package software.amazon.awscdk.services.greengrass;

/**
 * The <code>AWS::Greengrass::ResourceDefinitionVersion</code> resource represents a resource definition version for AWS IoT Greengrass .
 * <p>
 * A resource definition version contains a list of resources. (In AWS CloudFormation , resources are named <em>resource instances</em> .)
 * <p>
 * <blockquote>
 * <p>
 * To create a resource definition version, you must specify the ID of the resource definition that you want to associate with the version. For information about creating a resource definition, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html"><code>AWS::Greengrass::ResourceDefinition</code></a> .
 * <p>
 * After you create a resource definition version that contains the resources you want to deploy, you must add it to your group version. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html"><code>AWS::Greengrass::Group</code></a> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * CfnResourceDefinitionVersion cfnResourceDefinitionVersion = CfnResourceDefinitionVersion.Builder.create(this, "MyCfnResourceDefinitionVersion")
 *         .resourceDefinitionId("resourceDefinitionId")
 *         .resources(List.of(ResourceInstanceProperty.builder()
 *                 .id("id")
 *                 .name("name")
 *                 .resourceDataContainer(ResourceDataContainerProperty.builder()
 *                         .localDeviceResourceData(LocalDeviceResourceDataProperty.builder()
 *                                 .sourcePath("sourcePath")
 *                                 // the properties below are optional
 *                                 .groupOwnerSetting(GroupOwnerSettingProperty.builder()
 *                                         .autoAddGroupOwner(false)
 *                                         // the properties below are optional
 *                                         .groupOwner("groupOwner")
 *                                         .build())
 *                                 .build())
 *                         .localVolumeResourceData(LocalVolumeResourceDataProperty.builder()
 *                                 .destinationPath("destinationPath")
 *                                 .sourcePath("sourcePath")
 *                                 // the properties below are optional
 *                                 .groupOwnerSetting(GroupOwnerSettingProperty.builder()
 *                                         .autoAddGroupOwner(false)
 *                                         // the properties below are optional
 *                                         .groupOwner("groupOwner")
 *                                         .build())
 *                                 .build())
 *                         .s3MachineLearningModelResourceData(S3MachineLearningModelResourceDataProperty.builder()
 *                                 .destinationPath("destinationPath")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .ownerSetting(ResourceDownloadOwnerSettingProperty.builder()
 *                                         .groupOwner("groupOwner")
 *                                         .groupPermission("groupPermission")
 *                                         .build())
 *                                 .build())
 *                         .sageMakerMachineLearningModelResourceData(SageMakerMachineLearningModelResourceDataProperty.builder()
 *                                 .destinationPath("destinationPath")
 *                                 .sageMakerJobArn("sageMakerJobArn")
 *                                 // the properties below are optional
 *                                 .ownerSetting(ResourceDownloadOwnerSettingProperty.builder()
 *                                         .groupOwner("groupOwner")
 *                                         .groupPermission("groupPermission")
 *                                         .build())
 *                                 .build())
 *                         .secretsManagerSecretResourceData(SecretsManagerSecretResourceDataProperty.builder()
 *                                 .arn("arn")
 *                                 // the properties below are optional
 *                                 .additionalStagingLabelsToDownload(List.of("additionalStagingLabelsToDownload"))
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:08.104Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion")
public class CfnResourceDefinitionVersion extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnResourceDefinitionVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnResourceDefinitionVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnResourceDefinitionVersion(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ID of the resource definition associated with this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceDefinitionId() {
        return software.amazon.jsii.Kernel.get(this, "resourceDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the resource definition associated with this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceDefinitionId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceDefinitionId", java.util.Objects.requireNonNull(value, "resourceDefinitionId is required"));
    }

    /**
     * The resources in this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getResources() {
        return software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The resources in this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResources(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resources", java.util.Objects.requireNonNull(value, "resources is required"));
    }

    /**
     * The resources in this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResources(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion.ResourceInstanceProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion.ResourceInstanceProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "resources", java.util.Objects.requireNonNull(value, "resources is required"));
    }
    /**
     * Settings that define additional Linux OS group permissions to give to the Lambda function process.
     * <p>
     * You can give the permissions of the Linux group that owns the resource or choose another Linux group. These permissions are in addition to the function's <code>RunAs</code> permissions.
     * <p>
     * In an AWS CloudFormation template, <code>GroupOwnerSetting</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localdeviceresourcedata.html"><code>LocalDeviceResourceData</code></a> and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html"><code>LocalVolumeResourceData</code></a> property types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * GroupOwnerSettingProperty groupOwnerSettingProperty = GroupOwnerSettingProperty.builder()
     *         .autoAddGroupOwner(false)
     *         // the properties below are optional
     *         .groupOwner("groupOwner")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-groupownersetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-groupownersetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.GroupOwnerSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(GroupOwnerSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GroupOwnerSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether to give the privileges of the Linux group that owns the resource to the Lambda process.
         * <p>
         * This gives the Lambda process the file access permissions of the Linux group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-groupownersetting.html#cfn-greengrass-resourcedefinitionversion-groupownersetting-autoaddgroupowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-groupownersetting.html#cfn-greengrass-resourcedefinitionversion-groupownersetting-autoaddgroupowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAutoAddGroupOwner();

        /**
         * The name of the Linux group whose privileges you want to add to the Lambda process.
         * <p>
         * This value is ignored if <code>AutoAddGroupOwner</code> is true.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-groupownersetting.html#cfn-greengrass-resourcedefinitionversion-groupownersetting-groupowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-groupownersetting.html#cfn-greengrass-resourcedefinitionversion-groupownersetting-groupowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupOwner() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GroupOwnerSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GroupOwnerSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GroupOwnerSettingProperty> {
            java.lang.Object autoAddGroupOwner;
            java.lang.String groupOwner;

            /**
             * Sets the value of {@link GroupOwnerSettingProperty#getAutoAddGroupOwner}
             * @param autoAddGroupOwner Indicates whether to give the privileges of the Linux group that owns the resource to the Lambda process. This parameter is required.
             *                          This gives the Lambda process the file access permissions of the Linux group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoAddGroupOwner(java.lang.Boolean autoAddGroupOwner) {
                this.autoAddGroupOwner = autoAddGroupOwner;
                return this;
            }

            /**
             * Sets the value of {@link GroupOwnerSettingProperty#getAutoAddGroupOwner}
             * @param autoAddGroupOwner Indicates whether to give the privileges of the Linux group that owns the resource to the Lambda process. This parameter is required.
             *                          This gives the Lambda process the file access permissions of the Linux group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoAddGroupOwner(software.amazon.awscdk.IResolvable autoAddGroupOwner) {
                this.autoAddGroupOwner = autoAddGroupOwner;
                return this;
            }

            /**
             * Sets the value of {@link GroupOwnerSettingProperty#getGroupOwner}
             * @param groupOwner The name of the Linux group whose privileges you want to add to the Lambda process.
             *                   This value is ignored if <code>AutoAddGroupOwner</code> is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupOwner(java.lang.String groupOwner) {
                this.groupOwner = groupOwner;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GroupOwnerSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GroupOwnerSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GroupOwnerSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GroupOwnerSettingProperty {
            private final java.lang.Object autoAddGroupOwner;
            private final java.lang.String groupOwner;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoAddGroupOwner = software.amazon.jsii.Kernel.get(this, "autoAddGroupOwner", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.groupOwner = software.amazon.jsii.Kernel.get(this, "groupOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoAddGroupOwner = java.util.Objects.requireNonNull(builder.autoAddGroupOwner, "autoAddGroupOwner is required");
                this.groupOwner = builder.groupOwner;
            }

            @Override
            public final java.lang.Object getAutoAddGroupOwner() {
                return this.autoAddGroupOwner;
            }

            @Override
            public final java.lang.String getGroupOwner() {
                return this.groupOwner;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("autoAddGroupOwner", om.valueToTree(this.getAutoAddGroupOwner()));
                if (this.getGroupOwner() != null) {
                    data.set("groupOwner", om.valueToTree(this.getGroupOwner()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.GroupOwnerSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GroupOwnerSettingProperty.Jsii$Proxy that = (GroupOwnerSettingProperty.Jsii$Proxy) o;

                if (!autoAddGroupOwner.equals(that.autoAddGroupOwner)) return false;
                return this.groupOwner != null ? this.groupOwner.equals(that.groupOwner) : that.groupOwner == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoAddGroupOwner.hashCode();
                result = 31 * result + (this.groupOwner != null ? this.groupOwner.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings for a local device resource, which represents a file under <code>/dev</code> .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/access-local-resources.html">Access Local Resources with Lambda Functions</a> in the <em>Developer Guide</em> .
     * <p>
     * In an AWS CloudFormation template, <code>LocalDeviceResourceData</code> can be used in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html"><code>ResourceDataContainer</code></a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * LocalDeviceResourceDataProperty localDeviceResourceDataProperty = LocalDeviceResourceDataProperty.builder()
     *         .sourcePath("sourcePath")
     *         // the properties below are optional
     *         .groupOwnerSetting(GroupOwnerSettingProperty.builder()
     *                 .autoAddGroupOwner(false)
     *                 // the properties below are optional
     *                 .groupOwner("groupOwner")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localdeviceresourcedata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localdeviceresourcedata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.LocalDeviceResourceDataProperty")
    @software.amazon.jsii.Jsii.Proxy(LocalDeviceResourceDataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LocalDeviceResourceDataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The local absolute path of the device resource.
         * <p>
         * The source path for a device resource can refer only to a character device or block device under <code>/dev</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localdeviceresourcedata.html#cfn-greengrass-resourcedefinitionversion-localdeviceresourcedata-sourcepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localdeviceresourcedata.html#cfn-greengrass-resourcedefinitionversion-localdeviceresourcedata-sourcepath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourcePath();

        /**
         * Settings that define additional Linux OS group permissions to give to the Lambda function process.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localdeviceresourcedata.html#cfn-greengrass-resourcedefinitionversion-localdeviceresourcedata-groupownersetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localdeviceresourcedata.html#cfn-greengrass-resourcedefinitionversion-localdeviceresourcedata-groupownersetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGroupOwnerSetting() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LocalDeviceResourceDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocalDeviceResourceDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LocalDeviceResourceDataProperty> {
            java.lang.String sourcePath;
            java.lang.Object groupOwnerSetting;

            /**
             * Sets the value of {@link LocalDeviceResourceDataProperty#getSourcePath}
             * @param sourcePath The local absolute path of the device resource. This parameter is required.
             *                   The source path for a device resource can refer only to a character device or block device under <code>/dev</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePath(java.lang.String sourcePath) {
                this.sourcePath = sourcePath;
                return this;
            }

            /**
             * Sets the value of {@link LocalDeviceResourceDataProperty#getGroupOwnerSetting}
             * @param groupOwnerSetting Settings that define additional Linux OS group permissions to give to the Lambda function process.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupOwnerSetting(software.amazon.awscdk.IResolvable groupOwnerSetting) {
                this.groupOwnerSetting = groupOwnerSetting;
                return this;
            }

            /**
             * Sets the value of {@link LocalDeviceResourceDataProperty#getGroupOwnerSetting}
             * @param groupOwnerSetting Settings that define additional Linux OS group permissions to give to the Lambda function process.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupOwnerSetting(software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion.GroupOwnerSettingProperty groupOwnerSetting) {
                this.groupOwnerSetting = groupOwnerSetting;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocalDeviceResourceDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LocalDeviceResourceDataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LocalDeviceResourceDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocalDeviceResourceDataProperty {
            private final java.lang.String sourcePath;
            private final java.lang.Object groupOwnerSetting;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourcePath = software.amazon.jsii.Kernel.get(this, "sourcePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupOwnerSetting = software.amazon.jsii.Kernel.get(this, "groupOwnerSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourcePath = java.util.Objects.requireNonNull(builder.sourcePath, "sourcePath is required");
                this.groupOwnerSetting = builder.groupOwnerSetting;
            }

            @Override
            public final java.lang.String getSourcePath() {
                return this.sourcePath;
            }

            @Override
            public final java.lang.Object getGroupOwnerSetting() {
                return this.groupOwnerSetting;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourcePath", om.valueToTree(this.getSourcePath()));
                if (this.getGroupOwnerSetting() != null) {
                    data.set("groupOwnerSetting", om.valueToTree(this.getGroupOwnerSetting()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.LocalDeviceResourceDataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocalDeviceResourceDataProperty.Jsii$Proxy that = (LocalDeviceResourceDataProperty.Jsii$Proxy) o;

                if (!sourcePath.equals(that.sourcePath)) return false;
                return this.groupOwnerSetting != null ? this.groupOwnerSetting.equals(that.groupOwnerSetting) : that.groupOwnerSetting == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourcePath.hashCode();
                result = 31 * result + (this.groupOwnerSetting != null ? this.groupOwnerSetting.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings for a local volume resource, which represents a file or directory on the root file system.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/access-local-resources.html">Access Local Resources with Lambda Functions</a> in the <em>Developer Guide</em> .
     * <p>
     * In an AWS CloudFormation template, <code>LocalVolumeResourceData</code> can be used in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html"><code>ResourceDataContainer</code></a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * LocalVolumeResourceDataProperty localVolumeResourceDataProperty = LocalVolumeResourceDataProperty.builder()
     *         .destinationPath("destinationPath")
     *         .sourcePath("sourcePath")
     *         // the properties below are optional
     *         .groupOwnerSetting(GroupOwnerSettingProperty.builder()
     *                 .autoAddGroupOwner(false)
     *                 // the properties below are optional
     *                 .groupOwner("groupOwner")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.LocalVolumeResourceDataProperty")
    @software.amazon.jsii.Jsii.Proxy(LocalVolumeResourceDataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LocalVolumeResourceDataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The absolute local path of the resource in the Lambda environment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html#cfn-greengrass-resourcedefinitionversion-localvolumeresourcedata-destinationpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html#cfn-greengrass-resourcedefinitionversion-localvolumeresourcedata-destinationpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationPath();

        /**
         * The local absolute path of the volume resource on the host.
         * <p>
         * The source path for a volume resource type cannot start with <code>/sys</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html#cfn-greengrass-resourcedefinitionversion-localvolumeresourcedata-sourcepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html#cfn-greengrass-resourcedefinitionversion-localvolumeresourcedata-sourcepath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourcePath();

        /**
         * Settings that define additional Linux OS group permissions to give to the Lambda function process.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html#cfn-greengrass-resourcedefinitionversion-localvolumeresourcedata-groupownersetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html#cfn-greengrass-resourcedefinitionversion-localvolumeresourcedata-groupownersetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGroupOwnerSetting() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LocalVolumeResourceDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocalVolumeResourceDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LocalVolumeResourceDataProperty> {
            java.lang.String destinationPath;
            java.lang.String sourcePath;
            java.lang.Object groupOwnerSetting;

            /**
             * Sets the value of {@link LocalVolumeResourceDataProperty#getDestinationPath}
             * @param destinationPath The absolute local path of the resource in the Lambda environment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPath(java.lang.String destinationPath) {
                this.destinationPath = destinationPath;
                return this;
            }

            /**
             * Sets the value of {@link LocalVolumeResourceDataProperty#getSourcePath}
             * @param sourcePath The local absolute path of the volume resource on the host. This parameter is required.
             *                   The source path for a volume resource type cannot start with <code>/sys</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePath(java.lang.String sourcePath) {
                this.sourcePath = sourcePath;
                return this;
            }

            /**
             * Sets the value of {@link LocalVolumeResourceDataProperty#getGroupOwnerSetting}
             * @param groupOwnerSetting Settings that define additional Linux OS group permissions to give to the Lambda function process.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupOwnerSetting(software.amazon.awscdk.IResolvable groupOwnerSetting) {
                this.groupOwnerSetting = groupOwnerSetting;
                return this;
            }

            /**
             * Sets the value of {@link LocalVolumeResourceDataProperty#getGroupOwnerSetting}
             * @param groupOwnerSetting Settings that define additional Linux OS group permissions to give to the Lambda function process.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupOwnerSetting(software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion.GroupOwnerSettingProperty groupOwnerSetting) {
                this.groupOwnerSetting = groupOwnerSetting;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocalVolumeResourceDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LocalVolumeResourceDataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LocalVolumeResourceDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocalVolumeResourceDataProperty {
            private final java.lang.String destinationPath;
            private final java.lang.String sourcePath;
            private final java.lang.Object groupOwnerSetting;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationPath = software.amazon.jsii.Kernel.get(this, "destinationPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourcePath = software.amazon.jsii.Kernel.get(this, "sourcePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupOwnerSetting = software.amazon.jsii.Kernel.get(this, "groupOwnerSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationPath = java.util.Objects.requireNonNull(builder.destinationPath, "destinationPath is required");
                this.sourcePath = java.util.Objects.requireNonNull(builder.sourcePath, "sourcePath is required");
                this.groupOwnerSetting = builder.groupOwnerSetting;
            }

            @Override
            public final java.lang.String getDestinationPath() {
                return this.destinationPath;
            }

            @Override
            public final java.lang.String getSourcePath() {
                return this.sourcePath;
            }

            @Override
            public final java.lang.Object getGroupOwnerSetting() {
                return this.groupOwnerSetting;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationPath", om.valueToTree(this.getDestinationPath()));
                data.set("sourcePath", om.valueToTree(this.getSourcePath()));
                if (this.getGroupOwnerSetting() != null) {
                    data.set("groupOwnerSetting", om.valueToTree(this.getGroupOwnerSetting()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.LocalVolumeResourceDataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocalVolumeResourceDataProperty.Jsii$Proxy that = (LocalVolumeResourceDataProperty.Jsii$Proxy) o;

                if (!destinationPath.equals(that.destinationPath)) return false;
                if (!sourcePath.equals(that.sourcePath)) return false;
                return this.groupOwnerSetting != null ? this.groupOwnerSetting.equals(that.groupOwnerSetting) : that.groupOwnerSetting == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationPath.hashCode();
                result = 31 * result + (this.sourcePath.hashCode());
                result = 31 * result + (this.groupOwnerSetting != null ? this.groupOwnerSetting.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A container for resource data, which defines the resource type.
     * <p>
     * The container takes only one of the following supported resource data types: <code>LocalDeviceResourceData</code> , <code>LocalVolumeResourceData</code> , <code>SageMakerMachineLearningModelResourceData</code> , <code>S3MachineLearningModelResourceData</code> , or <code>SecretsManagerSecretResourceData</code> .
     * <p>
     * <blockquote>
     * <p>
     * Only one resource type can be defined for a <code>ResourceDataContainer</code> instance.
     * <p>
     * </blockquote>
     * <p>
     * In an AWS CloudFormation template, <code>ResourceDataContainer</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html"><code>ResourceInstance</code></a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * ResourceDataContainerProperty resourceDataContainerProperty = ResourceDataContainerProperty.builder()
     *         .localDeviceResourceData(LocalDeviceResourceDataProperty.builder()
     *                 .sourcePath("sourcePath")
     *                 // the properties below are optional
     *                 .groupOwnerSetting(GroupOwnerSettingProperty.builder()
     *                         .autoAddGroupOwner(false)
     *                         // the properties below are optional
     *                         .groupOwner("groupOwner")
     *                         .build())
     *                 .build())
     *         .localVolumeResourceData(LocalVolumeResourceDataProperty.builder()
     *                 .destinationPath("destinationPath")
     *                 .sourcePath("sourcePath")
     *                 // the properties below are optional
     *                 .groupOwnerSetting(GroupOwnerSettingProperty.builder()
     *                         .autoAddGroupOwner(false)
     *                         // the properties below are optional
     *                         .groupOwner("groupOwner")
     *                         .build())
     *                 .build())
     *         .s3MachineLearningModelResourceData(S3MachineLearningModelResourceDataProperty.builder()
     *                 .destinationPath("destinationPath")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .ownerSetting(ResourceDownloadOwnerSettingProperty.builder()
     *                         .groupOwner("groupOwner")
     *                         .groupPermission("groupPermission")
     *                         .build())
     *                 .build())
     *         .sageMakerMachineLearningModelResourceData(SageMakerMachineLearningModelResourceDataProperty.builder()
     *                 .destinationPath("destinationPath")
     *                 .sageMakerJobArn("sageMakerJobArn")
     *                 // the properties below are optional
     *                 .ownerSetting(ResourceDownloadOwnerSettingProperty.builder()
     *                         .groupOwner("groupOwner")
     *                         .groupPermission("groupPermission")
     *                         .build())
     *                 .build())
     *         .secretsManagerSecretResourceData(SecretsManagerSecretResourceDataProperty.builder()
     *                 .arn("arn")
     *                 // the properties below are optional
     *                 .additionalStagingLabelsToDownload(List.of("additionalStagingLabelsToDownload"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.ResourceDataContainerProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceDataContainerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceDataContainerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings for a local device resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-localdeviceresourcedata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-localdeviceresourcedata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLocalDeviceResourceData() {
            return null;
        }

        /**
         * Settings for a local volume resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-localvolumeresourcedata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-localvolumeresourcedata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLocalVolumeResourceData() {
            return null;
        }

        /**
         * Settings for a machine learning resource stored in Amazon S3 .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-s3machinelearningmodelresourcedata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-s3machinelearningmodelresourcedata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3MachineLearningModelResourceData() {
            return null;
        }

        /**
         * Settings for a machine learning resource saved as an SageMaker AI training job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-sagemakermachinelearningmodelresourcedata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-sagemakermachinelearningmodelresourcedata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSageMakerMachineLearningModelResourceData() {
            return null;
        }

        /**
         * Settings for a secret resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-secretsmanagersecretresourcedata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-secretsmanagersecretresourcedata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecretsManagerSecretResourceData() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceDataContainerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceDataContainerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceDataContainerProperty> {
            java.lang.Object localDeviceResourceData;
            java.lang.Object localVolumeResourceData;
            java.lang.Object s3MachineLearningModelResourceData;
            java.lang.Object sageMakerMachineLearningModelResourceData;
            java.lang.Object secretsManagerSecretResourceData;

            /**
             * Sets the value of {@link ResourceDataContainerProperty#getLocalDeviceResourceData}
             * @param localDeviceResourceData Settings for a local device resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localDeviceResourceData(software.amazon.awscdk.IResolvable localDeviceResourceData) {
                this.localDeviceResourceData = localDeviceResourceData;
                return this;
            }

            /**
             * Sets the value of {@link ResourceDataContainerProperty#getLocalDeviceResourceData}
             * @param localDeviceResourceData Settings for a local device resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localDeviceResourceData(software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion.LocalDeviceResourceDataProperty localDeviceResourceData) {
                this.localDeviceResourceData = localDeviceResourceData;
                return this;
            }

            /**
             * Sets the value of {@link ResourceDataContainerProperty#getLocalVolumeResourceData}
             * @param localVolumeResourceData Settings for a local volume resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localVolumeResourceData(software.amazon.awscdk.IResolvable localVolumeResourceData) {
                this.localVolumeResourceData = localVolumeResourceData;
                return this;
            }

            /**
             * Sets the value of {@link ResourceDataContainerProperty#getLocalVolumeResourceData}
             * @param localVolumeResourceData Settings for a local volume resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localVolumeResourceData(software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion.LocalVolumeResourceDataProperty localVolumeResourceData) {
                this.localVolumeResourceData = localVolumeResourceData;
                return this;
            }

            /**
             * Sets the value of {@link ResourceDataContainerProperty#getS3MachineLearningModelResourceData}
             * @param s3MachineLearningModelResourceData Settings for a machine learning resource stored in Amazon S3 .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3MachineLearningModelResourceData(software.amazon.awscdk.IResolvable s3MachineLearningModelResourceData) {
                this.s3MachineLearningModelResourceData = s3MachineLearningModelResourceData;
                return this;
            }

            /**
             * Sets the value of {@link ResourceDataContainerProperty#getS3MachineLearningModelResourceData}
             * @param s3MachineLearningModelResourceData Settings for a machine learning resource stored in Amazon S3 .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3MachineLearningModelResourceData(software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion.S3MachineLearningModelResourceDataProperty s3MachineLearningModelResourceData) {
                this.s3MachineLearningModelResourceData = s3MachineLearningModelResourceData;
                return this;
            }

            /**
             * Sets the value of {@link ResourceDataContainerProperty#getSageMakerMachineLearningModelResourceData}
             * @param sageMakerMachineLearningModelResourceData Settings for a machine learning resource saved as an SageMaker AI training job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerMachineLearningModelResourceData(software.amazon.awscdk.IResolvable sageMakerMachineLearningModelResourceData) {
                this.sageMakerMachineLearningModelResourceData = sageMakerMachineLearningModelResourceData;
                return this;
            }

            /**
             * Sets the value of {@link ResourceDataContainerProperty#getSageMakerMachineLearningModelResourceData}
             * @param sageMakerMachineLearningModelResourceData Settings for a machine learning resource saved as an SageMaker AI training job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerMachineLearningModelResourceData(software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion.SageMakerMachineLearningModelResourceDataProperty sageMakerMachineLearningModelResourceData) {
                this.sageMakerMachineLearningModelResourceData = sageMakerMachineLearningModelResourceData;
                return this;
            }

            /**
             * Sets the value of {@link ResourceDataContainerProperty#getSecretsManagerSecretResourceData}
             * @param secretsManagerSecretResourceData Settings for a secret resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretResourceData(software.amazon.awscdk.IResolvable secretsManagerSecretResourceData) {
                this.secretsManagerSecretResourceData = secretsManagerSecretResourceData;
                return this;
            }

            /**
             * Sets the value of {@link ResourceDataContainerProperty#getSecretsManagerSecretResourceData}
             * @param secretsManagerSecretResourceData Settings for a secret resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerSecretResourceData(software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion.SecretsManagerSecretResourceDataProperty secretsManagerSecretResourceData) {
                this.secretsManagerSecretResourceData = secretsManagerSecretResourceData;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceDataContainerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceDataContainerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceDataContainerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceDataContainerProperty {
            private final java.lang.Object localDeviceResourceData;
            private final java.lang.Object localVolumeResourceData;
            private final java.lang.Object s3MachineLearningModelResourceData;
            private final java.lang.Object sageMakerMachineLearningModelResourceData;
            private final java.lang.Object secretsManagerSecretResourceData;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.localDeviceResourceData = software.amazon.jsii.Kernel.get(this, "localDeviceResourceData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.localVolumeResourceData = software.amazon.jsii.Kernel.get(this, "localVolumeResourceData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3MachineLearningModelResourceData = software.amazon.jsii.Kernel.get(this, "s3MachineLearningModelResourceData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sageMakerMachineLearningModelResourceData = software.amazon.jsii.Kernel.get(this, "sageMakerMachineLearningModelResourceData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secretsManagerSecretResourceData = software.amazon.jsii.Kernel.get(this, "secretsManagerSecretResourceData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.localDeviceResourceData = builder.localDeviceResourceData;
                this.localVolumeResourceData = builder.localVolumeResourceData;
                this.s3MachineLearningModelResourceData = builder.s3MachineLearningModelResourceData;
                this.sageMakerMachineLearningModelResourceData = builder.sageMakerMachineLearningModelResourceData;
                this.secretsManagerSecretResourceData = builder.secretsManagerSecretResourceData;
            }

            @Override
            public final java.lang.Object getLocalDeviceResourceData() {
                return this.localDeviceResourceData;
            }

            @Override
            public final java.lang.Object getLocalVolumeResourceData() {
                return this.localVolumeResourceData;
            }

            @Override
            public final java.lang.Object getS3MachineLearningModelResourceData() {
                return this.s3MachineLearningModelResourceData;
            }

            @Override
            public final java.lang.Object getSageMakerMachineLearningModelResourceData() {
                return this.sageMakerMachineLearningModelResourceData;
            }

            @Override
            public final java.lang.Object getSecretsManagerSecretResourceData() {
                return this.secretsManagerSecretResourceData;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLocalDeviceResourceData() != null) {
                    data.set("localDeviceResourceData", om.valueToTree(this.getLocalDeviceResourceData()));
                }
                if (this.getLocalVolumeResourceData() != null) {
                    data.set("localVolumeResourceData", om.valueToTree(this.getLocalVolumeResourceData()));
                }
                if (this.getS3MachineLearningModelResourceData() != null) {
                    data.set("s3MachineLearningModelResourceData", om.valueToTree(this.getS3MachineLearningModelResourceData()));
                }
                if (this.getSageMakerMachineLearningModelResourceData() != null) {
                    data.set("sageMakerMachineLearningModelResourceData", om.valueToTree(this.getSageMakerMachineLearningModelResourceData()));
                }
                if (this.getSecretsManagerSecretResourceData() != null) {
                    data.set("secretsManagerSecretResourceData", om.valueToTree(this.getSecretsManagerSecretResourceData()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.ResourceDataContainerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceDataContainerProperty.Jsii$Proxy that = (ResourceDataContainerProperty.Jsii$Proxy) o;

                if (this.localDeviceResourceData != null ? !this.localDeviceResourceData.equals(that.localDeviceResourceData) : that.localDeviceResourceData != null) return false;
                if (this.localVolumeResourceData != null ? !this.localVolumeResourceData.equals(that.localVolumeResourceData) : that.localVolumeResourceData != null) return false;
                if (this.s3MachineLearningModelResourceData != null ? !this.s3MachineLearningModelResourceData.equals(that.s3MachineLearningModelResourceData) : that.s3MachineLearningModelResourceData != null) return false;
                if (this.sageMakerMachineLearningModelResourceData != null ? !this.sageMakerMachineLearningModelResourceData.equals(that.sageMakerMachineLearningModelResourceData) : that.sageMakerMachineLearningModelResourceData != null) return false;
                return this.secretsManagerSecretResourceData != null ? this.secretsManagerSecretResourceData.equals(that.secretsManagerSecretResourceData) : that.secretsManagerSecretResourceData == null;
            }

            @Override
            public final int hashCode() {
                int result = this.localDeviceResourceData != null ? this.localDeviceResourceData.hashCode() : 0;
                result = 31 * result + (this.localVolumeResourceData != null ? this.localVolumeResourceData.hashCode() : 0);
                result = 31 * result + (this.s3MachineLearningModelResourceData != null ? this.s3MachineLearningModelResourceData.hashCode() : 0);
                result = 31 * result + (this.sageMakerMachineLearningModelResourceData != null ? this.sageMakerMachineLearningModelResourceData.hashCode() : 0);
                result = 31 * result + (this.secretsManagerSecretResourceData != null ? this.secretsManagerSecretResourceData.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The owner setting for a downloaded machine learning resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/access-ml-resources.html">Access Machine Learning Resources from Lambda Functions</a> in the <em>Developer Guide</em> .
     * <p>
     * In an AWS CloudFormation template, <code>ResourceDownloadOwnerSetting</code> is the property type of the <code>OwnerSetting</code> property for the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html"><code>S3MachineLearningModelResourceData</code></a> and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html"><code>SageMakerMachineLearningModelResourceData</code></a> property types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * ResourceDownloadOwnerSettingProperty resourceDownloadOwnerSettingProperty = ResourceDownloadOwnerSettingProperty.builder()
     *         .groupOwner("groupOwner")
     *         .groupPermission("groupPermission")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedownloadownersetting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedownloadownersetting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.ResourceDownloadOwnerSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceDownloadOwnerSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceDownloadOwnerSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The group owner of the machine learning resource.
         * <p>
         * This is the group ID (GID) of an existing Linux OS group on the system. The group's permissions are added to the Lambda process.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedownloadownersetting.html#cfn-greengrass-resourcedefinitionversion-resourcedownloadownersetting-groupowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedownloadownersetting.html#cfn-greengrass-resourcedefinitionversion-resourcedownloadownersetting-groupowner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGroupOwner();

        /**
         * The permissions that the group owner has to the machine learning resource.
         * <p>
         * Valid values are <code>rw</code> (read-write) or <code>ro</code> (read-only).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedownloadownersetting.html#cfn-greengrass-resourcedefinitionversion-resourcedownloadownersetting-grouppermission">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedownloadownersetting.html#cfn-greengrass-resourcedefinitionversion-resourcedownloadownersetting-grouppermission</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGroupPermission();

        /**
         * @return a {@link Builder} of {@link ResourceDownloadOwnerSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceDownloadOwnerSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceDownloadOwnerSettingProperty> {
            java.lang.String groupOwner;
            java.lang.String groupPermission;

            /**
             * Sets the value of {@link ResourceDownloadOwnerSettingProperty#getGroupOwner}
             * @param groupOwner The group owner of the machine learning resource. This parameter is required.
             *                   This is the group ID (GID) of an existing Linux OS group on the system. The group's permissions are added to the Lambda process.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupOwner(java.lang.String groupOwner) {
                this.groupOwner = groupOwner;
                return this;
            }

            /**
             * Sets the value of {@link ResourceDownloadOwnerSettingProperty#getGroupPermission}
             * @param groupPermission The permissions that the group owner has to the machine learning resource. This parameter is required.
             *                        Valid values are <code>rw</code> (read-write) or <code>ro</code> (read-only).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupPermission(java.lang.String groupPermission) {
                this.groupPermission = groupPermission;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceDownloadOwnerSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceDownloadOwnerSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceDownloadOwnerSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceDownloadOwnerSettingProperty {
            private final java.lang.String groupOwner;
            private final java.lang.String groupPermission;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupOwner = software.amazon.jsii.Kernel.get(this, "groupOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groupPermission = software.amazon.jsii.Kernel.get(this, "groupPermission", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupOwner = java.util.Objects.requireNonNull(builder.groupOwner, "groupOwner is required");
                this.groupPermission = java.util.Objects.requireNonNull(builder.groupPermission, "groupPermission is required");
            }

            @Override
            public final java.lang.String getGroupOwner() {
                return this.groupOwner;
            }

            @Override
            public final java.lang.String getGroupPermission() {
                return this.groupPermission;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("groupOwner", om.valueToTree(this.getGroupOwner()));
                data.set("groupPermission", om.valueToTree(this.getGroupPermission()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.ResourceDownloadOwnerSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceDownloadOwnerSettingProperty.Jsii$Proxy that = (ResourceDownloadOwnerSettingProperty.Jsii$Proxy) o;

                if (!groupOwner.equals(that.groupOwner)) return false;
                return this.groupPermission.equals(that.groupPermission);
            }

            @Override
            public final int hashCode() {
                int result = this.groupOwner.hashCode();
                result = 31 * result + (this.groupPermission.hashCode());
                return result;
            }
        }
    }
    /**
     * A local resource, machine learning resource, or secret resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/access-local-resources.html">Access Local Resources with Lambda Functions</a> , <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/ml-inference.html">Perform Machine Learning Inference</a> , and <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/secrets.html">Deploy Secrets to the AWS IoT Greengrass Core</a> in the <em>Developer Guide</em> .
     * <p>
     * In an AWS CloudFormation template, the <code>Resources</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html"><code>AWS::Greengrass::ResourceDefinitionVersion</code></a> resource contains a list of <code>ResourceInstance</code> property types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * ResourceInstanceProperty resourceInstanceProperty = ResourceInstanceProperty.builder()
     *         .id("id")
     *         .name("name")
     *         .resourceDataContainer(ResourceDataContainerProperty.builder()
     *                 .localDeviceResourceData(LocalDeviceResourceDataProperty.builder()
     *                         .sourcePath("sourcePath")
     *                         // the properties below are optional
     *                         .groupOwnerSetting(GroupOwnerSettingProperty.builder()
     *                                 .autoAddGroupOwner(false)
     *                                 // the properties below are optional
     *                                 .groupOwner("groupOwner")
     *                                 .build())
     *                         .build())
     *                 .localVolumeResourceData(LocalVolumeResourceDataProperty.builder()
     *                         .destinationPath("destinationPath")
     *                         .sourcePath("sourcePath")
     *                         // the properties below are optional
     *                         .groupOwnerSetting(GroupOwnerSettingProperty.builder()
     *                                 .autoAddGroupOwner(false)
     *                                 // the properties below are optional
     *                                 .groupOwner("groupOwner")
     *                                 .build())
     *                         .build())
     *                 .s3MachineLearningModelResourceData(S3MachineLearningModelResourceDataProperty.builder()
     *                         .destinationPath("destinationPath")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .ownerSetting(ResourceDownloadOwnerSettingProperty.builder()
     *                                 .groupOwner("groupOwner")
     *                                 .groupPermission("groupPermission")
     *                                 .build())
     *                         .build())
     *                 .sageMakerMachineLearningModelResourceData(SageMakerMachineLearningModelResourceDataProperty.builder()
     *                         .destinationPath("destinationPath")
     *                         .sageMakerJobArn("sageMakerJobArn")
     *                         // the properties below are optional
     *                         .ownerSetting(ResourceDownloadOwnerSettingProperty.builder()
     *                                 .groupOwner("groupOwner")
     *                                 .groupPermission("groupPermission")
     *                                 .build())
     *                         .build())
     *                 .secretsManagerSecretResourceData(SecretsManagerSecretResourceDataProperty.builder()
     *                         .arn("arn")
     *                         // the properties below are optional
     *                         .additionalStagingLabelsToDownload(List.of("additionalStagingLabelsToDownload"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.ResourceInstanceProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceInstanceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceInstanceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A descriptive or arbitrary ID for the resource.
         * <p>
         * This value must be unique within the resource definition version. Maximum length is 128 characters with pattern <code>[a-zA-Z0-9:_-]+</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html#cfn-greengrass-resourcedefinitionversion-resourceinstance-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html#cfn-greengrass-resourcedefinitionversion-resourceinstance-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The descriptive resource name, which is displayed on the AWS IoT Greengrass console.
         * <p>
         * Maximum length 128 characters with pattern [a-zA-Z0-9:_-]+. This must be unique within a Greengrass group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html#cfn-greengrass-resourcedefinitionversion-resourceinstance-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html#cfn-greengrass-resourcedefinitionversion-resourceinstance-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * A container for resource data.
         * <p>
         * The container takes only one of the following supported resource data types: <code>LocalDeviceResourceData</code> , <code>LocalVolumeResourceData</code> , <code>SageMakerMachineLearningModelResourceData</code> , <code>S3MachineLearningModelResourceData</code> , or <code>SecretsManagerSecretResourceData</code> .
         * <p>
         * <blockquote>
         * <p>
         * Only one resource type can be defined for a <code>ResourceDataContainer</code> instance.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html#cfn-greengrass-resourcedefinitionversion-resourceinstance-resourcedatacontainer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html#cfn-greengrass-resourcedefinitionversion-resourceinstance-resourcedatacontainer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getResourceDataContainer();

        /**
         * @return a {@link Builder} of {@link ResourceInstanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceInstanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceInstanceProperty> {
            java.lang.String id;
            java.lang.String name;
            java.lang.Object resourceDataContainer;

            /**
             * Sets the value of {@link ResourceInstanceProperty#getId}
             * @param id A descriptive or arbitrary ID for the resource. This parameter is required.
             *           This value must be unique within the resource definition version. Maximum length is 128 characters with pattern <code>[a-zA-Z0-9:_-]+</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link ResourceInstanceProperty#getName}
             * @param name The descriptive resource name, which is displayed on the AWS IoT Greengrass console. This parameter is required.
             *             Maximum length 128 characters with pattern [a-zA-Z0-9:_-]+. This must be unique within a Greengrass group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ResourceInstanceProperty#getResourceDataContainer}
             * @param resourceDataContainer A container for resource data. This parameter is required.
             *                              The container takes only one of the following supported resource data types: <code>LocalDeviceResourceData</code> , <code>LocalVolumeResourceData</code> , <code>SageMakerMachineLearningModelResourceData</code> , <code>S3MachineLearningModelResourceData</code> , or <code>SecretsManagerSecretResourceData</code> .
             *                              <p>
             *                              <blockquote>
             *                              <p>
             *                              Only one resource type can be defined for a <code>ResourceDataContainer</code> instance.
             *                              <p>
             *                              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceDataContainer(software.amazon.awscdk.IResolvable resourceDataContainer) {
                this.resourceDataContainer = resourceDataContainer;
                return this;
            }

            /**
             * Sets the value of {@link ResourceInstanceProperty#getResourceDataContainer}
             * @param resourceDataContainer A container for resource data. This parameter is required.
             *                              The container takes only one of the following supported resource data types: <code>LocalDeviceResourceData</code> , <code>LocalVolumeResourceData</code> , <code>SageMakerMachineLearningModelResourceData</code> , <code>S3MachineLearningModelResourceData</code> , or <code>SecretsManagerSecretResourceData</code> .
             *                              <p>
             *                              <blockquote>
             *                              <p>
             *                              Only one resource type can be defined for a <code>ResourceDataContainer</code> instance.
             *                              <p>
             *                              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceDataContainer(software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion.ResourceDataContainerProperty resourceDataContainer) {
                this.resourceDataContainer = resourceDataContainer;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceInstanceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceInstanceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceInstanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceInstanceProperty {
            private final java.lang.String id;
            private final java.lang.String name;
            private final java.lang.Object resourceDataContainer;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceDataContainer = software.amazon.jsii.Kernel.get(this, "resourceDataContainer", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.resourceDataContainer = java.util.Objects.requireNonNull(builder.resourceDataContainer, "resourceDataContainer is required");
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getResourceDataContainer() {
                return this.resourceDataContainer;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("resourceDataContainer", om.valueToTree(this.getResourceDataContainer()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.ResourceInstanceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceInstanceProperty.Jsii$Proxy that = (ResourceInstanceProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (!name.equals(that.name)) return false;
                return this.resourceDataContainer.equals(that.resourceDataContainer);
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.resourceDataContainer.hashCode());
                return result;
            }
        }
    }
    /**
     * Settings for an Amazon S3 machine learning resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/ml-inference.html">Perform Machine Learning Inference</a> in the <em>Developer Guide</em> .
     * <p>
     * In an AWS CloudFormation template, <code>S3MachineLearningModelResourceData</code> can be used in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html"><code>ResourceDataContainer</code></a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * S3MachineLearningModelResourceDataProperty s3MachineLearningModelResourceDataProperty = S3MachineLearningModelResourceDataProperty.builder()
     *         .destinationPath("destinationPath")
     *         .s3Uri("s3Uri")
     *         // the properties below are optional
     *         .ownerSetting(ResourceDownloadOwnerSettingProperty.builder()
     *                 .groupOwner("groupOwner")
     *                 .groupPermission("groupPermission")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.S3MachineLearningModelResourceDataProperty")
    @software.amazon.jsii.Jsii.Proxy(S3MachineLearningModelResourceDataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3MachineLearningModelResourceDataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The absolute local path of the resource inside the Lambda environment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata-destinationpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata-destinationpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationPath();

        /**
         * The URI of the source model in an Amazon S3 bucket.
         * <p>
         * The model package must be in <code>tar.gz</code> or <code>.zip</code> format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata-s3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata-s3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Uri();

        /**
         * The owner setting for the downloaded machine learning resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/access-ml-resources.html">Access Machine Learning Resources from Lambda Functions</a> in the <em>Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata-ownersetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata-ownersetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOwnerSetting() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3MachineLearningModelResourceDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3MachineLearningModelResourceDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3MachineLearningModelResourceDataProperty> {
            java.lang.String destinationPath;
            java.lang.String s3Uri;
            java.lang.Object ownerSetting;

            /**
             * Sets the value of {@link S3MachineLearningModelResourceDataProperty#getDestinationPath}
             * @param destinationPath The absolute local path of the resource inside the Lambda environment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPath(java.lang.String destinationPath) {
                this.destinationPath = destinationPath;
                return this;
            }

            /**
             * Sets the value of {@link S3MachineLearningModelResourceDataProperty#getS3Uri}
             * @param s3Uri The URI of the source model in an Amazon S3 bucket. This parameter is required.
             *              The model package must be in <code>tar.gz</code> or <code>.zip</code> format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Sets the value of {@link S3MachineLearningModelResourceDataProperty#getOwnerSetting}
             * @param ownerSetting The owner setting for the downloaded machine learning resource.
             *                     For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/access-ml-resources.html">Access Machine Learning Resources from Lambda Functions</a> in the <em>Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ownerSetting(software.amazon.awscdk.IResolvable ownerSetting) {
                this.ownerSetting = ownerSetting;
                return this;
            }

            /**
             * Sets the value of {@link S3MachineLearningModelResourceDataProperty#getOwnerSetting}
             * @param ownerSetting The owner setting for the downloaded machine learning resource.
             *                     For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/access-ml-resources.html">Access Machine Learning Resources from Lambda Functions</a> in the <em>Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ownerSetting(software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion.ResourceDownloadOwnerSettingProperty ownerSetting) {
                this.ownerSetting = ownerSetting;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3MachineLearningModelResourceDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3MachineLearningModelResourceDataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3MachineLearningModelResourceDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3MachineLearningModelResourceDataProperty {
            private final java.lang.String destinationPath;
            private final java.lang.String s3Uri;
            private final java.lang.Object ownerSetting;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationPath = software.amazon.jsii.Kernel.get(this, "destinationPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ownerSetting = software.amazon.jsii.Kernel.get(this, "ownerSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationPath = java.util.Objects.requireNonNull(builder.destinationPath, "destinationPath is required");
                this.s3Uri = java.util.Objects.requireNonNull(builder.s3Uri, "s3Uri is required");
                this.ownerSetting = builder.ownerSetting;
            }

            @Override
            public final java.lang.String getDestinationPath() {
                return this.destinationPath;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            public final java.lang.Object getOwnerSetting() {
                return this.ownerSetting;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationPath", om.valueToTree(this.getDestinationPath()));
                data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                if (this.getOwnerSetting() != null) {
                    data.set("ownerSetting", om.valueToTree(this.getOwnerSetting()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.S3MachineLearningModelResourceDataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3MachineLearningModelResourceDataProperty.Jsii$Proxy that = (S3MachineLearningModelResourceDataProperty.Jsii$Proxy) o;

                if (!destinationPath.equals(that.destinationPath)) return false;
                if (!s3Uri.equals(that.s3Uri)) return false;
                return this.ownerSetting != null ? this.ownerSetting.equals(that.ownerSetting) : that.ownerSetting == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationPath.hashCode();
                result = 31 * result + (this.s3Uri.hashCode());
                result = 31 * result + (this.ownerSetting != null ? this.ownerSetting.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings for an Secrets Manager machine learning resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/ml-inference.html">Perform Machine Learning Inference</a> in the <em>Developer Guide</em> .
     * <p>
     * In an AWS CloudFormation template, <code>SageMakerMachineLearningModelResourceData</code> can be used in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html"><code>ResourceDataContainer</code></a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * SageMakerMachineLearningModelResourceDataProperty sageMakerMachineLearningModelResourceDataProperty = SageMakerMachineLearningModelResourceDataProperty.builder()
     *         .destinationPath("destinationPath")
     *         .sageMakerJobArn("sageMakerJobArn")
     *         // the properties below are optional
     *         .ownerSetting(ResourceDownloadOwnerSettingProperty.builder()
     *                 .groupOwner("groupOwner")
     *                 .groupPermission("groupPermission")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.SageMakerMachineLearningModelResourceDataProperty")
    @software.amazon.jsii.Jsii.Proxy(SageMakerMachineLearningModelResourceDataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SageMakerMachineLearningModelResourceDataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The absolute local path of the resource inside the Lambda environment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata-destinationpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata-destinationpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationPath();

        /**
         * The Amazon Resource Name (ARN) of the Amazon SageMaker AI training job that represents the source model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata-sagemakerjobarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata-sagemakerjobarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSageMakerJobArn();

        /**
         * The owner setting for the downloaded machine learning resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/access-ml-resources.html">Access Machine Learning Resources from Lambda Functions</a> in the <em>Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata-ownersetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata-ownersetting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOwnerSetting() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SageMakerMachineLearningModelResourceDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SageMakerMachineLearningModelResourceDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SageMakerMachineLearningModelResourceDataProperty> {
            java.lang.String destinationPath;
            java.lang.String sageMakerJobArn;
            java.lang.Object ownerSetting;

            /**
             * Sets the value of {@link SageMakerMachineLearningModelResourceDataProperty#getDestinationPath}
             * @param destinationPath The absolute local path of the resource inside the Lambda environment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationPath(java.lang.String destinationPath) {
                this.destinationPath = destinationPath;
                return this;
            }

            /**
             * Sets the value of {@link SageMakerMachineLearningModelResourceDataProperty#getSageMakerJobArn}
             * @param sageMakerJobArn The Amazon Resource Name (ARN) of the Amazon SageMaker AI training job that represents the source model. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sageMakerJobArn(java.lang.String sageMakerJobArn) {
                this.sageMakerJobArn = sageMakerJobArn;
                return this;
            }

            /**
             * Sets the value of {@link SageMakerMachineLearningModelResourceDataProperty#getOwnerSetting}
             * @param ownerSetting The owner setting for the downloaded machine learning resource.
             *                     For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/access-ml-resources.html">Access Machine Learning Resources from Lambda Functions</a> in the <em>Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ownerSetting(software.amazon.awscdk.IResolvable ownerSetting) {
                this.ownerSetting = ownerSetting;
                return this;
            }

            /**
             * Sets the value of {@link SageMakerMachineLearningModelResourceDataProperty#getOwnerSetting}
             * @param ownerSetting The owner setting for the downloaded machine learning resource.
             *                     For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/access-ml-resources.html">Access Machine Learning Resources from Lambda Functions</a> in the <em>Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ownerSetting(software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion.ResourceDownloadOwnerSettingProperty ownerSetting) {
                this.ownerSetting = ownerSetting;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SageMakerMachineLearningModelResourceDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SageMakerMachineLearningModelResourceDataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SageMakerMachineLearningModelResourceDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SageMakerMachineLearningModelResourceDataProperty {
            private final java.lang.String destinationPath;
            private final java.lang.String sageMakerJobArn;
            private final java.lang.Object ownerSetting;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationPath = software.amazon.jsii.Kernel.get(this, "destinationPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sageMakerJobArn = software.amazon.jsii.Kernel.get(this, "sageMakerJobArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ownerSetting = software.amazon.jsii.Kernel.get(this, "ownerSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationPath = java.util.Objects.requireNonNull(builder.destinationPath, "destinationPath is required");
                this.sageMakerJobArn = java.util.Objects.requireNonNull(builder.sageMakerJobArn, "sageMakerJobArn is required");
                this.ownerSetting = builder.ownerSetting;
            }

            @Override
            public final java.lang.String getDestinationPath() {
                return this.destinationPath;
            }

            @Override
            public final java.lang.String getSageMakerJobArn() {
                return this.sageMakerJobArn;
            }

            @Override
            public final java.lang.Object getOwnerSetting() {
                return this.ownerSetting;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationPath", om.valueToTree(this.getDestinationPath()));
                data.set("sageMakerJobArn", om.valueToTree(this.getSageMakerJobArn()));
                if (this.getOwnerSetting() != null) {
                    data.set("ownerSetting", om.valueToTree(this.getOwnerSetting()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.SageMakerMachineLearningModelResourceDataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SageMakerMachineLearningModelResourceDataProperty.Jsii$Proxy that = (SageMakerMachineLearningModelResourceDataProperty.Jsii$Proxy) o;

                if (!destinationPath.equals(that.destinationPath)) return false;
                if (!sageMakerJobArn.equals(that.sageMakerJobArn)) return false;
                return this.ownerSetting != null ? this.ownerSetting.equals(that.ownerSetting) : that.ownerSetting == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationPath.hashCode();
                result = 31 * result + (this.sageMakerJobArn.hashCode());
                result = 31 * result + (this.ownerSetting != null ? this.ownerSetting.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings for a secret resource, which references a secret from AWS Secrets Manager .
     * <p>
     * AWS IoT Greengrass stores a local, encrypted copy of the secret on the Greengrass core, where it can be securely accessed by connectors and Lambda functions. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/secrets.html">Deploy Secrets to the AWS IoT Greengrass Core</a> in the <em>Developer Guide</em> .
     * <p>
     * In an AWS CloudFormation template, <code>SecretsManagerSecretResourceData</code> can be used in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html"><code>ResourceDataContainer</code></a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * SecretsManagerSecretResourceDataProperty secretsManagerSecretResourceDataProperty = SecretsManagerSecretResourceDataProperty.builder()
     *         .arn("arn")
     *         // the properties below are optional
     *         .additionalStagingLabelsToDownload(List.of("additionalStagingLabelsToDownload"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.SecretsManagerSecretResourceDataProperty")
    @software.amazon.jsii.Jsii.Proxy(SecretsManagerSecretResourceDataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecretsManagerSecretResourceDataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Secrets Manager secret to make available on the core.
         * <p>
         * The value of the secret's latest version (represented by the <code>AWSCURRENT</code> staging label) is included by default.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata.html#cfn-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata.html#cfn-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * The staging labels whose values you want to make available on the core, in addition to <code>AWSCURRENT</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata.html#cfn-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata-additionalstaginglabelstodownload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata.html#cfn-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata-additionalstaginglabelstodownload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalStagingLabelsToDownload() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SecretsManagerSecretResourceDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecretsManagerSecretResourceDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecretsManagerSecretResourceDataProperty> {
            java.lang.String arn;
            java.util.List<java.lang.String> additionalStagingLabelsToDownload;

            /**
             * Sets the value of {@link SecretsManagerSecretResourceDataProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the Secrets Manager secret to make available on the core. This parameter is required.
             *            The value of the secret's latest version (represented by the <code>AWSCURRENT</code> staging label) is included by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link SecretsManagerSecretResourceDataProperty#getAdditionalStagingLabelsToDownload}
             * @param additionalStagingLabelsToDownload The staging labels whose values you want to make available on the core, in addition to <code>AWSCURRENT</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalStagingLabelsToDownload(java.util.List<java.lang.String> additionalStagingLabelsToDownload) {
                this.additionalStagingLabelsToDownload = additionalStagingLabelsToDownload;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecretsManagerSecretResourceDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecretsManagerSecretResourceDataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecretsManagerSecretResourceDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretsManagerSecretResourceDataProperty {
            private final java.lang.String arn;
            private final java.util.List<java.lang.String> additionalStagingLabelsToDownload;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.additionalStagingLabelsToDownload = software.amazon.jsii.Kernel.get(this, "additionalStagingLabelsToDownload", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
                this.additionalStagingLabelsToDownload = builder.additionalStagingLabelsToDownload;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.util.List<java.lang.String> getAdditionalStagingLabelsToDownload() {
                return this.additionalStagingLabelsToDownload;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));
                if (this.getAdditionalStagingLabelsToDownload() != null) {
                    data.set("additionalStagingLabelsToDownload", om.valueToTree(this.getAdditionalStagingLabelsToDownload()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnResourceDefinitionVersion.SecretsManagerSecretResourceDataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecretsManagerSecretResourceDataProperty.Jsii$Proxy that = (SecretsManagerSecretResourceDataProperty.Jsii$Proxy) o;

                if (!arn.equals(that.arn)) return false;
                return this.additionalStagingLabelsToDownload != null ? this.additionalStagingLabelsToDownload.equals(that.additionalStagingLabelsToDownload) : that.additionalStagingLabelsToDownload == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                result = 31 * result + (this.additionalStagingLabelsToDownload != null ? this.additionalStagingLabelsToDownload.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersionProps.Builder();
        }

        /**
         * The ID of the resource definition associated with this version.
         * <p>
         * This value is a GUID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html#cfn-greengrass-resourcedefinitionversion-resourcedefinitionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html#cfn-greengrass-resourcedefinitionversion-resourcedefinitionid</a>
         * @param resourceDefinitionId The ID of the resource definition associated with this version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceDefinitionId(final java.lang.String resourceDefinitionId) {
            this.props.resourceDefinitionId(resourceDefinitionId);
            return this;
        }

        /**
         * The resources in this version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html#cfn-greengrass-resourcedefinitionversion-resources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html#cfn-greengrass-resourcedefinitionversion-resources</a>
         * @param resources The resources in this version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(final software.amazon.awscdk.IResolvable resources) {
            this.props.resources(resources);
            return this;
        }
        /**
         * The resources in this version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html#cfn-greengrass-resourcedefinitionversion-resources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html#cfn-greengrass-resourcedefinitionversion-resources</a>
         * @param resources The resources in this version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(final java.util.List<? extends java.lang.Object> resources) {
            this.props.resources(resources);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion build() {
            return new software.amazon.awscdk.services.greengrass.CfnResourceDefinitionVersion(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
