package software.amazon.awscdk.services.imagebuilder;

/**
 * Properties for defining a <code>CfnContainerRecipe</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.imagebuilder.*;
 * CfnContainerRecipeProps cfnContainerRecipeProps = CfnContainerRecipeProps.builder()
 *         .components(List.of(ComponentConfigurationProperty.builder()
 *                 .componentArn("componentArn")
 *                 .parameters(List.of(ComponentParameterProperty.builder()
 *                         .name("name")
 *                         .value(List.of("value"))
 *                         .build()))
 *                 .build()))
 *         .containerType("containerType")
 *         .name("name")
 *         .parentImage("parentImage")
 *         .targetRepository(TargetContainerRepositoryProperty.builder()
 *                 .repositoryName("repositoryName")
 *                 .service("service")
 *                 .build())
 *         .version("version")
 *         // the properties below are optional
 *         .description("description")
 *         .dockerfileTemplateData("dockerfileTemplateData")
 *         .dockerfileTemplateUri("dockerfileTemplateUri")
 *         .imageOsVersionOverride("imageOsVersionOverride")
 *         .instanceConfiguration(InstanceConfigurationProperty.builder()
 *                 .blockDeviceMappings(List.of(InstanceBlockDeviceMappingProperty.builder()
 *                         .deviceName("deviceName")
 *                         .ebs(EbsInstanceBlockDeviceSpecificationProperty.builder()
 *                                 .deleteOnTermination(false)
 *                                 .encrypted(false)
 *                                 .iops(123)
 *                                 .kmsKeyId("kmsKeyId")
 *                                 .snapshotId("snapshotId")
 *                                 .throughput(123)
 *                                 .volumeSize(123)
 *                                 .volumeType("volumeType")
 *                                 .build())
 *                         .noDevice("noDevice")
 *                         .virtualName("virtualName")
 *                         .build()))
 *                 .image("image")
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .platformOverride("platformOverride")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .workingDirectory("workingDirectory")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:08.364Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnContainerRecipeProps")
@software.amazon.jsii.Jsii.Proxy(CfnContainerRecipeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnContainerRecipeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Build and test components that are included in the container recipe.
     * <p>
     * Recipes require a minimum of one build component, and can have a maximum of 20 build and test components in any combination.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-components">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-components</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getComponents();

    /**
     * Specifies the type of container, such as Docker.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-containertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-containertype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getContainerType();

    /**
     * The name of the container recipe.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The base image for customizations specified in the container recipe.
     * <p>
     * This can contain an Image Builder image resource ARN or a container image URI, for example <code>amazonlinux:latest</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-parentimage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-parentimage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getParentImage();

    /**
     * The destination repository for the container image.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-targetrepository">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-targetrepository</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTargetRepository();

    /**
     * The semantic version of the container recipe.
     * <p>
     * <blockquote>
     * <p>
     * The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
     * <p>
     * <em>Assignment:</em> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
     * <p>
     * <em>Patterns:</em> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
     * <p>
     * <em>Filtering:</em> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-version</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVersion();

    /**
     * The description of the container recipe.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of the elements required by the application running inside.
     * <p>
     * The template data consists of contextual variables where Image Builder places build information or scripts, based on your container image recipe.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-dockerfiletemplatedata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-dockerfiletemplatedata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDockerfileTemplateData() {
        return null;
    }

    /**
     * The S3 URI for the Dockerfile that will be used to build your container image.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-dockerfiletemplateuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-dockerfiletemplateuri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDockerfileTemplateUri() {
        return null;
    }

    /**
     * Specifies the operating system version for the base image.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-imageosversionoverride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-imageosversionoverride</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageOsVersionOverride() {
        return null;
    }

    /**
     * A group of options that can be used to configure an instance for building and testing container images.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-instanceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-instanceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceConfiguration() {
        return null;
    }

    /**
     * Identifies which KMS key is used to encrypt the container image for distribution to the target Region.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Specifies the operating system platform when you use a custom base image.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-platformoverride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-platformoverride</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPlatformOverride() {
        return null;
    }

    /**
     * Tags that are attached to the container recipe.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * The working directory for use during build and test workflows.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-workingdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-containerrecipe.html#cfn-imagebuilder-containerrecipe-workingdirectory</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWorkingDirectory() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnContainerRecipeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnContainerRecipeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnContainerRecipeProps> {
        java.lang.Object components;
        java.lang.String containerType;
        java.lang.String name;
        java.lang.String parentImage;
        java.lang.Object targetRepository;
        java.lang.String version;
        java.lang.String description;
        java.lang.String dockerfileTemplateData;
        java.lang.String dockerfileTemplateUri;
        java.lang.String imageOsVersionOverride;
        java.lang.Object instanceConfiguration;
        java.lang.String kmsKeyId;
        java.lang.String platformOverride;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.String workingDirectory;

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getComponents}
         * @param components Build and test components that are included in the container recipe. This parameter is required.
         *                   Recipes require a minimum of one build component, and can have a maximum of 20 build and test components in any combination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder components(software.amazon.awscdk.IResolvable components) {
            this.components = components;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getComponents}
         * @param components Build and test components that are included in the container recipe. This parameter is required.
         *                   Recipes require a minimum of one build component, and can have a maximum of 20 build and test components in any combination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder components(java.util.List<? extends java.lang.Object> components) {
            this.components = components;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getContainerType}
         * @param containerType Specifies the type of container, such as Docker. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerType(java.lang.String containerType) {
            this.containerType = containerType;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getName}
         * @param name The name of the container recipe. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getParentImage}
         * @param parentImage The base image for customizations specified in the container recipe. This parameter is required.
         *                    This can contain an Image Builder image resource ARN or a container image URI, for example <code>amazonlinux:latest</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parentImage(java.lang.String parentImage) {
            this.parentImage = parentImage;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getTargetRepository}
         * @param targetRepository The destination repository for the container image. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetRepository(software.amazon.awscdk.IResolvable targetRepository) {
            this.targetRepository = targetRepository;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getTargetRepository}
         * @param targetRepository The destination repository for the container image. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetRepository(software.amazon.awscdk.services.imagebuilder.CfnContainerRecipe.TargetContainerRepositoryProperty targetRepository) {
            this.targetRepository = targetRepository;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getVersion}
         * @param version The semantic version of the container recipe. This parameter is required.
         *                <blockquote>
         *                <p>
         *                The semantic version has four nodes: <major>.<minor>.<patch>/<build>. You can assign values for the first three, and can filter on all of them.
         *                <p>
         *                <em>Assignment:</em> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.
         *                <p>
         *                <em>Patterns:</em> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.
         *                <p>
         *                <em>Filtering:</em> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getDescription}
         * @param description The description of the container recipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getDockerfileTemplateData}
         * @param dockerfileTemplateData Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of the elements required by the application running inside.
         *                               The template data consists of contextual variables where Image Builder places build information or scripts, based on your container image recipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerfileTemplateData(java.lang.String dockerfileTemplateData) {
            this.dockerfileTemplateData = dockerfileTemplateData;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getDockerfileTemplateUri}
         * @param dockerfileTemplateUri The S3 URI for the Dockerfile that will be used to build your container image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerfileTemplateUri(java.lang.String dockerfileTemplateUri) {
            this.dockerfileTemplateUri = dockerfileTemplateUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getImageOsVersionOverride}
         * @param imageOsVersionOverride Specifies the operating system version for the base image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageOsVersionOverride(java.lang.String imageOsVersionOverride) {
            this.imageOsVersionOverride = imageOsVersionOverride;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getInstanceConfiguration}
         * @param instanceConfiguration A group of options that can be used to configure an instance for building and testing container images.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceConfiguration(software.amazon.awscdk.IResolvable instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getInstanceConfiguration}
         * @param instanceConfiguration A group of options that can be used to configure an instance for building and testing container images.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceConfiguration(software.amazon.awscdk.services.imagebuilder.CfnContainerRecipe.InstanceConfigurationProperty instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getKmsKeyId}
         * @param kmsKeyId Identifies which KMS key is used to encrypt the container image for distribution to the target Region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getPlatformOverride}
         * @param platformOverride Specifies the operating system platform when you use a custom base image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformOverride(java.lang.String platformOverride) {
            this.platformOverride = platformOverride;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getTags}
         * @param tags Tags that are attached to the container recipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerRecipeProps#getWorkingDirectory}
         * @param workingDirectory The working directory for use during build and test workflows.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workingDirectory(java.lang.String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnContainerRecipeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnContainerRecipeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnContainerRecipeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnContainerRecipeProps {
        private final java.lang.Object components;
        private final java.lang.String containerType;
        private final java.lang.String name;
        private final java.lang.String parentImage;
        private final java.lang.Object targetRepository;
        private final java.lang.String version;
        private final java.lang.String description;
        private final java.lang.String dockerfileTemplateData;
        private final java.lang.String dockerfileTemplateUri;
        private final java.lang.String imageOsVersionOverride;
        private final java.lang.Object instanceConfiguration;
        private final java.lang.String kmsKeyId;
        private final java.lang.String platformOverride;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.String workingDirectory;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.components = software.amazon.jsii.Kernel.get(this, "components", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.containerType = software.amazon.jsii.Kernel.get(this, "containerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parentImage = software.amazon.jsii.Kernel.get(this, "parentImage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetRepository = software.amazon.jsii.Kernel.get(this, "targetRepository", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dockerfileTemplateData = software.amazon.jsii.Kernel.get(this, "dockerfileTemplateData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dockerfileTemplateUri = software.amazon.jsii.Kernel.get(this, "dockerfileTemplateUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageOsVersionOverride = software.amazon.jsii.Kernel.get(this, "imageOsVersionOverride", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceConfiguration = software.amazon.jsii.Kernel.get(this, "instanceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.platformOverride = software.amazon.jsii.Kernel.get(this, "platformOverride", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.workingDirectory = software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.components = java.util.Objects.requireNonNull(builder.components, "components is required");
            this.containerType = java.util.Objects.requireNonNull(builder.containerType, "containerType is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.parentImage = java.util.Objects.requireNonNull(builder.parentImage, "parentImage is required");
            this.targetRepository = java.util.Objects.requireNonNull(builder.targetRepository, "targetRepository is required");
            this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            this.description = builder.description;
            this.dockerfileTemplateData = builder.dockerfileTemplateData;
            this.dockerfileTemplateUri = builder.dockerfileTemplateUri;
            this.imageOsVersionOverride = builder.imageOsVersionOverride;
            this.instanceConfiguration = builder.instanceConfiguration;
            this.kmsKeyId = builder.kmsKeyId;
            this.platformOverride = builder.platformOverride;
            this.tags = builder.tags;
            this.workingDirectory = builder.workingDirectory;
        }

        @Override
        public final java.lang.Object getComponents() {
            return this.components;
        }

        @Override
        public final java.lang.String getContainerType() {
            return this.containerType;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getParentImage() {
            return this.parentImage;
        }

        @Override
        public final java.lang.Object getTargetRepository() {
            return this.targetRepository;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDockerfileTemplateData() {
            return this.dockerfileTemplateData;
        }

        @Override
        public final java.lang.String getDockerfileTemplateUri() {
            return this.dockerfileTemplateUri;
        }

        @Override
        public final java.lang.String getImageOsVersionOverride() {
            return this.imageOsVersionOverride;
        }

        @Override
        public final java.lang.Object getInstanceConfiguration() {
            return this.instanceConfiguration;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getPlatformOverride() {
            return this.platformOverride;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("components", om.valueToTree(this.getComponents()));
            data.set("containerType", om.valueToTree(this.getContainerType()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("parentImage", om.valueToTree(this.getParentImage()));
            data.set("targetRepository", om.valueToTree(this.getTargetRepository()));
            data.set("version", om.valueToTree(this.getVersion()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDockerfileTemplateData() != null) {
                data.set("dockerfileTemplateData", om.valueToTree(this.getDockerfileTemplateData()));
            }
            if (this.getDockerfileTemplateUri() != null) {
                data.set("dockerfileTemplateUri", om.valueToTree(this.getDockerfileTemplateUri()));
            }
            if (this.getImageOsVersionOverride() != null) {
                data.set("imageOsVersionOverride", om.valueToTree(this.getImageOsVersionOverride()));
            }
            if (this.getInstanceConfiguration() != null) {
                data.set("instanceConfiguration", om.valueToTree(this.getInstanceConfiguration()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getPlatformOverride() != null) {
                data.set("platformOverride", om.valueToTree(this.getPlatformOverride()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWorkingDirectory() != null) {
                data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnContainerRecipeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnContainerRecipeProps.Jsii$Proxy that = (CfnContainerRecipeProps.Jsii$Proxy) o;

            if (!components.equals(that.components)) return false;
            if (!containerType.equals(that.containerType)) return false;
            if (!name.equals(that.name)) return false;
            if (!parentImage.equals(that.parentImage)) return false;
            if (!targetRepository.equals(that.targetRepository)) return false;
            if (!version.equals(that.version)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.dockerfileTemplateData != null ? !this.dockerfileTemplateData.equals(that.dockerfileTemplateData) : that.dockerfileTemplateData != null) return false;
            if (this.dockerfileTemplateUri != null ? !this.dockerfileTemplateUri.equals(that.dockerfileTemplateUri) : that.dockerfileTemplateUri != null) return false;
            if (this.imageOsVersionOverride != null ? !this.imageOsVersionOverride.equals(that.imageOsVersionOverride) : that.imageOsVersionOverride != null) return false;
            if (this.instanceConfiguration != null ? !this.instanceConfiguration.equals(that.instanceConfiguration) : that.instanceConfiguration != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.platformOverride != null ? !this.platformOverride.equals(that.platformOverride) : that.platformOverride != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.workingDirectory != null ? this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory == null;
        }

        @Override
        public final int hashCode() {
            int result = this.components.hashCode();
            result = 31 * result + (this.containerType.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.parentImage.hashCode());
            result = 31 * result + (this.targetRepository.hashCode());
            result = 31 * result + (this.version.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.dockerfileTemplateData != null ? this.dockerfileTemplateData.hashCode() : 0);
            result = 31 * result + (this.dockerfileTemplateUri != null ? this.dockerfileTemplateUri.hashCode() : 0);
            result = 31 * result + (this.imageOsVersionOverride != null ? this.imageOsVersionOverride.hashCode() : 0);
            result = 31 * result + (this.instanceConfiguration != null ? this.instanceConfiguration.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.platformOverride != null ? this.platformOverride.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
            return result;
        }
    }
}
