package software.amazon.awscdk.services.iot;

/**
 * Use the <code>AWS::IoT::Thing</code> resource to declare an AWS IoT thing.
 * <p>
 * For information about working with things, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/aws-iot-how-it-works.html">How AWS IoT Works</a> and <a href="https://docs.aws.amazon.com/iot/latest/developerguide/thing-registry.html">Device Registry for AWS IoT</a> in the <em>AWS IoT Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnThing cfnThing = CfnThing.Builder.create(this, "MyCfnThing")
 *         .attributePayload(AttributePayloadProperty.builder()
 *                 .attributes(Map.of(
 *                         "attributesKey", "attributes"))
 *                 .build())
 *         .thingName("thingName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:08.548Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnThing")
public class CfnThing extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnThing(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnThing(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iot.CfnThing.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnThing(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnThingProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnThing(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the AWS IoT thing, such as <code>arn:aws:iot:us-east-2:123456789012:thing/MyThing</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Id of this thing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A string that contains up to three key value pairs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAttributePayload() {
        return software.amazon.jsii.Kernel.get(this, "attributePayload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A string that contains up to three key value pairs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributePayload(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "attributePayload", value);
    }

    /**
     * A string that contains up to three key value pairs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributePayload(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnThing.AttributePayloadProperty value) {
        software.amazon.jsii.Kernel.set(this, "attributePayload", value);
    }

    /**
     * The name of the thing to update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getThingName() {
        return software.amazon.jsii.Kernel.get(this, "thingName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the thing to update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThingName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "thingName", value);
    }
    /**
     * The AttributePayload property specifies up to three attributes for an AWS IoT as key-value pairs.
     * <p>
     * AttributePayload is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html">AWS::IoT::Thing</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * AttributePayloadProperty attributePayloadProperty = AttributePayloadProperty.builder()
     *         .attributes(Map.of(
     *                 "attributesKey", "attributes"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thing-attributepayload.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thing-attributepayload.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnThing.AttributePayloadProperty")
    @software.amazon.jsii.Jsii.Proxy(AttributePayloadProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AttributePayloadProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A JSON string containing up to three key-value pair in JSON format. For example:.
         * <p>
         * <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thing-attributepayload.html#cfn-iot-thing-attributepayload-attributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thing-attributepayload.html#cfn-iot-thing-attributepayload-attributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AttributePayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AttributePayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AttributePayloadProperty> {
            java.lang.Object attributes;

            /**
             * Sets the value of {@link AttributePayloadProperty#getAttributes}
             * @param attributes A JSON string containing up to three key-value pair in JSON format. For example:.
             *                   <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(java.util.Map<java.lang.String, java.lang.String> attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link AttributePayloadProperty#getAttributes}
             * @param attributes A JSON string containing up to three key-value pair in JSON format. For example:.
             *                   <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(software.amazon.awscdk.IResolvable attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributePayloadProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AttributePayloadProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AttributePayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributePayloadProperty {
            private final java.lang.Object attributes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributes = builder.attributes;
            }

            @Override
            public final java.lang.Object getAttributes() {
                return this.attributes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttributes() != null) {
                    data.set("attributes", om.valueToTree(this.getAttributes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnThing.AttributePayloadProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AttributePayloadProperty.Jsii$Proxy that = (AttributePayloadProperty.Jsii$Proxy) o;

                return this.attributes != null ? this.attributes.equals(that.attributes) : that.attributes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attributes != null ? this.attributes.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iot.CfnThing}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.CfnThing> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.iot.CfnThingProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A string that contains up to three key value pairs.
         * <p>
         * Maximum length of 800. Duplicates not allowed.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-attributepayload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-attributepayload</a>
         * @param attributePayload A string that contains up to three key value pairs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributePayload(final software.amazon.awscdk.IResolvable attributePayload) {
            this.props().attributePayload(attributePayload);
            return this;
        }
        /**
         * A string that contains up to three key value pairs.
         * <p>
         * Maximum length of 800. Duplicates not allowed.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-attributepayload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-attributepayload</a>
         * @param attributePayload A string that contains up to three key value pairs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributePayload(final software.amazon.awscdk.services.iot.CfnThing.AttributePayloadProperty attributePayload) {
            this.props().attributePayload(attributePayload);
            return this;
        }

        /**
         * The name of the thing to update.
         * <p>
         * You can't change a thing's name. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-thingname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-thingname</a>
         * @param thingName The name of the thing to update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingName(final java.lang.String thingName) {
            this.props().thingName(thingName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iot.CfnThing}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iot.CfnThing build() {
            return new software.amazon.awscdk.services.iot.CfnThing(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iot.CfnThingProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iot.CfnThingProps.Builder();
            }
            return this.props;
        }
    }
}
