package software.amazon.awscdk.services.iot;

/**
 * Use the <code>AWS::IoT::TopicRule</code> resource to declare an AWS IoT rule.
 * <p>
 * For information about working with AWS IoT rules, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html">Rules for AWS IoT</a> in the <em>AWS IoT Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnTopicRule cfnTopicRule = CfnTopicRule.Builder.create(this, "MyCfnTopicRule")
 *         .topicRulePayload(TopicRulePayloadProperty.builder()
 *                 .actions(List.of(ActionProperty.builder()
 *                         .cloudwatchAlarm(CloudwatchAlarmActionProperty.builder()
 *                                 .alarmName("alarmName")
 *                                 .roleArn("roleArn")
 *                                 .stateReason("stateReason")
 *                                 .stateValue("stateValue")
 *                                 .build())
 *                         .cloudwatchLogs(CloudwatchLogsActionProperty.builder()
 *                                 .logGroupName("logGroupName")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .batchMode(false)
 *                                 .build())
 *                         .cloudwatchMetric(CloudwatchMetricActionProperty.builder()
 *                                 .metricName("metricName")
 *                                 .metricNamespace("metricNamespace")
 *                                 .metricUnit("metricUnit")
 *                                 .metricValue("metricValue")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .metricTimestamp("metricTimestamp")
 *                                 .build())
 *                         .dynamoDb(DynamoDBActionProperty.builder()
 *                                 .hashKeyField("hashKeyField")
 *                                 .hashKeyValue("hashKeyValue")
 *                                 .roleArn("roleArn")
 *                                 .tableName("tableName")
 *                                 // the properties below are optional
 *                                 .hashKeyType("hashKeyType")
 *                                 .payloadField("payloadField")
 *                                 .rangeKeyField("rangeKeyField")
 *                                 .rangeKeyType("rangeKeyType")
 *                                 .rangeKeyValue("rangeKeyValue")
 *                                 .build())
 *                         .dynamoDBv2(DynamoDBv2ActionProperty.builder()
 *                                 .putItem(PutItemInputProperty.builder()
 *                                         .tableName("tableName")
 *                                         .build())
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .elasticsearch(ElasticsearchActionProperty.builder()
 *                                 .endpoint("endpoint")
 *                                 .id("id")
 *                                 .index("index")
 *                                 .roleArn("roleArn")
 *                                 .type("type")
 *                                 .build())
 *                         .firehose(FirehoseActionProperty.builder()
 *                                 .deliveryStreamName("deliveryStreamName")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .batchMode(false)
 *                                 .separator("separator")
 *                                 .build())
 *                         .http(HttpActionProperty.builder()
 *                                 .url("url")
 *                                 // the properties below are optional
 *                                 .auth(HttpAuthorizationProperty.builder()
 *                                         .sigv4(SigV4AuthorizationProperty.builder()
 *                                                 .roleArn("roleArn")
 *                                                 .serviceName("serviceName")
 *                                                 .signingRegion("signingRegion")
 *                                                 .build())
 *                                         .build())
 *                                 .confirmationUrl("confirmationUrl")
 *                                 .headers(List.of(HttpActionHeaderProperty.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         .build()))
 *                                 .build())
 *                         .iotAnalytics(IotAnalyticsActionProperty.builder()
 *                                 .channelName("channelName")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .batchMode(false)
 *                                 .build())
 *                         .iotEvents(IotEventsActionProperty.builder()
 *                                 .inputName("inputName")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .batchMode(false)
 *                                 .messageId("messageId")
 *                                 .build())
 *                         .iotSiteWise(IotSiteWiseActionProperty.builder()
 *                                 .putAssetPropertyValueEntries(List.of(PutAssetPropertyValueEntryProperty.builder()
 *                                         .propertyValues(List.of(AssetPropertyValueProperty.builder()
 *                                                 .timestamp(AssetPropertyTimestampProperty.builder()
 *                                                         .timeInSeconds("timeInSeconds")
 *                                                         // the properties below are optional
 *                                                         .offsetInNanos("offsetInNanos")
 *                                                         .build())
 *                                                 .value(AssetPropertyVariantProperty.builder()
 *                                                         .booleanValue("booleanValue")
 *                                                         .doubleValue("doubleValue")
 *                                                         .integerValue("integerValue")
 *                                                         .stringValue("stringValue")
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .quality("quality")
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .assetId("assetId")
 *                                         .entryId("entryId")
 *                                         .propertyAlias("propertyAlias")
 *                                         .propertyId("propertyId")
 *                                         .build()))
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .kafka(KafkaActionProperty.builder()
 *                                 .clientProperties(Map.of(
 *                                         "clientPropertiesKey", "clientProperties"))
 *                                 .destinationArn("destinationArn")
 *                                 .topic("topic")
 *                                 // the properties below are optional
 *                                 .headers(List.of(KafkaActionHeaderProperty.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         .build()))
 *                                 .key("key")
 *                                 .partition("partition")
 *                                 .build())
 *                         .kinesis(KinesisActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .streamName("streamName")
 *                                 // the properties below are optional
 *                                 .partitionKey("partitionKey")
 *                                 .build())
 *                         .lambda(LambdaActionProperty.builder()
 *                                 .functionArn("functionArn")
 *                                 .build())
 *                         .location(LocationActionProperty.builder()
 *                                 .deviceId("deviceId")
 *                                 .latitude("latitude")
 *                                 .longitude("longitude")
 *                                 .roleArn("roleArn")
 *                                 .trackerName("trackerName")
 *                                 // the properties below are optional
 *                                 .timestamp(TimestampProperty.builder()
 *                                         .value("value")
 *                                         // the properties below are optional
 *                                         .unit("unit")
 *                                         .build())
 *                                 .build())
 *                         .openSearch(OpenSearchActionProperty.builder()
 *                                 .endpoint("endpoint")
 *                                 .id("id")
 *                                 .index("index")
 *                                 .roleArn("roleArn")
 *                                 .type("type")
 *                                 .build())
 *                         .republish(RepublishActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .topic("topic")
 *                                 // the properties below are optional
 *                                 .headers(RepublishActionHeadersProperty.builder()
 *                                         .contentType("contentType")
 *                                         .correlationData("correlationData")
 *                                         .messageExpiry("messageExpiry")
 *                                         .payloadFormatIndicator("payloadFormatIndicator")
 *                                         .responseTopic("responseTopic")
 *                                         .userProperties(List.of(UserPropertyProperty.builder()
 *                                                 .key("key")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .build())
 *                                 .qos(123)
 *                                 .build())
 *                         .s3(S3ActionProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .key("key")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .cannedAcl("cannedAcl")
 *                                 .build())
 *                         .sns(SnsActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .targetArn("targetArn")
 *                                 // the properties below are optional
 *                                 .messageFormat("messageFormat")
 *                                 .build())
 *                         .sqs(SqsActionProperty.builder()
 *                                 .queueUrl("queueUrl")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .useBase64(false)
 *                                 .build())
 *                         .stepFunctions(StepFunctionsActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .stateMachineName("stateMachineName")
 *                                 // the properties below are optional
 *                                 .executionNamePrefix("executionNamePrefix")
 *                                 .build())
 *                         .timestream(TimestreamActionProperty.builder()
 *                                 .databaseName("databaseName")
 *                                 .dimensions(List.of(TimestreamDimensionProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .roleArn("roleArn")
 *                                 .tableName("tableName")
 *                                 // the properties below are optional
 *                                 .timestamp(TimestreamTimestampProperty.builder()
 *                                         .unit("unit")
 *                                         .value("value")
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *                 .sql("sql")
 *                 // the properties below are optional
 *                 .awsIotSqlVersion("awsIotSqlVersion")
 *                 .description("description")
 *                 .errorAction(ActionProperty.builder()
 *                         .cloudwatchAlarm(CloudwatchAlarmActionProperty.builder()
 *                                 .alarmName("alarmName")
 *                                 .roleArn("roleArn")
 *                                 .stateReason("stateReason")
 *                                 .stateValue("stateValue")
 *                                 .build())
 *                         .cloudwatchLogs(CloudwatchLogsActionProperty.builder()
 *                                 .logGroupName("logGroupName")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .batchMode(false)
 *                                 .build())
 *                         .cloudwatchMetric(CloudwatchMetricActionProperty.builder()
 *                                 .metricName("metricName")
 *                                 .metricNamespace("metricNamespace")
 *                                 .metricUnit("metricUnit")
 *                                 .metricValue("metricValue")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .metricTimestamp("metricTimestamp")
 *                                 .build())
 *                         .dynamoDb(DynamoDBActionProperty.builder()
 *                                 .hashKeyField("hashKeyField")
 *                                 .hashKeyValue("hashKeyValue")
 *                                 .roleArn("roleArn")
 *                                 .tableName("tableName")
 *                                 // the properties below are optional
 *                                 .hashKeyType("hashKeyType")
 *                                 .payloadField("payloadField")
 *                                 .rangeKeyField("rangeKeyField")
 *                                 .rangeKeyType("rangeKeyType")
 *                                 .rangeKeyValue("rangeKeyValue")
 *                                 .build())
 *                         .dynamoDBv2(DynamoDBv2ActionProperty.builder()
 *                                 .putItem(PutItemInputProperty.builder()
 *                                         .tableName("tableName")
 *                                         .build())
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .elasticsearch(ElasticsearchActionProperty.builder()
 *                                 .endpoint("endpoint")
 *                                 .id("id")
 *                                 .index("index")
 *                                 .roleArn("roleArn")
 *                                 .type("type")
 *                                 .build())
 *                         .firehose(FirehoseActionProperty.builder()
 *                                 .deliveryStreamName("deliveryStreamName")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .batchMode(false)
 *                                 .separator("separator")
 *                                 .build())
 *                         .http(HttpActionProperty.builder()
 *                                 .url("url")
 *                                 // the properties below are optional
 *                                 .auth(HttpAuthorizationProperty.builder()
 *                                         .sigv4(SigV4AuthorizationProperty.builder()
 *                                                 .roleArn("roleArn")
 *                                                 .serviceName("serviceName")
 *                                                 .signingRegion("signingRegion")
 *                                                 .build())
 *                                         .build())
 *                                 .confirmationUrl("confirmationUrl")
 *                                 .headers(List.of(HttpActionHeaderProperty.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         .build()))
 *                                 .build())
 *                         .iotAnalytics(IotAnalyticsActionProperty.builder()
 *                                 .channelName("channelName")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .batchMode(false)
 *                                 .build())
 *                         .iotEvents(IotEventsActionProperty.builder()
 *                                 .inputName("inputName")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .batchMode(false)
 *                                 .messageId("messageId")
 *                                 .build())
 *                         .iotSiteWise(IotSiteWiseActionProperty.builder()
 *                                 .putAssetPropertyValueEntries(List.of(PutAssetPropertyValueEntryProperty.builder()
 *                                         .propertyValues(List.of(AssetPropertyValueProperty.builder()
 *                                                 .timestamp(AssetPropertyTimestampProperty.builder()
 *                                                         .timeInSeconds("timeInSeconds")
 *                                                         // the properties below are optional
 *                                                         .offsetInNanos("offsetInNanos")
 *                                                         .build())
 *                                                 .value(AssetPropertyVariantProperty.builder()
 *                                                         .booleanValue("booleanValue")
 *                                                         .doubleValue("doubleValue")
 *                                                         .integerValue("integerValue")
 *                                                         .stringValue("stringValue")
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .quality("quality")
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .assetId("assetId")
 *                                         .entryId("entryId")
 *                                         .propertyAlias("propertyAlias")
 *                                         .propertyId("propertyId")
 *                                         .build()))
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .kafka(KafkaActionProperty.builder()
 *                                 .clientProperties(Map.of(
 *                                         "clientPropertiesKey", "clientProperties"))
 *                                 .destinationArn("destinationArn")
 *                                 .topic("topic")
 *                                 // the properties below are optional
 *                                 .headers(List.of(KafkaActionHeaderProperty.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         .build()))
 *                                 .key("key")
 *                                 .partition("partition")
 *                                 .build())
 *                         .kinesis(KinesisActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .streamName("streamName")
 *                                 // the properties below are optional
 *                                 .partitionKey("partitionKey")
 *                                 .build())
 *                         .lambda(LambdaActionProperty.builder()
 *                                 .functionArn("functionArn")
 *                                 .build())
 *                         .location(LocationActionProperty.builder()
 *                                 .deviceId("deviceId")
 *                                 .latitude("latitude")
 *                                 .longitude("longitude")
 *                                 .roleArn("roleArn")
 *                                 .trackerName("trackerName")
 *                                 // the properties below are optional
 *                                 .timestamp(TimestampProperty.builder()
 *                                         .value("value")
 *                                         // the properties below are optional
 *                                         .unit("unit")
 *                                         .build())
 *                                 .build())
 *                         .openSearch(OpenSearchActionProperty.builder()
 *                                 .endpoint("endpoint")
 *                                 .id("id")
 *                                 .index("index")
 *                                 .roleArn("roleArn")
 *                                 .type("type")
 *                                 .build())
 *                         .republish(RepublishActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .topic("topic")
 *                                 // the properties below are optional
 *                                 .headers(RepublishActionHeadersProperty.builder()
 *                                         .contentType("contentType")
 *                                         .correlationData("correlationData")
 *                                         .messageExpiry("messageExpiry")
 *                                         .payloadFormatIndicator("payloadFormatIndicator")
 *                                         .responseTopic("responseTopic")
 *                                         .userProperties(List.of(UserPropertyProperty.builder()
 *                                                 .key("key")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .build())
 *                                 .qos(123)
 *                                 .build())
 *                         .s3(S3ActionProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .key("key")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .cannedAcl("cannedAcl")
 *                                 .build())
 *                         .sns(SnsActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .targetArn("targetArn")
 *                                 // the properties below are optional
 *                                 .messageFormat("messageFormat")
 *                                 .build())
 *                         .sqs(SqsActionProperty.builder()
 *                                 .queueUrl("queueUrl")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .useBase64(false)
 *                                 .build())
 *                         .stepFunctions(StepFunctionsActionProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .stateMachineName("stateMachineName")
 *                                 // the properties below are optional
 *                                 .executionNamePrefix("executionNamePrefix")
 *                                 .build())
 *                         .timestream(TimestreamActionProperty.builder()
 *                                 .databaseName("databaseName")
 *                                 .dimensions(List.of(TimestreamDimensionProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .roleArn("roleArn")
 *                                 .tableName("tableName")
 *                                 // the properties below are optional
 *                                 .timestamp(TimestreamTimestampProperty.builder()
 *                                         .unit("unit")
 *                                         .value("value")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .ruleDisabled(false)
 *                 .build())
 *         // the properties below are optional
 *         .ruleName("ruleName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:08.560Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule")
public class CfnTopicRule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnTopicRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTopicRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iot.CfnTopicRule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTopicRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.CfnTopicRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the AWS IoT rule, such as <code>arn:aws:iot:us-east-2:123456789012:rule/MyIoTRule</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The rule payload.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTopicRulePayload() {
        return software.amazon.jsii.Kernel.get(this, "topicRulePayload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The rule payload.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTopicRulePayload(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "topicRulePayload", java.util.Objects.requireNonNull(value, "topicRulePayload is required"));
    }

    /**
     * The rule payload.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTopicRulePayload(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.CfnTopicRule.TopicRulePayloadProperty value) {
        software.amazon.jsii.Kernel.set(this, "topicRulePayload", java.util.Objects.requireNonNull(value, "topicRulePayload is required"));
    }

    /**
     * The name of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRuleName() {
        return software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ruleName", value);
    }

    /**
     * Metadata which can be used to manage the topic rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Metadata which can be used to manage the topic rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Describes the actions associated with a rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * ActionProperty actionProperty = ActionProperty.builder()
     *         .cloudwatchAlarm(CloudwatchAlarmActionProperty.builder()
     *                 .alarmName("alarmName")
     *                 .roleArn("roleArn")
     *                 .stateReason("stateReason")
     *                 .stateValue("stateValue")
     *                 .build())
     *         .cloudwatchLogs(CloudwatchLogsActionProperty.builder()
     *                 .logGroupName("logGroupName")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .batchMode(false)
     *                 .build())
     *         .cloudwatchMetric(CloudwatchMetricActionProperty.builder()
     *                 .metricName("metricName")
     *                 .metricNamespace("metricNamespace")
     *                 .metricUnit("metricUnit")
     *                 .metricValue("metricValue")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .metricTimestamp("metricTimestamp")
     *                 .build())
     *         .dynamoDb(DynamoDBActionProperty.builder()
     *                 .hashKeyField("hashKeyField")
     *                 .hashKeyValue("hashKeyValue")
     *                 .roleArn("roleArn")
     *                 .tableName("tableName")
     *                 // the properties below are optional
     *                 .hashKeyType("hashKeyType")
     *                 .payloadField("payloadField")
     *                 .rangeKeyField("rangeKeyField")
     *                 .rangeKeyType("rangeKeyType")
     *                 .rangeKeyValue("rangeKeyValue")
     *                 .build())
     *         .dynamoDBv2(DynamoDBv2ActionProperty.builder()
     *                 .putItem(PutItemInputProperty.builder()
     *                         .tableName("tableName")
     *                         .build())
     *                 .roleArn("roleArn")
     *                 .build())
     *         .elasticsearch(ElasticsearchActionProperty.builder()
     *                 .endpoint("endpoint")
     *                 .id("id")
     *                 .index("index")
     *                 .roleArn("roleArn")
     *                 .type("type")
     *                 .build())
     *         .firehose(FirehoseActionProperty.builder()
     *                 .deliveryStreamName("deliveryStreamName")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .batchMode(false)
     *                 .separator("separator")
     *                 .build())
     *         .http(HttpActionProperty.builder()
     *                 .url("url")
     *                 // the properties below are optional
     *                 .auth(HttpAuthorizationProperty.builder()
     *                         .sigv4(SigV4AuthorizationProperty.builder()
     *                                 .roleArn("roleArn")
     *                                 .serviceName("serviceName")
     *                                 .signingRegion("signingRegion")
     *                                 .build())
     *                         .build())
     *                 .confirmationUrl("confirmationUrl")
     *                 .headers(List.of(HttpActionHeaderProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .iotAnalytics(IotAnalyticsActionProperty.builder()
     *                 .channelName("channelName")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .batchMode(false)
     *                 .build())
     *         .iotEvents(IotEventsActionProperty.builder()
     *                 .inputName("inputName")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .batchMode(false)
     *                 .messageId("messageId")
     *                 .build())
     *         .iotSiteWise(IotSiteWiseActionProperty.builder()
     *                 .putAssetPropertyValueEntries(List.of(PutAssetPropertyValueEntryProperty.builder()
     *                         .propertyValues(List.of(AssetPropertyValueProperty.builder()
     *                                 .timestamp(AssetPropertyTimestampProperty.builder()
     *                                         .timeInSeconds("timeInSeconds")
     *                                         // the properties below are optional
     *                                         .offsetInNanos("offsetInNanos")
     *                                         .build())
     *                                 .value(AssetPropertyVariantProperty.builder()
     *                                         .booleanValue("booleanValue")
     *                                         .doubleValue("doubleValue")
     *                                         .integerValue("integerValue")
     *                                         .stringValue("stringValue")
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .quality("quality")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .assetId("assetId")
     *                         .entryId("entryId")
     *                         .propertyAlias("propertyAlias")
     *                         .propertyId("propertyId")
     *                         .build()))
     *                 .roleArn("roleArn")
     *                 .build())
     *         .kafka(KafkaActionProperty.builder()
     *                 .clientProperties(Map.of(
     *                         "clientPropertiesKey", "clientProperties"))
     *                 .destinationArn("destinationArn")
     *                 .topic("topic")
     *                 // the properties below are optional
     *                 .headers(List.of(KafkaActionHeaderProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .key("key")
     *                 .partition("partition")
     *                 .build())
     *         .kinesis(KinesisActionProperty.builder()
     *                 .roleArn("roleArn")
     *                 .streamName("streamName")
     *                 // the properties below are optional
     *                 .partitionKey("partitionKey")
     *                 .build())
     *         .lambda(LambdaActionProperty.builder()
     *                 .functionArn("functionArn")
     *                 .build())
     *         .location(LocationActionProperty.builder()
     *                 .deviceId("deviceId")
     *                 .latitude("latitude")
     *                 .longitude("longitude")
     *                 .roleArn("roleArn")
     *                 .trackerName("trackerName")
     *                 // the properties below are optional
     *                 .timestamp(TimestampProperty.builder()
     *                         .value("value")
     *                         // the properties below are optional
     *                         .unit("unit")
     *                         .build())
     *                 .build())
     *         .openSearch(OpenSearchActionProperty.builder()
     *                 .endpoint("endpoint")
     *                 .id("id")
     *                 .index("index")
     *                 .roleArn("roleArn")
     *                 .type("type")
     *                 .build())
     *         .republish(RepublishActionProperty.builder()
     *                 .roleArn("roleArn")
     *                 .topic("topic")
     *                 // the properties below are optional
     *                 .headers(RepublishActionHeadersProperty.builder()
     *                         .contentType("contentType")
     *                         .correlationData("correlationData")
     *                         .messageExpiry("messageExpiry")
     *                         .payloadFormatIndicator("payloadFormatIndicator")
     *                         .responseTopic("responseTopic")
     *                         .userProperties(List.of(UserPropertyProperty.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 .qos(123)
     *                 .build())
     *         .s3(S3ActionProperty.builder()
     *                 .bucketName("bucketName")
     *                 .key("key")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .cannedAcl("cannedAcl")
     *                 .build())
     *         .sns(SnsActionProperty.builder()
     *                 .roleArn("roleArn")
     *                 .targetArn("targetArn")
     *                 // the properties below are optional
     *                 .messageFormat("messageFormat")
     *                 .build())
     *         .sqs(SqsActionProperty.builder()
     *                 .queueUrl("queueUrl")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .useBase64(false)
     *                 .build())
     *         .stepFunctions(StepFunctionsActionProperty.builder()
     *                 .roleArn("roleArn")
     *                 .stateMachineName("stateMachineName")
     *                 // the properties below are optional
     *                 .executionNamePrefix("executionNamePrefix")
     *                 .build())
     *         .timestream(TimestreamActionProperty.builder()
     *                 .databaseName("databaseName")
     *                 .dimensions(List.of(TimestreamDimensionProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .roleArn("roleArn")
     *                 .tableName("tableName")
     *                 // the properties below are optional
     *                 .timestamp(TimestreamTimestampProperty.builder()
     *                         .unit("unit")
     *                         .value("value")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.ActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Change the state of a CloudWatch alarm.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-cloudwatchalarm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-cloudwatchalarm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudwatchAlarm() {
            return null;
        }

        /**
         * Sends data to CloudWatch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-cloudwatchlogs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-cloudwatchlogs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudwatchLogs() {
            return null;
        }

        /**
         * Capture a CloudWatch metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-cloudwatchmetric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-cloudwatchmetric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudwatchMetric() {
            return null;
        }

        /**
         * Write to a DynamoDB table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-dynamodb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-dynamodb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDb() {
            return null;
        }

        /**
         * Write to a DynamoDB table.
         * <p>
         * This is a new version of the DynamoDB action. It allows you to write each attribute in an MQTT message payload into a separate DynamoDB column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-dynamodbv2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-dynamodbv2</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDBv2() {
            return null;
        }

        /**
         * Write data to an Amazon OpenSearch Service domain.
         * <p>
         * <blockquote>
         * <p>
         * The <code>Elasticsearch</code> action can only be used by existing rule actions. To create a new rule action or to update an existing rule action, use the <code>OpenSearch</code> rule action instead. For more information, see <a href="https://docs.aws.amazon.com//iot/latest/apireference/API_OpenSearchAction.html">OpenSearchAction</a> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-elasticsearch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-elasticsearch</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearch() {
            return null;
        }

        /**
         * Write to an Amazon Kinesis Firehose stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-firehose">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-firehose</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFirehose() {
            return null;
        }

        /**
         * Send data to an HTTPS endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-http">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-http</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttp() {
            return null;
        }

        /**
         * Sends message data to an AWS IoT Analytics channel.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-iotanalytics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-iotanalytics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIotAnalytics() {
            return null;
        }

        /**
         * Sends an input to an AWS IoT Events detector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-iotevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-iotevents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIotEvents() {
            return null;
        }

        /**
         * Sends data from the MQTT message that triggered the rule to AWS IoT SiteWise asset properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-iotsitewise">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-iotsitewise</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIotSiteWise() {
            return null;
        }

        /**
         * Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-kafka">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-kafka</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKafka() {
            return null;
        }

        /**
         * Write data to an Amazon Kinesis stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-kinesis">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-kinesis</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesis() {
            return null;
        }

        /**
         * Invoke a Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-lambda">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-lambda</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambda() {
            return null;
        }

        /**
         * Sends device location data to <a href="https://docs.aws.amazon.com//location/latest/developerguide/welcome.html">Amazon Location Service</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-location</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLocation() {
            return null;
        }

        /**
         * Write data to an Amazon OpenSearch Service domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-opensearch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-opensearch</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOpenSearch() {
            return null;
        }

        /**
         * Publish to another MQTT topic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-republish">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-republish</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRepublish() {
            return null;
        }

        /**
         * Write to an Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * Publish to an Amazon SNS topic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-sns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-sns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSns() {
            return null;
        }

        /**
         * Publish to an Amazon SQS queue.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-sqs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-sqs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqs() {
            return null;
        }

        /**
         * Starts execution of a Step Functions state machine.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-stepfunctions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-stepfunctions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStepFunctions() {
            return null;
        }

        /**
         * Writes attributes from an MQTT message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-timestream">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-timestream</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimestream() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionProperty> {
            java.lang.Object cloudwatchAlarm;
            java.lang.Object cloudwatchLogs;
            java.lang.Object cloudwatchMetric;
            java.lang.Object dynamoDb;
            java.lang.Object dynamoDBv2;
            java.lang.Object elasticsearch;
            java.lang.Object firehose;
            java.lang.Object http;
            java.lang.Object iotAnalytics;
            java.lang.Object iotEvents;
            java.lang.Object iotSiteWise;
            java.lang.Object kafka;
            java.lang.Object kinesis;
            java.lang.Object lambda;
            java.lang.Object location;
            java.lang.Object openSearch;
            java.lang.Object republish;
            java.lang.Object s3;
            java.lang.Object sns;
            java.lang.Object sqs;
            java.lang.Object stepFunctions;
            java.lang.Object timestream;

            /**
             * Sets the value of {@link ActionProperty#getCloudwatchAlarm}
             * @param cloudwatchAlarm Change the state of a CloudWatch alarm.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudwatchAlarm(software.amazon.awscdk.IResolvable cloudwatchAlarm) {
                this.cloudwatchAlarm = cloudwatchAlarm;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getCloudwatchAlarm}
             * @param cloudwatchAlarm Change the state of a CloudWatch alarm.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudwatchAlarm(software.amazon.awscdk.services.iot.CfnTopicRule.CloudwatchAlarmActionProperty cloudwatchAlarm) {
                this.cloudwatchAlarm = cloudwatchAlarm;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getCloudwatchLogs}
             * @param cloudwatchLogs Sends data to CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudwatchLogs(software.amazon.awscdk.IResolvable cloudwatchLogs) {
                this.cloudwatchLogs = cloudwatchLogs;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getCloudwatchLogs}
             * @param cloudwatchLogs Sends data to CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudwatchLogs(software.amazon.awscdk.services.iot.CfnTopicRule.CloudwatchLogsActionProperty cloudwatchLogs) {
                this.cloudwatchLogs = cloudwatchLogs;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getCloudwatchMetric}
             * @param cloudwatchMetric Capture a CloudWatch metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudwatchMetric(software.amazon.awscdk.IResolvable cloudwatchMetric) {
                this.cloudwatchMetric = cloudwatchMetric;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getCloudwatchMetric}
             * @param cloudwatchMetric Capture a CloudWatch metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudwatchMetric(software.amazon.awscdk.services.iot.CfnTopicRule.CloudwatchMetricActionProperty cloudwatchMetric) {
                this.cloudwatchMetric = cloudwatchMetric;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getDynamoDb}
             * @param dynamoDb Write to a DynamoDB table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDb(software.amazon.awscdk.IResolvable dynamoDb) {
                this.dynamoDb = dynamoDb;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getDynamoDb}
             * @param dynamoDb Write to a DynamoDB table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDb(software.amazon.awscdk.services.iot.CfnTopicRule.DynamoDBActionProperty dynamoDb) {
                this.dynamoDb = dynamoDb;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getDynamoDBv2}
             * @param dynamoDBv2 Write to a DynamoDB table.
             *                   This is a new version of the DynamoDB action. It allows you to write each attribute in an MQTT message payload into a separate DynamoDB column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDBv2(software.amazon.awscdk.IResolvable dynamoDBv2) {
                this.dynamoDBv2 = dynamoDBv2;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getDynamoDBv2}
             * @param dynamoDBv2 Write to a DynamoDB table.
             *                   This is a new version of the DynamoDB action. It allows you to write each attribute in an MQTT message payload into a separate DynamoDB column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamoDBv2(software.amazon.awscdk.services.iot.CfnTopicRule.DynamoDBv2ActionProperty dynamoDBv2) {
                this.dynamoDBv2 = dynamoDBv2;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getElasticsearch}
             * @param elasticsearch Write data to an Amazon OpenSearch Service domain.
             *                      <blockquote>
             *                      <p>
             *                      The <code>Elasticsearch</code> action can only be used by existing rule actions. To create a new rule action or to update an existing rule action, use the <code>OpenSearch</code> rule action instead. For more information, see <a href="https://docs.aws.amazon.com//iot/latest/apireference/API_OpenSearchAction.html">OpenSearchAction</a> .
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticsearch(software.amazon.awscdk.IResolvable elasticsearch) {
                this.elasticsearch = elasticsearch;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getElasticsearch}
             * @param elasticsearch Write data to an Amazon OpenSearch Service domain.
             *                      <blockquote>
             *                      <p>
             *                      The <code>Elasticsearch</code> action can only be used by existing rule actions. To create a new rule action or to update an existing rule action, use the <code>OpenSearch</code> rule action instead. For more information, see <a href="https://docs.aws.amazon.com//iot/latest/apireference/API_OpenSearchAction.html">OpenSearchAction</a> .
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticsearch(software.amazon.awscdk.services.iot.CfnTopicRule.ElasticsearchActionProperty elasticsearch) {
                this.elasticsearch = elasticsearch;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getFirehose}
             * @param firehose Write to an Amazon Kinesis Firehose stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firehose(software.amazon.awscdk.IResolvable firehose) {
                this.firehose = firehose;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getFirehose}
             * @param firehose Write to an Amazon Kinesis Firehose stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firehose(software.amazon.awscdk.services.iot.CfnTopicRule.FirehoseActionProperty firehose) {
                this.firehose = firehose;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getHttp}
             * @param http Send data to an HTTPS endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http(software.amazon.awscdk.IResolvable http) {
                this.http = http;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getHttp}
             * @param http Send data to an HTTPS endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http(software.amazon.awscdk.services.iot.CfnTopicRule.HttpActionProperty http) {
                this.http = http;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getIotAnalytics}
             * @param iotAnalytics Sends message data to an AWS IoT Analytics channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotAnalytics(software.amazon.awscdk.IResolvable iotAnalytics) {
                this.iotAnalytics = iotAnalytics;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getIotAnalytics}
             * @param iotAnalytics Sends message data to an AWS IoT Analytics channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotAnalytics(software.amazon.awscdk.services.iot.CfnTopicRule.IotAnalyticsActionProperty iotAnalytics) {
                this.iotAnalytics = iotAnalytics;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getIotEvents}
             * @param iotEvents Sends an input to an AWS IoT Events detector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotEvents(software.amazon.awscdk.IResolvable iotEvents) {
                this.iotEvents = iotEvents;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getIotEvents}
             * @param iotEvents Sends an input to an AWS IoT Events detector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotEvents(software.amazon.awscdk.services.iot.CfnTopicRule.IotEventsActionProperty iotEvents) {
                this.iotEvents = iotEvents;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getIotSiteWise}
             * @param iotSiteWise Sends data from the MQTT message that triggered the rule to AWS IoT SiteWise asset properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotSiteWise(software.amazon.awscdk.IResolvable iotSiteWise) {
                this.iotSiteWise = iotSiteWise;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getIotSiteWise}
             * @param iotSiteWise Sends data from the MQTT message that triggered the rule to AWS IoT SiteWise asset properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iotSiteWise(software.amazon.awscdk.services.iot.CfnTopicRule.IotSiteWiseActionProperty iotSiteWise) {
                this.iotSiteWise = iotSiteWise;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getKafka}
             * @param kafka Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kafka(software.amazon.awscdk.IResolvable kafka) {
                this.kafka = kafka;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getKafka}
             * @param kafka Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kafka(software.amazon.awscdk.services.iot.CfnTopicRule.KafkaActionProperty kafka) {
                this.kafka = kafka;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getKinesis}
             * @param kinesis Write data to an Amazon Kinesis stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesis(software.amazon.awscdk.IResolvable kinesis) {
                this.kinesis = kinesis;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getKinesis}
             * @param kinesis Write data to an Amazon Kinesis stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesis(software.amazon.awscdk.services.iot.CfnTopicRule.KinesisActionProperty kinesis) {
                this.kinesis = kinesis;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getLambda}
             * @param lambda Invoke a Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambda(software.amazon.awscdk.IResolvable lambda) {
                this.lambda = lambda;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getLambda}
             * @param lambda Invoke a Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambda(software.amazon.awscdk.services.iot.CfnTopicRule.LambdaActionProperty lambda) {
                this.lambda = lambda;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getLocation}
             * @param location Sends device location data to <a href="https://docs.aws.amazon.com//location/latest/developerguide/welcome.html">Amazon Location Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(software.amazon.awscdk.IResolvable location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getLocation}
             * @param location Sends device location data to <a href="https://docs.aws.amazon.com//location/latest/developerguide/welcome.html">Amazon Location Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(software.amazon.awscdk.services.iot.CfnTopicRule.LocationActionProperty location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getOpenSearch}
             * @param openSearch Write data to an Amazon OpenSearch Service domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openSearch(software.amazon.awscdk.IResolvable openSearch) {
                this.openSearch = openSearch;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getOpenSearch}
             * @param openSearch Write data to an Amazon OpenSearch Service domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openSearch(software.amazon.awscdk.services.iot.CfnTopicRule.OpenSearchActionProperty openSearch) {
                this.openSearch = openSearch;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getRepublish}
             * @param republish Publish to another MQTT topic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder republish(software.amazon.awscdk.IResolvable republish) {
                this.republish = republish;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getRepublish}
             * @param republish Publish to another MQTT topic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder republish(software.amazon.awscdk.services.iot.CfnTopicRule.RepublishActionProperty republish) {
                this.republish = republish;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getS3}
             * @param s3 Write to an Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getS3}
             * @param s3 Write to an Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.iot.CfnTopicRule.S3ActionProperty s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getSns}
             * @param sns Publish to an Amazon SNS topic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sns(software.amazon.awscdk.IResolvable sns) {
                this.sns = sns;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getSns}
             * @param sns Publish to an Amazon SNS topic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sns(software.amazon.awscdk.services.iot.CfnTopicRule.SnsActionProperty sns) {
                this.sns = sns;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getSqs}
             * @param sqs Publish to an Amazon SQS queue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqs(software.amazon.awscdk.IResolvable sqs) {
                this.sqs = sqs;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getSqs}
             * @param sqs Publish to an Amazon SQS queue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqs(software.amazon.awscdk.services.iot.CfnTopicRule.SqsActionProperty sqs) {
                this.sqs = sqs;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getStepFunctions}
             * @param stepFunctions Starts execution of a Step Functions state machine.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepFunctions(software.amazon.awscdk.IResolvable stepFunctions) {
                this.stepFunctions = stepFunctions;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getStepFunctions}
             * @param stepFunctions Starts execution of a Step Functions state machine.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stepFunctions(software.amazon.awscdk.services.iot.CfnTopicRule.StepFunctionsActionProperty stepFunctions) {
                this.stepFunctions = stepFunctions;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getTimestream}
             * @param timestream Writes attributes from an MQTT message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestream(software.amazon.awscdk.IResolvable timestream) {
                this.timestream = timestream;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getTimestream}
             * @param timestream Writes attributes from an MQTT message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestream(software.amazon.awscdk.services.iot.CfnTopicRule.TimestreamActionProperty timestream) {
                this.timestream = timestream;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionProperty {
            private final java.lang.Object cloudwatchAlarm;
            private final java.lang.Object cloudwatchLogs;
            private final java.lang.Object cloudwatchMetric;
            private final java.lang.Object dynamoDb;
            private final java.lang.Object dynamoDBv2;
            private final java.lang.Object elasticsearch;
            private final java.lang.Object firehose;
            private final java.lang.Object http;
            private final java.lang.Object iotAnalytics;
            private final java.lang.Object iotEvents;
            private final java.lang.Object iotSiteWise;
            private final java.lang.Object kafka;
            private final java.lang.Object kinesis;
            private final java.lang.Object lambda;
            private final java.lang.Object location;
            private final java.lang.Object openSearch;
            private final java.lang.Object republish;
            private final java.lang.Object s3;
            private final java.lang.Object sns;
            private final java.lang.Object sqs;
            private final java.lang.Object stepFunctions;
            private final java.lang.Object timestream;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudwatchAlarm = software.amazon.jsii.Kernel.get(this, "cloudwatchAlarm", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudwatchLogs = software.amazon.jsii.Kernel.get(this, "cloudwatchLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudwatchMetric = software.amazon.jsii.Kernel.get(this, "cloudwatchMetric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamoDb = software.amazon.jsii.Kernel.get(this, "dynamoDb", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamoDBv2 = software.amazon.jsii.Kernel.get(this, "dynamoDBv2", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.elasticsearch = software.amazon.jsii.Kernel.get(this, "elasticsearch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.firehose = software.amazon.jsii.Kernel.get(this, "firehose", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.http = software.amazon.jsii.Kernel.get(this, "http", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iotAnalytics = software.amazon.jsii.Kernel.get(this, "iotAnalytics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iotEvents = software.amazon.jsii.Kernel.get(this, "iotEvents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iotSiteWise = software.amazon.jsii.Kernel.get(this, "iotSiteWise", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kafka = software.amazon.jsii.Kernel.get(this, "kafka", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesis = software.amazon.jsii.Kernel.get(this, "kinesis", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambda = software.amazon.jsii.Kernel.get(this, "lambda", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.openSearch = software.amazon.jsii.Kernel.get(this, "openSearch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.republish = software.amazon.jsii.Kernel.get(this, "republish", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sns = software.amazon.jsii.Kernel.get(this, "sns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqs = software.amazon.jsii.Kernel.get(this, "sqs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stepFunctions = software.amazon.jsii.Kernel.get(this, "stepFunctions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timestream = software.amazon.jsii.Kernel.get(this, "timestream", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudwatchAlarm = builder.cloudwatchAlarm;
                this.cloudwatchLogs = builder.cloudwatchLogs;
                this.cloudwatchMetric = builder.cloudwatchMetric;
                this.dynamoDb = builder.dynamoDb;
                this.dynamoDBv2 = builder.dynamoDBv2;
                this.elasticsearch = builder.elasticsearch;
                this.firehose = builder.firehose;
                this.http = builder.http;
                this.iotAnalytics = builder.iotAnalytics;
                this.iotEvents = builder.iotEvents;
                this.iotSiteWise = builder.iotSiteWise;
                this.kafka = builder.kafka;
                this.kinesis = builder.kinesis;
                this.lambda = builder.lambda;
                this.location = builder.location;
                this.openSearch = builder.openSearch;
                this.republish = builder.republish;
                this.s3 = builder.s3;
                this.sns = builder.sns;
                this.sqs = builder.sqs;
                this.stepFunctions = builder.stepFunctions;
                this.timestream = builder.timestream;
            }

            @Override
            public final java.lang.Object getCloudwatchAlarm() {
                return this.cloudwatchAlarm;
            }

            @Override
            public final java.lang.Object getCloudwatchLogs() {
                return this.cloudwatchLogs;
            }

            @Override
            public final java.lang.Object getCloudwatchMetric() {
                return this.cloudwatchMetric;
            }

            @Override
            public final java.lang.Object getDynamoDb() {
                return this.dynamoDb;
            }

            @Override
            public final java.lang.Object getDynamoDBv2() {
                return this.dynamoDBv2;
            }

            @Override
            public final java.lang.Object getElasticsearch() {
                return this.elasticsearch;
            }

            @Override
            public final java.lang.Object getFirehose() {
                return this.firehose;
            }

            @Override
            public final java.lang.Object getHttp() {
                return this.http;
            }

            @Override
            public final java.lang.Object getIotAnalytics() {
                return this.iotAnalytics;
            }

            @Override
            public final java.lang.Object getIotEvents() {
                return this.iotEvents;
            }

            @Override
            public final java.lang.Object getIotSiteWise() {
                return this.iotSiteWise;
            }

            @Override
            public final java.lang.Object getKafka() {
                return this.kafka;
            }

            @Override
            public final java.lang.Object getKinesis() {
                return this.kinesis;
            }

            @Override
            public final java.lang.Object getLambda() {
                return this.lambda;
            }

            @Override
            public final java.lang.Object getLocation() {
                return this.location;
            }

            @Override
            public final java.lang.Object getOpenSearch() {
                return this.openSearch;
            }

            @Override
            public final java.lang.Object getRepublish() {
                return this.republish;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            public final java.lang.Object getSns() {
                return this.sns;
            }

            @Override
            public final java.lang.Object getSqs() {
                return this.sqs;
            }

            @Override
            public final java.lang.Object getStepFunctions() {
                return this.stepFunctions;
            }

            @Override
            public final java.lang.Object getTimestream() {
                return this.timestream;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudwatchAlarm() != null) {
                    data.set("cloudwatchAlarm", om.valueToTree(this.getCloudwatchAlarm()));
                }
                if (this.getCloudwatchLogs() != null) {
                    data.set("cloudwatchLogs", om.valueToTree(this.getCloudwatchLogs()));
                }
                if (this.getCloudwatchMetric() != null) {
                    data.set("cloudwatchMetric", om.valueToTree(this.getCloudwatchMetric()));
                }
                if (this.getDynamoDb() != null) {
                    data.set("dynamoDb", om.valueToTree(this.getDynamoDb()));
                }
                if (this.getDynamoDBv2() != null) {
                    data.set("dynamoDBv2", om.valueToTree(this.getDynamoDBv2()));
                }
                if (this.getElasticsearch() != null) {
                    data.set("elasticsearch", om.valueToTree(this.getElasticsearch()));
                }
                if (this.getFirehose() != null) {
                    data.set("firehose", om.valueToTree(this.getFirehose()));
                }
                if (this.getHttp() != null) {
                    data.set("http", om.valueToTree(this.getHttp()));
                }
                if (this.getIotAnalytics() != null) {
                    data.set("iotAnalytics", om.valueToTree(this.getIotAnalytics()));
                }
                if (this.getIotEvents() != null) {
                    data.set("iotEvents", om.valueToTree(this.getIotEvents()));
                }
                if (this.getIotSiteWise() != null) {
                    data.set("iotSiteWise", om.valueToTree(this.getIotSiteWise()));
                }
                if (this.getKafka() != null) {
                    data.set("kafka", om.valueToTree(this.getKafka()));
                }
                if (this.getKinesis() != null) {
                    data.set("kinesis", om.valueToTree(this.getKinesis()));
                }
                if (this.getLambda() != null) {
                    data.set("lambda", om.valueToTree(this.getLambda()));
                }
                if (this.getLocation() != null) {
                    data.set("location", om.valueToTree(this.getLocation()));
                }
                if (this.getOpenSearch() != null) {
                    data.set("openSearch", om.valueToTree(this.getOpenSearch()));
                }
                if (this.getRepublish() != null) {
                    data.set("republish", om.valueToTree(this.getRepublish()));
                }
                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }
                if (this.getSns() != null) {
                    data.set("sns", om.valueToTree(this.getSns()));
                }
                if (this.getSqs() != null) {
                    data.set("sqs", om.valueToTree(this.getSqs()));
                }
                if (this.getStepFunctions() != null) {
                    data.set("stepFunctions", om.valueToTree(this.getStepFunctions()));
                }
                if (this.getTimestream() != null) {
                    data.set("timestream", om.valueToTree(this.getTimestream()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.ActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionProperty.Jsii$Proxy that = (ActionProperty.Jsii$Proxy) o;

                if (this.cloudwatchAlarm != null ? !this.cloudwatchAlarm.equals(that.cloudwatchAlarm) : that.cloudwatchAlarm != null) return false;
                if (this.cloudwatchLogs != null ? !this.cloudwatchLogs.equals(that.cloudwatchLogs) : that.cloudwatchLogs != null) return false;
                if (this.cloudwatchMetric != null ? !this.cloudwatchMetric.equals(that.cloudwatchMetric) : that.cloudwatchMetric != null) return false;
                if (this.dynamoDb != null ? !this.dynamoDb.equals(that.dynamoDb) : that.dynamoDb != null) return false;
                if (this.dynamoDBv2 != null ? !this.dynamoDBv2.equals(that.dynamoDBv2) : that.dynamoDBv2 != null) return false;
                if (this.elasticsearch != null ? !this.elasticsearch.equals(that.elasticsearch) : that.elasticsearch != null) return false;
                if (this.firehose != null ? !this.firehose.equals(that.firehose) : that.firehose != null) return false;
                if (this.http != null ? !this.http.equals(that.http) : that.http != null) return false;
                if (this.iotAnalytics != null ? !this.iotAnalytics.equals(that.iotAnalytics) : that.iotAnalytics != null) return false;
                if (this.iotEvents != null ? !this.iotEvents.equals(that.iotEvents) : that.iotEvents != null) return false;
                if (this.iotSiteWise != null ? !this.iotSiteWise.equals(that.iotSiteWise) : that.iotSiteWise != null) return false;
                if (this.kafka != null ? !this.kafka.equals(that.kafka) : that.kafka != null) return false;
                if (this.kinesis != null ? !this.kinesis.equals(that.kinesis) : that.kinesis != null) return false;
                if (this.lambda != null ? !this.lambda.equals(that.lambda) : that.lambda != null) return false;
                if (this.location != null ? !this.location.equals(that.location) : that.location != null) return false;
                if (this.openSearch != null ? !this.openSearch.equals(that.openSearch) : that.openSearch != null) return false;
                if (this.republish != null ? !this.republish.equals(that.republish) : that.republish != null) return false;
                if (this.s3 != null ? !this.s3.equals(that.s3) : that.s3 != null) return false;
                if (this.sns != null ? !this.sns.equals(that.sns) : that.sns != null) return false;
                if (this.sqs != null ? !this.sqs.equals(that.sqs) : that.sqs != null) return false;
                if (this.stepFunctions != null ? !this.stepFunctions.equals(that.stepFunctions) : that.stepFunctions != null) return false;
                return this.timestream != null ? this.timestream.equals(that.timestream) : that.timestream == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudwatchAlarm != null ? this.cloudwatchAlarm.hashCode() : 0;
                result = 31 * result + (this.cloudwatchLogs != null ? this.cloudwatchLogs.hashCode() : 0);
                result = 31 * result + (this.cloudwatchMetric != null ? this.cloudwatchMetric.hashCode() : 0);
                result = 31 * result + (this.dynamoDb != null ? this.dynamoDb.hashCode() : 0);
                result = 31 * result + (this.dynamoDBv2 != null ? this.dynamoDBv2.hashCode() : 0);
                result = 31 * result + (this.elasticsearch != null ? this.elasticsearch.hashCode() : 0);
                result = 31 * result + (this.firehose != null ? this.firehose.hashCode() : 0);
                result = 31 * result + (this.http != null ? this.http.hashCode() : 0);
                result = 31 * result + (this.iotAnalytics != null ? this.iotAnalytics.hashCode() : 0);
                result = 31 * result + (this.iotEvents != null ? this.iotEvents.hashCode() : 0);
                result = 31 * result + (this.iotSiteWise != null ? this.iotSiteWise.hashCode() : 0);
                result = 31 * result + (this.kafka != null ? this.kafka.hashCode() : 0);
                result = 31 * result + (this.kinesis != null ? this.kinesis.hashCode() : 0);
                result = 31 * result + (this.lambda != null ? this.lambda.hashCode() : 0);
                result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
                result = 31 * result + (this.openSearch != null ? this.openSearch.hashCode() : 0);
                result = 31 * result + (this.republish != null ? this.republish.hashCode() : 0);
                result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
                result = 31 * result + (this.sns != null ? this.sns.hashCode() : 0);
                result = 31 * result + (this.sqs != null ? this.sqs.hashCode() : 0);
                result = 31 * result + (this.stepFunctions != null ? this.stepFunctions.hashCode() : 0);
                result = 31 * result + (this.timestream != null ? this.timestream.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An asset property timestamp entry containing the following information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * AssetPropertyTimestampProperty assetPropertyTimestampProperty = AssetPropertyTimestampProperty.builder()
     *         .timeInSeconds("timeInSeconds")
     *         // the properties below are optional
     *         .offsetInNanos("offsetInNanos")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertytimestamp.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertytimestamp.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.AssetPropertyTimestampProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetPropertyTimestampProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetPropertyTimestampProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A string that contains the time in seconds since epoch.
         * <p>
         * Accepts substitution templates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertytimestamp.html#cfn-iot-topicrule-assetpropertytimestamp-timeinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertytimestamp.html#cfn-iot-topicrule-assetpropertytimestamp-timeinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimeInSeconds();

        /**
         * Optional.
         * <p>
         * A string that contains the nanosecond time offset. Accepts substitution templates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertytimestamp.html#cfn-iot-topicrule-assetpropertytimestamp-offsetinnanos">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertytimestamp.html#cfn-iot-topicrule-assetpropertytimestamp-offsetinnanos</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOffsetInNanos() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetPropertyTimestampProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetPropertyTimestampProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetPropertyTimestampProperty> {
            java.lang.String timeInSeconds;
            java.lang.String offsetInNanos;

            /**
             * Sets the value of {@link AssetPropertyTimestampProperty#getTimeInSeconds}
             * @param timeInSeconds A string that contains the time in seconds since epoch. This parameter is required.
             *                      Accepts substitution templates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeInSeconds(java.lang.String timeInSeconds) {
                this.timeInSeconds = timeInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyTimestampProperty#getOffsetInNanos}
             * @param offsetInNanos Optional.
             *                      A string that contains the nanosecond time offset. Accepts substitution templates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder offsetInNanos(java.lang.String offsetInNanos) {
                this.offsetInNanos = offsetInNanos;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetPropertyTimestampProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetPropertyTimestampProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetPropertyTimestampProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetPropertyTimestampProperty {
            private final java.lang.String timeInSeconds;
            private final java.lang.String offsetInNanos;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timeInSeconds = software.amazon.jsii.Kernel.get(this, "timeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.offsetInNanos = software.amazon.jsii.Kernel.get(this, "offsetInNanos", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timeInSeconds = java.util.Objects.requireNonNull(builder.timeInSeconds, "timeInSeconds is required");
                this.offsetInNanos = builder.offsetInNanos;
            }

            @Override
            public final java.lang.String getTimeInSeconds() {
                return this.timeInSeconds;
            }

            @Override
            public final java.lang.String getOffsetInNanos() {
                return this.offsetInNanos;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("timeInSeconds", om.valueToTree(this.getTimeInSeconds()));
                if (this.getOffsetInNanos() != null) {
                    data.set("offsetInNanos", om.valueToTree(this.getOffsetInNanos()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.AssetPropertyTimestampProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetPropertyTimestampProperty.Jsii$Proxy that = (AssetPropertyTimestampProperty.Jsii$Proxy) o;

                if (!timeInSeconds.equals(that.timeInSeconds)) return false;
                return this.offsetInNanos != null ? this.offsetInNanos.equals(that.offsetInNanos) : that.offsetInNanos == null;
            }

            @Override
            public final int hashCode() {
                int result = this.timeInSeconds.hashCode();
                result = 31 * result + (this.offsetInNanos != null ? this.offsetInNanos.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An asset property value entry containing the following information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * AssetPropertyValueProperty assetPropertyValueProperty = AssetPropertyValueProperty.builder()
     *         .timestamp(AssetPropertyTimestampProperty.builder()
     *                 .timeInSeconds("timeInSeconds")
     *                 // the properties below are optional
     *                 .offsetInNanos("offsetInNanos")
     *                 .build())
     *         .value(AssetPropertyVariantProperty.builder()
     *                 .booleanValue("booleanValue")
     *                 .doubleValue("doubleValue")
     *                 .integerValue("integerValue")
     *                 .stringValue("stringValue")
     *                 .build())
     *         // the properties below are optional
     *         .quality("quality")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.AssetPropertyValueProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetPropertyValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetPropertyValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The asset property value timestamp.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvalue.html#cfn-iot-topicrule-assetpropertyvalue-timestamp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvalue.html#cfn-iot-topicrule-assetpropertyvalue-timestamp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTimestamp();

        /**
         * The value of the asset property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvalue.html#cfn-iot-topicrule-assetpropertyvalue-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvalue.html#cfn-iot-topicrule-assetpropertyvalue-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValue();

        /**
         * Optional.
         * <p>
         * A string that describes the quality of the value. Accepts substitution templates. Must be <code>GOOD</code> , <code>BAD</code> , or <code>UNCERTAIN</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvalue.html#cfn-iot-topicrule-assetpropertyvalue-quality">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvalue.html#cfn-iot-topicrule-assetpropertyvalue-quality</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQuality() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetPropertyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetPropertyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetPropertyValueProperty> {
            java.lang.Object timestamp;
            java.lang.Object value;
            java.lang.String quality;

            /**
             * Sets the value of {@link AssetPropertyValueProperty#getTimestamp}
             * @param timestamp The asset property value timestamp. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestamp(software.amazon.awscdk.IResolvable timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyValueProperty#getTimestamp}
             * @param timestamp The asset property value timestamp. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestamp(software.amazon.awscdk.services.iot.CfnTopicRule.AssetPropertyTimestampProperty timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyValueProperty#getValue}
             * @param value The value of the asset property. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyValueProperty#getValue}
             * @param value The value of the asset property. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.iot.CfnTopicRule.AssetPropertyVariantProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyValueProperty#getQuality}
             * @param quality Optional.
             *                A string that describes the quality of the value. Accepts substitution templates. Must be <code>GOOD</code> , <code>BAD</code> , or <code>UNCERTAIN</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quality(java.lang.String quality) {
                this.quality = quality;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetPropertyValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetPropertyValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetPropertyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetPropertyValueProperty {
            private final java.lang.Object timestamp;
            private final java.lang.Object value;
            private final java.lang.String quality;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timestamp = software.amazon.jsii.Kernel.get(this, "timestamp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.quality = software.amazon.jsii.Kernel.get(this, "quality", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timestamp = java.util.Objects.requireNonNull(builder.timestamp, "timestamp is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
                this.quality = builder.quality;
            }

            @Override
            public final java.lang.Object getTimestamp() {
                return this.timestamp;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            public final java.lang.String getQuality() {
                return this.quality;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("timestamp", om.valueToTree(this.getTimestamp()));
                data.set("value", om.valueToTree(this.getValue()));
                if (this.getQuality() != null) {
                    data.set("quality", om.valueToTree(this.getQuality()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.AssetPropertyValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetPropertyValueProperty.Jsii$Proxy that = (AssetPropertyValueProperty.Jsii$Proxy) o;

                if (!timestamp.equals(that.timestamp)) return false;
                if (!value.equals(that.value)) return false;
                return this.quality != null ? this.quality.equals(that.quality) : that.quality == null;
            }

            @Override
            public final int hashCode() {
                int result = this.timestamp.hashCode();
                result = 31 * result + (this.value.hashCode());
                result = 31 * result + (this.quality != null ? this.quality.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains an asset property value (of a single type).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * AssetPropertyVariantProperty assetPropertyVariantProperty = AssetPropertyVariantProperty.builder()
     *         .booleanValue("booleanValue")
     *         .doubleValue("doubleValue")
     *         .integerValue("integerValue")
     *         .stringValue("stringValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.AssetPropertyVariantProperty")
    @software.amazon.jsii.Jsii.Proxy(AssetPropertyVariantProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssetPropertyVariantProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Optional.
         * <p>
         * A string that contains the boolean value ( <code>true</code> or <code>false</code> ) of the value entry. Accepts substitution templates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html#cfn-iot-topicrule-assetpropertyvariant-booleanvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html#cfn-iot-topicrule-assetpropertyvariant-booleanvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBooleanValue() {
            return null;
        }

        /**
         * Optional.
         * <p>
         * A string that contains the double value of the value entry. Accepts substitution templates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html#cfn-iot-topicrule-assetpropertyvariant-doublevalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html#cfn-iot-topicrule-assetpropertyvariant-doublevalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDoubleValue() {
            return null;
        }

        /**
         * Optional.
         * <p>
         * A string that contains the integer value of the value entry. Accepts substitution templates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html#cfn-iot-topicrule-assetpropertyvariant-integervalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html#cfn-iot-topicrule-assetpropertyvariant-integervalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntegerValue() {
            return null;
        }

        /**
         * Optional.
         * <p>
         * The string value of the value entry. Accepts substitution templates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html#cfn-iot-topicrule-assetpropertyvariant-stringvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html#cfn-iot-topicrule-assetpropertyvariant-stringvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStringValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssetPropertyVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssetPropertyVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssetPropertyVariantProperty> {
            java.lang.String booleanValue;
            java.lang.String doubleValue;
            java.lang.String integerValue;
            java.lang.String stringValue;

            /**
             * Sets the value of {@link AssetPropertyVariantProperty#getBooleanValue}
             * @param booleanValue Optional.
             *                     A string that contains the boolean value ( <code>true</code> or <code>false</code> ) of the value entry. Accepts substitution templates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanValue(java.lang.String booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyVariantProperty#getDoubleValue}
             * @param doubleValue Optional.
             *                    A string that contains the double value of the value entry. Accepts substitution templates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder doubleValue(java.lang.String doubleValue) {
                this.doubleValue = doubleValue;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyVariantProperty#getIntegerValue}
             * @param integerValue Optional.
             *                     A string that contains the integer value of the value entry. Accepts substitution templates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerValue(java.lang.String integerValue) {
                this.integerValue = integerValue;
                return this;
            }

            /**
             * Sets the value of {@link AssetPropertyVariantProperty#getStringValue}
             * @param stringValue Optional.
             *                    The string value of the value entry. Accepts substitution templates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringValue(java.lang.String stringValue) {
                this.stringValue = stringValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssetPropertyVariantProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssetPropertyVariantProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssetPropertyVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetPropertyVariantProperty {
            private final java.lang.String booleanValue;
            private final java.lang.String doubleValue;
            private final java.lang.String integerValue;
            private final java.lang.String stringValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.booleanValue = software.amazon.jsii.Kernel.get(this, "booleanValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.doubleValue = software.amazon.jsii.Kernel.get(this, "doubleValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.integerValue = software.amazon.jsii.Kernel.get(this, "integerValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stringValue = software.amazon.jsii.Kernel.get(this, "stringValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.booleanValue = builder.booleanValue;
                this.doubleValue = builder.doubleValue;
                this.integerValue = builder.integerValue;
                this.stringValue = builder.stringValue;
            }

            @Override
            public final java.lang.String getBooleanValue() {
                return this.booleanValue;
            }

            @Override
            public final java.lang.String getDoubleValue() {
                return this.doubleValue;
            }

            @Override
            public final java.lang.String getIntegerValue() {
                return this.integerValue;
            }

            @Override
            public final java.lang.String getStringValue() {
                return this.stringValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBooleanValue() != null) {
                    data.set("booleanValue", om.valueToTree(this.getBooleanValue()));
                }
                if (this.getDoubleValue() != null) {
                    data.set("doubleValue", om.valueToTree(this.getDoubleValue()));
                }
                if (this.getIntegerValue() != null) {
                    data.set("integerValue", om.valueToTree(this.getIntegerValue()));
                }
                if (this.getStringValue() != null) {
                    data.set("stringValue", om.valueToTree(this.getStringValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.AssetPropertyVariantProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssetPropertyVariantProperty.Jsii$Proxy that = (AssetPropertyVariantProperty.Jsii$Proxy) o;

                if (this.booleanValue != null ? !this.booleanValue.equals(that.booleanValue) : that.booleanValue != null) return false;
                if (this.doubleValue != null ? !this.doubleValue.equals(that.doubleValue) : that.doubleValue != null) return false;
                if (this.integerValue != null ? !this.integerValue.equals(that.integerValue) : that.integerValue != null) return false;
                return this.stringValue != null ? this.stringValue.equals(that.stringValue) : that.stringValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.booleanValue != null ? this.booleanValue.hashCode() : 0;
                result = 31 * result + (this.doubleValue != null ? this.doubleValue.hashCode() : 0);
                result = 31 * result + (this.integerValue != null ? this.integerValue.hashCode() : 0);
                result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an action that updates a CloudWatch alarm.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * CloudwatchAlarmActionProperty cloudwatchAlarmActionProperty = CloudwatchAlarmActionProperty.builder()
     *         .alarmName("alarmName")
     *         .roleArn("roleArn")
     *         .stateReason("stateReason")
     *         .stateValue("stateValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.CloudwatchAlarmActionProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudwatchAlarmActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudwatchAlarmActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CloudWatch alarm name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-alarmname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-alarmname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlarmName();

        /**
         * The IAM role that allows access to the CloudWatch alarm.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The reason for the alarm change.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-statereason">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-statereason</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStateReason();

        /**
         * The value of the alarm state.
         * <p>
         * Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-statevalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-statevalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStateValue();

        /**
         * @return a {@link Builder} of {@link CloudwatchAlarmActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudwatchAlarmActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudwatchAlarmActionProperty> {
            java.lang.String alarmName;
            java.lang.String roleArn;
            java.lang.String stateReason;
            java.lang.String stateValue;

            /**
             * Sets the value of {@link CloudwatchAlarmActionProperty#getAlarmName}
             * @param alarmName The CloudWatch alarm name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmName(java.lang.String alarmName) {
                this.alarmName = alarmName;
                return this;
            }

            /**
             * Sets the value of {@link CloudwatchAlarmActionProperty#getRoleArn}
             * @param roleArn The IAM role that allows access to the CloudWatch alarm. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link CloudwatchAlarmActionProperty#getStateReason}
             * @param stateReason The reason for the alarm change. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stateReason(java.lang.String stateReason) {
                this.stateReason = stateReason;
                return this;
            }

            /**
             * Sets the value of {@link CloudwatchAlarmActionProperty#getStateValue}
             * @param stateValue The value of the alarm state. This parameter is required.
             *                   Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stateValue(java.lang.String stateValue) {
                this.stateValue = stateValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudwatchAlarmActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudwatchAlarmActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudwatchAlarmActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudwatchAlarmActionProperty {
            private final java.lang.String alarmName;
            private final java.lang.String roleArn;
            private final java.lang.String stateReason;
            private final java.lang.String stateValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarmName = software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stateReason = software.amazon.jsii.Kernel.get(this, "stateReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stateValue = software.amazon.jsii.Kernel.get(this, "stateValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarmName = java.util.Objects.requireNonNull(builder.alarmName, "alarmName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.stateReason = java.util.Objects.requireNonNull(builder.stateReason, "stateReason is required");
                this.stateValue = java.util.Objects.requireNonNull(builder.stateValue, "stateValue is required");
            }

            @Override
            public final java.lang.String getAlarmName() {
                return this.alarmName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getStateReason() {
                return this.stateReason;
            }

            @Override
            public final java.lang.String getStateValue() {
                return this.stateValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alarmName", om.valueToTree(this.getAlarmName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("stateReason", om.valueToTree(this.getStateReason()));
                data.set("stateValue", om.valueToTree(this.getStateValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.CloudwatchAlarmActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudwatchAlarmActionProperty.Jsii$Proxy that = (CloudwatchAlarmActionProperty.Jsii$Proxy) o;

                if (!alarmName.equals(that.alarmName)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!stateReason.equals(that.stateReason)) return false;
                return this.stateValue.equals(that.stateValue);
            }

            @Override
            public final int hashCode() {
                int result = this.alarmName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.stateReason.hashCode());
                result = 31 * result + (this.stateValue.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes an action that updates a CloudWatch log.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * CloudwatchLogsActionProperty cloudwatchLogsActionProperty = CloudwatchLogsActionProperty.builder()
     *         .logGroupName("logGroupName")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .batchMode(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchlogsaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchlogsaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.CloudwatchLogsActionProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudwatchLogsActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudwatchLogsActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CloudWatch log name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchlogsaction.html#cfn-iot-topicrule-cloudwatchlogsaction-loggroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchlogsaction.html#cfn-iot-topicrule-cloudwatchlogsaction-loggroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogGroupName();

        /**
         * The IAM role that allows access to the CloudWatch log.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchlogsaction.html#cfn-iot-topicrule-cloudwatchlogsaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchlogsaction.html#cfn-iot-topicrule-cloudwatchlogsaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * Indicates whether batches of log records will be extracted and uploaded into CloudWatch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchlogsaction.html#cfn-iot-topicrule-cloudwatchlogsaction-batchmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchlogsaction.html#cfn-iot-topicrule-cloudwatchlogsaction-batchmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBatchMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudwatchLogsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudwatchLogsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudwatchLogsActionProperty> {
            java.lang.String logGroupName;
            java.lang.String roleArn;
            java.lang.Object batchMode;

            /**
             * Sets the value of {@link CloudwatchLogsActionProperty#getLogGroupName}
             * @param logGroupName The CloudWatch log name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupName(java.lang.String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            /**
             * Sets the value of {@link CloudwatchLogsActionProperty#getRoleArn}
             * @param roleArn The IAM role that allows access to the CloudWatch log. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link CloudwatchLogsActionProperty#getBatchMode}
             * @param batchMode Indicates whether batches of log records will be extracted and uploaded into CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchMode(java.lang.Boolean batchMode) {
                this.batchMode = batchMode;
                return this;
            }

            /**
             * Sets the value of {@link CloudwatchLogsActionProperty#getBatchMode}
             * @param batchMode Indicates whether batches of log records will be extracted and uploaded into CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchMode(software.amazon.awscdk.IResolvable batchMode) {
                this.batchMode = batchMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudwatchLogsActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudwatchLogsActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudwatchLogsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudwatchLogsActionProperty {
            private final java.lang.String logGroupName;
            private final java.lang.String roleArn;
            private final java.lang.Object batchMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.batchMode = software.amazon.jsii.Kernel.get(this, "batchMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logGroupName = java.util.Objects.requireNonNull(builder.logGroupName, "logGroupName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.batchMode = builder.batchMode;
            }

            @Override
            public final java.lang.String getLogGroupName() {
                return this.logGroupName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getBatchMode() {
                return this.batchMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getBatchMode() != null) {
                    data.set("batchMode", om.valueToTree(this.getBatchMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.CloudwatchLogsActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudwatchLogsActionProperty.Jsii$Proxy that = (CloudwatchLogsActionProperty.Jsii$Proxy) o;

                if (!logGroupName.equals(that.logGroupName)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                return this.batchMode != null ? this.batchMode.equals(that.batchMode) : that.batchMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logGroupName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.batchMode != null ? this.batchMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an action that captures a CloudWatch metric.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * CloudwatchMetricActionProperty cloudwatchMetricActionProperty = CloudwatchMetricActionProperty.builder()
     *         .metricName("metricName")
     *         .metricNamespace("metricNamespace")
     *         .metricUnit("metricUnit")
     *         .metricValue("metricValue")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .metricTimestamp("metricTimestamp")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.CloudwatchMetricActionProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudwatchMetricActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudwatchMetricActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CloudWatch metric name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * The CloudWatch metric namespace name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricnamespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricnamespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricNamespace();

        /**
         * The <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit">metric unit</a> supported by CloudWatch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricUnit();

        /**
         * The CloudWatch metric value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricValue();

        /**
         * The IAM role that allows access to the CloudWatch metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * An optional <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp">Unix timestamp</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metrictimestamp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metrictimestamp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricTimestamp() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudwatchMetricActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudwatchMetricActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudwatchMetricActionProperty> {
            java.lang.String metricName;
            java.lang.String metricNamespace;
            java.lang.String metricUnit;
            java.lang.String metricValue;
            java.lang.String roleArn;
            java.lang.String metricTimestamp;

            /**
             * Sets the value of {@link CloudwatchMetricActionProperty#getMetricName}
             * @param metricName The CloudWatch metric name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link CloudwatchMetricActionProperty#getMetricNamespace}
             * @param metricNamespace The CloudWatch metric namespace name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricNamespace(java.lang.String metricNamespace) {
                this.metricNamespace = metricNamespace;
                return this;
            }

            /**
             * Sets the value of {@link CloudwatchMetricActionProperty#getMetricUnit}
             * @param metricUnit The <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit">metric unit</a> supported by CloudWatch. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricUnit(java.lang.String metricUnit) {
                this.metricUnit = metricUnit;
                return this;
            }

            /**
             * Sets the value of {@link CloudwatchMetricActionProperty#getMetricValue}
             * @param metricValue The CloudWatch metric value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricValue(java.lang.String metricValue) {
                this.metricValue = metricValue;
                return this;
            }

            /**
             * Sets the value of {@link CloudwatchMetricActionProperty#getRoleArn}
             * @param roleArn The IAM role that allows access to the CloudWatch metric. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link CloudwatchMetricActionProperty#getMetricTimestamp}
             * @param metricTimestamp An optional <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp">Unix timestamp</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricTimestamp(java.lang.String metricTimestamp) {
                this.metricTimestamp = metricTimestamp;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudwatchMetricActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudwatchMetricActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudwatchMetricActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudwatchMetricActionProperty {
            private final java.lang.String metricName;
            private final java.lang.String metricNamespace;
            private final java.lang.String metricUnit;
            private final java.lang.String metricValue;
            private final java.lang.String roleArn;
            private final java.lang.String metricTimestamp;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricNamespace = software.amazon.jsii.Kernel.get(this, "metricNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricUnit = software.amazon.jsii.Kernel.get(this, "metricUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricValue = software.amazon.jsii.Kernel.get(this, "metricValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricTimestamp = software.amazon.jsii.Kernel.get(this, "metricTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.metricNamespace = java.util.Objects.requireNonNull(builder.metricNamespace, "metricNamespace is required");
                this.metricUnit = java.util.Objects.requireNonNull(builder.metricUnit, "metricUnit is required");
                this.metricValue = java.util.Objects.requireNonNull(builder.metricValue, "metricValue is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.metricTimestamp = builder.metricTimestamp;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getMetricNamespace() {
                return this.metricNamespace;
            }

            @Override
            public final java.lang.String getMetricUnit() {
                return this.metricUnit;
            }

            @Override
            public final java.lang.String getMetricValue() {
                return this.metricValue;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getMetricTimestamp() {
                return this.metricTimestamp;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("metricNamespace", om.valueToTree(this.getMetricNamespace()));
                data.set("metricUnit", om.valueToTree(this.getMetricUnit()));
                data.set("metricValue", om.valueToTree(this.getMetricValue()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getMetricTimestamp() != null) {
                    data.set("metricTimestamp", om.valueToTree(this.getMetricTimestamp()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.CloudwatchMetricActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudwatchMetricActionProperty.Jsii$Proxy that = (CloudwatchMetricActionProperty.Jsii$Proxy) o;

                if (!metricName.equals(that.metricName)) return false;
                if (!metricNamespace.equals(that.metricNamespace)) return false;
                if (!metricUnit.equals(that.metricUnit)) return false;
                if (!metricValue.equals(that.metricValue)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                return this.metricTimestamp != null ? this.metricTimestamp.equals(that.metricTimestamp) : that.metricTimestamp == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metricName.hashCode();
                result = 31 * result + (this.metricNamespace.hashCode());
                result = 31 * result + (this.metricUnit.hashCode());
                result = 31 * result + (this.metricValue.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.metricTimestamp != null ? this.metricTimestamp.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an action to write to a DynamoDB table.
     * <p>
     * The <code>tableName</code> , <code>hashKeyField</code> , and <code>rangeKeyField</code> values must match the values used when you created the table.
     * <p>
     * The <code>hashKeyValue</code> and <code>rangeKeyvalue</code> fields use a substitution template syntax. These templates provide data at runtime. The syntax is as follows: ${ <em>sql-expression</em> }.
     * <p>
     * You can specify any valid expression in a WHERE or SELECT clause, including JSON properties, comparisons, calculations, and functions. For example, the following field uses the third level of the topic:
     * <p>
     * <code>"hashKeyValue": "${topic(3)}"</code>
     * <p>
     * The following field uses the timestamp:
     * <p>
     * <code>"rangeKeyValue": "${timestamp()}"</code>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-rule-actions.html">DynamoDBv2 Action</a> in the <em>AWS IoT Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * DynamoDBActionProperty dynamoDBActionProperty = DynamoDBActionProperty.builder()
     *         .hashKeyField("hashKeyField")
     *         .hashKeyValue("hashKeyValue")
     *         .roleArn("roleArn")
     *         .tableName("tableName")
     *         // the properties below are optional
     *         .hashKeyType("hashKeyType")
     *         .payloadField("payloadField")
     *         .rangeKeyField("rangeKeyField")
     *         .rangeKeyType("rangeKeyType")
     *         .rangeKeyValue("rangeKeyValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.DynamoDBActionProperty")
    @software.amazon.jsii.Jsii.Proxy(DynamoDBActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamoDBActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The hash key name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-hashkeyfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-hashkeyfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHashKeyField();

        /**
         * The hash key value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-hashkeyvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-hashkeyvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHashKeyValue();

        /**
         * The ARN of the IAM role that grants access to the DynamoDB table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The name of the DynamoDB table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * The hash key type.
         * <p>
         * Valid values are "STRING" or "NUMBER"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-hashkeytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-hashkeytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHashKeyType() {
            return null;
        }

        /**
         * The action payload.
         * <p>
         * This name can be customized.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-payloadfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-payloadfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPayloadField() {
            return null;
        }

        /**
         * The range key name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rangekeyfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rangekeyfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRangeKeyField() {
            return null;
        }

        /**
         * The range key type.
         * <p>
         * Valid values are "STRING" or "NUMBER"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rangekeytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rangekeytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRangeKeyType() {
            return null;
        }

        /**
         * The range key value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rangekeyvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rangekeyvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRangeKeyValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamoDBActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamoDBActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamoDBActionProperty> {
            java.lang.String hashKeyField;
            java.lang.String hashKeyValue;
            java.lang.String roleArn;
            java.lang.String tableName;
            java.lang.String hashKeyType;
            java.lang.String payloadField;
            java.lang.String rangeKeyField;
            java.lang.String rangeKeyType;
            java.lang.String rangeKeyValue;

            /**
             * Sets the value of {@link DynamoDBActionProperty#getHashKeyField}
             * @param hashKeyField The hash key name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hashKeyField(java.lang.String hashKeyField) {
                this.hashKeyField = hashKeyField;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBActionProperty#getHashKeyValue}
             * @param hashKeyValue The hash key value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hashKeyValue(java.lang.String hashKeyValue) {
                this.hashKeyValue = hashKeyValue;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBActionProperty#getRoleArn}
             * @param roleArn The ARN of the IAM role that grants access to the DynamoDB table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBActionProperty#getTableName}
             * @param tableName The name of the DynamoDB table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBActionProperty#getHashKeyType}
             * @param hashKeyType The hash key type.
             *                    Valid values are "STRING" or "NUMBER"
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hashKeyType(java.lang.String hashKeyType) {
                this.hashKeyType = hashKeyType;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBActionProperty#getPayloadField}
             * @param payloadField The action payload.
             *                     This name can be customized.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payloadField(java.lang.String payloadField) {
                this.payloadField = payloadField;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBActionProperty#getRangeKeyField}
             * @param rangeKeyField The range key name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeKeyField(java.lang.String rangeKeyField) {
                this.rangeKeyField = rangeKeyField;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBActionProperty#getRangeKeyType}
             * @param rangeKeyType The range key type.
             *                     Valid values are "STRING" or "NUMBER"
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeKeyType(java.lang.String rangeKeyType) {
                this.rangeKeyType = rangeKeyType;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBActionProperty#getRangeKeyValue}
             * @param rangeKeyValue The range key value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeKeyValue(java.lang.String rangeKeyValue) {
                this.rangeKeyValue = rangeKeyValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDBActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamoDBActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamoDBActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDBActionProperty {
            private final java.lang.String hashKeyField;
            private final java.lang.String hashKeyValue;
            private final java.lang.String roleArn;
            private final java.lang.String tableName;
            private final java.lang.String hashKeyType;
            private final java.lang.String payloadField;
            private final java.lang.String rangeKeyField;
            private final java.lang.String rangeKeyType;
            private final java.lang.String rangeKeyValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hashKeyField = software.amazon.jsii.Kernel.get(this, "hashKeyField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hashKeyValue = software.amazon.jsii.Kernel.get(this, "hashKeyValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hashKeyType = software.amazon.jsii.Kernel.get(this, "hashKeyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payloadField = software.amazon.jsii.Kernel.get(this, "payloadField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rangeKeyField = software.amazon.jsii.Kernel.get(this, "rangeKeyField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rangeKeyType = software.amazon.jsii.Kernel.get(this, "rangeKeyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rangeKeyValue = software.amazon.jsii.Kernel.get(this, "rangeKeyValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hashKeyField = java.util.Objects.requireNonNull(builder.hashKeyField, "hashKeyField is required");
                this.hashKeyValue = java.util.Objects.requireNonNull(builder.hashKeyValue, "hashKeyValue is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
                this.hashKeyType = builder.hashKeyType;
                this.payloadField = builder.payloadField;
                this.rangeKeyField = builder.rangeKeyField;
                this.rangeKeyType = builder.rangeKeyType;
                this.rangeKeyValue = builder.rangeKeyValue;
            }

            @Override
            public final java.lang.String getHashKeyField() {
                return this.hashKeyField;
            }

            @Override
            public final java.lang.String getHashKeyValue() {
                return this.hashKeyValue;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.String getHashKeyType() {
                return this.hashKeyType;
            }

            @Override
            public final java.lang.String getPayloadField() {
                return this.payloadField;
            }

            @Override
            public final java.lang.String getRangeKeyField() {
                return this.rangeKeyField;
            }

            @Override
            public final java.lang.String getRangeKeyType() {
                return this.rangeKeyType;
            }

            @Override
            public final java.lang.String getRangeKeyValue() {
                return this.rangeKeyValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hashKeyField", om.valueToTree(this.getHashKeyField()));
                data.set("hashKeyValue", om.valueToTree(this.getHashKeyValue()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("tableName", om.valueToTree(this.getTableName()));
                if (this.getHashKeyType() != null) {
                    data.set("hashKeyType", om.valueToTree(this.getHashKeyType()));
                }
                if (this.getPayloadField() != null) {
                    data.set("payloadField", om.valueToTree(this.getPayloadField()));
                }
                if (this.getRangeKeyField() != null) {
                    data.set("rangeKeyField", om.valueToTree(this.getRangeKeyField()));
                }
                if (this.getRangeKeyType() != null) {
                    data.set("rangeKeyType", om.valueToTree(this.getRangeKeyType()));
                }
                if (this.getRangeKeyValue() != null) {
                    data.set("rangeKeyValue", om.valueToTree(this.getRangeKeyValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.DynamoDBActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamoDBActionProperty.Jsii$Proxy that = (DynamoDBActionProperty.Jsii$Proxy) o;

                if (!hashKeyField.equals(that.hashKeyField)) return false;
                if (!hashKeyValue.equals(that.hashKeyValue)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!tableName.equals(that.tableName)) return false;
                if (this.hashKeyType != null ? !this.hashKeyType.equals(that.hashKeyType) : that.hashKeyType != null) return false;
                if (this.payloadField != null ? !this.payloadField.equals(that.payloadField) : that.payloadField != null) return false;
                if (this.rangeKeyField != null ? !this.rangeKeyField.equals(that.rangeKeyField) : that.rangeKeyField != null) return false;
                if (this.rangeKeyType != null ? !this.rangeKeyType.equals(that.rangeKeyType) : that.rangeKeyType != null) return false;
                return this.rangeKeyValue != null ? this.rangeKeyValue.equals(that.rangeKeyValue) : that.rangeKeyValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hashKeyField.hashCode();
                result = 31 * result + (this.hashKeyValue.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.tableName.hashCode());
                result = 31 * result + (this.hashKeyType != null ? this.hashKeyType.hashCode() : 0);
                result = 31 * result + (this.payloadField != null ? this.payloadField.hashCode() : 0);
                result = 31 * result + (this.rangeKeyField != null ? this.rangeKeyField.hashCode() : 0);
                result = 31 * result + (this.rangeKeyType != null ? this.rangeKeyType.hashCode() : 0);
                result = 31 * result + (this.rangeKeyValue != null ? this.rangeKeyValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an action to write to a DynamoDB table.
     * <p>
     * This DynamoDB action writes each attribute in the message payload into it's own column in the DynamoDB table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * DynamoDBv2ActionProperty dynamoDBv2ActionProperty = DynamoDBv2ActionProperty.builder()
     *         .putItem(PutItemInputProperty.builder()
     *                 .tableName("tableName")
     *                 .build())
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbv2action.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbv2action.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.DynamoDBv2ActionProperty")
    @software.amazon.jsii.Jsii.Proxy(DynamoDBv2ActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamoDBv2ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the DynamoDB table to which the message data will be written. For example:.
         * <p>
         * <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
         * <p>
         * Each attribute in the message payload will be written to a separate column in the DynamoDB database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbv2action.html#cfn-iot-topicrule-dynamodbv2action-putitem">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbv2action.html#cfn-iot-topicrule-dynamodbv2action-putitem</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPutItem() {
            return null;
        }

        /**
         * The ARN of the IAM role that grants access to the DynamoDB table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbv2action.html#cfn-iot-topicrule-dynamodbv2action-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbv2action.html#cfn-iot-topicrule-dynamodbv2action-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamoDBv2ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamoDBv2ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamoDBv2ActionProperty> {
            java.lang.Object putItem;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link DynamoDBv2ActionProperty#getPutItem}
             * @param putItem Specifies the DynamoDB table to which the message data will be written. For example:.
             *                <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
             *                <p>
             *                Each attribute in the message payload will be written to a separate column in the DynamoDB database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder putItem(software.amazon.awscdk.IResolvable putItem) {
                this.putItem = putItem;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBv2ActionProperty#getPutItem}
             * @param putItem Specifies the DynamoDB table to which the message data will be written. For example:.
             *                <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
             *                <p>
             *                Each attribute in the message payload will be written to a separate column in the DynamoDB database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder putItem(software.amazon.awscdk.services.iot.CfnTopicRule.PutItemInputProperty putItem) {
                this.putItem = putItem;
                return this;
            }

            /**
             * Sets the value of {@link DynamoDBv2ActionProperty#getRoleArn}
             * @param roleArn The ARN of the IAM role that grants access to the DynamoDB table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamoDBv2ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamoDBv2ActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamoDBv2ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoDBv2ActionProperty {
            private final java.lang.Object putItem;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.putItem = software.amazon.jsii.Kernel.get(this, "putItem", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.putItem = builder.putItem;
                this.roleArn = builder.roleArn;
            }

            @Override
            public final java.lang.Object getPutItem() {
                return this.putItem;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPutItem() != null) {
                    data.set("putItem", om.valueToTree(this.getPutItem()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.DynamoDBv2ActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamoDBv2ActionProperty.Jsii$Proxy that = (DynamoDBv2ActionProperty.Jsii$Proxy) o;

                if (this.putItem != null ? !this.putItem.equals(that.putItem) : that.putItem != null) return false;
                return this.roleArn != null ? this.roleArn.equals(that.roleArn) : that.roleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.putItem != null ? this.putItem.hashCode() : 0;
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an action that writes data to an Amazon OpenSearch Service domain.
     * <p>
     * <blockquote>
     * <p>
     * The <code>Elasticsearch</code> action can only be used by existing rule actions. To create a new rule action or to update an existing rule action, use the <code>OpenSearch</code> rule action instead. For more information, see <a href="https://docs.aws.amazon.com//iot/latest/apireference/API_OpenSearchAction.html">OpenSearchAction</a> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * ElasticsearchActionProperty elasticsearchActionProperty = ElasticsearchActionProperty.builder()
     *         .endpoint("endpoint")
     *         .id("id")
     *         .index("index")
     *         .roleArn("roleArn")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.ElasticsearchActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticsearchActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticsearchActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The endpoint of your OpenSearch domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-endpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndpoint();

        /**
         * The unique identifier for the document you are storing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The index where you want to store your data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-index">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-index</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndex();

        /**
         * The IAM role ARN that has access to OpenSearch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The type of document you are storing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ElasticsearchActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticsearchActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticsearchActionProperty> {
            java.lang.String endpoint;
            java.lang.String id;
            java.lang.String index;
            java.lang.String roleArn;
            java.lang.String type;

            /**
             * Sets the value of {@link ElasticsearchActionProperty#getEndpoint}
             * @param endpoint The endpoint of your OpenSearch domain. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpoint(java.lang.String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchActionProperty#getId}
             * @param id The unique identifier for the document you are storing. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchActionProperty#getIndex}
             * @param index The index where you want to store your data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder index(java.lang.String index) {
                this.index = index;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchActionProperty#getRoleArn}
             * @param roleArn The IAM role ARN that has access to OpenSearch. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchActionProperty#getType}
             * @param type The type of document you are storing. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticsearchActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticsearchActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticsearchActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticsearchActionProperty {
            private final java.lang.String endpoint;
            private final java.lang.String id;
            private final java.lang.String index;
            private final java.lang.String roleArn;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.index = software.amazon.jsii.Kernel.get(this, "index", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpoint = java.util.Objects.requireNonNull(builder.endpoint, "endpoint is required");
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.index = java.util.Objects.requireNonNull(builder.index, "index is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getEndpoint() {
                return this.endpoint;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getIndex() {
                return this.index;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endpoint", om.valueToTree(this.getEndpoint()));
                data.set("id", om.valueToTree(this.getId()));
                data.set("index", om.valueToTree(this.getIndex()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.ElasticsearchActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticsearchActionProperty.Jsii$Proxy that = (ElasticsearchActionProperty.Jsii$Proxy) o;

                if (!endpoint.equals(that.endpoint)) return false;
                if (!id.equals(that.id)) return false;
                if (!index.equals(that.index)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.endpoint.hashCode();
                result = 31 * result + (this.id.hashCode());
                result = 31 * result + (this.index.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes an action that writes data to an Amazon Kinesis Firehose stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * FirehoseActionProperty firehoseActionProperty = FirehoseActionProperty.builder()
     *         .deliveryStreamName("deliveryStreamName")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .batchMode(false)
     *         .separator("separator")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.FirehoseActionProperty")
    @software.amazon.jsii.Jsii.Proxy(FirehoseActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FirehoseActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The delivery stream name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-deliverystreamname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-deliverystreamname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeliveryStreamName();

        /**
         * The IAM role that grants access to the Amazon Kinesis Firehose stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * Whether to deliver the Kinesis Data Firehose stream as a batch by using <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html"><code>PutRecordBatch</code></a> . The default value is <code>false</code> .
         * <p>
         * When <code>batchMode</code> is <code>true</code> and the rule's SQL statement evaluates to an Array, each Array element forms one record in the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html"><code>PutRecordBatch</code></a> request. The resulting array can't have more than 500 records.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-batchmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-batchmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBatchMode() {
            return null;
        }

        /**
         * A character separator that will be used to separate records written to the Firehose stream.
         * <p>
         * Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-separator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-separator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSeparator() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FirehoseActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FirehoseActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FirehoseActionProperty> {
            java.lang.String deliveryStreamName;
            java.lang.String roleArn;
            java.lang.Object batchMode;
            java.lang.String separator;

            /**
             * Sets the value of {@link FirehoseActionProperty#getDeliveryStreamName}
             * @param deliveryStreamName The delivery stream name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliveryStreamName(java.lang.String deliveryStreamName) {
                this.deliveryStreamName = deliveryStreamName;
                return this;
            }

            /**
             * Sets the value of {@link FirehoseActionProperty#getRoleArn}
             * @param roleArn The IAM role that grants access to the Amazon Kinesis Firehose stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link FirehoseActionProperty#getBatchMode}
             * @param batchMode Whether to deliver the Kinesis Data Firehose stream as a batch by using <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html"><code>PutRecordBatch</code></a> . The default value is <code>false</code> .
             *                  When <code>batchMode</code> is <code>true</code> and the rule's SQL statement evaluates to an Array, each Array element forms one record in the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html"><code>PutRecordBatch</code></a> request. The resulting array can't have more than 500 records.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchMode(java.lang.Boolean batchMode) {
                this.batchMode = batchMode;
                return this;
            }

            /**
             * Sets the value of {@link FirehoseActionProperty#getBatchMode}
             * @param batchMode Whether to deliver the Kinesis Data Firehose stream as a batch by using <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html"><code>PutRecordBatch</code></a> . The default value is <code>false</code> .
             *                  When <code>batchMode</code> is <code>true</code> and the rule's SQL statement evaluates to an Array, each Array element forms one record in the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html"><code>PutRecordBatch</code></a> request. The resulting array can't have more than 500 records.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchMode(software.amazon.awscdk.IResolvable batchMode) {
                this.batchMode = batchMode;
                return this;
            }

            /**
             * Sets the value of {@link FirehoseActionProperty#getSeparator}
             * @param separator A character separator that will be used to separate records written to the Firehose stream.
             *                  Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder separator(java.lang.String separator) {
                this.separator = separator;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FirehoseActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FirehoseActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FirehoseActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirehoseActionProperty {
            private final java.lang.String deliveryStreamName;
            private final java.lang.String roleArn;
            private final java.lang.Object batchMode;
            private final java.lang.String separator;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deliveryStreamName = software.amazon.jsii.Kernel.get(this, "deliveryStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.batchMode = software.amazon.jsii.Kernel.get(this, "batchMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.separator = software.amazon.jsii.Kernel.get(this, "separator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deliveryStreamName = java.util.Objects.requireNonNull(builder.deliveryStreamName, "deliveryStreamName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.batchMode = builder.batchMode;
                this.separator = builder.separator;
            }

            @Override
            public final java.lang.String getDeliveryStreamName() {
                return this.deliveryStreamName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getBatchMode() {
                return this.batchMode;
            }

            @Override
            public final java.lang.String getSeparator() {
                return this.separator;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deliveryStreamName", om.valueToTree(this.getDeliveryStreamName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getBatchMode() != null) {
                    data.set("batchMode", om.valueToTree(this.getBatchMode()));
                }
                if (this.getSeparator() != null) {
                    data.set("separator", om.valueToTree(this.getSeparator()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.FirehoseActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FirehoseActionProperty.Jsii$Proxy that = (FirehoseActionProperty.Jsii$Proxy) o;

                if (!deliveryStreamName.equals(that.deliveryStreamName)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (this.batchMode != null ? !this.batchMode.equals(that.batchMode) : that.batchMode != null) return false;
                return this.separator != null ? this.separator.equals(that.separator) : that.separator == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deliveryStreamName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.batchMode != null ? this.batchMode.hashCode() : 0);
                result = 31 * result + (this.separator != null ? this.separator.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The HTTP action header.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * HttpActionHeaderProperty httpActionHeaderProperty = HttpActionHeaderProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpactionheader.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpactionheader.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.HttpActionHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpActionHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpActionHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The HTTP header key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpactionheader.html#cfn-iot-topicrule-httpactionheader-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpactionheader.html#cfn-iot-topicrule-httpactionheader-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The HTTP header value.
         * <p>
         * Substitution templates are supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpactionheader.html#cfn-iot-topicrule-httpactionheader-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpactionheader.html#cfn-iot-topicrule-httpactionheader-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link HttpActionHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpActionHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpActionHeaderProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link HttpActionHeaderProperty#getKey}
             * @param key The HTTP header key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link HttpActionHeaderProperty#getValue}
             * @param value The HTTP header value. This parameter is required.
             *              Substitution templates are supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpActionHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpActionHeaderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpActionHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpActionHeaderProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.HttpActionHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpActionHeaderProperty.Jsii$Proxy that = (HttpActionHeaderProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Send data to an HTTPS endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * HttpActionProperty httpActionProperty = HttpActionProperty.builder()
     *         .url("url")
     *         // the properties below are optional
     *         .auth(HttpAuthorizationProperty.builder()
     *                 .sigv4(SigV4AuthorizationProperty.builder()
     *                         .roleArn("roleArn")
     *                         .serviceName("serviceName")
     *                         .signingRegion("signingRegion")
     *                         .build())
     *                 .build())
     *         .confirmationUrl("confirmationUrl")
     *         .headers(List.of(HttpActionHeaderProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.HttpActionProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The endpoint URL.
         * <p>
         * If substitution templates are used in the URL, you must also specify a <code>confirmationUrl</code> . If this is a new destination, a new <code>TopicRuleDestination</code> is created if possible.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html#cfn-iot-topicrule-httpaction-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html#cfn-iot-topicrule-httpaction-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUrl();

        /**
         * The authentication method to use when sending data to an HTTPS endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html#cfn-iot-topicrule-httpaction-auth">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html#cfn-iot-topicrule-httpaction-auth</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuth() {
            return null;
        }

        /**
         * The URL to which AWS IoT sends a confirmation message.
         * <p>
         * The value of the confirmation URL must be a prefix of the endpoint URL. If you do not specify a confirmation URL AWS IoT uses the endpoint URL as the confirmation URL. If you use substitution templates in the confirmationUrl, you must create and enable topic rule destinations that match each possible value of the substitution template before traffic is allowed to your endpoint URL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html#cfn-iot-topicrule-httpaction-confirmationurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html#cfn-iot-topicrule-httpaction-confirmationurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConfirmationUrl() {
            return null;
        }

        /**
         * The HTTP headers to send with the message data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html#cfn-iot-topicrule-httpaction-headers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html#cfn-iot-topicrule-httpaction-headers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeaders() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpActionProperty> {
            java.lang.String url;
            java.lang.Object auth;
            java.lang.String confirmationUrl;
            java.lang.Object headers;

            /**
             * Sets the value of {@link HttpActionProperty#getUrl}
             * @param url The endpoint URL. This parameter is required.
             *            If substitution templates are used in the URL, you must also specify a <code>confirmationUrl</code> . If this is a new destination, a new <code>TopicRuleDestination</code> is created if possible.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Sets the value of {@link HttpActionProperty#getAuth}
             * @param auth The authentication method to use when sending data to an HTTPS endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auth(software.amazon.awscdk.IResolvable auth) {
                this.auth = auth;
                return this;
            }

            /**
             * Sets the value of {@link HttpActionProperty#getAuth}
             * @param auth The authentication method to use when sending data to an HTTPS endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auth(software.amazon.awscdk.services.iot.CfnTopicRule.HttpAuthorizationProperty auth) {
                this.auth = auth;
                return this;
            }

            /**
             * Sets the value of {@link HttpActionProperty#getConfirmationUrl}
             * @param confirmationUrl The URL to which AWS IoT sends a confirmation message.
             *                        The value of the confirmation URL must be a prefix of the endpoint URL. If you do not specify a confirmation URL AWS IoT uses the endpoint URL as the confirmation URL. If you use substitution templates in the confirmationUrl, you must create and enable topic rule destinations that match each possible value of the substitution template before traffic is allowed to your endpoint URL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confirmationUrl(java.lang.String confirmationUrl) {
                this.confirmationUrl = confirmationUrl;
                return this;
            }

            /**
             * Sets the value of {@link HttpActionProperty#getHeaders}
             * @param headers The HTTP headers to send with the message data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(software.amazon.awscdk.IResolvable headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link HttpActionProperty#getHeaders}
             * @param headers The HTTP headers to send with the message data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(java.util.List<? extends java.lang.Object> headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpActionProperty {
            private final java.lang.String url;
            private final java.lang.Object auth;
            private final java.lang.String confirmationUrl;
            private final java.lang.Object headers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.auth = software.amazon.jsii.Kernel.get(this, "auth", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.confirmationUrl = software.amazon.jsii.Kernel.get(this, "confirmationUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.url = java.util.Objects.requireNonNull(builder.url, "url is required");
                this.auth = builder.auth;
                this.confirmationUrl = builder.confirmationUrl;
                this.headers = builder.headers;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            public final java.lang.Object getAuth() {
                return this.auth;
            }

            @Override
            public final java.lang.String getConfirmationUrl() {
                return this.confirmationUrl;
            }

            @Override
            public final java.lang.Object getHeaders() {
                return this.headers;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("url", om.valueToTree(this.getUrl()));
                if (this.getAuth() != null) {
                    data.set("auth", om.valueToTree(this.getAuth()));
                }
                if (this.getConfirmationUrl() != null) {
                    data.set("confirmationUrl", om.valueToTree(this.getConfirmationUrl()));
                }
                if (this.getHeaders() != null) {
                    data.set("headers", om.valueToTree(this.getHeaders()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.HttpActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpActionProperty.Jsii$Proxy that = (HttpActionProperty.Jsii$Proxy) o;

                if (!url.equals(that.url)) return false;
                if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) return false;
                if (this.confirmationUrl != null ? !this.confirmationUrl.equals(that.confirmationUrl) : that.confirmationUrl != null) return false;
                return this.headers != null ? this.headers.equals(that.headers) : that.headers == null;
            }

            @Override
            public final int hashCode() {
                int result = this.url.hashCode();
                result = 31 * result + (this.auth != null ? this.auth.hashCode() : 0);
                result = 31 * result + (this.confirmationUrl != null ? this.confirmationUrl.hashCode() : 0);
                result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The authorization method used to send messages.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * HttpAuthorizationProperty httpAuthorizationProperty = HttpAuthorizationProperty.builder()
     *         .sigv4(SigV4AuthorizationProperty.builder()
     *                 .roleArn("roleArn")
     *                 .serviceName("serviceName")
     *                 .signingRegion("signingRegion")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpauthorization.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpauthorization.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.HttpAuthorizationProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpAuthorizationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpAuthorizationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Use Sig V4 authorization.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpauthorization.html#cfn-iot-topicrule-httpauthorization-sigv4">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpauthorization.html#cfn-iot-topicrule-httpauthorization-sigv4</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSigv4() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpAuthorizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpAuthorizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpAuthorizationProperty> {
            java.lang.Object sigv4;

            /**
             * Sets the value of {@link HttpAuthorizationProperty#getSigv4}
             * @param sigv4 Use Sig V4 authorization.
             *              For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sigv4(software.amazon.awscdk.IResolvable sigv4) {
                this.sigv4 = sigv4;
                return this;
            }

            /**
             * Sets the value of {@link HttpAuthorizationProperty#getSigv4}
             * @param sigv4 Use Sig V4 authorization.
             *              For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sigv4(software.amazon.awscdk.services.iot.CfnTopicRule.SigV4AuthorizationProperty sigv4) {
                this.sigv4 = sigv4;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpAuthorizationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpAuthorizationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpAuthorizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpAuthorizationProperty {
            private final java.lang.Object sigv4;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sigv4 = software.amazon.jsii.Kernel.get(this, "sigv4", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sigv4 = builder.sigv4;
            }

            @Override
            public final java.lang.Object getSigv4() {
                return this.sigv4;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSigv4() != null) {
                    data.set("sigv4", om.valueToTree(this.getSigv4()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.HttpAuthorizationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpAuthorizationProperty.Jsii$Proxy that = (HttpAuthorizationProperty.Jsii$Proxy) o;

                return this.sigv4 != null ? this.sigv4.equals(that.sigv4) : that.sigv4 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sigv4 != null ? this.sigv4.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Sends message data to an AWS IoT Analytics channel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * IotAnalyticsActionProperty iotAnalyticsActionProperty = IotAnalyticsActionProperty.builder()
     *         .channelName("channelName")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .batchMode(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.IotAnalyticsActionProperty")
    @software.amazon.jsii.Jsii.Proxy(IotAnalyticsActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IotAnalyticsActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the IoT Analytics channel to which message data will be sent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html#cfn-iot-topicrule-iotanalyticsaction-channelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html#cfn-iot-topicrule-iotanalyticsaction-channelname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getChannelName();

        /**
         * The ARN of the role which has a policy that grants IoT Analytics permission to send message data via IoT Analytics (iotanalytics:BatchPutMessage).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html#cfn-iot-topicrule-iotanalyticsaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html#cfn-iot-topicrule-iotanalyticsaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * Whether to process the action as a batch. The default value is <code>false</code> .
         * <p>
         * When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates to an Array, each Array element is delivered as a separate message when passed by <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_BatchPutMessage.html"><code>BatchPutMessage</code></a> The resulting array can't have more than 100 messages.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html#cfn-iot-topicrule-iotanalyticsaction-batchmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html#cfn-iot-topicrule-iotanalyticsaction-batchmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBatchMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IotAnalyticsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IotAnalyticsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IotAnalyticsActionProperty> {
            java.lang.String channelName;
            java.lang.String roleArn;
            java.lang.Object batchMode;

            /**
             * Sets the value of {@link IotAnalyticsActionProperty#getChannelName}
             * @param channelName The name of the IoT Analytics channel to which message data will be sent. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channelName(java.lang.String channelName) {
                this.channelName = channelName;
                return this;
            }

            /**
             * Sets the value of {@link IotAnalyticsActionProperty#getRoleArn}
             * @param roleArn The ARN of the role which has a policy that grants IoT Analytics permission to send message data via IoT Analytics (iotanalytics:BatchPutMessage). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link IotAnalyticsActionProperty#getBatchMode}
             * @param batchMode Whether to process the action as a batch. The default value is <code>false</code> .
             *                  When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates to an Array, each Array element is delivered as a separate message when passed by <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_BatchPutMessage.html"><code>BatchPutMessage</code></a> The resulting array can't have more than 100 messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchMode(java.lang.Boolean batchMode) {
                this.batchMode = batchMode;
                return this;
            }

            /**
             * Sets the value of {@link IotAnalyticsActionProperty#getBatchMode}
             * @param batchMode Whether to process the action as a batch. The default value is <code>false</code> .
             *                  When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates to an Array, each Array element is delivered as a separate message when passed by <a href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_BatchPutMessage.html"><code>BatchPutMessage</code></a> The resulting array can't have more than 100 messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchMode(software.amazon.awscdk.IResolvable batchMode) {
                this.batchMode = batchMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IotAnalyticsActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IotAnalyticsActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IotAnalyticsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IotAnalyticsActionProperty {
            private final java.lang.String channelName;
            private final java.lang.String roleArn;
            private final java.lang.Object batchMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.channelName = software.amazon.jsii.Kernel.get(this, "channelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.batchMode = software.amazon.jsii.Kernel.get(this, "batchMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.channelName = java.util.Objects.requireNonNull(builder.channelName, "channelName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.batchMode = builder.batchMode;
            }

            @Override
            public final java.lang.String getChannelName() {
                return this.channelName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getBatchMode() {
                return this.batchMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("channelName", om.valueToTree(this.getChannelName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getBatchMode() != null) {
                    data.set("batchMode", om.valueToTree(this.getBatchMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.IotAnalyticsActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IotAnalyticsActionProperty.Jsii$Proxy that = (IotAnalyticsActionProperty.Jsii$Proxy) o;

                if (!channelName.equals(that.channelName)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                return this.batchMode != null ? this.batchMode.equals(that.batchMode) : that.batchMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.channelName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.batchMode != null ? this.batchMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sends an input to an AWS IoT Events detector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * IotEventsActionProperty iotEventsActionProperty = IotEventsActionProperty.builder()
     *         .inputName("inputName")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .batchMode(false)
     *         .messageId("messageId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.IotEventsActionProperty")
    @software.amazon.jsii.Jsii.Proxy(IotEventsActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IotEventsActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the AWS IoT Events input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html#cfn-iot-topicrule-ioteventsaction-inputname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html#cfn-iot-topicrule-ioteventsaction-inputname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInputName();

        /**
         * The ARN of the role that grants AWS IoT permission to send an input to an AWS IoT Events detector.
         * <p>
         * ("Action":"iotevents:BatchPutMessage").
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html#cfn-iot-topicrule-ioteventsaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html#cfn-iot-topicrule-ioteventsaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * Whether to process the event actions as a batch. The default value is <code>false</code> .
         * <p>
         * When <code>batchMode</code> is <code>true</code> , you can't specify a <code>messageId</code> .
         * <p>
         * When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates to an Array, each Array element is treated as a separate message when Events by calling <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html"><code>BatchPutMessage</code></a> . The resulting array can't have more than 10 messages.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html#cfn-iot-topicrule-ioteventsaction-batchmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html#cfn-iot-topicrule-ioteventsaction-batchmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBatchMode() {
            return null;
        }

        /**
         * The ID of the message. The default <code>messageId</code> is a new UUID value.
         * <p>
         * When <code>batchMode</code> is <code>true</code> , you can't specify a <code>messageId</code> --a new UUID value will be assigned.
         * <p>
         * Assign a value to this property to ensure that only one input (message) with a given <code>messageId</code> will be processed by an AWS IoT Events detector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html#cfn-iot-topicrule-ioteventsaction-messageid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html#cfn-iot-topicrule-ioteventsaction-messageid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IotEventsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IotEventsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IotEventsActionProperty> {
            java.lang.String inputName;
            java.lang.String roleArn;
            java.lang.Object batchMode;
            java.lang.String messageId;

            /**
             * Sets the value of {@link IotEventsActionProperty#getInputName}
             * @param inputName The name of the AWS IoT Events input. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputName(java.lang.String inputName) {
                this.inputName = inputName;
                return this;
            }

            /**
             * Sets the value of {@link IotEventsActionProperty#getRoleArn}
             * @param roleArn The ARN of the role that grants AWS IoT permission to send an input to an AWS IoT Events detector. This parameter is required.
             *                ("Action":"iotevents:BatchPutMessage").
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link IotEventsActionProperty#getBatchMode}
             * @param batchMode Whether to process the event actions as a batch. The default value is <code>false</code> .
             *                  When <code>batchMode</code> is <code>true</code> , you can't specify a <code>messageId</code> .
             *                  <p>
             *                  When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates to an Array, each Array element is treated as a separate message when Events by calling <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html"><code>BatchPutMessage</code></a> . The resulting array can't have more than 10 messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchMode(java.lang.Boolean batchMode) {
                this.batchMode = batchMode;
                return this;
            }

            /**
             * Sets the value of {@link IotEventsActionProperty#getBatchMode}
             * @param batchMode Whether to process the event actions as a batch. The default value is <code>false</code> .
             *                  When <code>batchMode</code> is <code>true</code> , you can't specify a <code>messageId</code> .
             *                  <p>
             *                  When <code>batchMode</code> is <code>true</code> and the rule SQL statement evaluates to an Array, each Array element is treated as a separate message when Events by calling <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html"><code>BatchPutMessage</code></a> . The resulting array can't have more than 10 messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchMode(software.amazon.awscdk.IResolvable batchMode) {
                this.batchMode = batchMode;
                return this;
            }

            /**
             * Sets the value of {@link IotEventsActionProperty#getMessageId}
             * @param messageId The ID of the message. The default <code>messageId</code> is a new UUID value.
             *                  When <code>batchMode</code> is <code>true</code> , you can't specify a <code>messageId</code> --a new UUID value will be assigned.
             *                  <p>
             *                  Assign a value to this property to ensure that only one input (message) with a given <code>messageId</code> will be processed by an AWS IoT Events detector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageId(java.lang.String messageId) {
                this.messageId = messageId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IotEventsActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IotEventsActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IotEventsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IotEventsActionProperty {
            private final java.lang.String inputName;
            private final java.lang.String roleArn;
            private final java.lang.Object batchMode;
            private final java.lang.String messageId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputName = software.amazon.jsii.Kernel.get(this, "inputName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.batchMode = software.amazon.jsii.Kernel.get(this, "batchMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.messageId = software.amazon.jsii.Kernel.get(this, "messageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputName = java.util.Objects.requireNonNull(builder.inputName, "inputName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.batchMode = builder.batchMode;
                this.messageId = builder.messageId;
            }

            @Override
            public final java.lang.String getInputName() {
                return this.inputName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getBatchMode() {
                return this.batchMode;
            }

            @Override
            public final java.lang.String getMessageId() {
                return this.messageId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputName", om.valueToTree(this.getInputName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getBatchMode() != null) {
                    data.set("batchMode", om.valueToTree(this.getBatchMode()));
                }
                if (this.getMessageId() != null) {
                    data.set("messageId", om.valueToTree(this.getMessageId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.IotEventsActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IotEventsActionProperty.Jsii$Proxy that = (IotEventsActionProperty.Jsii$Proxy) o;

                if (!inputName.equals(that.inputName)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (this.batchMode != null ? !this.batchMode.equals(that.batchMode) : that.batchMode != null) return false;
                return this.messageId != null ? this.messageId.equals(that.messageId) : that.messageId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.batchMode != null ? this.batchMode.hashCode() : 0);
                result = 31 * result + (this.messageId != null ? this.messageId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an action to send data from an MQTT message that triggered the rule to AWS IoT SiteWise asset properties.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * IotSiteWiseActionProperty iotSiteWiseActionProperty = IotSiteWiseActionProperty.builder()
     *         .putAssetPropertyValueEntries(List.of(PutAssetPropertyValueEntryProperty.builder()
     *                 .propertyValues(List.of(AssetPropertyValueProperty.builder()
     *                         .timestamp(AssetPropertyTimestampProperty.builder()
     *                                 .timeInSeconds("timeInSeconds")
     *                                 // the properties below are optional
     *                                 .offsetInNanos("offsetInNanos")
     *                                 .build())
     *                         .value(AssetPropertyVariantProperty.builder()
     *                                 .booleanValue("booleanValue")
     *                                 .doubleValue("doubleValue")
     *                                 .integerValue("integerValue")
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         // the properties below are optional
     *                         .quality("quality")
     *                         .build()))
     *                 // the properties below are optional
     *                 .assetId("assetId")
     *                 .entryId("entryId")
     *                 .propertyAlias("propertyAlias")
     *                 .propertyId("propertyId")
     *                 .build()))
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotsitewiseaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotsitewiseaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.IotSiteWiseActionProperty")
    @software.amazon.jsii.Jsii.Proxy(IotSiteWiseActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IotSiteWiseActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of asset property value entries.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotsitewiseaction.html#cfn-iot-topicrule-iotsitewiseaction-putassetpropertyvalueentries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotsitewiseaction.html#cfn-iot-topicrule-iotsitewiseaction-putassetpropertyvalueentries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPutAssetPropertyValueEntries();

        /**
         * The ARN of the role that grants AWS IoT permission to send an asset property value to AWS IoT SiteWise.
         * <p>
         * ( <code>"Action": "iotsitewise:BatchPutAssetPropertyValue"</code> ). The trust policy can restrict access to specific asset hierarchy paths.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotsitewiseaction.html#cfn-iot-topicrule-iotsitewiseaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotsitewiseaction.html#cfn-iot-topicrule-iotsitewiseaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link IotSiteWiseActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IotSiteWiseActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IotSiteWiseActionProperty> {
            java.lang.Object putAssetPropertyValueEntries;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link IotSiteWiseActionProperty#getPutAssetPropertyValueEntries}
             * @param putAssetPropertyValueEntries A list of asset property value entries. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder putAssetPropertyValueEntries(software.amazon.awscdk.IResolvable putAssetPropertyValueEntries) {
                this.putAssetPropertyValueEntries = putAssetPropertyValueEntries;
                return this;
            }

            /**
             * Sets the value of {@link IotSiteWiseActionProperty#getPutAssetPropertyValueEntries}
             * @param putAssetPropertyValueEntries A list of asset property value entries. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder putAssetPropertyValueEntries(java.util.List<? extends java.lang.Object> putAssetPropertyValueEntries) {
                this.putAssetPropertyValueEntries = putAssetPropertyValueEntries;
                return this;
            }

            /**
             * Sets the value of {@link IotSiteWiseActionProperty#getRoleArn}
             * @param roleArn The ARN of the role that grants AWS IoT permission to send an asset property value to AWS IoT SiteWise. This parameter is required.
             *                ( <code>"Action": "iotsitewise:BatchPutAssetPropertyValue"</code> ). The trust policy can restrict access to specific asset hierarchy paths.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IotSiteWiseActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IotSiteWiseActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IotSiteWiseActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IotSiteWiseActionProperty {
            private final java.lang.Object putAssetPropertyValueEntries;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.putAssetPropertyValueEntries = software.amazon.jsii.Kernel.get(this, "putAssetPropertyValueEntries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.putAssetPropertyValueEntries = java.util.Objects.requireNonNull(builder.putAssetPropertyValueEntries, "putAssetPropertyValueEntries is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.Object getPutAssetPropertyValueEntries() {
                return this.putAssetPropertyValueEntries;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("putAssetPropertyValueEntries", om.valueToTree(this.getPutAssetPropertyValueEntries()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.IotSiteWiseActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IotSiteWiseActionProperty.Jsii$Proxy that = (IotSiteWiseActionProperty.Jsii$Proxy) o;

                if (!putAssetPropertyValueEntries.equals(that.putAssetPropertyValueEntries)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.putAssetPropertyValueEntries.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies a Kafka header using key-value pairs when you create a Rule’s Kafka Action.
     * <p>
     * You can use these headers to route data from IoT clients to downstream Kafka clusters without modifying your message payload.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * KafkaActionHeaderProperty kafkaActionHeaderProperty = KafkaActionHeaderProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaactionheader.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaactionheader.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.KafkaActionHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(KafkaActionHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KafkaActionHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key of the Kafka header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaactionheader.html#cfn-iot-topicrule-kafkaactionheader-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaactionheader.html#cfn-iot-topicrule-kafkaactionheader-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value of the Kafka header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaactionheader.html#cfn-iot-topicrule-kafkaactionheader-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaactionheader.html#cfn-iot-topicrule-kafkaactionheader-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link KafkaActionHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KafkaActionHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KafkaActionHeaderProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link KafkaActionHeaderProperty#getKey}
             * @param key The key of the Kafka header. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link KafkaActionHeaderProperty#getValue}
             * @param value The value of the Kafka header. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KafkaActionHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KafkaActionHeaderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KafkaActionHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KafkaActionHeaderProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.KafkaActionHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KafkaActionHeaderProperty.Jsii$Proxy that = (KafkaActionHeaderProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * KafkaActionProperty kafkaActionProperty = KafkaActionProperty.builder()
     *         .clientProperties(Map.of(
     *                 "clientPropertiesKey", "clientProperties"))
     *         .destinationArn("destinationArn")
     *         .topic("topic")
     *         // the properties below are optional
     *         .headers(List.of(KafkaActionHeaderProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .key("key")
     *         .partition("partition")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.KafkaActionProperty")
    @software.amazon.jsii.Jsii.Proxy(KafkaActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KafkaActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Properties of the Apache Kafka producer client.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-clientproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-clientproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getClientProperties();

        /**
         * The ARN of Kafka action's VPC <code>TopicRuleDestination</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-destinationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-destinationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationArn();

        /**
         * The Kafka topic for messages to be sent to the Kafka broker.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-topic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-topic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTopic();

        /**
         * The list of Kafka headers that you specify.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-headers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-headers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeaders() {
            return null;
        }

        /**
         * The Kafka message key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The Kafka message partition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-partition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-partition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPartition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KafkaActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KafkaActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KafkaActionProperty> {
            java.lang.Object clientProperties;
            java.lang.String destinationArn;
            java.lang.String topic;
            java.lang.Object headers;
            java.lang.String key;
            java.lang.String partition;

            /**
             * Sets the value of {@link KafkaActionProperty#getClientProperties}
             * @param clientProperties Properties of the Apache Kafka producer client. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientProperties(java.util.Map<java.lang.String, java.lang.String> clientProperties) {
                this.clientProperties = clientProperties;
                return this;
            }

            /**
             * Sets the value of {@link KafkaActionProperty#getClientProperties}
             * @param clientProperties Properties of the Apache Kafka producer client. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientProperties(software.amazon.awscdk.IResolvable clientProperties) {
                this.clientProperties = clientProperties;
                return this;
            }

            /**
             * Sets the value of {@link KafkaActionProperty#getDestinationArn}
             * @param destinationArn The ARN of Kafka action's VPC <code>TopicRuleDestination</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationArn(java.lang.String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            /**
             * Sets the value of {@link KafkaActionProperty#getTopic}
             * @param topic The Kafka topic for messages to be sent to the Kafka broker. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topic(java.lang.String topic) {
                this.topic = topic;
                return this;
            }

            /**
             * Sets the value of {@link KafkaActionProperty#getHeaders}
             * @param headers The list of Kafka headers that you specify.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(software.amazon.awscdk.IResolvable headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link KafkaActionProperty#getHeaders}
             * @param headers The list of Kafka headers that you specify.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(java.util.List<? extends java.lang.Object> headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link KafkaActionProperty#getKey}
             * @param key The Kafka message key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link KafkaActionProperty#getPartition}
             * @param partition The Kafka message partition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partition(java.lang.String partition) {
                this.partition = partition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KafkaActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KafkaActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KafkaActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KafkaActionProperty {
            private final java.lang.Object clientProperties;
            private final java.lang.String destinationArn;
            private final java.lang.String topic;
            private final java.lang.Object headers;
            private final java.lang.String key;
            private final java.lang.String partition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientProperties = software.amazon.jsii.Kernel.get(this, "clientProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinationArn = software.amazon.jsii.Kernel.get(this, "destinationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.partition = software.amazon.jsii.Kernel.get(this, "partition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientProperties = java.util.Objects.requireNonNull(builder.clientProperties, "clientProperties is required");
                this.destinationArn = java.util.Objects.requireNonNull(builder.destinationArn, "destinationArn is required");
                this.topic = java.util.Objects.requireNonNull(builder.topic, "topic is required");
                this.headers = builder.headers;
                this.key = builder.key;
                this.partition = builder.partition;
            }

            @Override
            public final java.lang.Object getClientProperties() {
                return this.clientProperties;
            }

            @Override
            public final java.lang.String getDestinationArn() {
                return this.destinationArn;
            }

            @Override
            public final java.lang.String getTopic() {
                return this.topic;
            }

            @Override
            public final java.lang.Object getHeaders() {
                return this.headers;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getPartition() {
                return this.partition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientProperties", om.valueToTree(this.getClientProperties()));
                data.set("destinationArn", om.valueToTree(this.getDestinationArn()));
                data.set("topic", om.valueToTree(this.getTopic()));
                if (this.getHeaders() != null) {
                    data.set("headers", om.valueToTree(this.getHeaders()));
                }
                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getPartition() != null) {
                    data.set("partition", om.valueToTree(this.getPartition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.KafkaActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KafkaActionProperty.Jsii$Proxy that = (KafkaActionProperty.Jsii$Proxy) o;

                if (!clientProperties.equals(that.clientProperties)) return false;
                if (!destinationArn.equals(that.destinationArn)) return false;
                if (!topic.equals(that.topic)) return false;
                if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) return false;
                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.partition != null ? this.partition.equals(that.partition) : that.partition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientProperties.hashCode();
                result = 31 * result + (this.destinationArn.hashCode());
                result = 31 * result + (this.topic.hashCode());
                result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
                result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
                result = 31 * result + (this.partition != null ? this.partition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an action to write data to an Amazon Kinesis stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * KinesisActionProperty kinesisActionProperty = KinesisActionProperty.builder()
     *         .roleArn("roleArn")
     *         .streamName("streamName")
     *         // the properties below are optional
     *         .partitionKey("partitionKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.KinesisActionProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the IAM role that grants access to the Amazon Kinesis stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html#cfn-iot-topicrule-kinesisaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html#cfn-iot-topicrule-kinesisaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The name of the Amazon Kinesis stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html#cfn-iot-topicrule-kinesisaction-streamname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html#cfn-iot-topicrule-kinesisaction-streamname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStreamName();

        /**
         * The partition key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html#cfn-iot-topicrule-kinesisaction-partitionkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html#cfn-iot-topicrule-kinesisaction-partitionkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPartitionKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KinesisActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisActionProperty> {
            java.lang.String roleArn;
            java.lang.String streamName;
            java.lang.String partitionKey;

            /**
             * Sets the value of {@link KinesisActionProperty#getRoleArn}
             * @param roleArn The ARN of the IAM role that grants access to the Amazon Kinesis stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link KinesisActionProperty#getStreamName}
             * @param streamName The name of the Amazon Kinesis stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamName(java.lang.String streamName) {
                this.streamName = streamName;
                return this;
            }

            /**
             * Sets the value of {@link KinesisActionProperty#getPartitionKey}
             * @param partitionKey The partition key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionKey(java.lang.String partitionKey) {
                this.partitionKey = partitionKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisActionProperty {
            private final java.lang.String roleArn;
            private final java.lang.String streamName;
            private final java.lang.String partitionKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.streamName = software.amazon.jsii.Kernel.get(this, "streamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.partitionKey = software.amazon.jsii.Kernel.get(this, "partitionKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.streamName = java.util.Objects.requireNonNull(builder.streamName, "streamName is required");
                this.partitionKey = builder.partitionKey;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getStreamName() {
                return this.streamName;
            }

            @Override
            public final java.lang.String getPartitionKey() {
                return this.partitionKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("streamName", om.valueToTree(this.getStreamName()));
                if (this.getPartitionKey() != null) {
                    data.set("partitionKey", om.valueToTree(this.getPartitionKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.KinesisActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisActionProperty.Jsii$Proxy that = (KinesisActionProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                if (!streamName.equals(that.streamName)) return false;
                return this.partitionKey != null ? this.partitionKey.equals(that.partitionKey) : that.partitionKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.streamName.hashCode());
                result = 31 * result + (this.partitionKey != null ? this.partitionKey.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an action to invoke a Lambda function.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * LambdaActionProperty lambdaActionProperty = LambdaActionProperty.builder()
     *         .functionArn("functionArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-lambdaaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-lambdaaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.LambdaActionProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-lambdaaction.html#cfn-iot-topicrule-lambdaaction-functionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-lambdaaction.html#cfn-iot-topicrule-lambdaaction-functionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFunctionArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaActionProperty> {
            java.lang.String functionArn;

            /**
             * Sets the value of {@link LambdaActionProperty#getFunctionArn}
             * @param functionArn The ARN of the Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionArn(java.lang.String functionArn) {
                this.functionArn = functionArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaActionProperty {
            private final java.lang.String functionArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.functionArn = software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.functionArn = builder.functionArn;
            }

            @Override
            public final java.lang.String getFunctionArn() {
                return this.functionArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFunctionArn() != null) {
                    data.set("functionArn", om.valueToTree(this.getFunctionArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.LambdaActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaActionProperty.Jsii$Proxy that = (LambdaActionProperty.Jsii$Proxy) o;

                return this.functionArn != null ? this.functionArn.equals(that.functionArn) : that.functionArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.functionArn != null ? this.functionArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes an action to send device location updates from an MQTT message to an Amazon Location tracker resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * LocationActionProperty locationActionProperty = LocationActionProperty.builder()
     *         .deviceId("deviceId")
     *         .latitude("latitude")
     *         .longitude("longitude")
     *         .roleArn("roleArn")
     *         .trackerName("trackerName")
     *         // the properties below are optional
     *         .timestamp(TimestampProperty.builder()
     *                 .value("value")
     *                 // the properties below are optional
     *                 .unit("unit")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.LocationActionProperty")
    @software.amazon.jsii.Jsii.Proxy(LocationActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LocationActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique ID of the device providing the location data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-deviceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-deviceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeviceId();

        /**
         * A string that evaluates to a double value that represents the latitude of the device's location.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-latitude">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-latitude</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLatitude();

        /**
         * A string that evaluates to a double value that represents the longitude of the device's location.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-longitude">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-longitude</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLongitude();

        /**
         * The IAM role that grants permission to write to the Amazon Location resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The name of the tracker resource in Amazon Location in which the location is updated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-trackername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-trackername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTrackerName();

        /**
         * The time that the location data was sampled.
         * <p>
         * The default value is the time the MQTT message was processed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-timestamp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-timestamp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimestamp() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LocationActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LocationActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LocationActionProperty> {
            java.lang.String deviceId;
            java.lang.String latitude;
            java.lang.String longitude;
            java.lang.String roleArn;
            java.lang.String trackerName;
            java.lang.Object timestamp;

            /**
             * Sets the value of {@link LocationActionProperty#getDeviceId}
             * @param deviceId The unique ID of the device providing the location data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceId(java.lang.String deviceId) {
                this.deviceId = deviceId;
                return this;
            }

            /**
             * Sets the value of {@link LocationActionProperty#getLatitude}
             * @param latitude A string that evaluates to a double value that represents the latitude of the device's location. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder latitude(java.lang.String latitude) {
                this.latitude = latitude;
                return this;
            }

            /**
             * Sets the value of {@link LocationActionProperty#getLongitude}
             * @param longitude A string that evaluates to a double value that represents the longitude of the device's location. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder longitude(java.lang.String longitude) {
                this.longitude = longitude;
                return this;
            }

            /**
             * Sets the value of {@link LocationActionProperty#getRoleArn}
             * @param roleArn The IAM role that grants permission to write to the Amazon Location resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link LocationActionProperty#getTrackerName}
             * @param trackerName The name of the tracker resource in Amazon Location in which the location is updated. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trackerName(java.lang.String trackerName) {
                this.trackerName = trackerName;
                return this;
            }

            /**
             * Sets the value of {@link LocationActionProperty#getTimestamp}
             * @param timestamp The time that the location data was sampled.
             *                  The default value is the time the MQTT message was processed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestamp(software.amazon.awscdk.IResolvable timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            /**
             * Sets the value of {@link LocationActionProperty#getTimestamp}
             * @param timestamp The time that the location data was sampled.
             *                  The default value is the time the MQTT message was processed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestamp(software.amazon.awscdk.services.iot.CfnTopicRule.TimestampProperty timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LocationActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LocationActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LocationActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LocationActionProperty {
            private final java.lang.String deviceId;
            private final java.lang.String latitude;
            private final java.lang.String longitude;
            private final java.lang.String roleArn;
            private final java.lang.String trackerName;
            private final java.lang.Object timestamp;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deviceId = software.amazon.jsii.Kernel.get(this, "deviceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.latitude = software.amazon.jsii.Kernel.get(this, "latitude", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.longitude = software.amazon.jsii.Kernel.get(this, "longitude", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.trackerName = software.amazon.jsii.Kernel.get(this, "trackerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timestamp = software.amazon.jsii.Kernel.get(this, "timestamp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deviceId = java.util.Objects.requireNonNull(builder.deviceId, "deviceId is required");
                this.latitude = java.util.Objects.requireNonNull(builder.latitude, "latitude is required");
                this.longitude = java.util.Objects.requireNonNull(builder.longitude, "longitude is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.trackerName = java.util.Objects.requireNonNull(builder.trackerName, "trackerName is required");
                this.timestamp = builder.timestamp;
            }

            @Override
            public final java.lang.String getDeviceId() {
                return this.deviceId;
            }

            @Override
            public final java.lang.String getLatitude() {
                return this.latitude;
            }

            @Override
            public final java.lang.String getLongitude() {
                return this.longitude;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getTrackerName() {
                return this.trackerName;
            }

            @Override
            public final java.lang.Object getTimestamp() {
                return this.timestamp;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deviceId", om.valueToTree(this.getDeviceId()));
                data.set("latitude", om.valueToTree(this.getLatitude()));
                data.set("longitude", om.valueToTree(this.getLongitude()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("trackerName", om.valueToTree(this.getTrackerName()));
                if (this.getTimestamp() != null) {
                    data.set("timestamp", om.valueToTree(this.getTimestamp()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.LocationActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LocationActionProperty.Jsii$Proxy that = (LocationActionProperty.Jsii$Proxy) o;

                if (!deviceId.equals(that.deviceId)) return false;
                if (!latitude.equals(that.latitude)) return false;
                if (!longitude.equals(that.longitude)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!trackerName.equals(that.trackerName)) return false;
                return this.timestamp != null ? this.timestamp.equals(that.timestamp) : that.timestamp == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deviceId.hashCode();
                result = 31 * result + (this.latitude.hashCode());
                result = 31 * result + (this.longitude.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.trackerName.hashCode());
                result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an action that writes data to an Amazon OpenSearch Service domain.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * OpenSearchActionProperty openSearchActionProperty = OpenSearchActionProperty.builder()
     *         .endpoint("endpoint")
     *         .id("id")
     *         .index("index")
     *         .roleArn("roleArn")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.OpenSearchActionProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenSearchActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenSearchActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The endpoint of your OpenSearch domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html#cfn-iot-topicrule-opensearchaction-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html#cfn-iot-topicrule-opensearchaction-endpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndpoint();

        /**
         * The unique identifier for the document you are storing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html#cfn-iot-topicrule-opensearchaction-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html#cfn-iot-topicrule-opensearchaction-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The OpenSearch index where you want to store your data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html#cfn-iot-topicrule-opensearchaction-index">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html#cfn-iot-topicrule-opensearchaction-index</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndex();

        /**
         * The IAM role ARN that has access to OpenSearch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html#cfn-iot-topicrule-opensearchaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html#cfn-iot-topicrule-opensearchaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The type of document you are storing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html#cfn-iot-topicrule-opensearchaction-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html#cfn-iot-topicrule-opensearchaction-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link OpenSearchActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenSearchActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenSearchActionProperty> {
            java.lang.String endpoint;
            java.lang.String id;
            java.lang.String index;
            java.lang.String roleArn;
            java.lang.String type;

            /**
             * Sets the value of {@link OpenSearchActionProperty#getEndpoint}
             * @param endpoint The endpoint of your OpenSearch domain. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpoint(java.lang.String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchActionProperty#getId}
             * @param id The unique identifier for the document you are storing. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchActionProperty#getIndex}
             * @param index The OpenSearch index where you want to store your data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder index(java.lang.String index) {
                this.index = index;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchActionProperty#getRoleArn}
             * @param roleArn The IAM role ARN that has access to OpenSearch. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchActionProperty#getType}
             * @param type The type of document you are storing. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenSearchActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenSearchActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenSearchActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenSearchActionProperty {
            private final java.lang.String endpoint;
            private final java.lang.String id;
            private final java.lang.String index;
            private final java.lang.String roleArn;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.index = software.amazon.jsii.Kernel.get(this, "index", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpoint = java.util.Objects.requireNonNull(builder.endpoint, "endpoint is required");
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.index = java.util.Objects.requireNonNull(builder.index, "index is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getEndpoint() {
                return this.endpoint;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getIndex() {
                return this.index;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endpoint", om.valueToTree(this.getEndpoint()));
                data.set("id", om.valueToTree(this.getId()));
                data.set("index", om.valueToTree(this.getIndex()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.OpenSearchActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenSearchActionProperty.Jsii$Proxy that = (OpenSearchActionProperty.Jsii$Proxy) o;

                if (!endpoint.equals(that.endpoint)) return false;
                if (!id.equals(that.id)) return false;
                if (!index.equals(that.index)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.endpoint.hashCode();
                result = 31 * result + (this.id.hashCode());
                result = 31 * result + (this.index.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * An asset property value entry containing the following information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * PutAssetPropertyValueEntryProperty putAssetPropertyValueEntryProperty = PutAssetPropertyValueEntryProperty.builder()
     *         .propertyValues(List.of(AssetPropertyValueProperty.builder()
     *                 .timestamp(AssetPropertyTimestampProperty.builder()
     *                         .timeInSeconds("timeInSeconds")
     *                         // the properties below are optional
     *                         .offsetInNanos("offsetInNanos")
     *                         .build())
     *                 .value(AssetPropertyVariantProperty.builder()
     *                         .booleanValue("booleanValue")
     *                         .doubleValue("doubleValue")
     *                         .integerValue("integerValue")
     *                         .stringValue("stringValue")
     *                         .build())
     *                 // the properties below are optional
     *                 .quality("quality")
     *                 .build()))
     *         // the properties below are optional
     *         .assetId("assetId")
     *         .entryId("entryId")
     *         .propertyAlias("propertyAlias")
     *         .propertyId("propertyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.PutAssetPropertyValueEntryProperty")
    @software.amazon.jsii.Jsii.Proxy(PutAssetPropertyValueEntryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PutAssetPropertyValueEntryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of property values to insert that each contain timestamp, quality, and value (TQV) information.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-propertyvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-propertyvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPropertyValues();

        /**
         * The ID of the AWS IoT SiteWise asset.
         * <p>
         * You must specify either a <code>propertyAlias</code> or both an <code>aliasId</code> and a <code>propertyId</code> . Accepts substitution templates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-assetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-assetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAssetId() {
            return null;
        }

        /**
         * Optional.
         * <p>
         * A unique identifier for this entry that you can define to better track which message caused an error in case of failure. Accepts substitution templates. Defaults to a new UUID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-entryid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-entryid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEntryId() {
            return null;
        }

        /**
         * The name of the property alias associated with your asset property.
         * <p>
         * You must specify either a <code>propertyAlias</code> or both an <code>aliasId</code> and a <code>propertyId</code> . Accepts substitution templates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-propertyalias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-propertyalias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropertyAlias() {
            return null;
        }

        /**
         * The ID of the asset's property.
         * <p>
         * You must specify either a <code>propertyAlias</code> or both an <code>aliasId</code> and a <code>propertyId</code> . Accepts substitution templates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-propertyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-propertyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropertyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PutAssetPropertyValueEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PutAssetPropertyValueEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PutAssetPropertyValueEntryProperty> {
            java.lang.Object propertyValues;
            java.lang.String assetId;
            java.lang.String entryId;
            java.lang.String propertyAlias;
            java.lang.String propertyId;

            /**
             * Sets the value of {@link PutAssetPropertyValueEntryProperty#getPropertyValues}
             * @param propertyValues A list of property values to insert that each contain timestamp, quality, and value (TQV) information. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyValues(software.amazon.awscdk.IResolvable propertyValues) {
                this.propertyValues = propertyValues;
                return this;
            }

            /**
             * Sets the value of {@link PutAssetPropertyValueEntryProperty#getPropertyValues}
             * @param propertyValues A list of property values to insert that each contain timestamp, quality, and value (TQV) information. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyValues(java.util.List<? extends java.lang.Object> propertyValues) {
                this.propertyValues = propertyValues;
                return this;
            }

            /**
             * Sets the value of {@link PutAssetPropertyValueEntryProperty#getAssetId}
             * @param assetId The ID of the AWS IoT SiteWise asset.
             *                You must specify either a <code>propertyAlias</code> or both an <code>aliasId</code> and a <code>propertyId</code> . Accepts substitution templates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assetId(java.lang.String assetId) {
                this.assetId = assetId;
                return this;
            }

            /**
             * Sets the value of {@link PutAssetPropertyValueEntryProperty#getEntryId}
             * @param entryId Optional.
             *                A unique identifier for this entry that you can define to better track which message caused an error in case of failure. Accepts substitution templates. Defaults to a new UUID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entryId(java.lang.String entryId) {
                this.entryId = entryId;
                return this;
            }

            /**
             * Sets the value of {@link PutAssetPropertyValueEntryProperty#getPropertyAlias}
             * @param propertyAlias The name of the property alias associated with your asset property.
             *                      You must specify either a <code>propertyAlias</code> or both an <code>aliasId</code> and a <code>propertyId</code> . Accepts substitution templates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyAlias(java.lang.String propertyAlias) {
                this.propertyAlias = propertyAlias;
                return this;
            }

            /**
             * Sets the value of {@link PutAssetPropertyValueEntryProperty#getPropertyId}
             * @param propertyId The ID of the asset's property.
             *                   You must specify either a <code>propertyAlias</code> or both an <code>aliasId</code> and a <code>propertyId</code> . Accepts substitution templates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyId(java.lang.String propertyId) {
                this.propertyId = propertyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PutAssetPropertyValueEntryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PutAssetPropertyValueEntryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PutAssetPropertyValueEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PutAssetPropertyValueEntryProperty {
            private final java.lang.Object propertyValues;
            private final java.lang.String assetId;
            private final java.lang.String entryId;
            private final java.lang.String propertyAlias;
            private final java.lang.String propertyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.propertyValues = software.amazon.jsii.Kernel.get(this, "propertyValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.assetId = software.amazon.jsii.Kernel.get(this, "assetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.entryId = software.amazon.jsii.Kernel.get(this, "entryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyAlias = software.amazon.jsii.Kernel.get(this, "propertyAlias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyId = software.amazon.jsii.Kernel.get(this, "propertyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.propertyValues = java.util.Objects.requireNonNull(builder.propertyValues, "propertyValues is required");
                this.assetId = builder.assetId;
                this.entryId = builder.entryId;
                this.propertyAlias = builder.propertyAlias;
                this.propertyId = builder.propertyId;
            }

            @Override
            public final java.lang.Object getPropertyValues() {
                return this.propertyValues;
            }

            @Override
            public final java.lang.String getAssetId() {
                return this.assetId;
            }

            @Override
            public final java.lang.String getEntryId() {
                return this.entryId;
            }

            @Override
            public final java.lang.String getPropertyAlias() {
                return this.propertyAlias;
            }

            @Override
            public final java.lang.String getPropertyId() {
                return this.propertyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("propertyValues", om.valueToTree(this.getPropertyValues()));
                if (this.getAssetId() != null) {
                    data.set("assetId", om.valueToTree(this.getAssetId()));
                }
                if (this.getEntryId() != null) {
                    data.set("entryId", om.valueToTree(this.getEntryId()));
                }
                if (this.getPropertyAlias() != null) {
                    data.set("propertyAlias", om.valueToTree(this.getPropertyAlias()));
                }
                if (this.getPropertyId() != null) {
                    data.set("propertyId", om.valueToTree(this.getPropertyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.PutAssetPropertyValueEntryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PutAssetPropertyValueEntryProperty.Jsii$Proxy that = (PutAssetPropertyValueEntryProperty.Jsii$Proxy) o;

                if (!propertyValues.equals(that.propertyValues)) return false;
                if (this.assetId != null ? !this.assetId.equals(that.assetId) : that.assetId != null) return false;
                if (this.entryId != null ? !this.entryId.equals(that.entryId) : that.entryId != null) return false;
                if (this.propertyAlias != null ? !this.propertyAlias.equals(that.propertyAlias) : that.propertyAlias != null) return false;
                return this.propertyId != null ? this.propertyId.equals(that.propertyId) : that.propertyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.propertyValues.hashCode();
                result = 31 * result + (this.assetId != null ? this.assetId.hashCode() : 0);
                result = 31 * result + (this.entryId != null ? this.entryId.hashCode() : 0);
                result = 31 * result + (this.propertyAlias != null ? this.propertyAlias.hashCode() : 0);
                result = 31 * result + (this.propertyId != null ? this.propertyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The input for the DynamoActionVS action that specifies the DynamoDB table to which the message data will be written.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * PutItemInputProperty putItemInputProperty = PutItemInputProperty.builder()
     *         .tableName("tableName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putiteminput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putiteminput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.PutItemInputProperty")
    @software.amazon.jsii.Jsii.Proxy(PutItemInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PutItemInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The table where the message data will be written.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putiteminput.html#cfn-iot-topicrule-putiteminput-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putiteminput.html#cfn-iot-topicrule-putiteminput-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link PutItemInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PutItemInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PutItemInputProperty> {
            java.lang.String tableName;

            /**
             * Sets the value of {@link PutItemInputProperty#getTableName}
             * @param tableName The table where the message data will be written. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PutItemInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PutItemInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PutItemInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PutItemInputProperty {
            private final java.lang.String tableName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("tableName", om.valueToTree(this.getTableName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.PutItemInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PutItemInputProperty.Jsii$Proxy that = (PutItemInputProperty.Jsii$Proxy) o;

                return this.tableName.equals(that.tableName);
            }

            @Override
            public final int hashCode() {
                int result = this.tableName.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies MQTT Version 5.0 headers information. For more information, see <a href="https://docs.aws.amazon.com//iot/latest/developerguide/mqtt.html">MQTT</a> in the IoT Core Developer Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * RepublishActionHeadersProperty republishActionHeadersProperty = RepublishActionHeadersProperty.builder()
     *         .contentType("contentType")
     *         .correlationData("correlationData")
     *         .messageExpiry("messageExpiry")
     *         .payloadFormatIndicator("payloadFormatIndicator")
     *         .responseTopic("responseTopic")
     *         .userProperties(List.of(UserPropertyProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishactionheaders.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishactionheaders.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.RepublishActionHeadersProperty")
    @software.amazon.jsii.Jsii.Proxy(RepublishActionHeadersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RepublishActionHeadersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A UTF-8 encoded string that describes the content of the publishing message.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901118">Content Type</a> in the MQTT Version 5.0 specification.
         * <p>
         * Supports <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-substitution-templates.html">substitution templates</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishactionheaders.html#cfn-iot-topicrule-republishactionheaders-contenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishactionheaders.html#cfn-iot-topicrule-republishactionheaders-contenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentType() {
            return null;
        }

        /**
         * The base64-encoded binary data used by the sender of the request message to identify which request the response message is for.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901115">Correlation Data</a> in the MQTT Version 5.0 specification.
         * <p>
         * Supports <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-substitution-templates.html">substitution templates</a> .
         * <p>
         * <blockquote>
         * <p>
         * This binary data must be base64-encoded.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishactionheaders.html#cfn-iot-topicrule-republishactionheaders-correlationdata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishactionheaders.html#cfn-iot-topicrule-republishactionheaders-correlationdata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCorrelationData() {
            return null;
        }

        /**
         * A user-defined integer value that represents the message expiry interval at the broker.
         * <p>
         * If the messages haven't been sent to the subscribers within that interval, the message expires and is removed. The value of <code>messageExpiry</code> represents the number of seconds before it expires. For more information about the limits of <code>messageExpiry</code> , see <a href="https://docs.aws.amazon.com//general/latest/gr/iot-core.html#limits_iot">Message broker and protocol limits and quotas</a> in the IoT Core Reference Guide.
         * <p>
         * Supports <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-substitution-templates.html">substitution templates</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishactionheaders.html#cfn-iot-topicrule-republishactionheaders-messageexpiry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishactionheaders.html#cfn-iot-topicrule-republishactionheaders-messageexpiry</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageExpiry() {
            return null;
        }

        /**
         * An <code>Enum</code> string value that indicates whether the payload is formatted as UTF-8.
         * <p>
         * Valid values are <code>UNSPECIFIED_BYTES</code> and <code>UTF8_DATA</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901111">Payload Format Indicator</a> from the MQTT Version 5.0 specification.
         * <p>
         * Supports <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-substitution-templates.html">substitution templates</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishactionheaders.html#cfn-iot-topicrule-republishactionheaders-payloadformatindicator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishactionheaders.html#cfn-iot-topicrule-republishactionheaders-payloadformatindicator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPayloadFormatIndicator() {
            return null;
        }

        /**
         * A UTF-8 encoded string that's used as the topic name for a response message.
         * <p>
         * The response topic is used to describe the topic to which the receiver should publish as part of the request-response flow. The topic must not contain wildcard characters.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901114">Response Topic</a> in the MQTT Version 5.0 specification.
         * <p>
         * Supports <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-substitution-templates.html">substitution templates</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishactionheaders.html#cfn-iot-topicrule-republishactionheaders-responsetopic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishactionheaders.html#cfn-iot-topicrule-republishactionheaders-responsetopic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResponseTopic() {
            return null;
        }

        /**
         * An array of key-value pairs that you define in the MQTT5 header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishactionheaders.html#cfn-iot-topicrule-republishactionheaders-userproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishactionheaders.html#cfn-iot-topicrule-republishactionheaders-userproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RepublishActionHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RepublishActionHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RepublishActionHeadersProperty> {
            java.lang.String contentType;
            java.lang.String correlationData;
            java.lang.String messageExpiry;
            java.lang.String payloadFormatIndicator;
            java.lang.String responseTopic;
            java.lang.Object userProperties;

            /**
             * Sets the value of {@link RepublishActionHeadersProperty#getContentType}
             * @param contentType A UTF-8 encoded string that describes the content of the publishing message.
             *                    For more information, see <a href="https://docs.aws.amazon.com/https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901118">Content Type</a> in the MQTT Version 5.0 specification.
             *                    <p>
             *                    Supports <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-substitution-templates.html">substitution templates</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentType(java.lang.String contentType) {
                this.contentType = contentType;
                return this;
            }

            /**
             * Sets the value of {@link RepublishActionHeadersProperty#getCorrelationData}
             * @param correlationData The base64-encoded binary data used by the sender of the request message to identify which request the response message is for.
             *                        For more information, see <a href="https://docs.aws.amazon.com/https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901115">Correlation Data</a> in the MQTT Version 5.0 specification.
             *                        <p>
             *                        Supports <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-substitution-templates.html">substitution templates</a> .
             *                        <p>
             *                        <blockquote>
             *                        <p>
             *                        This binary data must be base64-encoded.
             *                        <p>
             *                        </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder correlationData(java.lang.String correlationData) {
                this.correlationData = correlationData;
                return this;
            }

            /**
             * Sets the value of {@link RepublishActionHeadersProperty#getMessageExpiry}
             * @param messageExpiry A user-defined integer value that represents the message expiry interval at the broker.
             *                      If the messages haven't been sent to the subscribers within that interval, the message expires and is removed. The value of <code>messageExpiry</code> represents the number of seconds before it expires. For more information about the limits of <code>messageExpiry</code> , see <a href="https://docs.aws.amazon.com//general/latest/gr/iot-core.html#limits_iot">Message broker and protocol limits and quotas</a> in the IoT Core Reference Guide.
             *                      <p>
             *                      Supports <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-substitution-templates.html">substitution templates</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageExpiry(java.lang.String messageExpiry) {
                this.messageExpiry = messageExpiry;
                return this;
            }

            /**
             * Sets the value of {@link RepublishActionHeadersProperty#getPayloadFormatIndicator}
             * @param payloadFormatIndicator An <code>Enum</code> string value that indicates whether the payload is formatted as UTF-8.
             *                               Valid values are <code>UNSPECIFIED_BYTES</code> and <code>UTF8_DATA</code> .
             *                               <p>
             *                               For more information, see <a href="https://docs.aws.amazon.com/https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901111">Payload Format Indicator</a> from the MQTT Version 5.0 specification.
             *                               <p>
             *                               Supports <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-substitution-templates.html">substitution templates</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payloadFormatIndicator(java.lang.String payloadFormatIndicator) {
                this.payloadFormatIndicator = payloadFormatIndicator;
                return this;
            }

            /**
             * Sets the value of {@link RepublishActionHeadersProperty#getResponseTopic}
             * @param responseTopic A UTF-8 encoded string that's used as the topic name for a response message.
             *                      The response topic is used to describe the topic to which the receiver should publish as part of the request-response flow. The topic must not contain wildcard characters.
             *                      <p>
             *                      For more information, see <a href="https://docs.aws.amazon.com/https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901114">Response Topic</a> in the MQTT Version 5.0 specification.
             *                      <p>
             *                      Supports <a href="https://docs.aws.amazon.com//iot/latest/developerguide/iot-substitution-templates.html">substitution templates</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseTopic(java.lang.String responseTopic) {
                this.responseTopic = responseTopic;
                return this;
            }

            /**
             * Sets the value of {@link RepublishActionHeadersProperty#getUserProperties}
             * @param userProperties An array of key-value pairs that you define in the MQTT5 header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userProperties(software.amazon.awscdk.IResolvable userProperties) {
                this.userProperties = userProperties;
                return this;
            }

            /**
             * Sets the value of {@link RepublishActionHeadersProperty#getUserProperties}
             * @param userProperties An array of key-value pairs that you define in the MQTT5 header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userProperties(java.util.List<? extends java.lang.Object> userProperties) {
                this.userProperties = userProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RepublishActionHeadersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RepublishActionHeadersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RepublishActionHeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RepublishActionHeadersProperty {
            private final java.lang.String contentType;
            private final java.lang.String correlationData;
            private final java.lang.String messageExpiry;
            private final java.lang.String payloadFormatIndicator;
            private final java.lang.String responseTopic;
            private final java.lang.Object userProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.correlationData = software.amazon.jsii.Kernel.get(this, "correlationData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.messageExpiry = software.amazon.jsii.Kernel.get(this, "messageExpiry", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payloadFormatIndicator = software.amazon.jsii.Kernel.get(this, "payloadFormatIndicator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.responseTopic = software.amazon.jsii.Kernel.get(this, "responseTopic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userProperties = software.amazon.jsii.Kernel.get(this, "userProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.contentType = builder.contentType;
                this.correlationData = builder.correlationData;
                this.messageExpiry = builder.messageExpiry;
                this.payloadFormatIndicator = builder.payloadFormatIndicator;
                this.responseTopic = builder.responseTopic;
                this.userProperties = builder.userProperties;
            }

            @Override
            public final java.lang.String getContentType() {
                return this.contentType;
            }

            @Override
            public final java.lang.String getCorrelationData() {
                return this.correlationData;
            }

            @Override
            public final java.lang.String getMessageExpiry() {
                return this.messageExpiry;
            }

            @Override
            public final java.lang.String getPayloadFormatIndicator() {
                return this.payloadFormatIndicator;
            }

            @Override
            public final java.lang.String getResponseTopic() {
                return this.responseTopic;
            }

            @Override
            public final java.lang.Object getUserProperties() {
                return this.userProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContentType() != null) {
                    data.set("contentType", om.valueToTree(this.getContentType()));
                }
                if (this.getCorrelationData() != null) {
                    data.set("correlationData", om.valueToTree(this.getCorrelationData()));
                }
                if (this.getMessageExpiry() != null) {
                    data.set("messageExpiry", om.valueToTree(this.getMessageExpiry()));
                }
                if (this.getPayloadFormatIndicator() != null) {
                    data.set("payloadFormatIndicator", om.valueToTree(this.getPayloadFormatIndicator()));
                }
                if (this.getResponseTopic() != null) {
                    data.set("responseTopic", om.valueToTree(this.getResponseTopic()));
                }
                if (this.getUserProperties() != null) {
                    data.set("userProperties", om.valueToTree(this.getUserProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.RepublishActionHeadersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RepublishActionHeadersProperty.Jsii$Proxy that = (RepublishActionHeadersProperty.Jsii$Proxy) o;

                if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
                if (this.correlationData != null ? !this.correlationData.equals(that.correlationData) : that.correlationData != null) return false;
                if (this.messageExpiry != null ? !this.messageExpiry.equals(that.messageExpiry) : that.messageExpiry != null) return false;
                if (this.payloadFormatIndicator != null ? !this.payloadFormatIndicator.equals(that.payloadFormatIndicator) : that.payloadFormatIndicator != null) return false;
                if (this.responseTopic != null ? !this.responseTopic.equals(that.responseTopic) : that.responseTopic != null) return false;
                return this.userProperties != null ? this.userProperties.equals(that.userProperties) : that.userProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.contentType != null ? this.contentType.hashCode() : 0;
                result = 31 * result + (this.correlationData != null ? this.correlationData.hashCode() : 0);
                result = 31 * result + (this.messageExpiry != null ? this.messageExpiry.hashCode() : 0);
                result = 31 * result + (this.payloadFormatIndicator != null ? this.payloadFormatIndicator.hashCode() : 0);
                result = 31 * result + (this.responseTopic != null ? this.responseTopic.hashCode() : 0);
                result = 31 * result + (this.userProperties != null ? this.userProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an action to republish to another topic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * RepublishActionProperty republishActionProperty = RepublishActionProperty.builder()
     *         .roleArn("roleArn")
     *         .topic("topic")
     *         // the properties below are optional
     *         .headers(RepublishActionHeadersProperty.builder()
     *                 .contentType("contentType")
     *                 .correlationData("correlationData")
     *                 .messageExpiry("messageExpiry")
     *                 .payloadFormatIndicator("payloadFormatIndicator")
     *                 .responseTopic("responseTopic")
     *                 .userProperties(List.of(UserPropertyProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .qos(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.RepublishActionProperty")
    @software.amazon.jsii.Jsii.Proxy(RepublishActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RepublishActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the IAM role that grants access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html#cfn-iot-topicrule-republishaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html#cfn-iot-topicrule-republishaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The name of the MQTT topic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html#cfn-iot-topicrule-republishaction-topic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html#cfn-iot-topicrule-republishaction-topic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTopic();

        /**
         * MQTT Version 5.0 headers information. For more information, see <a href="https://docs.aws.amazon.com//iot/latest/developerguide/mqtt.html">MQTT</a> in the IoT Core Developer Guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html#cfn-iot-topicrule-republishaction-headers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html#cfn-iot-topicrule-republishaction-headers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeaders() {
            return null;
        }

        /**
         * The Quality of Service (QoS) level to use when republishing messages.
         * <p>
         * The default value is 0.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html#cfn-iot-topicrule-republishaction-qos">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html#cfn-iot-topicrule-republishaction-qos</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getQos() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RepublishActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RepublishActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RepublishActionProperty> {
            java.lang.String roleArn;
            java.lang.String topic;
            java.lang.Object headers;
            java.lang.Number qos;

            /**
             * Sets the value of {@link RepublishActionProperty#getRoleArn}
             * @param roleArn The ARN of the IAM role that grants access. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link RepublishActionProperty#getTopic}
             * @param topic The name of the MQTT topic. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topic(java.lang.String topic) {
                this.topic = topic;
                return this;
            }

            /**
             * Sets the value of {@link RepublishActionProperty#getHeaders}
             * @param headers MQTT Version 5.0 headers information. For more information, see <a href="https://docs.aws.amazon.com//iot/latest/developerguide/mqtt.html">MQTT</a> in the IoT Core Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(software.amazon.awscdk.IResolvable headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link RepublishActionProperty#getHeaders}
             * @param headers MQTT Version 5.0 headers information. For more information, see <a href="https://docs.aws.amazon.com//iot/latest/developerguide/mqtt.html">MQTT</a> in the IoT Core Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(software.amazon.awscdk.services.iot.CfnTopicRule.RepublishActionHeadersProperty headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link RepublishActionProperty#getQos}
             * @param qos The Quality of Service (QoS) level to use when republishing messages.
             *            The default value is 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder qos(java.lang.Number qos) {
                this.qos = qos;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RepublishActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RepublishActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RepublishActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RepublishActionProperty {
            private final java.lang.String roleArn;
            private final java.lang.String topic;
            private final java.lang.Object headers;
            private final java.lang.Number qos;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.topic = software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.qos = software.amazon.jsii.Kernel.get(this, "qos", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.topic = java.util.Objects.requireNonNull(builder.topic, "topic is required");
                this.headers = builder.headers;
                this.qos = builder.qos;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getTopic() {
                return this.topic;
            }

            @Override
            public final java.lang.Object getHeaders() {
                return this.headers;
            }

            @Override
            public final java.lang.Number getQos() {
                return this.qos;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("topic", om.valueToTree(this.getTopic()));
                if (this.getHeaders() != null) {
                    data.set("headers", om.valueToTree(this.getHeaders()));
                }
                if (this.getQos() != null) {
                    data.set("qos", om.valueToTree(this.getQos()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.RepublishActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RepublishActionProperty.Jsii$Proxy that = (RepublishActionProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                if (!topic.equals(that.topic)) return false;
                if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) return false;
                return this.qos != null ? this.qos.equals(that.qos) : that.qos == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.topic.hashCode());
                result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
                result = 31 * result + (this.qos != null ? this.qos.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an action to write data to an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * S3ActionProperty s3ActionProperty = S3ActionProperty.builder()
     *         .bucketName("bucketName")
     *         .key("key")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .cannedAcl("cannedAcl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.S3ActionProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The object key.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, resources, and condition keys for Amazon S3</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The ARN of the IAM role that grants access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The Amazon S3 canned ACL that controls access to the object identified by the object key.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-cannedacl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-cannedacl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCannedAcl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ActionProperty> {
            java.lang.String bucketName;
            java.lang.String key;
            java.lang.String roleArn;
            java.lang.String cannedAcl;

            /**
             * Sets the value of {@link S3ActionProperty#getBucketName}
             * @param bucketName The Amazon S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3ActionProperty#getKey}
             * @param key The object key. This parameter is required.
             *            For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html">Actions, resources, and condition keys for Amazon S3</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link S3ActionProperty#getRoleArn}
             * @param roleArn The ARN of the IAM role that grants access. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link S3ActionProperty#getCannedAcl}
             * @param cannedAcl The Amazon S3 canned ACL that controls access to the object identified by the object key.
             *                  For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cannedAcl(java.lang.String cannedAcl) {
                this.cannedAcl = cannedAcl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ActionProperty {
            private final java.lang.String bucketName;
            private final java.lang.String key;
            private final java.lang.String roleArn;
            private final java.lang.String cannedAcl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cannedAcl = software.amazon.jsii.Kernel.get(this, "cannedAcl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.cannedAcl = builder.cannedAcl;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getCannedAcl() {
                return this.cannedAcl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                data.set("key", om.valueToTree(this.getKey()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getCannedAcl() != null) {
                    data.set("cannedAcl", om.valueToTree(this.getCannedAcl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.S3ActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ActionProperty.Jsii$Proxy that = (S3ActionProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (!key.equals(that.key)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                return this.cannedAcl != null ? this.cannedAcl.equals(that.cannedAcl) : that.cannedAcl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.cannedAcl != null ? this.cannedAcl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 signing process</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * SigV4AuthorizationProperty sigV4AuthorizationProperty = SigV4AuthorizationProperty.builder()
     *         .roleArn("roleArn")
     *         .serviceName("serviceName")
     *         .signingRegion("signingRegion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sigv4authorization.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sigv4authorization.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.SigV4AuthorizationProperty")
    @software.amazon.jsii.Jsii.Proxy(SigV4AuthorizationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SigV4AuthorizationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the signing role.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sigv4authorization.html#cfn-iot-topicrule-sigv4authorization-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sigv4authorization.html#cfn-iot-topicrule-sigv4authorization-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The service name to use while signing with Sig V4.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sigv4authorization.html#cfn-iot-topicrule-sigv4authorization-servicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sigv4authorization.html#cfn-iot-topicrule-sigv4authorization-servicename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServiceName();

        /**
         * The signing region.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sigv4authorization.html#cfn-iot-topicrule-sigv4authorization-signingregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sigv4authorization.html#cfn-iot-topicrule-sigv4authorization-signingregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSigningRegion();

        /**
         * @return a {@link Builder} of {@link SigV4AuthorizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SigV4AuthorizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SigV4AuthorizationProperty> {
            java.lang.String roleArn;
            java.lang.String serviceName;
            java.lang.String signingRegion;

            /**
             * Sets the value of {@link SigV4AuthorizationProperty#getRoleArn}
             * @param roleArn The ARN of the signing role. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link SigV4AuthorizationProperty#getServiceName}
             * @param serviceName The service name to use while signing with Sig V4. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceName(java.lang.String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            /**
             * Sets the value of {@link SigV4AuthorizationProperty#getSigningRegion}
             * @param signingRegion The signing region. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder signingRegion(java.lang.String signingRegion) {
                this.signingRegion = signingRegion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SigV4AuthorizationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SigV4AuthorizationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SigV4AuthorizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SigV4AuthorizationProperty {
            private final java.lang.String roleArn;
            private final java.lang.String serviceName;
            private final java.lang.String signingRegion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.signingRegion = software.amazon.jsii.Kernel.get(this, "signingRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.serviceName = java.util.Objects.requireNonNull(builder.serviceName, "serviceName is required");
                this.signingRegion = java.util.Objects.requireNonNull(builder.signingRegion, "signingRegion is required");
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getServiceName() {
                return this.serviceName;
            }

            @Override
            public final java.lang.String getSigningRegion() {
                return this.signingRegion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("serviceName", om.valueToTree(this.getServiceName()));
                data.set("signingRegion", om.valueToTree(this.getSigningRegion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.SigV4AuthorizationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SigV4AuthorizationProperty.Jsii$Proxy that = (SigV4AuthorizationProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                if (!serviceName.equals(that.serviceName)) return false;
                return this.signingRegion.equals(that.signingRegion);
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.serviceName.hashCode());
                result = 31 * result + (this.signingRegion.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes an action to publish to an Amazon SNS topic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * SnsActionProperty snsActionProperty = SnsActionProperty.builder()
     *         .roleArn("roleArn")
     *         .targetArn("targetArn")
     *         // the properties below are optional
     *         .messageFormat("messageFormat")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.SnsActionProperty")
    @software.amazon.jsii.Jsii.Proxy(SnsActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnsActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the IAM role that grants access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html#cfn-iot-topicrule-snsaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html#cfn-iot-topicrule-snsaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The ARN of the SNS topic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html#cfn-iot-topicrule-snsaction-targetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html#cfn-iot-topicrule-snsaction-targetarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetArn();

        /**
         * (Optional) The message format of the message to publish.
         * <p>
         * Accepted values are "JSON" and "RAW". The default value of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and relevant platform-specific bits of the payload should be extracted. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/json-formats.html">Amazon SNS Message and JSON Formats</a> in the <em>Amazon Simple Notification Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html#cfn-iot-topicrule-snsaction-messageformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html#cfn-iot-topicrule-snsaction-messageformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnsActionProperty> {
            java.lang.String roleArn;
            java.lang.String targetArn;
            java.lang.String messageFormat;

            /**
             * Sets the value of {@link SnsActionProperty#getRoleArn}
             * @param roleArn The ARN of the IAM role that grants access. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link SnsActionProperty#getTargetArn}
             * @param targetArn The ARN of the SNS topic. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetArn(java.lang.String targetArn) {
                this.targetArn = targetArn;
                return this;
            }

            /**
             * Sets the value of {@link SnsActionProperty#getMessageFormat}
             * @param messageFormat (Optional) The message format of the message to publish.
             *                      Accepted values are "JSON" and "RAW". The default value of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and relevant platform-specific bits of the payload should be extracted. For more information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/json-formats.html">Amazon SNS Message and JSON Formats</a> in the <em>Amazon Simple Notification Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageFormat(java.lang.String messageFormat) {
                this.messageFormat = messageFormat;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnsActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnsActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnsActionProperty {
            private final java.lang.String roleArn;
            private final java.lang.String targetArn;
            private final java.lang.String messageFormat;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetArn = software.amazon.jsii.Kernel.get(this, "targetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.messageFormat = software.amazon.jsii.Kernel.get(this, "messageFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.targetArn = java.util.Objects.requireNonNull(builder.targetArn, "targetArn is required");
                this.messageFormat = builder.messageFormat;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getTargetArn() {
                return this.targetArn;
            }

            @Override
            public final java.lang.String getMessageFormat() {
                return this.messageFormat;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("targetArn", om.valueToTree(this.getTargetArn()));
                if (this.getMessageFormat() != null) {
                    data.set("messageFormat", om.valueToTree(this.getMessageFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.SnsActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnsActionProperty.Jsii$Proxy that = (SnsActionProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                if (!targetArn.equals(that.targetArn)) return false;
                return this.messageFormat != null ? this.messageFormat.equals(that.messageFormat) : that.messageFormat == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.targetArn.hashCode());
                result = 31 * result + (this.messageFormat != null ? this.messageFormat.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an action to publish data to an Amazon SQS queue.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * SqsActionProperty sqsActionProperty = SqsActionProperty.builder()
     *         .queueUrl("queueUrl")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .useBase64(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.SqsActionProperty")
    @software.amazon.jsii.Jsii.Proxy(SqsActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SqsActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URL of the Amazon SQS queue.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html#cfn-iot-topicrule-sqsaction-queueurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html#cfn-iot-topicrule-sqsaction-queueurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueueUrl();

        /**
         * The ARN of the IAM role that grants access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html#cfn-iot-topicrule-sqsaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html#cfn-iot-topicrule-sqsaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * Specifies whether to use Base64 encoding.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html#cfn-iot-topicrule-sqsaction-usebase64">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html#cfn-iot-topicrule-sqsaction-usebase64</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseBase64() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SqsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SqsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SqsActionProperty> {
            java.lang.String queueUrl;
            java.lang.String roleArn;
            java.lang.Object useBase64;

            /**
             * Sets the value of {@link SqsActionProperty#getQueueUrl}
             * @param queueUrl The URL of the Amazon SQS queue. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queueUrl(java.lang.String queueUrl) {
                this.queueUrl = queueUrl;
                return this;
            }

            /**
             * Sets the value of {@link SqsActionProperty#getRoleArn}
             * @param roleArn The ARN of the IAM role that grants access. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link SqsActionProperty#getUseBase64}
             * @param useBase64 Specifies whether to use Base64 encoding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useBase64(java.lang.Boolean useBase64) {
                this.useBase64 = useBase64;
                return this;
            }

            /**
             * Sets the value of {@link SqsActionProperty#getUseBase64}
             * @param useBase64 Specifies whether to use Base64 encoding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useBase64(software.amazon.awscdk.IResolvable useBase64) {
                this.useBase64 = useBase64;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SqsActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SqsActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SqsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SqsActionProperty {
            private final java.lang.String queueUrl;
            private final java.lang.String roleArn;
            private final java.lang.Object useBase64;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queueUrl = software.amazon.jsii.Kernel.get(this, "queueUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.useBase64 = software.amazon.jsii.Kernel.get(this, "useBase64", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queueUrl = java.util.Objects.requireNonNull(builder.queueUrl, "queueUrl is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.useBase64 = builder.useBase64;
            }

            @Override
            public final java.lang.String getQueueUrl() {
                return this.queueUrl;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getUseBase64() {
                return this.useBase64;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queueUrl", om.valueToTree(this.getQueueUrl()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getUseBase64() != null) {
                    data.set("useBase64", om.valueToTree(this.getUseBase64()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.SqsActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SqsActionProperty.Jsii$Proxy that = (SqsActionProperty.Jsii$Proxy) o;

                if (!queueUrl.equals(that.queueUrl)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                return this.useBase64 != null ? this.useBase64.equals(that.useBase64) : that.useBase64 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.queueUrl.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.useBase64 != null ? this.useBase64.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Starts execution of a Step Functions state machine.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * StepFunctionsActionProperty stepFunctionsActionProperty = StepFunctionsActionProperty.builder()
     *         .roleArn("roleArn")
     *         .stateMachineName("stateMachineName")
     *         // the properties below are optional
     *         .executionNamePrefix("executionNamePrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.StepFunctionsActionProperty")
    @software.amazon.jsii.Jsii.Proxy(StepFunctionsActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StepFunctionsActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the role that grants IoT permission to start execution of a state machine ("Action":"states:StartExecution").
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html#cfn-iot-topicrule-stepfunctionsaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html#cfn-iot-topicrule-stepfunctionsaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The name of the Step Functions state machine whose execution will be started.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html#cfn-iot-topicrule-stepfunctionsaction-statemachinename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html#cfn-iot-topicrule-stepfunctionsaction-statemachinename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStateMachineName();

        /**
         * (Optional) A name will be given to the state machine execution consisting of this prefix followed by a UUID.
         * <p>
         * Step Functions automatically creates a unique name for each state machine execution if one is not provided.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html#cfn-iot-topicrule-stepfunctionsaction-executionnameprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html#cfn-iot-topicrule-stepfunctionsaction-executionnameprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutionNamePrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StepFunctionsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StepFunctionsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StepFunctionsActionProperty> {
            java.lang.String roleArn;
            java.lang.String stateMachineName;
            java.lang.String executionNamePrefix;

            /**
             * Sets the value of {@link StepFunctionsActionProperty#getRoleArn}
             * @param roleArn The ARN of the role that grants IoT permission to start execution of a state machine ("Action":"states:StartExecution"). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link StepFunctionsActionProperty#getStateMachineName}
             * @param stateMachineName The name of the Step Functions state machine whose execution will be started. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stateMachineName(java.lang.String stateMachineName) {
                this.stateMachineName = stateMachineName;
                return this;
            }

            /**
             * Sets the value of {@link StepFunctionsActionProperty#getExecutionNamePrefix}
             * @param executionNamePrefix (Optional) A name will be given to the state machine execution consisting of this prefix followed by a UUID.
             *                            Step Functions automatically creates a unique name for each state machine execution if one is not provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionNamePrefix(java.lang.String executionNamePrefix) {
                this.executionNamePrefix = executionNamePrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StepFunctionsActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StepFunctionsActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StepFunctionsActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepFunctionsActionProperty {
            private final java.lang.String roleArn;
            private final java.lang.String stateMachineName;
            private final java.lang.String executionNamePrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stateMachineName = software.amazon.jsii.Kernel.get(this, "stateMachineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.executionNamePrefix = software.amazon.jsii.Kernel.get(this, "executionNamePrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.stateMachineName = java.util.Objects.requireNonNull(builder.stateMachineName, "stateMachineName is required");
                this.executionNamePrefix = builder.executionNamePrefix;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getStateMachineName() {
                return this.stateMachineName;
            }

            @Override
            public final java.lang.String getExecutionNamePrefix() {
                return this.executionNamePrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("stateMachineName", om.valueToTree(this.getStateMachineName()));
                if (this.getExecutionNamePrefix() != null) {
                    data.set("executionNamePrefix", om.valueToTree(this.getExecutionNamePrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.StepFunctionsActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StepFunctionsActionProperty.Jsii$Proxy that = (StepFunctionsActionProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                if (!stateMachineName.equals(that.stateMachineName)) return false;
                return this.executionNamePrefix != null ? this.executionNamePrefix.equals(that.executionNamePrefix) : that.executionNamePrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.stateMachineName.hashCode());
                result = 31 * result + (this.executionNamePrefix != null ? this.executionNamePrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes how to interpret an application-defined timestamp value from an MQTT message payload and the precision of that value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * TimestampProperty timestampProperty = TimestampProperty.builder()
     *         .value("value")
     *         // the properties below are optional
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestamp.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestamp.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.TimestampProperty")
    @software.amazon.jsii.Jsii.Proxy(TimestampProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimestampProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An expression that returns a long epoch time value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestamp.html#cfn-iot-topicrule-timestamp-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestamp.html#cfn-iot-topicrule-timestamp-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * The precision of the timestamp value that results from the expression described in <code>value</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestamp.html#cfn-iot-topicrule-timestamp-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestamp.html#cfn-iot-topicrule-timestamp-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TimestampProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimestampProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimestampProperty> {
            java.lang.String value;
            java.lang.String unit;

            /**
             * Sets the value of {@link TimestampProperty#getValue}
             * @param value An expression that returns a long epoch time value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link TimestampProperty#getUnit}
             * @param unit The precision of the timestamp value that results from the expression described in <code>value</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimestampProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimestampProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimestampProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimestampProperty {
            private final java.lang.String value;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.TimestampProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimestampProperty.Jsii$Proxy that = (TimestampProperty.Jsii$Proxy) o;

                if (!value.equals(that.value)) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an action that writes records into an Amazon Timestream table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * TimestreamActionProperty timestreamActionProperty = TimestreamActionProperty.builder()
     *         .databaseName("databaseName")
     *         .dimensions(List.of(TimestreamDimensionProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .roleArn("roleArn")
     *         .tableName("tableName")
     *         // the properties below are optional
     *         .timestamp(TimestreamTimestampProperty.builder()
     *                 .unit("unit")
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.TimestreamActionProperty")
    @software.amazon.jsii.Jsii.Proxy(TimestreamActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimestreamActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of an Amazon Timestream database that has the table to write records into.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html#cfn-iot-topicrule-timestreamaction-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html#cfn-iot-topicrule-timestreamaction-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * Metadata attributes of the time series that are written in each measure record.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html#cfn-iot-topicrule-timestreamaction-dimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html#cfn-iot-topicrule-timestreamaction-dimensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDimensions();

        /**
         * The Amazon Resource Name (ARN) of the role that grants AWS IoT permission to write to the Timestream database table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html#cfn-iot-topicrule-timestreamaction-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html#cfn-iot-topicrule-timestreamaction-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The table where the message data will be written.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html#cfn-iot-topicrule-timestreamaction-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html#cfn-iot-topicrule-timestreamaction-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * The value to use for the entry's timestamp.
         * <p>
         * If blank, the time that the entry was processed is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html#cfn-iot-topicrule-timestreamaction-timestamp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html#cfn-iot-topicrule-timestreamaction-timestamp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimestamp() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TimestreamActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimestreamActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimestreamActionProperty> {
            java.lang.String databaseName;
            java.lang.Object dimensions;
            java.lang.String roleArn;
            java.lang.String tableName;
            java.lang.Object timestamp;

            /**
             * Sets the value of {@link TimestreamActionProperty#getDatabaseName}
             * @param databaseName The name of an Amazon Timestream database that has the table to write records into. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamActionProperty#getDimensions}
             * @param dimensions Metadata attributes of the time series that are written in each measure record. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamActionProperty#getDimensions}
             * @param dimensions Metadata attributes of the time series that are written in each measure record. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamActionProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the role that grants AWS IoT permission to write to the Timestream database table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamActionProperty#getTableName}
             * @param tableName The table where the message data will be written. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamActionProperty#getTimestamp}
             * @param timestamp The value to use for the entry's timestamp.
             *                  If blank, the time that the entry was processed is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestamp(software.amazon.awscdk.IResolvable timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamActionProperty#getTimestamp}
             * @param timestamp The value to use for the entry's timestamp.
             *                  If blank, the time that the entry was processed is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestamp(software.amazon.awscdk.services.iot.CfnTopicRule.TimestreamTimestampProperty timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimestreamActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimestreamActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimestreamActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimestreamActionProperty {
            private final java.lang.String databaseName;
            private final java.lang.Object dimensions;
            private final java.lang.String roleArn;
            private final java.lang.String tableName;
            private final java.lang.Object timestamp;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timestamp = software.amazon.jsii.Kernel.get(this, "timestamp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.dimensions = java.util.Objects.requireNonNull(builder.dimensions, "dimensions is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
                this.timestamp = builder.timestamp;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.Object getTimestamp() {
                return this.timestamp;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("dimensions", om.valueToTree(this.getDimensions()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("tableName", om.valueToTree(this.getTableName()));
                if (this.getTimestamp() != null) {
                    data.set("timestamp", om.valueToTree(this.getTimestamp()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.TimestreamActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimestreamActionProperty.Jsii$Proxy that = (TimestreamActionProperty.Jsii$Proxy) o;

                if (!databaseName.equals(that.databaseName)) return false;
                if (!dimensions.equals(that.dimensions)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!tableName.equals(that.tableName)) return false;
                return this.timestamp != null ? this.timestamp.equals(that.timestamp) : that.timestamp == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName.hashCode();
                result = 31 * result + (this.dimensions.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.tableName.hashCode());
                result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Metadata attributes of the time series that are written in each measure record.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * TimestreamDimensionProperty timestreamDimensionProperty = TimestreamDimensionProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamdimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamdimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.TimestreamDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(TimestreamDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimestreamDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metadata dimension name.
         * <p>
         * This is the name of the column in the Amazon Timestream database table record.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamdimension.html#cfn-iot-topicrule-timestreamdimension-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamdimension.html#cfn-iot-topicrule-timestreamdimension-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value to write in this column of the database record.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamdimension.html#cfn-iot-topicrule-timestreamdimension-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamdimension.html#cfn-iot-topicrule-timestreamdimension-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link TimestreamDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimestreamDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimestreamDimensionProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link TimestreamDimensionProperty#getName}
             * @param name The metadata dimension name. This parameter is required.
             *             This is the name of the column in the Amazon Timestream database table record.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamDimensionProperty#getValue}
             * @param value The value to write in this column of the database record. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimestreamDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimestreamDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimestreamDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimestreamDimensionProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.TimestreamDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimestreamDimensionProperty.Jsii$Proxy that = (TimestreamDimensionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The value to use for the entry's timestamp.
     * <p>
     * If blank, the time that the entry was processed is used.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * TimestreamTimestampProperty timestreamTimestampProperty = TimestreamTimestampProperty.builder()
     *         .unit("unit")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamtimestamp.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamtimestamp.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.TimestreamTimestampProperty")
    @software.amazon.jsii.Jsii.Proxy(TimestreamTimestampProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimestreamTimestampProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The precision of the timestamp value that results from the expression described in <code>value</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamtimestamp.html#cfn-iot-topicrule-timestreamtimestamp-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamtimestamp.html#cfn-iot-topicrule-timestreamtimestamp-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnit();

        /**
         * An expression that returns a long epoch time value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamtimestamp.html#cfn-iot-topicrule-timestreamtimestamp-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamtimestamp.html#cfn-iot-topicrule-timestreamtimestamp-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link TimestreamTimestampProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimestreamTimestampProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimestreamTimestampProperty> {
            java.lang.String unit;
            java.lang.String value;

            /**
             * Sets the value of {@link TimestreamTimestampProperty#getUnit}
             * @param unit The precision of the timestamp value that results from the expression described in <code>value</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Sets the value of {@link TimestreamTimestampProperty#getValue}
             * @param value An expression that returns a long epoch time value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimestreamTimestampProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimestreamTimestampProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimestreamTimestampProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimestreamTimestampProperty {
            private final java.lang.String unit;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.unit = java.util.Objects.requireNonNull(builder.unit, "unit is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("unit", om.valueToTree(this.getUnit()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.TimestreamTimestampProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimestreamTimestampProperty.Jsii$Proxy that = (TimestreamTimestampProperty.Jsii$Proxy) o;

                if (!unit.equals(that.unit)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.unit.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes a rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * TopicRulePayloadProperty topicRulePayloadProperty = TopicRulePayloadProperty.builder()
     *         .actions(List.of(ActionProperty.builder()
     *                 .cloudwatchAlarm(CloudwatchAlarmActionProperty.builder()
     *                         .alarmName("alarmName")
     *                         .roleArn("roleArn")
     *                         .stateReason("stateReason")
     *                         .stateValue("stateValue")
     *                         .build())
     *                 .cloudwatchLogs(CloudwatchLogsActionProperty.builder()
     *                         .logGroupName("logGroupName")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .batchMode(false)
     *                         .build())
     *                 .cloudwatchMetric(CloudwatchMetricActionProperty.builder()
     *                         .metricName("metricName")
     *                         .metricNamespace("metricNamespace")
     *                         .metricUnit("metricUnit")
     *                         .metricValue("metricValue")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .metricTimestamp("metricTimestamp")
     *                         .build())
     *                 .dynamoDb(DynamoDBActionProperty.builder()
     *                         .hashKeyField("hashKeyField")
     *                         .hashKeyValue("hashKeyValue")
     *                         .roleArn("roleArn")
     *                         .tableName("tableName")
     *                         // the properties below are optional
     *                         .hashKeyType("hashKeyType")
     *                         .payloadField("payloadField")
     *                         .rangeKeyField("rangeKeyField")
     *                         .rangeKeyType("rangeKeyType")
     *                         .rangeKeyValue("rangeKeyValue")
     *                         .build())
     *                 .dynamoDBv2(DynamoDBv2ActionProperty.builder()
     *                         .putItem(PutItemInputProperty.builder()
     *                                 .tableName("tableName")
     *                                 .build())
     *                         .roleArn("roleArn")
     *                         .build())
     *                 .elasticsearch(ElasticsearchActionProperty.builder()
     *                         .endpoint("endpoint")
     *                         .id("id")
     *                         .index("index")
     *                         .roleArn("roleArn")
     *                         .type("type")
     *                         .build())
     *                 .firehose(FirehoseActionProperty.builder()
     *                         .deliveryStreamName("deliveryStreamName")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .batchMode(false)
     *                         .separator("separator")
     *                         .build())
     *                 .http(HttpActionProperty.builder()
     *                         .url("url")
     *                         // the properties below are optional
     *                         .auth(HttpAuthorizationProperty.builder()
     *                                 .sigv4(SigV4AuthorizationProperty.builder()
     *                                         .roleArn("roleArn")
     *                                         .serviceName("serviceName")
     *                                         .signingRegion("signingRegion")
     *                                         .build())
     *                                 .build())
     *                         .confirmationUrl("confirmationUrl")
     *                         .headers(List.of(HttpActionHeaderProperty.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 .iotAnalytics(IotAnalyticsActionProperty.builder()
     *                         .channelName("channelName")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .batchMode(false)
     *                         .build())
     *                 .iotEvents(IotEventsActionProperty.builder()
     *                         .inputName("inputName")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .batchMode(false)
     *                         .messageId("messageId")
     *                         .build())
     *                 .iotSiteWise(IotSiteWiseActionProperty.builder()
     *                         .putAssetPropertyValueEntries(List.of(PutAssetPropertyValueEntryProperty.builder()
     *                                 .propertyValues(List.of(AssetPropertyValueProperty.builder()
     *                                         .timestamp(AssetPropertyTimestampProperty.builder()
     *                                                 .timeInSeconds("timeInSeconds")
     *                                                 // the properties below are optional
     *                                                 .offsetInNanos("offsetInNanos")
     *                                                 .build())
     *                                         .value(AssetPropertyVariantProperty.builder()
     *                                                 .booleanValue("booleanValue")
     *                                                 .doubleValue("doubleValue")
     *                                                 .integerValue("integerValue")
     *                                                 .stringValue("stringValue")
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .quality("quality")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .assetId("assetId")
     *                                 .entryId("entryId")
     *                                 .propertyAlias("propertyAlias")
     *                                 .propertyId("propertyId")
     *                                 .build()))
     *                         .roleArn("roleArn")
     *                         .build())
     *                 .kafka(KafkaActionProperty.builder()
     *                         .clientProperties(Map.of(
     *                                 "clientPropertiesKey", "clientProperties"))
     *                         .destinationArn("destinationArn")
     *                         .topic("topic")
     *                         // the properties below are optional
     *                         .headers(List.of(KafkaActionHeaderProperty.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 .build()))
     *                         .key("key")
     *                         .partition("partition")
     *                         .build())
     *                 .kinesis(KinesisActionProperty.builder()
     *                         .roleArn("roleArn")
     *                         .streamName("streamName")
     *                         // the properties below are optional
     *                         .partitionKey("partitionKey")
     *                         .build())
     *                 .lambda(LambdaActionProperty.builder()
     *                         .functionArn("functionArn")
     *                         .build())
     *                 .location(LocationActionProperty.builder()
     *                         .deviceId("deviceId")
     *                         .latitude("latitude")
     *                         .longitude("longitude")
     *                         .roleArn("roleArn")
     *                         .trackerName("trackerName")
     *                         // the properties below are optional
     *                         .timestamp(TimestampProperty.builder()
     *                                 .value("value")
     *                                 // the properties below are optional
     *                                 .unit("unit")
     *                                 .build())
     *                         .build())
     *                 .openSearch(OpenSearchActionProperty.builder()
     *                         .endpoint("endpoint")
     *                         .id("id")
     *                         .index("index")
     *                         .roleArn("roleArn")
     *                         .type("type")
     *                         .build())
     *                 .republish(RepublishActionProperty.builder()
     *                         .roleArn("roleArn")
     *                         .topic("topic")
     *                         // the properties below are optional
     *                         .headers(RepublishActionHeadersProperty.builder()
     *                                 .contentType("contentType")
     *                                 .correlationData("correlationData")
     *                                 .messageExpiry("messageExpiry")
     *                                 .payloadFormatIndicator("payloadFormatIndicator")
     *                                 .responseTopic("responseTopic")
     *                                 .userProperties(List.of(UserPropertyProperty.builder()
     *                                         .key("key")
     *                                         .value("value")
     *                                         .build()))
     *                                 .build())
     *                         .qos(123)
     *                         .build())
     *                 .s3(S3ActionProperty.builder()
     *                         .bucketName("bucketName")
     *                         .key("key")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .cannedAcl("cannedAcl")
     *                         .build())
     *                 .sns(SnsActionProperty.builder()
     *                         .roleArn("roleArn")
     *                         .targetArn("targetArn")
     *                         // the properties below are optional
     *                         .messageFormat("messageFormat")
     *                         .build())
     *                 .sqs(SqsActionProperty.builder()
     *                         .queueUrl("queueUrl")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .useBase64(false)
     *                         .build())
     *                 .stepFunctions(StepFunctionsActionProperty.builder()
     *                         .roleArn("roleArn")
     *                         .stateMachineName("stateMachineName")
     *                         // the properties below are optional
     *                         .executionNamePrefix("executionNamePrefix")
     *                         .build())
     *                 .timestream(TimestreamActionProperty.builder()
     *                         .databaseName("databaseName")
     *                         .dimensions(List.of(TimestreamDimensionProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .roleArn("roleArn")
     *                         .tableName("tableName")
     *                         // the properties below are optional
     *                         .timestamp(TimestreamTimestampProperty.builder()
     *                                 .unit("unit")
     *                                 .value("value")
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .sql("sql")
     *         // the properties below are optional
     *         .awsIotSqlVersion("awsIotSqlVersion")
     *         .description("description")
     *         .errorAction(ActionProperty.builder()
     *                 .cloudwatchAlarm(CloudwatchAlarmActionProperty.builder()
     *                         .alarmName("alarmName")
     *                         .roleArn("roleArn")
     *                         .stateReason("stateReason")
     *                         .stateValue("stateValue")
     *                         .build())
     *                 .cloudwatchLogs(CloudwatchLogsActionProperty.builder()
     *                         .logGroupName("logGroupName")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .batchMode(false)
     *                         .build())
     *                 .cloudwatchMetric(CloudwatchMetricActionProperty.builder()
     *                         .metricName("metricName")
     *                         .metricNamespace("metricNamespace")
     *                         .metricUnit("metricUnit")
     *                         .metricValue("metricValue")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .metricTimestamp("metricTimestamp")
     *                         .build())
     *                 .dynamoDb(DynamoDBActionProperty.builder()
     *                         .hashKeyField("hashKeyField")
     *                         .hashKeyValue("hashKeyValue")
     *                         .roleArn("roleArn")
     *                         .tableName("tableName")
     *                         // the properties below are optional
     *                         .hashKeyType("hashKeyType")
     *                         .payloadField("payloadField")
     *                         .rangeKeyField("rangeKeyField")
     *                         .rangeKeyType("rangeKeyType")
     *                         .rangeKeyValue("rangeKeyValue")
     *                         .build())
     *                 .dynamoDBv2(DynamoDBv2ActionProperty.builder()
     *                         .putItem(PutItemInputProperty.builder()
     *                                 .tableName("tableName")
     *                                 .build())
     *                         .roleArn("roleArn")
     *                         .build())
     *                 .elasticsearch(ElasticsearchActionProperty.builder()
     *                         .endpoint("endpoint")
     *                         .id("id")
     *                         .index("index")
     *                         .roleArn("roleArn")
     *                         .type("type")
     *                         .build())
     *                 .firehose(FirehoseActionProperty.builder()
     *                         .deliveryStreamName("deliveryStreamName")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .batchMode(false)
     *                         .separator("separator")
     *                         .build())
     *                 .http(HttpActionProperty.builder()
     *                         .url("url")
     *                         // the properties below are optional
     *                         .auth(HttpAuthorizationProperty.builder()
     *                                 .sigv4(SigV4AuthorizationProperty.builder()
     *                                         .roleArn("roleArn")
     *                                         .serviceName("serviceName")
     *                                         .signingRegion("signingRegion")
     *                                         .build())
     *                                 .build())
     *                         .confirmationUrl("confirmationUrl")
     *                         .headers(List.of(HttpActionHeaderProperty.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 .iotAnalytics(IotAnalyticsActionProperty.builder()
     *                         .channelName("channelName")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .batchMode(false)
     *                         .build())
     *                 .iotEvents(IotEventsActionProperty.builder()
     *                         .inputName("inputName")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .batchMode(false)
     *                         .messageId("messageId")
     *                         .build())
     *                 .iotSiteWise(IotSiteWiseActionProperty.builder()
     *                         .putAssetPropertyValueEntries(List.of(PutAssetPropertyValueEntryProperty.builder()
     *                                 .propertyValues(List.of(AssetPropertyValueProperty.builder()
     *                                         .timestamp(AssetPropertyTimestampProperty.builder()
     *                                                 .timeInSeconds("timeInSeconds")
     *                                                 // the properties below are optional
     *                                                 .offsetInNanos("offsetInNanos")
     *                                                 .build())
     *                                         .value(AssetPropertyVariantProperty.builder()
     *                                                 .booleanValue("booleanValue")
     *                                                 .doubleValue("doubleValue")
     *                                                 .integerValue("integerValue")
     *                                                 .stringValue("stringValue")
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .quality("quality")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .assetId("assetId")
     *                                 .entryId("entryId")
     *                                 .propertyAlias("propertyAlias")
     *                                 .propertyId("propertyId")
     *                                 .build()))
     *                         .roleArn("roleArn")
     *                         .build())
     *                 .kafka(KafkaActionProperty.builder()
     *                         .clientProperties(Map.of(
     *                                 "clientPropertiesKey", "clientProperties"))
     *                         .destinationArn("destinationArn")
     *                         .topic("topic")
     *                         // the properties below are optional
     *                         .headers(List.of(KafkaActionHeaderProperty.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 .build()))
     *                         .key("key")
     *                         .partition("partition")
     *                         .build())
     *                 .kinesis(KinesisActionProperty.builder()
     *                         .roleArn("roleArn")
     *                         .streamName("streamName")
     *                         // the properties below are optional
     *                         .partitionKey("partitionKey")
     *                         .build())
     *                 .lambda(LambdaActionProperty.builder()
     *                         .functionArn("functionArn")
     *                         .build())
     *                 .location(LocationActionProperty.builder()
     *                         .deviceId("deviceId")
     *                         .latitude("latitude")
     *                         .longitude("longitude")
     *                         .roleArn("roleArn")
     *                         .trackerName("trackerName")
     *                         // the properties below are optional
     *                         .timestamp(TimestampProperty.builder()
     *                                 .value("value")
     *                                 // the properties below are optional
     *                                 .unit("unit")
     *                                 .build())
     *                         .build())
     *                 .openSearch(OpenSearchActionProperty.builder()
     *                         .endpoint("endpoint")
     *                         .id("id")
     *                         .index("index")
     *                         .roleArn("roleArn")
     *                         .type("type")
     *                         .build())
     *                 .republish(RepublishActionProperty.builder()
     *                         .roleArn("roleArn")
     *                         .topic("topic")
     *                         // the properties below are optional
     *                         .headers(RepublishActionHeadersProperty.builder()
     *                                 .contentType("contentType")
     *                                 .correlationData("correlationData")
     *                                 .messageExpiry("messageExpiry")
     *                                 .payloadFormatIndicator("payloadFormatIndicator")
     *                                 .responseTopic("responseTopic")
     *                                 .userProperties(List.of(UserPropertyProperty.builder()
     *                                         .key("key")
     *                                         .value("value")
     *                                         .build()))
     *                                 .build())
     *                         .qos(123)
     *                         .build())
     *                 .s3(S3ActionProperty.builder()
     *                         .bucketName("bucketName")
     *                         .key("key")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .cannedAcl("cannedAcl")
     *                         .build())
     *                 .sns(SnsActionProperty.builder()
     *                         .roleArn("roleArn")
     *                         .targetArn("targetArn")
     *                         // the properties below are optional
     *                         .messageFormat("messageFormat")
     *                         .build())
     *                 .sqs(SqsActionProperty.builder()
     *                         .queueUrl("queueUrl")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .useBase64(false)
     *                         .build())
     *                 .stepFunctions(StepFunctionsActionProperty.builder()
     *                         .roleArn("roleArn")
     *                         .stateMachineName("stateMachineName")
     *                         // the properties below are optional
     *                         .executionNamePrefix("executionNamePrefix")
     *                         .build())
     *                 .timestream(TimestreamActionProperty.builder()
     *                         .databaseName("databaseName")
     *                         .dimensions(List.of(TimestreamDimensionProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .roleArn("roleArn")
     *                         .tableName("tableName")
     *                         // the properties below are optional
     *                         .timestamp(TimestreamTimestampProperty.builder()
     *                                 .unit("unit")
     *                                 .value("value")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .ruleDisabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.TopicRulePayloadProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicRulePayloadProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicRulePayloadProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The actions associated with the rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getActions();

        /**
         * The SQL statement used to query the topic.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html">AWS IoT SQL Reference</a> in the <em>AWS IoT Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-sql">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-sql</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSql();

        /**
         * The version of the SQL rules engine to use when evaluating the rule.
         * <p>
         * The default value is 2015-10-08.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-awsiotsqlversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-awsiotsqlversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsIotSqlVersion() {
            return null;
        }

        /**
         * The description of the rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The action to take when an error occurs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-erroraction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-erroraction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorAction() {
            return null;
        }

        /**
         * Specifies whether the rule is disabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-ruledisabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-ruledisabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRuleDisabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicRulePayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicRulePayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicRulePayloadProperty> {
            java.lang.Object actions;
            java.lang.String sql;
            java.lang.String awsIotSqlVersion;
            java.lang.String description;
            java.lang.Object errorAction;
            java.lang.Object ruleDisabled;

            /**
             * Sets the value of {@link TopicRulePayloadProperty#getActions}
             * @param actions The actions associated with the rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.IResolvable actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link TopicRulePayloadProperty#getActions}
             * @param actions The actions associated with the rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<? extends java.lang.Object> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link TopicRulePayloadProperty#getSql}
             * @param sql The SQL statement used to query the topic. This parameter is required.
             *            For more information, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html">AWS IoT SQL Reference</a> in the <em>AWS IoT Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sql(java.lang.String sql) {
                this.sql = sql;
                return this;
            }

            /**
             * Sets the value of {@link TopicRulePayloadProperty#getAwsIotSqlVersion}
             * @param awsIotSqlVersion The version of the SQL rules engine to use when evaluating the rule.
             *                         The default value is 2015-10-08.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsIotSqlVersion(java.lang.String awsIotSqlVersion) {
                this.awsIotSqlVersion = awsIotSqlVersion;
                return this;
            }

            /**
             * Sets the value of {@link TopicRulePayloadProperty#getDescription}
             * @param description The description of the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link TopicRulePayloadProperty#getErrorAction}
             * @param errorAction The action to take when an error occurs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorAction(software.amazon.awscdk.IResolvable errorAction) {
                this.errorAction = errorAction;
                return this;
            }

            /**
             * Sets the value of {@link TopicRulePayloadProperty#getErrorAction}
             * @param errorAction The action to take when an error occurs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorAction(software.amazon.awscdk.services.iot.CfnTopicRule.ActionProperty errorAction) {
                this.errorAction = errorAction;
                return this;
            }

            /**
             * Sets the value of {@link TopicRulePayloadProperty#getRuleDisabled}
             * @param ruleDisabled Specifies whether the rule is disabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleDisabled(java.lang.Boolean ruleDisabled) {
                this.ruleDisabled = ruleDisabled;
                return this;
            }

            /**
             * Sets the value of {@link TopicRulePayloadProperty#getRuleDisabled}
             * @param ruleDisabled Specifies whether the rule is disabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleDisabled(software.amazon.awscdk.IResolvable ruleDisabled) {
                this.ruleDisabled = ruleDisabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicRulePayloadProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicRulePayloadProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicRulePayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicRulePayloadProperty {
            private final java.lang.Object actions;
            private final java.lang.String sql;
            private final java.lang.String awsIotSqlVersion;
            private final java.lang.String description;
            private final java.lang.Object errorAction;
            private final java.lang.Object ruleDisabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sql = software.amazon.jsii.Kernel.get(this, "sql", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsIotSqlVersion = software.amazon.jsii.Kernel.get(this, "awsIotSqlVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorAction = software.amazon.jsii.Kernel.get(this, "errorAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ruleDisabled = software.amazon.jsii.Kernel.get(this, "ruleDisabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
                this.sql = java.util.Objects.requireNonNull(builder.sql, "sql is required");
                this.awsIotSqlVersion = builder.awsIotSqlVersion;
                this.description = builder.description;
                this.errorAction = builder.errorAction;
                this.ruleDisabled = builder.ruleDisabled;
            }

            @Override
            public final java.lang.Object getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.String getSql() {
                return this.sql;
            }

            @Override
            public final java.lang.String getAwsIotSqlVersion() {
                return this.awsIotSqlVersion;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getErrorAction() {
                return this.errorAction;
            }

            @Override
            public final java.lang.Object getRuleDisabled() {
                return this.ruleDisabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                data.set("sql", om.valueToTree(this.getSql()));
                if (this.getAwsIotSqlVersion() != null) {
                    data.set("awsIotSqlVersion", om.valueToTree(this.getAwsIotSqlVersion()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getErrorAction() != null) {
                    data.set("errorAction", om.valueToTree(this.getErrorAction()));
                }
                if (this.getRuleDisabled() != null) {
                    data.set("ruleDisabled", om.valueToTree(this.getRuleDisabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.TopicRulePayloadProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicRulePayloadProperty.Jsii$Proxy that = (TopicRulePayloadProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                if (!sql.equals(that.sql)) return false;
                if (this.awsIotSqlVersion != null ? !this.awsIotSqlVersion.equals(that.awsIotSqlVersion) : that.awsIotSqlVersion != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.errorAction != null ? !this.errorAction.equals(that.errorAction) : that.errorAction != null) return false;
                return this.ruleDisabled != null ? this.ruleDisabled.equals(that.ruleDisabled) : that.ruleDisabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.sql.hashCode());
                result = 31 * result + (this.awsIotSqlVersion != null ? this.awsIotSqlVersion.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.errorAction != null ? this.errorAction.hashCode() : 0);
                result = 31 * result + (this.ruleDisabled != null ? this.ruleDisabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A key-value pair that you define in the header.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * UserPropertyProperty userPropertyProperty = UserPropertyProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-userproperty.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-userproperty.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnTopicRule.UserPropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(UserPropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserPropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A key to be specified in <code>UserProperty</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-userproperty.html#cfn-iot-topicrule-userproperty-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-userproperty.html#cfn-iot-topicrule-userproperty-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * A value to be specified in <code>UserProperty</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-userproperty.html#cfn-iot-topicrule-userproperty-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-userproperty.html#cfn-iot-topicrule-userproperty-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link UserPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserPropertyProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link UserPropertyProperty#getKey}
             * @param key A key to be specified in <code>UserProperty</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link UserPropertyProperty#getValue}
             * @param value A value to be specified in <code>UserProperty</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserPropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserPropertyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPropertyProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnTopicRule.UserPropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserPropertyProperty.Jsii$Proxy that = (UserPropertyProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iot.CfnTopicRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.CfnTopicRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iot.CfnTopicRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iot.CfnTopicRuleProps.Builder();
        }

        /**
         * The rule payload.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-topicrulepayload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-topicrulepayload</a>
         * @param topicRulePayload The rule payload. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicRulePayload(final software.amazon.awscdk.IResolvable topicRulePayload) {
            this.props.topicRulePayload(topicRulePayload);
            return this;
        }
        /**
         * The rule payload.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-topicrulepayload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-topicrulepayload</a>
         * @param topicRulePayload The rule payload. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicRulePayload(final software.amazon.awscdk.services.iot.CfnTopicRule.TopicRulePayloadProperty topicRulePayload) {
            this.props.topicRulePayload(topicRulePayload);
            return this;
        }

        /**
         * The name of the rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-rulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-rulename</a>
         * @param ruleName The name of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(final java.lang.String ruleName) {
            this.props.ruleName(ruleName);
            return this;
        }

        /**
         * Metadata which can be used to manage the topic rule.
         * <p>
         * <blockquote>
         * <p>
         * For URI Request parameters use format: ...key1=value1&amp;key2=value2...
         * <p>
         * For the CLI command-line parameter use format: --tags "key1=value1&amp;key2=value2..."
         * <p>
         * For the cli-input-json file use format: "tags": "key1=value1&amp;key2=value2..."
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-tags</a>
         * @param tags Metadata which can be used to manage the topic rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iot.CfnTopicRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iot.CfnTopicRule build() {
            return new software.amazon.awscdk.services.iot.CfnTopicRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
