package software.amazon.awscdk.services.iottwinmaker;

/**
 * Use the <code>AWS::IoTTwinMaker::Entity</code> resource to declare an entity.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iottwinmaker.*;
 * DataValueProperty dataValueProperty_;
 * Object definition;
 * Object error;
 * Object relationshipValue;
 * CfnEntity cfnEntity = CfnEntity.Builder.create(this, "MyCfnEntity")
 *         .entityName("entityName")
 *         .workspaceId("workspaceId")
 *         // the properties below are optional
 *         .components(Map.of(
 *                 "componentsKey", ComponentProperty.builder()
 *                         .componentName("componentName")
 *                         .componentTypeId("componentTypeId")
 *                         .definedIn("definedIn")
 *                         .description("description")
 *                         .properties(Map.of(
 *                                 "propertiesKey", PropertyProperty.builder()
 *                                         .definition(definition)
 *                                         .value(DataValueProperty.builder()
 *                                                 .booleanValue(false)
 *                                                 .doubleValue(123)
 *                                                 .expression("expression")
 *                                                 .integerValue(123)
 *                                                 .listValue(List.of(dataValueProperty_))
 *                                                 .longValue(123)
 *                                                 .mapValue(Map.of(
 *                                                         "mapValueKey", dataValueProperty_))
 *                                                 .relationshipValue(relationshipValue)
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build()))
 *                         .propertyGroups(Map.of(
 *                                 "propertyGroupsKey", PropertyGroupProperty.builder()
 *                                         .groupType("groupType")
 *                                         .propertyNames(List.of("propertyNames"))
 *                                         .build()))
 *                         .status(StatusProperty.builder()
 *                                 .error(error)
 *                                 .state("state")
 *                                 .build())
 *                         .build()))
 *         .compositeComponents(Map.of(
 *                 "compositeComponentsKey", CompositeComponentProperty.builder()
 *                         .componentName("componentName")
 *                         .componentPath("componentPath")
 *                         .componentTypeId("componentTypeId")
 *                         .description("description")
 *                         .properties(Map.of(
 *                                 "propertiesKey", PropertyProperty.builder()
 *                                         .definition(definition)
 *                                         .value(DataValueProperty.builder()
 *                                                 .booleanValue(false)
 *                                                 .doubleValue(123)
 *                                                 .expression("expression")
 *                                                 .integerValue(123)
 *                                                 .listValue(List.of(dataValueProperty_))
 *                                                 .longValue(123)
 *                                                 .mapValue(Map.of(
 *                                                         "mapValueKey", dataValueProperty_))
 *                                                 .relationshipValue(relationshipValue)
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         .build()))
 *                         .propertyGroups(Map.of(
 *                                 "propertyGroupsKey", PropertyGroupProperty.builder()
 *                                         .groupType("groupType")
 *                                         .propertyNames(List.of("propertyNames"))
 *                                         .build()))
 *                         .status(StatusProperty.builder()
 *                                 .error(error)
 *                                 .state("state")
 *                                 .build())
 *                         .build()))
 *         .description("description")
 *         .entityId("entityId")
 *         .parentEntityId("parentEntityId")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:08.827Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnEntity")
public class CfnEntity extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnEntity(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEntity(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iottwinmaker.CfnEntity.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEntity(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iottwinmaker.CfnEntityProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The entity ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time the entity was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationDateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationDateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A boolean value that specifies whether the entity has child entities or not.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrHasChildEntities() {
        return software.amazon.jsii.Kernel.get(this, "attrHasChildEntities", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrStatusError() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusErrorCode() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusErrorCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusErrorMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusErrorMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusState() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time when the component type was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdateDateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdateDateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The entity name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEntityName() {
        return software.amazon.jsii.Kernel.get(this, "entityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The entity name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEntityName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "entityName", java.util.Objects.requireNonNull(value, "entityName is required"));
    }

    /**
     * The ID of the workspace that contains the entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getWorkspaceId() {
        return software.amazon.jsii.Kernel.get(this, "workspaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the workspace that contains the entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkspaceId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "workspaceId", java.util.Objects.requireNonNull(value, "workspaceId is required"));
    }

    /**
     * An object that maps strings to the components in the entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getComponents() {
        return software.amazon.jsii.Kernel.get(this, "components", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that maps strings to the components in the entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComponents(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "components", value);
    }

    /**
     * An object that maps strings to the components in the entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComponents(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iottwinmaker.CfnEntity.ComponentProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iottwinmaker.CfnEntity.ComponentProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "components", value);
    }

    /**
     * Maps string to <code>compositeComponent</code> updates in the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCompositeComponents() {
        return software.amazon.jsii.Kernel.get(this, "compositeComponents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Maps string to <code>compositeComponent</code> updates in the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCompositeComponents(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "compositeComponents", value);
    }

    /**
     * Maps string to <code>compositeComponent</code> updates in the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCompositeComponents(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iottwinmaker.CfnEntity.CompositeComponentProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iottwinmaker.CfnEntity.CompositeComponentProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "compositeComponents", value);
    }

    /**
     * The description of the entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The ID of the entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEntityId() {
        return software.amazon.jsii.Kernel.get(this, "entityId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEntityId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "entityId", value);
    }

    /**
     * The ID of the parent entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getParentEntityId() {
        return software.amazon.jsii.Kernel.get(this, "parentEntityId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the parent entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParentEntityId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "parentEntityId", value);
    }

    /**
     * Metadata that you can use to manage the entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Metadata that you can use to manage the entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The entity component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * DataValueProperty dataValueProperty_;
     * Object definition;
     * Object error;
     * Object relationshipValue;
     * ComponentProperty componentProperty = ComponentProperty.builder()
     *         .componentName("componentName")
     *         .componentTypeId("componentTypeId")
     *         .definedIn("definedIn")
     *         .description("description")
     *         .properties(Map.of(
     *                 "propertiesKey", PropertyProperty.builder()
     *                         .definition(definition)
     *                         .value(DataValueProperty.builder()
     *                                 .booleanValue(false)
     *                                 .doubleValue(123)
     *                                 .expression("expression")
     *                                 .integerValue(123)
     *                                 .listValue(List.of(dataValueProperty_))
     *                                 .longValue(123)
     *                                 .mapValue(Map.of(
     *                                         "mapValueKey", dataValueProperty_))
     *                                 .relationshipValue(relationshipValue)
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .build()))
     *         .propertyGroups(Map.of(
     *                 "propertyGroupsKey", PropertyGroupProperty.builder()
     *                         .groupType("groupType")
     *                         .propertyNames(List.of("propertyNames"))
     *                         .build()))
     *         .status(StatusProperty.builder()
     *                 .error(error)
     *                 .state("state")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnEntity.ComponentProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-componentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-componentname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentName() {
            return null;
        }

        /**
         * The ID of the component type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-componenttypeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-componenttypeid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentTypeId() {
            return null;
        }

        /**
         * The name of the property definition set in the request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-definedin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-definedin</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefinedIn() {
            return null;
        }

        /**
         * The description of the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * An object that maps strings to the properties to set in the component type.
         * <p>
         * Each string in the mapping must be unique to this object.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-properties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProperties() {
            return null;
        }

        /**
         * An object that maps strings to the property groups in the component type.
         * <p>
         * Each string in the mapping must be unique to this object.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-propertygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-propertygroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPropertyGroups() {
            return null;
        }

        /**
         * The status of the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentProperty> {
            java.lang.String componentName;
            java.lang.String componentTypeId;
            java.lang.String definedIn;
            java.lang.String description;
            java.lang.Object properties;
            java.lang.Object propertyGroups;
            java.lang.Object status;

            /**
             * Sets the value of {@link ComponentProperty#getComponentName}
             * @param componentName The name of the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentName(java.lang.String componentName) {
                this.componentName = componentName;
                return this;
            }

            /**
             * Sets the value of {@link ComponentProperty#getComponentTypeId}
             * @param componentTypeId The ID of the component type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentTypeId(java.lang.String componentTypeId) {
                this.componentTypeId = componentTypeId;
                return this;
            }

            /**
             * Sets the value of {@link ComponentProperty#getDefinedIn}
             * @param definedIn The name of the property definition set in the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder definedIn(java.lang.String definedIn) {
                this.definedIn = definedIn;
                return this;
            }

            /**
             * Sets the value of {@link ComponentProperty#getDescription}
             * @param description The description of the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link ComponentProperty#getProperties}
             * @param properties An object that maps strings to the properties to set in the component type.
             *                   Each string in the mapping must be unique to this object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.IResolvable properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link ComponentProperty#getProperties}
             * @param properties An object that maps strings to the properties to set in the component type.
             *                   Each string in the mapping must be unique to this object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(java.util.Map<java.lang.String, ? extends java.lang.Object> properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link ComponentProperty#getPropertyGroups}
             * @param propertyGroups An object that maps strings to the property groups in the component type.
             *                       Each string in the mapping must be unique to this object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyGroups(software.amazon.awscdk.IResolvable propertyGroups) {
                this.propertyGroups = propertyGroups;
                return this;
            }

            /**
             * Sets the value of {@link ComponentProperty#getPropertyGroups}
             * @param propertyGroups An object that maps strings to the property groups in the component type.
             *                       Each string in the mapping must be unique to this object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyGroups(java.util.Map<java.lang.String, ? extends java.lang.Object> propertyGroups) {
                this.propertyGroups = propertyGroups;
                return this;
            }

            /**
             * Sets the value of {@link ComponentProperty#getStatus}
             * @param status The status of the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(software.amazon.awscdk.IResolvable status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link ComponentProperty#getStatus}
             * @param status The status of the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(software.amazon.awscdk.services.iottwinmaker.CfnEntity.StatusProperty status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentProperty {
            private final java.lang.String componentName;
            private final java.lang.String componentTypeId;
            private final java.lang.String definedIn;
            private final java.lang.String description;
            private final java.lang.Object properties;
            private final java.lang.Object propertyGroups;
            private final java.lang.Object status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.componentName = software.amazon.jsii.Kernel.get(this, "componentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.componentTypeId = software.amazon.jsii.Kernel.get(this, "componentTypeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.definedIn = software.amazon.jsii.Kernel.get(this, "definedIn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.propertyGroups = software.amazon.jsii.Kernel.get(this, "propertyGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.componentName = builder.componentName;
                this.componentTypeId = builder.componentTypeId;
                this.definedIn = builder.definedIn;
                this.description = builder.description;
                this.properties = builder.properties;
                this.propertyGroups = builder.propertyGroups;
                this.status = builder.status;
            }

            @Override
            public final java.lang.String getComponentName() {
                return this.componentName;
            }

            @Override
            public final java.lang.String getComponentTypeId() {
                return this.componentTypeId;
            }

            @Override
            public final java.lang.String getDefinedIn() {
                return this.definedIn;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getProperties() {
                return this.properties;
            }

            @Override
            public final java.lang.Object getPropertyGroups() {
                return this.propertyGroups;
            }

            @Override
            public final java.lang.Object getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComponentName() != null) {
                    data.set("componentName", om.valueToTree(this.getComponentName()));
                }
                if (this.getComponentTypeId() != null) {
                    data.set("componentTypeId", om.valueToTree(this.getComponentTypeId()));
                }
                if (this.getDefinedIn() != null) {
                    data.set("definedIn", om.valueToTree(this.getDefinedIn()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getProperties() != null) {
                    data.set("properties", om.valueToTree(this.getProperties()));
                }
                if (this.getPropertyGroups() != null) {
                    data.set("propertyGroups", om.valueToTree(this.getPropertyGroups()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnEntity.ComponentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentProperty.Jsii$Proxy that = (ComponentProperty.Jsii$Proxy) o;

                if (this.componentName != null ? !this.componentName.equals(that.componentName) : that.componentName != null) return false;
                if (this.componentTypeId != null ? !this.componentTypeId.equals(that.componentTypeId) : that.componentTypeId != null) return false;
                if (this.definedIn != null ? !this.definedIn.equals(that.definedIn) : that.definedIn != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) return false;
                if (this.propertyGroups != null ? !this.propertyGroups.equals(that.propertyGroups) : that.propertyGroups != null) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.componentName != null ? this.componentName.hashCode() : 0;
                result = 31 * result + (this.componentTypeId != null ? this.componentTypeId.hashCode() : 0);
                result = 31 * result + (this.definedIn != null ? this.definedIn.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
                result = 31 * result + (this.propertyGroups != null ? this.propertyGroups.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a composite component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * DataValueProperty dataValueProperty_;
     * Object definition;
     * Object error;
     * Object relationshipValue;
     * CompositeComponentProperty compositeComponentProperty = CompositeComponentProperty.builder()
     *         .componentName("componentName")
     *         .componentPath("componentPath")
     *         .componentTypeId("componentTypeId")
     *         .description("description")
     *         .properties(Map.of(
     *                 "propertiesKey", PropertyProperty.builder()
     *                         .definition(definition)
     *                         .value(DataValueProperty.builder()
     *                                 .booleanValue(false)
     *                                 .doubleValue(123)
     *                                 .expression("expression")
     *                                 .integerValue(123)
     *                                 .listValue(List.of(dataValueProperty_))
     *                                 .longValue(123)
     *                                 .mapValue(Map.of(
     *                                         "mapValueKey", dataValueProperty_))
     *                                 .relationshipValue(relationshipValue)
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .build()))
     *         .propertyGroups(Map.of(
     *                 "propertyGroupsKey", PropertyGroupProperty.builder()
     *                         .groupType("groupType")
     *                         .propertyNames(List.of("propertyNames"))
     *                         .build()))
     *         .status(StatusProperty.builder()
     *                 .error(error)
     *                 .state("state")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-compositecomponent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-compositecomponent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnEntity.CompositeComponentProperty")
    @software.amazon.jsii.Jsii.Proxy(CompositeComponentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CompositeComponentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-compositecomponent.html#cfn-iottwinmaker-entity-compositecomponent-componentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-compositecomponent.html#cfn-iottwinmaker-entity-compositecomponent-componentname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentName() {
            return null;
        }

        /**
         * The path to the composite component, starting from the top-level component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-compositecomponent.html#cfn-iottwinmaker-entity-compositecomponent-componentpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-compositecomponent.html#cfn-iottwinmaker-entity-compositecomponent-componentpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentPath() {
            return null;
        }

        /**
         * The ID of the composite component type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-compositecomponent.html#cfn-iottwinmaker-entity-compositecomponent-componenttypeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-compositecomponent.html#cfn-iottwinmaker-entity-compositecomponent-componenttypeid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentTypeId() {
            return null;
        }

        /**
         * The description of the component type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-compositecomponent.html#cfn-iottwinmaker-entity-compositecomponent-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-compositecomponent.html#cfn-iottwinmaker-entity-compositecomponent-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Map of strings to the properties in the component type.
         * <p>
         * Each string in the mapping must be unique to this component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-compositecomponent.html#cfn-iottwinmaker-entity-compositecomponent-properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-compositecomponent.html#cfn-iottwinmaker-entity-compositecomponent-properties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProperties() {
            return null;
        }

        /**
         * The property groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-compositecomponent.html#cfn-iottwinmaker-entity-compositecomponent-propertygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-compositecomponent.html#cfn-iottwinmaker-entity-compositecomponent-propertygroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPropertyGroups() {
            return null;
        }

        /**
         * The current status of the composite component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-compositecomponent.html#cfn-iottwinmaker-entity-compositecomponent-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-compositecomponent.html#cfn-iottwinmaker-entity-compositecomponent-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CompositeComponentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CompositeComponentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CompositeComponentProperty> {
            java.lang.String componentName;
            java.lang.String componentPath;
            java.lang.String componentTypeId;
            java.lang.String description;
            java.lang.Object properties;
            java.lang.Object propertyGroups;
            java.lang.Object status;

            /**
             * Sets the value of {@link CompositeComponentProperty#getComponentName}
             * @param componentName The name of the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentName(java.lang.String componentName) {
                this.componentName = componentName;
                return this;
            }

            /**
             * Sets the value of {@link CompositeComponentProperty#getComponentPath}
             * @param componentPath The path to the composite component, starting from the top-level component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentPath(java.lang.String componentPath) {
                this.componentPath = componentPath;
                return this;
            }

            /**
             * Sets the value of {@link CompositeComponentProperty#getComponentTypeId}
             * @param componentTypeId The ID of the composite component type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentTypeId(java.lang.String componentTypeId) {
                this.componentTypeId = componentTypeId;
                return this;
            }

            /**
             * Sets the value of {@link CompositeComponentProperty#getDescription}
             * @param description The description of the component type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link CompositeComponentProperty#getProperties}
             * @param properties Map of strings to the properties in the component type.
             *                   Each string in the mapping must be unique to this component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.IResolvable properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link CompositeComponentProperty#getProperties}
             * @param properties Map of strings to the properties in the component type.
             *                   Each string in the mapping must be unique to this component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(java.util.Map<java.lang.String, ? extends java.lang.Object> properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link CompositeComponentProperty#getPropertyGroups}
             * @param propertyGroups The property groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyGroups(software.amazon.awscdk.IResolvable propertyGroups) {
                this.propertyGroups = propertyGroups;
                return this;
            }

            /**
             * Sets the value of {@link CompositeComponentProperty#getPropertyGroups}
             * @param propertyGroups The property groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyGroups(java.util.Map<java.lang.String, ? extends java.lang.Object> propertyGroups) {
                this.propertyGroups = propertyGroups;
                return this;
            }

            /**
             * Sets the value of {@link CompositeComponentProperty#getStatus}
             * @param status The current status of the composite component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(software.amazon.awscdk.IResolvable status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link CompositeComponentProperty#getStatus}
             * @param status The current status of the composite component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(software.amazon.awscdk.services.iottwinmaker.CfnEntity.StatusProperty status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CompositeComponentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CompositeComponentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CompositeComponentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CompositeComponentProperty {
            private final java.lang.String componentName;
            private final java.lang.String componentPath;
            private final java.lang.String componentTypeId;
            private final java.lang.String description;
            private final java.lang.Object properties;
            private final java.lang.Object propertyGroups;
            private final java.lang.Object status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.componentName = software.amazon.jsii.Kernel.get(this, "componentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.componentPath = software.amazon.jsii.Kernel.get(this, "componentPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.componentTypeId = software.amazon.jsii.Kernel.get(this, "componentTypeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.propertyGroups = software.amazon.jsii.Kernel.get(this, "propertyGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.componentName = builder.componentName;
                this.componentPath = builder.componentPath;
                this.componentTypeId = builder.componentTypeId;
                this.description = builder.description;
                this.properties = builder.properties;
                this.propertyGroups = builder.propertyGroups;
                this.status = builder.status;
            }

            @Override
            public final java.lang.String getComponentName() {
                return this.componentName;
            }

            @Override
            public final java.lang.String getComponentPath() {
                return this.componentPath;
            }

            @Override
            public final java.lang.String getComponentTypeId() {
                return this.componentTypeId;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getProperties() {
                return this.properties;
            }

            @Override
            public final java.lang.Object getPropertyGroups() {
                return this.propertyGroups;
            }

            @Override
            public final java.lang.Object getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComponentName() != null) {
                    data.set("componentName", om.valueToTree(this.getComponentName()));
                }
                if (this.getComponentPath() != null) {
                    data.set("componentPath", om.valueToTree(this.getComponentPath()));
                }
                if (this.getComponentTypeId() != null) {
                    data.set("componentTypeId", om.valueToTree(this.getComponentTypeId()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getProperties() != null) {
                    data.set("properties", om.valueToTree(this.getProperties()));
                }
                if (this.getPropertyGroups() != null) {
                    data.set("propertyGroups", om.valueToTree(this.getPropertyGroups()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnEntity.CompositeComponentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CompositeComponentProperty.Jsii$Proxy that = (CompositeComponentProperty.Jsii$Proxy) o;

                if (this.componentName != null ? !this.componentName.equals(that.componentName) : that.componentName != null) return false;
                if (this.componentPath != null ? !this.componentPath.equals(that.componentPath) : that.componentPath != null) return false;
                if (this.componentTypeId != null ? !this.componentTypeId.equals(that.componentTypeId) : that.componentTypeId != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) return false;
                if (this.propertyGroups != null ? !this.propertyGroups.equals(that.propertyGroups) : that.propertyGroups != null) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.componentName != null ? this.componentName.hashCode() : 0;
                result = 31 * result + (this.componentPath != null ? this.componentPath.hashCode() : 0);
                result = 31 * result + (this.componentTypeId != null ? this.componentTypeId.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
                result = 31 * result + (this.propertyGroups != null ? this.propertyGroups.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The entity data type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * DataTypeProperty dataTypeProperty_;
     * DataValueProperty dataValueProperty_;
     * Object relationshipValue;
     * DataTypeProperty dataTypeProperty = DataTypeProperty.builder()
     *         .allowedValues(List.of(DataValueProperty.builder()
     *                 .booleanValue(false)
     *                 .doubleValue(123)
     *                 .expression("expression")
     *                 .integerValue(123)
     *                 .listValue(List.of(dataValueProperty_))
     *                 .longValue(123)
     *                 .mapValue(Map.of(
     *                         "mapValueKey", dataValueProperty_))
     *                 .relationshipValue(relationshipValue)
     *                 .stringValue("stringValue")
     *                 .build()))
     *         .nestedType(dataTypeProperty_)
     *         .relationship(RelationshipProperty.builder()
     *                 .relationshipType("relationshipType")
     *                 .targetComponentTypeId("targetComponentTypeId")
     *                 .build())
     *         .type("type")
     *         .unitOfMeasure("unitOfMeasure")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datatype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datatype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnEntity.DataTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(DataTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The allowed values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datatype.html#cfn-iottwinmaker-entity-datatype-allowedvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datatype.html#cfn-iottwinmaker-entity-datatype-allowedvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowedValues() {
            return null;
        }

        /**
         * The nested type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datatype.html#cfn-iottwinmaker-entity-datatype-nestedtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datatype.html#cfn-iottwinmaker-entity-datatype-nestedtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNestedType() {
            return null;
        }

        /**
         * The relationship.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datatype.html#cfn-iottwinmaker-entity-datatype-relationship">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datatype.html#cfn-iottwinmaker-entity-datatype-relationship</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelationship() {
            return null;
        }

        /**
         * The entity type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datatype.html#cfn-iottwinmaker-entity-datatype-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datatype.html#cfn-iottwinmaker-entity-datatype-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * The unit of measure.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datatype.html#cfn-iottwinmaker-entity-datatype-unitofmeasure">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datatype.html#cfn-iottwinmaker-entity-datatype-unitofmeasure</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnitOfMeasure() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataTypeProperty> {
            java.lang.Object allowedValues;
            java.lang.Object nestedType;
            java.lang.Object relationship;
            java.lang.String type;
            java.lang.String unitOfMeasure;

            /**
             * Sets the value of {@link DataTypeProperty#getAllowedValues}
             * @param allowedValues The allowed values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedValues(software.amazon.awscdk.IResolvable allowedValues) {
                this.allowedValues = allowedValues;
                return this;
            }

            /**
             * Sets the value of {@link DataTypeProperty#getAllowedValues}
             * @param allowedValues The allowed values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedValues(java.util.List<? extends java.lang.Object> allowedValues) {
                this.allowedValues = allowedValues;
                return this;
            }

            /**
             * Sets the value of {@link DataTypeProperty#getNestedType}
             * @param nestedType The nested type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nestedType(software.amazon.awscdk.IResolvable nestedType) {
                this.nestedType = nestedType;
                return this;
            }

            /**
             * Sets the value of {@link DataTypeProperty#getNestedType}
             * @param nestedType The nested type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nestedType(software.amazon.awscdk.services.iottwinmaker.CfnEntity.DataTypeProperty nestedType) {
                this.nestedType = nestedType;
                return this;
            }

            /**
             * Sets the value of {@link DataTypeProperty#getRelationship}
             * @param relationship The relationship.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationship(software.amazon.awscdk.IResolvable relationship) {
                this.relationship = relationship;
                return this;
            }

            /**
             * Sets the value of {@link DataTypeProperty#getRelationship}
             * @param relationship The relationship.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationship(software.amazon.awscdk.services.iottwinmaker.CfnEntity.RelationshipProperty relationship) {
                this.relationship = relationship;
                return this;
            }

            /**
             * Sets the value of {@link DataTypeProperty#getType}
             * @param type The entity type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link DataTypeProperty#getUnitOfMeasure}
             * @param unitOfMeasure The unit of measure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unitOfMeasure(java.lang.String unitOfMeasure) {
                this.unitOfMeasure = unitOfMeasure;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataTypeProperty {
            private final java.lang.Object allowedValues;
            private final java.lang.Object nestedType;
            private final java.lang.Object relationship;
            private final java.lang.String type;
            private final java.lang.String unitOfMeasure;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowedValues = software.amazon.jsii.Kernel.get(this, "allowedValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nestedType = software.amazon.jsii.Kernel.get(this, "nestedType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.relationship = software.amazon.jsii.Kernel.get(this, "relationship", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unitOfMeasure = software.amazon.jsii.Kernel.get(this, "unitOfMeasure", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowedValues = builder.allowedValues;
                this.nestedType = builder.nestedType;
                this.relationship = builder.relationship;
                this.type = builder.type;
                this.unitOfMeasure = builder.unitOfMeasure;
            }

            @Override
            public final java.lang.Object getAllowedValues() {
                return this.allowedValues;
            }

            @Override
            public final java.lang.Object getNestedType() {
                return this.nestedType;
            }

            @Override
            public final java.lang.Object getRelationship() {
                return this.relationship;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getUnitOfMeasure() {
                return this.unitOfMeasure;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowedValues() != null) {
                    data.set("allowedValues", om.valueToTree(this.getAllowedValues()));
                }
                if (this.getNestedType() != null) {
                    data.set("nestedType", om.valueToTree(this.getNestedType()));
                }
                if (this.getRelationship() != null) {
                    data.set("relationship", om.valueToTree(this.getRelationship()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getUnitOfMeasure() != null) {
                    data.set("unitOfMeasure", om.valueToTree(this.getUnitOfMeasure()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnEntity.DataTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataTypeProperty.Jsii$Proxy that = (DataTypeProperty.Jsii$Proxy) o;

                if (this.allowedValues != null ? !this.allowedValues.equals(that.allowedValues) : that.allowedValues != null) return false;
                if (this.nestedType != null ? !this.nestedType.equals(that.nestedType) : that.nestedType != null) return false;
                if (this.relationship != null ? !this.relationship.equals(that.relationship) : that.relationship != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.unitOfMeasure != null ? this.unitOfMeasure.equals(that.unitOfMeasure) : that.unitOfMeasure == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowedValues != null ? this.allowedValues.hashCode() : 0;
                result = 31 * result + (this.nestedType != null ? this.nestedType.hashCode() : 0);
                result = 31 * result + (this.relationship != null ? this.relationship.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.unitOfMeasure != null ? this.unitOfMeasure.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that specifies a value for a property.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * DataValueProperty dataValueProperty_;
     * Object relationshipValue;
     * DataValueProperty dataValueProperty = DataValueProperty.builder()
     *         .booleanValue(false)
     *         .doubleValue(123)
     *         .expression("expression")
     *         .integerValue(123)
     *         .listValue(List.of(dataValueProperty_))
     *         .longValue(123)
     *         .mapValue(Map.of(
     *                 "mapValueKey", dataValueProperty_))
     *         .relationshipValue(relationshipValue)
     *         .stringValue("stringValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnEntity.DataValueProperty")
    @software.amazon.jsii.Jsii.Proxy(DataValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A boolean value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-booleanvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-booleanvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBooleanValue() {
            return null;
        }

        /**
         * A double value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-doublevalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-doublevalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDoubleValue() {
            return null;
        }

        /**
         * An expression that produces the value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpression() {
            return null;
        }

        /**
         * An integer value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-integervalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-integervalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIntegerValue() {
            return null;
        }

        /**
         * A list of multiple values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-listvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-listvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getListValue() {
            return null;
        }

        /**
         * A long value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-longvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-longvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLongValue() {
            return null;
        }

        /**
         * An object that maps strings to multiple DataValue objects.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-mapvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-mapvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMapValue() {
            return null;
        }

        /**
         * A value that relates a component to another component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-relationshipvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-relationshipvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelationshipValue() {
            return null;
        }

        /**
         * A string value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-stringvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-stringvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStringValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataValueProperty> {
            java.lang.Object booleanValue;
            java.lang.Number doubleValue;
            java.lang.String expression;
            java.lang.Number integerValue;
            java.lang.Object listValue;
            java.lang.Number longValue;
            java.lang.Object mapValue;
            java.lang.Object relationshipValue;
            java.lang.String stringValue;

            /**
             * Sets the value of {@link DataValueProperty#getBooleanValue}
             * @param booleanValue A boolean value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanValue(java.lang.Boolean booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getBooleanValue}
             * @param booleanValue A boolean value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanValue(software.amazon.awscdk.IResolvable booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getDoubleValue}
             * @param doubleValue A double value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder doubleValue(java.lang.Number doubleValue) {
                this.doubleValue = doubleValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getExpression}
             * @param expression An expression that produces the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getIntegerValue}
             * @param integerValue An integer value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerValue(java.lang.Number integerValue) {
                this.integerValue = integerValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getListValue}
             * @param listValue A list of multiple values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder listValue(software.amazon.awscdk.IResolvable listValue) {
                this.listValue = listValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getListValue}
             * @param listValue A list of multiple values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder listValue(java.util.List<? extends java.lang.Object> listValue) {
                this.listValue = listValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getLongValue}
             * @param longValue A long value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder longValue(java.lang.Number longValue) {
                this.longValue = longValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getMapValue}
             * @param mapValue An object that maps strings to multiple DataValue objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mapValue(software.amazon.awscdk.IResolvable mapValue) {
                this.mapValue = mapValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getMapValue}
             * @param mapValue An object that maps strings to multiple DataValue objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mapValue(java.util.Map<java.lang.String, ? extends java.lang.Object> mapValue) {
                this.mapValue = mapValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getRelationshipValue}
             * @param relationshipValue A value that relates a component to another component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationshipValue(java.lang.Object relationshipValue) {
                this.relationshipValue = relationshipValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getStringValue}
             * @param stringValue A string value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringValue(java.lang.String stringValue) {
                this.stringValue = stringValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataValueProperty {
            private final java.lang.Object booleanValue;
            private final java.lang.Number doubleValue;
            private final java.lang.String expression;
            private final java.lang.Number integerValue;
            private final java.lang.Object listValue;
            private final java.lang.Number longValue;
            private final java.lang.Object mapValue;
            private final java.lang.Object relationshipValue;
            private final java.lang.String stringValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.booleanValue = software.amazon.jsii.Kernel.get(this, "booleanValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.doubleValue = software.amazon.jsii.Kernel.get(this, "doubleValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.integerValue = software.amazon.jsii.Kernel.get(this, "integerValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.listValue = software.amazon.jsii.Kernel.get(this, "listValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.longValue = software.amazon.jsii.Kernel.get(this, "longValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mapValue = software.amazon.jsii.Kernel.get(this, "mapValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.relationshipValue = software.amazon.jsii.Kernel.get(this, "relationshipValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stringValue = software.amazon.jsii.Kernel.get(this, "stringValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.booleanValue = builder.booleanValue;
                this.doubleValue = builder.doubleValue;
                this.expression = builder.expression;
                this.integerValue = builder.integerValue;
                this.listValue = builder.listValue;
                this.longValue = builder.longValue;
                this.mapValue = builder.mapValue;
                this.relationshipValue = builder.relationshipValue;
                this.stringValue = builder.stringValue;
            }

            @Override
            public final java.lang.Object getBooleanValue() {
                return this.booleanValue;
            }

            @Override
            public final java.lang.Number getDoubleValue() {
                return this.doubleValue;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.Number getIntegerValue() {
                return this.integerValue;
            }

            @Override
            public final java.lang.Object getListValue() {
                return this.listValue;
            }

            @Override
            public final java.lang.Number getLongValue() {
                return this.longValue;
            }

            @Override
            public final java.lang.Object getMapValue() {
                return this.mapValue;
            }

            @Override
            public final java.lang.Object getRelationshipValue() {
                return this.relationshipValue;
            }

            @Override
            public final java.lang.String getStringValue() {
                return this.stringValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBooleanValue() != null) {
                    data.set("booleanValue", om.valueToTree(this.getBooleanValue()));
                }
                if (this.getDoubleValue() != null) {
                    data.set("doubleValue", om.valueToTree(this.getDoubleValue()));
                }
                if (this.getExpression() != null) {
                    data.set("expression", om.valueToTree(this.getExpression()));
                }
                if (this.getIntegerValue() != null) {
                    data.set("integerValue", om.valueToTree(this.getIntegerValue()));
                }
                if (this.getListValue() != null) {
                    data.set("listValue", om.valueToTree(this.getListValue()));
                }
                if (this.getLongValue() != null) {
                    data.set("longValue", om.valueToTree(this.getLongValue()));
                }
                if (this.getMapValue() != null) {
                    data.set("mapValue", om.valueToTree(this.getMapValue()));
                }
                if (this.getRelationshipValue() != null) {
                    data.set("relationshipValue", om.valueToTree(this.getRelationshipValue()));
                }
                if (this.getStringValue() != null) {
                    data.set("stringValue", om.valueToTree(this.getStringValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnEntity.DataValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataValueProperty.Jsii$Proxy that = (DataValueProperty.Jsii$Proxy) o;

                if (this.booleanValue != null ? !this.booleanValue.equals(that.booleanValue) : that.booleanValue != null) return false;
                if (this.doubleValue != null ? !this.doubleValue.equals(that.doubleValue) : that.doubleValue != null) return false;
                if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) return false;
                if (this.integerValue != null ? !this.integerValue.equals(that.integerValue) : that.integerValue != null) return false;
                if (this.listValue != null ? !this.listValue.equals(that.listValue) : that.listValue != null) return false;
                if (this.longValue != null ? !this.longValue.equals(that.longValue) : that.longValue != null) return false;
                if (this.mapValue != null ? !this.mapValue.equals(that.mapValue) : that.mapValue != null) return false;
                if (this.relationshipValue != null ? !this.relationshipValue.equals(that.relationshipValue) : that.relationshipValue != null) return false;
                return this.stringValue != null ? this.stringValue.equals(that.stringValue) : that.stringValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.booleanValue != null ? this.booleanValue.hashCode() : 0;
                result = 31 * result + (this.doubleValue != null ? this.doubleValue.hashCode() : 0);
                result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
                result = 31 * result + (this.integerValue != null ? this.integerValue.hashCode() : 0);
                result = 31 * result + (this.listValue != null ? this.listValue.hashCode() : 0);
                result = 31 * result + (this.longValue != null ? this.longValue.hashCode() : 0);
                result = 31 * result + (this.mapValue != null ? this.mapValue.hashCode() : 0);
                result = 31 * result + (this.relationshipValue != null ? this.relationshipValue.hashCode() : 0);
                result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The entity definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * DataTypeProperty dataTypeProperty_;
     * DataValueProperty dataValueProperty_;
     * Object relationshipValue;
     * DefinitionProperty definitionProperty = DefinitionProperty.builder()
     *         .configuration(Map.of(
     *                 "configurationKey", "configuration"))
     *         .dataType(DataTypeProperty.builder()
     *                 .allowedValues(List.of(DataValueProperty.builder()
     *                         .booleanValue(false)
     *                         .doubleValue(123)
     *                         .expression("expression")
     *                         .integerValue(123)
     *                         .listValue(List.of(dataValueProperty_))
     *                         .longValue(123)
     *                         .mapValue(Map.of(
     *                                 "mapValueKey", dataValueProperty_))
     *                         .relationshipValue(relationshipValue)
     *                         .stringValue("stringValue")
     *                         .build()))
     *                 .nestedType(dataTypeProperty_)
     *                 .relationship(RelationshipProperty.builder()
     *                         .relationshipType("relationshipType")
     *                         .targetComponentTypeId("targetComponentTypeId")
     *                         .build())
     *                 .type("type")
     *                 .unitOfMeasure("unitOfMeasure")
     *                 .build())
     *         .defaultValue(DataValueProperty.builder()
     *                 .booleanValue(false)
     *                 .doubleValue(123)
     *                 .expression("expression")
     *                 .integerValue(123)
     *                 .listValue(List.of(dataValueProperty_))
     *                 .longValue(123)
     *                 .mapValue(Map.of(
     *                         "mapValueKey", dataValueProperty_))
     *                 .relationshipValue(relationshipValue)
     *                 .stringValue("stringValue")
     *                 .build())
     *         .isExternalId(false)
     *         .isFinal(false)
     *         .isImported(false)
     *         .isInherited(false)
     *         .isRequiredInEntity(false)
     *         .isStoredExternally(false)
     *         .isTimeSeries(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnEntity.DefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(DefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
            return null;
        }

        /**
         * The data type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-datatype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-datatype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataType() {
            return null;
        }

        /**
         * The default value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-defaultvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-defaultvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultValue() {
            return null;
        }

        /**
         * Displays if the entity has a external Id.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-isexternalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-isexternalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsExternalId() {
            return null;
        }

        /**
         * Displays if the entity is final.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-isfinal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-isfinal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsFinal() {
            return null;
        }

        /**
         * Displays if the entity is imported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-isimported">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-isimported</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsImported() {
            return null;
        }

        /**
         * Displays if the entity is inherited.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-isinherited">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-isinherited</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsInherited() {
            return null;
        }

        /**
         * Displays if the entity is a required entity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-isrequiredinentity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-isrequiredinentity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsRequiredInEntity() {
            return null;
        }

        /**
         * Displays if the entity is tored externally.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-isstoredexternally">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-isstoredexternally</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsStoredExternally() {
            return null;
        }

        /**
         * Displays if the entity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-istimeseries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-definition.html#cfn-iottwinmaker-entity-definition-istimeseries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsTimeSeries() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefinitionProperty> {
            java.lang.Object configuration;
            java.lang.Object dataType;
            java.lang.Object defaultValue;
            java.lang.Object isExternalId;
            java.lang.Object isFinal;
            java.lang.Object isImported;
            java.lang.Object isInherited;
            java.lang.Object isRequiredInEntity;
            java.lang.Object isStoredExternally;
            java.lang.Object isTimeSeries;

            /**
             * Sets the value of {@link DefinitionProperty#getConfiguration}
             * @param configuration The configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(java.util.Map<java.lang.String, java.lang.String> configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getConfiguration}
             * @param configuration The configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getDataType}
             * @param dataType The data type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataType(software.amazon.awscdk.IResolvable dataType) {
                this.dataType = dataType;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getDataType}
             * @param dataType The data type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataType(software.amazon.awscdk.services.iottwinmaker.CfnEntity.DataTypeProperty dataType) {
                this.dataType = dataType;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getDefaultValue}
             * @param defaultValue The default value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(software.amazon.awscdk.IResolvable defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getDefaultValue}
             * @param defaultValue The default value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(software.amazon.awscdk.services.iottwinmaker.CfnEntity.DataValueProperty defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getIsExternalId}
             * @param isExternalId Displays if the entity has a external Id.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isExternalId(java.lang.Boolean isExternalId) {
                this.isExternalId = isExternalId;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getIsExternalId}
             * @param isExternalId Displays if the entity has a external Id.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isExternalId(software.amazon.awscdk.IResolvable isExternalId) {
                this.isExternalId = isExternalId;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getIsFinal}
             * @param isFinal Displays if the entity is final.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isFinal(java.lang.Boolean isFinal) {
                this.isFinal = isFinal;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getIsFinal}
             * @param isFinal Displays if the entity is final.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isFinal(software.amazon.awscdk.IResolvable isFinal) {
                this.isFinal = isFinal;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getIsImported}
             * @param isImported Displays if the entity is imported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isImported(java.lang.Boolean isImported) {
                this.isImported = isImported;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getIsImported}
             * @param isImported Displays if the entity is imported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isImported(software.amazon.awscdk.IResolvable isImported) {
                this.isImported = isImported;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getIsInherited}
             * @param isInherited Displays if the entity is inherited.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isInherited(java.lang.Boolean isInherited) {
                this.isInherited = isInherited;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getIsInherited}
             * @param isInherited Displays if the entity is inherited.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isInherited(software.amazon.awscdk.IResolvable isInherited) {
                this.isInherited = isInherited;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getIsRequiredInEntity}
             * @param isRequiredInEntity Displays if the entity is a required entity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isRequiredInEntity(java.lang.Boolean isRequiredInEntity) {
                this.isRequiredInEntity = isRequiredInEntity;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getIsRequiredInEntity}
             * @param isRequiredInEntity Displays if the entity is a required entity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isRequiredInEntity(software.amazon.awscdk.IResolvable isRequiredInEntity) {
                this.isRequiredInEntity = isRequiredInEntity;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getIsStoredExternally}
             * @param isStoredExternally Displays if the entity is tored externally.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isStoredExternally(java.lang.Boolean isStoredExternally) {
                this.isStoredExternally = isStoredExternally;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getIsStoredExternally}
             * @param isStoredExternally Displays if the entity is tored externally.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isStoredExternally(software.amazon.awscdk.IResolvable isStoredExternally) {
                this.isStoredExternally = isStoredExternally;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getIsTimeSeries}
             * @param isTimeSeries Displays if the entity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isTimeSeries(java.lang.Boolean isTimeSeries) {
                this.isTimeSeries = isTimeSeries;
                return this;
            }

            /**
             * Sets the value of {@link DefinitionProperty#getIsTimeSeries}
             * @param isTimeSeries Displays if the entity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isTimeSeries(software.amazon.awscdk.IResolvable isTimeSeries) {
                this.isTimeSeries = isTimeSeries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefinitionProperty {
            private final java.lang.Object configuration;
            private final java.lang.Object dataType;
            private final java.lang.Object defaultValue;
            private final java.lang.Object isExternalId;
            private final java.lang.Object isFinal;
            private final java.lang.Object isImported;
            private final java.lang.Object isInherited;
            private final java.lang.Object isRequiredInEntity;
            private final java.lang.Object isStoredExternally;
            private final java.lang.Object isTimeSeries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isExternalId = software.amazon.jsii.Kernel.get(this, "isExternalId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isFinal = software.amazon.jsii.Kernel.get(this, "isFinal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isImported = software.amazon.jsii.Kernel.get(this, "isImported", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isInherited = software.amazon.jsii.Kernel.get(this, "isInherited", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isRequiredInEntity = software.amazon.jsii.Kernel.get(this, "isRequiredInEntity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isStoredExternally = software.amazon.jsii.Kernel.get(this, "isStoredExternally", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isTimeSeries = software.amazon.jsii.Kernel.get(this, "isTimeSeries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configuration = builder.configuration;
                this.dataType = builder.dataType;
                this.defaultValue = builder.defaultValue;
                this.isExternalId = builder.isExternalId;
                this.isFinal = builder.isFinal;
                this.isImported = builder.isImported;
                this.isInherited = builder.isInherited;
                this.isRequiredInEntity = builder.isRequiredInEntity;
                this.isStoredExternally = builder.isStoredExternally;
                this.isTimeSeries = builder.isTimeSeries;
            }

            @Override
            public final java.lang.Object getConfiguration() {
                return this.configuration;
            }

            @Override
            public final java.lang.Object getDataType() {
                return this.dataType;
            }

            @Override
            public final java.lang.Object getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            public final java.lang.Object getIsExternalId() {
                return this.isExternalId;
            }

            @Override
            public final java.lang.Object getIsFinal() {
                return this.isFinal;
            }

            @Override
            public final java.lang.Object getIsImported() {
                return this.isImported;
            }

            @Override
            public final java.lang.Object getIsInherited() {
                return this.isInherited;
            }

            @Override
            public final java.lang.Object getIsRequiredInEntity() {
                return this.isRequiredInEntity;
            }

            @Override
            public final java.lang.Object getIsStoredExternally() {
                return this.isStoredExternally;
            }

            @Override
            public final java.lang.Object getIsTimeSeries() {
                return this.isTimeSeries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfiguration() != null) {
                    data.set("configuration", om.valueToTree(this.getConfiguration()));
                }
                if (this.getDataType() != null) {
                    data.set("dataType", om.valueToTree(this.getDataType()));
                }
                if (this.getDefaultValue() != null) {
                    data.set("defaultValue", om.valueToTree(this.getDefaultValue()));
                }
                if (this.getIsExternalId() != null) {
                    data.set("isExternalId", om.valueToTree(this.getIsExternalId()));
                }
                if (this.getIsFinal() != null) {
                    data.set("isFinal", om.valueToTree(this.getIsFinal()));
                }
                if (this.getIsImported() != null) {
                    data.set("isImported", om.valueToTree(this.getIsImported()));
                }
                if (this.getIsInherited() != null) {
                    data.set("isInherited", om.valueToTree(this.getIsInherited()));
                }
                if (this.getIsRequiredInEntity() != null) {
                    data.set("isRequiredInEntity", om.valueToTree(this.getIsRequiredInEntity()));
                }
                if (this.getIsStoredExternally() != null) {
                    data.set("isStoredExternally", om.valueToTree(this.getIsStoredExternally()));
                }
                if (this.getIsTimeSeries() != null) {
                    data.set("isTimeSeries", om.valueToTree(this.getIsTimeSeries()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnEntity.DefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefinitionProperty.Jsii$Proxy that = (DefinitionProperty.Jsii$Proxy) o;

                if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
                if (this.dataType != null ? !this.dataType.equals(that.dataType) : that.dataType != null) return false;
                if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) return false;
                if (this.isExternalId != null ? !this.isExternalId.equals(that.isExternalId) : that.isExternalId != null) return false;
                if (this.isFinal != null ? !this.isFinal.equals(that.isFinal) : that.isFinal != null) return false;
                if (this.isImported != null ? !this.isImported.equals(that.isImported) : that.isImported != null) return false;
                if (this.isInherited != null ? !this.isInherited.equals(that.isInherited) : that.isInherited != null) return false;
                if (this.isRequiredInEntity != null ? !this.isRequiredInEntity.equals(that.isRequiredInEntity) : that.isRequiredInEntity != null) return false;
                if (this.isStoredExternally != null ? !this.isStoredExternally.equals(that.isStoredExternally) : that.isStoredExternally != null) return false;
                return this.isTimeSeries != null ? this.isTimeSeries.equals(that.isTimeSeries) : that.isTimeSeries == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configuration != null ? this.configuration.hashCode() : 0;
                result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
                result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                result = 31 * result + (this.isExternalId != null ? this.isExternalId.hashCode() : 0);
                result = 31 * result + (this.isFinal != null ? this.isFinal.hashCode() : 0);
                result = 31 * result + (this.isImported != null ? this.isImported.hashCode() : 0);
                result = 31 * result + (this.isInherited != null ? this.isInherited.hashCode() : 0);
                result = 31 * result + (this.isRequiredInEntity != null ? this.isRequiredInEntity.hashCode() : 0);
                result = 31 * result + (this.isStoredExternally != null ? this.isStoredExternally.hashCode() : 0);
                result = 31 * result + (this.isTimeSeries != null ? this.isTimeSeries.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The entity error.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * ErrorProperty errorProperty = ErrorProperty.builder()
     *         .code("code")
     *         .message("message")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-error.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-error.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnEntity.ErrorProperty")
    @software.amazon.jsii.Jsii.Proxy(ErrorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ErrorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The entity error code.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-error.html#cfn-iottwinmaker-entity-error-code">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-error.html#cfn-iottwinmaker-entity-error-code</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCode() {
            return null;
        }

        /**
         * The entity error message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-error.html#cfn-iottwinmaker-entity-error-message">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-error.html#cfn-iottwinmaker-entity-error-message</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ErrorProperty> {
            java.lang.String code;
            java.lang.String message;

            /**
             * Sets the value of {@link ErrorProperty#getCode}
             * @param code The entity error code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder code(java.lang.String code) {
                this.code = code;
                return this;
            }

            /**
             * Sets the value of {@link ErrorProperty#getMessage}
             * @param message The entity error message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder message(java.lang.String message) {
                this.message = message;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ErrorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ErrorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ErrorProperty {
            private final java.lang.String code;
            private final java.lang.String message;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.code = builder.code;
                this.message = builder.message;
            }

            @Override
            public final java.lang.String getCode() {
                return this.code;
            }

            @Override
            public final java.lang.String getMessage() {
                return this.message;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCode() != null) {
                    data.set("code", om.valueToTree(this.getCode()));
                }
                if (this.getMessage() != null) {
                    data.set("message", om.valueToTree(this.getMessage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnEntity.ErrorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ErrorProperty.Jsii$Proxy that = (ErrorProperty.Jsii$Proxy) o;

                if (this.code != null ? !this.code.equals(that.code) : that.code != null) return false;
                return this.message != null ? this.message.equals(that.message) : that.message == null;
            }

            @Override
            public final int hashCode() {
                int result = this.code != null ? this.code.hashCode() : 0;
                result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The property group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * PropertyGroupProperty propertyGroupProperty = PropertyGroupProperty.builder()
     *         .groupType("groupType")
     *         .propertyNames(List.of("propertyNames"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-propertygroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-propertygroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnEntity.PropertyGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(PropertyGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PropertyGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The group type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-propertygroup.html#cfn-iottwinmaker-entity-propertygroup-grouptype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-propertygroup.html#cfn-iottwinmaker-entity-propertygroup-grouptype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupType() {
            return null;
        }

        /**
         * The property names.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-propertygroup.html#cfn-iottwinmaker-entity-propertygroup-propertynames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-propertygroup.html#cfn-iottwinmaker-entity-propertygroup-propertynames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPropertyNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PropertyGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PropertyGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PropertyGroupProperty> {
            java.lang.String groupType;
            java.util.List<java.lang.String> propertyNames;

            /**
             * Sets the value of {@link PropertyGroupProperty#getGroupType}
             * @param groupType The group type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupType(java.lang.String groupType) {
                this.groupType = groupType;
                return this;
            }

            /**
             * Sets the value of {@link PropertyGroupProperty#getPropertyNames}
             * @param propertyNames The property names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyNames(java.util.List<java.lang.String> propertyNames) {
                this.propertyNames = propertyNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PropertyGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PropertyGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PropertyGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PropertyGroupProperty {
            private final java.lang.String groupType;
            private final java.util.List<java.lang.String> propertyNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupType = software.amazon.jsii.Kernel.get(this, "groupType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyNames = software.amazon.jsii.Kernel.get(this, "propertyNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupType = builder.groupType;
                this.propertyNames = builder.propertyNames;
            }

            @Override
            public final java.lang.String getGroupType() {
                return this.groupType;
            }

            @Override
            public final java.util.List<java.lang.String> getPropertyNames() {
                return this.propertyNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGroupType() != null) {
                    data.set("groupType", om.valueToTree(this.getGroupType()));
                }
                if (this.getPropertyNames() != null) {
                    data.set("propertyNames", om.valueToTree(this.getPropertyNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnEntity.PropertyGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PropertyGroupProperty.Jsii$Proxy that = (PropertyGroupProperty.Jsii$Proxy) o;

                if (this.groupType != null ? !this.groupType.equals(that.groupType) : that.groupType != null) return false;
                return this.propertyNames != null ? this.propertyNames.equals(that.propertyNames) : that.propertyNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.groupType != null ? this.groupType.hashCode() : 0;
                result = 31 * result + (this.propertyNames != null ? this.propertyNames.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that sets information about a property.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * DataValueProperty dataValueProperty_;
     * Object definition;
     * Object relationshipValue;
     * PropertyProperty propertyProperty = PropertyProperty.builder()
     *         .definition(definition)
     *         .value(DataValueProperty.builder()
     *                 .booleanValue(false)
     *                 .doubleValue(123)
     *                 .expression("expression")
     *                 .integerValue(123)
     *                 .listValue(List.of(dataValueProperty_))
     *                 .longValue(123)
     *                 .mapValue(Map.of(
     *                         "mapValueKey", dataValueProperty_))
     *                 .relationshipValue(relationshipValue)
     *                 .stringValue("stringValue")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-property.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-property.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnEntity.PropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(PropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that specifies information about a property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-property.html#cfn-iottwinmaker-entity-property-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-property.html#cfn-iottwinmaker-entity-property-definition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefinition() {
            return null;
        }

        /**
         * An object that contains information about a value for a time series property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-property.html#cfn-iottwinmaker-entity-property-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-property.html#cfn-iottwinmaker-entity-property-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PropertyProperty> {
            java.lang.Object definition;
            java.lang.Object value;

            /**
             * Sets the value of {@link PropertyProperty#getDefinition}
             * @param definition An object that specifies information about a property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder definition(java.lang.Object definition) {
                this.definition = definition;
                return this;
            }

            /**
             * Sets the value of {@link PropertyProperty#getValue}
             * @param value An object that contains information about a value for a time series property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link PropertyProperty#getValue}
             * @param value An object that contains information about a value for a time series property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.iottwinmaker.CfnEntity.DataValueProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PropertyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PropertyProperty {
            private final java.lang.Object definition;
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.definition = builder.definition;
                this.value = builder.value;
            }

            @Override
            public final java.lang.Object getDefinition() {
                return this.definition;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefinition() != null) {
                    data.set("definition", om.valueToTree(this.getDefinition()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnEntity.PropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PropertyProperty.Jsii$Proxy that = (PropertyProperty.Jsii$Proxy) o;

                if (this.definition != null ? !this.definition.equals(that.definition) : that.definition != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.definition != null ? this.definition.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The entity relationship.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * RelationshipProperty relationshipProperty = RelationshipProperty.builder()
     *         .relationshipType("relationshipType")
     *         .targetComponentTypeId("targetComponentTypeId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-relationship.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-relationship.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnEntity.RelationshipProperty")
    @software.amazon.jsii.Jsii.Proxy(RelationshipProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RelationshipProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The relationship type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-relationship.html#cfn-iottwinmaker-entity-relationship-relationshiptype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-relationship.html#cfn-iottwinmaker-entity-relationship-relationshiptype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRelationshipType() {
            return null;
        }

        /**
         * the component type Id target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-relationship.html#cfn-iottwinmaker-entity-relationship-targetcomponenttypeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-relationship.html#cfn-iottwinmaker-entity-relationship-targetcomponenttypeid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetComponentTypeId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RelationshipProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RelationshipProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RelationshipProperty> {
            java.lang.String relationshipType;
            java.lang.String targetComponentTypeId;

            /**
             * Sets the value of {@link RelationshipProperty#getRelationshipType}
             * @param relationshipType The relationship type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationshipType(java.lang.String relationshipType) {
                this.relationshipType = relationshipType;
                return this;
            }

            /**
             * Sets the value of {@link RelationshipProperty#getTargetComponentTypeId}
             * @param targetComponentTypeId the component type Id target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetComponentTypeId(java.lang.String targetComponentTypeId) {
                this.targetComponentTypeId = targetComponentTypeId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RelationshipProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RelationshipProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RelationshipProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RelationshipProperty {
            private final java.lang.String relationshipType;
            private final java.lang.String targetComponentTypeId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.relationshipType = software.amazon.jsii.Kernel.get(this, "relationshipType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetComponentTypeId = software.amazon.jsii.Kernel.get(this, "targetComponentTypeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.relationshipType = builder.relationshipType;
                this.targetComponentTypeId = builder.targetComponentTypeId;
            }

            @Override
            public final java.lang.String getRelationshipType() {
                return this.relationshipType;
            }

            @Override
            public final java.lang.String getTargetComponentTypeId() {
                return this.targetComponentTypeId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRelationshipType() != null) {
                    data.set("relationshipType", om.valueToTree(this.getRelationshipType()));
                }
                if (this.getTargetComponentTypeId() != null) {
                    data.set("targetComponentTypeId", om.valueToTree(this.getTargetComponentTypeId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnEntity.RelationshipProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RelationshipProperty.Jsii$Proxy that = (RelationshipProperty.Jsii$Proxy) o;

                if (this.relationshipType != null ? !this.relationshipType.equals(that.relationshipType) : that.relationshipType != null) return false;
                return this.targetComponentTypeId != null ? this.targetComponentTypeId.equals(that.targetComponentTypeId) : that.targetComponentTypeId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.relationshipType != null ? this.relationshipType.hashCode() : 0;
                result = 31 * result + (this.targetComponentTypeId != null ? this.targetComponentTypeId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The entity relationship.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * RelationshipValueProperty relationshipValueProperty = RelationshipValueProperty.builder()
     *         .targetComponentName("targetComponentName")
     *         .targetEntityId("targetEntityId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-relationshipvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-relationshipvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnEntity.RelationshipValueProperty")
    @software.amazon.jsii.Jsii.Proxy(RelationshipValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RelationshipValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The target component name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-relationshipvalue.html#cfn-iottwinmaker-entity-relationshipvalue-targetcomponentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-relationshipvalue.html#cfn-iottwinmaker-entity-relationshipvalue-targetcomponentname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetComponentName() {
            return null;
        }

        /**
         * The target entity Id.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-relationshipvalue.html#cfn-iottwinmaker-entity-relationshipvalue-targetentityid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-relationshipvalue.html#cfn-iottwinmaker-entity-relationshipvalue-targetentityid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetEntityId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RelationshipValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RelationshipValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RelationshipValueProperty> {
            java.lang.String targetComponentName;
            java.lang.String targetEntityId;

            /**
             * Sets the value of {@link RelationshipValueProperty#getTargetComponentName}
             * @param targetComponentName The target component name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetComponentName(java.lang.String targetComponentName) {
                this.targetComponentName = targetComponentName;
                return this;
            }

            /**
             * Sets the value of {@link RelationshipValueProperty#getTargetEntityId}
             * @param targetEntityId The target entity Id.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetEntityId(java.lang.String targetEntityId) {
                this.targetEntityId = targetEntityId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RelationshipValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RelationshipValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RelationshipValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RelationshipValueProperty {
            private final java.lang.String targetComponentName;
            private final java.lang.String targetEntityId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetComponentName = software.amazon.jsii.Kernel.get(this, "targetComponentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetEntityId = software.amazon.jsii.Kernel.get(this, "targetEntityId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetComponentName = builder.targetComponentName;
                this.targetEntityId = builder.targetEntityId;
            }

            @Override
            public final java.lang.String getTargetComponentName() {
                return this.targetComponentName;
            }

            @Override
            public final java.lang.String getTargetEntityId() {
                return this.targetEntityId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTargetComponentName() != null) {
                    data.set("targetComponentName", om.valueToTree(this.getTargetComponentName()));
                }
                if (this.getTargetEntityId() != null) {
                    data.set("targetEntityId", om.valueToTree(this.getTargetEntityId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnEntity.RelationshipValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RelationshipValueProperty.Jsii$Proxy that = (RelationshipValueProperty.Jsii$Proxy) o;

                if (this.targetComponentName != null ? !this.targetComponentName.equals(that.targetComponentName) : that.targetComponentName != null) return false;
                return this.targetEntityId != null ? this.targetEntityId.equals(that.targetEntityId) : that.targetEntityId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetComponentName != null ? this.targetComponentName.hashCode() : 0;
                result = 31 * result + (this.targetEntityId != null ? this.targetEntityId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The current status of the entity.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * Object error;
     * StatusProperty statusProperty = StatusProperty.builder()
     *         .error(error)
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-status.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-status.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnEntity.StatusProperty")
    @software.amazon.jsii.Jsii.Proxy(StatusProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatusProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The error message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-status.html#cfn-iottwinmaker-entity-status-error">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-status.html#cfn-iottwinmaker-entity-status-error</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getError() {
            return null;
        }

        /**
         * The current state of the entity, component, component type, or workspace.
         * <p>
         * Valid Values: <code>CREATING | UPDATING | DELETING | ACTIVE | ERROR</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-status.html#cfn-iottwinmaker-entity-status-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-status.html#cfn-iottwinmaker-entity-status-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StatusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatusProperty> {
            java.lang.Object error;
            java.lang.String state;

            /**
             * Sets the value of {@link StatusProperty#getError}
             * @param error The error message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder error(java.lang.Object error) {
                this.error = error;
                return this;
            }

            /**
             * Sets the value of {@link StatusProperty#getState}
             * @param state The current state of the entity, component, component type, or workspace.
             *              Valid Values: <code>CREATING | UPDATING | DELETING | ACTIVE | ERROR</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatusProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatusProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatusProperty {
            private final java.lang.Object error;
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.error = software.amazon.jsii.Kernel.get(this, "error", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.error = builder.error;
                this.state = builder.state;
            }

            @Override
            public final java.lang.Object getError() {
                return this.error;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getError() != null) {
                    data.set("error", om.valueToTree(this.getError()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnEntity.StatusProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatusProperty.Jsii$Proxy that = (StatusProperty.Jsii$Proxy) o;

                if (this.error != null ? !this.error.equals(that.error) : that.error != null) return false;
                return this.state != null ? this.state.equals(that.state) : that.state == null;
            }

            @Override
            public final int hashCode() {
                int result = this.error != null ? this.error.hashCode() : 0;
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iottwinmaker.CfnEntity}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iottwinmaker.CfnEntity> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iottwinmaker.CfnEntityProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iottwinmaker.CfnEntityProps.Builder();
        }

        /**
         * The entity name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-entityname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-entityname</a>
         * @param entityName The entity name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityName(final java.lang.String entityName) {
            this.props.entityName(entityName);
            return this;
        }

        /**
         * The ID of the workspace that contains the entity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-workspaceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-workspaceid</a>
         * @param workspaceId The ID of the workspace that contains the entity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workspaceId(final java.lang.String workspaceId) {
            this.props.workspaceId(workspaceId);
            return this;
        }

        /**
         * An object that maps strings to the components in the entity.
         * <p>
         * Each string in the mapping must be unique to this object.
         * <p>
         * For information on the component object see the <a href="https://docs.aws.amazon.com//iot-twinmaker/latest/apireference/API_ComponentResponse.html">component</a> API reference.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-components">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-components</a>
         * @param components An object that maps strings to the components in the entity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder components(final software.amazon.awscdk.IResolvable components) {
            this.props.components(components);
            return this;
        }
        /**
         * An object that maps strings to the components in the entity.
         * <p>
         * Each string in the mapping must be unique to this object.
         * <p>
         * For information on the component object see the <a href="https://docs.aws.amazon.com//iot-twinmaker/latest/apireference/API_ComponentResponse.html">component</a> API reference.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-components">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-components</a>
         * @param components An object that maps strings to the components in the entity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder components(final java.util.Map<java.lang.String, ? extends java.lang.Object> components) {
            this.props.components(components);
            return this;
        }

        /**
         * Maps string to <code>compositeComponent</code> updates in the request.
         * <p>
         * Each key of the map represents the <code>componentPath</code> of the <code>compositeComponent</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-compositecomponents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-compositecomponents</a>
         * @param compositeComponents Maps string to <code>compositeComponent</code> updates in the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compositeComponents(final software.amazon.awscdk.IResolvable compositeComponents) {
            this.props.compositeComponents(compositeComponents);
            return this;
        }
        /**
         * Maps string to <code>compositeComponent</code> updates in the request.
         * <p>
         * Each key of the map represents the <code>componentPath</code> of the <code>compositeComponent</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-compositecomponents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-compositecomponents</a>
         * @param compositeComponents Maps string to <code>compositeComponent</code> updates in the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compositeComponents(final java.util.Map<java.lang.String, ? extends java.lang.Object> compositeComponents) {
            this.props.compositeComponents(compositeComponents);
            return this;
        }

        /**
         * The description of the entity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-description</a>
         * @param description The description of the entity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The ID of the entity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-entityid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-entityid</a>
         * @param entityId The ID of the entity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityId(final java.lang.String entityId) {
            this.props.entityId(entityId);
            return this;
        }

        /**
         * The ID of the parent entity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-parententityid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-parententityid</a>
         * @param parentEntityId The ID of the parent entity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parentEntityId(final java.lang.String parentEntityId) {
            this.props.parentEntityId(parentEntityId);
            return this;
        }

        /**
         * Metadata that you can use to manage the entity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-tags</a>
         * @param tags Metadata that you can use to manage the entity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iottwinmaker.CfnEntity}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iottwinmaker.CfnEntity build() {
            return new software.amazon.awscdk.services.iottwinmaker.CfnEntity(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
