package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Enables logging for error logs with an optional custom CloudWatch log group.
 * <p>
 * When this class is used, logging is enabled (<code>logging: true</code>) and
 * you can optionally provide a CloudWatch log group for storing the error logs.
 * <p>
 * If no log group is provided, a default one will be created automatically.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.*;
 * Bucket bucket;
 * LogGroup logGroup = new LogGroup(this, "Log Group");
 * S3Bucket destination = S3Bucket.Builder.create(bucket)
 *         .loggingConfig(new EnableLogging(logGroup))
 *         .build();
 * DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destination(destination)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:09.250Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.EnableLogging")
public class EnableLogging extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig {

    protected EnableLogging(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EnableLogging(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param logGroup The CloudWatch log group where log streams will be created to hold error logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EnableLogging(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup logGroup) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { logGroup });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EnableLogging() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * If true, log errors when data transformation or data delivery fails.
     * <p>
     * <code>true</code> when using <code>EnableLogging</code>, <code>false</code> when using <code>DisableLogging</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getLogging() {
        return software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The CloudWatch log group where log streams will be created to hold error logs.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
    }
}
