package software.amazon.awscdk.services.lambda;

/**
 * The format target function should recieve record in.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource;
 * import software.amazon.awscdk.services.lambda.eventsources.ConfluentSchemaRegistry;
 * import software.amazon.awscdk.services.secretsmanager.Secret;
 * // Your MSK cluster arn
 * String clusterArn;
 * Function myFunction;
 * // The Kafka topic you want to subscribe to
 * String topic = "some-cool-topic";
 * Secret secret = Secret.Builder.create(this, "Secret").secretName("AmazonMSK_KafkaSecret").build();
 * myFunction.addEventSource(ManagedKafkaEventSource.Builder.create()
 *         .clusterArn(clusterArn)
 *         .topic(topic)
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .provisionedPollerConfig(ProvisionedPollerConfig.builder()
 *                 .minimumPollers(1)
 *                 .maximumPollers(3)
 *                 .build())
 *         .schemaRegistryConfig(ConfluentSchemaRegistry.Builder.create()
 *                 .schemaRegistryUri("https://example.com")
 *                 .eventRecordFormat(EventRecordFormat.JSON)
 *                 .authenticationType(KafkaSchemaRegistryAccessConfigType.BASIC_AUTH)
 *                 .secret(secret)
 *                 .schemaValidationConfigs(List.of(KafkaSchemaValidationConfig.builder().attribute(KafkaSchemaValidationAttribute.KEY).build()))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:09.469Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.EventRecordFormat")
public class EventRecordFormat extends software.amazon.jsii.JsiiObject {

    protected EventRecordFormat(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EventRecordFormat(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        JSON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.EventRecordFormat.class, "JSON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.EventRecordFormat.class));
        SOURCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.EventRecordFormat.class, "SOURCE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.EventRecordFormat.class));
    }

    /**
     * A custom event record format.
     * <p>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EventRecordFormat of(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.EventRecordFormat.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.EventRecordFormat.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * The target function will recieve records as json objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.EventRecordFormat JSON;

    /**
     * The target function will recieve records in same format as the schema source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.lambda.EventRecordFormat SOURCE;

    /**
     * The enum to use in <code>SchemaRegistryConfig.EventRecordFormat</code> property in CloudFormation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
