package software.amazon.awscdk.services.lambda;

/**
 * The invoke modes for a Lambda function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn;
 * fn.addFunctionUrl(FunctionUrlOptions.builder()
 *         .authType(FunctionUrlAuthType.NONE)
 *         .invokeMode(InvokeMode.RESPONSE_STREAM)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:09.527Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.InvokeMode")
public enum InvokeMode {
    /**
     * Default option.
     * <p>
     * Lambda invokes your function using the Invoke API operation.
     * Invocation results are available when the payload is complete.
     * The maximum payload size is 6 MB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BUFFERED,
    /**
     * Your function streams payload results as they become available.
     * <p>
     * Lambda invokes your function using the InvokeWithResponseStream API operation.
     * The maximum response payload size is 20 MB, however, you can request a quota increase.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RESPONSE_STREAM,
}
