package software.amazon.awscdk.services.lambda.eventsources;

/**
 * Confluent schema registry configuration for a Lambda event source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource;
 * import software.amazon.awscdk.services.lambda.eventsources.ConfluentSchemaRegistry;
 * import software.amazon.awscdk.services.secretsmanager.Secret;
 * // Your MSK cluster arn
 * String clusterArn;
 * Function myFunction;
 * // The Kafka topic you want to subscribe to
 * String topic = "some-cool-topic";
 * Secret secret = Secret.Builder.create(this, "Secret").secretName("AmazonMSK_KafkaSecret").build();
 * myFunction.addEventSource(ManagedKafkaEventSource.Builder.create()
 *         .clusterArn(clusterArn)
 *         .topic(topic)
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .provisionedPollerConfig(ProvisionedPollerConfig.builder()
 *                 .minimumPollers(1)
 *                 .maximumPollers(3)
 *                 .build())
 *         .schemaRegistryConfig(ConfluentSchemaRegistry.Builder.create()
 *                 .schemaRegistryUri("https://example.com")
 *                 .eventRecordFormat(EventRecordFormat.JSON)
 *                 .authenticationType(KafkaSchemaRegistryAccessConfigType.BASIC_AUTH)
 *                 .secret(secret)
 *                 .schemaValidationConfigs(List.of(KafkaSchemaValidationConfig.builder().attribute(KafkaSchemaValidationAttribute.KEY).build()))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:09.577Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.ConfluentSchemaRegistry")
public class ConfluentSchemaRegistry extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.ISchemaRegistry {

    protected ConfluentSchemaRegistry(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ConfluentSchemaRegistry(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ConfluentSchemaRegistry(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.eventsources.ConfluentSchemaRegistryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns a schema registry configuration.
     * <p>
     * @param _target This parameter is required.
     * @param targetHandler This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.KafkaSchemaRegistryConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IEventSourceMapping _target, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction targetHandler) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryConfig.class), new Object[] { java.util.Objects.requireNonNull(_target, "_target is required"), java.util.Objects.requireNonNull(targetHandler, "targetHandler is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.eventsources.ConfluentSchemaRegistry}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.eventsources.ConfluentSchemaRegistry> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.lambda.eventsources.ConfluentSchemaRegistryProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.lambda.eventsources.ConfluentSchemaRegistryProps.Builder();
        }

        /**
         * The record format that Lambda delivers to your function after schema validation.
         * <p>
         * <ul>
         * <li>Choose JSON to have Lambda deliver the record to your function as a standard JSON object.</li>
         * <li>Choose SOURCE to have Lambda deliver the record to your function in its original source format. Lambda removes all schema metadata, such as the schema ID, before sending the record to your function.</li>
         * </ul>
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param eventRecordFormat The record format that Lambda delivers to your function after schema validation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventRecordFormat(final software.amazon.awscdk.services.lambda.EventRecordFormat eventRecordFormat) {
            this.props.eventRecordFormat(eventRecordFormat);
            return this;
        }

        /**
         * An array of schema validation configuration objects, which tell Lambda the message attributes you want to validate and filter using your schema registry.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param schemaValidationConfigs An array of schema validation configuration objects, which tell Lambda the message attributes you want to validate and filter using your schema registry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaValidationConfigs(final java.util.List<? extends software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> schemaValidationConfigs) {
            this.props.schemaValidationConfigs(schemaValidationConfigs);
            return this;
        }

        /**
         * The type of authentication for schema registry credentials.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param authenticationType The type of authentication for schema registry credentials. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationType(final software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfigType authenticationType) {
            this.props.authenticationType(authenticationType);
            return this;
        }

        /**
         * The URI for your schema registry.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param schemaRegistryUri The URI for your schema registry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaRegistryUri(final java.lang.String schemaRegistryUri) {
            this.props.schemaRegistryUri(schemaRegistryUri);
            return this;
        }

        /**
         * The secret with the schema registry credentials.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param secret The secret with the schema registry credentials. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(final software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.props.secret(secret);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lambda.eventsources.ConfluentSchemaRegistry}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.eventsources.ConfluentSchemaRegistry build() {
            return new software.amazon.awscdk.services.lambda.eventsources.ConfluentSchemaRegistry(
                this.props.build()
            );
        }
    }
}
