package software.amazon.awscdk.services.lambda.eventsources;

/**
 * The set of properties for streaming event sources shared by Dynamo and Kinesis.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.lambda.eventsources.*;
 * IEventSourceDlq eventSourceDlq;
 * Object filters;
 * Key key;
 * StreamEventSourceProps streamEventSourceProps = StreamEventSourceProps.builder()
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         // the properties below are optional
 *         .batchSize(123)
 *         .bisectBatchOnError(false)
 *         .enabled(false)
 *         .filterEncryption(key)
 *         .filters(List.of(Map.of(
 *                 "filtersKey", filters)))
 *         .maxBatchingWindow(Duration.minutes(30))
 *         .maxRecordAge(Duration.minutes(30))
 *         .metricsConfig(MetricsConfig.builder()
 *                 .metrics(List.of(MetricType.EVENT_COUNT))
 *                 .build())
 *         .onFailure(eventSourceDlq)
 *         .parallelizationFactor(123)
 *         .provisionedPollerConfig(ProvisionedPollerConfig.builder()
 *                 .maximumPollers(123)
 *                 .minimumPollers(123)
 *                 .build())
 *         .reportBatchItemFailures(false)
 *         .retryAttempts(123)
 *         .tumblingWindow(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:09.607Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.StreamEventSourceProps")
@software.amazon.jsii.Jsii.Proxy(StreamEventSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StreamEventSourceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.eventsources.BaseStreamEventSourceProps {

    /**
     * If the function returns an error, split the batch in two and retry.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getBisectBatchOnError() {
        return null;
    }

    /**
     * Add Customer managed KMS key to encrypt Filter Criteria.
     * <p>
     * Default: - none
     * <p>
     * @see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk">https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getFilterEncryption() {
        return null;
    }

    /**
     * Add filter criteria option.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.util.Map<java.lang.String, java.lang.Object>> getFilters() {
        return null;
    }

    /**
     * The maximum age of a record that Lambda sends to a function for processing.
     * <p>
     * Valid Range:
     * <p>
     * <ul>
     * <li>Minimum value of 60 seconds</li>
     * <li>Maximum value of 7 days</li>
     * </ul>
     * <p>
     * The default value is -1, which sets the maximum age to infinite.
     * When the value is set to infinite, Lambda never discards old records.
     * Record are valid until it expires in the event source.
     * <p>
     * Default: -1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMaxRecordAge() {
        return null;
    }

    /**
     * Configuration for enhanced monitoring metrics collection When specified, enables collection of additional metrics for the stream event source.
     * <p>
     * Default: - Enhanced monitoring is disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.MetricsConfig getMetricsConfig() {
        return null;
    }

    /**
     * An Amazon S3, Amazon SQS queue or Amazon SNS topic destination for discarded records.
     * <p>
     * Default: - discarded records are ignored
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IEventSourceDlq getOnFailure() {
        return null;
    }

    /**
     * The number of batches to process from each shard concurrently.
     * <p>
     * Valid Range:
     * <p>
     * <ul>
     * <li>Minimum value of 1</li>
     * <li>Maximum value of 10</li>
     * </ul>
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getParallelizationFactor() {
        return null;
    }

    /**
     * Allow functions to return partially successful responses for a batch of records.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting">https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-batchfailurereporting</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReportBatchItemFailures() {
        return null;
    }

    /**
     * Maximum number of retry attempts.
     * <p>
     * Set to -1 for infinite retries (until the record expires in the event source).
     * <p>
     * Valid Range: -1 (infinite) or 0 to 10000
     * <p>
     * Default: -1 (infinite retries)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRetryAttempts() {
        return null;
    }

    /**
     * The size of the tumbling windows to group records sent to DynamoDB or Kinesis Valid Range: 0 - 15 minutes.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTumblingWindow() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StreamEventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StreamEventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StreamEventSourceProps> {
        java.lang.Boolean bisectBatchOnError;
        software.amazon.awscdk.services.kms.IKey filterEncryption;
        java.util.List<java.util.Map<java.lang.String, java.lang.Object>> filters;
        software.amazon.awscdk.Duration maxRecordAge;
        software.amazon.awscdk.services.lambda.MetricsConfig metricsConfig;
        software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure;
        java.lang.Number parallelizationFactor;
        java.lang.Boolean reportBatchItemFailures;
        java.lang.Number retryAttempts;
        software.amazon.awscdk.Duration tumblingWindow;
        software.amazon.awscdk.services.lambda.StartingPosition startingPosition;
        java.lang.Number batchSize;
        java.lang.Boolean enabled;
        software.amazon.awscdk.Duration maxBatchingWindow;
        software.amazon.awscdk.services.lambda.eventsources.ProvisionedPollerConfig provisionedPollerConfig;

        /**
         * Sets the value of {@link StreamEventSourceProps#getBisectBatchOnError}
         * @param bisectBatchOnError If the function returns an error, split the batch in two and retry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bisectBatchOnError(java.lang.Boolean bisectBatchOnError) {
            this.bisectBatchOnError = bisectBatchOnError;
            return this;
        }

        /**
         * Sets the value of {@link StreamEventSourceProps#getFilterEncryption}
         * @param filterEncryption Add Customer managed KMS key to encrypt Filter Criteria.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterEncryption(software.amazon.awscdk.services.kms.IKey filterEncryption) {
            this.filterEncryption = filterEncryption;
            return this;
        }

        /**
         * Sets the value of {@link StreamEventSourceProps#getFilters}
         * @param filters Add filter criteria option.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder filters(java.util.List<? extends java.util.Map<java.lang.String, ? extends java.lang.Object>> filters) {
            this.filters = (java.util.List<java.util.Map<java.lang.String, java.lang.Object>>)filters;
            return this;
        }

        /**
         * Sets the value of {@link StreamEventSourceProps#getMaxRecordAge}
         * @param maxRecordAge The maximum age of a record that Lambda sends to a function for processing.
         *                     Valid Range:
         *                     <p>
         *                     <ul>
         *                     <li>Minimum value of 60 seconds</li>
         *                     <li>Maximum value of 7 days</li>
         *                     </ul>
         *                     <p>
         *                     The default value is -1, which sets the maximum age to infinite.
         *                     When the value is set to infinite, Lambda never discards old records.
         *                     Record are valid until it expires in the event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRecordAge(software.amazon.awscdk.Duration maxRecordAge) {
            this.maxRecordAge = maxRecordAge;
            return this;
        }

        /**
         * Sets the value of {@link StreamEventSourceProps#getMetricsConfig}
         * @param metricsConfig Configuration for enhanced monitoring metrics collection When specified, enables collection of additional metrics for the stream event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsConfig(software.amazon.awscdk.services.lambda.MetricsConfig metricsConfig) {
            this.metricsConfig = metricsConfig;
            return this;
        }

        /**
         * Sets the value of {@link StreamEventSourceProps#getOnFailure}
         * @param onFailure An Amazon S3, Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        /**
         * Sets the value of {@link StreamEventSourceProps#getParallelizationFactor}
         * @param parallelizationFactor The number of batches to process from each shard concurrently.
         *                              Valid Range:
         *                              <p>
         *                              <ul>
         *                              <li>Minimum value of 1</li>
         *                              <li>Maximum value of 10</li>
         *                              </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parallelizationFactor(java.lang.Number parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        /**
         * Sets the value of {@link StreamEventSourceProps#getReportBatchItemFailures}
         * @param reportBatchItemFailures Allow functions to return partially successful responses for a batch of records.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportBatchItemFailures(java.lang.Boolean reportBatchItemFailures) {
            this.reportBatchItemFailures = reportBatchItemFailures;
            return this;
        }

        /**
         * Sets the value of {@link StreamEventSourceProps#getRetryAttempts}
         * @param retryAttempts Maximum number of retry attempts.
         *                      Set to -1 for infinite retries (until the record expires in the event source).
         *                      <p>
         *                      Valid Range: -1 (infinite) or 0 to 10000
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Sets the value of {@link StreamEventSourceProps#getTumblingWindow}
         * @param tumblingWindow The size of the tumbling windows to group records sent to DynamoDB or Kinesis Valid Range: 0 - 15 minutes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tumblingWindow(software.amazon.awscdk.Duration tumblingWindow) {
            this.tumblingWindow = tumblingWindow;
            return this;
        }

        /**
         * Sets the value of {@link StreamEventSourceProps#getStartingPosition}
         * @param startingPosition Where to begin consuming the stream. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPosition(software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        /**
         * Sets the value of {@link StreamEventSourceProps#getBatchSize}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         *                  Your function receives an
         *                  event with all the retrieved records.
         *                  <p>
         *                  Valid Range:
         *                  <p>
         *                  <ul>
         *                  <li>Minimum value of 1</li>
         *                  <li>Maximum value of:
         *                  <p>
         *                  <ul>
         *                  <li>1000 for <code>DynamoEventSource</code></li>
         *                  <li>10000 for <code>KinesisEventSource</code>, <code>ManagedKafkaEventSource</code> and <code>SelfManagedKafkaEventSource</code></li>
         *                  </ul></li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(java.lang.Number batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        /**
         * Sets the value of {@link StreamEventSourceProps#getEnabled}
         * @param enabled If the stream event source mapping should be enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link StreamEventSourceProps#getMaxBatchingWindow}
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function.
         *                          Maximum of Duration.minutes(5).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchingWindow(software.amazon.awscdk.Duration maxBatchingWindow) {
            this.maxBatchingWindow = maxBatchingWindow;
            return this;
        }

        /**
         * Sets the value of {@link StreamEventSourceProps#getProvisionedPollerConfig}
         * @param provisionedPollerConfig Configuration for provisioned pollers that read from the event source.
         *                                When specified, allows control over the minimum and maximum number of pollers
         *                                that can be provisioned to process events from the source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedPollerConfig(software.amazon.awscdk.services.lambda.eventsources.ProvisionedPollerConfig provisionedPollerConfig) {
            this.provisionedPollerConfig = provisionedPollerConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StreamEventSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StreamEventSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StreamEventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamEventSourceProps {
        private final java.lang.Boolean bisectBatchOnError;
        private final software.amazon.awscdk.services.kms.IKey filterEncryption;
        private final java.util.List<java.util.Map<java.lang.String, java.lang.Object>> filters;
        private final software.amazon.awscdk.Duration maxRecordAge;
        private final software.amazon.awscdk.services.lambda.MetricsConfig metricsConfig;
        private final software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure;
        private final java.lang.Number parallelizationFactor;
        private final java.lang.Boolean reportBatchItemFailures;
        private final java.lang.Number retryAttempts;
        private final software.amazon.awscdk.Duration tumblingWindow;
        private final software.amazon.awscdk.services.lambda.StartingPosition startingPosition;
        private final java.lang.Number batchSize;
        private final java.lang.Boolean enabled;
        private final software.amazon.awscdk.Duration maxBatchingWindow;
        private final software.amazon.awscdk.services.lambda.eventsources.ProvisionedPollerConfig provisionedPollerConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bisectBatchOnError = software.amazon.jsii.Kernel.get(this, "bisectBatchOnError", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.filterEncryption = software.amazon.jsii.Kernel.get(this, "filterEncryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.filters = software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
            this.maxRecordAge = software.amazon.jsii.Kernel.get(this, "maxRecordAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.metricsConfig = software.amazon.jsii.Kernel.get(this, "metricsConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.MetricsConfig.class));
            this.onFailure = software.amazon.jsii.Kernel.get(this, "onFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IEventSourceDlq.class));
            this.parallelizationFactor = software.amazon.jsii.Kernel.get(this, "parallelizationFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.reportBatchItemFailures = software.amazon.jsii.Kernel.get(this, "reportBatchItemFailures", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tumblingWindow = software.amazon.jsii.Kernel.get(this, "tumblingWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.startingPosition = software.amazon.jsii.Kernel.get(this, "startingPosition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.StartingPosition.class));
            this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.maxBatchingWindow = software.amazon.jsii.Kernel.get(this, "maxBatchingWindow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.provisionedPollerConfig = software.amazon.jsii.Kernel.get(this, "provisionedPollerConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.eventsources.ProvisionedPollerConfig.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bisectBatchOnError = builder.bisectBatchOnError;
            this.filterEncryption = builder.filterEncryption;
            this.filters = (java.util.List<java.util.Map<java.lang.String, java.lang.Object>>)builder.filters;
            this.maxRecordAge = builder.maxRecordAge;
            this.metricsConfig = builder.metricsConfig;
            this.onFailure = builder.onFailure;
            this.parallelizationFactor = builder.parallelizationFactor;
            this.reportBatchItemFailures = builder.reportBatchItemFailures;
            this.retryAttempts = builder.retryAttempts;
            this.tumblingWindow = builder.tumblingWindow;
            this.startingPosition = java.util.Objects.requireNonNull(builder.startingPosition, "startingPosition is required");
            this.batchSize = builder.batchSize;
            this.enabled = builder.enabled;
            this.maxBatchingWindow = builder.maxBatchingWindow;
            this.provisionedPollerConfig = builder.provisionedPollerConfig;
        }

        @Override
        public final java.lang.Boolean getBisectBatchOnError() {
            return this.bisectBatchOnError;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getFilterEncryption() {
            return this.filterEncryption;
        }

        @Override
        public final java.util.List<java.util.Map<java.lang.String, java.lang.Object>> getFilters() {
            return this.filters;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxRecordAge() {
            return this.maxRecordAge;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.MetricsConfig getMetricsConfig() {
            return this.metricsConfig;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IEventSourceDlq getOnFailure() {
            return this.onFailure;
        }

        @Override
        public final java.lang.Number getParallelizationFactor() {
            return this.parallelizationFactor;
        }

        @Override
        public final java.lang.Boolean getReportBatchItemFailures() {
            return this.reportBatchItemFailures;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public final software.amazon.awscdk.Duration getTumblingWindow() {
            return this.tumblingWindow;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.StartingPosition getStartingPosition() {
            return this.startingPosition;
        }

        @Override
        public final java.lang.Number getBatchSize() {
            return this.batchSize;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxBatchingWindow() {
            return this.maxBatchingWindow;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.eventsources.ProvisionedPollerConfig getProvisionedPollerConfig() {
            return this.provisionedPollerConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBisectBatchOnError() != null) {
                data.set("bisectBatchOnError", om.valueToTree(this.getBisectBatchOnError()));
            }
            if (this.getFilterEncryption() != null) {
                data.set("filterEncryption", om.valueToTree(this.getFilterEncryption()));
            }
            if (this.getFilters() != null) {
                data.set("filters", om.valueToTree(this.getFilters()));
            }
            if (this.getMaxRecordAge() != null) {
                data.set("maxRecordAge", om.valueToTree(this.getMaxRecordAge()));
            }
            if (this.getMetricsConfig() != null) {
                data.set("metricsConfig", om.valueToTree(this.getMetricsConfig()));
            }
            if (this.getOnFailure() != null) {
                data.set("onFailure", om.valueToTree(this.getOnFailure()));
            }
            if (this.getParallelizationFactor() != null) {
                data.set("parallelizationFactor", om.valueToTree(this.getParallelizationFactor()));
            }
            if (this.getReportBatchItemFailures() != null) {
                data.set("reportBatchItemFailures", om.valueToTree(this.getReportBatchItemFailures()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }
            if (this.getTumblingWindow() != null) {
                data.set("tumblingWindow", om.valueToTree(this.getTumblingWindow()));
            }
            data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
            if (this.getBatchSize() != null) {
                data.set("batchSize", om.valueToTree(this.getBatchSize()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getMaxBatchingWindow() != null) {
                data.set("maxBatchingWindow", om.valueToTree(this.getMaxBatchingWindow()));
            }
            if (this.getProvisionedPollerConfig() != null) {
                data.set("provisionedPollerConfig", om.valueToTree(this.getProvisionedPollerConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda_event_sources.StreamEventSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StreamEventSourceProps.Jsii$Proxy that = (StreamEventSourceProps.Jsii$Proxy) o;

            if (this.bisectBatchOnError != null ? !this.bisectBatchOnError.equals(that.bisectBatchOnError) : that.bisectBatchOnError != null) return false;
            if (this.filterEncryption != null ? !this.filterEncryption.equals(that.filterEncryption) : that.filterEncryption != null) return false;
            if (this.filters != null ? !this.filters.equals(that.filters) : that.filters != null) return false;
            if (this.maxRecordAge != null ? !this.maxRecordAge.equals(that.maxRecordAge) : that.maxRecordAge != null) return false;
            if (this.metricsConfig != null ? !this.metricsConfig.equals(that.metricsConfig) : that.metricsConfig != null) return false;
            if (this.onFailure != null ? !this.onFailure.equals(that.onFailure) : that.onFailure != null) return false;
            if (this.parallelizationFactor != null ? !this.parallelizationFactor.equals(that.parallelizationFactor) : that.parallelizationFactor != null) return false;
            if (this.reportBatchItemFailures != null ? !this.reportBatchItemFailures.equals(that.reportBatchItemFailures) : that.reportBatchItemFailures != null) return false;
            if (this.retryAttempts != null ? !this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts != null) return false;
            if (this.tumblingWindow != null ? !this.tumblingWindow.equals(that.tumblingWindow) : that.tumblingWindow != null) return false;
            if (!startingPosition.equals(that.startingPosition)) return false;
            if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.maxBatchingWindow != null ? !this.maxBatchingWindow.equals(that.maxBatchingWindow) : that.maxBatchingWindow != null) return false;
            return this.provisionedPollerConfig != null ? this.provisionedPollerConfig.equals(that.provisionedPollerConfig) : that.provisionedPollerConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bisectBatchOnError != null ? this.bisectBatchOnError.hashCode() : 0;
            result = 31 * result + (this.filterEncryption != null ? this.filterEncryption.hashCode() : 0);
            result = 31 * result + (this.filters != null ? this.filters.hashCode() : 0);
            result = 31 * result + (this.maxRecordAge != null ? this.maxRecordAge.hashCode() : 0);
            result = 31 * result + (this.metricsConfig != null ? this.metricsConfig.hashCode() : 0);
            result = 31 * result + (this.onFailure != null ? this.onFailure.hashCode() : 0);
            result = 31 * result + (this.parallelizationFactor != null ? this.parallelizationFactor.hashCode() : 0);
            result = 31 * result + (this.reportBatchItemFailures != null ? this.reportBatchItemFailures.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            result = 31 * result + (this.tumblingWindow != null ? this.tumblingWindow.hashCode() : 0);
            result = 31 * result + (this.startingPosition.hashCode());
            result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.maxBatchingWindow != null ? this.maxBatchingWindow.hashCode() : 0);
            result = 31 * result + (this.provisionedPollerConfig != null ? this.provisionedPollerConfig.hashCode() : 0);
            return result;
        }
    }
}
