package software.amazon.awscdk.services.lookoutmetrics;

/**
 * The <code>AWS::LookoutMetrics::AnomalyDetector</code> type creates an anomaly detector.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lookoutmetrics.*;
 * CfnAnomalyDetector cfnAnomalyDetector = CfnAnomalyDetector.Builder.create(this, "MyCfnAnomalyDetector")
 *         .anomalyDetectorConfig(AnomalyDetectorConfigProperty.builder()
 *                 .anomalyDetectorFrequency("anomalyDetectorFrequency")
 *                 .build())
 *         .metricSetList(List.of(MetricSetProperty.builder()
 *                 .metricList(List.of(MetricProperty.builder()
 *                         .aggregationFunction("aggregationFunction")
 *                         .metricName("metricName")
 *                         // the properties below are optional
 *                         .namespace("namespace")
 *                         .build()))
 *                 .metricSetName("metricSetName")
 *                 .metricSource(MetricSourceProperty.builder()
 *                         .appFlowConfig(AppFlowConfigProperty.builder()
 *                                 .flowName("flowName")
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .cloudwatchConfig(CloudwatchConfigProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .rdsSourceConfig(RDSSourceConfigProperty.builder()
 *                                 .databaseHost("databaseHost")
 *                                 .databaseName("databaseName")
 *                                 .databasePort(123)
 *                                 .dbInstanceIdentifier("dbInstanceIdentifier")
 *                                 .roleArn("roleArn")
 *                                 .secretManagerArn("secretManagerArn")
 *                                 .tableName("tableName")
 *                                 .vpcConfiguration(VpcConfigurationProperty.builder()
 *                                         .securityGroupIdList(List.of("securityGroupIdList"))
 *                                         .subnetIdList(List.of("subnetIdList"))
 *                                         .build())
 *                                 .build())
 *                         .redshiftSourceConfig(RedshiftSourceConfigProperty.builder()
 *                                 .clusterIdentifier("clusterIdentifier")
 *                                 .databaseHost("databaseHost")
 *                                 .databaseName("databaseName")
 *                                 .databasePort(123)
 *                                 .roleArn("roleArn")
 *                                 .secretManagerArn("secretManagerArn")
 *                                 .tableName("tableName")
 *                                 .vpcConfiguration(VpcConfigurationProperty.builder()
 *                                         .securityGroupIdList(List.of("securityGroupIdList"))
 *                                         .subnetIdList(List.of("subnetIdList"))
 *                                         .build())
 *                                 .build())
 *                         .s3SourceConfig(S3SourceConfigProperty.builder()
 *                                 .fileFormatDescriptor(FileFormatDescriptorProperty.builder()
 *                                         .csvFormatDescriptor(CsvFormatDescriptorProperty.builder()
 *                                                 .charset("charset")
 *                                                 .containsHeader(false)
 *                                                 .delimiter("delimiter")
 *                                                 .fileCompression("fileCompression")
 *                                                 .headerList(List.of("headerList"))
 *                                                 .quoteSymbol("quoteSymbol")
 *                                                 .build())
 *                                         .jsonFormatDescriptor(JsonFormatDescriptorProperty.builder()
 *                                                 .charset("charset")
 *                                                 .fileCompression("fileCompression")
 *                                                 .build())
 *                                         .build())
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .historicalDataPathList(List.of("historicalDataPathList"))
 *                                 .templatedPathList(List.of("templatedPathList"))
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .dimensionList(List.of("dimensionList"))
 *                 .metricSetDescription("metricSetDescription")
 *                 .metricSetFrequency("metricSetFrequency")
 *                 .offset(123)
 *                 .timestampColumn(TimestampColumnProperty.builder()
 *                         .columnFormat("columnFormat")
 *                         .columnName("columnName")
 *                         .build())
 *                 .timezone("timezone")
 *                 .build()))
 *         // the properties below are optional
 *         .anomalyDetectorDescription("anomalyDetectorDescription")
 *         .anomalyDetectorName("anomalyDetectorName")
 *         .kmsKeyArn("kmsKeyArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:10.092Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector")
public class CfnAnomalyDetector extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnAnomalyDetector(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAnomalyDetector(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAnomalyDetector(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetectorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the detector.
     * <p>
     * For example, <code>arn:aws:lookoutmetrics:us-east-2:123456789012:AnomalyDetector:my-detector</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Contains information about the configuration of the anomaly detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAnomalyDetectorConfig() {
        return software.amazon.jsii.Kernel.get(this, "anomalyDetectorConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains information about the configuration of the anomaly detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnomalyDetectorConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "anomalyDetectorConfig", java.util.Objects.requireNonNull(value, "anomalyDetectorConfig is required"));
    }

    /**
     * Contains information about the configuration of the anomaly detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnomalyDetectorConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.AnomalyDetectorConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "anomalyDetectorConfig", java.util.Objects.requireNonNull(value, "anomalyDetectorConfig is required"));
    }

    /**
     * The detector's dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMetricSetList() {
        return software.amazon.jsii.Kernel.get(this, "metricSetList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The detector's dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricSetList(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "metricSetList", java.util.Objects.requireNonNull(value, "metricSetList is required"));
    }

    /**
     * The detector's dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricSetList(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.MetricSetProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.MetricSetProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "metricSetList", java.util.Objects.requireNonNull(value, "metricSetList is required"));
    }

    /**
     * A description of the detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAnomalyDetectorDescription() {
        return software.amazon.jsii.Kernel.get(this, "anomalyDetectorDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnomalyDetectorDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "anomalyDetectorDescription", value);
    }

    /**
     * The name of the detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAnomalyDetectorName() {
        return software.amazon.jsii.Kernel.get(this, "anomalyDetectorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnomalyDetectorName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "anomalyDetectorName", value);
    }

    /**
     * The ARN of the KMS key to use to encrypt your data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the KMS key to use to encrypt your data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyArn", value);
    }
    /**
     * Contains information about a detector's configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lookoutmetrics.*;
     * AnomalyDetectorConfigProperty anomalyDetectorConfigProperty = AnomalyDetectorConfigProperty.builder()
     *         .anomalyDetectorFrequency("anomalyDetectorFrequency")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-anomalydetectorconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-anomalydetectorconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.AnomalyDetectorConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AnomalyDetectorConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnomalyDetectorConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The frequency at which the detector analyzes its source data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-anomalydetectorconfig.html#cfn-lookoutmetrics-anomalydetector-anomalydetectorconfig-anomalydetectorfrequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-anomalydetectorconfig.html#cfn-lookoutmetrics-anomalydetector-anomalydetectorconfig-anomalydetectorfrequency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAnomalyDetectorFrequency();

        /**
         * @return a {@link Builder} of {@link AnomalyDetectorConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnomalyDetectorConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnomalyDetectorConfigProperty> {
            java.lang.String anomalyDetectorFrequency;

            /**
             * Sets the value of {@link AnomalyDetectorConfigProperty#getAnomalyDetectorFrequency}
             * @param anomalyDetectorFrequency The frequency at which the detector analyzes its source data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder anomalyDetectorFrequency(java.lang.String anomalyDetectorFrequency) {
                this.anomalyDetectorFrequency = anomalyDetectorFrequency;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnomalyDetectorConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnomalyDetectorConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnomalyDetectorConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnomalyDetectorConfigProperty {
            private final java.lang.String anomalyDetectorFrequency;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.anomalyDetectorFrequency = software.amazon.jsii.Kernel.get(this, "anomalyDetectorFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.anomalyDetectorFrequency = java.util.Objects.requireNonNull(builder.anomalyDetectorFrequency, "anomalyDetectorFrequency is required");
            }

            @Override
            public final java.lang.String getAnomalyDetectorFrequency() {
                return this.anomalyDetectorFrequency;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("anomalyDetectorFrequency", om.valueToTree(this.getAnomalyDetectorFrequency()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.AnomalyDetectorConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnomalyDetectorConfigProperty.Jsii$Proxy that = (AnomalyDetectorConfigProperty.Jsii$Proxy) o;

                return this.anomalyDetectorFrequency.equals(that.anomalyDetectorFrequency);
            }

            @Override
            public final int hashCode() {
                int result = this.anomalyDetectorFrequency.hashCode();
                return result;
            }
        }
    }
    /**
     * Details about an Amazon AppFlow flow datasource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lookoutmetrics.*;
     * AppFlowConfigProperty appFlowConfigProperty = AppFlowConfigProperty.builder()
     *         .flowName("flowName")
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-appflowconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-appflowconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.AppFlowConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AppFlowConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AppFlowConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * name of the flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-appflowconfig.html#cfn-lookoutmetrics-anomalydetector-appflowconfig-flowname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-appflowconfig.html#cfn-lookoutmetrics-anomalydetector-appflowconfig-flowname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFlowName();

        /**
         * An IAM role that gives Amazon Lookout for Metrics permission to access the flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-appflowconfig.html#cfn-lookoutmetrics-anomalydetector-appflowconfig-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-appflowconfig.html#cfn-lookoutmetrics-anomalydetector-appflowconfig-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link AppFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AppFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AppFlowConfigProperty> {
            java.lang.String flowName;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link AppFlowConfigProperty#getFlowName}
             * @param flowName name of the flow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flowName(java.lang.String flowName) {
                this.flowName = flowName;
                return this;
            }

            /**
             * Sets the value of {@link AppFlowConfigProperty#getRoleArn}
             * @param roleArn An IAM role that gives Amazon Lookout for Metrics permission to access the flow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AppFlowConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AppFlowConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AppFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppFlowConfigProperty {
            private final java.lang.String flowName;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.flowName = software.amazon.jsii.Kernel.get(this, "flowName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.flowName = java.util.Objects.requireNonNull(builder.flowName, "flowName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.String getFlowName() {
                return this.flowName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("flowName", om.valueToTree(this.getFlowName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.AppFlowConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AppFlowConfigProperty.Jsii$Proxy that = (AppFlowConfigProperty.Jsii$Proxy) o;

                if (!flowName.equals(that.flowName)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.flowName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Details about an Amazon CloudWatch datasource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lookoutmetrics.*;
     * CloudwatchConfigProperty cloudwatchConfigProperty = CloudwatchConfigProperty.builder()
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-cloudwatchconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-cloudwatchconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.CloudwatchConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudwatchConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudwatchConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An IAM role that gives Amazon Lookout for Metrics permission to access data in Amazon CloudWatch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-cloudwatchconfig.html#cfn-lookoutmetrics-anomalydetector-cloudwatchconfig-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-cloudwatchconfig.html#cfn-lookoutmetrics-anomalydetector-cloudwatchconfig-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link CloudwatchConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudwatchConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudwatchConfigProperty> {
            java.lang.String roleArn;

            /**
             * Sets the value of {@link CloudwatchConfigProperty#getRoleArn}
             * @param roleArn An IAM role that gives Amazon Lookout for Metrics permission to access data in Amazon CloudWatch. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudwatchConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudwatchConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudwatchConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudwatchConfigProperty {
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.CloudwatchConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudwatchConfigProperty.Jsii$Proxy that = (CloudwatchConfigProperty.Jsii$Proxy) o;

                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains information about how a source CSV data file should be analyzed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lookoutmetrics.*;
     * CsvFormatDescriptorProperty csvFormatDescriptorProperty = CsvFormatDescriptorProperty.builder()
     *         .charset("charset")
     *         .containsHeader(false)
     *         .delimiter("delimiter")
     *         .fileCompression("fileCompression")
     *         .headerList(List.of("headerList"))
     *         .quoteSymbol("quoteSymbol")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.CsvFormatDescriptorProperty")
    @software.amazon.jsii.Jsii.Proxy(CsvFormatDescriptorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CsvFormatDescriptorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The character set in which the source CSV file is written.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-charset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-charset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCharset() {
            return null;
        }

        /**
         * Whether or not the source CSV file contains a header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-containsheader">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-containsheader</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainsHeader() {
            return null;
        }

        /**
         * The character used to delimit the source CSV file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-delimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-delimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDelimiter() {
            return null;
        }

        /**
         * The level of compression of the source CSV file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-filecompression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-filecompression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFileCompression() {
            return null;
        }

        /**
         * A list of the source CSV file's headers, if any.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-headerlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-headerlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHeaderList() {
            return null;
        }

        /**
         * The character used as a quote character.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-quotesymbol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-csvformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-csvformatdescriptor-quotesymbol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQuoteSymbol() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CsvFormatDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CsvFormatDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CsvFormatDescriptorProperty> {
            java.lang.String charset;
            java.lang.Object containsHeader;
            java.lang.String delimiter;
            java.lang.String fileCompression;
            java.util.List<java.lang.String> headerList;
            java.lang.String quoteSymbol;

            /**
             * Sets the value of {@link CsvFormatDescriptorProperty#getCharset}
             * @param charset The character set in which the source CSV file is written.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder charset(java.lang.String charset) {
                this.charset = charset;
                return this;
            }

            /**
             * Sets the value of {@link CsvFormatDescriptorProperty#getContainsHeader}
             * @param containsHeader Whether or not the source CSV file contains a header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containsHeader(java.lang.Boolean containsHeader) {
                this.containsHeader = containsHeader;
                return this;
            }

            /**
             * Sets the value of {@link CsvFormatDescriptorProperty#getContainsHeader}
             * @param containsHeader Whether or not the source CSV file contains a header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containsHeader(software.amazon.awscdk.IResolvable containsHeader) {
                this.containsHeader = containsHeader;
                return this;
            }

            /**
             * Sets the value of {@link CsvFormatDescriptorProperty#getDelimiter}
             * @param delimiter The character used to delimit the source CSV file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delimiter(java.lang.String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            /**
             * Sets the value of {@link CsvFormatDescriptorProperty#getFileCompression}
             * @param fileCompression The level of compression of the source CSV file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileCompression(java.lang.String fileCompression) {
                this.fileCompression = fileCompression;
                return this;
            }

            /**
             * Sets the value of {@link CsvFormatDescriptorProperty#getHeaderList}
             * @param headerList A list of the source CSV file's headers, if any.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerList(java.util.List<java.lang.String> headerList) {
                this.headerList = headerList;
                return this;
            }

            /**
             * Sets the value of {@link CsvFormatDescriptorProperty#getQuoteSymbol}
             * @param quoteSymbol The character used as a quote character.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quoteSymbol(java.lang.String quoteSymbol) {
                this.quoteSymbol = quoteSymbol;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CsvFormatDescriptorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CsvFormatDescriptorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CsvFormatDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CsvFormatDescriptorProperty {
            private final java.lang.String charset;
            private final java.lang.Object containsHeader;
            private final java.lang.String delimiter;
            private final java.lang.String fileCompression;
            private final java.util.List<java.lang.String> headerList;
            private final java.lang.String quoteSymbol;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.charset = software.amazon.jsii.Kernel.get(this, "charset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containsHeader = software.amazon.jsii.Kernel.get(this, "containsHeader", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.delimiter = software.amazon.jsii.Kernel.get(this, "delimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fileCompression = software.amazon.jsii.Kernel.get(this, "fileCompression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headerList = software.amazon.jsii.Kernel.get(this, "headerList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.quoteSymbol = software.amazon.jsii.Kernel.get(this, "quoteSymbol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.charset = builder.charset;
                this.containsHeader = builder.containsHeader;
                this.delimiter = builder.delimiter;
                this.fileCompression = builder.fileCompression;
                this.headerList = builder.headerList;
                this.quoteSymbol = builder.quoteSymbol;
            }

            @Override
            public final java.lang.String getCharset() {
                return this.charset;
            }

            @Override
            public final java.lang.Object getContainsHeader() {
                return this.containsHeader;
            }

            @Override
            public final java.lang.String getDelimiter() {
                return this.delimiter;
            }

            @Override
            public final java.lang.String getFileCompression() {
                return this.fileCompression;
            }

            @Override
            public final java.util.List<java.lang.String> getHeaderList() {
                return this.headerList;
            }

            @Override
            public final java.lang.String getQuoteSymbol() {
                return this.quoteSymbol;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCharset() != null) {
                    data.set("charset", om.valueToTree(this.getCharset()));
                }
                if (this.getContainsHeader() != null) {
                    data.set("containsHeader", om.valueToTree(this.getContainsHeader()));
                }
                if (this.getDelimiter() != null) {
                    data.set("delimiter", om.valueToTree(this.getDelimiter()));
                }
                if (this.getFileCompression() != null) {
                    data.set("fileCompression", om.valueToTree(this.getFileCompression()));
                }
                if (this.getHeaderList() != null) {
                    data.set("headerList", om.valueToTree(this.getHeaderList()));
                }
                if (this.getQuoteSymbol() != null) {
                    data.set("quoteSymbol", om.valueToTree(this.getQuoteSymbol()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.CsvFormatDescriptorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CsvFormatDescriptorProperty.Jsii$Proxy that = (CsvFormatDescriptorProperty.Jsii$Proxy) o;

                if (this.charset != null ? !this.charset.equals(that.charset) : that.charset != null) return false;
                if (this.containsHeader != null ? !this.containsHeader.equals(that.containsHeader) : that.containsHeader != null) return false;
                if (this.delimiter != null ? !this.delimiter.equals(that.delimiter) : that.delimiter != null) return false;
                if (this.fileCompression != null ? !this.fileCompression.equals(that.fileCompression) : that.fileCompression != null) return false;
                if (this.headerList != null ? !this.headerList.equals(that.headerList) : that.headerList != null) return false;
                return this.quoteSymbol != null ? this.quoteSymbol.equals(that.quoteSymbol) : that.quoteSymbol == null;
            }

            @Override
            public final int hashCode() {
                int result = this.charset != null ? this.charset.hashCode() : 0;
                result = 31 * result + (this.containsHeader != null ? this.containsHeader.hashCode() : 0);
                result = 31 * result + (this.delimiter != null ? this.delimiter.hashCode() : 0);
                result = 31 * result + (this.fileCompression != null ? this.fileCompression.hashCode() : 0);
                result = 31 * result + (this.headerList != null ? this.headerList.hashCode() : 0);
                result = 31 * result + (this.quoteSymbol != null ? this.quoteSymbol.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a source file's formatting.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lookoutmetrics.*;
     * FileFormatDescriptorProperty fileFormatDescriptorProperty = FileFormatDescriptorProperty.builder()
     *         .csvFormatDescriptor(CsvFormatDescriptorProperty.builder()
     *                 .charset("charset")
     *                 .containsHeader(false)
     *                 .delimiter("delimiter")
     *                 .fileCompression("fileCompression")
     *                 .headerList(List.of("headerList"))
     *                 .quoteSymbol("quoteSymbol")
     *                 .build())
     *         .jsonFormatDescriptor(JsonFormatDescriptorProperty.builder()
     *                 .charset("charset")
     *                 .fileCompression("fileCompression")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-fileformatdescriptor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-fileformatdescriptor.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.FileFormatDescriptorProperty")
    @software.amazon.jsii.Jsii.Proxy(FileFormatDescriptorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FileFormatDescriptorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains information about how a source CSV data file should be analyzed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-fileformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-fileformatdescriptor-csvformatdescriptor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-fileformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-fileformatdescriptor-csvformatdescriptor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCsvFormatDescriptor() {
            return null;
        }

        /**
         * Contains information about how a source JSON data file should be analyzed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-fileformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-fileformatdescriptor-jsonformatdescriptor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-fileformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-fileformatdescriptor-jsonformatdescriptor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJsonFormatDescriptor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FileFormatDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FileFormatDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FileFormatDescriptorProperty> {
            java.lang.Object csvFormatDescriptor;
            java.lang.Object jsonFormatDescriptor;

            /**
             * Sets the value of {@link FileFormatDescriptorProperty#getCsvFormatDescriptor}
             * @param csvFormatDescriptor Contains information about how a source CSV data file should be analyzed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvFormatDescriptor(software.amazon.awscdk.IResolvable csvFormatDescriptor) {
                this.csvFormatDescriptor = csvFormatDescriptor;
                return this;
            }

            /**
             * Sets the value of {@link FileFormatDescriptorProperty#getCsvFormatDescriptor}
             * @param csvFormatDescriptor Contains information about how a source CSV data file should be analyzed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvFormatDescriptor(software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.CsvFormatDescriptorProperty csvFormatDescriptor) {
                this.csvFormatDescriptor = csvFormatDescriptor;
                return this;
            }

            /**
             * Sets the value of {@link FileFormatDescriptorProperty#getJsonFormatDescriptor}
             * @param jsonFormatDescriptor Contains information about how a source JSON data file should be analyzed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonFormatDescriptor(software.amazon.awscdk.IResolvable jsonFormatDescriptor) {
                this.jsonFormatDescriptor = jsonFormatDescriptor;
                return this;
            }

            /**
             * Sets the value of {@link FileFormatDescriptorProperty#getJsonFormatDescriptor}
             * @param jsonFormatDescriptor Contains information about how a source JSON data file should be analyzed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonFormatDescriptor(software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.JsonFormatDescriptorProperty jsonFormatDescriptor) {
                this.jsonFormatDescriptor = jsonFormatDescriptor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FileFormatDescriptorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FileFormatDescriptorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FileFormatDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileFormatDescriptorProperty {
            private final java.lang.Object csvFormatDescriptor;
            private final java.lang.Object jsonFormatDescriptor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.csvFormatDescriptor = software.amazon.jsii.Kernel.get(this, "csvFormatDescriptor", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jsonFormatDescriptor = software.amazon.jsii.Kernel.get(this, "jsonFormatDescriptor", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.csvFormatDescriptor = builder.csvFormatDescriptor;
                this.jsonFormatDescriptor = builder.jsonFormatDescriptor;
            }

            @Override
            public final java.lang.Object getCsvFormatDescriptor() {
                return this.csvFormatDescriptor;
            }

            @Override
            public final java.lang.Object getJsonFormatDescriptor() {
                return this.jsonFormatDescriptor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCsvFormatDescriptor() != null) {
                    data.set("csvFormatDescriptor", om.valueToTree(this.getCsvFormatDescriptor()));
                }
                if (this.getJsonFormatDescriptor() != null) {
                    data.set("jsonFormatDescriptor", om.valueToTree(this.getJsonFormatDescriptor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.FileFormatDescriptorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FileFormatDescriptorProperty.Jsii$Proxy that = (FileFormatDescriptorProperty.Jsii$Proxy) o;

                if (this.csvFormatDescriptor != null ? !this.csvFormatDescriptor.equals(that.csvFormatDescriptor) : that.csvFormatDescriptor != null) return false;
                return this.jsonFormatDescriptor != null ? this.jsonFormatDescriptor.equals(that.jsonFormatDescriptor) : that.jsonFormatDescriptor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.csvFormatDescriptor != null ? this.csvFormatDescriptor.hashCode() : 0;
                result = 31 * result + (this.jsonFormatDescriptor != null ? this.jsonFormatDescriptor.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about how a source JSON data file should be analyzed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lookoutmetrics.*;
     * JsonFormatDescriptorProperty jsonFormatDescriptorProperty = JsonFormatDescriptorProperty.builder()
     *         .charset("charset")
     *         .fileCompression("fileCompression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-jsonformatdescriptor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-jsonformatdescriptor.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.JsonFormatDescriptorProperty")
    @software.amazon.jsii.Jsii.Proxy(JsonFormatDescriptorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JsonFormatDescriptorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The character set in which the source JSON file is written.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-jsonformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-jsonformatdescriptor-charset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-jsonformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-jsonformatdescriptor-charset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCharset() {
            return null;
        }

        /**
         * The level of compression of the source CSV file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-jsonformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-jsonformatdescriptor-filecompression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-jsonformatdescriptor.html#cfn-lookoutmetrics-anomalydetector-jsonformatdescriptor-filecompression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFileCompression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JsonFormatDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JsonFormatDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JsonFormatDescriptorProperty> {
            java.lang.String charset;
            java.lang.String fileCompression;

            /**
             * Sets the value of {@link JsonFormatDescriptorProperty#getCharset}
             * @param charset The character set in which the source JSON file is written.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder charset(java.lang.String charset) {
                this.charset = charset;
                return this;
            }

            /**
             * Sets the value of {@link JsonFormatDescriptorProperty#getFileCompression}
             * @param fileCompression The level of compression of the source CSV file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileCompression(java.lang.String fileCompression) {
                this.fileCompression = fileCompression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JsonFormatDescriptorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JsonFormatDescriptorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JsonFormatDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonFormatDescriptorProperty {
            private final java.lang.String charset;
            private final java.lang.String fileCompression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.charset = software.amazon.jsii.Kernel.get(this, "charset", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fileCompression = software.amazon.jsii.Kernel.get(this, "fileCompression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.charset = builder.charset;
                this.fileCompression = builder.fileCompression;
            }

            @Override
            public final java.lang.String getCharset() {
                return this.charset;
            }

            @Override
            public final java.lang.String getFileCompression() {
                return this.fileCompression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCharset() != null) {
                    data.set("charset", om.valueToTree(this.getCharset()));
                }
                if (this.getFileCompression() != null) {
                    data.set("fileCompression", om.valueToTree(this.getFileCompression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.JsonFormatDescriptorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JsonFormatDescriptorProperty.Jsii$Proxy that = (JsonFormatDescriptorProperty.Jsii$Proxy) o;

                if (this.charset != null ? !this.charset.equals(that.charset) : that.charset != null) return false;
                return this.fileCompression != null ? this.fileCompression.equals(that.fileCompression) : that.fileCompression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.charset != null ? this.charset.hashCode() : 0;
                result = 31 * result + (this.fileCompression != null ? this.fileCompression.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A calculation made by contrasting a measure and a dimension from your source data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lookoutmetrics.*;
     * MetricProperty metricProperty = MetricProperty.builder()
     *         .aggregationFunction("aggregationFunction")
     *         .metricName("metricName")
     *         // the properties below are optional
     *         .namespace("namespace")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metric.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metric.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.MetricProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The function with which the metric is calculated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metric.html#cfn-lookoutmetrics-anomalydetector-metric-aggregationfunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metric.html#cfn-lookoutmetrics-anomalydetector-metric-aggregationfunction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAggregationFunction();

        /**
         * The name of the metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metric.html#cfn-lookoutmetrics-anomalydetector-metric-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metric.html#cfn-lookoutmetrics-anomalydetector-metric-metricname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * The namespace for the metric.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metric.html#cfn-lookoutmetrics-anomalydetector-metric-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metric.html#cfn-lookoutmetrics-anomalydetector-metric-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricProperty> {
            java.lang.String aggregationFunction;
            java.lang.String metricName;
            java.lang.String namespace;

            /**
             * Sets the value of {@link MetricProperty#getAggregationFunction}
             * @param aggregationFunction The function with which the metric is calculated. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationFunction(java.lang.String aggregationFunction) {
                this.aggregationFunction = aggregationFunction;
                return this;
            }

            /**
             * Sets the value of {@link MetricProperty#getMetricName}
             * @param metricName The name of the metric. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link MetricProperty#getNamespace}
             * @param namespace The namespace for the metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricProperty {
            private final java.lang.String aggregationFunction;
            private final java.lang.String metricName;
            private final java.lang.String namespace;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregationFunction = software.amazon.jsii.Kernel.get(this, "aggregationFunction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregationFunction = java.util.Objects.requireNonNull(builder.aggregationFunction, "aggregationFunction is required");
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.namespace = builder.namespace;
            }

            @Override
            public final java.lang.String getAggregationFunction() {
                return this.aggregationFunction;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("aggregationFunction", om.valueToTree(this.getAggregationFunction()));
                data.set("metricName", om.valueToTree(this.getMetricName()));
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.MetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricProperty.Jsii$Proxy that = (MetricProperty.Jsii$Proxy) o;

                if (!aggregationFunction.equals(that.aggregationFunction)) return false;
                if (!metricName.equals(that.metricName)) return false;
                return this.namespace != null ? this.namespace.equals(that.namespace) : that.namespace == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aggregationFunction.hashCode();
                result = 31 * result + (this.metricName.hashCode());
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lookoutmetrics.*;
     * MetricSetProperty metricSetProperty = MetricSetProperty.builder()
     *         .metricList(List.of(MetricProperty.builder()
     *                 .aggregationFunction("aggregationFunction")
     *                 .metricName("metricName")
     *                 // the properties below are optional
     *                 .namespace("namespace")
     *                 .build()))
     *         .metricSetName("metricSetName")
     *         .metricSource(MetricSourceProperty.builder()
     *                 .appFlowConfig(AppFlowConfigProperty.builder()
     *                         .flowName("flowName")
     *                         .roleArn("roleArn")
     *                         .build())
     *                 .cloudwatchConfig(CloudwatchConfigProperty.builder()
     *                         .roleArn("roleArn")
     *                         .build())
     *                 .rdsSourceConfig(RDSSourceConfigProperty.builder()
     *                         .databaseHost("databaseHost")
     *                         .databaseName("databaseName")
     *                         .databasePort(123)
     *                         .dbInstanceIdentifier("dbInstanceIdentifier")
     *                         .roleArn("roleArn")
     *                         .secretManagerArn("secretManagerArn")
     *                         .tableName("tableName")
     *                         .vpcConfiguration(VpcConfigurationProperty.builder()
     *                                 .securityGroupIdList(List.of("securityGroupIdList"))
     *                                 .subnetIdList(List.of("subnetIdList"))
     *                                 .build())
     *                         .build())
     *                 .redshiftSourceConfig(RedshiftSourceConfigProperty.builder()
     *                         .clusterIdentifier("clusterIdentifier")
     *                         .databaseHost("databaseHost")
     *                         .databaseName("databaseName")
     *                         .databasePort(123)
     *                         .roleArn("roleArn")
     *                         .secretManagerArn("secretManagerArn")
     *                         .tableName("tableName")
     *                         .vpcConfiguration(VpcConfigurationProperty.builder()
     *                                 .securityGroupIdList(List.of("securityGroupIdList"))
     *                                 .subnetIdList(List.of("subnetIdList"))
     *                                 .build())
     *                         .build())
     *                 .s3SourceConfig(S3SourceConfigProperty.builder()
     *                         .fileFormatDescriptor(FileFormatDescriptorProperty.builder()
     *                                 .csvFormatDescriptor(CsvFormatDescriptorProperty.builder()
     *                                         .charset("charset")
     *                                         .containsHeader(false)
     *                                         .delimiter("delimiter")
     *                                         .fileCompression("fileCompression")
     *                                         .headerList(List.of("headerList"))
     *                                         .quoteSymbol("quoteSymbol")
     *                                         .build())
     *                                 .jsonFormatDescriptor(JsonFormatDescriptorProperty.builder()
     *                                         .charset("charset")
     *                                         .fileCompression("fileCompression")
     *                                         .build())
     *                                 .build())
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .historicalDataPathList(List.of("historicalDataPathList"))
     *                         .templatedPathList(List.of("templatedPathList"))
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .dimensionList(List.of("dimensionList"))
     *         .metricSetDescription("metricSetDescription")
     *         .metricSetFrequency("metricSetFrequency")
     *         .offset(123)
     *         .timestampColumn(TimestampColumnProperty.builder()
     *                 .columnFormat("columnFormat")
     *                 .columnName("columnName")
     *                 .build())
     *         .timezone("timezone")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.MetricSetProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of metrics that the dataset will contain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-metriclist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-metriclist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMetricList();

        /**
         * The name of the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-metricsetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-metricsetname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricSetName();

        /**
         * Contains information about how the source data should be interpreted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-metricsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-metricsource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMetricSource();

        /**
         * A list of the fields you want to treat as dimensions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-dimensionlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-dimensionlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDimensionList() {
            return null;
        }

        /**
         * A description of the dataset you are creating.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-metricsetdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-metricsetdescription</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricSetDescription() {
            return null;
        }

        /**
         * The frequency with which the source data will be analyzed for anomalies.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-metricsetfrequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-metricsetfrequency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetricSetFrequency() {
            return null;
        }

        /**
         * After an interval ends, the amount of seconds that the detector waits before importing data.
         * <p>
         * Offset is only supported for S3, Redshift, Athena and datasources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-offset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-offset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOffset() {
            return null;
        }

        /**
         * Contains information about the column used for tracking time in your source data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-timestampcolumn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-timestampcolumn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimestampColumn() {
            return null;
        }

        /**
         * The time zone in which your source data was recorded.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-timezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricset.html#cfn-lookoutmetrics-anomalydetector-metricset-timezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimezone() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricSetProperty> {
            java.lang.Object metricList;
            java.lang.String metricSetName;
            java.lang.Object metricSource;
            java.util.List<java.lang.String> dimensionList;
            java.lang.String metricSetDescription;
            java.lang.String metricSetFrequency;
            java.lang.Number offset;
            java.lang.Object timestampColumn;
            java.lang.String timezone;

            /**
             * Sets the value of {@link MetricSetProperty#getMetricList}
             * @param metricList A list of metrics that the dataset will contain. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricList(software.amazon.awscdk.IResolvable metricList) {
                this.metricList = metricList;
                return this;
            }

            /**
             * Sets the value of {@link MetricSetProperty#getMetricList}
             * @param metricList A list of metrics that the dataset will contain. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricList(java.util.List<? extends java.lang.Object> metricList) {
                this.metricList = metricList;
                return this;
            }

            /**
             * Sets the value of {@link MetricSetProperty#getMetricSetName}
             * @param metricSetName The name of the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricSetName(java.lang.String metricSetName) {
                this.metricSetName = metricSetName;
                return this;
            }

            /**
             * Sets the value of {@link MetricSetProperty#getMetricSource}
             * @param metricSource Contains information about how the source data should be interpreted. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricSource(software.amazon.awscdk.IResolvable metricSource) {
                this.metricSource = metricSource;
                return this;
            }

            /**
             * Sets the value of {@link MetricSetProperty#getMetricSource}
             * @param metricSource Contains information about how the source data should be interpreted. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricSource(software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.MetricSourceProperty metricSource) {
                this.metricSource = metricSource;
                return this;
            }

            /**
             * Sets the value of {@link MetricSetProperty#getDimensionList}
             * @param dimensionList A list of the fields you want to treat as dimensions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionList(java.util.List<java.lang.String> dimensionList) {
                this.dimensionList = dimensionList;
                return this;
            }

            /**
             * Sets the value of {@link MetricSetProperty#getMetricSetDescription}
             * @param metricSetDescription A description of the dataset you are creating.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricSetDescription(java.lang.String metricSetDescription) {
                this.metricSetDescription = metricSetDescription;
                return this;
            }

            /**
             * Sets the value of {@link MetricSetProperty#getMetricSetFrequency}
             * @param metricSetFrequency The frequency with which the source data will be analyzed for anomalies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricSetFrequency(java.lang.String metricSetFrequency) {
                this.metricSetFrequency = metricSetFrequency;
                return this;
            }

            /**
             * Sets the value of {@link MetricSetProperty#getOffset}
             * @param offset After an interval ends, the amount of seconds that the detector waits before importing data.
             *               Offset is only supported for S3, Redshift, Athena and datasources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder offset(java.lang.Number offset) {
                this.offset = offset;
                return this;
            }

            /**
             * Sets the value of {@link MetricSetProperty#getTimestampColumn}
             * @param timestampColumn Contains information about the column used for tracking time in your source data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestampColumn(software.amazon.awscdk.IResolvable timestampColumn) {
                this.timestampColumn = timestampColumn;
                return this;
            }

            /**
             * Sets the value of {@link MetricSetProperty#getTimestampColumn}
             * @param timestampColumn Contains information about the column used for tracking time in your source data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestampColumn(software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.TimestampColumnProperty timestampColumn) {
                this.timestampColumn = timestampColumn;
                return this;
            }

            /**
             * Sets the value of {@link MetricSetProperty#getTimezone}
             * @param timezone The time zone in which your source data was recorded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timezone(java.lang.String timezone) {
                this.timezone = timezone;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricSetProperty {
            private final java.lang.Object metricList;
            private final java.lang.String metricSetName;
            private final java.lang.Object metricSource;
            private final java.util.List<java.lang.String> dimensionList;
            private final java.lang.String metricSetDescription;
            private final java.lang.String metricSetFrequency;
            private final java.lang.Number offset;
            private final java.lang.Object timestampColumn;
            private final java.lang.String timezone;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricList = software.amazon.jsii.Kernel.get(this, "metricList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metricSetName = software.amazon.jsii.Kernel.get(this, "metricSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricSource = software.amazon.jsii.Kernel.get(this, "metricSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dimensionList = software.amazon.jsii.Kernel.get(this, "dimensionList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.metricSetDescription = software.amazon.jsii.Kernel.get(this, "metricSetDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricSetFrequency = software.amazon.jsii.Kernel.get(this, "metricSetFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.offset = software.amazon.jsii.Kernel.get(this, "offset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timestampColumn = software.amazon.jsii.Kernel.get(this, "timestampColumn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timezone = software.amazon.jsii.Kernel.get(this, "timezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricList = java.util.Objects.requireNonNull(builder.metricList, "metricList is required");
                this.metricSetName = java.util.Objects.requireNonNull(builder.metricSetName, "metricSetName is required");
                this.metricSource = java.util.Objects.requireNonNull(builder.metricSource, "metricSource is required");
                this.dimensionList = builder.dimensionList;
                this.metricSetDescription = builder.metricSetDescription;
                this.metricSetFrequency = builder.metricSetFrequency;
                this.offset = builder.offset;
                this.timestampColumn = builder.timestampColumn;
                this.timezone = builder.timezone;
            }

            @Override
            public final java.lang.Object getMetricList() {
                return this.metricList;
            }

            @Override
            public final java.lang.String getMetricSetName() {
                return this.metricSetName;
            }

            @Override
            public final java.lang.Object getMetricSource() {
                return this.metricSource;
            }

            @Override
            public final java.util.List<java.lang.String> getDimensionList() {
                return this.dimensionList;
            }

            @Override
            public final java.lang.String getMetricSetDescription() {
                return this.metricSetDescription;
            }

            @Override
            public final java.lang.String getMetricSetFrequency() {
                return this.metricSetFrequency;
            }

            @Override
            public final java.lang.Number getOffset() {
                return this.offset;
            }

            @Override
            public final java.lang.Object getTimestampColumn() {
                return this.timestampColumn;
            }

            @Override
            public final java.lang.String getTimezone() {
                return this.timezone;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricList", om.valueToTree(this.getMetricList()));
                data.set("metricSetName", om.valueToTree(this.getMetricSetName()));
                data.set("metricSource", om.valueToTree(this.getMetricSource()));
                if (this.getDimensionList() != null) {
                    data.set("dimensionList", om.valueToTree(this.getDimensionList()));
                }
                if (this.getMetricSetDescription() != null) {
                    data.set("metricSetDescription", om.valueToTree(this.getMetricSetDescription()));
                }
                if (this.getMetricSetFrequency() != null) {
                    data.set("metricSetFrequency", om.valueToTree(this.getMetricSetFrequency()));
                }
                if (this.getOffset() != null) {
                    data.set("offset", om.valueToTree(this.getOffset()));
                }
                if (this.getTimestampColumn() != null) {
                    data.set("timestampColumn", om.valueToTree(this.getTimestampColumn()));
                }
                if (this.getTimezone() != null) {
                    data.set("timezone", om.valueToTree(this.getTimezone()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.MetricSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricSetProperty.Jsii$Proxy that = (MetricSetProperty.Jsii$Proxy) o;

                if (!metricList.equals(that.metricList)) return false;
                if (!metricSetName.equals(that.metricSetName)) return false;
                if (!metricSource.equals(that.metricSource)) return false;
                if (this.dimensionList != null ? !this.dimensionList.equals(that.dimensionList) : that.dimensionList != null) return false;
                if (this.metricSetDescription != null ? !this.metricSetDescription.equals(that.metricSetDescription) : that.metricSetDescription != null) return false;
                if (this.metricSetFrequency != null ? !this.metricSetFrequency.equals(that.metricSetFrequency) : that.metricSetFrequency != null) return false;
                if (this.offset != null ? !this.offset.equals(that.offset) : that.offset != null) return false;
                if (this.timestampColumn != null ? !this.timestampColumn.equals(that.timestampColumn) : that.timestampColumn != null) return false;
                return this.timezone != null ? this.timezone.equals(that.timezone) : that.timezone == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metricList.hashCode();
                result = 31 * result + (this.metricSetName.hashCode());
                result = 31 * result + (this.metricSource.hashCode());
                result = 31 * result + (this.dimensionList != null ? this.dimensionList.hashCode() : 0);
                result = 31 * result + (this.metricSetDescription != null ? this.metricSetDescription.hashCode() : 0);
                result = 31 * result + (this.metricSetFrequency != null ? this.metricSetFrequency.hashCode() : 0);
                result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
                result = 31 * result + (this.timestampColumn != null ? this.timestampColumn.hashCode() : 0);
                result = 31 * result + (this.timezone != null ? this.timezone.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about how the source data should be interpreted.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lookoutmetrics.*;
     * MetricSourceProperty metricSourceProperty = MetricSourceProperty.builder()
     *         .appFlowConfig(AppFlowConfigProperty.builder()
     *                 .flowName("flowName")
     *                 .roleArn("roleArn")
     *                 .build())
     *         .cloudwatchConfig(CloudwatchConfigProperty.builder()
     *                 .roleArn("roleArn")
     *                 .build())
     *         .rdsSourceConfig(RDSSourceConfigProperty.builder()
     *                 .databaseHost("databaseHost")
     *                 .databaseName("databaseName")
     *                 .databasePort(123)
     *                 .dbInstanceIdentifier("dbInstanceIdentifier")
     *                 .roleArn("roleArn")
     *                 .secretManagerArn("secretManagerArn")
     *                 .tableName("tableName")
     *                 .vpcConfiguration(VpcConfigurationProperty.builder()
     *                         .securityGroupIdList(List.of("securityGroupIdList"))
     *                         .subnetIdList(List.of("subnetIdList"))
     *                         .build())
     *                 .build())
     *         .redshiftSourceConfig(RedshiftSourceConfigProperty.builder()
     *                 .clusterIdentifier("clusterIdentifier")
     *                 .databaseHost("databaseHost")
     *                 .databaseName("databaseName")
     *                 .databasePort(123)
     *                 .roleArn("roleArn")
     *                 .secretManagerArn("secretManagerArn")
     *                 .tableName("tableName")
     *                 .vpcConfiguration(VpcConfigurationProperty.builder()
     *                         .securityGroupIdList(List.of("securityGroupIdList"))
     *                         .subnetIdList(List.of("subnetIdList"))
     *                         .build())
     *                 .build())
     *         .s3SourceConfig(S3SourceConfigProperty.builder()
     *                 .fileFormatDescriptor(FileFormatDescriptorProperty.builder()
     *                         .csvFormatDescriptor(CsvFormatDescriptorProperty.builder()
     *                                 .charset("charset")
     *                                 .containsHeader(false)
     *                                 .delimiter("delimiter")
     *                                 .fileCompression("fileCompression")
     *                                 .headerList(List.of("headerList"))
     *                                 .quoteSymbol("quoteSymbol")
     *                                 .build())
     *                         .jsonFormatDescriptor(JsonFormatDescriptorProperty.builder()
     *                                 .charset("charset")
     *                                 .fileCompression("fileCompression")
     *                                 .build())
     *                         .build())
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .historicalDataPathList(List.of("historicalDataPathList"))
     *                 .templatedPathList(List.of("templatedPathList"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.MetricSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details about an AppFlow datasource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html#cfn-lookoutmetrics-anomalydetector-metricsource-appflowconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html#cfn-lookoutmetrics-anomalydetector-metricsource-appflowconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAppFlowConfig() {
            return null;
        }

        /**
         * Details about an Amazon CloudWatch monitoring datasource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html#cfn-lookoutmetrics-anomalydetector-metricsource-cloudwatchconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html#cfn-lookoutmetrics-anomalydetector-metricsource-cloudwatchconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudwatchConfig() {
            return null;
        }

        /**
         * Details about an Amazon Relational Database Service (RDS) datasource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html#cfn-lookoutmetrics-anomalydetector-metricsource-rdssourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html#cfn-lookoutmetrics-anomalydetector-metricsource-rdssourceconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRdsSourceConfig() {
            return null;
        }

        /**
         * Details about an Amazon Redshift database datasource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html#cfn-lookoutmetrics-anomalydetector-metricsource-redshiftsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html#cfn-lookoutmetrics-anomalydetector-metricsource-redshiftsourceconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftSourceConfig() {
            return null;
        }

        /**
         * Contains information about the configuration of the S3 bucket that contains source files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html#cfn-lookoutmetrics-anomalydetector-metricsource-s3sourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-metricsource.html#cfn-lookoutmetrics-anomalydetector-metricsource-s3sourceconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3SourceConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricSourceProperty> {
            java.lang.Object appFlowConfig;
            java.lang.Object cloudwatchConfig;
            java.lang.Object rdsSourceConfig;
            java.lang.Object redshiftSourceConfig;
            java.lang.Object s3SourceConfig;

            /**
             * Sets the value of {@link MetricSourceProperty#getAppFlowConfig}
             * @param appFlowConfig Details about an AppFlow datasource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appFlowConfig(software.amazon.awscdk.IResolvable appFlowConfig) {
                this.appFlowConfig = appFlowConfig;
                return this;
            }

            /**
             * Sets the value of {@link MetricSourceProperty#getAppFlowConfig}
             * @param appFlowConfig Details about an AppFlow datasource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appFlowConfig(software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.AppFlowConfigProperty appFlowConfig) {
                this.appFlowConfig = appFlowConfig;
                return this;
            }

            /**
             * Sets the value of {@link MetricSourceProperty#getCloudwatchConfig}
             * @param cloudwatchConfig Details about an Amazon CloudWatch monitoring datasource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudwatchConfig(software.amazon.awscdk.IResolvable cloudwatchConfig) {
                this.cloudwatchConfig = cloudwatchConfig;
                return this;
            }

            /**
             * Sets the value of {@link MetricSourceProperty#getCloudwatchConfig}
             * @param cloudwatchConfig Details about an Amazon CloudWatch monitoring datasource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudwatchConfig(software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.CloudwatchConfigProperty cloudwatchConfig) {
                this.cloudwatchConfig = cloudwatchConfig;
                return this;
            }

            /**
             * Sets the value of {@link MetricSourceProperty#getRdsSourceConfig}
             * @param rdsSourceConfig Details about an Amazon Relational Database Service (RDS) datasource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rdsSourceConfig(software.amazon.awscdk.IResolvable rdsSourceConfig) {
                this.rdsSourceConfig = rdsSourceConfig;
                return this;
            }

            /**
             * Sets the value of {@link MetricSourceProperty#getRdsSourceConfig}
             * @param rdsSourceConfig Details about an Amazon Relational Database Service (RDS) datasource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rdsSourceConfig(software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.RDSSourceConfigProperty rdsSourceConfig) {
                this.rdsSourceConfig = rdsSourceConfig;
                return this;
            }

            /**
             * Sets the value of {@link MetricSourceProperty#getRedshiftSourceConfig}
             * @param redshiftSourceConfig Details about an Amazon Redshift database datasource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftSourceConfig(software.amazon.awscdk.IResolvable redshiftSourceConfig) {
                this.redshiftSourceConfig = redshiftSourceConfig;
                return this;
            }

            /**
             * Sets the value of {@link MetricSourceProperty#getRedshiftSourceConfig}
             * @param redshiftSourceConfig Details about an Amazon Redshift database datasource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftSourceConfig(software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.RedshiftSourceConfigProperty redshiftSourceConfig) {
                this.redshiftSourceConfig = redshiftSourceConfig;
                return this;
            }

            /**
             * Sets the value of {@link MetricSourceProperty#getS3SourceConfig}
             * @param s3SourceConfig Contains information about the configuration of the S3 bucket that contains source files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3SourceConfig(software.amazon.awscdk.IResolvable s3SourceConfig) {
                this.s3SourceConfig = s3SourceConfig;
                return this;
            }

            /**
             * Sets the value of {@link MetricSourceProperty#getS3SourceConfig}
             * @param s3SourceConfig Contains information about the configuration of the S3 bucket that contains source files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3SourceConfig(software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.S3SourceConfigProperty s3SourceConfig) {
                this.s3SourceConfig = s3SourceConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricSourceProperty {
            private final java.lang.Object appFlowConfig;
            private final java.lang.Object cloudwatchConfig;
            private final java.lang.Object rdsSourceConfig;
            private final java.lang.Object redshiftSourceConfig;
            private final java.lang.Object s3SourceConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.appFlowConfig = software.amazon.jsii.Kernel.get(this, "appFlowConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudwatchConfig = software.amazon.jsii.Kernel.get(this, "cloudwatchConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rdsSourceConfig = software.amazon.jsii.Kernel.get(this, "rdsSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.redshiftSourceConfig = software.amazon.jsii.Kernel.get(this, "redshiftSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3SourceConfig = software.amazon.jsii.Kernel.get(this, "s3SourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.appFlowConfig = builder.appFlowConfig;
                this.cloudwatchConfig = builder.cloudwatchConfig;
                this.rdsSourceConfig = builder.rdsSourceConfig;
                this.redshiftSourceConfig = builder.redshiftSourceConfig;
                this.s3SourceConfig = builder.s3SourceConfig;
            }

            @Override
            public final java.lang.Object getAppFlowConfig() {
                return this.appFlowConfig;
            }

            @Override
            public final java.lang.Object getCloudwatchConfig() {
                return this.cloudwatchConfig;
            }

            @Override
            public final java.lang.Object getRdsSourceConfig() {
                return this.rdsSourceConfig;
            }

            @Override
            public final java.lang.Object getRedshiftSourceConfig() {
                return this.redshiftSourceConfig;
            }

            @Override
            public final java.lang.Object getS3SourceConfig() {
                return this.s3SourceConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAppFlowConfig() != null) {
                    data.set("appFlowConfig", om.valueToTree(this.getAppFlowConfig()));
                }
                if (this.getCloudwatchConfig() != null) {
                    data.set("cloudwatchConfig", om.valueToTree(this.getCloudwatchConfig()));
                }
                if (this.getRdsSourceConfig() != null) {
                    data.set("rdsSourceConfig", om.valueToTree(this.getRdsSourceConfig()));
                }
                if (this.getRedshiftSourceConfig() != null) {
                    data.set("redshiftSourceConfig", om.valueToTree(this.getRedshiftSourceConfig()));
                }
                if (this.getS3SourceConfig() != null) {
                    data.set("s3SourceConfig", om.valueToTree(this.getS3SourceConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.MetricSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricSourceProperty.Jsii$Proxy that = (MetricSourceProperty.Jsii$Proxy) o;

                if (this.appFlowConfig != null ? !this.appFlowConfig.equals(that.appFlowConfig) : that.appFlowConfig != null) return false;
                if (this.cloudwatchConfig != null ? !this.cloudwatchConfig.equals(that.cloudwatchConfig) : that.cloudwatchConfig != null) return false;
                if (this.rdsSourceConfig != null ? !this.rdsSourceConfig.equals(that.rdsSourceConfig) : that.rdsSourceConfig != null) return false;
                if (this.redshiftSourceConfig != null ? !this.redshiftSourceConfig.equals(that.redshiftSourceConfig) : that.redshiftSourceConfig != null) return false;
                return this.s3SourceConfig != null ? this.s3SourceConfig.equals(that.s3SourceConfig) : that.s3SourceConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.appFlowConfig != null ? this.appFlowConfig.hashCode() : 0;
                result = 31 * result + (this.cloudwatchConfig != null ? this.cloudwatchConfig.hashCode() : 0);
                result = 31 * result + (this.rdsSourceConfig != null ? this.rdsSourceConfig.hashCode() : 0);
                result = 31 * result + (this.redshiftSourceConfig != null ? this.redshiftSourceConfig.hashCode() : 0);
                result = 31 * result + (this.s3SourceConfig != null ? this.s3SourceConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about the Amazon Relational Database Service (RDS) configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lookoutmetrics.*;
     * RDSSourceConfigProperty rDSSourceConfigProperty = RDSSourceConfigProperty.builder()
     *         .databaseHost("databaseHost")
     *         .databaseName("databaseName")
     *         .databasePort(123)
     *         .dbInstanceIdentifier("dbInstanceIdentifier")
     *         .roleArn("roleArn")
     *         .secretManagerArn("secretManagerArn")
     *         .tableName("tableName")
     *         .vpcConfiguration(VpcConfigurationProperty.builder()
     *                 .securityGroupIdList(List.of("securityGroupIdList"))
     *                 .subnetIdList(List.of("subnetIdList"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.RDSSourceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RDSSourceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RDSSourceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The host name of the database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-databasehost">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-databasehost</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseHost();

        /**
         * The name of the RDS database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * The port number where the database can be accessed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-databaseport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-databaseport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDatabasePort();

        /**
         * A string identifying the database instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-dbinstanceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-dbinstanceidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDbInstanceIdentifier();

        /**
         * The Amazon Resource Name (ARN) of the role.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-secretmanagerarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-secretmanagerarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretManagerArn();

        /**
         * The name of the table in the database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * An object containing information about the Amazon Virtual Private Cloud (VPC) configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-vpcconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-rdssourceconfig.html#cfn-lookoutmetrics-anomalydetector-rdssourceconfig-vpcconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVpcConfiguration();

        /**
         * @return a {@link Builder} of {@link RDSSourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RDSSourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RDSSourceConfigProperty> {
            java.lang.String databaseHost;
            java.lang.String databaseName;
            java.lang.Number databasePort;
            java.lang.String dbInstanceIdentifier;
            java.lang.String roleArn;
            java.lang.String secretManagerArn;
            java.lang.String tableName;
            java.lang.Object vpcConfiguration;

            /**
             * Sets the value of {@link RDSSourceConfigProperty#getDatabaseHost}
             * @param databaseHost The host name of the database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseHost(java.lang.String databaseHost) {
                this.databaseHost = databaseHost;
                return this;
            }

            /**
             * Sets the value of {@link RDSSourceConfigProperty#getDatabaseName}
             * @param databaseName The name of the RDS database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link RDSSourceConfigProperty#getDatabasePort}
             * @param databasePort The port number where the database can be accessed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databasePort(java.lang.Number databasePort) {
                this.databasePort = databasePort;
                return this;
            }

            /**
             * Sets the value of {@link RDSSourceConfigProperty#getDbInstanceIdentifier}
             * @param dbInstanceIdentifier A string identifying the database instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dbInstanceIdentifier(java.lang.String dbInstanceIdentifier) {
                this.dbInstanceIdentifier = dbInstanceIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link RDSSourceConfigProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the role. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link RDSSourceConfigProperty#getSecretManagerArn}
             * @param secretManagerArn The Amazon Resource Name (ARN) of the AWS Secrets Manager role. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretManagerArn(java.lang.String secretManagerArn) {
                this.secretManagerArn = secretManagerArn;
                return this;
            }

            /**
             * Sets the value of {@link RDSSourceConfigProperty#getTableName}
             * @param tableName The name of the table in the database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link RDSSourceConfigProperty#getVpcConfiguration}
             * @param vpcConfiguration An object containing information about the Amazon Virtual Private Cloud (VPC) configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RDSSourceConfigProperty#getVpcConfiguration}
             * @param vpcConfiguration An object containing information about the Amazon Virtual Private Cloud (VPC) configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.VpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RDSSourceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RDSSourceConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RDSSourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RDSSourceConfigProperty {
            private final java.lang.String databaseHost;
            private final java.lang.String databaseName;
            private final java.lang.Number databasePort;
            private final java.lang.String dbInstanceIdentifier;
            private final java.lang.String roleArn;
            private final java.lang.String secretManagerArn;
            private final java.lang.String tableName;
            private final java.lang.Object vpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseHost = software.amazon.jsii.Kernel.get(this, "databaseHost", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databasePort = software.amazon.jsii.Kernel.get(this, "databasePort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dbInstanceIdentifier = software.amazon.jsii.Kernel.get(this, "dbInstanceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretManagerArn = software.amazon.jsii.Kernel.get(this, "secretManagerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcConfiguration = software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseHost = java.util.Objects.requireNonNull(builder.databaseHost, "databaseHost is required");
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.databasePort = java.util.Objects.requireNonNull(builder.databasePort, "databasePort is required");
                this.dbInstanceIdentifier = java.util.Objects.requireNonNull(builder.dbInstanceIdentifier, "dbInstanceIdentifier is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.secretManagerArn = java.util.Objects.requireNonNull(builder.secretManagerArn, "secretManagerArn is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
                this.vpcConfiguration = java.util.Objects.requireNonNull(builder.vpcConfiguration, "vpcConfiguration is required");
            }

            @Override
            public final java.lang.String getDatabaseHost() {
                return this.databaseHost;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.Number getDatabasePort() {
                return this.databasePort;
            }

            @Override
            public final java.lang.String getDbInstanceIdentifier() {
                return this.dbInstanceIdentifier;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getSecretManagerArn() {
                return this.secretManagerArn;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.Object getVpcConfiguration() {
                return this.vpcConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseHost", om.valueToTree(this.getDatabaseHost()));
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("databasePort", om.valueToTree(this.getDatabasePort()));
                data.set("dbInstanceIdentifier", om.valueToTree(this.getDbInstanceIdentifier()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("secretManagerArn", om.valueToTree(this.getSecretManagerArn()));
                data.set("tableName", om.valueToTree(this.getTableName()));
                data.set("vpcConfiguration", om.valueToTree(this.getVpcConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.RDSSourceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RDSSourceConfigProperty.Jsii$Proxy that = (RDSSourceConfigProperty.Jsii$Proxy) o;

                if (!databaseHost.equals(that.databaseHost)) return false;
                if (!databaseName.equals(that.databaseName)) return false;
                if (!databasePort.equals(that.databasePort)) return false;
                if (!dbInstanceIdentifier.equals(that.dbInstanceIdentifier)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!secretManagerArn.equals(that.secretManagerArn)) return false;
                if (!tableName.equals(that.tableName)) return false;
                return this.vpcConfiguration.equals(that.vpcConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.databaseHost.hashCode();
                result = 31 * result + (this.databaseName.hashCode());
                result = 31 * result + (this.databasePort.hashCode());
                result = 31 * result + (this.dbInstanceIdentifier.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.secretManagerArn.hashCode());
                result = 31 * result + (this.tableName.hashCode());
                result = 31 * result + (this.vpcConfiguration.hashCode());
                return result;
            }
        }
    }
    /**
     * Provides information about the Amazon Redshift database configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lookoutmetrics.*;
     * RedshiftSourceConfigProperty redshiftSourceConfigProperty = RedshiftSourceConfigProperty.builder()
     *         .clusterIdentifier("clusterIdentifier")
     *         .databaseHost("databaseHost")
     *         .databaseName("databaseName")
     *         .databasePort(123)
     *         .roleArn("roleArn")
     *         .secretManagerArn("secretManagerArn")
     *         .tableName("tableName")
     *         .vpcConfiguration(VpcConfigurationProperty.builder()
     *                 .securityGroupIdList(List.of("securityGroupIdList"))
     *                 .subnetIdList(List.of("subnetIdList"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.RedshiftSourceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftSourceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftSourceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A string identifying the Redshift cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-clusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-clusteridentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier();

        /**
         * The name of the database host.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-databasehost">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-databasehost</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseHost();

        /**
         * The Redshift database name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * The port number where the database can be accessed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-databaseport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-databaseport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDatabasePort();

        /**
         * The Amazon Resource Name (ARN) of the role providing access to the database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-secretmanagerarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-secretmanagerarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretManagerArn();

        /**
         * The table name of the Redshift database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * Contains information about the Amazon Virtual Private Cloud (VPC) configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-vpcconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-redshiftsourceconfig.html#cfn-lookoutmetrics-anomalydetector-redshiftsourceconfig-vpcconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVpcConfiguration();

        /**
         * @return a {@link Builder} of {@link RedshiftSourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftSourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftSourceConfigProperty> {
            java.lang.String clusterIdentifier;
            java.lang.String databaseHost;
            java.lang.String databaseName;
            java.lang.Number databasePort;
            java.lang.String roleArn;
            java.lang.String secretManagerArn;
            java.lang.String tableName;
            java.lang.Object vpcConfiguration;

            /**
             * Sets the value of {@link RedshiftSourceConfigProperty#getClusterIdentifier}
             * @param clusterIdentifier A string identifying the Redshift cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
                this.clusterIdentifier = clusterIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSourceConfigProperty#getDatabaseHost}
             * @param databaseHost The name of the database host. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseHost(java.lang.String databaseHost) {
                this.databaseHost = databaseHost;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSourceConfigProperty#getDatabaseName}
             * @param databaseName The Redshift database name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSourceConfigProperty#getDatabasePort}
             * @param databasePort The port number where the database can be accessed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databasePort(java.lang.Number databasePort) {
                this.databasePort = databasePort;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSourceConfigProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the role providing access to the database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSourceConfigProperty#getSecretManagerArn}
             * @param secretManagerArn The Amazon Resource Name (ARN) of the AWS Secrets Manager role. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretManagerArn(java.lang.String secretManagerArn) {
                this.secretManagerArn = secretManagerArn;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSourceConfigProperty#getTableName}
             * @param tableName The table name of the Redshift database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSourceConfigProperty#getVpcConfiguration}
             * @param vpcConfiguration Contains information about the Amazon Virtual Private Cloud (VPC) configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftSourceConfigProperty#getVpcConfiguration}
             * @param vpcConfiguration Contains information about the Amazon Virtual Private Cloud (VPC) configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.VpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftSourceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftSourceConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftSourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftSourceConfigProperty {
            private final java.lang.String clusterIdentifier;
            private final java.lang.String databaseHost;
            private final java.lang.String databaseName;
            private final java.lang.Number databasePort;
            private final java.lang.String roleArn;
            private final java.lang.String secretManagerArn;
            private final java.lang.String tableName;
            private final java.lang.Object vpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseHost = software.amazon.jsii.Kernel.get(this, "databaseHost", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databasePort = software.amazon.jsii.Kernel.get(this, "databasePort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretManagerArn = software.amazon.jsii.Kernel.get(this, "secretManagerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcConfiguration = software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterIdentifier = java.util.Objects.requireNonNull(builder.clusterIdentifier, "clusterIdentifier is required");
                this.databaseHost = java.util.Objects.requireNonNull(builder.databaseHost, "databaseHost is required");
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.databasePort = java.util.Objects.requireNonNull(builder.databasePort, "databasePort is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.secretManagerArn = java.util.Objects.requireNonNull(builder.secretManagerArn, "secretManagerArn is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
                this.vpcConfiguration = java.util.Objects.requireNonNull(builder.vpcConfiguration, "vpcConfiguration is required");
            }

            @Override
            public final java.lang.String getClusterIdentifier() {
                return this.clusterIdentifier;
            }

            @Override
            public final java.lang.String getDatabaseHost() {
                return this.databaseHost;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.Number getDatabasePort() {
                return this.databasePort;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getSecretManagerArn() {
                return this.secretManagerArn;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.Object getVpcConfiguration() {
                return this.vpcConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));
                data.set("databaseHost", om.valueToTree(this.getDatabaseHost()));
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("databasePort", om.valueToTree(this.getDatabasePort()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("secretManagerArn", om.valueToTree(this.getSecretManagerArn()));
                data.set("tableName", om.valueToTree(this.getTableName()));
                data.set("vpcConfiguration", om.valueToTree(this.getVpcConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.RedshiftSourceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftSourceConfigProperty.Jsii$Proxy that = (RedshiftSourceConfigProperty.Jsii$Proxy) o;

                if (!clusterIdentifier.equals(that.clusterIdentifier)) return false;
                if (!databaseHost.equals(that.databaseHost)) return false;
                if (!databaseName.equals(that.databaseName)) return false;
                if (!databasePort.equals(that.databasePort)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!secretManagerArn.equals(that.secretManagerArn)) return false;
                if (!tableName.equals(that.tableName)) return false;
                return this.vpcConfiguration.equals(that.vpcConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.clusterIdentifier.hashCode();
                result = 31 * result + (this.databaseHost.hashCode());
                result = 31 * result + (this.databaseName.hashCode());
                result = 31 * result + (this.databasePort.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.secretManagerArn.hashCode());
                result = 31 * result + (this.tableName.hashCode());
                result = 31 * result + (this.vpcConfiguration.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains information about the configuration of the S3 bucket that contains source files.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lookoutmetrics.*;
     * S3SourceConfigProperty s3SourceConfigProperty = S3SourceConfigProperty.builder()
     *         .fileFormatDescriptor(FileFormatDescriptorProperty.builder()
     *                 .csvFormatDescriptor(CsvFormatDescriptorProperty.builder()
     *                         .charset("charset")
     *                         .containsHeader(false)
     *                         .delimiter("delimiter")
     *                         .fileCompression("fileCompression")
     *                         .headerList(List.of("headerList"))
     *                         .quoteSymbol("quoteSymbol")
     *                         .build())
     *                 .jsonFormatDescriptor(JsonFormatDescriptorProperty.builder()
     *                         .charset("charset")
     *                         .fileCompression("fileCompression")
     *                         .build())
     *                 .build())
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .historicalDataPathList(List.of("historicalDataPathList"))
     *         .templatedPathList(List.of("templatedPathList"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-s3sourceconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-s3sourceconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.S3SourceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3SourceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3SourceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains information about a source file's formatting.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-s3sourceconfig.html#cfn-lookoutmetrics-anomalydetector-s3sourceconfig-fileformatdescriptor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-s3sourceconfig.html#cfn-lookoutmetrics-anomalydetector-s3sourceconfig-fileformatdescriptor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFileFormatDescriptor();

        /**
         * The ARN of an IAM role that has read and write access permissions to the source S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-s3sourceconfig.html#cfn-lookoutmetrics-anomalydetector-s3sourceconfig-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-s3sourceconfig.html#cfn-lookoutmetrics-anomalydetector-s3sourceconfig-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * A list of paths to the historical data files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-s3sourceconfig.html#cfn-lookoutmetrics-anomalydetector-s3sourceconfig-historicaldatapathlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-s3sourceconfig.html#cfn-lookoutmetrics-anomalydetector-s3sourceconfig-historicaldatapathlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHistoricalDataPathList() {
            return null;
        }

        /**
         * A list of templated paths to the source files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-s3sourceconfig.html#cfn-lookoutmetrics-anomalydetector-s3sourceconfig-templatedpathlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-s3sourceconfig.html#cfn-lookoutmetrics-anomalydetector-s3sourceconfig-templatedpathlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTemplatedPathList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3SourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3SourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3SourceConfigProperty> {
            java.lang.Object fileFormatDescriptor;
            java.lang.String roleArn;
            java.util.List<java.lang.String> historicalDataPathList;
            java.util.List<java.lang.String> templatedPathList;

            /**
             * Sets the value of {@link S3SourceConfigProperty#getFileFormatDescriptor}
             * @param fileFormatDescriptor Contains information about a source file's formatting. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileFormatDescriptor(software.amazon.awscdk.IResolvable fileFormatDescriptor) {
                this.fileFormatDescriptor = fileFormatDescriptor;
                return this;
            }

            /**
             * Sets the value of {@link S3SourceConfigProperty#getFileFormatDescriptor}
             * @param fileFormatDescriptor Contains information about a source file's formatting. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileFormatDescriptor(software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.FileFormatDescriptorProperty fileFormatDescriptor) {
                this.fileFormatDescriptor = fileFormatDescriptor;
                return this;
            }

            /**
             * Sets the value of {@link S3SourceConfigProperty#getRoleArn}
             * @param roleArn The ARN of an IAM role that has read and write access permissions to the source S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link S3SourceConfigProperty#getHistoricalDataPathList}
             * @param historicalDataPathList A list of paths to the historical data files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder historicalDataPathList(java.util.List<java.lang.String> historicalDataPathList) {
                this.historicalDataPathList = historicalDataPathList;
                return this;
            }

            /**
             * Sets the value of {@link S3SourceConfigProperty#getTemplatedPathList}
             * @param templatedPathList A list of templated paths to the source files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templatedPathList(java.util.List<java.lang.String> templatedPathList) {
                this.templatedPathList = templatedPathList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3SourceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3SourceConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3SourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3SourceConfigProperty {
            private final java.lang.Object fileFormatDescriptor;
            private final java.lang.String roleArn;
            private final java.util.List<java.lang.String> historicalDataPathList;
            private final java.util.List<java.lang.String> templatedPathList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fileFormatDescriptor = software.amazon.jsii.Kernel.get(this, "fileFormatDescriptor", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.historicalDataPathList = software.amazon.jsii.Kernel.get(this, "historicalDataPathList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.templatedPathList = software.amazon.jsii.Kernel.get(this, "templatedPathList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fileFormatDescriptor = java.util.Objects.requireNonNull(builder.fileFormatDescriptor, "fileFormatDescriptor is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.historicalDataPathList = builder.historicalDataPathList;
                this.templatedPathList = builder.templatedPathList;
            }

            @Override
            public final java.lang.Object getFileFormatDescriptor() {
                return this.fileFormatDescriptor;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.util.List<java.lang.String> getHistoricalDataPathList() {
                return this.historicalDataPathList;
            }

            @Override
            public final java.util.List<java.lang.String> getTemplatedPathList() {
                return this.templatedPathList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fileFormatDescriptor", om.valueToTree(this.getFileFormatDescriptor()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getHistoricalDataPathList() != null) {
                    data.set("historicalDataPathList", om.valueToTree(this.getHistoricalDataPathList()));
                }
                if (this.getTemplatedPathList() != null) {
                    data.set("templatedPathList", om.valueToTree(this.getTemplatedPathList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.S3SourceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3SourceConfigProperty.Jsii$Proxy that = (S3SourceConfigProperty.Jsii$Proxy) o;

                if (!fileFormatDescriptor.equals(that.fileFormatDescriptor)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (this.historicalDataPathList != null ? !this.historicalDataPathList.equals(that.historicalDataPathList) : that.historicalDataPathList != null) return false;
                return this.templatedPathList != null ? this.templatedPathList.equals(that.templatedPathList) : that.templatedPathList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fileFormatDescriptor.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.historicalDataPathList != null ? this.historicalDataPathList.hashCode() : 0);
                result = 31 * result + (this.templatedPathList != null ? this.templatedPathList.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about the column used to track time in a source data file.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lookoutmetrics.*;
     * TimestampColumnProperty timestampColumnProperty = TimestampColumnProperty.builder()
     *         .columnFormat("columnFormat")
     *         .columnName("columnName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-timestampcolumn.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-timestampcolumn.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.TimestampColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(TimestampColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimestampColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The format of the timestamp column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-timestampcolumn.html#cfn-lookoutmetrics-anomalydetector-timestampcolumn-columnformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-timestampcolumn.html#cfn-lookoutmetrics-anomalydetector-timestampcolumn-columnformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColumnFormat() {
            return null;
        }

        /**
         * The name of the timestamp column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-timestampcolumn.html#cfn-lookoutmetrics-anomalydetector-timestampcolumn-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-timestampcolumn.html#cfn-lookoutmetrics-anomalydetector-timestampcolumn-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColumnName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TimestampColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimestampColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimestampColumnProperty> {
            java.lang.String columnFormat;
            java.lang.String columnName;

            /**
             * Sets the value of {@link TimestampColumnProperty#getColumnFormat}
             * @param columnFormat The format of the timestamp column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnFormat(java.lang.String columnFormat) {
                this.columnFormat = columnFormat;
                return this;
            }

            /**
             * Sets the value of {@link TimestampColumnProperty#getColumnName}
             * @param columnName The name of the timestamp column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimestampColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimestampColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimestampColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimestampColumnProperty {
            private final java.lang.String columnFormat;
            private final java.lang.String columnName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnFormat = software.amazon.jsii.Kernel.get(this, "columnFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnFormat = builder.columnFormat;
                this.columnName = builder.columnName;
            }

            @Override
            public final java.lang.String getColumnFormat() {
                return this.columnFormat;
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnFormat() != null) {
                    data.set("columnFormat", om.valueToTree(this.getColumnFormat()));
                }
                if (this.getColumnName() != null) {
                    data.set("columnName", om.valueToTree(this.getColumnName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.TimestampColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimestampColumnProperty.Jsii$Proxy that = (TimestampColumnProperty.Jsii$Proxy) o;

                if (this.columnFormat != null ? !this.columnFormat.equals(that.columnFormat) : that.columnFormat != null) return false;
                return this.columnName != null ? this.columnName.equals(that.columnName) : that.columnName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnFormat != null ? this.columnFormat.hashCode() : 0;
                result = 31 * result + (this.columnName != null ? this.columnName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configuration information about the Amazon Virtual Private Cloud (VPC).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lookoutmetrics.*;
     * VpcConfigurationProperty vpcConfigurationProperty = VpcConfigurationProperty.builder()
     *         .securityGroupIdList(List.of("securityGroupIdList"))
     *         .subnetIdList(List.of("subnetIdList"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-vpcconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-vpcconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.VpcConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of strings containing the list of security groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-vpcconfiguration.html#cfn-lookoutmetrics-anomalydetector-vpcconfiguration-securitygroupidlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-vpcconfiguration.html#cfn-lookoutmetrics-anomalydetector-vpcconfiguration-securitygroupidlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIdList();

        /**
         * An array of strings containing the Amazon VPC subnet IDs (e.g., <code>subnet-0bb1c79de3EXAMPLE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-vpcconfiguration.html#cfn-lookoutmetrics-anomalydetector-vpcconfiguration-subnetidlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lookoutmetrics-anomalydetector-vpcconfiguration.html#cfn-lookoutmetrics-anomalydetector-vpcconfiguration-subnetidlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIdList();

        /**
         * @return a {@link Builder} of {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigurationProperty> {
            java.util.List<java.lang.String> securityGroupIdList;
            java.util.List<java.lang.String> subnetIdList;

            /**
             * Sets the value of {@link VpcConfigurationProperty#getSecurityGroupIdList}
             * @param securityGroupIdList An array of strings containing the list of security groups. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIdList(java.util.List<java.lang.String> securityGroupIdList) {
                this.securityGroupIdList = securityGroupIdList;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigurationProperty#getSubnetIdList}
             * @param subnetIdList An array of strings containing the Amazon VPC subnet IDs (e.g., <code>subnet-0bb1c79de3EXAMPLE</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIdList(java.util.List<java.lang.String> subnetIdList) {
                this.subnetIdList = subnetIdList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigurationProperty {
            private final java.util.List<java.lang.String> securityGroupIdList;
            private final java.util.List<java.lang.String> subnetIdList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIdList = software.amazon.jsii.Kernel.get(this, "securityGroupIdList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIdList = software.amazon.jsii.Kernel.get(this, "subnetIdList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIdList = java.util.Objects.requireNonNull(builder.securityGroupIdList, "securityGroupIdList is required");
                this.subnetIdList = java.util.Objects.requireNonNull(builder.subnetIdList, "subnetIdList is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIdList() {
                return this.securityGroupIdList;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIdList() {
                return this.subnetIdList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIdList", om.valueToTree(this.getSecurityGroupIdList()));
                data.set("subnetIdList", om.valueToTree(this.getSubnetIdList()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lookoutmetrics.CfnAnomalyDetector.VpcConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigurationProperty.Jsii$Proxy that = (VpcConfigurationProperty.Jsii$Proxy) o;

                if (!securityGroupIdList.equals(that.securityGroupIdList)) return false;
                return this.subnetIdList.equals(that.subnetIdList);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIdList.hashCode();
                result = 31 * result + (this.subnetIdList.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetectorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetectorProps.Builder();
        }

        /**
         * Contains information about the configuration of the anomaly detector.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-anomalydetectorconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-anomalydetectorconfig</a>
         * @param anomalyDetectorConfig Contains information about the configuration of the anomaly detector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder anomalyDetectorConfig(final software.amazon.awscdk.IResolvable anomalyDetectorConfig) {
            this.props.anomalyDetectorConfig(anomalyDetectorConfig);
            return this;
        }
        /**
         * Contains information about the configuration of the anomaly detector.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-anomalydetectorconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-anomalydetectorconfig</a>
         * @param anomalyDetectorConfig Contains information about the configuration of the anomaly detector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder anomalyDetectorConfig(final software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector.AnomalyDetectorConfigProperty anomalyDetectorConfig) {
            this.props.anomalyDetectorConfig(anomalyDetectorConfig);
            return this;
        }

        /**
         * The detector's dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-metricsetlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-metricsetlist</a>
         * @param metricSetList The detector's dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricSetList(final software.amazon.awscdk.IResolvable metricSetList) {
            this.props.metricSetList(metricSetList);
            return this;
        }
        /**
         * The detector's dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-metricsetlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-metricsetlist</a>
         * @param metricSetList The detector's dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricSetList(final java.util.List<? extends java.lang.Object> metricSetList) {
            this.props.metricSetList(metricSetList);
            return this;
        }

        /**
         * A description of the detector.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-anomalydetectordescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-anomalydetectordescription</a>
         * @param anomalyDetectorDescription A description of the detector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder anomalyDetectorDescription(final java.lang.String anomalyDetectorDescription) {
            this.props.anomalyDetectorDescription(anomalyDetectorDescription);
            return this;
        }

        /**
         * The name of the detector.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-anomalydetectorname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-anomalydetectorname</a>
         * @param anomalyDetectorName The name of the detector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder anomalyDetectorName(final java.lang.String anomalyDetectorName) {
            this.props.anomalyDetectorName(anomalyDetectorName);
            return this;
        }

        /**
         * The ARN of the KMS key to use to encrypt your data.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutmetrics-anomalydetector.html#cfn-lookoutmetrics-anomalydetector-kmskeyarn</a>
         * @param kmsKeyArn The ARN of the KMS key to use to encrypt your data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(final java.lang.String kmsKeyArn) {
            this.props.kmsKeyArn(kmsKeyArn);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector build() {
            return new software.amazon.awscdk.services.lookoutmetrics.CfnAnomalyDetector(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
