package software.amazon.awscdk.services.omics;

/**
 * Creates a new workflow version for the workflow that you specify with the <code>workflowId</code> parameter.
 * <p>
 * When you create a new version of a workflow, you need to specify the configuration for the new version. It doesn't inherit any configuration values from the workflow.
 * <p>
 * Provide a version name that is unique for this workflow. You cannot change the name after HealthOmics creates the version.
 * <p>
 * <blockquote>
 * <p>
 * Don’t include any personally identifiable information (PII) in the version name. Version names appear in the workflow version ARN.
 * <p>
 * </blockquote>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow versioning in AWS HealthOmics</a> in the AWS HealthOmics User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.omics.*;
 * CfnWorkflowVersion cfnWorkflowVersion = CfnWorkflowVersion.Builder.create(this, "MyCfnWorkflowVersion")
 *         .versionName("versionName")
 *         .workflowId("workflowId")
 *         // the properties below are optional
 *         .accelerators("accelerators")
 *         .definitionUri("definitionUri")
 *         .description("description")
 *         .engine("engine")
 *         .main("main")
 *         .parameterTemplate(Map.of(
 *                 "parameterTemplateKey", WorkflowParameterProperty.builder()
 *                         .description("description")
 *                         .optional(false)
 *                         .build()))
 *         .storageCapacity(123)
 *         .storageType("storageType")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .workflowBucketOwnerId("workflowBucketOwnerId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:11.734Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_omics.CfnWorkflowVersion")
public class CfnWorkflowVersion extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnWorkflowVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkflowVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.omics.CfnWorkflowVersion.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWorkflowVersion(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.omics.CfnWorkflowVersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * ARN of the workflow version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The creation time of the workflow version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the workflow version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the workflow version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrType() {
        return software.amazon.jsii.Kernel.get(this, "attrType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUuid() {
        return software.amazon.jsii.Kernel.get(this, "attrUuid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the workflow version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersionName() {
        return software.amazon.jsii.Kernel.get(this, "versionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the workflow version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersionName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "versionName", java.util.Objects.requireNonNull(value, "versionName is required"));
    }

    /**
     * The workflow's ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getWorkflowId() {
        return software.amazon.jsii.Kernel.get(this, "workflowId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The workflow's ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkflowId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "workflowId", java.util.Objects.requireNonNull(value, "workflowId is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAccelerators() {
        return software.amazon.jsii.Kernel.get(this, "accelerators", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccelerators(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "accelerators", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefinitionUri() {
        return software.amazon.jsii.Kernel.get(this, "definitionUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "definitionUri", value);
    }

    /**
     * The description of the workflow version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the workflow version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngine(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engine", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMain() {
        return software.amazon.jsii.Kernel.get(this, "main", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMain(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "main", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameterTemplate() {
        return software.amazon.jsii.Kernel.get(this, "parameterTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameterTemplate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "parameterTemplate", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameterTemplate(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.omics.CfnWorkflowVersion.WorkflowParameterProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.omics.CfnWorkflowVersion.WorkflowParameterProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "parameterTemplate", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getStorageCapacity() {
        return software.amazon.jsii.Kernel.get(this, "storageCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "storageCapacity", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStorageType() {
        return software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "storageType", value);
    }

    /**
     * A map of resource tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * A map of resource tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getWorkflowBucketOwnerId() {
        return software.amazon.jsii.Kernel.get(this, "workflowBucketOwnerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkflowBucketOwnerId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "workflowBucketOwnerId", value);
    }
    /**
     * A workflow parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.omics.*;
     * WorkflowParameterProperty workflowParameterProperty = WorkflowParameterProperty.builder()
     *         .description("description")
     *         .optional(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflowversion-workflowparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflowversion-workflowparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_omics.CfnWorkflowVersion.WorkflowParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkflowParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkflowParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parameter's description.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflowversion-workflowparameter.html#cfn-omics-workflowversion-workflowparameter-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflowversion-workflowparameter.html#cfn-omics-workflowversion-workflowparameter-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Whether the parameter is optional.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflowversion-workflowparameter.html#cfn-omics-workflowversion-workflowparameter-optional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-omics-workflowversion-workflowparameter.html#cfn-omics-workflowversion-workflowparameter-optional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOptional() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkflowParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkflowParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkflowParameterProperty> {
            java.lang.String description;
            java.lang.Object optional;

            /**
             * Sets the value of {@link WorkflowParameterProperty#getDescription}
             * @param description The parameter's description.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowParameterProperty#getOptional}
             * @param optional Whether the parameter is optional.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optional(java.lang.Boolean optional) {
                this.optional = optional;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowParameterProperty#getOptional}
             * @param optional Whether the parameter is optional.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optional(software.amazon.awscdk.IResolvable optional) {
                this.optional = optional;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkflowParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkflowParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkflowParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkflowParameterProperty {
            private final java.lang.String description;
            private final java.lang.Object optional;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.optional = software.amazon.jsii.Kernel.get(this, "optional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.description = builder.description;
                this.optional = builder.optional;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getOptional() {
                return this.optional;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getOptional() != null) {
                    data.set("optional", om.valueToTree(this.getOptional()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_omics.CfnWorkflowVersion.WorkflowParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkflowParameterProperty.Jsii$Proxy that = (WorkflowParameterProperty.Jsii$Proxy) o;

                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                return this.optional != null ? this.optional.equals(that.optional) : that.optional == null;
            }

            @Override
            public final int hashCode() {
                int result = this.description != null ? this.description.hashCode() : 0;
                result = 31 * result + (this.optional != null ? this.optional.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.omics.CfnWorkflowVersion}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.omics.CfnWorkflowVersion> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.omics.CfnWorkflowVersionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.omics.CfnWorkflowVersionProps.Builder();
        }

        /**
         * The name of the workflow version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-versionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-versionname</a>
         * @param versionName The name of the workflow version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionName(final java.lang.String versionName) {
            this.props.versionName(versionName);
            return this;
        }

        /**
         * The workflow's ID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-workflowid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-workflowid</a>
         * @param workflowId The workflow's ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflowId(final java.lang.String workflowId) {
            this.props.workflowId(workflowId);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-accelerators">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-accelerators</a>
         * @param accelerators This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accelerators(final java.lang.String accelerators) {
            this.props.accelerators(accelerators);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-definitionuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-definitionuri</a>
         * @param definitionUri This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionUri(final java.lang.String definitionUri) {
            this.props.definitionUri(definitionUri);
            return this;
        }

        /**
         * The description of the workflow version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-description</a>
         * @param description The description of the workflow version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-engine</a>
         * @param engine This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final java.lang.String engine) {
            this.props.engine(engine);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-main">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-main</a>
         * @param main This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder main(final java.lang.String main) {
            this.props.main(main);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-parametertemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-parametertemplate</a>
         * @param parameterTemplate This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterTemplate(final software.amazon.awscdk.IResolvable parameterTemplate) {
            this.props.parameterTemplate(parameterTemplate);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-parametertemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-parametertemplate</a>
         * @param parameterTemplate This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterTemplate(final java.util.Map<java.lang.String, ? extends java.lang.Object> parameterTemplate) {
            this.props.parameterTemplate(parameterTemplate);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-storagecapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-storagecapacity</a>
         * @param storageCapacity This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageCapacity(final java.lang.Number storageCapacity) {
            this.props.storageCapacity(storageCapacity);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-storagetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-storagetype</a>
         * @param storageType This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(final java.lang.String storageType) {
            this.props.storageType(storageType);
            return this;
        }

        /**
         * A map of resource tags.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-tags</a>
         * @param tags A map of resource tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-workflowbucketownerid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-omics-workflowversion.html#cfn-omics-workflowversion-workflowbucketownerid</a>
         * @param workflowBucketOwnerId This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflowBucketOwnerId(final java.lang.String workflowBucketOwnerId) {
            this.props.workflowBucketOwnerId(workflowBucketOwnerId);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.omics.CfnWorkflowVersion}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.omics.CfnWorkflowVersion build() {
            return new software.amazon.awscdk.services.omics.CfnWorkflowVersion(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
