package software.amazon.awscdk.services.pinpointemail;

/**
 * Specifies an identity to use for sending email through Amazon Pinpoint.
 * <p>
 * In Amazon Pinpoint, an <em>identity</em> is an email address or domain that you use when you send email. Before you can use Amazon Pinpoint to send an email from an identity, you first have to verify it. By verifying an identity, you demonstrate that you're the owner of the address or domain, and that you've given Amazon Pinpoint permission to send email from that identity.
 * <p>
 * When you verify an email address, Amazon Pinpoint sends an email to the address. Your email address is verified as soon as you follow the link in the verification email.
 * <p>
 * When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens. You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon Pinpoint detects these records in the DNS configuration for your domain. It usually takes around 72 hours to complete the domain verification process.
 * <p>
 * <blockquote>
 * <p>
 * When you use CloudFormation to specify an identity, CloudFormation might indicate that the identity was created successfully. However, you have to verify the identity before you can use it to send email.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpointemail.*;
 * CfnIdentity cfnIdentity = CfnIdentity.Builder.create(this, "MyCfnIdentity")
 *         .name("name")
 *         // the properties below are optional
 *         .dkimSigningEnabled(false)
 *         .feedbackForwardingEnabled(false)
 *         .mailFromAttributes(MailFromAttributesProperty.builder()
 *                 .behaviorOnMxFailure("behaviorOnMxFailure")
 *                 .mailFromDomain("mailFromDomain")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:12.160Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpointemail.CfnIdentity")
public class CfnIdentity extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnIdentity(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIdentity(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.pinpointemail.CfnIdentity.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIdentity(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.pinpointemail.CfnIdentityProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The host name for the first token that you have to add to the DNS configuration for your domain.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-email-manage-verify.html#channels-email-manage-verify-domain">Verifying a Domain</a> in the Amazon Pinpoint User Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentityDnsRecordName1() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentityDnsRecordName1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The host name for the second token that you have to add to the DNS configuration for your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentityDnsRecordName2() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentityDnsRecordName2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The host name for the third token that you have to add to the DNS configuration for your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentityDnsRecordName3() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentityDnsRecordName3", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The record value for the first token that you have to add to the DNS configuration for your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentityDnsRecordValue1() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentityDnsRecordValue1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The record value for the second token that you have to add to the DNS configuration for your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentityDnsRecordValue2() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentityDnsRecordValue2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The record value for the third token that you have to add to the DNS configuration for your domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentityDnsRecordValue3() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentityDnsRecordValue3", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The address or domain of the identity, such as <em>sender&#64;example.com</em> or <em>example.co.uk</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The address or domain of the identity, such as <em>sender&#64;example.com</em> or <em>example.co.uk</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * For domain identities, this attribute is used to enable or disable DomainKeys Identified Mail (DKIM) signing for the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDkimSigningEnabled() {
        return software.amazon.jsii.Kernel.get(this, "dkimSigningEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * For domain identities, this attribute is used to enable or disable DomainKeys Identified Mail (DKIM) signing for the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDkimSigningEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "dkimSigningEnabled", value);
    }

    /**
     * For domain identities, this attribute is used to enable or disable DomainKeys Identified Mail (DKIM) signing for the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDkimSigningEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dkimSigningEnabled", value);
    }

    /**
     * Used to enable or disable feedback forwarding for an identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFeedbackForwardingEnabled() {
        return software.amazon.jsii.Kernel.get(this, "feedbackForwardingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Used to enable or disable feedback forwarding for an identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFeedbackForwardingEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "feedbackForwardingEnabled", value);
    }

    /**
     * Used to enable or disable feedback forwarding for an identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFeedbackForwardingEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "feedbackForwardingEnabled", value);
    }

    /**
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMailFromAttributes() {
        return software.amazon.jsii.Kernel.get(this, "mailFromAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMailFromAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mailFromAttributes", value);
    }

    /**
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMailFromAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpointemail.CfnIdentity.MailFromAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "mailFromAttributes", value);
    }

    /**
     * An object that defines the tags (keys and values) that you want to associate with the email identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An object that defines the tags (keys and values) that you want to associate with the email identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * A list of attributes that are associated with a MAIL FROM domain.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpointemail.*;
     * MailFromAttributesProperty mailFromAttributesProperty = MailFromAttributesProperty.builder()
     *         .behaviorOnMxFailure("behaviorOnMxFailure")
     *         .mailFromDomain("mailFromDomain")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpointemail-identity-mailfromattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpointemail-identity-mailfromattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpointemail.CfnIdentity.MailFromAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(MailFromAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MailFromAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action that Amazon Pinpoint to takes if it can't read the required MX record for a custom MAIL FROM domain.
         * <p>
         * When you set this value to <code>UseDefaultValue</code> , Amazon Pinpoint uses <em>amazonses.com</em> as the MAIL FROM domain. When you set this value to <code>RejectMessage</code> , Amazon Pinpoint returns a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.
         * <p>
         * These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code> , <code>Failed</code> , and <code>TemporaryFailure</code> states.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpointemail-identity-mailfromattributes.html#cfn-pinpointemail-identity-mailfromattributes-behavioronmxfailure">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpointemail-identity-mailfromattributes.html#cfn-pinpointemail-identity-mailfromattributes-behavioronmxfailure</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBehaviorOnMxFailure() {
            return null;
        }

        /**
         * The name of a domain that an email identity uses as a custom MAIL FROM domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpointemail-identity-mailfromattributes.html#cfn-pinpointemail-identity-mailfromattributes-mailfromdomain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpointemail-identity-mailfromattributes.html#cfn-pinpointemail-identity-mailfromattributes-mailfromdomain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMailFromDomain() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MailFromAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MailFromAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MailFromAttributesProperty> {
            java.lang.String behaviorOnMxFailure;
            java.lang.String mailFromDomain;

            /**
             * Sets the value of {@link MailFromAttributesProperty#getBehaviorOnMxFailure}
             * @param behaviorOnMxFailure The action that Amazon Pinpoint to takes if it can't read the required MX record for a custom MAIL FROM domain.
             *                            When you set this value to <code>UseDefaultValue</code> , Amazon Pinpoint uses <em>amazonses.com</em> as the MAIL FROM domain. When you set this value to <code>RejectMessage</code> , Amazon Pinpoint returns a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.
             *                            <p>
             *                            These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code> , <code>Failed</code> , and <code>TemporaryFailure</code> states.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder behaviorOnMxFailure(java.lang.String behaviorOnMxFailure) {
                this.behaviorOnMxFailure = behaviorOnMxFailure;
                return this;
            }

            /**
             * Sets the value of {@link MailFromAttributesProperty#getMailFromDomain}
             * @param mailFromDomain The name of a domain that an email identity uses as a custom MAIL FROM domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailFromDomain(java.lang.String mailFromDomain) {
                this.mailFromDomain = mailFromDomain;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MailFromAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MailFromAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MailFromAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MailFromAttributesProperty {
            private final java.lang.String behaviorOnMxFailure;
            private final java.lang.String mailFromDomain;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.behaviorOnMxFailure = software.amazon.jsii.Kernel.get(this, "behaviorOnMxFailure", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mailFromDomain = software.amazon.jsii.Kernel.get(this, "mailFromDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.behaviorOnMxFailure = builder.behaviorOnMxFailure;
                this.mailFromDomain = builder.mailFromDomain;
            }

            @Override
            public final java.lang.String getBehaviorOnMxFailure() {
                return this.behaviorOnMxFailure;
            }

            @Override
            public final java.lang.String getMailFromDomain() {
                return this.mailFromDomain;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBehaviorOnMxFailure() != null) {
                    data.set("behaviorOnMxFailure", om.valueToTree(this.getBehaviorOnMxFailure()));
                }
                if (this.getMailFromDomain() != null) {
                    data.set("mailFromDomain", om.valueToTree(this.getMailFromDomain()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpointemail.CfnIdentity.MailFromAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MailFromAttributesProperty.Jsii$Proxy that = (MailFromAttributesProperty.Jsii$Proxy) o;

                if (this.behaviorOnMxFailure != null ? !this.behaviorOnMxFailure.equals(that.behaviorOnMxFailure) : that.behaviorOnMxFailure != null) return false;
                return this.mailFromDomain != null ? this.mailFromDomain.equals(that.mailFromDomain) : that.mailFromDomain == null;
            }

            @Override
            public final int hashCode() {
                int result = this.behaviorOnMxFailure != null ? this.behaviorOnMxFailure.hashCode() : 0;
                result = 31 * result + (this.mailFromDomain != null ? this.mailFromDomain.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.pinpointemail.CfnIdentity}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.pinpointemail.CfnIdentity> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.pinpointemail.CfnIdentityProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.pinpointemail.CfnIdentityProps.Builder();
        }

        /**
         * The address or domain of the identity, such as <em>sender&#64;example.com</em> or <em>example.co.uk</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html#cfn-pinpointemail-identity-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html#cfn-pinpointemail-identity-name</a>
         * @param name The address or domain of the identity, such as <em>sender&#64;example.com</em> or <em>example.co.uk</em> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * For domain identities, this attribute is used to enable or disable DomainKeys Identified Mail (DKIM) signing for the domain.
         * <p>
         * If the value is <code>true</code> , then the messages that you send from the domain are signed using both the DKIM keys for your domain, as well as the keys for the <code>amazonses.com</code> domain. If the value is <code>false</code> , then the messages that you send are only signed using the DKIM keys for the <code>amazonses.com</code> domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html#cfn-pinpointemail-identity-dkimsigningenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html#cfn-pinpointemail-identity-dkimsigningenabled</a>
         * @param dkimSigningEnabled For domain identities, this attribute is used to enable or disable DomainKeys Identified Mail (DKIM) signing for the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimSigningEnabled(final java.lang.Boolean dkimSigningEnabled) {
            this.props.dkimSigningEnabled(dkimSigningEnabled);
            return this;
        }
        /**
         * For domain identities, this attribute is used to enable or disable DomainKeys Identified Mail (DKIM) signing for the domain.
         * <p>
         * If the value is <code>true</code> , then the messages that you send from the domain are signed using both the DKIM keys for your domain, as well as the keys for the <code>amazonses.com</code> domain. If the value is <code>false</code> , then the messages that you send are only signed using the DKIM keys for the <code>amazonses.com</code> domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html#cfn-pinpointemail-identity-dkimsigningenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html#cfn-pinpointemail-identity-dkimsigningenabled</a>
         * @param dkimSigningEnabled For domain identities, this attribute is used to enable or disable DomainKeys Identified Mail (DKIM) signing for the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimSigningEnabled(final software.amazon.awscdk.IResolvable dkimSigningEnabled) {
            this.props.dkimSigningEnabled(dkimSigningEnabled);
            return this;
        }

        /**
         * Used to enable or disable feedback forwarding for an identity.
         * <p>
         * This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event.
         * <p>
         * When you enable feedback forwarding, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email.
         * <p>
         * When you disable feedback forwarding, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html#cfn-pinpointemail-identity-feedbackforwardingenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html#cfn-pinpointemail-identity-feedbackforwardingenabled</a>
         * @param feedbackForwardingEnabled Used to enable or disable feedback forwarding for an identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder feedbackForwardingEnabled(final java.lang.Boolean feedbackForwardingEnabled) {
            this.props.feedbackForwardingEnabled(feedbackForwardingEnabled);
            return this;
        }
        /**
         * Used to enable or disable feedback forwarding for an identity.
         * <p>
         * This setting determines what happens when an identity is used to send an email that results in a bounce or complaint event.
         * <p>
         * When you enable feedback forwarding, Amazon Pinpoint sends you email notifications when bounce or complaint events occur. Amazon Pinpoint sends this notification to the address that you specified in the Return-Path header of the original email.
         * <p>
         * When you disable feedback forwarding, Amazon Pinpoint sends notifications through other mechanisms, such as by notifying an Amazon SNS topic. You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for receiving bounce or complaint notifications, Amazon Pinpoint sends an email notification when these events occur (even if this setting is disabled).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html#cfn-pinpointemail-identity-feedbackforwardingenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html#cfn-pinpointemail-identity-feedbackforwardingenabled</a>
         * @param feedbackForwardingEnabled Used to enable or disable feedback forwarding for an identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder feedbackForwardingEnabled(final software.amazon.awscdk.IResolvable feedbackForwardingEnabled) {
            this.props.feedbackForwardingEnabled(feedbackForwardingEnabled);
            return this;
        }

        /**
         * Used to enable or disable the custom Mail-From domain configuration for an email identity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html#cfn-pinpointemail-identity-mailfromattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html#cfn-pinpointemail-identity-mailfromattributes</a>
         * @param mailFromAttributes Used to enable or disable the custom Mail-From domain configuration for an email identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mailFromAttributes(final software.amazon.awscdk.IResolvable mailFromAttributes) {
            this.props.mailFromAttributes(mailFromAttributes);
            return this;
        }
        /**
         * Used to enable or disable the custom Mail-From domain configuration for an email identity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html#cfn-pinpointemail-identity-mailfromattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html#cfn-pinpointemail-identity-mailfromattributes</a>
         * @param mailFromAttributes Used to enable or disable the custom Mail-From domain configuration for an email identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mailFromAttributes(final software.amazon.awscdk.services.pinpointemail.CfnIdentity.MailFromAttributesProperty mailFromAttributes) {
            this.props.mailFromAttributes(mailFromAttributes);
            return this;
        }

        /**
         * An object that defines the tags (keys and values) that you want to associate with the email identity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html#cfn-pinpointemail-identity-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpointemail-identity.html#cfn-pinpointemail-identity-tags</a>
         * @param tags An object that defines the tags (keys and values) that you want to associate with the email identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.pinpointemail.CfnIdentity}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.pinpointemail.CfnIdentity build() {
            return new software.amazon.awscdk.services.pinpointemail.CfnIdentity(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
