package software.amazon.awscdk.services.quicksight;

/**
 * Creates a dataset.
 * <p>
 * This operation doesn't support datasets that include uploaded files as a source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * Object tagRuleConfigurations;
 * CfnDataSet cfnDataSet = CfnDataSet.Builder.create(this, "MyCfnDataSet")
 *         .awsAccountId("awsAccountId")
 *         .columnGroups(List.of(ColumnGroupProperty.builder()
 *                 .geoSpatialColumnGroup(GeoSpatialColumnGroupProperty.builder()
 *                         .columns(List.of("columns"))
 *                         .name("name")
 *                         // the properties below are optional
 *                         .countryCode("countryCode")
 *                         .build())
 *                 .build()))
 *         .columnLevelPermissionRules(List.of(ColumnLevelPermissionRuleProperty.builder()
 *                 .columnNames(List.of("columnNames"))
 *                 .principals(List.of("principals"))
 *                 .build()))
 *         .dataSetId("dataSetId")
 *         .datasetParameters(List.of(DatasetParameterProperty.builder()
 *                 .dateTimeDatasetParameter(DateTimeDatasetParameterProperty.builder()
 *                         .id("id")
 *                         .name("name")
 *                         .valueType("valueType")
 *                         // the properties below are optional
 *                         .defaultValues(DateTimeDatasetParameterDefaultValuesProperty.builder()
 *                                 .staticValues(List.of("staticValues"))
 *                                 .build())
 *                         .timeGranularity("timeGranularity")
 *                         .build())
 *                 .decimalDatasetParameter(DecimalDatasetParameterProperty.builder()
 *                         .id("id")
 *                         .name("name")
 *                         .valueType("valueType")
 *                         // the properties below are optional
 *                         .defaultValues(DecimalDatasetParameterDefaultValuesProperty.builder()
 *                                 .staticValues(List.of(123))
 *                                 .build())
 *                         .build())
 *                 .integerDatasetParameter(IntegerDatasetParameterProperty.builder()
 *                         .id("id")
 *                         .name("name")
 *                         .valueType("valueType")
 *                         // the properties below are optional
 *                         .defaultValues(IntegerDatasetParameterDefaultValuesProperty.builder()
 *                                 .staticValues(List.of(123))
 *                                 .build())
 *                         .build())
 *                 .stringDatasetParameter(StringDatasetParameterProperty.builder()
 *                         .id("id")
 *                         .name("name")
 *                         .valueType("valueType")
 *                         // the properties below are optional
 *                         .defaultValues(StringDatasetParameterDefaultValuesProperty.builder()
 *                                 .staticValues(List.of("staticValues"))
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .dataSetRefreshProperties(DataSetRefreshPropertiesProperty.builder()
 *                 .failureConfiguration(RefreshFailureConfigurationProperty.builder()
 *                         .emailAlert(RefreshFailureEmailAlertProperty.builder()
 *                                 .alertStatus("alertStatus")
 *                                 .build())
 *                         .build())
 *                 .refreshConfiguration(RefreshConfigurationProperty.builder()
 *                         .incrementalRefresh(IncrementalRefreshProperty.builder()
 *                                 .lookbackWindow(LookbackWindowProperty.builder()
 *                                         .columnName("columnName")
 *                                         .size(123)
 *                                         .sizeUnit("sizeUnit")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .dataSetUsageConfiguration(DataSetUsageConfigurationProperty.builder()
 *                 .disableUseAsDirectQuerySource(false)
 *                 .disableUseAsImportedSource(false)
 *                 .build())
 *         .fieldFolders(Map.of(
 *                 "fieldFoldersKey", FieldFolderProperty.builder()
 *                         .columns(List.of("columns"))
 *                         .description("description")
 *                         .build()))
 *         .folderArns(List.of("folderArns"))
 *         .importMode("importMode")
 *         .ingestionWaitPolicy(IngestionWaitPolicyProperty.builder()
 *                 .ingestionWaitTimeInHours(123)
 *                 .waitForSpiceIngestion(false)
 *                 .build())
 *         .logicalTableMap(Map.of(
 *                 "logicalTableMapKey", LogicalTableProperty.builder()
 *                         .alias("alias")
 *                         // the properties below are optional
 *                         .dataTransforms(List.of(TransformOperationProperty.builder()
 *                                 .castColumnTypeOperation(CastColumnTypeOperationProperty.builder()
 *                                         .columnName("columnName")
 *                                         .newColumnType("newColumnType")
 *                                         // the properties below are optional
 *                                         .format("format")
 *                                         .subType("subType")
 *                                         .build())
 *                                 .createColumnsOperation(CreateColumnsOperationProperty.builder()
 *                                         .columns(List.of(CalculatedColumnProperty.builder()
 *                                                 .columnId("columnId")
 *                                                 .columnName("columnName")
 *                                                 .expression("expression")
 *                                                 .build()))
 *                                         .build())
 *                                 .filterOperation(FilterOperationProperty.builder()
 *                                         .conditionExpression("conditionExpression")
 *                                         .build())
 *                                 .overrideDatasetParameterOperation(OverrideDatasetParameterOperationProperty.builder()
 *                                         .parameterName("parameterName")
 *                                         // the properties below are optional
 *                                         .newDefaultValues(NewDefaultValuesProperty.builder()
 *                                                 .dateTimeStaticValues(List.of("dateTimeStaticValues"))
 *                                                 .decimalStaticValues(List.of(123))
 *                                                 .integerStaticValues(List.of(123))
 *                                                 .stringStaticValues(List.of("stringStaticValues"))
 *                                                 .build())
 *                                         .newParameterName("newParameterName")
 *                                         .build())
 *                                 .projectOperation(ProjectOperationProperty.builder()
 *                                         .projectedColumns(List.of("projectedColumns"))
 *                                         .build())
 *                                 .renameColumnOperation(RenameColumnOperationProperty.builder()
 *                                         .columnName("columnName")
 *                                         // the properties below are optional
 *                                         .newColumnName("newColumnName")
 *                                         .build())
 *                                 .tagColumnOperation(TagColumnOperationProperty.builder()
 *                                         .columnName("columnName")
 *                                         .tags(List.of(ColumnTagProperty.builder()
 *                                                 .columnDescription(ColumnDescriptionProperty.builder()
 *                                                         .text("text")
 *                                                         .build())
 *                                                 .columnGeographicRole("columnGeographicRole")
 *                                                 .build()))
 *                                         .build())
 *                                 .untagColumnOperation(UntagColumnOperationProperty.builder()
 *                                         .columnName("columnName")
 *                                         .tagNames(List.of("tagNames"))
 *                                         .build())
 *                                 .build()))
 *                         .source(LogicalTableSourceProperty.builder()
 *                                 .dataSetArn("dataSetArn")
 *                                 .joinInstruction(JoinInstructionProperty.builder()
 *                                         .leftOperand("leftOperand")
 *                                         .onClause("onClause")
 *                                         .rightOperand("rightOperand")
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .leftJoinKeyProperties(JoinKeyPropertiesProperty.builder()
 *                                                 .uniqueKey(false)
 *                                                 .build())
 *                                         .rightJoinKeyProperties(JoinKeyPropertiesProperty.builder()
 *                                                 .uniqueKey(false)
 *                                                 .build())
 *                                         .build())
 *                                 .physicalTableId("physicalTableId")
 *                                 .build())
 *                         .build()))
 *         .name("name")
 *         .performanceConfiguration(PerformanceConfigurationProperty.builder()
 *                 .uniqueKeys(List.of(UniqueKeyProperty.builder()
 *                         .columnNames(List.of("columnNames"))
 *                         .build()))
 *                 .build())
 *         .permissions(List.of(ResourcePermissionProperty.builder()
 *                 .actions(List.of("actions"))
 *                 .principal("principal")
 *                 .build()))
 *         .physicalTableMap(Map.of(
 *                 "physicalTableMapKey", PhysicalTableProperty.builder()
 *                         .customSql(CustomSqlProperty.builder()
 *                                 .dataSourceArn("dataSourceArn")
 *                                 .name("name")
 *                                 .sqlQuery("sqlQuery")
 *                                 // the properties below are optional
 *                                 .columns(List.of(InputColumnProperty.builder()
 *                                         .name("name")
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .subType("subType")
 *                                         .build()))
 *                                 .build())
 *                         .relationalTable(RelationalTableProperty.builder()
 *                                 .dataSourceArn("dataSourceArn")
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .catalog("catalog")
 *                                 .inputColumns(List.of(InputColumnProperty.builder()
 *                                         .name("name")
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .subType("subType")
 *                                         .build()))
 *                                 .schema("schema")
 *                                 .build())
 *                         .s3Source(S3SourceProperty.builder()
 *                                 .dataSourceArn("dataSourceArn")
 *                                 // the properties below are optional
 *                                 .inputColumns(List.of(InputColumnProperty.builder()
 *                                         .name("name")
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .subType("subType")
 *                                         .build()))
 *                                 .uploadSettings(UploadSettingsProperty.builder()
 *                                         .containsHeader(false)
 *                                         .delimiter("delimiter")
 *                                         .format("format")
 *                                         .startFromRow(123)
 *                                         .textQualifier("textQualifier")
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *         .rowLevelPermissionDataSet(RowLevelPermissionDataSetProperty.builder()
 *                 .arn("arn")
 *                 .permissionPolicy("permissionPolicy")
 *                 // the properties below are optional
 *                 .formatVersion("formatVersion")
 *                 .namespace("namespace")
 *                 .status("status")
 *                 .build())
 *         .rowLevelPermissionTagConfiguration(RowLevelPermissionTagConfigurationProperty.builder()
 *                 .tagRules(List.of(RowLevelPermissionTagRuleProperty.builder()
 *                         .columnName("columnName")
 *                         .tagKey("tagKey")
 *                         // the properties below are optional
 *                         .matchAllValue("matchAllValue")
 *                         .tagMultiValueDelimiter("tagMultiValueDelimiter")
 *                         .build()))
 *                 // the properties below are optional
 *                 .status("status")
 *                 .tagRuleConfigurations(tagRuleConfigurations)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .useAs("useAs")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:13.350Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet")
public class CfnDataSet extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDataSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.quicksight.CfnDataSet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * <p>The amount of SPICE capacity used by this dataset.
     * <p>
     * This is 0 if the dataset isn't
     * imported into SPICE.</p>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrConsumedSpiceCapacityInBytes() {
        return software.amazon.jsii.Kernel.get(this, "attrConsumedSpiceCapacityInBytes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The time this dataset version was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time this dataset version was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * <p>The list of columns after all transforms.
     * <p>
     * These columns are available in templates,
     * analyses, and dashboards.</p>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrOutputColumns() {
        return software.amazon.jsii.Kernel.get(this, "attrOutputColumns", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The AWS account ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAwsAccountId() {
        return software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS account ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAwsAccountId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "awsAccountId", value);
    }

    /**
     * Groupings of columns that work together in certain Amazon QuickSight features.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getColumnGroups() {
        return software.amazon.jsii.Kernel.get(this, "columnGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Groupings of columns that work together in certain Amazon QuickSight features.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setColumnGroups(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "columnGroups", value);
    }

    /**
     * Groupings of columns that work together in certain Amazon QuickSight features.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setColumnGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnGroupProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnGroupProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "columnGroups", value);
    }

    /**
     * A set of one or more definitions of a <code>ColumnLevelPermissionRule</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getColumnLevelPermissionRules() {
        return software.amazon.jsii.Kernel.get(this, "columnLevelPermissionRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A set of one or more definitions of a <code>ColumnLevelPermissionRule</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setColumnLevelPermissionRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "columnLevelPermissionRules", value);
    }

    /**
     * A set of one or more definitions of a <code>ColumnLevelPermissionRule</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setColumnLevelPermissionRules(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnLevelPermissionRuleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnLevelPermissionRuleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "columnLevelPermissionRules", value);
    }

    /**
     * An ID for the dataset that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDataSetId() {
        return software.amazon.jsii.Kernel.get(this, "dataSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An ID for the dataset that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSetId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataSetId", value);
    }

    /**
     * The parameters that are declared in a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDatasetParameters() {
        return software.amazon.jsii.Kernel.get(this, "datasetParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The parameters that are declared in a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatasetParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "datasetParameters", value);
    }

    /**
     * The parameters that are declared in a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatasetParameters(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.DatasetParameterProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnDataSet.DatasetParameterProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "datasetParameters", value);
    }

    /**
     * The refresh properties of a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataSetRefreshProperties() {
        return software.amazon.jsii.Kernel.get(this, "dataSetRefreshProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The refresh properties of a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSetRefreshProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataSetRefreshProperties", value);
    }

    /**
     * The refresh properties of a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSetRefreshProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetRefreshPropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataSetRefreshProperties", value);
    }

    /**
     * The usage configuration to apply to child datasets that reference this dataset as a source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataSetUsageConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "dataSetUsageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The usage configuration to apply to child datasets that reference this dataset as a source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSetUsageConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataSetUsageConfiguration", value);
    }

    /**
     * The usage configuration to apply to child datasets that reference this dataset as a source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSetUsageConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetUsageConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataSetUsageConfiguration", value);
    }

    /**
     * The folder that contains fields and nested subfolders for your dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFieldFolders() {
        return software.amazon.jsii.Kernel.get(this, "fieldFolders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The folder that contains fields and nested subfolders for your dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFieldFolders(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "fieldFolders", value);
    }

    /**
     * The folder that contains fields and nested subfolders for your dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFieldFolders(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.FieldFolderProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnDataSet.FieldFolderProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "fieldFolders", value);
    }

    /**
     * <p>When you create the dataset, Amazon QuickSight adds the dataset to these folders.</p>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFolderArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "folderArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * <p>When you create the dataset, Amazon QuickSight adds the dataset to these folders.</p>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFolderArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "folderArns", value);
    }

    /**
     * Indicates whether you want to import the data into SPICE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getImportMode() {
        return software.amazon.jsii.Kernel.get(this, "importMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether you want to import the data into SPICE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImportMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "importMode", value);
    }

    /**
     * The wait policy to use when creating or updating a Dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIngestionWaitPolicy() {
        return software.amazon.jsii.Kernel.get(this, "ingestionWaitPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The wait policy to use when creating or updating a Dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIngestionWaitPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ingestionWaitPolicy", value);
    }

    /**
     * The wait policy to use when creating or updating a Dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIngestionWaitPolicy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.IngestionWaitPolicyProperty value) {
        software.amazon.jsii.Kernel.set(this, "ingestionWaitPolicy", value);
    }

    /**
     * Configures the combination and transformation of the data from the physical tables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogicalTableMap() {
        return software.amazon.jsii.Kernel.get(this, "logicalTableMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configures the combination and transformation of the data from the physical tables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogicalTableMap(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logicalTableMap", value);
    }

    /**
     * Configures the combination and transformation of the data from the physical tables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogicalTableMap(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.LogicalTableProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnDataSet.LogicalTableProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "logicalTableMap", value);
    }

    /**
     * The display name for the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The display name for the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The performance optimization configuration of a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPerformanceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "performanceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The performance optimization configuration of a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformanceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "performanceConfiguration", value);
    }

    /**
     * The performance optimization configuration of a dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPerformanceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.PerformanceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "performanceConfiguration", value);
    }

    /**
     * A list of resource permissions on the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPermissions() {
        return software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of resource permissions on the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * A list of resource permissions on the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.ResourcePermissionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnDataSet.ResourcePermissionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * Declares the physical tables that are available in the underlying data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPhysicalTableMap() {
        return software.amazon.jsii.Kernel.get(this, "physicalTableMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Declares the physical tables that are available in the underlying data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPhysicalTableMap(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "physicalTableMap", value);
    }

    /**
     * Declares the physical tables that are available in the underlying data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPhysicalTableMap(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnDataSet.PhysicalTableProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnDataSet.PhysicalTableProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "physicalTableMap", value);
    }

    /**
     * The row-level security configuration for the data that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRowLevelPermissionDataSet() {
        return software.amazon.jsii.Kernel.get(this, "rowLevelPermissionDataSet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The row-level security configuration for the data that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRowLevelPermissionDataSet(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rowLevelPermissionDataSet", value);
    }

    /**
     * The row-level security configuration for the data that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRowLevelPermissionDataSet(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.RowLevelPermissionDataSetProperty value) {
        software.amazon.jsii.Kernel.set(this, "rowLevelPermissionDataSet", value);
    }

    /**
     * The element you can use to define tags for row-level security.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRowLevelPermissionTagConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "rowLevelPermissionTagConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The element you can use to define tags for row-level security.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRowLevelPermissionTagConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rowLevelPermissionTagConfiguration", value);
    }

    /**
     * The element you can use to define tags for row-level security.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRowLevelPermissionTagConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnDataSet.RowLevelPermissionTagConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "rowLevelPermissionTagConfiguration", value);
    }

    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The usage of the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUseAs() {
        return software.amazon.jsii.Kernel.get(this, "useAs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The usage of the dataset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseAs(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "useAs", value);
    }
    /**
     * A calculated column for a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CalculatedColumnProperty calculatedColumnProperty = CalculatedColumnProperty.builder()
     *         .columnId("columnId")
     *         .columnName("columnName")
     *         .expression("expression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.CalculatedColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(CalculatedColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CalculatedColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A unique ID to identify a calculated column.
         * <p>
         * During a dataset update, if the column ID of a calculated column matches that of an existing calculated column, Amazon QuickSight preserves the existing calculated column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html#cfn-quicksight-dataset-calculatedcolumn-columnid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html#cfn-quicksight-dataset-calculatedcolumn-columnid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnId();

        /**
         * Column name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html#cfn-quicksight-dataset-calculatedcolumn-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html#cfn-quicksight-dataset-calculatedcolumn-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * An expression that defines the calculated column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html#cfn-quicksight-dataset-calculatedcolumn-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-calculatedcolumn.html#cfn-quicksight-dataset-calculatedcolumn-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * @return a {@link Builder} of {@link CalculatedColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CalculatedColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CalculatedColumnProperty> {
            java.lang.String columnId;
            java.lang.String columnName;
            java.lang.String expression;

            /**
             * Sets the value of {@link CalculatedColumnProperty#getColumnId}
             * @param columnId A unique ID to identify a calculated column. This parameter is required.
             *                 During a dataset update, if the column ID of a calculated column matches that of an existing calculated column, Amazon QuickSight preserves the existing calculated column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnId(java.lang.String columnId) {
                this.columnId = columnId;
                return this;
            }

            /**
             * Sets the value of {@link CalculatedColumnProperty#getColumnName}
             * @param columnName Column name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link CalculatedColumnProperty#getExpression}
             * @param expression An expression that defines the calculated column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CalculatedColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CalculatedColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CalculatedColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CalculatedColumnProperty {
            private final java.lang.String columnId;
            private final java.lang.String columnName;
            private final java.lang.String expression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnId = software.amazon.jsii.Kernel.get(this, "columnId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnId = java.util.Objects.requireNonNull(builder.columnId, "columnId is required");
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
            }

            @Override
            public final java.lang.String getColumnId() {
                return this.columnId;
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnId", om.valueToTree(this.getColumnId()));
                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("expression", om.valueToTree(this.getExpression()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.CalculatedColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CalculatedColumnProperty.Jsii$Proxy that = (CalculatedColumnProperty.Jsii$Proxy) o;

                if (!columnId.equals(that.columnId)) return false;
                if (!columnName.equals(that.columnName)) return false;
                return this.expression.equals(that.expression);
            }

            @Override
            public final int hashCode() {
                int result = this.columnId.hashCode();
                result = 31 * result + (this.columnName.hashCode());
                result = 31 * result + (this.expression.hashCode());
                return result;
            }
        }
    }
    /**
     * A transform operation that casts a column to a different type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CastColumnTypeOperationProperty castColumnTypeOperationProperty = CastColumnTypeOperationProperty.builder()
     *         .columnName("columnName")
     *         .newColumnType("newColumnType")
     *         // the properties below are optional
     *         .format("format")
     *         .subType("subType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.CastColumnTypeOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(CastColumnTypeOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CastColumnTypeOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Column name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * New column data type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-newcolumntype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-newcolumntype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNewColumnType();

        /**
         * When casting a column from string to datetime type, you can supply a string in a format supported by Amazon QuickSight to denote the source data format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-format">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-format</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
            return null;
        }

        /**
         * The sub data type of the new column.
         * <p>
         * Sub types are only available for decimal columns that are part of a SPICE dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-subtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-castcolumntypeoperation.html#cfn-quicksight-dataset-castcolumntypeoperation-subtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CastColumnTypeOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CastColumnTypeOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CastColumnTypeOperationProperty> {
            java.lang.String columnName;
            java.lang.String newColumnType;
            java.lang.String format;
            java.lang.String subType;

            /**
             * Sets the value of {@link CastColumnTypeOperationProperty#getColumnName}
             * @param columnName Column name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link CastColumnTypeOperationProperty#getNewColumnType}
             * @param newColumnType New column data type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newColumnType(java.lang.String newColumnType) {
                this.newColumnType = newColumnType;
                return this;
            }

            /**
             * Sets the value of {@link CastColumnTypeOperationProperty#getFormat}
             * @param format When casting a column from string to datetime type, you can supply a string in a format supported by Amazon QuickSight to denote the source data format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Sets the value of {@link CastColumnTypeOperationProperty#getSubType}
             * @param subType The sub data type of the new column.
             *                Sub types are only available for decimal columns that are part of a SPICE dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subType(java.lang.String subType) {
                this.subType = subType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CastColumnTypeOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CastColumnTypeOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CastColumnTypeOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CastColumnTypeOperationProperty {
            private final java.lang.String columnName;
            private final java.lang.String newColumnType;
            private final java.lang.String format;
            private final java.lang.String subType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.newColumnType = software.amazon.jsii.Kernel.get(this, "newColumnType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subType = software.amazon.jsii.Kernel.get(this, "subType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.newColumnType = java.util.Objects.requireNonNull(builder.newColumnType, "newColumnType is required");
                this.format = builder.format;
                this.subType = builder.subType;
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.String getNewColumnType() {
                return this.newColumnType;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public final java.lang.String getSubType() {
                return this.subType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("newColumnType", om.valueToTree(this.getNewColumnType()));
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }
                if (this.getSubType() != null) {
                    data.set("subType", om.valueToTree(this.getSubType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.CastColumnTypeOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CastColumnTypeOperationProperty.Jsii$Proxy that = (CastColumnTypeOperationProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                if (!newColumnType.equals(that.newColumnType)) return false;
                if (this.format != null ? !this.format.equals(that.format) : that.format != null) return false;
                return this.subType != null ? this.subType.equals(that.subType) : that.subType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.newColumnType.hashCode());
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                result = 31 * result + (this.subType != null ? this.subType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Metadata that contains a description for a column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnDescriptionProperty columnDescriptionProperty = ColumnDescriptionProperty.builder()
     *         .text("text")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columndescription.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columndescription.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnDescriptionProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnDescriptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnDescriptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The text of a description for a column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columndescription.html#cfn-quicksight-dataset-columndescription-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columndescription.html#cfn-quicksight-dataset-columndescription-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getText() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnDescriptionProperty> {
            java.lang.String text;

            /**
             * Sets the value of {@link ColumnDescriptionProperty#getText}
             * @param text The text of a description for a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnDescriptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnDescriptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnDescriptionProperty {
            private final java.lang.String text;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.text = builder.text;
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getText() != null) {
                    data.set("text", om.valueToTree(this.getText()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnDescriptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnDescriptionProperty.Jsii$Proxy that = (ColumnDescriptionProperty.Jsii$Proxy) o;

                return this.text != null ? this.text.equals(that.text) : that.text == null;
            }

            @Override
            public final int hashCode() {
                int result = this.text != null ? this.text.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Groupings of columns that work together in certain Amazon QuickSight features.
     * <p>
     * This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnGroupProperty columnGroupProperty = ColumnGroupProperty.builder()
     *         .geoSpatialColumnGroup(GeoSpatialColumnGroupProperty.builder()
     *                 .columns(List.of("columns"))
     *                 .name("name")
     *                 // the properties below are optional
     *                 .countryCode("countryCode")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columngroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columngroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Geospatial column group that denotes a hierarchy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columngroup.html#cfn-quicksight-dataset-columngroup-geospatialcolumngroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columngroup.html#cfn-quicksight-dataset-columngroup-geospatialcolumngroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGeoSpatialColumnGroup() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnGroupProperty> {
            java.lang.Object geoSpatialColumnGroup;

            /**
             * Sets the value of {@link ColumnGroupProperty#getGeoSpatialColumnGroup}
             * @param geoSpatialColumnGroup Geospatial column group that denotes a hierarchy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoSpatialColumnGroup(software.amazon.awscdk.IResolvable geoSpatialColumnGroup) {
                this.geoSpatialColumnGroup = geoSpatialColumnGroup;
                return this;
            }

            /**
             * Sets the value of {@link ColumnGroupProperty#getGeoSpatialColumnGroup}
             * @param geoSpatialColumnGroup Geospatial column group that denotes a hierarchy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoSpatialColumnGroup(software.amazon.awscdk.services.quicksight.CfnDataSet.GeoSpatialColumnGroupProperty geoSpatialColumnGroup) {
                this.geoSpatialColumnGroup = geoSpatialColumnGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnGroupProperty {
            private final java.lang.Object geoSpatialColumnGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.geoSpatialColumnGroup = software.amazon.jsii.Kernel.get(this, "geoSpatialColumnGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.geoSpatialColumnGroup = builder.geoSpatialColumnGroup;
            }

            @Override
            public final java.lang.Object getGeoSpatialColumnGroup() {
                return this.geoSpatialColumnGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGeoSpatialColumnGroup() != null) {
                    data.set("geoSpatialColumnGroup", om.valueToTree(this.getGeoSpatialColumnGroup()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnGroupProperty.Jsii$Proxy that = (ColumnGroupProperty.Jsii$Proxy) o;

                return this.geoSpatialColumnGroup != null ? this.geoSpatialColumnGroup.equals(that.geoSpatialColumnGroup) : that.geoSpatialColumnGroup == null;
            }

            @Override
            public final int hashCode() {
                int result = this.geoSpatialColumnGroup != null ? this.geoSpatialColumnGroup.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A rule defined to grant access on one or more restricted columns.
     * <p>
     * Each dataset can have multiple rules. To create a restricted column, you add it to one or more rules. Each rule must contain at least one column and at least one user or group. To be able to see a restricted column, a user or group needs to be added to a rule for that column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnLevelPermissionRuleProperty columnLevelPermissionRuleProperty = ColumnLevelPermissionRuleProperty.builder()
     *         .columnNames(List.of("columnNames"))
     *         .principals(List.of("principals"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columnlevelpermissionrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columnlevelpermissionrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnLevelPermissionRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnLevelPermissionRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnLevelPermissionRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of column names.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columnlevelpermissionrule.html#cfn-quicksight-dataset-columnlevelpermissionrule-columnnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columnlevelpermissionrule.html#cfn-quicksight-dataset-columnlevelpermissionrule-columnnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getColumnNames() {
            return null;
        }

        /**
         * An array of Amazon Resource Names (ARNs) for QuickSight users or groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columnlevelpermissionrule.html#cfn-quicksight-dataset-columnlevelpermissionrule-principals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columnlevelpermissionrule.html#cfn-quicksight-dataset-columnlevelpermissionrule-principals</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPrincipals() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnLevelPermissionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnLevelPermissionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnLevelPermissionRuleProperty> {
            java.util.List<java.lang.String> columnNames;
            java.util.List<java.lang.String> principals;

            /**
             * Sets the value of {@link ColumnLevelPermissionRuleProperty#getColumnNames}
             * @param columnNames An array of column names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnNames(java.util.List<java.lang.String> columnNames) {
                this.columnNames = columnNames;
                return this;
            }

            /**
             * Sets the value of {@link ColumnLevelPermissionRuleProperty#getPrincipals}
             * @param principals An array of Amazon Resource Names (ARNs) for QuickSight users or groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principals(java.util.List<java.lang.String> principals) {
                this.principals = principals;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnLevelPermissionRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnLevelPermissionRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnLevelPermissionRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnLevelPermissionRuleProperty {
            private final java.util.List<java.lang.String> columnNames;
            private final java.util.List<java.lang.String> principals;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnNames = software.amazon.jsii.Kernel.get(this, "columnNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.principals = software.amazon.jsii.Kernel.get(this, "principals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnNames = builder.columnNames;
                this.principals = builder.principals;
            }

            @Override
            public final java.util.List<java.lang.String> getColumnNames() {
                return this.columnNames;
            }

            @Override
            public final java.util.List<java.lang.String> getPrincipals() {
                return this.principals;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnNames() != null) {
                    data.set("columnNames", om.valueToTree(this.getColumnNames()));
                }
                if (this.getPrincipals() != null) {
                    data.set("principals", om.valueToTree(this.getPrincipals()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnLevelPermissionRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnLevelPermissionRuleProperty.Jsii$Proxy that = (ColumnLevelPermissionRuleProperty.Jsii$Proxy) o;

                if (this.columnNames != null ? !this.columnNames.equals(that.columnNames) : that.columnNames != null) return false;
                return this.principals != null ? this.principals.equals(that.principals) : that.principals == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnNames != null ? this.columnNames.hashCode() : 0;
                result = 31 * result + (this.principals != null ? this.principals.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A tag for a column in a <code>[TagColumnOperation](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_TagColumnOperation.html)</code> structure. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ColumnTagProperty columnTagProperty = ColumnTagProperty.builder()
     *         .columnDescription(ColumnDescriptionProperty.builder()
     *                 .text("text")
     *                 .build())
     *         .columnGeographicRole("columnGeographicRole")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntag.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntag.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnTagProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnTagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnTagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A description for a column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntag.html#cfn-quicksight-dataset-columntag-columndescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntag.html#cfn-quicksight-dataset-columntag-columndescription</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumnDescription() {
            return null;
        }

        /**
         * A geospatial role for a column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntag.html#cfn-quicksight-dataset-columntag-columngeographicrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-columntag.html#cfn-quicksight-dataset-columntag-columngeographicrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColumnGeographicRole() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnTagProperty> {
            java.lang.Object columnDescription;
            java.lang.String columnGeographicRole;

            /**
             * Sets the value of {@link ColumnTagProperty#getColumnDescription}
             * @param columnDescription A description for a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnDescription(software.amazon.awscdk.IResolvable columnDescription) {
                this.columnDescription = columnDescription;
                return this;
            }

            /**
             * Sets the value of {@link ColumnTagProperty#getColumnDescription}
             * @param columnDescription A description for a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnDescription(software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnDescriptionProperty columnDescription) {
                this.columnDescription = columnDescription;
                return this;
            }

            /**
             * Sets the value of {@link ColumnTagProperty#getColumnGeographicRole}
             * @param columnGeographicRole A geospatial role for a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnGeographicRole(java.lang.String columnGeographicRole) {
                this.columnGeographicRole = columnGeographicRole;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnTagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnTagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnTagProperty {
            private final java.lang.Object columnDescription;
            private final java.lang.String columnGeographicRole;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnDescription = software.amazon.jsii.Kernel.get(this, "columnDescription", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.columnGeographicRole = software.amazon.jsii.Kernel.get(this, "columnGeographicRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnDescription = builder.columnDescription;
                this.columnGeographicRole = builder.columnGeographicRole;
            }

            @Override
            public final java.lang.Object getColumnDescription() {
                return this.columnDescription;
            }

            @Override
            public final java.lang.String getColumnGeographicRole() {
                return this.columnGeographicRole;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnDescription() != null) {
                    data.set("columnDescription", om.valueToTree(this.getColumnDescription()));
                }
                if (this.getColumnGeographicRole() != null) {
                    data.set("columnGeographicRole", om.valueToTree(this.getColumnGeographicRole()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.ColumnTagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnTagProperty.Jsii$Proxy that = (ColumnTagProperty.Jsii$Proxy) o;

                if (this.columnDescription != null ? !this.columnDescription.equals(that.columnDescription) : that.columnDescription != null) return false;
                return this.columnGeographicRole != null ? this.columnGeographicRole.equals(that.columnGeographicRole) : that.columnGeographicRole == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnDescription != null ? this.columnDescription.hashCode() : 0;
                result = 31 * result + (this.columnGeographicRole != null ? this.columnGeographicRole.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that creates calculated columns.
     * <p>
     * Columns created in one such operation form a lexical closure.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CreateColumnsOperationProperty createColumnsOperationProperty = CreateColumnsOperationProperty.builder()
     *         .columns(List.of(CalculatedColumnProperty.builder()
     *                 .columnId("columnId")
     *                 .columnName("columnName")
     *                 .expression("expression")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-createcolumnsoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-createcolumnsoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.CreateColumnsOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(CreateColumnsOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CreateColumnsOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Calculated columns to create.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-createcolumnsoperation.html#cfn-quicksight-dataset-createcolumnsoperation-columns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-createcolumnsoperation.html#cfn-quicksight-dataset-createcolumnsoperation-columns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CreateColumnsOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CreateColumnsOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CreateColumnsOperationProperty> {
            java.lang.Object columns;

            /**
             * Sets the value of {@link CreateColumnsOperationProperty#getColumns}
             * @param columns Calculated columns to create.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(software.amazon.awscdk.IResolvable columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link CreateColumnsOperationProperty#getColumns}
             * @param columns Calculated columns to create.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<? extends java.lang.Object> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CreateColumnsOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CreateColumnsOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CreateColumnsOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateColumnsOperationProperty {
            private final java.lang.Object columns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columns = builder.columns;
            }

            @Override
            public final java.lang.Object getColumns() {
                return this.columns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumns() != null) {
                    data.set("columns", om.valueToTree(this.getColumns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.CreateColumnsOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CreateColumnsOperationProperty.Jsii$Proxy that = (CreateColumnsOperationProperty.Jsii$Proxy) o;

                return this.columns != null ? this.columns.equals(that.columns) : that.columns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columns != null ? this.columns.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A physical table type built from the results of the custom SQL query.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CustomSqlProperty customSqlProperty = CustomSqlProperty.builder()
     *         .dataSourceArn("dataSourceArn")
     *         .name("name")
     *         .sqlQuery("sqlQuery")
     *         // the properties below are optional
     *         .columns(List.of(InputColumnProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .subType("subType")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.CustomSqlProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomSqlProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomSqlProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-datasourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-datasourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSourceArn();

        /**
         * A display name for the SQL query result.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The SQL query.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-sqlquery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-sqlquery</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSqlQuery();

        /**
         * The column schema from the SQL query result set.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-columns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-customsql.html#cfn-quicksight-dataset-customsql-columns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomSqlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomSqlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomSqlProperty> {
            java.lang.String dataSourceArn;
            java.lang.String name;
            java.lang.String sqlQuery;
            java.lang.Object columns;

            /**
             * Sets the value of {@link CustomSqlProperty#getDataSourceArn}
             * @param dataSourceArn The Amazon Resource Name (ARN) of the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSourceArn(java.lang.String dataSourceArn) {
                this.dataSourceArn = dataSourceArn;
                return this;
            }

            /**
             * Sets the value of {@link CustomSqlProperty#getName}
             * @param name A display name for the SQL query result. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CustomSqlProperty#getSqlQuery}
             * @param sqlQuery The SQL query. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlQuery(java.lang.String sqlQuery) {
                this.sqlQuery = sqlQuery;
                return this;
            }

            /**
             * Sets the value of {@link CustomSqlProperty#getColumns}
             * @param columns The column schema from the SQL query result set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(software.amazon.awscdk.IResolvable columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link CustomSqlProperty#getColumns}
             * @param columns The column schema from the SQL query result set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<? extends java.lang.Object> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomSqlProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomSqlProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomSqlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomSqlProperty {
            private final java.lang.String dataSourceArn;
            private final java.lang.String name;
            private final java.lang.String sqlQuery;
            private final java.lang.Object columns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSourceArn = software.amazon.jsii.Kernel.get(this, "dataSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sqlQuery = software.amazon.jsii.Kernel.get(this, "sqlQuery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSourceArn = java.util.Objects.requireNonNull(builder.dataSourceArn, "dataSourceArn is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.sqlQuery = java.util.Objects.requireNonNull(builder.sqlQuery, "sqlQuery is required");
                this.columns = builder.columns;
            }

            @Override
            public final java.lang.String getDataSourceArn() {
                return this.dataSourceArn;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSqlQuery() {
                return this.sqlQuery;
            }

            @Override
            public final java.lang.Object getColumns() {
                return this.columns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSourceArn", om.valueToTree(this.getDataSourceArn()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("sqlQuery", om.valueToTree(this.getSqlQuery()));
                if (this.getColumns() != null) {
                    data.set("columns", om.valueToTree(this.getColumns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.CustomSqlProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomSqlProperty.Jsii$Proxy that = (CustomSqlProperty.Jsii$Proxy) o;

                if (!dataSourceArn.equals(that.dataSourceArn)) return false;
                if (!name.equals(that.name)) return false;
                if (!sqlQuery.equals(that.sqlQuery)) return false;
                return this.columns != null ? this.columns.equals(that.columns) : that.columns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataSourceArn.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.sqlQuery.hashCode());
                result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The refresh properties of a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetRefreshPropertiesProperty dataSetRefreshPropertiesProperty = DataSetRefreshPropertiesProperty.builder()
     *         .failureConfiguration(RefreshFailureConfigurationProperty.builder()
     *                 .emailAlert(RefreshFailureEmailAlertProperty.builder()
     *                         .alertStatus("alertStatus")
     *                         .build())
     *                 .build())
     *         .refreshConfiguration(RefreshConfigurationProperty.builder()
     *                 .incrementalRefresh(IncrementalRefreshProperty.builder()
     *                         .lookbackWindow(LookbackWindowProperty.builder()
     *                                 .columnName("columnName")
     *                                 .size(123)
     *                                 .sizeUnit("sizeUnit")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetrefreshproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetrefreshproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetRefreshPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetRefreshPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetRefreshPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The failure configuration for a dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetrefreshproperties.html#cfn-quicksight-dataset-datasetrefreshproperties-failureconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetrefreshproperties.html#cfn-quicksight-dataset-datasetrefreshproperties-failureconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailureConfiguration() {
            return null;
        }

        /**
         * The refresh configuration for a dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetrefreshproperties.html#cfn-quicksight-dataset-datasetrefreshproperties-refreshconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetrefreshproperties.html#cfn-quicksight-dataset-datasetrefreshproperties-refreshconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRefreshConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetRefreshPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetRefreshPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetRefreshPropertiesProperty> {
            java.lang.Object failureConfiguration;
            java.lang.Object refreshConfiguration;

            /**
             * Sets the value of {@link DataSetRefreshPropertiesProperty#getFailureConfiguration}
             * @param failureConfiguration The failure configuration for a dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureConfiguration(software.amazon.awscdk.IResolvable failureConfiguration) {
                this.failureConfiguration = failureConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSetRefreshPropertiesProperty#getFailureConfiguration}
             * @param failureConfiguration The failure configuration for a dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureConfiguration(software.amazon.awscdk.services.quicksight.CfnDataSet.RefreshFailureConfigurationProperty failureConfiguration) {
                this.failureConfiguration = failureConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSetRefreshPropertiesProperty#getRefreshConfiguration}
             * @param refreshConfiguration The refresh configuration for a dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshConfiguration(software.amazon.awscdk.IResolvable refreshConfiguration) {
                this.refreshConfiguration = refreshConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSetRefreshPropertiesProperty#getRefreshConfiguration}
             * @param refreshConfiguration The refresh configuration for a dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshConfiguration(software.amazon.awscdk.services.quicksight.CfnDataSet.RefreshConfigurationProperty refreshConfiguration) {
                this.refreshConfiguration = refreshConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetRefreshPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetRefreshPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetRefreshPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetRefreshPropertiesProperty {
            private final java.lang.Object failureConfiguration;
            private final java.lang.Object refreshConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failureConfiguration = software.amazon.jsii.Kernel.get(this, "failureConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.refreshConfiguration = software.amazon.jsii.Kernel.get(this, "refreshConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failureConfiguration = builder.failureConfiguration;
                this.refreshConfiguration = builder.refreshConfiguration;
            }

            @Override
            public final java.lang.Object getFailureConfiguration() {
                return this.failureConfiguration;
            }

            @Override
            public final java.lang.Object getRefreshConfiguration() {
                return this.refreshConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFailureConfiguration() != null) {
                    data.set("failureConfiguration", om.valueToTree(this.getFailureConfiguration()));
                }
                if (this.getRefreshConfiguration() != null) {
                    data.set("refreshConfiguration", om.valueToTree(this.getRefreshConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetRefreshPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetRefreshPropertiesProperty.Jsii$Proxy that = (DataSetRefreshPropertiesProperty.Jsii$Proxy) o;

                if (this.failureConfiguration != null ? !this.failureConfiguration.equals(that.failureConfiguration) : that.failureConfiguration != null) return false;
                return this.refreshConfiguration != null ? this.refreshConfiguration.equals(that.refreshConfiguration) : that.refreshConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.failureConfiguration != null ? this.failureConfiguration.hashCode() : 0;
                result = 31 * result + (this.refreshConfiguration != null ? this.refreshConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The usage configuration to apply to child datasets that reference this dataset as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataSetUsageConfigurationProperty dataSetUsageConfigurationProperty = DataSetUsageConfigurationProperty.builder()
     *         .disableUseAsDirectQuerySource(false)
     *         .disableUseAsImportedSource(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetusageconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetusageconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetUsageConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetUsageConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetUsageConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An option that controls whether a child dataset of a direct query can use this dataset as a source.
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetusageconfiguration.html#cfn-quicksight-dataset-datasetusageconfiguration-disableuseasdirectquerysource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetusageconfiguration.html#cfn-quicksight-dataset-datasetusageconfiguration-disableuseasdirectquerysource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableUseAsDirectQuerySource() {
            return null;
        }

        /**
         * An option that controls whether a child dataset that's stored in QuickSight can use this dataset as a source.
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetusageconfiguration.html#cfn-quicksight-dataset-datasetusageconfiguration-disableuseasimportedsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetusageconfiguration.html#cfn-quicksight-dataset-datasetusageconfiguration-disableuseasimportedsource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableUseAsImportedSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSetUsageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetUsageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetUsageConfigurationProperty> {
            java.lang.Object disableUseAsDirectQuerySource;
            java.lang.Object disableUseAsImportedSource;

            /**
             * Sets the value of {@link DataSetUsageConfigurationProperty#getDisableUseAsDirectQuerySource}
             * @param disableUseAsDirectQuerySource An option that controls whether a child dataset of a direct query can use this dataset as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableUseAsDirectQuerySource(java.lang.Boolean disableUseAsDirectQuerySource) {
                this.disableUseAsDirectQuerySource = disableUseAsDirectQuerySource;
                return this;
            }

            /**
             * Sets the value of {@link DataSetUsageConfigurationProperty#getDisableUseAsDirectQuerySource}
             * @param disableUseAsDirectQuerySource An option that controls whether a child dataset of a direct query can use this dataset as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableUseAsDirectQuerySource(software.amazon.awscdk.IResolvable disableUseAsDirectQuerySource) {
                this.disableUseAsDirectQuerySource = disableUseAsDirectQuerySource;
                return this;
            }

            /**
             * Sets the value of {@link DataSetUsageConfigurationProperty#getDisableUseAsImportedSource}
             * @param disableUseAsImportedSource An option that controls whether a child dataset that's stored in QuickSight can use this dataset as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableUseAsImportedSource(java.lang.Boolean disableUseAsImportedSource) {
                this.disableUseAsImportedSource = disableUseAsImportedSource;
                return this;
            }

            /**
             * Sets the value of {@link DataSetUsageConfigurationProperty#getDisableUseAsImportedSource}
             * @param disableUseAsImportedSource An option that controls whether a child dataset that's stored in QuickSight can use this dataset as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableUseAsImportedSource(software.amazon.awscdk.IResolvable disableUseAsImportedSource) {
                this.disableUseAsImportedSource = disableUseAsImportedSource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetUsageConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetUsageConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetUsageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetUsageConfigurationProperty {
            private final java.lang.Object disableUseAsDirectQuerySource;
            private final java.lang.Object disableUseAsImportedSource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.disableUseAsDirectQuerySource = software.amazon.jsii.Kernel.get(this, "disableUseAsDirectQuerySource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.disableUseAsImportedSource = software.amazon.jsii.Kernel.get(this, "disableUseAsImportedSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.disableUseAsDirectQuerySource = builder.disableUseAsDirectQuerySource;
                this.disableUseAsImportedSource = builder.disableUseAsImportedSource;
            }

            @Override
            public final java.lang.Object getDisableUseAsDirectQuerySource() {
                return this.disableUseAsDirectQuerySource;
            }

            @Override
            public final java.lang.Object getDisableUseAsImportedSource() {
                return this.disableUseAsImportedSource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDisableUseAsDirectQuerySource() != null) {
                    data.set("disableUseAsDirectQuerySource", om.valueToTree(this.getDisableUseAsDirectQuerySource()));
                }
                if (this.getDisableUseAsImportedSource() != null) {
                    data.set("disableUseAsImportedSource", om.valueToTree(this.getDisableUseAsImportedSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DataSetUsageConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetUsageConfigurationProperty.Jsii$Proxy that = (DataSetUsageConfigurationProperty.Jsii$Proxy) o;

                if (this.disableUseAsDirectQuerySource != null ? !this.disableUseAsDirectQuerySource.equals(that.disableUseAsDirectQuerySource) : that.disableUseAsDirectQuerySource != null) return false;
                return this.disableUseAsImportedSource != null ? this.disableUseAsImportedSource.equals(that.disableUseAsImportedSource) : that.disableUseAsImportedSource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.disableUseAsDirectQuerySource != null ? this.disableUseAsDirectQuerySource.hashCode() : 0;
                result = 31 * result + (this.disableUseAsImportedSource != null ? this.disableUseAsImportedSource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameter declarations of the dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DatasetParameterProperty datasetParameterProperty = DatasetParameterProperty.builder()
     *         .dateTimeDatasetParameter(DateTimeDatasetParameterProperty.builder()
     *                 .id("id")
     *                 .name("name")
     *                 .valueType("valueType")
     *                 // the properties below are optional
     *                 .defaultValues(DateTimeDatasetParameterDefaultValuesProperty.builder()
     *                         .staticValues(List.of("staticValues"))
     *                         .build())
     *                 .timeGranularity("timeGranularity")
     *                 .build())
     *         .decimalDatasetParameter(DecimalDatasetParameterProperty.builder()
     *                 .id("id")
     *                 .name("name")
     *                 .valueType("valueType")
     *                 // the properties below are optional
     *                 .defaultValues(DecimalDatasetParameterDefaultValuesProperty.builder()
     *                         .staticValues(List.of(123))
     *                         .build())
     *                 .build())
     *         .integerDatasetParameter(IntegerDatasetParameterProperty.builder()
     *                 .id("id")
     *                 .name("name")
     *                 .valueType("valueType")
     *                 // the properties below are optional
     *                 .defaultValues(IntegerDatasetParameterDefaultValuesProperty.builder()
     *                         .staticValues(List.of(123))
     *                         .build())
     *                 .build())
     *         .stringDatasetParameter(StringDatasetParameterProperty.builder()
     *                 .id("id")
     *                 .name("name")
     *                 .valueType("valueType")
     *                 // the properties below are optional
     *                 .defaultValues(StringDatasetParameterDefaultValuesProperty.builder()
     *                         .staticValues(List.of("staticValues"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DatasetParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(DatasetParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatasetParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A date time parameter that is created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html#cfn-quicksight-dataset-datasetparameter-datetimedatasetparameter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html#cfn-quicksight-dataset-datasetparameter-datetimedatasetparameter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDateTimeDatasetParameter() {
            return null;
        }

        /**
         * A decimal parameter that is created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html#cfn-quicksight-dataset-datasetparameter-decimaldatasetparameter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html#cfn-quicksight-dataset-datasetparameter-decimaldatasetparameter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDecimalDatasetParameter() {
            return null;
        }

        /**
         * An integer parameter that is created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html#cfn-quicksight-dataset-datasetparameter-integerdatasetparameter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html#cfn-quicksight-dataset-datasetparameter-integerdatasetparameter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntegerDatasetParameter() {
            return null;
        }

        /**
         * A string parameter that is created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html#cfn-quicksight-dataset-datasetparameter-stringdatasetparameter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datasetparameter.html#cfn-quicksight-dataset-datasetparameter-stringdatasetparameter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStringDatasetParameter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatasetParameterProperty> {
            java.lang.Object dateTimeDatasetParameter;
            java.lang.Object decimalDatasetParameter;
            java.lang.Object integerDatasetParameter;
            java.lang.Object stringDatasetParameter;

            /**
             * Sets the value of {@link DatasetParameterProperty#getDateTimeDatasetParameter}
             * @param dateTimeDatasetParameter A date time parameter that is created in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateTimeDatasetParameter(software.amazon.awscdk.IResolvable dateTimeDatasetParameter) {
                this.dateTimeDatasetParameter = dateTimeDatasetParameter;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getDateTimeDatasetParameter}
             * @param dateTimeDatasetParameter A date time parameter that is created in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateTimeDatasetParameter(software.amazon.awscdk.services.quicksight.CfnDataSet.DateTimeDatasetParameterProperty dateTimeDatasetParameter) {
                this.dateTimeDatasetParameter = dateTimeDatasetParameter;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getDecimalDatasetParameter}
             * @param decimalDatasetParameter A decimal parameter that is created in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decimalDatasetParameter(software.amazon.awscdk.IResolvable decimalDatasetParameter) {
                this.decimalDatasetParameter = decimalDatasetParameter;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getDecimalDatasetParameter}
             * @param decimalDatasetParameter A decimal parameter that is created in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decimalDatasetParameter(software.amazon.awscdk.services.quicksight.CfnDataSet.DecimalDatasetParameterProperty decimalDatasetParameter) {
                this.decimalDatasetParameter = decimalDatasetParameter;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getIntegerDatasetParameter}
             * @param integerDatasetParameter An integer parameter that is created in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerDatasetParameter(software.amazon.awscdk.IResolvable integerDatasetParameter) {
                this.integerDatasetParameter = integerDatasetParameter;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getIntegerDatasetParameter}
             * @param integerDatasetParameter An integer parameter that is created in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerDatasetParameter(software.amazon.awscdk.services.quicksight.CfnDataSet.IntegerDatasetParameterProperty integerDatasetParameter) {
                this.integerDatasetParameter = integerDatasetParameter;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getStringDatasetParameter}
             * @param stringDatasetParameter A string parameter that is created in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringDatasetParameter(software.amazon.awscdk.IResolvable stringDatasetParameter) {
                this.stringDatasetParameter = stringDatasetParameter;
                return this;
            }

            /**
             * Sets the value of {@link DatasetParameterProperty#getStringDatasetParameter}
             * @param stringDatasetParameter A string parameter that is created in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringDatasetParameter(software.amazon.awscdk.services.quicksight.CfnDataSet.StringDatasetParameterProperty stringDatasetParameter) {
                this.stringDatasetParameter = stringDatasetParameter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatasetParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatasetParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatasetParameterProperty {
            private final java.lang.Object dateTimeDatasetParameter;
            private final java.lang.Object decimalDatasetParameter;
            private final java.lang.Object integerDatasetParameter;
            private final java.lang.Object stringDatasetParameter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dateTimeDatasetParameter = software.amazon.jsii.Kernel.get(this, "dateTimeDatasetParameter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.decimalDatasetParameter = software.amazon.jsii.Kernel.get(this, "decimalDatasetParameter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.integerDatasetParameter = software.amazon.jsii.Kernel.get(this, "integerDatasetParameter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stringDatasetParameter = software.amazon.jsii.Kernel.get(this, "stringDatasetParameter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dateTimeDatasetParameter = builder.dateTimeDatasetParameter;
                this.decimalDatasetParameter = builder.decimalDatasetParameter;
                this.integerDatasetParameter = builder.integerDatasetParameter;
                this.stringDatasetParameter = builder.stringDatasetParameter;
            }

            @Override
            public final java.lang.Object getDateTimeDatasetParameter() {
                return this.dateTimeDatasetParameter;
            }

            @Override
            public final java.lang.Object getDecimalDatasetParameter() {
                return this.decimalDatasetParameter;
            }

            @Override
            public final java.lang.Object getIntegerDatasetParameter() {
                return this.integerDatasetParameter;
            }

            @Override
            public final java.lang.Object getStringDatasetParameter() {
                return this.stringDatasetParameter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDateTimeDatasetParameter() != null) {
                    data.set("dateTimeDatasetParameter", om.valueToTree(this.getDateTimeDatasetParameter()));
                }
                if (this.getDecimalDatasetParameter() != null) {
                    data.set("decimalDatasetParameter", om.valueToTree(this.getDecimalDatasetParameter()));
                }
                if (this.getIntegerDatasetParameter() != null) {
                    data.set("integerDatasetParameter", om.valueToTree(this.getIntegerDatasetParameter()));
                }
                if (this.getStringDatasetParameter() != null) {
                    data.set("stringDatasetParameter", om.valueToTree(this.getStringDatasetParameter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DatasetParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatasetParameterProperty.Jsii$Proxy that = (DatasetParameterProperty.Jsii$Proxy) o;

                if (this.dateTimeDatasetParameter != null ? !this.dateTimeDatasetParameter.equals(that.dateTimeDatasetParameter) : that.dateTimeDatasetParameter != null) return false;
                if (this.decimalDatasetParameter != null ? !this.decimalDatasetParameter.equals(that.decimalDatasetParameter) : that.decimalDatasetParameter != null) return false;
                if (this.integerDatasetParameter != null ? !this.integerDatasetParameter.equals(that.integerDatasetParameter) : that.integerDatasetParameter != null) return false;
                return this.stringDatasetParameter != null ? this.stringDatasetParameter.equals(that.stringDatasetParameter) : that.stringDatasetParameter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dateTimeDatasetParameter != null ? this.dateTimeDatasetParameter.hashCode() : 0;
                result = 31 * result + (this.decimalDatasetParameter != null ? this.decimalDatasetParameter.hashCode() : 0);
                result = 31 * result + (this.integerDatasetParameter != null ? this.integerDatasetParameter.hashCode() : 0);
                result = 31 * result + (this.stringDatasetParameter != null ? this.stringDatasetParameter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <p>The default values of a date time parameter.</p>.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DateTimeDatasetParameterDefaultValuesProperty dateTimeDatasetParameterDefaultValuesProperty = DateTimeDatasetParameterDefaultValuesProperty.builder()
     *         .staticValues(List.of("staticValues"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameterdefaultvalues.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameterdefaultvalues.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DateTimeDatasetParameterDefaultValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(DateTimeDatasetParameterDefaultValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DateTimeDatasetParameterDefaultValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of static default values for a given date time parameter.
         * <p>
         * The valid format for this property is <code>yyyy-MM-dd’T’HH:mm:ss’Z’</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameterdefaultvalues.html#cfn-quicksight-dataset-datetimedatasetparameterdefaultvalues-staticvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameterdefaultvalues.html#cfn-quicksight-dataset-datetimedatasetparameterdefaultvalues-staticvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStaticValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DateTimeDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DateTimeDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DateTimeDatasetParameterDefaultValuesProperty> {
            java.util.List<java.lang.String> staticValues;

            /**
             * Sets the value of {@link DateTimeDatasetParameterDefaultValuesProperty#getStaticValues}
             * @param staticValues A list of static default values for a given date time parameter.
             *                     The valid format for this property is <code>yyyy-MM-dd’T’HH:mm:ss’Z’</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValues(java.util.List<java.lang.String> staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DateTimeDatasetParameterDefaultValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DateTimeDatasetParameterDefaultValuesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DateTimeDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DateTimeDatasetParameterDefaultValuesProperty {
            private final java.util.List<java.lang.String> staticValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.staticValues = software.amazon.jsii.Kernel.get(this, "staticValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.staticValues = builder.staticValues;
            }

            @Override
            public final java.util.List<java.lang.String> getStaticValues() {
                return this.staticValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStaticValues() != null) {
                    data.set("staticValues", om.valueToTree(this.getStaticValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DateTimeDatasetParameterDefaultValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DateTimeDatasetParameterDefaultValuesProperty.Jsii$Proxy that = (DateTimeDatasetParameterDefaultValuesProperty.Jsii$Proxy) o;

                return this.staticValues != null ? this.staticValues.equals(that.staticValues) : that.staticValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.staticValues != null ? this.staticValues.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A date time parameter that is created in the dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DateTimeDatasetParameterProperty dateTimeDatasetParameterProperty = DateTimeDatasetParameterProperty.builder()
     *         .id("id")
     *         .name("name")
     *         .valueType("valueType")
     *         // the properties below are optional
     *         .defaultValues(DateTimeDatasetParameterDefaultValuesProperty.builder()
     *                 .staticValues(List.of("staticValues"))
     *                 .build())
     *         .timeGranularity("timeGranularity")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DateTimeDatasetParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(DateTimeDatasetParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DateTimeDatasetParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An identifier for the parameter that is created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The name of the date time parameter that is created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value type of the dataset parameter.
         * <p>
         * Valid values are <code>single value</code> or <code>multi value</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-valuetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-valuetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueType();

        /**
         * A list of default values for a given date time parameter.
         * <p>
         * This structure only accepts static values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-defaultvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-defaultvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultValues() {
            return null;
        }

        /**
         * The time granularity of the date time parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-timegranularity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-datetimedatasetparameter.html#cfn-quicksight-dataset-datetimedatasetparameter-timegranularity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimeGranularity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DateTimeDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DateTimeDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DateTimeDatasetParameterProperty> {
            java.lang.String id;
            java.lang.String name;
            java.lang.String valueType;
            java.lang.Object defaultValues;
            java.lang.String timeGranularity;

            /**
             * Sets the value of {@link DateTimeDatasetParameterProperty#getId}
             * @param id An identifier for the parameter that is created in the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeDatasetParameterProperty#getName}
             * @param name The name of the date time parameter that is created in the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeDatasetParameterProperty#getValueType}
             * @param valueType The value type of the dataset parameter. This parameter is required.
             *                  Valid values are <code>single value</code> or <code>multi value</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueType(java.lang.String valueType) {
                this.valueType = valueType;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeDatasetParameterProperty#getDefaultValues}
             * @param defaultValues A list of default values for a given date time parameter.
             *                      This structure only accepts static values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValues(software.amazon.awscdk.IResolvable defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeDatasetParameterProperty#getDefaultValues}
             * @param defaultValues A list of default values for a given date time parameter.
             *                      This structure only accepts static values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValues(software.amazon.awscdk.services.quicksight.CfnDataSet.DateTimeDatasetParameterDefaultValuesProperty defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeDatasetParameterProperty#getTimeGranularity}
             * @param timeGranularity The time granularity of the date time parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeGranularity(java.lang.String timeGranularity) {
                this.timeGranularity = timeGranularity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DateTimeDatasetParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DateTimeDatasetParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DateTimeDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DateTimeDatasetParameterProperty {
            private final java.lang.String id;
            private final java.lang.String name;
            private final java.lang.String valueType;
            private final java.lang.Object defaultValues;
            private final java.lang.String timeGranularity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueType = software.amazon.jsii.Kernel.get(this, "valueType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultValues = software.amazon.jsii.Kernel.get(this, "defaultValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeGranularity = software.amazon.jsii.Kernel.get(this, "timeGranularity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.valueType = java.util.Objects.requireNonNull(builder.valueType, "valueType is required");
                this.defaultValues = builder.defaultValues;
                this.timeGranularity = builder.timeGranularity;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValueType() {
                return this.valueType;
            }

            @Override
            public final java.lang.Object getDefaultValues() {
                return this.defaultValues;
            }

            @Override
            public final java.lang.String getTimeGranularity() {
                return this.timeGranularity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("valueType", om.valueToTree(this.getValueType()));
                if (this.getDefaultValues() != null) {
                    data.set("defaultValues", om.valueToTree(this.getDefaultValues()));
                }
                if (this.getTimeGranularity() != null) {
                    data.set("timeGranularity", om.valueToTree(this.getTimeGranularity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DateTimeDatasetParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DateTimeDatasetParameterProperty.Jsii$Proxy that = (DateTimeDatasetParameterProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (!name.equals(that.name)) return false;
                if (!valueType.equals(that.valueType)) return false;
                if (this.defaultValues != null ? !this.defaultValues.equals(that.defaultValues) : that.defaultValues != null) return false;
                return this.timeGranularity != null ? this.timeGranularity.equals(that.timeGranularity) : that.timeGranularity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.valueType.hashCode());
                result = 31 * result + (this.defaultValues != null ? this.defaultValues.hashCode() : 0);
                result = 31 * result + (this.timeGranularity != null ? this.timeGranularity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of default values for a given decimal parameter.
     * <p>
     * This structure only accepts static values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DecimalDatasetParameterDefaultValuesProperty decimalDatasetParameterDefaultValuesProperty = DecimalDatasetParameterDefaultValuesProperty.builder()
     *         .staticValues(List.of(123))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameterdefaultvalues.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameterdefaultvalues.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DecimalDatasetParameterDefaultValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(DecimalDatasetParameterDefaultValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DecimalDatasetParameterDefaultValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of static default values for a given decimal parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameterdefaultvalues.html#cfn-quicksight-dataset-decimaldatasetparameterdefaultvalues-staticvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameterdefaultvalues.html#cfn-quicksight-dataset-decimaldatasetparameterdefaultvalues-staticvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStaticValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DecimalDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DecimalDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DecimalDatasetParameterDefaultValuesProperty> {
            java.lang.Object staticValues;

            /**
             * Sets the value of {@link DecimalDatasetParameterDefaultValuesProperty#getStaticValues}
             * @param staticValues A list of static default values for a given decimal parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValues(java.util.List<? extends java.lang.Number> staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            /**
             * Sets the value of {@link DecimalDatasetParameterDefaultValuesProperty#getStaticValues}
             * @param staticValues A list of static default values for a given decimal parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValues(software.amazon.awscdk.IResolvable staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DecimalDatasetParameterDefaultValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DecimalDatasetParameterDefaultValuesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DecimalDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DecimalDatasetParameterDefaultValuesProperty {
            private final java.lang.Object staticValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.staticValues = software.amazon.jsii.Kernel.get(this, "staticValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.staticValues = builder.staticValues;
            }

            @Override
            public final java.lang.Object getStaticValues() {
                return this.staticValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStaticValues() != null) {
                    data.set("staticValues", om.valueToTree(this.getStaticValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DecimalDatasetParameterDefaultValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DecimalDatasetParameterDefaultValuesProperty.Jsii$Proxy that = (DecimalDatasetParameterDefaultValuesProperty.Jsii$Proxy) o;

                return this.staticValues != null ? this.staticValues.equals(that.staticValues) : that.staticValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.staticValues != null ? this.staticValues.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A decimal parameter that is created in the dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DecimalDatasetParameterProperty decimalDatasetParameterProperty = DecimalDatasetParameterProperty.builder()
     *         .id("id")
     *         .name("name")
     *         .valueType("valueType")
     *         // the properties below are optional
     *         .defaultValues(DecimalDatasetParameterDefaultValuesProperty.builder()
     *                 .staticValues(List.of(123))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.DecimalDatasetParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(DecimalDatasetParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DecimalDatasetParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An identifier for the decimal parameter created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html#cfn-quicksight-dataset-decimaldatasetparameter-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html#cfn-quicksight-dataset-decimaldatasetparameter-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The name of the decimal parameter that is created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html#cfn-quicksight-dataset-decimaldatasetparameter-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html#cfn-quicksight-dataset-decimaldatasetparameter-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value type of the dataset parameter.
         * <p>
         * Valid values are <code>single value</code> or <code>multi value</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html#cfn-quicksight-dataset-decimaldatasetparameter-valuetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html#cfn-quicksight-dataset-decimaldatasetparameter-valuetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueType();

        /**
         * A list of default values for a given decimal parameter.
         * <p>
         * This structure only accepts static values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html#cfn-quicksight-dataset-decimaldatasetparameter-defaultvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-decimaldatasetparameter.html#cfn-quicksight-dataset-decimaldatasetparameter-defaultvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DecimalDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DecimalDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DecimalDatasetParameterProperty> {
            java.lang.String id;
            java.lang.String name;
            java.lang.String valueType;
            java.lang.Object defaultValues;

            /**
             * Sets the value of {@link DecimalDatasetParameterProperty#getId}
             * @param id An identifier for the decimal parameter created in the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link DecimalDatasetParameterProperty#getName}
             * @param name The name of the decimal parameter that is created in the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DecimalDatasetParameterProperty#getValueType}
             * @param valueType The value type of the dataset parameter. This parameter is required.
             *                  Valid values are <code>single value</code> or <code>multi value</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueType(java.lang.String valueType) {
                this.valueType = valueType;
                return this;
            }

            /**
             * Sets the value of {@link DecimalDatasetParameterProperty#getDefaultValues}
             * @param defaultValues A list of default values for a given decimal parameter.
             *                      This structure only accepts static values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValues(software.amazon.awscdk.IResolvable defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            /**
             * Sets the value of {@link DecimalDatasetParameterProperty#getDefaultValues}
             * @param defaultValues A list of default values for a given decimal parameter.
             *                      This structure only accepts static values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValues(software.amazon.awscdk.services.quicksight.CfnDataSet.DecimalDatasetParameterDefaultValuesProperty defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DecimalDatasetParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DecimalDatasetParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DecimalDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DecimalDatasetParameterProperty {
            private final java.lang.String id;
            private final java.lang.String name;
            private final java.lang.String valueType;
            private final java.lang.Object defaultValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueType = software.amazon.jsii.Kernel.get(this, "valueType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultValues = software.amazon.jsii.Kernel.get(this, "defaultValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.valueType = java.util.Objects.requireNonNull(builder.valueType, "valueType is required");
                this.defaultValues = builder.defaultValues;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValueType() {
                return this.valueType;
            }

            @Override
            public final java.lang.Object getDefaultValues() {
                return this.defaultValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("valueType", om.valueToTree(this.getValueType()));
                if (this.getDefaultValues() != null) {
                    data.set("defaultValues", om.valueToTree(this.getDefaultValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.DecimalDatasetParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DecimalDatasetParameterProperty.Jsii$Proxy that = (DecimalDatasetParameterProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (!name.equals(that.name)) return false;
                if (!valueType.equals(that.valueType)) return false;
                return this.defaultValues != null ? this.defaultValues.equals(that.defaultValues) : that.defaultValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.valueType.hashCode());
                result = 31 * result + (this.defaultValues != null ? this.defaultValues.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A FieldFolder element is a folder that contains fields and nested subfolders.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * FieldFolderProperty fieldFolderProperty = FieldFolderProperty.builder()
     *         .columns(List.of("columns"))
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-fieldfolder.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-fieldfolder.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.FieldFolderProperty")
    @software.amazon.jsii.Jsii.Proxy(FieldFolderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FieldFolderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A folder has a list of columns.
         * <p>
         * A column can only be in one folder.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-fieldfolder.html#cfn-quicksight-dataset-fieldfolder-columns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-fieldfolder.html#cfn-quicksight-dataset-fieldfolder-columns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getColumns() {
            return null;
        }

        /**
         * The description for a field folder.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-fieldfolder.html#cfn-quicksight-dataset-fieldfolder-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-fieldfolder.html#cfn-quicksight-dataset-fieldfolder-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FieldFolderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FieldFolderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FieldFolderProperty> {
            java.util.List<java.lang.String> columns;
            java.lang.String description;

            /**
             * Sets the value of {@link FieldFolderProperty#getColumns}
             * @param columns A folder has a list of columns.
             *                A column can only be in one folder.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<java.lang.String> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link FieldFolderProperty#getDescription}
             * @param description The description for a field folder.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FieldFolderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FieldFolderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FieldFolderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldFolderProperty {
            private final java.util.List<java.lang.String> columns;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columns = builder.columns;
                this.description = builder.description;
            }

            @Override
            public final java.util.List<java.lang.String> getColumns() {
                return this.columns;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumns() != null) {
                    data.set("columns", om.valueToTree(this.getColumns()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.FieldFolderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FieldFolderProperty.Jsii$Proxy that = (FieldFolderProperty.Jsii$Proxy) o;

                if (this.columns != null ? !this.columns.equals(that.columns) : that.columns != null) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columns != null ? this.columns.hashCode() : 0;
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that filters rows based on a condition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * FilterOperationProperty filterOperationProperty = FilterOperationProperty.builder()
     *         .conditionExpression("conditionExpression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.FilterOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An expression that must evaluate to a Boolean value.
         * <p>
         * Rows for which the expression evaluates to true are kept in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html#cfn-quicksight-dataset-filteroperation-conditionexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-filteroperation.html#cfn-quicksight-dataset-filteroperation-conditionexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConditionExpression();

        /**
         * @return a {@link Builder} of {@link FilterOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterOperationProperty> {
            java.lang.String conditionExpression;

            /**
             * Sets the value of {@link FilterOperationProperty#getConditionExpression}
             * @param conditionExpression An expression that must evaluate to a Boolean value. This parameter is required.
             *                            Rows for which the expression evaluates to true are kept in the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionExpression(java.lang.String conditionExpression) {
                this.conditionExpression = conditionExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterOperationProperty {
            private final java.lang.String conditionExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.conditionExpression = software.amazon.jsii.Kernel.get(this, "conditionExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.conditionExpression = java.util.Objects.requireNonNull(builder.conditionExpression, "conditionExpression is required");
            }

            @Override
            public final java.lang.String getConditionExpression() {
                return this.conditionExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("conditionExpression", om.valueToTree(this.getConditionExpression()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.FilterOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterOperationProperty.Jsii$Proxy that = (FilterOperationProperty.Jsii$Proxy) o;

                return this.conditionExpression.equals(that.conditionExpression);
            }

            @Override
            public final int hashCode() {
                int result = this.conditionExpression.hashCode();
                return result;
            }
        }
    }
    /**
     * Geospatial column group that denotes a hierarchy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * GeoSpatialColumnGroupProperty geoSpatialColumnGroupProperty = GeoSpatialColumnGroupProperty.builder()
     *         .columns(List.of("columns"))
     *         .name("name")
     *         // the properties below are optional
     *         .countryCode("countryCode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.GeoSpatialColumnGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(GeoSpatialColumnGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeoSpatialColumnGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Columns in this hierarchy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html#cfn-quicksight-dataset-geospatialcolumngroup-columns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html#cfn-quicksight-dataset-geospatialcolumngroup-columns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getColumns();

        /**
         * A display name for the hierarchy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html#cfn-quicksight-dataset-geospatialcolumngroup-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html#cfn-quicksight-dataset-geospatialcolumngroup-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Country code.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html#cfn-quicksight-dataset-geospatialcolumngroup-countrycode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-geospatialcolumngroup.html#cfn-quicksight-dataset-geospatialcolumngroup-countrycode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCountryCode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeoSpatialColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeoSpatialColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeoSpatialColumnGroupProperty> {
            java.util.List<java.lang.String> columns;
            java.lang.String name;
            java.lang.String countryCode;

            /**
             * Sets the value of {@link GeoSpatialColumnGroupProperty#getColumns}
             * @param columns Columns in this hierarchy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<java.lang.String> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link GeoSpatialColumnGroupProperty#getName}
             * @param name A display name for the hierarchy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link GeoSpatialColumnGroupProperty#getCountryCode}
             * @param countryCode Country code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder countryCode(java.lang.String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeoSpatialColumnGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeoSpatialColumnGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GeoSpatialColumnGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeoSpatialColumnGroupProperty {
            private final java.util.List<java.lang.String> columns;
            private final java.lang.String name;
            private final java.lang.String countryCode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.countryCode = software.amazon.jsii.Kernel.get(this, "countryCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columns = java.util.Objects.requireNonNull(builder.columns, "columns is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.countryCode = builder.countryCode;
            }

            @Override
            public final java.util.List<java.lang.String> getColumns() {
                return this.columns;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getCountryCode() {
                return this.countryCode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columns", om.valueToTree(this.getColumns()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getCountryCode() != null) {
                    data.set("countryCode", om.valueToTree(this.getCountryCode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.GeoSpatialColumnGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeoSpatialColumnGroupProperty.Jsii$Proxy that = (GeoSpatialColumnGroupProperty.Jsii$Proxy) o;

                if (!columns.equals(that.columns)) return false;
                if (!name.equals(that.name)) return false;
                return this.countryCode != null ? this.countryCode.equals(that.countryCode) : that.countryCode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columns.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.countryCode != null ? this.countryCode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The incremental refresh configuration for a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * IncrementalRefreshProperty incrementalRefreshProperty = IncrementalRefreshProperty.builder()
     *         .lookbackWindow(LookbackWindowProperty.builder()
     *                 .columnName("columnName")
     *                 .size(123)
     *                 .sizeUnit("sizeUnit")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-incrementalrefresh.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-incrementalrefresh.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.IncrementalRefreshProperty")
    @software.amazon.jsii.Jsii.Proxy(IncrementalRefreshProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IncrementalRefreshProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The lookback window setup for an incremental refresh configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-incrementalrefresh.html#cfn-quicksight-dataset-incrementalrefresh-lookbackwindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-incrementalrefresh.html#cfn-quicksight-dataset-incrementalrefresh-lookbackwindow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLookbackWindow();

        /**
         * @return a {@link Builder} of {@link IncrementalRefreshProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IncrementalRefreshProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IncrementalRefreshProperty> {
            java.lang.Object lookbackWindow;

            /**
             * Sets the value of {@link IncrementalRefreshProperty#getLookbackWindow}
             * @param lookbackWindow The lookback window setup for an incremental refresh configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lookbackWindow(software.amazon.awscdk.IResolvable lookbackWindow) {
                this.lookbackWindow = lookbackWindow;
                return this;
            }

            /**
             * Sets the value of {@link IncrementalRefreshProperty#getLookbackWindow}
             * @param lookbackWindow The lookback window setup for an incremental refresh configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lookbackWindow(software.amazon.awscdk.services.quicksight.CfnDataSet.LookbackWindowProperty lookbackWindow) {
                this.lookbackWindow = lookbackWindow;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IncrementalRefreshProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IncrementalRefreshProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IncrementalRefreshProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IncrementalRefreshProperty {
            private final java.lang.Object lookbackWindow;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lookbackWindow = software.amazon.jsii.Kernel.get(this, "lookbackWindow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lookbackWindow = java.util.Objects.requireNonNull(builder.lookbackWindow, "lookbackWindow is required");
            }

            @Override
            public final java.lang.Object getLookbackWindow() {
                return this.lookbackWindow;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("lookbackWindow", om.valueToTree(this.getLookbackWindow()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.IncrementalRefreshProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IncrementalRefreshProperty.Jsii$Proxy that = (IncrementalRefreshProperty.Jsii$Proxy) o;

                return this.lookbackWindow.equals(that.lookbackWindow);
            }

            @Override
            public final int hashCode() {
                int result = this.lookbackWindow.hashCode();
                return result;
            }
        }
    }
    /**
     * The wait policy to use when creating or updating a Dataset.
     * <p>
     * The default is to wait for SPICE ingestion to finish with timeout of 36 hours.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * IngestionWaitPolicyProperty ingestionWaitPolicyProperty = IngestionWaitPolicyProperty.builder()
     *         .ingestionWaitTimeInHours(123)
     *         .waitForSpiceIngestion(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-ingestionwaitpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-ingestionwaitpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.IngestionWaitPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(IngestionWaitPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngestionWaitPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum time (in hours) to wait for Ingestion to complete.
         * <p>
         * Default timeout is 36 hours. Applicable only when <code>DataSetImportMode</code> mode is set to SPICE and <code>WaitForSpiceIngestion</code> is set to true.
         * <p>
         * Default: - 36
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-ingestionwaitpolicy.html#cfn-quicksight-dataset-ingestionwaitpolicy-ingestionwaittimeinhours">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-ingestionwaitpolicy.html#cfn-quicksight-dataset-ingestionwaitpolicy-ingestionwaittimeinhours</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIngestionWaitTimeInHours() {
            return null;
        }

        /**
         * Wait for SPICE ingestion to finish to mark dataset creation or update as successful.
         * <p>
         * Default (true). Applicable only when <code>DataSetImportMode</code> mode is set to SPICE.
         * <p>
         * Default: - true
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-ingestionwaitpolicy.html#cfn-quicksight-dataset-ingestionwaitpolicy-waitforspiceingestion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-ingestionwaitpolicy.html#cfn-quicksight-dataset-ingestionwaitpolicy-waitforspiceingestion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWaitForSpiceIngestion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IngestionWaitPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngestionWaitPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngestionWaitPolicyProperty> {
            java.lang.Number ingestionWaitTimeInHours;
            java.lang.Object waitForSpiceIngestion;

            /**
             * Sets the value of {@link IngestionWaitPolicyProperty#getIngestionWaitTimeInHours}
             * @param ingestionWaitTimeInHours The maximum time (in hours) to wait for Ingestion to complete.
             *                                 Default timeout is 36 hours. Applicable only when <code>DataSetImportMode</code> mode is set to SPICE and <code>WaitForSpiceIngestion</code> is set to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ingestionWaitTimeInHours(java.lang.Number ingestionWaitTimeInHours) {
                this.ingestionWaitTimeInHours = ingestionWaitTimeInHours;
                return this;
            }

            /**
             * Sets the value of {@link IngestionWaitPolicyProperty#getWaitForSpiceIngestion}
             * @param waitForSpiceIngestion Wait for SPICE ingestion to finish to mark dataset creation or update as successful.
             *                              Default (true). Applicable only when <code>DataSetImportMode</code> mode is set to SPICE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitForSpiceIngestion(java.lang.Boolean waitForSpiceIngestion) {
                this.waitForSpiceIngestion = waitForSpiceIngestion;
                return this;
            }

            /**
             * Sets the value of {@link IngestionWaitPolicyProperty#getWaitForSpiceIngestion}
             * @param waitForSpiceIngestion Wait for SPICE ingestion to finish to mark dataset creation or update as successful.
             *                              Default (true). Applicable only when <code>DataSetImportMode</code> mode is set to SPICE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitForSpiceIngestion(software.amazon.awscdk.IResolvable waitForSpiceIngestion) {
                this.waitForSpiceIngestion = waitForSpiceIngestion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngestionWaitPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngestionWaitPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngestionWaitPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngestionWaitPolicyProperty {
            private final java.lang.Number ingestionWaitTimeInHours;
            private final java.lang.Object waitForSpiceIngestion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ingestionWaitTimeInHours = software.amazon.jsii.Kernel.get(this, "ingestionWaitTimeInHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.waitForSpiceIngestion = software.amazon.jsii.Kernel.get(this, "waitForSpiceIngestion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ingestionWaitTimeInHours = builder.ingestionWaitTimeInHours;
                this.waitForSpiceIngestion = builder.waitForSpiceIngestion;
            }

            @Override
            public final java.lang.Number getIngestionWaitTimeInHours() {
                return this.ingestionWaitTimeInHours;
            }

            @Override
            public final java.lang.Object getWaitForSpiceIngestion() {
                return this.waitForSpiceIngestion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIngestionWaitTimeInHours() != null) {
                    data.set("ingestionWaitTimeInHours", om.valueToTree(this.getIngestionWaitTimeInHours()));
                }
                if (this.getWaitForSpiceIngestion() != null) {
                    data.set("waitForSpiceIngestion", om.valueToTree(this.getWaitForSpiceIngestion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.IngestionWaitPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngestionWaitPolicyProperty.Jsii$Proxy that = (IngestionWaitPolicyProperty.Jsii$Proxy) o;

                if (this.ingestionWaitTimeInHours != null ? !this.ingestionWaitTimeInHours.equals(that.ingestionWaitTimeInHours) : that.ingestionWaitTimeInHours != null) return false;
                return this.waitForSpiceIngestion != null ? this.waitForSpiceIngestion.equals(that.waitForSpiceIngestion) : that.waitForSpiceIngestion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ingestionWaitTimeInHours != null ? this.ingestionWaitTimeInHours.hashCode() : 0;
                result = 31 * result + (this.waitForSpiceIngestion != null ? this.waitForSpiceIngestion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Metadata for a column that is used as the input of a transform operation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * InputColumnProperty inputColumnProperty = InputColumnProperty.builder()
     *         .name("name")
     *         .type("type")
     *         // the properties below are optional
     *         .subType("subType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.InputColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(InputColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of this column in the underlying data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html#cfn-quicksight-dataset-inputcolumn-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html#cfn-quicksight-dataset-inputcolumn-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The data type of the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html#cfn-quicksight-dataset-inputcolumn-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html#cfn-quicksight-dataset-inputcolumn-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The sub data type of the column.
         * <p>
         * Sub types are only available for decimal columns that are part of a SPICE dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html#cfn-quicksight-dataset-inputcolumn-subtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-inputcolumn.html#cfn-quicksight-dataset-inputcolumn-subtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputColumnProperty> {
            java.lang.String name;
            java.lang.String type;
            java.lang.String subType;

            /**
             * Sets the value of {@link InputColumnProperty#getName}
             * @param name The name of this column in the underlying data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link InputColumnProperty#getType}
             * @param type The data type of the column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link InputColumnProperty#getSubType}
             * @param subType The sub data type of the column.
             *                Sub types are only available for decimal columns that are part of a SPICE dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subType(java.lang.String subType) {
                this.subType = subType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputColumnProperty {
            private final java.lang.String name;
            private final java.lang.String type;
            private final java.lang.String subType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subType = software.amazon.jsii.Kernel.get(this, "subType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.subType = builder.subType;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getSubType() {
                return this.subType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getSubType() != null) {
                    data.set("subType", om.valueToTree(this.getSubType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.InputColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputColumnProperty.Jsii$Proxy that = (InputColumnProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!type.equals(that.type)) return false;
                return this.subType != null ? this.subType.equals(that.subType) : that.subType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.subType != null ? this.subType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of default values for a given integer parameter.
     * <p>
     * This structure only accepts static values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * IntegerDatasetParameterDefaultValuesProperty integerDatasetParameterDefaultValuesProperty = IntegerDatasetParameterDefaultValuesProperty.builder()
     *         .staticValues(List.of(123))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameterdefaultvalues.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameterdefaultvalues.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.IntegerDatasetParameterDefaultValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(IntegerDatasetParameterDefaultValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntegerDatasetParameterDefaultValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of static default values for a given integer parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameterdefaultvalues.html#cfn-quicksight-dataset-integerdatasetparameterdefaultvalues-staticvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameterdefaultvalues.html#cfn-quicksight-dataset-integerdatasetparameterdefaultvalues-staticvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStaticValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntegerDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntegerDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntegerDatasetParameterDefaultValuesProperty> {
            java.lang.Object staticValues;

            /**
             * Sets the value of {@link IntegerDatasetParameterDefaultValuesProperty#getStaticValues}
             * @param staticValues A list of static default values for a given integer parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValues(java.util.List<? extends java.lang.Number> staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            /**
             * Sets the value of {@link IntegerDatasetParameterDefaultValuesProperty#getStaticValues}
             * @param staticValues A list of static default values for a given integer parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValues(software.amazon.awscdk.IResolvable staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegerDatasetParameterDefaultValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntegerDatasetParameterDefaultValuesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntegerDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegerDatasetParameterDefaultValuesProperty {
            private final java.lang.Object staticValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.staticValues = software.amazon.jsii.Kernel.get(this, "staticValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.staticValues = builder.staticValues;
            }

            @Override
            public final java.lang.Object getStaticValues() {
                return this.staticValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStaticValues() != null) {
                    data.set("staticValues", om.valueToTree(this.getStaticValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.IntegerDatasetParameterDefaultValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntegerDatasetParameterDefaultValuesProperty.Jsii$Proxy that = (IntegerDatasetParameterDefaultValuesProperty.Jsii$Proxy) o;

                return this.staticValues != null ? this.staticValues.equals(that.staticValues) : that.staticValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.staticValues != null ? this.staticValues.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An integer parameter that is created in the dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * IntegerDatasetParameterProperty integerDatasetParameterProperty = IntegerDatasetParameterProperty.builder()
     *         .id("id")
     *         .name("name")
     *         .valueType("valueType")
     *         // the properties below are optional
     *         .defaultValues(IntegerDatasetParameterDefaultValuesProperty.builder()
     *                 .staticValues(List.of(123))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.IntegerDatasetParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(IntegerDatasetParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntegerDatasetParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An identifier for the integer parameter created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html#cfn-quicksight-dataset-integerdatasetparameter-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html#cfn-quicksight-dataset-integerdatasetparameter-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The name of the integer parameter that is created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html#cfn-quicksight-dataset-integerdatasetparameter-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html#cfn-quicksight-dataset-integerdatasetparameter-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value type of the dataset parameter.
         * <p>
         * Valid values are <code>single value</code> or <code>multi value</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html#cfn-quicksight-dataset-integerdatasetparameter-valuetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html#cfn-quicksight-dataset-integerdatasetparameter-valuetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueType();

        /**
         * A list of default values for a given integer parameter.
         * <p>
         * This structure only accepts static values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html#cfn-quicksight-dataset-integerdatasetparameter-defaultvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-integerdatasetparameter.html#cfn-quicksight-dataset-integerdatasetparameter-defaultvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntegerDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntegerDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntegerDatasetParameterProperty> {
            java.lang.String id;
            java.lang.String name;
            java.lang.String valueType;
            java.lang.Object defaultValues;

            /**
             * Sets the value of {@link IntegerDatasetParameterProperty#getId}
             * @param id An identifier for the integer parameter created in the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link IntegerDatasetParameterProperty#getName}
             * @param name The name of the integer parameter that is created in the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link IntegerDatasetParameterProperty#getValueType}
             * @param valueType The value type of the dataset parameter. This parameter is required.
             *                  Valid values are <code>single value</code> or <code>multi value</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueType(java.lang.String valueType) {
                this.valueType = valueType;
                return this;
            }

            /**
             * Sets the value of {@link IntegerDatasetParameterProperty#getDefaultValues}
             * @param defaultValues A list of default values for a given integer parameter.
             *                      This structure only accepts static values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValues(software.amazon.awscdk.IResolvable defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            /**
             * Sets the value of {@link IntegerDatasetParameterProperty#getDefaultValues}
             * @param defaultValues A list of default values for a given integer parameter.
             *                      This structure only accepts static values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValues(software.amazon.awscdk.services.quicksight.CfnDataSet.IntegerDatasetParameterDefaultValuesProperty defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegerDatasetParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntegerDatasetParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntegerDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegerDatasetParameterProperty {
            private final java.lang.String id;
            private final java.lang.String name;
            private final java.lang.String valueType;
            private final java.lang.Object defaultValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueType = software.amazon.jsii.Kernel.get(this, "valueType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultValues = software.amazon.jsii.Kernel.get(this, "defaultValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.valueType = java.util.Objects.requireNonNull(builder.valueType, "valueType is required");
                this.defaultValues = builder.defaultValues;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValueType() {
                return this.valueType;
            }

            @Override
            public final java.lang.Object getDefaultValues() {
                return this.defaultValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("valueType", om.valueToTree(this.getValueType()));
                if (this.getDefaultValues() != null) {
                    data.set("defaultValues", om.valueToTree(this.getDefaultValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.IntegerDatasetParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntegerDatasetParameterProperty.Jsii$Proxy that = (IntegerDatasetParameterProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (!name.equals(that.name)) return false;
                if (!valueType.equals(that.valueType)) return false;
                return this.defaultValues != null ? this.defaultValues.equals(that.defaultValues) : that.defaultValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.valueType.hashCode());
                result = 31 * result + (this.defaultValues != null ? this.defaultValues.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The instructions associated with a join.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * JoinInstructionProperty joinInstructionProperty = JoinInstructionProperty.builder()
     *         .leftOperand("leftOperand")
     *         .onClause("onClause")
     *         .rightOperand("rightOperand")
     *         .type("type")
     *         // the properties below are optional
     *         .leftJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                 .uniqueKey(false)
     *                 .build())
     *         .rightJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                 .uniqueKey(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.JoinInstructionProperty")
    @software.amazon.jsii.Jsii.Proxy(JoinInstructionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JoinInstructionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The operand on the left side of a join.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-leftoperand">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-leftoperand</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLeftOperand();

        /**
         * The join instructions provided in the <code>ON</code> clause of a join.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-onclause">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-onclause</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOnClause();

        /**
         * The operand on the right side of a join.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-rightoperand">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-rightoperand</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRightOperand();

        /**
         * The type of join that it is.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Join key properties of the left operand.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-leftjoinkeyproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-leftjoinkeyproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLeftJoinKeyProperties() {
            return null;
        }

        /**
         * Join key properties of the right operand.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-rightjoinkeyproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joininstruction.html#cfn-quicksight-dataset-joininstruction-rightjoinkeyproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRightJoinKeyProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JoinInstructionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JoinInstructionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JoinInstructionProperty> {
            java.lang.String leftOperand;
            java.lang.String onClause;
            java.lang.String rightOperand;
            java.lang.String type;
            java.lang.Object leftJoinKeyProperties;
            java.lang.Object rightJoinKeyProperties;

            /**
             * Sets the value of {@link JoinInstructionProperty#getLeftOperand}
             * @param leftOperand The operand on the left side of a join. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leftOperand(java.lang.String leftOperand) {
                this.leftOperand = leftOperand;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getOnClause}
             * @param onClause The join instructions provided in the <code>ON</code> clause of a join. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onClause(java.lang.String onClause) {
                this.onClause = onClause;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getRightOperand}
             * @param rightOperand The operand on the right side of a join. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rightOperand(java.lang.String rightOperand) {
                this.rightOperand = rightOperand;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getType}
             * @param type The type of join that it is. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getLeftJoinKeyProperties}
             * @param leftJoinKeyProperties Join key properties of the left operand.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leftJoinKeyProperties(software.amazon.awscdk.IResolvable leftJoinKeyProperties) {
                this.leftJoinKeyProperties = leftJoinKeyProperties;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getLeftJoinKeyProperties}
             * @param leftJoinKeyProperties Join key properties of the left operand.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leftJoinKeyProperties(software.amazon.awscdk.services.quicksight.CfnDataSet.JoinKeyPropertiesProperty leftJoinKeyProperties) {
                this.leftJoinKeyProperties = leftJoinKeyProperties;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getRightJoinKeyProperties}
             * @param rightJoinKeyProperties Join key properties of the right operand.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rightJoinKeyProperties(software.amazon.awscdk.IResolvable rightJoinKeyProperties) {
                this.rightJoinKeyProperties = rightJoinKeyProperties;
                return this;
            }

            /**
             * Sets the value of {@link JoinInstructionProperty#getRightJoinKeyProperties}
             * @param rightJoinKeyProperties Join key properties of the right operand.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rightJoinKeyProperties(software.amazon.awscdk.services.quicksight.CfnDataSet.JoinKeyPropertiesProperty rightJoinKeyProperties) {
                this.rightJoinKeyProperties = rightJoinKeyProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JoinInstructionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JoinInstructionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JoinInstructionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JoinInstructionProperty {
            private final java.lang.String leftOperand;
            private final java.lang.String onClause;
            private final java.lang.String rightOperand;
            private final java.lang.String type;
            private final java.lang.Object leftJoinKeyProperties;
            private final java.lang.Object rightJoinKeyProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.leftOperand = software.amazon.jsii.Kernel.get(this, "leftOperand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onClause = software.amazon.jsii.Kernel.get(this, "onClause", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rightOperand = software.amazon.jsii.Kernel.get(this, "rightOperand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.leftJoinKeyProperties = software.amazon.jsii.Kernel.get(this, "leftJoinKeyProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rightJoinKeyProperties = software.amazon.jsii.Kernel.get(this, "rightJoinKeyProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.leftOperand = java.util.Objects.requireNonNull(builder.leftOperand, "leftOperand is required");
                this.onClause = java.util.Objects.requireNonNull(builder.onClause, "onClause is required");
                this.rightOperand = java.util.Objects.requireNonNull(builder.rightOperand, "rightOperand is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.leftJoinKeyProperties = builder.leftJoinKeyProperties;
                this.rightJoinKeyProperties = builder.rightJoinKeyProperties;
            }

            @Override
            public final java.lang.String getLeftOperand() {
                return this.leftOperand;
            }

            @Override
            public final java.lang.String getOnClause() {
                return this.onClause;
            }

            @Override
            public final java.lang.String getRightOperand() {
                return this.rightOperand;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getLeftJoinKeyProperties() {
                return this.leftJoinKeyProperties;
            }

            @Override
            public final java.lang.Object getRightJoinKeyProperties() {
                return this.rightJoinKeyProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("leftOperand", om.valueToTree(this.getLeftOperand()));
                data.set("onClause", om.valueToTree(this.getOnClause()));
                data.set("rightOperand", om.valueToTree(this.getRightOperand()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getLeftJoinKeyProperties() != null) {
                    data.set("leftJoinKeyProperties", om.valueToTree(this.getLeftJoinKeyProperties()));
                }
                if (this.getRightJoinKeyProperties() != null) {
                    data.set("rightJoinKeyProperties", om.valueToTree(this.getRightJoinKeyProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.JoinInstructionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JoinInstructionProperty.Jsii$Proxy that = (JoinInstructionProperty.Jsii$Proxy) o;

                if (!leftOperand.equals(that.leftOperand)) return false;
                if (!onClause.equals(that.onClause)) return false;
                if (!rightOperand.equals(that.rightOperand)) return false;
                if (!type.equals(that.type)) return false;
                if (this.leftJoinKeyProperties != null ? !this.leftJoinKeyProperties.equals(that.leftJoinKeyProperties) : that.leftJoinKeyProperties != null) return false;
                return this.rightJoinKeyProperties != null ? this.rightJoinKeyProperties.equals(that.rightJoinKeyProperties) : that.rightJoinKeyProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.leftOperand.hashCode();
                result = 31 * result + (this.onClause.hashCode());
                result = 31 * result + (this.rightOperand.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.leftJoinKeyProperties != null ? this.leftJoinKeyProperties.hashCode() : 0);
                result = 31 * result + (this.rightJoinKeyProperties != null ? this.rightJoinKeyProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Properties associated with the columns participating in a join.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * JoinKeyPropertiesProperty joinKeyPropertiesProperty = JoinKeyPropertiesProperty.builder()
     *         .uniqueKey(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinkeyproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinkeyproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.JoinKeyPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(JoinKeyPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JoinKeyPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A value that indicates that a row in a table is uniquely identified by the columns in a join key.
         * <p>
         * This is used by QuickSight to optimize query performance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinkeyproperties.html#cfn-quicksight-dataset-joinkeyproperties-uniquekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-joinkeyproperties.html#cfn-quicksight-dataset-joinkeyproperties-uniquekey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUniqueKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JoinKeyPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JoinKeyPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JoinKeyPropertiesProperty> {
            java.lang.Object uniqueKey;

            /**
             * Sets the value of {@link JoinKeyPropertiesProperty#getUniqueKey}
             * @param uniqueKey A value that indicates that a row in a table is uniquely identified by the columns in a join key.
             *                  This is used by QuickSight to optimize query performance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uniqueKey(java.lang.Boolean uniqueKey) {
                this.uniqueKey = uniqueKey;
                return this;
            }

            /**
             * Sets the value of {@link JoinKeyPropertiesProperty#getUniqueKey}
             * @param uniqueKey A value that indicates that a row in a table is uniquely identified by the columns in a join key.
             *                  This is used by QuickSight to optimize query performance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uniqueKey(software.amazon.awscdk.IResolvable uniqueKey) {
                this.uniqueKey = uniqueKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JoinKeyPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JoinKeyPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JoinKeyPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JoinKeyPropertiesProperty {
            private final java.lang.Object uniqueKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.uniqueKey = software.amazon.jsii.Kernel.get(this, "uniqueKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.uniqueKey = builder.uniqueKey;
            }

            @Override
            public final java.lang.Object getUniqueKey() {
                return this.uniqueKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getUniqueKey() != null) {
                    data.set("uniqueKey", om.valueToTree(this.getUniqueKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.JoinKeyPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JoinKeyPropertiesProperty.Jsii$Proxy that = (JoinKeyPropertiesProperty.Jsii$Proxy) o;

                return this.uniqueKey != null ? this.uniqueKey.equals(that.uniqueKey) : that.uniqueKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.uniqueKey != null ? this.uniqueKey.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A <em>logical table</em> is a unit that joins and that data transformations operate on.
     * <p>
     * A logical table has a source, which can be either a physical table or result of a join. When a logical table points to a physical table, the logical table acts as a mutable copy of that physical table through transform operations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * LogicalTableProperty logicalTableProperty = LogicalTableProperty.builder()
     *         .alias("alias")
     *         // the properties below are optional
     *         .dataTransforms(List.of(TransformOperationProperty.builder()
     *                 .castColumnTypeOperation(CastColumnTypeOperationProperty.builder()
     *                         .columnName("columnName")
     *                         .newColumnType("newColumnType")
     *                         // the properties below are optional
     *                         .format("format")
     *                         .subType("subType")
     *                         .build())
     *                 .createColumnsOperation(CreateColumnsOperationProperty.builder()
     *                         .columns(List.of(CalculatedColumnProperty.builder()
     *                                 .columnId("columnId")
     *                                 .columnName("columnName")
     *                                 .expression("expression")
     *                                 .build()))
     *                         .build())
     *                 .filterOperation(FilterOperationProperty.builder()
     *                         .conditionExpression("conditionExpression")
     *                         .build())
     *                 .overrideDatasetParameterOperation(OverrideDatasetParameterOperationProperty.builder()
     *                         .parameterName("parameterName")
     *                         // the properties below are optional
     *                         .newDefaultValues(NewDefaultValuesProperty.builder()
     *                                 .dateTimeStaticValues(List.of("dateTimeStaticValues"))
     *                                 .decimalStaticValues(List.of(123))
     *                                 .integerStaticValues(List.of(123))
     *                                 .stringStaticValues(List.of("stringStaticValues"))
     *                                 .build())
     *                         .newParameterName("newParameterName")
     *                         .build())
     *                 .projectOperation(ProjectOperationProperty.builder()
     *                         .projectedColumns(List.of("projectedColumns"))
     *                         .build())
     *                 .renameColumnOperation(RenameColumnOperationProperty.builder()
     *                         .columnName("columnName")
     *                         // the properties below are optional
     *                         .newColumnName("newColumnName")
     *                         .build())
     *                 .tagColumnOperation(TagColumnOperationProperty.builder()
     *                         .columnName("columnName")
     *                         .tags(List.of(ColumnTagProperty.builder()
     *                                 .columnDescription(ColumnDescriptionProperty.builder()
     *                                         .text("text")
     *                                         .build())
     *                                 .columnGeographicRole("columnGeographicRole")
     *                                 .build()))
     *                         .build())
     *                 .untagColumnOperation(UntagColumnOperationProperty.builder()
     *                         .columnName("columnName")
     *                         .tagNames(List.of("tagNames"))
     *                         .build())
     *                 .build()))
     *         .source(LogicalTableSourceProperty.builder()
     *                 .dataSetArn("dataSetArn")
     *                 .joinInstruction(JoinInstructionProperty.builder()
     *                         .leftOperand("leftOperand")
     *                         .onClause("onClause")
     *                         .rightOperand("rightOperand")
     *                         .type("type")
     *                         // the properties below are optional
     *                         .leftJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                                 .uniqueKey(false)
     *                                 .build())
     *                         .rightJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                                 .uniqueKey(false)
     *                                 .build())
     *                         .build())
     *                 .physicalTableId("physicalTableId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.LogicalTableProperty")
    @software.amazon.jsii.Jsii.Proxy(LogicalTableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogicalTableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A display name for the logical table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html#cfn-quicksight-dataset-logicaltable-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html#cfn-quicksight-dataset-logicaltable-alias</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlias();

        /**
         * Transform operations that act on this logical table.
         * <p>
         * For this structure to be valid, only one of the attributes can be non-null.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html#cfn-quicksight-dataset-logicaltable-datatransforms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html#cfn-quicksight-dataset-logicaltable-datatransforms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataTransforms() {
            return null;
        }

        /**
         * Source of this logical table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html#cfn-quicksight-dataset-logicaltable-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltable.html#cfn-quicksight-dataset-logicaltable-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogicalTableProperty> {
            java.lang.String alias;
            java.lang.Object dataTransforms;
            java.lang.Object source;

            /**
             * Sets the value of {@link LogicalTableProperty#getAlias}
             * @param alias A display name for the logical table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alias(java.lang.String alias) {
                this.alias = alias;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableProperty#getDataTransforms}
             * @param dataTransforms Transform operations that act on this logical table.
             *                       For this structure to be valid, only one of the attributes can be non-null.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTransforms(software.amazon.awscdk.IResolvable dataTransforms) {
                this.dataTransforms = dataTransforms;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableProperty#getDataTransforms}
             * @param dataTransforms Transform operations that act on this logical table.
             *                       For this structure to be valid, only one of the attributes can be non-null.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTransforms(java.util.List<? extends java.lang.Object> dataTransforms) {
                this.dataTransforms = dataTransforms;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableProperty#getSource}
             * @param source Source of this logical table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableProperty#getSource}
             * @param source Source of this logical table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.quicksight.CfnDataSet.LogicalTableSourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogicalTableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogicalTableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogicalTableProperty {
            private final java.lang.String alias;
            private final java.lang.Object dataTransforms;
            private final java.lang.Object source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataTransforms = software.amazon.jsii.Kernel.get(this, "dataTransforms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alias = java.util.Objects.requireNonNull(builder.alias, "alias is required");
                this.dataTransforms = builder.dataTransforms;
                this.source = builder.source;
            }

            @Override
            public final java.lang.String getAlias() {
                return this.alias;
            }

            @Override
            public final java.lang.Object getDataTransforms() {
                return this.dataTransforms;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alias", om.valueToTree(this.getAlias()));
                if (this.getDataTransforms() != null) {
                    data.set("dataTransforms", om.valueToTree(this.getDataTransforms()));
                }
                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.LogicalTableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogicalTableProperty.Jsii$Proxy that = (LogicalTableProperty.Jsii$Proxy) o;

                if (!alias.equals(that.alias)) return false;
                if (this.dataTransforms != null ? !this.dataTransforms.equals(that.dataTransforms) : that.dataTransforms != null) return false;
                return this.source != null ? this.source.equals(that.source) : that.source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alias.hashCode();
                result = 31 * result + (this.dataTransforms != null ? this.dataTransforms.hashCode() : 0);
                result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the source of a logical table.
     * <p>
     * This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * LogicalTableSourceProperty logicalTableSourceProperty = LogicalTableSourceProperty.builder()
     *         .dataSetArn("dataSetArn")
     *         .joinInstruction(JoinInstructionProperty.builder()
     *                 .leftOperand("leftOperand")
     *                 .onClause("onClause")
     *                 .rightOperand("rightOperand")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .leftJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                         .uniqueKey(false)
     *                         .build())
     *                 .rightJoinKeyProperties(JoinKeyPropertiesProperty.builder()
     *                         .uniqueKey(false)
     *                         .build())
     *                 .build())
     *         .physicalTableId("physicalTableId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.LogicalTableSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(LogicalTableSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogicalTableSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Number (ARN) of the parent dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html#cfn-quicksight-dataset-logicaltablesource-datasetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html#cfn-quicksight-dataset-logicaltablesource-datasetarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataSetArn() {
            return null;
        }

        /**
         * Specifies the result of a join of two logical tables.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html#cfn-quicksight-dataset-logicaltablesource-joininstruction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html#cfn-quicksight-dataset-logicaltablesource-joininstruction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJoinInstruction() {
            return null;
        }

        /**
         * Physical table ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html#cfn-quicksight-dataset-logicaltablesource-physicaltableid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-logicaltablesource.html#cfn-quicksight-dataset-logicaltablesource-physicaltableid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPhysicalTableId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogicalTableSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogicalTableSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogicalTableSourceProperty> {
            java.lang.String dataSetArn;
            java.lang.Object joinInstruction;
            java.lang.String physicalTableId;

            /**
             * Sets the value of {@link LogicalTableSourceProperty#getDataSetArn}
             * @param dataSetArn The Amazon Resource Number (ARN) of the parent dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSetArn(java.lang.String dataSetArn) {
                this.dataSetArn = dataSetArn;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableSourceProperty#getJoinInstruction}
             * @param joinInstruction Specifies the result of a join of two logical tables.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder joinInstruction(software.amazon.awscdk.IResolvable joinInstruction) {
                this.joinInstruction = joinInstruction;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableSourceProperty#getJoinInstruction}
             * @param joinInstruction Specifies the result of a join of two logical tables.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder joinInstruction(software.amazon.awscdk.services.quicksight.CfnDataSet.JoinInstructionProperty joinInstruction) {
                this.joinInstruction = joinInstruction;
                return this;
            }

            /**
             * Sets the value of {@link LogicalTableSourceProperty#getPhysicalTableId}
             * @param physicalTableId Physical table ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder physicalTableId(java.lang.String physicalTableId) {
                this.physicalTableId = physicalTableId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogicalTableSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogicalTableSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogicalTableSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogicalTableSourceProperty {
            private final java.lang.String dataSetArn;
            private final java.lang.Object joinInstruction;
            private final java.lang.String physicalTableId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSetArn = software.amazon.jsii.Kernel.get(this, "dataSetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.joinInstruction = software.amazon.jsii.Kernel.get(this, "joinInstruction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.physicalTableId = software.amazon.jsii.Kernel.get(this, "physicalTableId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSetArn = builder.dataSetArn;
                this.joinInstruction = builder.joinInstruction;
                this.physicalTableId = builder.physicalTableId;
            }

            @Override
            public final java.lang.String getDataSetArn() {
                return this.dataSetArn;
            }

            @Override
            public final java.lang.Object getJoinInstruction() {
                return this.joinInstruction;
            }

            @Override
            public final java.lang.String getPhysicalTableId() {
                return this.physicalTableId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataSetArn() != null) {
                    data.set("dataSetArn", om.valueToTree(this.getDataSetArn()));
                }
                if (this.getJoinInstruction() != null) {
                    data.set("joinInstruction", om.valueToTree(this.getJoinInstruction()));
                }
                if (this.getPhysicalTableId() != null) {
                    data.set("physicalTableId", om.valueToTree(this.getPhysicalTableId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.LogicalTableSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogicalTableSourceProperty.Jsii$Proxy that = (LogicalTableSourceProperty.Jsii$Proxy) o;

                if (this.dataSetArn != null ? !this.dataSetArn.equals(that.dataSetArn) : that.dataSetArn != null) return false;
                if (this.joinInstruction != null ? !this.joinInstruction.equals(that.joinInstruction) : that.joinInstruction != null) return false;
                return this.physicalTableId != null ? this.physicalTableId.equals(that.physicalTableId) : that.physicalTableId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataSetArn != null ? this.dataSetArn.hashCode() : 0;
                result = 31 * result + (this.joinInstruction != null ? this.joinInstruction.hashCode() : 0);
                result = 31 * result + (this.physicalTableId != null ? this.physicalTableId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The lookback window setup of an incremental refresh configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * LookbackWindowProperty lookbackWindowProperty = LookbackWindowProperty.builder()
     *         .columnName("columnName")
     *         .size(123)
     *         .sizeUnit("sizeUnit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-lookbackwindow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-lookbackwindow.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.LookbackWindowProperty")
    @software.amazon.jsii.Jsii.Proxy(LookbackWindowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LookbackWindowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the lookback window column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-lookbackwindow.html#cfn-quicksight-dataset-lookbackwindow-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-lookbackwindow.html#cfn-quicksight-dataset-lookbackwindow-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * The lookback window column size.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-lookbackwindow.html#cfn-quicksight-dataset-lookbackwindow-size">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-lookbackwindow.html#cfn-quicksight-dataset-lookbackwindow-size</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSize();

        /**
         * The size unit that is used for the lookback window column.
         * <p>
         * Valid values for this structure are <code>HOUR</code> , <code>DAY</code> , and <code>WEEK</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-lookbackwindow.html#cfn-quicksight-dataset-lookbackwindow-sizeunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-lookbackwindow.html#cfn-quicksight-dataset-lookbackwindow-sizeunit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSizeUnit();

        /**
         * @return a {@link Builder} of {@link LookbackWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LookbackWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LookbackWindowProperty> {
            java.lang.String columnName;
            java.lang.Number size;
            java.lang.String sizeUnit;

            /**
             * Sets the value of {@link LookbackWindowProperty#getColumnName}
             * @param columnName The name of the lookback window column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link LookbackWindowProperty#getSize}
             * @param size The lookback window column size. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder size(java.lang.Number size) {
                this.size = size;
                return this;
            }

            /**
             * Sets the value of {@link LookbackWindowProperty#getSizeUnit}
             * @param sizeUnit The size unit that is used for the lookback window column. This parameter is required.
             *                 Valid values for this structure are <code>HOUR</code> , <code>DAY</code> , and <code>WEEK</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeUnit(java.lang.String sizeUnit) {
                this.sizeUnit = sizeUnit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LookbackWindowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LookbackWindowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LookbackWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LookbackWindowProperty {
            private final java.lang.String columnName;
            private final java.lang.Number size;
            private final java.lang.String sizeUnit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sizeUnit = software.amazon.jsii.Kernel.get(this, "sizeUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.size = java.util.Objects.requireNonNull(builder.size, "size is required");
                this.sizeUnit = java.util.Objects.requireNonNull(builder.sizeUnit, "sizeUnit is required");
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.Number getSize() {
                return this.size;
            }

            @Override
            public final java.lang.String getSizeUnit() {
                return this.sizeUnit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("size", om.valueToTree(this.getSize()));
                data.set("sizeUnit", om.valueToTree(this.getSizeUnit()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.LookbackWindowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LookbackWindowProperty.Jsii$Proxy that = (LookbackWindowProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                if (!size.equals(that.size)) return false;
                return this.sizeUnit.equals(that.sizeUnit);
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.size.hashCode());
                result = 31 * result + (this.sizeUnit.hashCode());
                return result;
            }
        }
    }
    /**
     * The new default values for the parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * NewDefaultValuesProperty newDefaultValuesProperty = NewDefaultValuesProperty.builder()
     *         .dateTimeStaticValues(List.of("dateTimeStaticValues"))
     *         .decimalStaticValues(List.of(123))
     *         .integerStaticValues(List.of(123))
     *         .stringStaticValues(List.of("stringStaticValues"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.NewDefaultValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(NewDefaultValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NewDefaultValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of static default values for a given date time parameter.
         * <p>
         * The valid format for this property is <code>yyyy-MM-dd’T’HH:mm:ss’Z’</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html#cfn-quicksight-dataset-newdefaultvalues-datetimestaticvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html#cfn-quicksight-dataset-newdefaultvalues-datetimestaticvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDateTimeStaticValues() {
            return null;
        }

        /**
         * A list of static default values for a given decimal parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html#cfn-quicksight-dataset-newdefaultvalues-decimalstaticvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html#cfn-quicksight-dataset-newdefaultvalues-decimalstaticvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDecimalStaticValues() {
            return null;
        }

        /**
         * A list of static default values for a given integer parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html#cfn-quicksight-dataset-newdefaultvalues-integerstaticvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html#cfn-quicksight-dataset-newdefaultvalues-integerstaticvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntegerStaticValues() {
            return null;
        }

        /**
         * A list of static default values for a given string parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html#cfn-quicksight-dataset-newdefaultvalues-stringstaticvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-newdefaultvalues.html#cfn-quicksight-dataset-newdefaultvalues-stringstaticvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStringStaticValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NewDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NewDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NewDefaultValuesProperty> {
            java.util.List<java.lang.String> dateTimeStaticValues;
            java.lang.Object decimalStaticValues;
            java.lang.Object integerStaticValues;
            java.util.List<java.lang.String> stringStaticValues;

            /**
             * Sets the value of {@link NewDefaultValuesProperty#getDateTimeStaticValues}
             * @param dateTimeStaticValues A list of static default values for a given date time parameter.
             *                             The valid format for this property is <code>yyyy-MM-dd’T’HH:mm:ss’Z’</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateTimeStaticValues(java.util.List<java.lang.String> dateTimeStaticValues) {
                this.dateTimeStaticValues = dateTimeStaticValues;
                return this;
            }

            /**
             * Sets the value of {@link NewDefaultValuesProperty#getDecimalStaticValues}
             * @param decimalStaticValues A list of static default values for a given decimal parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decimalStaticValues(java.util.List<? extends java.lang.Number> decimalStaticValues) {
                this.decimalStaticValues = decimalStaticValues;
                return this;
            }

            /**
             * Sets the value of {@link NewDefaultValuesProperty#getDecimalStaticValues}
             * @param decimalStaticValues A list of static default values for a given decimal parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decimalStaticValues(software.amazon.awscdk.IResolvable decimalStaticValues) {
                this.decimalStaticValues = decimalStaticValues;
                return this;
            }

            /**
             * Sets the value of {@link NewDefaultValuesProperty#getIntegerStaticValues}
             * @param integerStaticValues A list of static default values for a given integer parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerStaticValues(java.util.List<? extends java.lang.Number> integerStaticValues) {
                this.integerStaticValues = integerStaticValues;
                return this;
            }

            /**
             * Sets the value of {@link NewDefaultValuesProperty#getIntegerStaticValues}
             * @param integerStaticValues A list of static default values for a given integer parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerStaticValues(software.amazon.awscdk.IResolvable integerStaticValues) {
                this.integerStaticValues = integerStaticValues;
                return this;
            }

            /**
             * Sets the value of {@link NewDefaultValuesProperty#getStringStaticValues}
             * @param stringStaticValues A list of static default values for a given string parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringStaticValues(java.util.List<java.lang.String> stringStaticValues) {
                this.stringStaticValues = stringStaticValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NewDefaultValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NewDefaultValuesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NewDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NewDefaultValuesProperty {
            private final java.util.List<java.lang.String> dateTimeStaticValues;
            private final java.lang.Object decimalStaticValues;
            private final java.lang.Object integerStaticValues;
            private final java.util.List<java.lang.String> stringStaticValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dateTimeStaticValues = software.amazon.jsii.Kernel.get(this, "dateTimeStaticValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.decimalStaticValues = software.amazon.jsii.Kernel.get(this, "decimalStaticValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.integerStaticValues = software.amazon.jsii.Kernel.get(this, "integerStaticValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stringStaticValues = software.amazon.jsii.Kernel.get(this, "stringStaticValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dateTimeStaticValues = builder.dateTimeStaticValues;
                this.decimalStaticValues = builder.decimalStaticValues;
                this.integerStaticValues = builder.integerStaticValues;
                this.stringStaticValues = builder.stringStaticValues;
            }

            @Override
            public final java.util.List<java.lang.String> getDateTimeStaticValues() {
                return this.dateTimeStaticValues;
            }

            @Override
            public final java.lang.Object getDecimalStaticValues() {
                return this.decimalStaticValues;
            }

            @Override
            public final java.lang.Object getIntegerStaticValues() {
                return this.integerStaticValues;
            }

            @Override
            public final java.util.List<java.lang.String> getStringStaticValues() {
                return this.stringStaticValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDateTimeStaticValues() != null) {
                    data.set("dateTimeStaticValues", om.valueToTree(this.getDateTimeStaticValues()));
                }
                if (this.getDecimalStaticValues() != null) {
                    data.set("decimalStaticValues", om.valueToTree(this.getDecimalStaticValues()));
                }
                if (this.getIntegerStaticValues() != null) {
                    data.set("integerStaticValues", om.valueToTree(this.getIntegerStaticValues()));
                }
                if (this.getStringStaticValues() != null) {
                    data.set("stringStaticValues", om.valueToTree(this.getStringStaticValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.NewDefaultValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NewDefaultValuesProperty.Jsii$Proxy that = (NewDefaultValuesProperty.Jsii$Proxy) o;

                if (this.dateTimeStaticValues != null ? !this.dateTimeStaticValues.equals(that.dateTimeStaticValues) : that.dateTimeStaticValues != null) return false;
                if (this.decimalStaticValues != null ? !this.decimalStaticValues.equals(that.decimalStaticValues) : that.decimalStaticValues != null) return false;
                if (this.integerStaticValues != null ? !this.integerStaticValues.equals(that.integerStaticValues) : that.integerStaticValues != null) return false;
                return this.stringStaticValues != null ? this.stringStaticValues.equals(that.stringStaticValues) : that.stringStaticValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dateTimeStaticValues != null ? this.dateTimeStaticValues.hashCode() : 0;
                result = 31 * result + (this.decimalStaticValues != null ? this.decimalStaticValues.hashCode() : 0);
                result = 31 * result + (this.integerStaticValues != null ? this.integerStaticValues.hashCode() : 0);
                result = 31 * result + (this.stringStaticValues != null ? this.stringStaticValues.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Output column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * OutputColumnProperty outputColumnProperty = OutputColumnProperty.builder()
     *         .description("description")
     *         .name("name")
     *         .subType("subType")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.OutputColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A description for a column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The display name of the column..
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The sub data type of the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-subtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-subtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubType() {
            return null;
        }

        /**
         * The data type of the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-outputcolumn.html#cfn-quicksight-dataset-outputcolumn-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputColumnProperty> {
            java.lang.String description;
            java.lang.String name;
            java.lang.String subType;
            java.lang.String type;

            /**
             * Sets the value of {@link OutputColumnProperty#getDescription}
             * @param description A description for a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link OutputColumnProperty#getName}
             * @param name The display name of the column..
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link OutputColumnProperty#getSubType}
             * @param subType The sub data type of the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subType(java.lang.String subType) {
                this.subType = subType;
                return this;
            }

            /**
             * Sets the value of {@link OutputColumnProperty#getType}
             * @param type The data type of the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputColumnProperty {
            private final java.lang.String description;
            private final java.lang.String name;
            private final java.lang.String subType;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subType = software.amazon.jsii.Kernel.get(this, "subType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.description = builder.description;
                this.name = builder.name;
                this.subType = builder.subType;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSubType() {
                return this.subType;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getSubType() != null) {
                    data.set("subType", om.valueToTree(this.getSubType()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.OutputColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputColumnProperty.Jsii$Proxy that = (OutputColumnProperty.Jsii$Proxy) o;

                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.subType != null ? !this.subType.equals(that.subType) : that.subType != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.description != null ? this.description.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.subType != null ? this.subType.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that overrides the dataset parameter values that are defined in another dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * OverrideDatasetParameterOperationProperty overrideDatasetParameterOperationProperty = OverrideDatasetParameterOperationProperty.builder()
     *         .parameterName("parameterName")
     *         // the properties below are optional
     *         .newDefaultValues(NewDefaultValuesProperty.builder()
     *                 .dateTimeStaticValues(List.of("dateTimeStaticValues"))
     *                 .decimalStaticValues(List.of(123))
     *                 .integerStaticValues(List.of(123))
     *                 .stringStaticValues(List.of("stringStaticValues"))
     *                 .build())
     *         .newParameterName("newParameterName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-overridedatasetparameteroperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-overridedatasetparameteroperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.OverrideDatasetParameterOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(OverrideDatasetParameterOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OverrideDatasetParameterOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the parameter to be overridden with different values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-overridedatasetparameteroperation.html#cfn-quicksight-dataset-overridedatasetparameteroperation-parametername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-overridedatasetparameteroperation.html#cfn-quicksight-dataset-overridedatasetparameteroperation-parametername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParameterName();

        /**
         * The new default values for the parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-overridedatasetparameteroperation.html#cfn-quicksight-dataset-overridedatasetparameteroperation-newdefaultvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-overridedatasetparameteroperation.html#cfn-quicksight-dataset-overridedatasetparameteroperation-newdefaultvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNewDefaultValues() {
            return null;
        }

        /**
         * The new name for the parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-overridedatasetparameteroperation.html#cfn-quicksight-dataset-overridedatasetparameteroperation-newparametername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-overridedatasetparameteroperation.html#cfn-quicksight-dataset-overridedatasetparameteroperation-newparametername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNewParameterName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OverrideDatasetParameterOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OverrideDatasetParameterOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OverrideDatasetParameterOperationProperty> {
            java.lang.String parameterName;
            java.lang.Object newDefaultValues;
            java.lang.String newParameterName;

            /**
             * Sets the value of {@link OverrideDatasetParameterOperationProperty#getParameterName}
             * @param parameterName The name of the parameter to be overridden with different values. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterName(java.lang.String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            /**
             * Sets the value of {@link OverrideDatasetParameterOperationProperty#getNewDefaultValues}
             * @param newDefaultValues The new default values for the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newDefaultValues(software.amazon.awscdk.IResolvable newDefaultValues) {
                this.newDefaultValues = newDefaultValues;
                return this;
            }

            /**
             * Sets the value of {@link OverrideDatasetParameterOperationProperty#getNewDefaultValues}
             * @param newDefaultValues The new default values for the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newDefaultValues(software.amazon.awscdk.services.quicksight.CfnDataSet.NewDefaultValuesProperty newDefaultValues) {
                this.newDefaultValues = newDefaultValues;
                return this;
            }

            /**
             * Sets the value of {@link OverrideDatasetParameterOperationProperty#getNewParameterName}
             * @param newParameterName The new name for the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newParameterName(java.lang.String newParameterName) {
                this.newParameterName = newParameterName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OverrideDatasetParameterOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OverrideDatasetParameterOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OverrideDatasetParameterOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OverrideDatasetParameterOperationProperty {
            private final java.lang.String parameterName;
            private final java.lang.Object newDefaultValues;
            private final java.lang.String newParameterName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parameterName = software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.newDefaultValues = software.amazon.jsii.Kernel.get(this, "newDefaultValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.newParameterName = software.amazon.jsii.Kernel.get(this, "newParameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parameterName = java.util.Objects.requireNonNull(builder.parameterName, "parameterName is required");
                this.newDefaultValues = builder.newDefaultValues;
                this.newParameterName = builder.newParameterName;
            }

            @Override
            public final java.lang.String getParameterName() {
                return this.parameterName;
            }

            @Override
            public final java.lang.Object getNewDefaultValues() {
                return this.newDefaultValues;
            }

            @Override
            public final java.lang.String getNewParameterName() {
                return this.newParameterName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("parameterName", om.valueToTree(this.getParameterName()));
                if (this.getNewDefaultValues() != null) {
                    data.set("newDefaultValues", om.valueToTree(this.getNewDefaultValues()));
                }
                if (this.getNewParameterName() != null) {
                    data.set("newParameterName", om.valueToTree(this.getNewParameterName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.OverrideDatasetParameterOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OverrideDatasetParameterOperationProperty.Jsii$Proxy that = (OverrideDatasetParameterOperationProperty.Jsii$Proxy) o;

                if (!parameterName.equals(that.parameterName)) return false;
                if (this.newDefaultValues != null ? !this.newDefaultValues.equals(that.newDefaultValues) : that.newDefaultValues != null) return false;
                return this.newParameterName != null ? this.newParameterName.equals(that.newParameterName) : that.newParameterName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.parameterName.hashCode();
                result = 31 * result + (this.newDefaultValues != null ? this.newDefaultValues.hashCode() : 0);
                result = 31 * result + (this.newParameterName != null ? this.newParameterName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * PerformanceConfigurationProperty performanceConfigurationProperty = PerformanceConfigurationProperty.builder()
     *         .uniqueKeys(List.of(UniqueKeyProperty.builder()
     *                 .columnNames(List.of("columnNames"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-performanceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-performanceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.PerformanceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PerformanceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PerformanceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-performanceconfiguration.html#cfn-quicksight-dataset-performanceconfiguration-uniquekeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-performanceconfiguration.html#cfn-quicksight-dataset-performanceconfiguration-uniquekeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUniqueKeys() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PerformanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PerformanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PerformanceConfigurationProperty> {
            java.lang.Object uniqueKeys;

            /**
             * Sets the value of {@link PerformanceConfigurationProperty#getUniqueKeys}
             * @param uniqueKeys the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uniqueKeys(software.amazon.awscdk.IResolvable uniqueKeys) {
                this.uniqueKeys = uniqueKeys;
                return this;
            }

            /**
             * Sets the value of {@link PerformanceConfigurationProperty#getUniqueKeys}
             * @param uniqueKeys the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uniqueKeys(java.util.List<? extends java.lang.Object> uniqueKeys) {
                this.uniqueKeys = uniqueKeys;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PerformanceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PerformanceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PerformanceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PerformanceConfigurationProperty {
            private final java.lang.Object uniqueKeys;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.uniqueKeys = software.amazon.jsii.Kernel.get(this, "uniqueKeys", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.uniqueKeys = builder.uniqueKeys;
            }

            @Override
            public final java.lang.Object getUniqueKeys() {
                return this.uniqueKeys;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getUniqueKeys() != null) {
                    data.set("uniqueKeys", om.valueToTree(this.getUniqueKeys()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.PerformanceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PerformanceConfigurationProperty.Jsii$Proxy that = (PerformanceConfigurationProperty.Jsii$Proxy) o;

                return this.uniqueKeys != null ? this.uniqueKeys.equals(that.uniqueKeys) : that.uniqueKeys == null;
            }

            @Override
            public final int hashCode() {
                int result = this.uniqueKeys != null ? this.uniqueKeys.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A view of a data source that contains information about the shape of the data in the underlying source.
     * <p>
     * This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * PhysicalTableProperty physicalTableProperty = PhysicalTableProperty.builder()
     *         .customSql(CustomSqlProperty.builder()
     *                 .dataSourceArn("dataSourceArn")
     *                 .name("name")
     *                 .sqlQuery("sqlQuery")
     *                 // the properties below are optional
     *                 .columns(List.of(InputColumnProperty.builder()
     *                         .name("name")
     *                         .type("type")
     *                         // the properties below are optional
     *                         .subType("subType")
     *                         .build()))
     *                 .build())
     *         .relationalTable(RelationalTableProperty.builder()
     *                 .dataSourceArn("dataSourceArn")
     *                 .name("name")
     *                 // the properties below are optional
     *                 .catalog("catalog")
     *                 .inputColumns(List.of(InputColumnProperty.builder()
     *                         .name("name")
     *                         .type("type")
     *                         // the properties below are optional
     *                         .subType("subType")
     *                         .build()))
     *                 .schema("schema")
     *                 .build())
     *         .s3Source(S3SourceProperty.builder()
     *                 .dataSourceArn("dataSourceArn")
     *                 // the properties below are optional
     *                 .inputColumns(List.of(InputColumnProperty.builder()
     *                         .name("name")
     *                         .type("type")
     *                         // the properties below are optional
     *                         .subType("subType")
     *                         .build()))
     *                 .uploadSettings(UploadSettingsProperty.builder()
     *                         .containsHeader(false)
     *                         .delimiter("delimiter")
     *                         .format("format")
     *                         .startFromRow(123)
     *                         .textQualifier("textQualifier")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.PhysicalTableProperty")
    @software.amazon.jsii.Jsii.Proxy(PhysicalTableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PhysicalTableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A physical table type built from the results of the custom SQL query.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-customsql">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-customsql</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomSql() {
            return null;
        }

        /**
         * A physical table type for relational data sources.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-relationaltable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-relationaltable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelationalTable() {
            return null;
        }

        /**
         * A physical table type for as S3 data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-s3source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-physicaltable.html#cfn-quicksight-dataset-physicaltable-s3source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Source() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PhysicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PhysicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PhysicalTableProperty> {
            java.lang.Object customSql;
            java.lang.Object relationalTable;
            java.lang.Object s3Source;

            /**
             * Sets the value of {@link PhysicalTableProperty#getCustomSql}
             * @param customSql A physical table type built from the results of the custom SQL query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customSql(software.amazon.awscdk.IResolvable customSql) {
                this.customSql = customSql;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getCustomSql}
             * @param customSql A physical table type built from the results of the custom SQL query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customSql(software.amazon.awscdk.services.quicksight.CfnDataSet.CustomSqlProperty customSql) {
                this.customSql = customSql;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getRelationalTable}
             * @param relationalTable A physical table type for relational data sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationalTable(software.amazon.awscdk.IResolvable relationalTable) {
                this.relationalTable = relationalTable;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getRelationalTable}
             * @param relationalTable A physical table type for relational data sources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationalTable(software.amazon.awscdk.services.quicksight.CfnDataSet.RelationalTableProperty relationalTable) {
                this.relationalTable = relationalTable;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getS3Source}
             * @param s3Source A physical table type for as S3 data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Source(software.amazon.awscdk.IResolvable s3Source) {
                this.s3Source = s3Source;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalTableProperty#getS3Source}
             * @param s3Source A physical table type for as S3 data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Source(software.amazon.awscdk.services.quicksight.CfnDataSet.S3SourceProperty s3Source) {
                this.s3Source = s3Source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PhysicalTableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PhysicalTableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PhysicalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PhysicalTableProperty {
            private final java.lang.Object customSql;
            private final java.lang.Object relationalTable;
            private final java.lang.Object s3Source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customSql = software.amazon.jsii.Kernel.get(this, "customSql", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.relationalTable = software.amazon.jsii.Kernel.get(this, "relationalTable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Source = software.amazon.jsii.Kernel.get(this, "s3Source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customSql = builder.customSql;
                this.relationalTable = builder.relationalTable;
                this.s3Source = builder.s3Source;
            }

            @Override
            public final java.lang.Object getCustomSql() {
                return this.customSql;
            }

            @Override
            public final java.lang.Object getRelationalTable() {
                return this.relationalTable;
            }

            @Override
            public final java.lang.Object getS3Source() {
                return this.s3Source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomSql() != null) {
                    data.set("customSql", om.valueToTree(this.getCustomSql()));
                }
                if (this.getRelationalTable() != null) {
                    data.set("relationalTable", om.valueToTree(this.getRelationalTable()));
                }
                if (this.getS3Source() != null) {
                    data.set("s3Source", om.valueToTree(this.getS3Source()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.PhysicalTableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PhysicalTableProperty.Jsii$Proxy that = (PhysicalTableProperty.Jsii$Proxy) o;

                if (this.customSql != null ? !this.customSql.equals(that.customSql) : that.customSql != null) return false;
                if (this.relationalTable != null ? !this.relationalTable.equals(that.relationalTable) : that.relationalTable != null) return false;
                return this.s3Source != null ? this.s3Source.equals(that.s3Source) : that.s3Source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customSql != null ? this.customSql.hashCode() : 0;
                result = 31 * result + (this.relationalTable != null ? this.relationalTable.hashCode() : 0);
                result = 31 * result + (this.s3Source != null ? this.s3Source.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that projects columns.
     * <p>
     * Operations that come after a projection can only refer to projected columns.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ProjectOperationProperty projectOperationProperty = ProjectOperationProperty.builder()
     *         .projectedColumns(List.of("projectedColumns"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.ProjectOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(ProjectOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProjectOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Projected columns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html#cfn-quicksight-dataset-projectoperation-projectedcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-projectoperation.html#cfn-quicksight-dataset-projectoperation-projectedcolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getProjectedColumns();

        /**
         * @return a {@link Builder} of {@link ProjectOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProjectOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProjectOperationProperty> {
            java.util.List<java.lang.String> projectedColumns;

            /**
             * Sets the value of {@link ProjectOperationProperty#getProjectedColumns}
             * @param projectedColumns Projected columns. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projectedColumns(java.util.List<java.lang.String> projectedColumns) {
                this.projectedColumns = projectedColumns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProjectOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProjectOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProjectOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProjectOperationProperty {
            private final java.util.List<java.lang.String> projectedColumns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.projectedColumns = software.amazon.jsii.Kernel.get(this, "projectedColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.projectedColumns = java.util.Objects.requireNonNull(builder.projectedColumns, "projectedColumns is required");
            }

            @Override
            public final java.util.List<java.lang.String> getProjectedColumns() {
                return this.projectedColumns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("projectedColumns", om.valueToTree(this.getProjectedColumns()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.ProjectOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProjectOperationProperty.Jsii$Proxy that = (ProjectOperationProperty.Jsii$Proxy) o;

                return this.projectedColumns.equals(that.projectedColumns);
            }

            @Override
            public final int hashCode() {
                int result = this.projectedColumns.hashCode();
                return result;
            }
        }
    }
    /**
     * The refresh configuration of a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RefreshConfigurationProperty refreshConfigurationProperty = RefreshConfigurationProperty.builder()
     *         .incrementalRefresh(IncrementalRefreshProperty.builder()
     *                 .lookbackWindow(LookbackWindowProperty.builder()
     *                         .columnName("columnName")
     *                         .size(123)
     *                         .sizeUnit("sizeUnit")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.RefreshConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RefreshConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RefreshConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The incremental refresh for the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshconfiguration.html#cfn-quicksight-dataset-refreshconfiguration-incrementalrefresh">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshconfiguration.html#cfn-quicksight-dataset-refreshconfiguration-incrementalrefresh</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIncrementalRefresh();

        /**
         * @return a {@link Builder} of {@link RefreshConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RefreshConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RefreshConfigurationProperty> {
            java.lang.Object incrementalRefresh;

            /**
             * Sets the value of {@link RefreshConfigurationProperty#getIncrementalRefresh}
             * @param incrementalRefresh The incremental refresh for the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder incrementalRefresh(software.amazon.awscdk.IResolvable incrementalRefresh) {
                this.incrementalRefresh = incrementalRefresh;
                return this;
            }

            /**
             * Sets the value of {@link RefreshConfigurationProperty#getIncrementalRefresh}
             * @param incrementalRefresh The incremental refresh for the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder incrementalRefresh(software.amazon.awscdk.services.quicksight.CfnDataSet.IncrementalRefreshProperty incrementalRefresh) {
                this.incrementalRefresh = incrementalRefresh;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RefreshConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RefreshConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RefreshConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RefreshConfigurationProperty {
            private final java.lang.Object incrementalRefresh;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.incrementalRefresh = software.amazon.jsii.Kernel.get(this, "incrementalRefresh", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.incrementalRefresh = java.util.Objects.requireNonNull(builder.incrementalRefresh, "incrementalRefresh is required");
            }

            @Override
            public final java.lang.Object getIncrementalRefresh() {
                return this.incrementalRefresh;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("incrementalRefresh", om.valueToTree(this.getIncrementalRefresh()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.RefreshConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RefreshConfigurationProperty.Jsii$Proxy that = (RefreshConfigurationProperty.Jsii$Proxy) o;

                return this.incrementalRefresh.equals(that.incrementalRefresh);
            }

            @Override
            public final int hashCode() {
                int result = this.incrementalRefresh.hashCode();
                return result;
            }
        }
    }
    /**
     * The failure configuration of a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RefreshFailureConfigurationProperty refreshFailureConfigurationProperty = RefreshFailureConfigurationProperty.builder()
     *         .emailAlert(RefreshFailureEmailAlertProperty.builder()
     *                 .alertStatus("alertStatus")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshfailureconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshfailureconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.RefreshFailureConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RefreshFailureConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RefreshFailureConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The email alert configuration for a dataset refresh failure.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshfailureconfiguration.html#cfn-quicksight-dataset-refreshfailureconfiguration-emailalert">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshfailureconfiguration.html#cfn-quicksight-dataset-refreshfailureconfiguration-emailalert</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmailAlert() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RefreshFailureConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RefreshFailureConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RefreshFailureConfigurationProperty> {
            java.lang.Object emailAlert;

            /**
             * Sets the value of {@link RefreshFailureConfigurationProperty#getEmailAlert}
             * @param emailAlert The email alert configuration for a dataset refresh failure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailAlert(software.amazon.awscdk.IResolvable emailAlert) {
                this.emailAlert = emailAlert;
                return this;
            }

            /**
             * Sets the value of {@link RefreshFailureConfigurationProperty#getEmailAlert}
             * @param emailAlert The email alert configuration for a dataset refresh failure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailAlert(software.amazon.awscdk.services.quicksight.CfnDataSet.RefreshFailureEmailAlertProperty emailAlert) {
                this.emailAlert = emailAlert;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RefreshFailureConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RefreshFailureConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RefreshFailureConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RefreshFailureConfigurationProperty {
            private final java.lang.Object emailAlert;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.emailAlert = software.amazon.jsii.Kernel.get(this, "emailAlert", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.emailAlert = builder.emailAlert;
            }

            @Override
            public final java.lang.Object getEmailAlert() {
                return this.emailAlert;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEmailAlert() != null) {
                    data.set("emailAlert", om.valueToTree(this.getEmailAlert()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.RefreshFailureConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RefreshFailureConfigurationProperty.Jsii$Proxy that = (RefreshFailureConfigurationProperty.Jsii$Proxy) o;

                return this.emailAlert != null ? this.emailAlert.equals(that.emailAlert) : that.emailAlert == null;
            }

            @Override
            public final int hashCode() {
                int result = this.emailAlert != null ? this.emailAlert.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration settings for the email alerts that are sent when a dataset refresh fails.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RefreshFailureEmailAlertProperty refreshFailureEmailAlertProperty = RefreshFailureEmailAlertProperty.builder()
     *         .alertStatus("alertStatus")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshfailureemailalert.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshfailureemailalert.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.RefreshFailureEmailAlertProperty")
    @software.amazon.jsii.Jsii.Proxy(RefreshFailureEmailAlertProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RefreshFailureEmailAlertProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The status value that determines if email alerts are sent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshfailureemailalert.html#cfn-quicksight-dataset-refreshfailureemailalert-alertstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-refreshfailureemailalert.html#cfn-quicksight-dataset-refreshfailureemailalert-alertstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlertStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RefreshFailureEmailAlertProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RefreshFailureEmailAlertProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RefreshFailureEmailAlertProperty> {
            java.lang.String alertStatus;

            /**
             * Sets the value of {@link RefreshFailureEmailAlertProperty#getAlertStatus}
             * @param alertStatus The status value that determines if email alerts are sent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alertStatus(java.lang.String alertStatus) {
                this.alertStatus = alertStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RefreshFailureEmailAlertProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RefreshFailureEmailAlertProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RefreshFailureEmailAlertProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RefreshFailureEmailAlertProperty {
            private final java.lang.String alertStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alertStatus = software.amazon.jsii.Kernel.get(this, "alertStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alertStatus = builder.alertStatus;
            }

            @Override
            public final java.lang.String getAlertStatus() {
                return this.alertStatus;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlertStatus() != null) {
                    data.set("alertStatus", om.valueToTree(this.getAlertStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.RefreshFailureEmailAlertProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RefreshFailureEmailAlertProperty.Jsii$Proxy that = (RefreshFailureEmailAlertProperty.Jsii$Proxy) o;

                return this.alertStatus != null ? this.alertStatus.equals(that.alertStatus) : that.alertStatus == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alertStatus != null ? this.alertStatus.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A physical table type for relational data sources.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RelationalTableProperty relationalTableProperty = RelationalTableProperty.builder()
     *         .dataSourceArn("dataSourceArn")
     *         .name("name")
     *         // the properties below are optional
     *         .catalog("catalog")
     *         .inputColumns(List.of(InputColumnProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .subType("subType")
     *                 .build()))
     *         .schema("schema")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.RelationalTableProperty")
    @software.amazon.jsii.Jsii.Proxy(RelationalTableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RelationalTableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) for the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-datasourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-datasourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSourceArn();

        /**
         * The name of the relational table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The catalog associated with a table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-catalog">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-catalog</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCatalog() {
            return null;
        }

        /**
         * The column schema of the table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-inputcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-inputcolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputColumns() {
            return null;
        }

        /**
         * The schema name.
         * <p>
         * This name applies to certain relational database engines.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-schema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-relationaltable.html#cfn-quicksight-dataset-relationaltable-schema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSchema() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RelationalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RelationalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RelationalTableProperty> {
            java.lang.String dataSourceArn;
            java.lang.String name;
            java.lang.String catalog;
            java.lang.Object inputColumns;
            java.lang.String schema;

            /**
             * Sets the value of {@link RelationalTableProperty#getDataSourceArn}
             * @param dataSourceArn The Amazon Resource Name (ARN) for the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSourceArn(java.lang.String dataSourceArn) {
                this.dataSourceArn = dataSourceArn;
                return this;
            }

            /**
             * Sets the value of {@link RelationalTableProperty#getName}
             * @param name The name of the relational table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RelationalTableProperty#getCatalog}
             * @param catalog The catalog associated with a table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalog(java.lang.String catalog) {
                this.catalog = catalog;
                return this;
            }

            /**
             * Sets the value of {@link RelationalTableProperty#getInputColumns}
             * @param inputColumns The column schema of the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputColumns(software.amazon.awscdk.IResolvable inputColumns) {
                this.inputColumns = inputColumns;
                return this;
            }

            /**
             * Sets the value of {@link RelationalTableProperty#getInputColumns}
             * @param inputColumns The column schema of the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputColumns(java.util.List<? extends java.lang.Object> inputColumns) {
                this.inputColumns = inputColumns;
                return this;
            }

            /**
             * Sets the value of {@link RelationalTableProperty#getSchema}
             * @param schema The schema name.
             *               This name applies to certain relational database engines.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schema(java.lang.String schema) {
                this.schema = schema;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RelationalTableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RelationalTableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RelationalTableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RelationalTableProperty {
            private final java.lang.String dataSourceArn;
            private final java.lang.String name;
            private final java.lang.String catalog;
            private final java.lang.Object inputColumns;
            private final java.lang.String schema;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSourceArn = software.amazon.jsii.Kernel.get(this, "dataSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.catalog = software.amazon.jsii.Kernel.get(this, "catalog", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputColumns = software.amazon.jsii.Kernel.get(this, "inputColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.schema = software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSourceArn = java.util.Objects.requireNonNull(builder.dataSourceArn, "dataSourceArn is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.catalog = builder.catalog;
                this.inputColumns = builder.inputColumns;
                this.schema = builder.schema;
            }

            @Override
            public final java.lang.String getDataSourceArn() {
                return this.dataSourceArn;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getCatalog() {
                return this.catalog;
            }

            @Override
            public final java.lang.Object getInputColumns() {
                return this.inputColumns;
            }

            @Override
            public final java.lang.String getSchema() {
                return this.schema;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSourceArn", om.valueToTree(this.getDataSourceArn()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getCatalog() != null) {
                    data.set("catalog", om.valueToTree(this.getCatalog()));
                }
                if (this.getInputColumns() != null) {
                    data.set("inputColumns", om.valueToTree(this.getInputColumns()));
                }
                if (this.getSchema() != null) {
                    data.set("schema", om.valueToTree(this.getSchema()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.RelationalTableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RelationalTableProperty.Jsii$Proxy that = (RelationalTableProperty.Jsii$Proxy) o;

                if (!dataSourceArn.equals(that.dataSourceArn)) return false;
                if (!name.equals(that.name)) return false;
                if (this.catalog != null ? !this.catalog.equals(that.catalog) : that.catalog != null) return false;
                if (this.inputColumns != null ? !this.inputColumns.equals(that.inputColumns) : that.inputColumns != null) return false;
                return this.schema != null ? this.schema.equals(that.schema) : that.schema == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataSourceArn.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.catalog != null ? this.catalog.hashCode() : 0);
                result = 31 * result + (this.inputColumns != null ? this.inputColumns.hashCode() : 0);
                result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that renames a column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RenameColumnOperationProperty renameColumnOperationProperty = RenameColumnOperationProperty.builder()
     *         .columnName("columnName")
     *         // the properties below are optional
     *         .newColumnName("newColumnName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.RenameColumnOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(RenameColumnOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RenameColumnOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column to be renamed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnoperation.html#cfn-quicksight-dataset-renamecolumnoperation-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnoperation.html#cfn-quicksight-dataset-renamecolumnoperation-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * The new name for the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnoperation.html#cfn-quicksight-dataset-renamecolumnoperation-newcolumnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-renamecolumnoperation.html#cfn-quicksight-dataset-renamecolumnoperation-newcolumnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNewColumnName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RenameColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RenameColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RenameColumnOperationProperty> {
            java.lang.String columnName;
            java.lang.String newColumnName;

            /**
             * Sets the value of {@link RenameColumnOperationProperty#getColumnName}
             * @param columnName The name of the column to be renamed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link RenameColumnOperationProperty#getNewColumnName}
             * @param newColumnName The new name for the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newColumnName(java.lang.String newColumnName) {
                this.newColumnName = newColumnName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RenameColumnOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RenameColumnOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RenameColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RenameColumnOperationProperty {
            private final java.lang.String columnName;
            private final java.lang.String newColumnName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.newColumnName = software.amazon.jsii.Kernel.get(this, "newColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.newColumnName = builder.newColumnName;
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.String getNewColumnName() {
                return this.newColumnName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                if (this.getNewColumnName() != null) {
                    data.set("newColumnName", om.valueToTree(this.getNewColumnName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.RenameColumnOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RenameColumnOperationProperty.Jsii$Proxy that = (RenameColumnOperationProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                return this.newColumnName != null ? this.newColumnName.equals(that.newColumnName) : that.newColumnName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.newColumnName != null ? this.newColumnName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Permission for the resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ResourcePermissionProperty resourcePermissionProperty = ResourcePermissionProperty.builder()
     *         .actions(List.of("actions"))
     *         .principal("principal")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-resourcepermission.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-resourcepermission.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.ResourcePermissionProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourcePermissionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourcePermissionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IAM action to grant or revoke permisions on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-resourcepermission.html#cfn-quicksight-dataset-resourcepermission-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-resourcepermission.html#cfn-quicksight-dataset-resourcepermission-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getActions();

        /**
         * The Amazon Resource Name (ARN) of the principal. This can be one of the following:.
         * <p>
         * <ul>
         * <li>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</li>
         * <li>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</li>
         * <li>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-resourcepermission.html#cfn-quicksight-dataset-resourcepermission-principal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-resourcepermission.html#cfn-quicksight-dataset-resourcepermission-principal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrincipal();

        /**
         * @return a {@link Builder} of {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourcePermissionProperty> {
            java.util.List<java.lang.String> actions;
            java.lang.String principal;

            /**
             * Sets the value of {@link ResourcePermissionProperty#getActions}
             * @param actions The IAM action to grant or revoke permisions on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<java.lang.String> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link ResourcePermissionProperty#getPrincipal}
             * @param principal The Amazon Resource Name (ARN) of the principal. This can be one of the following:. This parameter is required.
             *                  <ul>
             *                  <li>The ARN of an Amazon QuickSight user or group associated with a data source or dataset. (This is common.)</li>
             *                  <li>The ARN of an Amazon QuickSight user, group, or namespace associated with an analysis, dashboard, template, or theme. (This is common.)</li>
             *                  <li>The ARN of an AWS account root: This is an IAM ARN rather than a QuickSight ARN. Use this option only to share resources (templates) across AWS accounts . (This is less common.)</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principal(java.lang.String principal) {
                this.principal = principal;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourcePermissionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourcePermissionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourcePermissionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcePermissionProperty {
            private final java.util.List<java.lang.String> actions;
            private final java.lang.String principal;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
                this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
            }

            @Override
            public final java.util.List<java.lang.String> getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.String getPrincipal() {
                return this.principal;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                data.set("principal", om.valueToTree(this.getPrincipal()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.ResourcePermissionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourcePermissionProperty.Jsii$Proxy that = (ResourcePermissionProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                return this.principal.equals(that.principal);
            }

            @Override
            public final int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.principal.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about a dataset that contains permissions for row-level security (RLS).
     * <p>
     * The permissions dataset maps fields to users or groups. For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/restrict-access-to-a-data-set-using-row-level-security.html">Using Row-Level Security (RLS) to Restrict Access to a Dataset</a> in the <em>Amazon QuickSight User Guide</em> .
     * <p>
     * The option to deny permissions by setting <code>PermissionPolicy</code> to <code>DENY_ACCESS</code> is not supported for new RLS datasets.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RowLevelPermissionDataSetProperty rowLevelPermissionDataSetProperty = RowLevelPermissionDataSetProperty.builder()
     *         .arn("arn")
     *         .permissionPolicy("permissionPolicy")
     *         // the properties below are optional
     *         .formatVersion("formatVersion")
     *         .namespace("namespace")
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.RowLevelPermissionDataSetProperty")
    @software.amazon.jsii.Jsii.Proxy(RowLevelPermissionDataSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RowLevelPermissionDataSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * The type of permissions to use when interpreting the permissions for RLS.
         * <p>
         * <code>DENY_ACCESS</code> is included for backward compatibility only.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-permissionpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-permissionpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPermissionPolicy();

        /**
         * The user or group rules associated with the dataset that contains permissions for RLS.
         * <p>
         * By default, <code>FormatVersion</code> is <code>VERSION_1</code> . When <code>FormatVersion</code> is <code>VERSION_1</code> , <code>UserName</code> and <code>GroupName</code> are required. When <code>FormatVersion</code> is <code>VERSION_2</code> , <code>UserARN</code> and <code>GroupARN</code> are required, and <code>Namespace</code> must not exist.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-formatversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-formatversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormatVersion() {
            return null;
        }

        /**
         * The namespace associated with the dataset that contains permissions for RLS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * The status of the row-level security permission dataset.
         * <p>
         * If enabled, the status is <code>ENABLED</code> . If disabled, the status is <code>DISABLED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiondataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RowLevelPermissionDataSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RowLevelPermissionDataSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RowLevelPermissionDataSetProperty> {
            java.lang.String arn;
            java.lang.String permissionPolicy;
            java.lang.String formatVersion;
            java.lang.String namespace;
            java.lang.String status;

            /**
             * Sets the value of {@link RowLevelPermissionDataSetProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link RowLevelPermissionDataSetProperty#getPermissionPolicy}
             * @param permissionPolicy The type of permissions to use when interpreting the permissions for RLS. This parameter is required.
             *                         <code>DENY_ACCESS</code> is included for backward compatibility only.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder permissionPolicy(java.lang.String permissionPolicy) {
                this.permissionPolicy = permissionPolicy;
                return this;
            }

            /**
             * Sets the value of {@link RowLevelPermissionDataSetProperty#getFormatVersion}
             * @param formatVersion The user or group rules associated with the dataset that contains permissions for RLS.
             *                      By default, <code>FormatVersion</code> is <code>VERSION_1</code> . When <code>FormatVersion</code> is <code>VERSION_1</code> , <code>UserName</code> and <code>GroupName</code> are required. When <code>FormatVersion</code> is <code>VERSION_2</code> , <code>UserARN</code> and <code>GroupARN</code> are required, and <code>Namespace</code> must not exist.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatVersion(java.lang.String formatVersion) {
                this.formatVersion = formatVersion;
                return this;
            }

            /**
             * Sets the value of {@link RowLevelPermissionDataSetProperty#getNamespace}
             * @param namespace The namespace associated with the dataset that contains permissions for RLS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link RowLevelPermissionDataSetProperty#getStatus}
             * @param status The status of the row-level security permission dataset.
             *               If enabled, the status is <code>ENABLED</code> . If disabled, the status is <code>DISABLED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RowLevelPermissionDataSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RowLevelPermissionDataSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RowLevelPermissionDataSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RowLevelPermissionDataSetProperty {
            private final java.lang.String arn;
            private final java.lang.String permissionPolicy;
            private final java.lang.String formatVersion;
            private final java.lang.String namespace;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.permissionPolicy = software.amazon.jsii.Kernel.get(this, "permissionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.formatVersion = software.amazon.jsii.Kernel.get(this, "formatVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
                this.permissionPolicy = java.util.Objects.requireNonNull(builder.permissionPolicy, "permissionPolicy is required");
                this.formatVersion = builder.formatVersion;
                this.namespace = builder.namespace;
                this.status = builder.status;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getPermissionPolicy() {
                return this.permissionPolicy;
            }

            @Override
            public final java.lang.String getFormatVersion() {
                return this.formatVersion;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));
                data.set("permissionPolicy", om.valueToTree(this.getPermissionPolicy()));
                if (this.getFormatVersion() != null) {
                    data.set("formatVersion", om.valueToTree(this.getFormatVersion()));
                }
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.RowLevelPermissionDataSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RowLevelPermissionDataSetProperty.Jsii$Proxy that = (RowLevelPermissionDataSetProperty.Jsii$Proxy) o;

                if (!arn.equals(that.arn)) return false;
                if (!permissionPolicy.equals(that.permissionPolicy)) return false;
                if (this.formatVersion != null ? !this.formatVersion.equals(that.formatVersion) : that.formatVersion != null) return false;
                if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                result = 31 * result + (this.permissionPolicy.hashCode());
                result = 31 * result + (this.formatVersion != null ? this.formatVersion.hashCode() : 0);
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The element you can use to define tags for row-level security.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * Object tagRuleConfigurations;
     * RowLevelPermissionTagConfigurationProperty rowLevelPermissionTagConfigurationProperty = RowLevelPermissionTagConfigurationProperty.builder()
     *         .tagRules(List.of(RowLevelPermissionTagRuleProperty.builder()
     *                 .columnName("columnName")
     *                 .tagKey("tagKey")
     *                 // the properties below are optional
     *                 .matchAllValue("matchAllValue")
     *                 .tagMultiValueDelimiter("tagMultiValueDelimiter")
     *                 .build()))
     *         // the properties below are optional
     *         .status("status")
     *         .tagRuleConfigurations(tagRuleConfigurations)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.RowLevelPermissionTagConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RowLevelPermissionTagConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RowLevelPermissionTagConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A set of rules associated with row-level security, such as the tag names and columns that they are assigned to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagconfiguration.html#cfn-quicksight-dataset-rowlevelpermissiontagconfiguration-tagrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagconfiguration.html#cfn-quicksight-dataset-rowlevelpermissiontagconfiguration-tagrules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTagRules();

        /**
         * The status of row-level security tags.
         * <p>
         * If enabled, the status is <code>ENABLED</code> . If disabled, the status is <code>DISABLED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagconfiguration.html#cfn-quicksight-dataset-rowlevelpermissiontagconfiguration-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagconfiguration.html#cfn-quicksight-dataset-rowlevelpermissiontagconfiguration-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * The configuration of tags on a dataset to set row-level security.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagconfiguration.html#cfn-quicksight-dataset-rowlevelpermissiontagconfiguration-tagruleconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagconfiguration.html#cfn-quicksight-dataset-rowlevelpermissiontagconfiguration-tagruleconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagRuleConfigurations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RowLevelPermissionTagConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RowLevelPermissionTagConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RowLevelPermissionTagConfigurationProperty> {
            java.lang.Object tagRules;
            java.lang.String status;
            java.lang.Object tagRuleConfigurations;

            /**
             * Sets the value of {@link RowLevelPermissionTagConfigurationProperty#getTagRules}
             * @param tagRules A set of rules associated with row-level security, such as the tag names and columns that they are assigned to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagRules(software.amazon.awscdk.IResolvable tagRules) {
                this.tagRules = tagRules;
                return this;
            }

            /**
             * Sets the value of {@link RowLevelPermissionTagConfigurationProperty#getTagRules}
             * @param tagRules A set of rules associated with row-level security, such as the tag names and columns that they are assigned to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagRules(java.util.List<? extends java.lang.Object> tagRules) {
                this.tagRules = tagRules;
                return this;
            }

            /**
             * Sets the value of {@link RowLevelPermissionTagConfigurationProperty#getStatus}
             * @param status The status of row-level security tags.
             *               If enabled, the status is <code>ENABLED</code> . If disabled, the status is <code>DISABLED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link RowLevelPermissionTagConfigurationProperty#getTagRuleConfigurations}
             * @param tagRuleConfigurations The configuration of tags on a dataset to set row-level security.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagRuleConfigurations(java.lang.Object tagRuleConfigurations) {
                this.tagRuleConfigurations = tagRuleConfigurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RowLevelPermissionTagConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RowLevelPermissionTagConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RowLevelPermissionTagConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RowLevelPermissionTagConfigurationProperty {
            private final java.lang.Object tagRules;
            private final java.lang.String status;
            private final java.lang.Object tagRuleConfigurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tagRules = software.amazon.jsii.Kernel.get(this, "tagRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagRuleConfigurations = software.amazon.jsii.Kernel.get(this, "tagRuleConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tagRules = java.util.Objects.requireNonNull(builder.tagRules, "tagRules is required");
                this.status = builder.status;
                this.tagRuleConfigurations = builder.tagRuleConfigurations;
            }

            @Override
            public final java.lang.Object getTagRules() {
                return this.tagRules;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.Object getTagRuleConfigurations() {
                return this.tagRuleConfigurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("tagRules", om.valueToTree(this.getTagRules()));
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getTagRuleConfigurations() != null) {
                    data.set("tagRuleConfigurations", om.valueToTree(this.getTagRuleConfigurations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.RowLevelPermissionTagConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RowLevelPermissionTagConfigurationProperty.Jsii$Proxy that = (RowLevelPermissionTagConfigurationProperty.Jsii$Proxy) o;

                if (!tagRules.equals(that.tagRules)) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                return this.tagRuleConfigurations != null ? this.tagRuleConfigurations.equals(that.tagRuleConfigurations) : that.tagRuleConfigurations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.tagRules.hashCode();
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.tagRuleConfigurations != null ? this.tagRuleConfigurations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A set of rules associated with a tag.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RowLevelPermissionTagRuleProperty rowLevelPermissionTagRuleProperty = RowLevelPermissionTagRuleProperty.builder()
     *         .columnName("columnName")
     *         .tagKey("tagKey")
     *         // the properties below are optional
     *         .matchAllValue("matchAllValue")
     *         .tagMultiValueDelimiter("tagMultiValueDelimiter")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.RowLevelPermissionTagRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RowLevelPermissionTagRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RowLevelPermissionTagRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The column name that a tag key is assigned to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagrule.html#cfn-quicksight-dataset-rowlevelpermissiontagrule-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagrule.html#cfn-quicksight-dataset-rowlevelpermissiontagrule-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * The unique key for a tag.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagrule.html#cfn-quicksight-dataset-rowlevelpermissiontagrule-tagkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagrule.html#cfn-quicksight-dataset-rowlevelpermissiontagrule-tagkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTagKey();

        /**
         * A string that you want to use to filter by all the values in a column in the dataset and don’t want to list the values one by one.
         * <p>
         * For example, you can use an asterisk as your match all value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagrule.html#cfn-quicksight-dataset-rowlevelpermissiontagrule-matchallvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagrule.html#cfn-quicksight-dataset-rowlevelpermissiontagrule-matchallvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMatchAllValue() {
            return null;
        }

        /**
         * A string that you want to use to delimit the values when you pass the values at run time.
         * <p>
         * For example, you can delimit the values with a comma.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagrule.html#cfn-quicksight-dataset-rowlevelpermissiontagrule-tagmultivaluedelimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-rowlevelpermissiontagrule.html#cfn-quicksight-dataset-rowlevelpermissiontagrule-tagmultivaluedelimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagMultiValueDelimiter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RowLevelPermissionTagRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RowLevelPermissionTagRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RowLevelPermissionTagRuleProperty> {
            java.lang.String columnName;
            java.lang.String tagKey;
            java.lang.String matchAllValue;
            java.lang.String tagMultiValueDelimiter;

            /**
             * Sets the value of {@link RowLevelPermissionTagRuleProperty#getColumnName}
             * @param columnName The column name that a tag key is assigned to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link RowLevelPermissionTagRuleProperty#getTagKey}
             * @param tagKey The unique key for a tag. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagKey(java.lang.String tagKey) {
                this.tagKey = tagKey;
                return this;
            }

            /**
             * Sets the value of {@link RowLevelPermissionTagRuleProperty#getMatchAllValue}
             * @param matchAllValue A string that you want to use to filter by all the values in a column in the dataset and don’t want to list the values one by one.
             *                      For example, you can use an asterisk as your match all value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchAllValue(java.lang.String matchAllValue) {
                this.matchAllValue = matchAllValue;
                return this;
            }

            /**
             * Sets the value of {@link RowLevelPermissionTagRuleProperty#getTagMultiValueDelimiter}
             * @param tagMultiValueDelimiter A string that you want to use to delimit the values when you pass the values at run time.
             *                               For example, you can delimit the values with a comma.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagMultiValueDelimiter(java.lang.String tagMultiValueDelimiter) {
                this.tagMultiValueDelimiter = tagMultiValueDelimiter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RowLevelPermissionTagRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RowLevelPermissionTagRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RowLevelPermissionTagRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RowLevelPermissionTagRuleProperty {
            private final java.lang.String columnName;
            private final java.lang.String tagKey;
            private final java.lang.String matchAllValue;
            private final java.lang.String tagMultiValueDelimiter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagKey = software.amazon.jsii.Kernel.get(this, "tagKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.matchAllValue = software.amazon.jsii.Kernel.get(this, "matchAllValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagMultiValueDelimiter = software.amazon.jsii.Kernel.get(this, "tagMultiValueDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.tagKey = java.util.Objects.requireNonNull(builder.tagKey, "tagKey is required");
                this.matchAllValue = builder.matchAllValue;
                this.tagMultiValueDelimiter = builder.tagMultiValueDelimiter;
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.String getTagKey() {
                return this.tagKey;
            }

            @Override
            public final java.lang.String getMatchAllValue() {
                return this.matchAllValue;
            }

            @Override
            public final java.lang.String getTagMultiValueDelimiter() {
                return this.tagMultiValueDelimiter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("tagKey", om.valueToTree(this.getTagKey()));
                if (this.getMatchAllValue() != null) {
                    data.set("matchAllValue", om.valueToTree(this.getMatchAllValue()));
                }
                if (this.getTagMultiValueDelimiter() != null) {
                    data.set("tagMultiValueDelimiter", om.valueToTree(this.getTagMultiValueDelimiter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.RowLevelPermissionTagRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RowLevelPermissionTagRuleProperty.Jsii$Proxy that = (RowLevelPermissionTagRuleProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                if (!tagKey.equals(that.tagKey)) return false;
                if (this.matchAllValue != null ? !this.matchAllValue.equals(that.matchAllValue) : that.matchAllValue != null) return false;
                return this.tagMultiValueDelimiter != null ? this.tagMultiValueDelimiter.equals(that.tagMultiValueDelimiter) : that.tagMultiValueDelimiter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.tagKey.hashCode());
                result = 31 * result + (this.matchAllValue != null ? this.matchAllValue.hashCode() : 0);
                result = 31 * result + (this.tagMultiValueDelimiter != null ? this.tagMultiValueDelimiter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A physical table type for an S3 data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * S3SourceProperty s3SourceProperty = S3SourceProperty.builder()
     *         .dataSourceArn("dataSourceArn")
     *         // the properties below are optional
     *         .inputColumns(List.of(InputColumnProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .subType("subType")
     *                 .build()))
     *         .uploadSettings(UploadSettingsProperty.builder()
     *                 .containsHeader(false)
     *                 .delimiter("delimiter")
     *                 .format("format")
     *                 .startFromRow(123)
     *                 .textQualifier("textQualifier")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-s3source.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-s3source.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.S3SourceProperty")
    @software.amazon.jsii.Jsii.Proxy(S3SourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3SourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) for the data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-s3source.html#cfn-quicksight-dataset-s3source-datasourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-s3source.html#cfn-quicksight-dataset-s3source-datasourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSourceArn();

        /**
         * A physical table type for an S3 data source.
         * <p>
         * <blockquote>
         * <p>
         * For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-s3source.html#cfn-quicksight-dataset-s3source-inputcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-s3source.html#cfn-quicksight-dataset-s3source-inputcolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputColumns() {
            return null;
        }

        /**
         * Information about the format for the S3 source file or files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-s3source.html#cfn-quicksight-dataset-s3source-uploadsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-s3source.html#cfn-quicksight-dataset-s3source-uploadsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUploadSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3SourceProperty> {
            java.lang.String dataSourceArn;
            java.lang.Object inputColumns;
            java.lang.Object uploadSettings;

            /**
             * Sets the value of {@link S3SourceProperty#getDataSourceArn}
             * @param dataSourceArn The Amazon Resource Name (ARN) for the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSourceArn(java.lang.String dataSourceArn) {
                this.dataSourceArn = dataSourceArn;
                return this;
            }

            /**
             * Sets the value of {@link S3SourceProperty#getInputColumns}
             * @param inputColumns A physical table type for an S3 data source.
             *                     <blockquote>
             *                     <p>
             *                     For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputColumns(software.amazon.awscdk.IResolvable inputColumns) {
                this.inputColumns = inputColumns;
                return this;
            }

            /**
             * Sets the value of {@link S3SourceProperty#getInputColumns}
             * @param inputColumns A physical table type for an S3 data source.
             *                     <blockquote>
             *                     <p>
             *                     For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputColumns(java.util.List<? extends java.lang.Object> inputColumns) {
                this.inputColumns = inputColumns;
                return this;
            }

            /**
             * Sets the value of {@link S3SourceProperty#getUploadSettings}
             * @param uploadSettings Information about the format for the S3 source file or files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uploadSettings(software.amazon.awscdk.IResolvable uploadSettings) {
                this.uploadSettings = uploadSettings;
                return this;
            }

            /**
             * Sets the value of {@link S3SourceProperty#getUploadSettings}
             * @param uploadSettings Information about the format for the S3 source file or files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uploadSettings(software.amazon.awscdk.services.quicksight.CfnDataSet.UploadSettingsProperty uploadSettings) {
                this.uploadSettings = uploadSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3SourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3SourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3SourceProperty {
            private final java.lang.String dataSourceArn;
            private final java.lang.Object inputColumns;
            private final java.lang.Object uploadSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSourceArn = software.amazon.jsii.Kernel.get(this, "dataSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputColumns = software.amazon.jsii.Kernel.get(this, "inputColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.uploadSettings = software.amazon.jsii.Kernel.get(this, "uploadSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSourceArn = java.util.Objects.requireNonNull(builder.dataSourceArn, "dataSourceArn is required");
                this.inputColumns = builder.inputColumns;
                this.uploadSettings = builder.uploadSettings;
            }

            @Override
            public final java.lang.String getDataSourceArn() {
                return this.dataSourceArn;
            }

            @Override
            public final java.lang.Object getInputColumns() {
                return this.inputColumns;
            }

            @Override
            public final java.lang.Object getUploadSettings() {
                return this.uploadSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSourceArn", om.valueToTree(this.getDataSourceArn()));
                if (this.getInputColumns() != null) {
                    data.set("inputColumns", om.valueToTree(this.getInputColumns()));
                }
                if (this.getUploadSettings() != null) {
                    data.set("uploadSettings", om.valueToTree(this.getUploadSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.S3SourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3SourceProperty.Jsii$Proxy that = (S3SourceProperty.Jsii$Proxy) o;

                if (!dataSourceArn.equals(that.dataSourceArn)) return false;
                if (this.inputColumns != null ? !this.inputColumns.equals(that.inputColumns) : that.inputColumns != null) return false;
                return this.uploadSettings != null ? this.uploadSettings.equals(that.uploadSettings) : that.uploadSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataSourceArn.hashCode();
                result = 31 * result + (this.inputColumns != null ? this.inputColumns.hashCode() : 0);
                result = 31 * result + (this.uploadSettings != null ? this.uploadSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of default values for a given string dataset parameter type.
     * <p>
     * This structure only accepts static values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * StringDatasetParameterDefaultValuesProperty stringDatasetParameterDefaultValuesProperty = StringDatasetParameterDefaultValuesProperty.builder()
     *         .staticValues(List.of("staticValues"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-stringdatasetparameterdefaultvalues.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-stringdatasetparameterdefaultvalues.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.StringDatasetParameterDefaultValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(StringDatasetParameterDefaultValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StringDatasetParameterDefaultValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of static default values for a given string parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-stringdatasetparameterdefaultvalues.html#cfn-quicksight-dataset-stringdatasetparameterdefaultvalues-staticvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-stringdatasetparameterdefaultvalues.html#cfn-quicksight-dataset-stringdatasetparameterdefaultvalues-staticvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStaticValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StringDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StringDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StringDatasetParameterDefaultValuesProperty> {
            java.util.List<java.lang.String> staticValues;

            /**
             * Sets the value of {@link StringDatasetParameterDefaultValuesProperty#getStaticValues}
             * @param staticValues A list of static default values for a given string parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValues(java.util.List<java.lang.String> staticValues) {
                this.staticValues = staticValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StringDatasetParameterDefaultValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StringDatasetParameterDefaultValuesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StringDatasetParameterDefaultValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StringDatasetParameterDefaultValuesProperty {
            private final java.util.List<java.lang.String> staticValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.staticValues = software.amazon.jsii.Kernel.get(this, "staticValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.staticValues = builder.staticValues;
            }

            @Override
            public final java.util.List<java.lang.String> getStaticValues() {
                return this.staticValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStaticValues() != null) {
                    data.set("staticValues", om.valueToTree(this.getStaticValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.StringDatasetParameterDefaultValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StringDatasetParameterDefaultValuesProperty.Jsii$Proxy that = (StringDatasetParameterDefaultValuesProperty.Jsii$Proxy) o;

                return this.staticValues != null ? this.staticValues.equals(that.staticValues) : that.staticValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.staticValues != null ? this.staticValues.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A string parameter that is created in the dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * StringDatasetParameterProperty stringDatasetParameterProperty = StringDatasetParameterProperty.builder()
     *         .id("id")
     *         .name("name")
     *         .valueType("valueType")
     *         // the properties below are optional
     *         .defaultValues(StringDatasetParameterDefaultValuesProperty.builder()
     *                 .staticValues(List.of("staticValues"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-stringdatasetparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-stringdatasetparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.StringDatasetParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(StringDatasetParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StringDatasetParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An identifier for the string parameter that is created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-stringdatasetparameter.html#cfn-quicksight-dataset-stringdatasetparameter-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-stringdatasetparameter.html#cfn-quicksight-dataset-stringdatasetparameter-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The name of the string parameter that is created in the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-stringdatasetparameter.html#cfn-quicksight-dataset-stringdatasetparameter-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-stringdatasetparameter.html#cfn-quicksight-dataset-stringdatasetparameter-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value type of the dataset parameter.
         * <p>
         * Valid values are <code>single value</code> or <code>multi value</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-stringdatasetparameter.html#cfn-quicksight-dataset-stringdatasetparameter-valuetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-stringdatasetparameter.html#cfn-quicksight-dataset-stringdatasetparameter-valuetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueType();

        /**
         * A list of default values for a given string dataset parameter type.
         * <p>
         * This structure only accepts static values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-stringdatasetparameter.html#cfn-quicksight-dataset-stringdatasetparameter-defaultvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-stringdatasetparameter.html#cfn-quicksight-dataset-stringdatasetparameter-defaultvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StringDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StringDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StringDatasetParameterProperty> {
            java.lang.String id;
            java.lang.String name;
            java.lang.String valueType;
            java.lang.Object defaultValues;

            /**
             * Sets the value of {@link StringDatasetParameterProperty#getId}
             * @param id An identifier for the string parameter that is created in the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link StringDatasetParameterProperty#getName}
             * @param name The name of the string parameter that is created in the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link StringDatasetParameterProperty#getValueType}
             * @param valueType The value type of the dataset parameter. This parameter is required.
             *                  Valid values are <code>single value</code> or <code>multi value</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueType(java.lang.String valueType) {
                this.valueType = valueType;
                return this;
            }

            /**
             * Sets the value of {@link StringDatasetParameterProperty#getDefaultValues}
             * @param defaultValues A list of default values for a given string dataset parameter type.
             *                      This structure only accepts static values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValues(software.amazon.awscdk.IResolvable defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            /**
             * Sets the value of {@link StringDatasetParameterProperty#getDefaultValues}
             * @param defaultValues A list of default values for a given string dataset parameter type.
             *                      This structure only accepts static values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValues(software.amazon.awscdk.services.quicksight.CfnDataSet.StringDatasetParameterDefaultValuesProperty defaultValues) {
                this.defaultValues = defaultValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StringDatasetParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StringDatasetParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StringDatasetParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StringDatasetParameterProperty {
            private final java.lang.String id;
            private final java.lang.String name;
            private final java.lang.String valueType;
            private final java.lang.Object defaultValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueType = software.amazon.jsii.Kernel.get(this, "valueType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultValues = software.amazon.jsii.Kernel.get(this, "defaultValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.valueType = java.util.Objects.requireNonNull(builder.valueType, "valueType is required");
                this.defaultValues = builder.defaultValues;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValueType() {
                return this.valueType;
            }

            @Override
            public final java.lang.Object getDefaultValues() {
                return this.defaultValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("valueType", om.valueToTree(this.getValueType()));
                if (this.getDefaultValues() != null) {
                    data.set("defaultValues", om.valueToTree(this.getDefaultValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.StringDatasetParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StringDatasetParameterProperty.Jsii$Proxy that = (StringDatasetParameterProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (!name.equals(that.name)) return false;
                if (!valueType.equals(that.valueType)) return false;
                return this.defaultValues != null ? this.defaultValues.equals(that.defaultValues) : that.defaultValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.valueType.hashCode());
                result = 31 * result + (this.defaultValues != null ? this.defaultValues.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A transform operation that tags a column with additional information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TagColumnOperationProperty tagColumnOperationProperty = TagColumnOperationProperty.builder()
     *         .columnName("columnName")
     *         .tags(List.of(ColumnTagProperty.builder()
     *                 .columnDescription(ColumnDescriptionProperty.builder()
     *                         .text("text")
     *                         .build())
     *                 .columnGeographicRole("columnGeographicRole")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-tagcolumnoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-tagcolumnoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.TagColumnOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(TagColumnOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagColumnOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The column that this operation acts on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-tagcolumnoperation.html#cfn-quicksight-dataset-tagcolumnoperation-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-tagcolumnoperation.html#cfn-quicksight-dataset-tagcolumnoperation-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * The dataset column tag, currently only used for geospatial type tagging.
         * <p>
         * <blockquote>
         * <p>
         * This is not tags for the AWS tagging feature.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-tagcolumnoperation.html#cfn-quicksight-dataset-tagcolumnoperation-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-tagcolumnoperation.html#cfn-quicksight-dataset-tagcolumnoperation-tags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnTagProperty> getTags();

        /**
         * @return a {@link Builder} of {@link TagColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagColumnOperationProperty> {
            java.lang.String columnName;
            java.util.List<software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnTagProperty> tags;

            /**
             * Sets the value of {@link TagColumnOperationProperty#getColumnName}
             * @param columnName The column that this operation acts on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link TagColumnOperationProperty#getTags}
             * @param tags The dataset column tag, currently only used for geospatial type tagging. This parameter is required.
             *             <blockquote>
             *             <p>
             *             This is not tags for the AWS tagging feature.
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnTagProperty> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnTagProperty>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagColumnOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagColumnOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagColumnOperationProperty {
            private final java.lang.String columnName;
            private final java.util.List<software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnTagProperty> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnTagProperty.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.tags = (java.util.List<software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnTagProperty>)java.util.Objects.requireNonNull(builder.tags, "tags is required");
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.services.quicksight.CfnDataSet.ColumnTagProperty> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("tags", om.valueToTree(this.getTags()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.TagColumnOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagColumnOperationProperty.Jsii$Proxy that = (TagColumnOperationProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                return this.tags.equals(that.tags);
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.tags.hashCode());
                return result;
            }
        }
    }
    /**
     * A data transformation on a logical table.
     * <p>
     * This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TransformOperationProperty transformOperationProperty = TransformOperationProperty.builder()
     *         .castColumnTypeOperation(CastColumnTypeOperationProperty.builder()
     *                 .columnName("columnName")
     *                 .newColumnType("newColumnType")
     *                 // the properties below are optional
     *                 .format("format")
     *                 .subType("subType")
     *                 .build())
     *         .createColumnsOperation(CreateColumnsOperationProperty.builder()
     *                 .columns(List.of(CalculatedColumnProperty.builder()
     *                         .columnId("columnId")
     *                         .columnName("columnName")
     *                         .expression("expression")
     *                         .build()))
     *                 .build())
     *         .filterOperation(FilterOperationProperty.builder()
     *                 .conditionExpression("conditionExpression")
     *                 .build())
     *         .overrideDatasetParameterOperation(OverrideDatasetParameterOperationProperty.builder()
     *                 .parameterName("parameterName")
     *                 // the properties below are optional
     *                 .newDefaultValues(NewDefaultValuesProperty.builder()
     *                         .dateTimeStaticValues(List.of("dateTimeStaticValues"))
     *                         .decimalStaticValues(List.of(123))
     *                         .integerStaticValues(List.of(123))
     *                         .stringStaticValues(List.of("stringStaticValues"))
     *                         .build())
     *                 .newParameterName("newParameterName")
     *                 .build())
     *         .projectOperation(ProjectOperationProperty.builder()
     *                 .projectedColumns(List.of("projectedColumns"))
     *                 .build())
     *         .renameColumnOperation(RenameColumnOperationProperty.builder()
     *                 .columnName("columnName")
     *                 // the properties below are optional
     *                 .newColumnName("newColumnName")
     *                 .build())
     *         .tagColumnOperation(TagColumnOperationProperty.builder()
     *                 .columnName("columnName")
     *                 .tags(List.of(ColumnTagProperty.builder()
     *                         .columnDescription(ColumnDescriptionProperty.builder()
     *                                 .text("text")
     *                                 .build())
     *                         .columnGeographicRole("columnGeographicRole")
     *                         .build()))
     *                 .build())
     *         .untagColumnOperation(UntagColumnOperationProperty.builder()
     *                 .columnName("columnName")
     *                 .tagNames(List.of("tagNames"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.TransformOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(TransformOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransformOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A transform operation that casts a column to a different type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-castcolumntypeoperation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-castcolumntypeoperation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCastColumnTypeOperation() {
            return null;
        }

        /**
         * An operation that creates calculated columns.
         * <p>
         * Columns created in one such operation form a lexical closure.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-createcolumnsoperation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-createcolumnsoperation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreateColumnsOperation() {
            return null;
        }

        /**
         * An operation that filters rows based on some condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-filteroperation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-filteroperation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterOperation() {
            return null;
        }

        /**
         * A transform operation that overrides the dataset parameter values that are defined in another dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-overridedatasetparameteroperation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-overridedatasetparameteroperation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrideDatasetParameterOperation() {
            return null;
        }

        /**
         * An operation that projects columns.
         * <p>
         * Operations that come after a projection can only refer to projected columns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-projectoperation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-projectoperation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProjectOperation() {
            return null;
        }

        /**
         * An operation that renames a column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-renamecolumnoperation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-renamecolumnoperation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRenameColumnOperation() {
            return null;
        }

        /**
         * An operation that tags a column with additional information.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-tagcolumnoperation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-tagcolumnoperation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagColumnOperation() {
            return null;
        }

        /**
         * <p>A transform operation that removes tags associated with a column.</p>.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-untagcolumnoperation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-transformoperation.html#cfn-quicksight-dataset-transformoperation-untagcolumnoperation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUntagColumnOperation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TransformOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransformOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransformOperationProperty> {
            java.lang.Object castColumnTypeOperation;
            java.lang.Object createColumnsOperation;
            java.lang.Object filterOperation;
            java.lang.Object overrideDatasetParameterOperation;
            java.lang.Object projectOperation;
            java.lang.Object renameColumnOperation;
            java.lang.Object tagColumnOperation;
            java.lang.Object untagColumnOperation;

            /**
             * Sets the value of {@link TransformOperationProperty#getCastColumnTypeOperation}
             * @param castColumnTypeOperation A transform operation that casts a column to a different type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder castColumnTypeOperation(software.amazon.awscdk.IResolvable castColumnTypeOperation) {
                this.castColumnTypeOperation = castColumnTypeOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getCastColumnTypeOperation}
             * @param castColumnTypeOperation A transform operation that casts a column to a different type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder castColumnTypeOperation(software.amazon.awscdk.services.quicksight.CfnDataSet.CastColumnTypeOperationProperty castColumnTypeOperation) {
                this.castColumnTypeOperation = castColumnTypeOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getCreateColumnsOperation}
             * @param createColumnsOperation An operation that creates calculated columns.
             *                               Columns created in one such operation form a lexical closure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createColumnsOperation(software.amazon.awscdk.IResolvable createColumnsOperation) {
                this.createColumnsOperation = createColumnsOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getCreateColumnsOperation}
             * @param createColumnsOperation An operation that creates calculated columns.
             *                               Columns created in one such operation form a lexical closure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createColumnsOperation(software.amazon.awscdk.services.quicksight.CfnDataSet.CreateColumnsOperationProperty createColumnsOperation) {
                this.createColumnsOperation = createColumnsOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getFilterOperation}
             * @param filterOperation An operation that filters rows based on some condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterOperation(software.amazon.awscdk.IResolvable filterOperation) {
                this.filterOperation = filterOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getFilterOperation}
             * @param filterOperation An operation that filters rows based on some condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterOperation(software.amazon.awscdk.services.quicksight.CfnDataSet.FilterOperationProperty filterOperation) {
                this.filterOperation = filterOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getOverrideDatasetParameterOperation}
             * @param overrideDatasetParameterOperation A transform operation that overrides the dataset parameter values that are defined in another dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideDatasetParameterOperation(software.amazon.awscdk.IResolvable overrideDatasetParameterOperation) {
                this.overrideDatasetParameterOperation = overrideDatasetParameterOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getOverrideDatasetParameterOperation}
             * @param overrideDatasetParameterOperation A transform operation that overrides the dataset parameter values that are defined in another dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideDatasetParameterOperation(software.amazon.awscdk.services.quicksight.CfnDataSet.OverrideDatasetParameterOperationProperty overrideDatasetParameterOperation) {
                this.overrideDatasetParameterOperation = overrideDatasetParameterOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getProjectOperation}
             * @param projectOperation An operation that projects columns.
             *                         Operations that come after a projection can only refer to projected columns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projectOperation(software.amazon.awscdk.IResolvable projectOperation) {
                this.projectOperation = projectOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getProjectOperation}
             * @param projectOperation An operation that projects columns.
             *                         Operations that come after a projection can only refer to projected columns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder projectOperation(software.amazon.awscdk.services.quicksight.CfnDataSet.ProjectOperationProperty projectOperation) {
                this.projectOperation = projectOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getRenameColumnOperation}
             * @param renameColumnOperation An operation that renames a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder renameColumnOperation(software.amazon.awscdk.IResolvable renameColumnOperation) {
                this.renameColumnOperation = renameColumnOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getRenameColumnOperation}
             * @param renameColumnOperation An operation that renames a column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder renameColumnOperation(software.amazon.awscdk.services.quicksight.CfnDataSet.RenameColumnOperationProperty renameColumnOperation) {
                this.renameColumnOperation = renameColumnOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getTagColumnOperation}
             * @param tagColumnOperation An operation that tags a column with additional information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagColumnOperation(software.amazon.awscdk.IResolvable tagColumnOperation) {
                this.tagColumnOperation = tagColumnOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getTagColumnOperation}
             * @param tagColumnOperation An operation that tags a column with additional information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagColumnOperation(software.amazon.awscdk.services.quicksight.CfnDataSet.TagColumnOperationProperty tagColumnOperation) {
                this.tagColumnOperation = tagColumnOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getUntagColumnOperation}
             * @param untagColumnOperation <p>A transform operation that removes tags associated with a column.</p>.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder untagColumnOperation(software.amazon.awscdk.IResolvable untagColumnOperation) {
                this.untagColumnOperation = untagColumnOperation;
                return this;
            }

            /**
             * Sets the value of {@link TransformOperationProperty#getUntagColumnOperation}
             * @param untagColumnOperation <p>A transform operation that removes tags associated with a column.</p>.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder untagColumnOperation(software.amazon.awscdk.services.quicksight.CfnDataSet.UntagColumnOperationProperty untagColumnOperation) {
                this.untagColumnOperation = untagColumnOperation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransformOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransformOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransformOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformOperationProperty {
            private final java.lang.Object castColumnTypeOperation;
            private final java.lang.Object createColumnsOperation;
            private final java.lang.Object filterOperation;
            private final java.lang.Object overrideDatasetParameterOperation;
            private final java.lang.Object projectOperation;
            private final java.lang.Object renameColumnOperation;
            private final java.lang.Object tagColumnOperation;
            private final java.lang.Object untagColumnOperation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.castColumnTypeOperation = software.amazon.jsii.Kernel.get(this, "castColumnTypeOperation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createColumnsOperation = software.amazon.jsii.Kernel.get(this, "createColumnsOperation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filterOperation = software.amazon.jsii.Kernel.get(this, "filterOperation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.overrideDatasetParameterOperation = software.amazon.jsii.Kernel.get(this, "overrideDatasetParameterOperation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.projectOperation = software.amazon.jsii.Kernel.get(this, "projectOperation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.renameColumnOperation = software.amazon.jsii.Kernel.get(this, "renameColumnOperation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tagColumnOperation = software.amazon.jsii.Kernel.get(this, "tagColumnOperation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.untagColumnOperation = software.amazon.jsii.Kernel.get(this, "untagColumnOperation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.castColumnTypeOperation = builder.castColumnTypeOperation;
                this.createColumnsOperation = builder.createColumnsOperation;
                this.filterOperation = builder.filterOperation;
                this.overrideDatasetParameterOperation = builder.overrideDatasetParameterOperation;
                this.projectOperation = builder.projectOperation;
                this.renameColumnOperation = builder.renameColumnOperation;
                this.tagColumnOperation = builder.tagColumnOperation;
                this.untagColumnOperation = builder.untagColumnOperation;
            }

            @Override
            public final java.lang.Object getCastColumnTypeOperation() {
                return this.castColumnTypeOperation;
            }

            @Override
            public final java.lang.Object getCreateColumnsOperation() {
                return this.createColumnsOperation;
            }

            @Override
            public final java.lang.Object getFilterOperation() {
                return this.filterOperation;
            }

            @Override
            public final java.lang.Object getOverrideDatasetParameterOperation() {
                return this.overrideDatasetParameterOperation;
            }

            @Override
            public final java.lang.Object getProjectOperation() {
                return this.projectOperation;
            }

            @Override
            public final java.lang.Object getRenameColumnOperation() {
                return this.renameColumnOperation;
            }

            @Override
            public final java.lang.Object getTagColumnOperation() {
                return this.tagColumnOperation;
            }

            @Override
            public final java.lang.Object getUntagColumnOperation() {
                return this.untagColumnOperation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCastColumnTypeOperation() != null) {
                    data.set("castColumnTypeOperation", om.valueToTree(this.getCastColumnTypeOperation()));
                }
                if (this.getCreateColumnsOperation() != null) {
                    data.set("createColumnsOperation", om.valueToTree(this.getCreateColumnsOperation()));
                }
                if (this.getFilterOperation() != null) {
                    data.set("filterOperation", om.valueToTree(this.getFilterOperation()));
                }
                if (this.getOverrideDatasetParameterOperation() != null) {
                    data.set("overrideDatasetParameterOperation", om.valueToTree(this.getOverrideDatasetParameterOperation()));
                }
                if (this.getProjectOperation() != null) {
                    data.set("projectOperation", om.valueToTree(this.getProjectOperation()));
                }
                if (this.getRenameColumnOperation() != null) {
                    data.set("renameColumnOperation", om.valueToTree(this.getRenameColumnOperation()));
                }
                if (this.getTagColumnOperation() != null) {
                    data.set("tagColumnOperation", om.valueToTree(this.getTagColumnOperation()));
                }
                if (this.getUntagColumnOperation() != null) {
                    data.set("untagColumnOperation", om.valueToTree(this.getUntagColumnOperation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.TransformOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransformOperationProperty.Jsii$Proxy that = (TransformOperationProperty.Jsii$Proxy) o;

                if (this.castColumnTypeOperation != null ? !this.castColumnTypeOperation.equals(that.castColumnTypeOperation) : that.castColumnTypeOperation != null) return false;
                if (this.createColumnsOperation != null ? !this.createColumnsOperation.equals(that.createColumnsOperation) : that.createColumnsOperation != null) return false;
                if (this.filterOperation != null ? !this.filterOperation.equals(that.filterOperation) : that.filterOperation != null) return false;
                if (this.overrideDatasetParameterOperation != null ? !this.overrideDatasetParameterOperation.equals(that.overrideDatasetParameterOperation) : that.overrideDatasetParameterOperation != null) return false;
                if (this.projectOperation != null ? !this.projectOperation.equals(that.projectOperation) : that.projectOperation != null) return false;
                if (this.renameColumnOperation != null ? !this.renameColumnOperation.equals(that.renameColumnOperation) : that.renameColumnOperation != null) return false;
                if (this.tagColumnOperation != null ? !this.tagColumnOperation.equals(that.tagColumnOperation) : that.tagColumnOperation != null) return false;
                return this.untagColumnOperation != null ? this.untagColumnOperation.equals(that.untagColumnOperation) : that.untagColumnOperation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.castColumnTypeOperation != null ? this.castColumnTypeOperation.hashCode() : 0;
                result = 31 * result + (this.createColumnsOperation != null ? this.createColumnsOperation.hashCode() : 0);
                result = 31 * result + (this.filterOperation != null ? this.filterOperation.hashCode() : 0);
                result = 31 * result + (this.overrideDatasetParameterOperation != null ? this.overrideDatasetParameterOperation.hashCode() : 0);
                result = 31 * result + (this.projectOperation != null ? this.projectOperation.hashCode() : 0);
                result = 31 * result + (this.renameColumnOperation != null ? this.renameColumnOperation.hashCode() : 0);
                result = 31 * result + (this.tagColumnOperation != null ? this.tagColumnOperation.hashCode() : 0);
                result = 31 * result + (this.untagColumnOperation != null ? this.untagColumnOperation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * UniqueKeyProperty uniqueKeyProperty = UniqueKeyProperty.builder()
     *         .columnNames(List.of("columnNames"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uniquekey.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uniquekey.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.UniqueKeyProperty")
    @software.amazon.jsii.Jsii.Proxy(UniqueKeyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UniqueKeyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uniquekey.html#cfn-quicksight-dataset-uniquekey-columnnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uniquekey.html#cfn-quicksight-dataset-uniquekey-columnnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getColumnNames();

        /**
         * @return a {@link Builder} of {@link UniqueKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UniqueKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UniqueKeyProperty> {
            java.util.List<java.lang.String> columnNames;

            /**
             * Sets the value of {@link UniqueKeyProperty#getColumnNames}
             * @param columnNames the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnNames(java.util.List<java.lang.String> columnNames) {
                this.columnNames = columnNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UniqueKeyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UniqueKeyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UniqueKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UniqueKeyProperty {
            private final java.util.List<java.lang.String> columnNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnNames = software.amazon.jsii.Kernel.get(this, "columnNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnNames = java.util.Objects.requireNonNull(builder.columnNames, "columnNames is required");
            }

            @Override
            public final java.util.List<java.lang.String> getColumnNames() {
                return this.columnNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnNames", om.valueToTree(this.getColumnNames()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.UniqueKeyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UniqueKeyProperty.Jsii$Proxy that = (UniqueKeyProperty.Jsii$Proxy) o;

                return this.columnNames.equals(that.columnNames);
            }

            @Override
            public final int hashCode() {
                int result = this.columnNames.hashCode();
                return result;
            }
        }
    }
    /**
     * A transform operation that removes tags associated with a column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * UntagColumnOperationProperty untagColumnOperationProperty = UntagColumnOperationProperty.builder()
     *         .columnName("columnName")
     *         .tagNames(List.of("tagNames"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-untagcolumnoperation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-untagcolumnoperation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.UntagColumnOperationProperty")
    @software.amazon.jsii.Jsii.Proxy(UntagColumnOperationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UntagColumnOperationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The column that this operation acts on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-untagcolumnoperation.html#cfn-quicksight-dataset-untagcolumnoperation-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-untagcolumnoperation.html#cfn-quicksight-dataset-untagcolumnoperation-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * The column tags to remove from this column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-untagcolumnoperation.html#cfn-quicksight-dataset-untagcolumnoperation-tagnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-untagcolumnoperation.html#cfn-quicksight-dataset-untagcolumnoperation-tagnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTagNames();

        /**
         * @return a {@link Builder} of {@link UntagColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UntagColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UntagColumnOperationProperty> {
            java.lang.String columnName;
            java.util.List<java.lang.String> tagNames;

            /**
             * Sets the value of {@link UntagColumnOperationProperty#getColumnName}
             * @param columnName The column that this operation acts on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link UntagColumnOperationProperty#getTagNames}
             * @param tagNames The column tags to remove from this column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagNames(java.util.List<java.lang.String> tagNames) {
                this.tagNames = tagNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UntagColumnOperationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UntagColumnOperationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UntagColumnOperationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UntagColumnOperationProperty {
            private final java.lang.String columnName;
            private final java.util.List<java.lang.String> tagNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagNames = software.amazon.jsii.Kernel.get(this, "tagNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.tagNames = java.util.Objects.requireNonNull(builder.tagNames, "tagNames is required");
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.util.List<java.lang.String> getTagNames() {
                return this.tagNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("tagNames", om.valueToTree(this.getTagNames()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.UntagColumnOperationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UntagColumnOperationProperty.Jsii$Proxy that = (UntagColumnOperationProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                return this.tagNames.equals(that.tagNames);
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.tagNames.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about the format for a source file or files.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * UploadSettingsProperty uploadSettingsProperty = UploadSettingsProperty.builder()
     *         .containsHeader(false)
     *         .delimiter("delimiter")
     *         .format("format")
     *         .startFromRow(123)
     *         .textQualifier("textQualifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnDataSet.UploadSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(UploadSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UploadSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether the file has a header row, or the files each have a header row.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html#cfn-quicksight-dataset-uploadsettings-containsheader">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html#cfn-quicksight-dataset-uploadsettings-containsheader</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainsHeader() {
            return null;
        }

        /**
         * The delimiter between values in the file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html#cfn-quicksight-dataset-uploadsettings-delimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html#cfn-quicksight-dataset-uploadsettings-delimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDelimiter() {
            return null;
        }

        /**
         * File format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html#cfn-quicksight-dataset-uploadsettings-format">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html#cfn-quicksight-dataset-uploadsettings-format</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
            return null;
        }

        /**
         * A row number to start reading data from.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html#cfn-quicksight-dataset-uploadsettings-startfromrow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html#cfn-quicksight-dataset-uploadsettings-startfromrow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStartFromRow() {
            return null;
        }

        /**
         * Text qualifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html#cfn-quicksight-dataset-uploadsettings-textqualifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dataset-uploadsettings.html#cfn-quicksight-dataset-uploadsettings-textqualifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTextQualifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UploadSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UploadSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UploadSettingsProperty> {
            java.lang.Object containsHeader;
            java.lang.String delimiter;
            java.lang.String format;
            java.lang.Number startFromRow;
            java.lang.String textQualifier;

            /**
             * Sets the value of {@link UploadSettingsProperty#getContainsHeader}
             * @param containsHeader Whether the file has a header row, or the files each have a header row.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containsHeader(java.lang.Boolean containsHeader) {
                this.containsHeader = containsHeader;
                return this;
            }

            /**
             * Sets the value of {@link UploadSettingsProperty#getContainsHeader}
             * @param containsHeader Whether the file has a header row, or the files each have a header row.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containsHeader(software.amazon.awscdk.IResolvable containsHeader) {
                this.containsHeader = containsHeader;
                return this;
            }

            /**
             * Sets the value of {@link UploadSettingsProperty#getDelimiter}
             * @param delimiter The delimiter between values in the file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delimiter(java.lang.String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            /**
             * Sets the value of {@link UploadSettingsProperty#getFormat}
             * @param format File format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Sets the value of {@link UploadSettingsProperty#getStartFromRow}
             * @param startFromRow A row number to start reading data from.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startFromRow(java.lang.Number startFromRow) {
                this.startFromRow = startFromRow;
                return this;
            }

            /**
             * Sets the value of {@link UploadSettingsProperty#getTextQualifier}
             * @param textQualifier Text qualifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textQualifier(java.lang.String textQualifier) {
                this.textQualifier = textQualifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UploadSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UploadSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UploadSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UploadSettingsProperty {
            private final java.lang.Object containsHeader;
            private final java.lang.String delimiter;
            private final java.lang.String format;
            private final java.lang.Number startFromRow;
            private final java.lang.String textQualifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containsHeader = software.amazon.jsii.Kernel.get(this, "containsHeader", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.delimiter = software.amazon.jsii.Kernel.get(this, "delimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startFromRow = software.amazon.jsii.Kernel.get(this, "startFromRow", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.textQualifier = software.amazon.jsii.Kernel.get(this, "textQualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containsHeader = builder.containsHeader;
                this.delimiter = builder.delimiter;
                this.format = builder.format;
                this.startFromRow = builder.startFromRow;
                this.textQualifier = builder.textQualifier;
            }

            @Override
            public final java.lang.Object getContainsHeader() {
                return this.containsHeader;
            }

            @Override
            public final java.lang.String getDelimiter() {
                return this.delimiter;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public final java.lang.Number getStartFromRow() {
                return this.startFromRow;
            }

            @Override
            public final java.lang.String getTextQualifier() {
                return this.textQualifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainsHeader() != null) {
                    data.set("containsHeader", om.valueToTree(this.getContainsHeader()));
                }
                if (this.getDelimiter() != null) {
                    data.set("delimiter", om.valueToTree(this.getDelimiter()));
                }
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }
                if (this.getStartFromRow() != null) {
                    data.set("startFromRow", om.valueToTree(this.getStartFromRow()));
                }
                if (this.getTextQualifier() != null) {
                    data.set("textQualifier", om.valueToTree(this.getTextQualifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnDataSet.UploadSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UploadSettingsProperty.Jsii$Proxy that = (UploadSettingsProperty.Jsii$Proxy) o;

                if (this.containsHeader != null ? !this.containsHeader.equals(that.containsHeader) : that.containsHeader != null) return false;
                if (this.delimiter != null ? !this.delimiter.equals(that.delimiter) : that.delimiter != null) return false;
                if (this.format != null ? !this.format.equals(that.format) : that.format != null) return false;
                if (this.startFromRow != null ? !this.startFromRow.equals(that.startFromRow) : that.startFromRow != null) return false;
                return this.textQualifier != null ? this.textQualifier.equals(that.textQualifier) : that.textQualifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containsHeader != null ? this.containsHeader.hashCode() : 0;
                result = 31 * result + (this.delimiter != null ? this.delimiter.hashCode() : 0);
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                result = 31 * result + (this.startFromRow != null ? this.startFromRow.hashCode() : 0);
                result = 31 * result + (this.textQualifier != null ? this.textQualifier.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.quicksight.CfnDataSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.quicksight.CfnDataSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.quicksight.CfnDataSetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The AWS account ID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-awsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-awsaccountid</a>
         * @param awsAccountId The AWS account ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(final java.lang.String awsAccountId) {
            this.props().awsAccountId(awsAccountId);
            return this;
        }

        /**
         * Groupings of columns that work together in certain Amazon QuickSight features.
         * <p>
         * Currently, only geospatial hierarchy is supported.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-columngroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-columngroups</a>
         * @param columnGroups Groupings of columns that work together in certain Amazon QuickSight features. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnGroups(final software.amazon.awscdk.IResolvable columnGroups) {
            this.props().columnGroups(columnGroups);
            return this;
        }
        /**
         * Groupings of columns that work together in certain Amazon QuickSight features.
         * <p>
         * Currently, only geospatial hierarchy is supported.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-columngroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-columngroups</a>
         * @param columnGroups Groupings of columns that work together in certain Amazon QuickSight features. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnGroups(final java.util.List<? extends java.lang.Object> columnGroups) {
            this.props().columnGroups(columnGroups);
            return this;
        }

        /**
         * A set of one or more definitions of a <code>ColumnLevelPermissionRule</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-columnlevelpermissionrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-columnlevelpermissionrules</a>
         * @param columnLevelPermissionRules A set of one or more definitions of a <code>ColumnLevelPermissionRule</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnLevelPermissionRules(final software.amazon.awscdk.IResolvable columnLevelPermissionRules) {
            this.props().columnLevelPermissionRules(columnLevelPermissionRules);
            return this;
        }
        /**
         * A set of one or more definitions of a <code>ColumnLevelPermissionRule</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-columnlevelpermissionrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-columnlevelpermissionrules</a>
         * @param columnLevelPermissionRules A set of one or more definitions of a <code>ColumnLevelPermissionRule</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder columnLevelPermissionRules(final java.util.List<? extends java.lang.Object> columnLevelPermissionRules) {
            this.props().columnLevelPermissionRules(columnLevelPermissionRules);
            return this;
        }

        /**
         * An ID for the dataset that you want to create.
         * <p>
         * This ID is unique per AWS Region for each AWS account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetid</a>
         * @param dataSetId An ID for the dataset that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSetId(final java.lang.String dataSetId) {
            this.props().dataSetId(dataSetId);
            return this;
        }

        /**
         * The parameters that are declared in a dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetparameters</a>
         * @param datasetParameters The parameters that are declared in a dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetParameters(final software.amazon.awscdk.IResolvable datasetParameters) {
            this.props().datasetParameters(datasetParameters);
            return this;
        }
        /**
         * The parameters that are declared in a dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetparameters</a>
         * @param datasetParameters The parameters that are declared in a dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetParameters(final java.util.List<? extends java.lang.Object> datasetParameters) {
            this.props().datasetParameters(datasetParameters);
            return this;
        }

        /**
         * The refresh properties of a dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetrefreshproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetrefreshproperties</a>
         * @param dataSetRefreshProperties The refresh properties of a dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSetRefreshProperties(final software.amazon.awscdk.IResolvable dataSetRefreshProperties) {
            this.props().dataSetRefreshProperties(dataSetRefreshProperties);
            return this;
        }
        /**
         * The refresh properties of a dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetrefreshproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetrefreshproperties</a>
         * @param dataSetRefreshProperties The refresh properties of a dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSetRefreshProperties(final software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetRefreshPropertiesProperty dataSetRefreshProperties) {
            this.props().dataSetRefreshProperties(dataSetRefreshProperties);
            return this;
        }

        /**
         * The usage configuration to apply to child datasets that reference this dataset as a source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetusageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetusageconfiguration</a>
         * @param dataSetUsageConfiguration The usage configuration to apply to child datasets that reference this dataset as a source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSetUsageConfiguration(final software.amazon.awscdk.IResolvable dataSetUsageConfiguration) {
            this.props().dataSetUsageConfiguration(dataSetUsageConfiguration);
            return this;
        }
        /**
         * The usage configuration to apply to child datasets that reference this dataset as a source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetusageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-datasetusageconfiguration</a>
         * @param dataSetUsageConfiguration The usage configuration to apply to child datasets that reference this dataset as a source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSetUsageConfiguration(final software.amazon.awscdk.services.quicksight.CfnDataSet.DataSetUsageConfigurationProperty dataSetUsageConfiguration) {
            this.props().dataSetUsageConfiguration(dataSetUsageConfiguration);
            return this;
        }

        /**
         * The folder that contains fields and nested subfolders for your dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-fieldfolders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-fieldfolders</a>
         * @param fieldFolders The folder that contains fields and nested subfolders for your dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fieldFolders(final software.amazon.awscdk.IResolvable fieldFolders) {
            this.props().fieldFolders(fieldFolders);
            return this;
        }
        /**
         * The folder that contains fields and nested subfolders for your dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-fieldfolders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-fieldfolders</a>
         * @param fieldFolders The folder that contains fields and nested subfolders for your dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fieldFolders(final java.util.Map<java.lang.String, ? extends java.lang.Object> fieldFolders) {
            this.props().fieldFolders(fieldFolders);
            return this;
        }

        /**
         * <p>When you create the dataset, Amazon QuickSight adds the dataset to these folders.</p>.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-folderarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-folderarns</a>
         * @param folderArns <p>When you create the dataset, Amazon QuickSight adds the dataset to these folders.</p>. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder folderArns(final java.util.List<java.lang.String> folderArns) {
            this.props().folderArns(folderArns);
            return this;
        }

        /**
         * Indicates whether you want to import the data into SPICE.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-importmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-importmode</a>
         * @param importMode Indicates whether you want to import the data into SPICE. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder importMode(final java.lang.String importMode) {
            this.props().importMode(importMode);
            return this;
        }

        /**
         * The wait policy to use when creating or updating a Dataset.
         * <p>
         * The default is to wait for SPICE ingestion to finish with timeout of 36 hours.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-ingestionwaitpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-ingestionwaitpolicy</a>
         * @param ingestionWaitPolicy The wait policy to use when creating or updating a Dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingestionWaitPolicy(final software.amazon.awscdk.IResolvable ingestionWaitPolicy) {
            this.props().ingestionWaitPolicy(ingestionWaitPolicy);
            return this;
        }
        /**
         * The wait policy to use when creating or updating a Dataset.
         * <p>
         * The default is to wait for SPICE ingestion to finish with timeout of 36 hours.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-ingestionwaitpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-ingestionwaitpolicy</a>
         * @param ingestionWaitPolicy The wait policy to use when creating or updating a Dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ingestionWaitPolicy(final software.amazon.awscdk.services.quicksight.CfnDataSet.IngestionWaitPolicyProperty ingestionWaitPolicy) {
            this.props().ingestionWaitPolicy(ingestionWaitPolicy);
            return this;
        }

        /**
         * Configures the combination and transformation of the data from the physical tables.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-logicaltablemap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-logicaltablemap</a>
         * @param logicalTableMap Configures the combination and transformation of the data from the physical tables. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logicalTableMap(final software.amazon.awscdk.IResolvable logicalTableMap) {
            this.props().logicalTableMap(logicalTableMap);
            return this;
        }
        /**
         * Configures the combination and transformation of the data from the physical tables.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-logicaltablemap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-logicaltablemap</a>
         * @param logicalTableMap Configures the combination and transformation of the data from the physical tables. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logicalTableMap(final java.util.Map<java.lang.String, ? extends java.lang.Object> logicalTableMap) {
            this.props().logicalTableMap(logicalTableMap);
            return this;
        }

        /**
         * The display name for the dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-name</a>
         * @param name The display name for the dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The performance optimization configuration of a dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-performanceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-performanceconfiguration</a>
         * @param performanceConfiguration The performance optimization configuration of a dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceConfiguration(final software.amazon.awscdk.IResolvable performanceConfiguration) {
            this.props().performanceConfiguration(performanceConfiguration);
            return this;
        }
        /**
         * The performance optimization configuration of a dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-performanceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-performanceconfiguration</a>
         * @param performanceConfiguration The performance optimization configuration of a dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceConfiguration(final software.amazon.awscdk.services.quicksight.CfnDataSet.PerformanceConfigurationProperty performanceConfiguration) {
            this.props().performanceConfiguration(performanceConfiguration);
            return this;
        }

        /**
         * A list of resource permissions on the dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-permissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-permissions</a>
         * @param permissions A list of resource permissions on the dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(final software.amazon.awscdk.IResolvable permissions) {
            this.props().permissions(permissions);
            return this;
        }
        /**
         * A list of resource permissions on the dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-permissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-permissions</a>
         * @param permissions A list of resource permissions on the dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(final java.util.List<? extends java.lang.Object> permissions) {
            this.props().permissions(permissions);
            return this;
        }

        /**
         * Declares the physical tables that are available in the underlying data sources.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-physicaltablemap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-physicaltablemap</a>
         * @param physicalTableMap Declares the physical tables that are available in the underlying data sources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder physicalTableMap(final software.amazon.awscdk.IResolvable physicalTableMap) {
            this.props().physicalTableMap(physicalTableMap);
            return this;
        }
        /**
         * Declares the physical tables that are available in the underlying data sources.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-physicaltablemap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-physicaltablemap</a>
         * @param physicalTableMap Declares the physical tables that are available in the underlying data sources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder physicalTableMap(final java.util.Map<java.lang.String, ? extends java.lang.Object> physicalTableMap) {
            this.props().physicalTableMap(physicalTableMap);
            return this;
        }

        /**
         * The row-level security configuration for the data that you want to create.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset</a>
         * @param rowLevelPermissionDataSet The row-level security configuration for the data that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rowLevelPermissionDataSet(final software.amazon.awscdk.IResolvable rowLevelPermissionDataSet) {
            this.props().rowLevelPermissionDataSet(rowLevelPermissionDataSet);
            return this;
        }
        /**
         * The row-level security configuration for the data that you want to create.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-rowlevelpermissiondataset</a>
         * @param rowLevelPermissionDataSet The row-level security configuration for the data that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rowLevelPermissionDataSet(final software.amazon.awscdk.services.quicksight.CfnDataSet.RowLevelPermissionDataSetProperty rowLevelPermissionDataSet) {
            this.props().rowLevelPermissionDataSet(rowLevelPermissionDataSet);
            return this;
        }

        /**
         * The element you can use to define tags for row-level security.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-rowlevelpermissiontagconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-rowlevelpermissiontagconfiguration</a>
         * @param rowLevelPermissionTagConfiguration The element you can use to define tags for row-level security. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rowLevelPermissionTagConfiguration(final software.amazon.awscdk.IResolvable rowLevelPermissionTagConfiguration) {
            this.props().rowLevelPermissionTagConfiguration(rowLevelPermissionTagConfiguration);
            return this;
        }
        /**
         * The element you can use to define tags for row-level security.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-rowlevelpermissiontagconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-rowlevelpermissiontagconfiguration</a>
         * @param rowLevelPermissionTagConfiguration The element you can use to define tags for row-level security. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rowLevelPermissionTagConfiguration(final software.amazon.awscdk.services.quicksight.CfnDataSet.RowLevelPermissionTagConfigurationProperty rowLevelPermissionTagConfiguration) {
            this.props().rowLevelPermissionTagConfiguration(rowLevelPermissionTagConfiguration);
            return this;
        }

        /**
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-tags</a>
         * @param tags Contains a map of the key-value pairs for the resource tag or tags assigned to the dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The usage of the dataset.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-useas">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dataset.html#cfn-quicksight-dataset-useas</a>
         * @param useAs The usage of the dataset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useAs(final java.lang.String useAs) {
            this.props().useAs(useAs);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.quicksight.CfnDataSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.quicksight.CfnDataSet build() {
            return new software.amazon.awscdk.services.quicksight.CfnDataSet(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.quicksight.CfnDataSetProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.quicksight.CfnDataSetProps.Builder();
            }
            return this.props;
        }
    }
}
