package software.amazon.awscdk.services.rds;

/**
 * The database insights mode of the Aurora DB cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.AURORA)
 *         .vpc(vpc)
 *         // If you enable the advanced mode of Database Insights,
 *         // Performance Insights is enabled and you must set the `performanceInsightRetention` to 465(15 months).
 *         .databaseInsightsMode(DatabaseInsightsMode.ADVANCED)
 *         .performanceInsightRetention(PerformanceInsightRetention.MONTHS_15)
 *         .writer(ClusterInstance.provisioned("Writer", ProvisionedClusterInstanceProps.builder()
 *                 .instanceType(InstanceType.of(InstanceClass.R7G, InstanceSize.LARGE))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:14.191Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseInsightsMode")
public enum DatabaseInsightsMode {
    /**
     * Standard mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * Advanced mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ADVANCED,
}
