package software.amazon.awscdk.services.rds;

/**
 * A Aurora Serverless v1 Cluster restored from a snapshot.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ServerlessClusterFromSnapshot.Builder.create(this, "Cluster")
 *         .engine(DatabaseClusterEngine.AURORA_MYSQL)
 *         .vpc(vpc)
 *         .snapshotIdentifier("mySnapshot")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:14.292Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.ServerlessClusterFromSnapshot")
public class ServerlessClusterFromSnapshot extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.rds.IServerlessCluster {

    protected ServerlessClusterFromSnapshot(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ServerlessClusterFromSnapshot(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.ServerlessClusterFromSnapshot.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ServerlessClusterFromSnapshot(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ServerlessClusterFromSnapshotProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Renders the secret attachment target specifications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps asSecretAttachmentTarget() {
        return software.amazon.jsii.Kernel.call(this, "asSecretAttachmentTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps.class));
    }

    /**
     * Grant the given identity to access to the Data API, including read access to the secret attached to the cluster if present.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantDataApiAccess(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantDataApiAccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The ARN of the cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterArn() {
        return software.amazon.jsii.Kernel.get(this, "clusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The endpoint to use for read/write operations.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Endpoint getClusterEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Endpoint.class));
    }

    /**
     * Identifier of the cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The endpoint to use for read/write operations.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Endpoint getClusterReadEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "clusterReadEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Endpoint.class));
    }

    /**
     * Access to the network connections.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.CfnDBClusterProps getNewCfnProps() {
        return software.amazon.jsii.Kernel.get(this, "newCfnProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CfnDBClusterProps.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class))));
    }

    /**
     * The secret attached to this cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
        return software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableDataApi() {
        return software.amazon.jsii.Kernel.get(this, "enableDataApi", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setEnableDataApi(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableDataApi", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.ServerlessClusterFromSnapshot}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.ServerlessClusterFromSnapshot> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.ServerlessClusterFromSnapshotProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.ServerlessClusterFromSnapshotProps.Builder();
        }

        /**
         * What kind of database to start.
         * <p>
         * @return {@code this}
         * @param engine What kind of database to start. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final software.amazon.awscdk.services.rds.IClusterEngine engine) {
            this.props.engine(engine);
            return this;
        }

        /**
         * The identifier for the DB instance snapshot or DB cluster snapshot to restore from.
         * <p>
         * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot.
         * However, you can use only the ARN to specify a DB instance snapshot.
         * <p>
         * @return {@code this}
         * @param snapshotIdentifier The identifier for the DB instance snapshot or DB cluster snapshot to restore from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotIdentifier(final java.lang.String snapshotIdentifier) {
            this.props.snapshotIdentifier(snapshotIdentifier);
            return this;
        }

        /**
         * The number of days during which automatic DB snapshots are retained.
         * <p>
         * Automatic backup retention cannot be disabled on serverless clusters.
         * Must be a value from 1 day to 35 days.
         * <p>
         * Default: Duration.days(1)
         * <p>
         * @return {@code this}
         * @param backupRetention The number of days during which automatic DB snapshots are retained. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetention(final software.amazon.awscdk.Duration backupRetention) {
            this.props.backupRetention(backupRetention);
            return this;
        }

        /**
         * An optional identifier for the cluster.
         * <p>
         * Default: - A name is automatically generated.
         * <p>
         * @return {@code this}
         * @param clusterIdentifier An optional identifier for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterIdentifier(final java.lang.String clusterIdentifier) {
            this.props.clusterIdentifier(clusterIdentifier);
            return this;
        }

        /**
         * Whether to copy tags to the snapshot when a snapshot is created.
         * <p>
         * Default: - true
         * <p>
         * @return {@code this}
         * @param copyTagsToSnapshot Whether to copy tags to the snapshot when a snapshot is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(final java.lang.Boolean copyTagsToSnapshot) {
            this.props.copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }

        /**
         * Master user credentials.
         * <p>
         * Note - It is not possible to change the master username for a snapshot;
         * however, it is possible to provide (or generate) a new password.
         * <p>
         * Default: - The existing username and password from the snapshot will be used.
         * <p>
         * @return {@code this}
         * @param credentials Master user credentials. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(final software.amazon.awscdk.services.rds.SnapshotCredentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        /**
         * Name of a database which is automatically created inside the cluster.
         * <p>
         * Default: - Database is not created in cluster.
         * <p>
         * @return {@code this}
         * @param defaultDatabaseName Name of a database which is automatically created inside the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultDatabaseName(final java.lang.String defaultDatabaseName) {
            this.props.defaultDatabaseName(defaultDatabaseName);
            return this;
        }

        /**
         * Indicates whether the DB cluster should have deletion protection enabled.
         * <p>
         * Default: - true if removalPolicy is RETAIN, false otherwise
         * <p>
         * @return {@code this}
         * @param deletionProtection Indicates whether the DB cluster should have deletion protection enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * Whether to enable the Data API.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html</a>
         * @param enableDataApi Whether to enable the Data API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableDataApi(final java.lang.Boolean enableDataApi) {
            this.props.enableDataApi(enableDataApi);
            return this;
        }

        /**
         * Additional parameters to pass to the database engine.
         * <p>
         * Default: - no parameter group.
         * <p>
         * @return {@code this}
         * @param parameterGroup Additional parameters to pass to the database engine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterGroup(final software.amazon.awscdk.services.rds.IParameterGroup parameterGroup) {
            this.props.parameterGroup(parameterGroup);
            return this;
        }

        /**
         * The removal policy to apply when the cluster and its instances are removed from the stack or replaced during an update.
         * <p>
         * Default: - RemovalPolicy.SNAPSHOT (remove the cluster and instances, but retain a snapshot of the data)
         * <p>
         * @return {@code this}
         * @param removalPolicy The removal policy to apply when the cluster and its instances are removed from the stack or replaced during an update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * Scaling configuration of an Aurora Serverless database cluster.
         * <p>
         * Default: - Serverless cluster is automatically paused after 5 minutes of being idle.
         * minimum capacity: 2 ACU
         * maximum capacity: 16 ACU
         * <p>
         * @return {@code this}
         * @param scaling Scaling configuration of an Aurora Serverless database cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scaling(final software.amazon.awscdk.services.rds.ServerlessScalingOptions scaling) {
            this.props.scaling(scaling);
            return this;
        }

        /**
         * Security group.
         * <p>
         * Default: - a new security group is created if `vpc` was provided.
         * If the `vpc` property was not provided, no VPC security groups will be associated with the DB cluster.
         * <p>
         * @return {@code this}
         * @param securityGroups Security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * Existing subnet group for the cluster.
         * <p>
         * Default: - a new subnet group is created if `vpc` was provided.
         * If the `vpc` property was not provided, no subnet group will be associated with the DB cluster
         * <p>
         * @return {@code this}
         * @param subnetGroup Existing subnet group for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetGroup(final software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup) {
            this.props.subnetGroup(subnetGroup);
            return this;
        }

        /**
         * The VPC that this Aurora Serverless v1 Cluster has been created in.
         * <p>
         * Default: - the default VPC in the account and region will be used
         * <p>
         * @return {@code this}
         * @param vpc The VPC that this Aurora Serverless v1 Cluster has been created in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Where to place the instances within the VPC.
         * <p>
         * If provided, the <code>vpc</code> property must also be specified.
         * <p>
         * Default: - the VPC default strategy if not specified.
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place the instances within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.rds.ServerlessClusterFromSnapshot}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.ServerlessClusterFromSnapshot build() {
            return new software.amazon.awscdk.services.rds.ServerlessClusterFromSnapshot(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
