package software.amazon.awscdk.services.rds;

/**
 * The versions for the SQL Server instance engines (those returned by <code>DatabaseInstanceEngine.sqlServerSe</code>, <code>DatabaseInstanceEngine.sqlServerEx</code>, <code>DatabaseInstanceEngine.sqlServerWeb</code> and <code>DatabaseInstanceEngine.sqlServerEe</code>).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ParameterGroup parameterGroup = ParameterGroup.Builder.create(this, "ParameterGroup")
 *         .engine(DatabaseInstanceEngine.sqlServerEe(SqlServerEeInstanceEngineProps.builder()
 *                 .version(SqlServerEngineVersion.VER_11)
 *                 .build()))
 *         .name("my-parameter-group")
 *         .parameters(Map.of(
 *                 "locks", "100"))
 *         .build();
 * DatabaseInstance.Builder.create(this, "Database")
 *         .engine(DatabaseInstanceEngine.SQL_SERVER_EE)
 *         .vpc(vpc)
 *         .parameterGroup(parameterGroup)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:14.299Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.SqlServerEngineVersion")
public class SqlServerEngineVersion extends software.amazon.jsii.JsiiObject {

    protected SqlServerEngineVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqlServerEngineVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        VER_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_11_00_5058_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_11_00_5058_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_11_00_6020_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_11_00_6020_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_11_00_6594_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_11_00_6594_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_11_00_7462_6_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_11_00_7462_6_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_11_00_7493_4_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_11_00_7493_4_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12_00_4422_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12_00_4422_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12_00_5000_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12_00_5000_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12_00_5546_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12_00_5546_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12_00_5571_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12_00_5571_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12_00_6293_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12_00_6293_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12_00_6329_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12_00_6329_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12_00_6433_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12_00_6433_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12_00_6439_10_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12_00_6439_10_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12_00_6444_4_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12_00_6444_4_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_12_00_6449_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_12_00_6449_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_2164_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_2164_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_4422_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_4422_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_4451_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_4451_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_4466_4_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_4466_4_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_4522_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_4522_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_5216_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_5216_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_5292_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_5292_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_5366_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_5366_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_5426_0_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_5426_0_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_5598_27_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_5598_27_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_5820_21_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_5820_21_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_5850_14_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_5850_14_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_5882_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_5882_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_6300_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_6300_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_6419_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_6419_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_6430_49_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_6430_49_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_6435_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_6435_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_6441_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_6441_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_6445_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_6445_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_6450_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_6450_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_13_00_6455_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_13_00_6455_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_1000_169_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_1000_169_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3015_40_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3015_40_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3035_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3035_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3049_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3049_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3192_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3192_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3223_3_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3223_3_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3281_6_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3281_6_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3294_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3294_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3356_20_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3356_20_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3381_3_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3381_3_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3401_7_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3401_7_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3421_10_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3421_10_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3451_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3451_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3460_9_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3460_9_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3465_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3465_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3471_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3471_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3475_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3475_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3480_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3480_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_14_00_3485_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_14_00_3485_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4043_16_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4043_16_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4073_23_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4073_23_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4153_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4153_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4198_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4198_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4236_7_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4236_7_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4312_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4312_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4316_3_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4316_3_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4322_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4322_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4335_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4335_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4345_5_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4345_5_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4355_3_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4355_3_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4365_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4365_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4375_4_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4375_4_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4382_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4382_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4385_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4385_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4390_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4390_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4395_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4395_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4410_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4410_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4415_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4415_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4420_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4420_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_15_00_4430_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_15_00_4430_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_16_00_4085_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_16_00_4085_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_16_00_4095_4_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_16_00_4095_4_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_16_00_4105_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_16_00_4105_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_16_00_4115_5_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_16_00_4115_5_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_16_00_4120_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_16_00_4120_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_16_00_4125_3_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_16_00_4125_3_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_16_00_4131_2_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_16_00_4131_2_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_16_00_4135_4_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_16_00_4135_4_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_16_00_4140_3_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_16_00_4140_3_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_16_00_4150_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_16_00_4150_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_16_00_4165_4_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_16_00_4165_4_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_16_00_4175_1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_16_00_4175_1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
        VER_16_00_4185_3_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "VER_16_00_4185_3_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class));
    }

    /**
     * Create a new SqlServerEngineVersion with an arbitrary version.
     * <p>
     * @param sqlServerFullVersion the full version string, for example "15.00.3049.1.v1". This parameter is required.
     * @param sqlServerMajorVersion the major version of the engine, for example "15.00". This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.SqlServerEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String sqlServerFullVersion, final @org.jetbrains.annotations.NotNull java.lang.String sqlServerMajorVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SqlServerEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(sqlServerFullVersion, "sqlServerFullVersion is required"), java.util.Objects.requireNonNull(sqlServerMajorVersion, "sqlServerMajorVersion is required") });
    }

    /**
     * (deprecated) Version "11.00" (only a major version, without a specific minor version).
     * <p>
     * @deprecated SQL Server 11.00 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_11;

    /**
     * (deprecated) Version "11.00.5058.0.v1".
     * <p>
     * @deprecated SQL Server 11.00.5058.0.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_11_00_5058_0_V1;

    /**
     * (deprecated) Version "11.00.6020.0.v1".
     * <p>
     * @deprecated SQL Server 11.00.6020.0.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_11_00_6020_0_V1;

    /**
     * (deprecated) Version "11.00.6594.0.v1".
     * <p>
     * @deprecated SQL Server 11.00.6594.0.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_11_00_6594_0_V1;

    /**
     * (deprecated) Version "11.00.7462.6.v1".
     * <p>
     * @deprecated SQL Server 11.00.7462.6.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_11_00_7462_6_V1;

    /**
     * (deprecated) Version "11.00.7493.4.v1".
     * <p>
     * @deprecated SQL Server 11.00.7493.4.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_11_00_7493_4_V1;

    /**
     * (deprecated) Version "12.00" (only a major version, without a specific minor version).
     * <p>
     * @deprecated SQL Server 12.00 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12;

    /**
     * (deprecated) Version "12.00.4422.0.v1".
     * <p>
     * @deprecated SQL Server 12.00.4422.0.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12_00_4422_0_V1;

    /**
     * (deprecated) Version "12.00.5000.0.v1".
     * <p>
     * @deprecated SQL Server 12.00.5000.0.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12_00_5000_0_V1;

    /**
     * (deprecated) Version "12.00.5546.0.v1".
     * <p>
     * @deprecated SQL Server 12.00.5546.0.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12_00_5546_0_V1;

    /**
     * (deprecated) Version "12.00.5571.0.v1".
     * <p>
     * @deprecated SQL Server 12.00.5571.0.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12_00_5571_0_V1;

    /**
     * (deprecated) Version "12.00.6293.0.v1".
     * <p>
     * @deprecated SQL Server 12.00.6293.0.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12_00_6293_0_V1;

    /**
     * (deprecated) Version "12.00.6329.1.v1".
     * <p>
     * @deprecated SQL Server 12.00.6329.1.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12_00_6329_1_V1;

    /**
     * (deprecated) Version "12.00.6433.1.v1".
     * <p>
     * @deprecated SQL Server 12.00.6433.1.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12_00_6433_1_V1;

    /**
     * (deprecated) Version "12.00.6439.10.v1".
     * <p>
     * @deprecated SQL Server 12.00.6439.10.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12_00_6439_10_V1;

    /**
     * (deprecated) Version "12.00.6444.4.v1".
     * <p>
     * @deprecated SQL Server 12.00.6444.4.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12_00_6444_4_V1;

    /**
     * (deprecated) Version "12.00.6449.1.v1".
     * <p>
     * @deprecated SQL Server 12.00.6449.1.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_12_00_6449_1_V1;

    /**
     * Version "13.00" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13;

    /**
     * (deprecated) Version "13.00.2164.0.v1".
     * <p>
     * @deprecated SQL Server 13.00.2164.0.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_2164_0_V1;

    /**
     * (deprecated) Version "13.00.4422.0.v1".
     * <p>
     * @deprecated SQL Server 13.00.4422.0.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_4422_0_V1;

    /**
     * (deprecated) Version "13.00.4451.0.v1".
     * <p>
     * @deprecated SQL Server 13.00.4451.0.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_4451_0_V1;

    /**
     * (deprecated) Version "13.00.4466.4.v1".
     * <p>
     * @deprecated SQL Server 13.00.4466.4.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_4466_4_V1;

    /**
     * (deprecated) Version "13.00.4522.0.v1".
     * <p>
     * @deprecated SQL Server 13.00.4522.0.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_4522_0_V1;

    /**
     * (deprecated) Version "13.00.5216.0.v1".
     * <p>
     * @deprecated SQL Server 13.00.5216.0.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_5216_0_V1;

    /**
     * (deprecated) Version "13.00.5292.0.v1".
     * <p>
     * @deprecated SQL Server 13.00.5292.0.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_5292_0_V1;

    /**
     * (deprecated) Version "13.00.5366.0.v1".
     * <p>
     * @deprecated SQL Server 13.00.5366.0.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_5366_0_V1;

    /**
     * (deprecated) Version "13.00.5426.0.v1".
     * <p>
     * @deprecated SQL Server 13.00.5426.0.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_5426_0_V1;

    /**
     * (deprecated) Version "13.00.5598.27.v1".
     * <p>
     * @deprecated SQL Server 13.00.5598.27.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_5598_27_V1;

    /**
     * (deprecated) Version "13.00.5820.21.v1".
     * <p>
     * @deprecated SQL Server 13.00.5820.21.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_5820_21_V1;

    /**
     * (deprecated) Version "13.00.5850.14.v1".
     * <p>
     * @deprecated SQL Server 13.00.5850.14.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_5850_14_V1;

    /**
     * (deprecated) Version "13.00.5882.1.v1".
     * <p>
     * @deprecated SQL Server 13.00.5882.1.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_5882_1_V1;

    /**
     * Version "13.00.6300.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_6300_2_V1;

    /**
     * Version "13.00.6419.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_6419_1_V1;

    /**
     * Version "13.00.6430.49.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_6430_49_V1;

    /**
     * Version "13.00.6435.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_6435_1_V1;

    /**
     * Version "13.00.6441.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_6441_1_V1;

    /**
     * Version "13.00.6445.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_6445_1_V1;

    /**
     * Version "13.00.6450.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_6450_1_V1;

    /**
     * Version "13.00.6455.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_13_00_6455_2_V1;

    /**
     * Version "14.00" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14;

    /**
     * (deprecated) Version "14.00.1000.169.v1".
     * <p>
     * @deprecated SQL Server 14.00.1000.169.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_1000_169_V1;

    /**
     * (deprecated) Version "14.00.3015.40.v1".
     * <p>
     * @deprecated SQL Server 14.00.3015.40.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3015_40_V1;

    /**
     * (deprecated) Version "14.00.3035.2.v1".
     * <p>
     * @deprecated SQL Server 14.00.3035.2.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3035_2_V1;

    /**
     * (deprecated) Version "14.00.3049.1.v1".
     * <p>
     * @deprecated SQL Server 14.00.3049.1.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3049_1_V1;

    /**
     * (deprecated) Version "14.00.3192.2.v1".
     * <p>
     * @deprecated SQL Server 14.00.3192.2.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3192_2_V1;

    /**
     * (deprecated) Version "14.00.3223.3.v1".
     * <p>
     * @deprecated SQL Server 14.00.3223.3.v1 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3223_3_V1;

    /**
     * Version "14.00.3281.6.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3281_6_V1;

    /**
     * Version "14.00.3294.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3294_2_V1;

    /**
     * Version "14.00.3356.20.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3356_20_V1;

    /**
     * Version "14.00.3381.3.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3381_3_V1;

    /**
     * Version "14.00.3401.7.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3401_7_V1;

    /**
     * Version "14.00.3421.10.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3421_10_V1;

    /**
     * Version "14.00.3451.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3451_2_V1;

    /**
     * Version "14.00.3460.9.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3460_9_V1;

    /**
     * Version "14.00.3465.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3465_1_V1;

    /**
     * Version "14.00.3471.2.v1 ".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3471_2_V1;

    /**
     * Version "14.00.3475.1.v1 ".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3475_1_V1;

    /**
     * Version "14.00.3480.1.v1 ".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3480_1_V1;

    /**
     * Version "14.00.3485.1.v1 ".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_14_00_3485_1_V1;

    /**
     * Version "15.00" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15;

    /**
     * Version "15.00.4043.16.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4043_16_V1;

    /**
     * Version "15.00.4073.23.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4073_23_V1;

    /**
     * Version "15.00.4153.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4153_1_V1;

    /**
     * Version "15.00.4198.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4198_2_V1;

    /**
     * Version "15.00.4236.7.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4236_7_V1;

    /**
     * Version "15.00.4312.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4312_2_V1;

    /**
     * Version "15.00.4316.3.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4316_3_V1;

    /**
     * Version "15.00.4322.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4322_2_V1;

    /**
     * Version "15.00.4335.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4335_1_V1;

    /**
     * Version "15.00.4345.5.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4345_5_V1;

    /**
     * Version "15.00.4355.3.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4355_3_V1;

    /**
     * Version "15.00.4365.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4365_2_V1;

    /**
     * Version "15.00.4375.4.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4375_4_V1;

    /**
     * Version "15.00.4382.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4382_1_V1;

    /**
     * Version "15.00.4385.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4385_2_V1;

    /**
     * Version "15.00.4390.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4390_2_V1;

    /**
     * Version "15.00.4395.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4395_2_V1;

    /**
     * Version "15.00.4410.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4410_1_V1;

    /**
     * Version "15.00.4415.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4415_2_V1;

    /**
     * Version "15.00.4420.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4420_2_V1;

    /**
     * Version "15.00.4430.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_15_00_4430_1_V1;

    /**
     * Version "16.00" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_16;

    /**
     * Version "16.00.4085.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_16_00_4085_2_V1;

    /**
     * Version "16.00.4095.4.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_16_00_4095_4_V1;

    /**
     * Version "16.00.4105.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_16_00_4105_2_V1;

    /**
     * Version "16.00.4115.5.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_16_00_4115_5_V1;

    /**
     * Version "16.00.4120.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_16_00_4120_1_V1;

    /**
     * Version "16.00.4125.3.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_16_00_4125_3_V1;

    /**
     * Version "16.00.4131.2.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_16_00_4131_2_V1;

    /**
     * Version "16.00.4135.4.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_16_00_4135_4_V1;

    /**
     * Version "16.00.4140.3.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_16_00_4140_3_V1;

    /**
     * Version "16.00.4150.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_16_00_4150_1_V1;

    /**
     * Version "16.00.4165.4.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_16_00_4165_4_V1;

    /**
     * Version "16.00.4175.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_16_00_4175_1_V1;

    /**
     * Version "16.00.4185.3.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.SqlServerEngineVersion VER_16_00_4185_3_V1;

    /**
     * The full version string, for example, "15.00.3049.1.v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSqlServerFullVersion() {
        return software.amazon.jsii.Kernel.get(this, "sqlServerFullVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The major version of the engine, for example, "15.00".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSqlServerMajorVersion() {
        return software.amazon.jsii.Kernel.get(this, "sqlServerMajorVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
