package software.amazon.awscdk.services.route53;

/**
 * Construction properties for a CnameRecord.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.certificatemanager.*;
 * import software.amazon.awscdk.services.route53.*;
 * // hosted zone and route53 features
 * String hostedZoneId;
 * String zoneName = "example.com";
 * String myDomainName = "api.example.com";
 * Certificate certificate = Certificate.Builder.create(this, "cert").domainName(myDomainName).build();
 * SchemaFile schema = SchemaFile.Builder.create().filePath("mySchemaFile").build();
 * GraphqlApi api = GraphqlApi.Builder.create(this, "api")
 *         .name("myApi")
 *         .definition(Definition.fromSchema(schema))
 *         .domainName(DomainOptions.builder()
 *                 .certificate(certificate)
 *                 .domainName(myDomainName)
 *                 .build())
 *         .build();
 * // hosted zone for adding appsync domain
 * IHostedZone zone = HostedZone.fromHostedZoneAttributes(this, "HostedZone", HostedZoneAttributes.builder()
 *         .hostedZoneId(hostedZoneId)
 *         .zoneName(zoneName)
 *         .build());
 * // create a cname to the appsync domain. will map to something like xxxx.cloudfront.net
 * // create a cname to the appsync domain. will map to something like xxxx.cloudfront.net
 * CnameRecord.Builder.create(this, "CnameApiRecord")
 *         .recordName("api")
 *         .zone(zone)
 *         .domainName(api.getAppSyncDomainName())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:14.560Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CnameRecordProps")
@software.amazon.jsii.Jsii.Proxy(CnameRecordProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CnameRecordProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.route53.RecordSetOptions {

    /**
     * The domain name of the target that this record should point to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * @return a {@link Builder} of {@link CnameRecordProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CnameRecordProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CnameRecordProps> {
        java.lang.String domainName;
        software.amazon.awscdk.services.route53.IHostedZone zone;
        software.amazon.awscdk.services.route53.CidrRoutingConfig cidrRoutingConfig;
        java.lang.String comment;
        java.lang.Boolean deleteExisting;
        software.amazon.awscdk.services.route53.GeoLocation geoLocation;
        software.amazon.awscdk.services.route53.IHealthCheck healthCheck;
        java.lang.Boolean multiValueAnswer;
        java.lang.String recordName;
        java.lang.String region;
        java.lang.String setIdentifier;
        software.amazon.awscdk.Duration ttl;
        java.lang.Number weight;

        /**
         * Sets the value of {@link CnameRecordProps#getDomainName}
         * @param domainName The domain name of the target that this record should point to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CnameRecordProps#getZone}
         * @param zone The hosted zone in which to define the new record. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zone(software.amazon.awscdk.services.route53.IHostedZone zone) {
            this.zone = zone;
            return this;
        }

        /**
         * Sets the value of {@link CnameRecordProps#getCidrRoutingConfig}
         * @param cidrRoutingConfig The object that is specified in resource record set object when you are linking a resource record set to a CIDR location.
         *                          A LocationName with an asterisk “*” can be used to create a default CIDR record. CollectionId is still required for default record.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrRoutingConfig(software.amazon.awscdk.services.route53.CidrRoutingConfig cidrRoutingConfig) {
            this.cidrRoutingConfig = cidrRoutingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CnameRecordProps#getComment}
         * @param comment A comment to add on the record.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link CnameRecordProps#getDeleteExisting}
         * @param deleteExisting Whether to delete the same record set in the hosted zone if it already exists (dangerous!).
         *                       This allows to deploy a new record set while minimizing the downtime because the
         *                       new record set will be created immediately after the existing one is deleted. It
         *                       also avoids "manual" actions to delete existing record sets.
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       <strong>N.B.:</strong> this feature is dangerous, use with caution! It can only be used safely when
         *                       <code>deleteExisting</code> is set to <code>true</code> as soon as the resource is added to the stack. Changing
         *                       an existing Record Set's <code>deleteExisting</code> property from <code>false -&gt; true</code> after deployment
         *                       will delete the record!
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteExisting(java.lang.Boolean deleteExisting) {
            this.deleteExisting = deleteExisting;
            return this;
        }

        /**
         * Sets the value of {@link CnameRecordProps#getGeoLocation}
         * @param geoLocation The geographical origin for this record to return DNS records based on the user's location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geoLocation(software.amazon.awscdk.services.route53.GeoLocation geoLocation) {
            this.geoLocation = geoLocation;
            return this;
        }

        /**
         * Sets the value of {@link CnameRecordProps#getHealthCheck}
         * @param healthCheck The health check to associate with the record set.
         *                    Route53 will return this record set in response to DNS queries only if the health check is passing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.route53.IHealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link CnameRecordProps#getMultiValueAnswer}
         * @param multiValueAnswer Whether to return multiple values, such as IP addresses for your web servers, in response to DNS queries.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiValueAnswer(java.lang.Boolean multiValueAnswer) {
            this.multiValueAnswer = multiValueAnswer;
            return this;
        }

        /**
         * Sets the value of {@link CnameRecordProps#getRecordName}
         * @param recordName The subdomain name for this record. This should be relative to the zone root name.
         *                   For example, if you want to create a record for acme.example.com, specify
         *                   "acme".
         *                   <p>
         *                   You can also specify the fully qualified domain name which terminates with a
         *                   ".". For example, "acme.example.com.".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordName(java.lang.String recordName) {
            this.recordName = recordName;
            return this;
        }

        /**
         * Sets the value of {@link CnameRecordProps#getRegion}
         * @param region The Amazon EC2 Region where you created the resource that this resource record set refers to.
         *               The resource typically is an AWS resource, such as an EC2 instance or an ELB load balancer,
         *               and is referred to by an IP address or a DNS domain name, depending on the record type.
         *               <p>
         *               When Amazon Route 53 receives a DNS query for a domain name and type for which you have created latency resource record sets,
         *               Route 53 selects the latency resource record set that has the lowest latency between the end user and the associated Amazon EC2 Region.
         *               Route 53 then returns the value that is associated with the selected resource record set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link CnameRecordProps#getSetIdentifier}
         * @param setIdentifier A string used to distinguish between different records with the same combination of DNS name and type.
         *                      It can only be set when either weight or geoLocation is defined.
         *                      <p>
         *                      This parameter must be between 1 and 128 characters in length.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder setIdentifier(java.lang.String setIdentifier) {
            this.setIdentifier = setIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CnameRecordProps#getTtl}
         * @param ttl The resource record cache time to live (TTL).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttl(software.amazon.awscdk.Duration ttl) {
            this.ttl = ttl;
            return this;
        }

        /**
         * Sets the value of {@link CnameRecordProps#getWeight}
         * @param weight Among resource record sets that have the same combination of DNS name and type, a value that determines the proportion of DNS queries that Amazon Route 53 responds to using the current resource record set.
         *               Route 53 calculates the sum of the weights for the resource record sets that have the same combination of DNS name and type.
         *               Route 53 then responds to queries based on the ratio of a resource's weight to the total.
         *               <p>
         *               This value can be a number between 0 and 255.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder weight(java.lang.Number weight) {
            this.weight = weight;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CnameRecordProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CnameRecordProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CnameRecordProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CnameRecordProps {
        private final java.lang.String domainName;
        private final software.amazon.awscdk.services.route53.IHostedZone zone;
        private final software.amazon.awscdk.services.route53.CidrRoutingConfig cidrRoutingConfig;
        private final java.lang.String comment;
        private final java.lang.Boolean deleteExisting;
        private final software.amazon.awscdk.services.route53.GeoLocation geoLocation;
        private final software.amazon.awscdk.services.route53.IHealthCheck healthCheck;
        private final java.lang.Boolean multiValueAnswer;
        private final java.lang.String recordName;
        private final java.lang.String region;
        private final java.lang.String setIdentifier;
        private final software.amazon.awscdk.Duration ttl;
        private final java.lang.Number weight;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.zone = software.amazon.jsii.Kernel.get(this, "zone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class));
            this.cidrRoutingConfig = software.amazon.jsii.Kernel.get(this, "cidrRoutingConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.CidrRoutingConfig.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deleteExisting = software.amazon.jsii.Kernel.get(this, "deleteExisting", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.geoLocation = software.amazon.jsii.Kernel.get(this, "geoLocation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.GeoLocation.class));
            this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHealthCheck.class));
            this.multiValueAnswer = software.amazon.jsii.Kernel.get(this, "multiValueAnswer", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.recordName = software.amazon.jsii.Kernel.get(this, "recordName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.setIdentifier = software.amazon.jsii.Kernel.get(this, "setIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ttl = software.amazon.jsii.Kernel.get(this, "ttl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.zone = java.util.Objects.requireNonNull(builder.zone, "zone is required");
            this.cidrRoutingConfig = builder.cidrRoutingConfig;
            this.comment = builder.comment;
            this.deleteExisting = builder.deleteExisting;
            this.geoLocation = builder.geoLocation;
            this.healthCheck = builder.healthCheck;
            this.multiValueAnswer = builder.multiValueAnswer;
            this.recordName = builder.recordName;
            this.region = builder.region;
            this.setIdentifier = builder.setIdentifier;
            this.ttl = builder.ttl;
            this.weight = builder.weight;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final software.amazon.awscdk.services.route53.IHostedZone getZone() {
            return this.zone;
        }

        @Override
        public final software.amazon.awscdk.services.route53.CidrRoutingConfig getCidrRoutingConfig() {
            return this.cidrRoutingConfig;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.Boolean getDeleteExisting() {
            return this.deleteExisting;
        }

        @Override
        public final software.amazon.awscdk.services.route53.GeoLocation getGeoLocation() {
            return this.geoLocation;
        }

        @Override
        public final software.amazon.awscdk.services.route53.IHealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public final java.lang.Boolean getMultiValueAnswer() {
            return this.multiValueAnswer;
        }

        @Override
        public final java.lang.String getRecordName() {
            return this.recordName;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getSetIdentifier() {
            return this.setIdentifier;
        }

        @Override
        public final software.amazon.awscdk.Duration getTtl() {
            return this.ttl;
        }

        @Override
        public final java.lang.Number getWeight() {
            return this.weight;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            data.set("zone", om.valueToTree(this.getZone()));
            if (this.getCidrRoutingConfig() != null) {
                data.set("cidrRoutingConfig", om.valueToTree(this.getCidrRoutingConfig()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getDeleteExisting() != null) {
                data.set("deleteExisting", om.valueToTree(this.getDeleteExisting()));
            }
            if (this.getGeoLocation() != null) {
                data.set("geoLocation", om.valueToTree(this.getGeoLocation()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getMultiValueAnswer() != null) {
                data.set("multiValueAnswer", om.valueToTree(this.getMultiValueAnswer()));
            }
            if (this.getRecordName() != null) {
                data.set("recordName", om.valueToTree(this.getRecordName()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getSetIdentifier() != null) {
                data.set("setIdentifier", om.valueToTree(this.getSetIdentifier()));
            }
            if (this.getTtl() != null) {
                data.set("ttl", om.valueToTree(this.getTtl()));
            }
            if (this.getWeight() != null) {
                data.set("weight", om.valueToTree(this.getWeight()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.CnameRecordProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CnameRecordProps.Jsii$Proxy that = (CnameRecordProps.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (!zone.equals(that.zone)) return false;
            if (this.cidrRoutingConfig != null ? !this.cidrRoutingConfig.equals(that.cidrRoutingConfig) : that.cidrRoutingConfig != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.deleteExisting != null ? !this.deleteExisting.equals(that.deleteExisting) : that.deleteExisting != null) return false;
            if (this.geoLocation != null ? !this.geoLocation.equals(that.geoLocation) : that.geoLocation != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.multiValueAnswer != null ? !this.multiValueAnswer.equals(that.multiValueAnswer) : that.multiValueAnswer != null) return false;
            if (this.recordName != null ? !this.recordName.equals(that.recordName) : that.recordName != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.setIdentifier != null ? !this.setIdentifier.equals(that.setIdentifier) : that.setIdentifier != null) return false;
            if (this.ttl != null ? !this.ttl.equals(that.ttl) : that.ttl != null) return false;
            return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.zone.hashCode());
            result = 31 * result + (this.cidrRoutingConfig != null ? this.cidrRoutingConfig.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.deleteExisting != null ? this.deleteExisting.hashCode() : 0);
            result = 31 * result + (this.geoLocation != null ? this.geoLocation.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.multiValueAnswer != null ? this.multiValueAnswer.hashCode() : 0);
            result = 31 * result + (this.recordName != null ? this.recordName.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.setIdentifier != null ? this.setIdentifier.hashCode() : 0);
            result = 31 * result + (this.ttl != null ? this.ttl.hashCode() : 0);
            result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
            return result;
        }
    }
}
