package software.amazon.awscdk.services.route53.targets;

/**
 * Use an Elastic Beanstalk environment URL as an alias record target. E.g. mysampleenvironment.xyz.us-east-1.elasticbeanstalk.com or mycustomcnameprefix.us-east-1.elasticbeanstalk.com.
 * <p>
 * Only supports Elastic Beanstalk environments created after 2016 that have a regional endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.regioninfo.RegionInfo;
 * HostedZone zone;
 * String ebsEnvironmentUrl;
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(
 *         new ElasticBeanstalkEnvironmentEndpointTarget(ebsEnvironmentUrl, Map.of(
 *                 "hostedZoneId", RegionInfo.get("us-east-1").getEbsEnvEndpointHostedZoneId()))))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:14.623Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53_targets.ElasticBeanstalkEnvironmentEndpointTarget")
public class ElasticBeanstalkEnvironmentEndpointTarget extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.route53.IAliasRecordTarget {

    protected ElasticBeanstalkEnvironmentEndpointTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ElasticBeanstalkEnvironmentEndpointTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param environmentEndpoint This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ElasticBeanstalkEnvironmentEndpointTarget(final @org.jetbrains.annotations.NotNull java.lang.String environmentEndpoint, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.targets.IAliasRecordTargetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(environmentEndpoint, "environmentEndpoint is required"), props });
    }

    /**
     * @param environmentEndpoint This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ElasticBeanstalkEnvironmentEndpointTarget(final @org.jetbrains.annotations.NotNull java.lang.String environmentEndpoint) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(environmentEndpoint, "environmentEndpoint is required") });
    }

    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     * <p>
     * @param record This parameter is required.
     * @param _zone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.AliasRecordTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IRecordSet record, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IHostedZone _zone) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.AliasRecordTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(record, "record is required"), _zone });
    }

    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     * <p>
     * @param record This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.AliasRecordTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IRecordSet record) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.AliasRecordTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(record, "record is required") });
    }
}
