package software.amazon.awscdk.services.s3.deployment;

/**
 * Define options which can be passed using the method <code>Source.jsonData()</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * StringParameter param;
 * // Example with a secret value that contains double quotes
 * BucketDeployment deployment = BucketDeployment.Builder.create(this, "JsonDeployment")
 *         .sources(List.of(Source.jsonData("config.json", Map.of(
 *                 "api_endpoint", "https://api.example.com",
 *                 "secretValue", param.getStringValue(),  // value with double quotes
 *                 "config", Map.of(
 *                         "enabled", true,
 *                         "features", List.of("feature1", "feature2"))), JsonProcessingOptions.builder().escape(true).build())))
 *         .destinationBucket(bucket)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:14.881Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3_deployment.JsonProcessingOptions")
@software.amazon.jsii.Jsii.Proxy(JsonProcessingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface JsonProcessingOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * If set to <code>true</code>, the marker substitution will make sure the value inserted in the file will be a valid JSON string.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEscape() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link JsonProcessingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JsonProcessingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<JsonProcessingOptions> {
        java.lang.Boolean escape;

        /**
         * Sets the value of {@link JsonProcessingOptions#getEscape}
         * @param escape If set to <code>true</code>, the marker substitution will make sure the value inserted in the file will be a valid JSON string.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder escape(java.lang.Boolean escape) {
            this.escape = escape;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JsonProcessingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public JsonProcessingOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JsonProcessingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonProcessingOptions {
        private final java.lang.Boolean escape;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.escape = software.amazon.jsii.Kernel.get(this, "escape", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.escape = builder.escape;
        }

        @Override
        public final java.lang.Boolean getEscape() {
            return this.escape;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEscape() != null) {
                data.set("escape", om.valueToTree(this.getEscape()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3_deployment.JsonProcessingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JsonProcessingOptions.Jsii$Proxy that = (JsonProcessingOptions.Jsii$Proxy) o;

            return this.escape != null ? this.escape.equals(that.escape) : that.escape == null;
        }

        @Override
        public final int hashCode() {
            int result = this.escape != null ? this.escape.hashCode() : 0;
            return result;
        }
    }
}
