package software.amazon.awscdk.services.securityhub;

/**
 * Creates a V2 automation rule.
 * <p>
 * This API is in private preview and subject to change.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securityhub.*;
 * CfnAutomationRuleV2 cfnAutomationRuleV2 = CfnAutomationRuleV2.Builder.create(this, "MyCfnAutomationRuleV2")
 *         .actions(List.of(AutomationRulesActionV2Property.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .externalIntegrationConfiguration(ExternalIntegrationConfigurationProperty.builder()
 *                         .connectorArn("connectorArn")
 *                         .build())
 *                 .findingFieldsUpdate(AutomationRulesFindingFieldsUpdateV2Property.builder()
 *                         .comment("comment")
 *                         .severityId(123)
 *                         .statusId(123)
 *                         .build())
 *                 .build()))
 *         .criteria(CriteriaProperty.builder()
 *                 .ocsfFindingCriteria(OcsfFindingFiltersProperty.builder()
 *                         .compositeFilters(List.of(CompositeFilterProperty.builder()
 *                                 .booleanFilters(List.of(OcsfBooleanFilterProperty.builder()
 *                                         .fieldName("fieldName")
 *                                         .filter(BooleanFilterProperty.builder()
 *                                                 .value(false)
 *                                                 .build())
 *                                         .build()))
 *                                 .dateFilters(List.of(OcsfDateFilterProperty.builder()
 *                                         .fieldName("fieldName")
 *                                         .filter(DateFilterProperty.builder()
 *                                                 .dateRange(DateRangeProperty.builder()
 *                                                         .unit("unit")
 *                                                         .value(123)
 *                                                         .build())
 *                                                 .end("end")
 *                                                 .start("start")
 *                                                 .build())
 *                                         .build()))
 *                                 .mapFilters(List.of(OcsfMapFilterProperty.builder()
 *                                         .fieldName("fieldName")
 *                                         .filter(MapFilterProperty.builder()
 *                                                 .comparison("comparison")
 *                                                 .key("key")
 *                                                 .value("value")
 *                                                 .build())
 *                                         .build()))
 *                                 .numberFilters(List.of(OcsfNumberFilterProperty.builder()
 *                                         .fieldName("fieldName")
 *                                         .filter(NumberFilterProperty.builder()
 *                                                 .eq(123)
 *                                                 .gte(123)
 *                                                 .lte(123)
 *                                                 .build())
 *                                         .build()))
 *                                 .operator("operator")
 *                                 .stringFilters(List.of(OcsfStringFilterProperty.builder()
 *                                         .fieldName("fieldName")
 *                                         .filter(StringFilterProperty.builder()
 *                                                 .comparison("comparison")
 *                                                 .value("value")
 *                                                 .build())
 *                                         .build()))
 *                                 .build()))
 *                         .compositeOperator("compositeOperator")
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .ruleName("ruleName")
 *         .ruleOrder(123)
 *         // the properties below are optional
 *         .ruleStatus("ruleStatus")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:15.520Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2")
public class CfnAutomationRuleV2 extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnAutomationRuleV2(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAutomationRuleV2(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAutomationRuleV2(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2Props props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The timestamp when the V2 automation rule was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the V2 automation rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRuleArn() {
        return software.amazon.jsii.Kernel.get(this, "attrRuleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the V2 automation rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRuleId() {
        return software.amazon.jsii.Kernel.get(this, "attrRuleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp when the V2 automation rule was updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of actions to be performed when the rule criteria is met.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getActions() {
        return software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of actions to be performed when the rule criteria is met.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "actions", java.util.Objects.requireNonNull(value, "actions is required"));
    }

    /**
     * A list of actions to be performed when the rule criteria is met.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2.AutomationRulesActionV2Property)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2.AutomationRulesActionV2Property; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "actions", java.util.Objects.requireNonNull(value, "actions is required"));
    }

    /**
     * The filtering type and configuration of the automation rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getCriteria() {
        return software.amazon.jsii.Kernel.get(this, "criteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The filtering type and configuration of the automation rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCriteria(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "criteria", java.util.Objects.requireNonNull(value, "criteria is required"));
    }

    /**
     * The filtering type and configuration of the automation rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCriteria(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2.CriteriaProperty value) {
        software.amazon.jsii.Kernel.set(this, "criteria", java.util.Objects.requireNonNull(value, "criteria is required"));
    }

    /**
     * A description of the V2 automation rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the V2 automation rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", java.util.Objects.requireNonNull(value, "description is required"));
    }

    /**
     * The name of the V2 automation rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRuleName() {
        return software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the V2 automation rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ruleName", java.util.Objects.requireNonNull(value, "ruleName is required"));
    }

    /**
     * The value for the rule priority.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getRuleOrder() {
        return software.amazon.jsii.Kernel.get(this, "ruleOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The value for the rule priority.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleOrder(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "ruleOrder", java.util.Objects.requireNonNull(value, "ruleOrder is required"));
    }

    /**
     * The status of the V2 automation rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRuleStatus() {
        return software.amazon.jsii.Kernel.get(this, "ruleStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the V2 automation rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ruleStatus", value);
    }

    /**
     * A list of key-value pairs associated with the V2 automation rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * A list of key-value pairs associated with the V2 automation rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Allows you to configure automated responses.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * AutomationRulesActionV2Property automationRulesActionV2Property = AutomationRulesActionV2Property.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .externalIntegrationConfiguration(ExternalIntegrationConfigurationProperty.builder()
     *                 .connectorArn("connectorArn")
     *                 .build())
     *         .findingFieldsUpdate(AutomationRulesFindingFieldsUpdateV2Property.builder()
     *                 .comment("comment")
     *                 .severityId(123)
     *                 .statusId(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-automationrulesactionv2.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-automationrulesactionv2.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.AutomationRulesActionV2Property")
    @software.amazon.jsii.Jsii.Proxy(AutomationRulesActionV2Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutomationRulesActionV2Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the type of action that Security Hub takes when a finding matches the defined criteria of a rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-automationrulesactionv2.html#cfn-securityhub-automationrulev2-automationrulesactionv2-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-automationrulesactionv2.html#cfn-securityhub-automationrulev2-automationrulesactionv2-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The settings for integrating automation rule actions with external systems or service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-automationrulesactionv2.html#cfn-securityhub-automationrulev2-automationrulesactionv2-externalintegrationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-automationrulesactionv2.html#cfn-securityhub-automationrulev2-automationrulesactionv2-externalintegrationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExternalIntegrationConfiguration() {
            return null;
        }

        /**
         * Specifies that the automation rule action is an update to a finding field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-automationrulesactionv2.html#cfn-securityhub-automationrulev2-automationrulesactionv2-findingfieldsupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-automationrulesactionv2.html#cfn-securityhub-automationrulev2-automationrulesactionv2-findingfieldsupdate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFindingFieldsUpdate() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutomationRulesActionV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutomationRulesActionV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutomationRulesActionV2Property> {
            java.lang.String type;
            java.lang.Object externalIntegrationConfiguration;
            java.lang.Object findingFieldsUpdate;

            /**
             * Sets the value of {@link AutomationRulesActionV2Property#getType}
             * @param type Specifies the type of action that Security Hub takes when a finding matches the defined criteria of a rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesActionV2Property#getExternalIntegrationConfiguration}
             * @param externalIntegrationConfiguration The settings for integrating automation rule actions with external systems or service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalIntegrationConfiguration(software.amazon.awscdk.IResolvable externalIntegrationConfiguration) {
                this.externalIntegrationConfiguration = externalIntegrationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesActionV2Property#getExternalIntegrationConfiguration}
             * @param externalIntegrationConfiguration The settings for integrating automation rule actions with external systems or service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalIntegrationConfiguration(software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2.ExternalIntegrationConfigurationProperty externalIntegrationConfiguration) {
                this.externalIntegrationConfiguration = externalIntegrationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesActionV2Property#getFindingFieldsUpdate}
             * @param findingFieldsUpdate Specifies that the automation rule action is an update to a finding field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingFieldsUpdate(software.amazon.awscdk.IResolvable findingFieldsUpdate) {
                this.findingFieldsUpdate = findingFieldsUpdate;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesActionV2Property#getFindingFieldsUpdate}
             * @param findingFieldsUpdate Specifies that the automation rule action is an update to a finding field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingFieldsUpdate(software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2.AutomationRulesFindingFieldsUpdateV2Property findingFieldsUpdate) {
                this.findingFieldsUpdate = findingFieldsUpdate;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutomationRulesActionV2Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutomationRulesActionV2Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutomationRulesActionV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutomationRulesActionV2Property {
            private final java.lang.String type;
            private final java.lang.Object externalIntegrationConfiguration;
            private final java.lang.Object findingFieldsUpdate;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalIntegrationConfiguration = software.amazon.jsii.Kernel.get(this, "externalIntegrationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.findingFieldsUpdate = software.amazon.jsii.Kernel.get(this, "findingFieldsUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.externalIntegrationConfiguration = builder.externalIntegrationConfiguration;
                this.findingFieldsUpdate = builder.findingFieldsUpdate;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getExternalIntegrationConfiguration() {
                return this.externalIntegrationConfiguration;
            }

            @Override
            public final java.lang.Object getFindingFieldsUpdate() {
                return this.findingFieldsUpdate;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getExternalIntegrationConfiguration() != null) {
                    data.set("externalIntegrationConfiguration", om.valueToTree(this.getExternalIntegrationConfiguration()));
                }
                if (this.getFindingFieldsUpdate() != null) {
                    data.set("findingFieldsUpdate", om.valueToTree(this.getFindingFieldsUpdate()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.AutomationRulesActionV2Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutomationRulesActionV2Property.Jsii$Proxy that = (AutomationRulesActionV2Property.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.externalIntegrationConfiguration != null ? !this.externalIntegrationConfiguration.equals(that.externalIntegrationConfiguration) : that.externalIntegrationConfiguration != null) return false;
                return this.findingFieldsUpdate != null ? this.findingFieldsUpdate.equals(that.findingFieldsUpdate) : that.findingFieldsUpdate == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.externalIntegrationConfiguration != null ? this.externalIntegrationConfiguration.hashCode() : 0);
                result = 31 * result + (this.findingFieldsUpdate != null ? this.findingFieldsUpdate.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Allows you to define the structure for modifying specific fields in security findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * AutomationRulesFindingFieldsUpdateV2Property automationRulesFindingFieldsUpdateV2Property = AutomationRulesFindingFieldsUpdateV2Property.builder()
     *         .comment("comment")
     *         .severityId(123)
     *         .statusId(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-automationrulesfindingfieldsupdatev2.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-automationrulesfindingfieldsupdatev2.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.AutomationRulesFindingFieldsUpdateV2Property")
    @software.amazon.jsii.Jsii.Proxy(AutomationRulesFindingFieldsUpdateV2Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutomationRulesFindingFieldsUpdateV2Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Notes or contextual information for findings that are modified by the automation rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-automationrulesfindingfieldsupdatev2.html#cfn-securityhub-automationrulev2-automationrulesfindingfieldsupdatev2-comment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-automationrulesfindingfieldsupdatev2.html#cfn-securityhub-automationrulev2-automationrulesfindingfieldsupdatev2-comment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
            return null;
        }

        /**
         * The severity level to be assigned to findings that match the automation rule criteria.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-automationrulesfindingfieldsupdatev2.html#cfn-securityhub-automationrulev2-automationrulesfindingfieldsupdatev2-severityid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-automationrulesfindingfieldsupdatev2.html#cfn-securityhub-automationrulev2-automationrulesfindingfieldsupdatev2-severityid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSeverityId() {
            return null;
        }

        /**
         * The status to be applied to findings that match automation rule criteria.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-automationrulesfindingfieldsupdatev2.html#cfn-securityhub-automationrulev2-automationrulesfindingfieldsupdatev2-statusid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-automationrulesfindingfieldsupdatev2.html#cfn-securityhub-automationrulev2-automationrulesfindingfieldsupdatev2-statusid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStatusId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutomationRulesFindingFieldsUpdateV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutomationRulesFindingFieldsUpdateV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutomationRulesFindingFieldsUpdateV2Property> {
            java.lang.String comment;
            java.lang.Number severityId;
            java.lang.Number statusId;

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateV2Property#getComment}
             * @param comment Notes or contextual information for findings that are modified by the automation rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comment(java.lang.String comment) {
                this.comment = comment;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateV2Property#getSeverityId}
             * @param severityId The severity level to be assigned to findings that match the automation rule criteria.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder severityId(java.lang.Number severityId) {
                this.severityId = severityId;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateV2Property#getStatusId}
             * @param statusId The status to be applied to findings that match automation rule criteria.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusId(java.lang.Number statusId) {
                this.statusId = statusId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutomationRulesFindingFieldsUpdateV2Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutomationRulesFindingFieldsUpdateV2Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutomationRulesFindingFieldsUpdateV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutomationRulesFindingFieldsUpdateV2Property {
            private final java.lang.String comment;
            private final java.lang.Number severityId;
            private final java.lang.Number statusId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.severityId = software.amazon.jsii.Kernel.get(this, "severityId", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.statusId = software.amazon.jsii.Kernel.get(this, "statusId", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comment = builder.comment;
                this.severityId = builder.severityId;
                this.statusId = builder.statusId;
            }

            @Override
            public final java.lang.String getComment() {
                return this.comment;
            }

            @Override
            public final java.lang.Number getSeverityId() {
                return this.severityId;
            }

            @Override
            public final java.lang.Number getStatusId() {
                return this.statusId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComment() != null) {
                    data.set("comment", om.valueToTree(this.getComment()));
                }
                if (this.getSeverityId() != null) {
                    data.set("severityId", om.valueToTree(this.getSeverityId()));
                }
                if (this.getStatusId() != null) {
                    data.set("statusId", om.valueToTree(this.getStatusId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.AutomationRulesFindingFieldsUpdateV2Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutomationRulesFindingFieldsUpdateV2Property.Jsii$Proxy that = (AutomationRulesFindingFieldsUpdateV2Property.Jsii$Proxy) o;

                if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
                if (this.severityId != null ? !this.severityId.equals(that.severityId) : that.severityId != null) return false;
                return this.statusId != null ? this.statusId.equals(that.statusId) : that.statusId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.comment != null ? this.comment.hashCode() : 0;
                result = 31 * result + (this.severityId != null ? this.severityId.hashCode() : 0);
                result = 31 * result + (this.statusId != null ? this.statusId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Boolean filter for querying findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * BooleanFilterProperty booleanFilterProperty = BooleanFilterProperty.builder()
     *         .value(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-booleanfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-booleanfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.BooleanFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(BooleanFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BooleanFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value of the boolean.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-booleanfilter.html#cfn-securityhub-automationrulev2-booleanfilter-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-booleanfilter.html#cfn-securityhub-automationrulev2-booleanfilter-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValue();

        /**
         * @return a {@link Builder} of {@link BooleanFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BooleanFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BooleanFilterProperty> {
            java.lang.Object value;

            /**
             * Sets the value of {@link BooleanFilterProperty#getValue}
             * @param value The value of the boolean. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Boolean value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link BooleanFilterProperty#getValue}
             * @param value The value of the boolean. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BooleanFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BooleanFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BooleanFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BooleanFilterProperty {
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.BooleanFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BooleanFilterProperty.Jsii$Proxy that = (BooleanFilterProperty.Jsii$Proxy) o;

                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                return result;
            }
        }
    }
    /**
     * Enables the creation of filtering criteria for security findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * CompositeFilterProperty compositeFilterProperty = CompositeFilterProperty.builder()
     *         .booleanFilters(List.of(OcsfBooleanFilterProperty.builder()
     *                 .fieldName("fieldName")
     *                 .filter(BooleanFilterProperty.builder()
     *                         .value(false)
     *                         .build())
     *                 .build()))
     *         .dateFilters(List.of(OcsfDateFilterProperty.builder()
     *                 .fieldName("fieldName")
     *                 .filter(DateFilterProperty.builder()
     *                         .dateRange(DateRangeProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .end("end")
     *                         .start("start")
     *                         .build())
     *                 .build()))
     *         .mapFilters(List.of(OcsfMapFilterProperty.builder()
     *                 .fieldName("fieldName")
     *                 .filter(MapFilterProperty.builder()
     *                         .comparison("comparison")
     *                         .key("key")
     *                         .value("value")
     *                         .build())
     *                 .build()))
     *         .numberFilters(List.of(OcsfNumberFilterProperty.builder()
     *                 .fieldName("fieldName")
     *                 .filter(NumberFilterProperty.builder()
     *                         .eq(123)
     *                         .gte(123)
     *                         .lte(123)
     *                         .build())
     *                 .build()))
     *         .operator("operator")
     *         .stringFilters(List.of(OcsfStringFilterProperty.builder()
     *                 .fieldName("fieldName")
     *                 .filter(StringFilterProperty.builder()
     *                         .comparison("comparison")
     *                         .value("value")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-compositefilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-compositefilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.CompositeFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(CompositeFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CompositeFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables filtering based on boolean field values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-compositefilter.html#cfn-securityhub-automationrulev2-compositefilter-booleanfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-compositefilter.html#cfn-securityhub-automationrulev2-compositefilter-booleanfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBooleanFilters() {
            return null;
        }

        /**
         * Enables filtering based on date and timestamp fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-compositefilter.html#cfn-securityhub-automationrulev2-compositefilter-datefilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-compositefilter.html#cfn-securityhub-automationrulev2-compositefilter-datefilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDateFilters() {
            return null;
        }

        /**
         * Enables the creation of filtering criteria for security findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-compositefilter.html#cfn-securityhub-automationrulev2-compositefilter-mapfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-compositefilter.html#cfn-securityhub-automationrulev2-compositefilter-mapfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMapFilters() {
            return null;
        }

        /**
         * Enables filtering based on numerical field values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-compositefilter.html#cfn-securityhub-automationrulev2-compositefilter-numberfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-compositefilter.html#cfn-securityhub-automationrulev2-compositefilter-numberfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNumberFilters() {
            return null;
        }

        /**
         * The logical operator used to combine multiple filter conditions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-compositefilter.html#cfn-securityhub-automationrulev2-compositefilter-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-compositefilter.html#cfn-securityhub-automationrulev2-compositefilter-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOperator() {
            return null;
        }

        /**
         * Enables filtering based on string field values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-compositefilter.html#cfn-securityhub-automationrulev2-compositefilter-stringfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-compositefilter.html#cfn-securityhub-automationrulev2-compositefilter-stringfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStringFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CompositeFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CompositeFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CompositeFilterProperty> {
            java.lang.Object booleanFilters;
            java.lang.Object dateFilters;
            java.lang.Object mapFilters;
            java.lang.Object numberFilters;
            java.lang.String operator;
            java.lang.Object stringFilters;

            /**
             * Sets the value of {@link CompositeFilterProperty#getBooleanFilters}
             * @param booleanFilters Enables filtering based on boolean field values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanFilters(software.amazon.awscdk.IResolvable booleanFilters) {
                this.booleanFilters = booleanFilters;
                return this;
            }

            /**
             * Sets the value of {@link CompositeFilterProperty#getBooleanFilters}
             * @param booleanFilters Enables filtering based on boolean field values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanFilters(java.util.List<? extends java.lang.Object> booleanFilters) {
                this.booleanFilters = booleanFilters;
                return this;
            }

            /**
             * Sets the value of {@link CompositeFilterProperty#getDateFilters}
             * @param dateFilters Enables filtering based on date and timestamp fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateFilters(software.amazon.awscdk.IResolvable dateFilters) {
                this.dateFilters = dateFilters;
                return this;
            }

            /**
             * Sets the value of {@link CompositeFilterProperty#getDateFilters}
             * @param dateFilters Enables filtering based on date and timestamp fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateFilters(java.util.List<? extends java.lang.Object> dateFilters) {
                this.dateFilters = dateFilters;
                return this;
            }

            /**
             * Sets the value of {@link CompositeFilterProperty#getMapFilters}
             * @param mapFilters Enables the creation of filtering criteria for security findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mapFilters(software.amazon.awscdk.IResolvable mapFilters) {
                this.mapFilters = mapFilters;
                return this;
            }

            /**
             * Sets the value of {@link CompositeFilterProperty#getMapFilters}
             * @param mapFilters Enables the creation of filtering criteria for security findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mapFilters(java.util.List<? extends java.lang.Object> mapFilters) {
                this.mapFilters = mapFilters;
                return this;
            }

            /**
             * Sets the value of {@link CompositeFilterProperty#getNumberFilters}
             * @param numberFilters Enables filtering based on numerical field values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberFilters(software.amazon.awscdk.IResolvable numberFilters) {
                this.numberFilters = numberFilters;
                return this;
            }

            /**
             * Sets the value of {@link CompositeFilterProperty#getNumberFilters}
             * @param numberFilters Enables filtering based on numerical field values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberFilters(java.util.List<? extends java.lang.Object> numberFilters) {
                this.numberFilters = numberFilters;
                return this;
            }

            /**
             * Sets the value of {@link CompositeFilterProperty#getOperator}
             * @param operator The logical operator used to combine multiple filter conditions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link CompositeFilterProperty#getStringFilters}
             * @param stringFilters Enables filtering based on string field values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringFilters(software.amazon.awscdk.IResolvable stringFilters) {
                this.stringFilters = stringFilters;
                return this;
            }

            /**
             * Sets the value of {@link CompositeFilterProperty#getStringFilters}
             * @param stringFilters Enables filtering based on string field values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringFilters(java.util.List<? extends java.lang.Object> stringFilters) {
                this.stringFilters = stringFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CompositeFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CompositeFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CompositeFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CompositeFilterProperty {
            private final java.lang.Object booleanFilters;
            private final java.lang.Object dateFilters;
            private final java.lang.Object mapFilters;
            private final java.lang.Object numberFilters;
            private final java.lang.String operator;
            private final java.lang.Object stringFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.booleanFilters = software.amazon.jsii.Kernel.get(this, "booleanFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dateFilters = software.amazon.jsii.Kernel.get(this, "dateFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mapFilters = software.amazon.jsii.Kernel.get(this, "mapFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.numberFilters = software.amazon.jsii.Kernel.get(this, "numberFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stringFilters = software.amazon.jsii.Kernel.get(this, "stringFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.booleanFilters = builder.booleanFilters;
                this.dateFilters = builder.dateFilters;
                this.mapFilters = builder.mapFilters;
                this.numberFilters = builder.numberFilters;
                this.operator = builder.operator;
                this.stringFilters = builder.stringFilters;
            }

            @Override
            public final java.lang.Object getBooleanFilters() {
                return this.booleanFilters;
            }

            @Override
            public final java.lang.Object getDateFilters() {
                return this.dateFilters;
            }

            @Override
            public final java.lang.Object getMapFilters() {
                return this.mapFilters;
            }

            @Override
            public final java.lang.Object getNumberFilters() {
                return this.numberFilters;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.lang.Object getStringFilters() {
                return this.stringFilters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBooleanFilters() != null) {
                    data.set("booleanFilters", om.valueToTree(this.getBooleanFilters()));
                }
                if (this.getDateFilters() != null) {
                    data.set("dateFilters", om.valueToTree(this.getDateFilters()));
                }
                if (this.getMapFilters() != null) {
                    data.set("mapFilters", om.valueToTree(this.getMapFilters()));
                }
                if (this.getNumberFilters() != null) {
                    data.set("numberFilters", om.valueToTree(this.getNumberFilters()));
                }
                if (this.getOperator() != null) {
                    data.set("operator", om.valueToTree(this.getOperator()));
                }
                if (this.getStringFilters() != null) {
                    data.set("stringFilters", om.valueToTree(this.getStringFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.CompositeFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CompositeFilterProperty.Jsii$Proxy that = (CompositeFilterProperty.Jsii$Proxy) o;

                if (this.booleanFilters != null ? !this.booleanFilters.equals(that.booleanFilters) : that.booleanFilters != null) return false;
                if (this.dateFilters != null ? !this.dateFilters.equals(that.dateFilters) : that.dateFilters != null) return false;
                if (this.mapFilters != null ? !this.mapFilters.equals(that.mapFilters) : that.mapFilters != null) return false;
                if (this.numberFilters != null ? !this.numberFilters.equals(that.numberFilters) : that.numberFilters != null) return false;
                if (this.operator != null ? !this.operator.equals(that.operator) : that.operator != null) return false;
                return this.stringFilters != null ? this.stringFilters.equals(that.stringFilters) : that.stringFilters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.booleanFilters != null ? this.booleanFilters.hashCode() : 0;
                result = 31 * result + (this.dateFilters != null ? this.dateFilters.hashCode() : 0);
                result = 31 * result + (this.mapFilters != null ? this.mapFilters.hashCode() : 0);
                result = 31 * result + (this.numberFilters != null ? this.numberFilters.hashCode() : 0);
                result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
                result = 31 * result + (this.stringFilters != null ? this.stringFilters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The filtering type and configuration of the automation rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * CriteriaProperty criteriaProperty = CriteriaProperty.builder()
     *         .ocsfFindingCriteria(OcsfFindingFiltersProperty.builder()
     *                 .compositeFilters(List.of(CompositeFilterProperty.builder()
     *                         .booleanFilters(List.of(OcsfBooleanFilterProperty.builder()
     *                                 .fieldName("fieldName")
     *                                 .filter(BooleanFilterProperty.builder()
     *                                         .value(false)
     *                                         .build())
     *                                 .build()))
     *                         .dateFilters(List.of(OcsfDateFilterProperty.builder()
     *                                 .fieldName("fieldName")
     *                                 .filter(DateFilterProperty.builder()
     *                                         .dateRange(DateRangeProperty.builder()
     *                                                 .unit("unit")
     *                                                 .value(123)
     *                                                 .build())
     *                                         .end("end")
     *                                         .start("start")
     *                                         .build())
     *                                 .build()))
     *                         .mapFilters(List.of(OcsfMapFilterProperty.builder()
     *                                 .fieldName("fieldName")
     *                                 .filter(MapFilterProperty.builder()
     *                                         .comparison("comparison")
     *                                         .key("key")
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .numberFilters(List.of(OcsfNumberFilterProperty.builder()
     *                                 .fieldName("fieldName")
     *                                 .filter(NumberFilterProperty.builder()
     *                                         .eq(123)
     *                                         .gte(123)
     *                                         .lte(123)
     *                                         .build())
     *                                 .build()))
     *                         .operator("operator")
     *                         .stringFilters(List.of(OcsfStringFilterProperty.builder()
     *                                 .fieldName("fieldName")
     *                                 .filter(StringFilterProperty.builder()
     *                                         .comparison("comparison")
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 .compositeOperator("compositeOperator")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-criteria.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-criteria.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.CriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(CriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The filtering conditions that align with OCSF standards.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-criteria.html#cfn-securityhub-automationrulev2-criteria-ocsffindingcriteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-criteria.html#cfn-securityhub-automationrulev2-criteria-ocsffindingcriteria</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOcsfFindingCriteria() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CriteriaProperty> {
            java.lang.Object ocsfFindingCriteria;

            /**
             * Sets the value of {@link CriteriaProperty#getOcsfFindingCriteria}
             * @param ocsfFindingCriteria The filtering conditions that align with OCSF standards.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ocsfFindingCriteria(software.amazon.awscdk.IResolvable ocsfFindingCriteria) {
                this.ocsfFindingCriteria = ocsfFindingCriteria;
                return this;
            }

            /**
             * Sets the value of {@link CriteriaProperty#getOcsfFindingCriteria}
             * @param ocsfFindingCriteria The filtering conditions that align with OCSF standards.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ocsfFindingCriteria(software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2.OcsfFindingFiltersProperty ocsfFindingCriteria) {
                this.ocsfFindingCriteria = ocsfFindingCriteria;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CriteriaProperty {
            private final java.lang.Object ocsfFindingCriteria;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ocsfFindingCriteria = software.amazon.jsii.Kernel.get(this, "ocsfFindingCriteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ocsfFindingCriteria = builder.ocsfFindingCriteria;
            }

            @Override
            public final java.lang.Object getOcsfFindingCriteria() {
                return this.ocsfFindingCriteria;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOcsfFindingCriteria() != null) {
                    data.set("ocsfFindingCriteria", om.valueToTree(this.getOcsfFindingCriteria()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.CriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CriteriaProperty.Jsii$Proxy that = (CriteriaProperty.Jsii$Proxy) o;

                return this.ocsfFindingCriteria != null ? this.ocsfFindingCriteria.equals(that.ocsfFindingCriteria) : that.ocsfFindingCriteria == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ocsfFindingCriteria != null ? this.ocsfFindingCriteria.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A date filter for querying findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * DateFilterProperty dateFilterProperty = DateFilterProperty.builder()
     *         .dateRange(DateRangeProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .end("end")
     *         .start("start")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-datefilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-datefilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.DateFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(DateFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DateFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A date range for the date filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-datefilter.html#cfn-securityhub-automationrulev2-datefilter-daterange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-datefilter.html#cfn-securityhub-automationrulev2-datefilter-daterange</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDateRange() {
            return null;
        }

        /**
         * A timestamp that provides the end date for the date filter.
         * <p>
         * For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-datefilter.html#cfn-securityhub-automationrulev2-datefilter-end">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-datefilter.html#cfn-securityhub-automationrulev2-datefilter-end</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEnd() {
            return null;
        }

        /**
         * A timestamp that provides the start date for the date filter.
         * <p>
         * For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-datefilter.html#cfn-securityhub-automationrulev2-datefilter-start">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-datefilter.html#cfn-securityhub-automationrulev2-datefilter-start</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStart() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DateFilterProperty> {
            java.lang.Object dateRange;
            java.lang.String end;
            java.lang.String start;

            /**
             * Sets the value of {@link DateFilterProperty#getDateRange}
             * @param dateRange A date range for the date filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateRange(software.amazon.awscdk.IResolvable dateRange) {
                this.dateRange = dateRange;
                return this;
            }

            /**
             * Sets the value of {@link DateFilterProperty#getDateRange}
             * @param dateRange A date range for the date filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateRange(software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2.DateRangeProperty dateRange) {
                this.dateRange = dateRange;
                return this;
            }

            /**
             * Sets the value of {@link DateFilterProperty#getEnd}
             * @param end A timestamp that provides the end date for the date filter.
             *            For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder end(java.lang.String end) {
                this.end = end;
                return this;
            }

            /**
             * Sets the value of {@link DateFilterProperty#getStart}
             * @param start A timestamp that provides the start date for the date filter.
             *              For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder start(java.lang.String start) {
                this.start = start;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DateFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DateFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DateFilterProperty {
            private final java.lang.Object dateRange;
            private final java.lang.String end;
            private final java.lang.String start;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dateRange = software.amazon.jsii.Kernel.get(this, "dateRange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.end = software.amazon.jsii.Kernel.get(this, "end", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.start = software.amazon.jsii.Kernel.get(this, "start", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dateRange = builder.dateRange;
                this.end = builder.end;
                this.start = builder.start;
            }

            @Override
            public final java.lang.Object getDateRange() {
                return this.dateRange;
            }

            @Override
            public final java.lang.String getEnd() {
                return this.end;
            }

            @Override
            public final java.lang.String getStart() {
                return this.start;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDateRange() != null) {
                    data.set("dateRange", om.valueToTree(this.getDateRange()));
                }
                if (this.getEnd() != null) {
                    data.set("end", om.valueToTree(this.getEnd()));
                }
                if (this.getStart() != null) {
                    data.set("start", om.valueToTree(this.getStart()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.DateFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DateFilterProperty.Jsii$Proxy that = (DateFilterProperty.Jsii$Proxy) o;

                if (this.dateRange != null ? !this.dateRange.equals(that.dateRange) : that.dateRange != null) return false;
                if (this.end != null ? !this.end.equals(that.end) : that.end != null) return false;
                return this.start != null ? this.start.equals(that.start) : that.start == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dateRange != null ? this.dateRange.hashCode() : 0;
                result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
                result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A date range for the date filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * DateRangeProperty dateRangeProperty = DateRangeProperty.builder()
     *         .unit("unit")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-daterange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-daterange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.DateRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(DateRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DateRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A date range unit for the date filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-daterange.html#cfn-securityhub-automationrulev2-daterange-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-daterange.html#cfn-securityhub-automationrulev2-daterange-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnit();

        /**
         * A date range value for the date filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-daterange.html#cfn-securityhub-automationrulev2-daterange-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-daterange.html#cfn-securityhub-automationrulev2-daterange-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * @return a {@link Builder} of {@link DateRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DateRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DateRangeProperty> {
            java.lang.String unit;
            java.lang.Number value;

            /**
             * Sets the value of {@link DateRangeProperty#getUnit}
             * @param unit A date range unit for the date filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Sets the value of {@link DateRangeProperty#getValue}
             * @param value A date range value for the date filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DateRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DateRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DateRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DateRangeProperty {
            private final java.lang.String unit;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.unit = java.util.Objects.requireNonNull(builder.unit, "unit is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("unit", om.valueToTree(this.getUnit()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.DateRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DateRangeProperty.Jsii$Proxy that = (DateRangeProperty.Jsii$Proxy) o;

                if (!unit.equals(that.unit)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.unit.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The settings for integrating automation rule actions with external systems or service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * ExternalIntegrationConfigurationProperty externalIntegrationConfigurationProperty = ExternalIntegrationConfigurationProperty.builder()
     *         .connectorArn("connectorArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-externalintegrationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-externalintegrationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.ExternalIntegrationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExternalIntegrationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExternalIntegrationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the connector that establishes the integration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-externalintegrationconfiguration.html#cfn-securityhub-automationrulev2-externalintegrationconfiguration-connectorarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-externalintegrationconfiguration.html#cfn-securityhub-automationrulev2-externalintegrationconfiguration-connectorarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectorArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExternalIntegrationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExternalIntegrationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExternalIntegrationConfigurationProperty> {
            java.lang.String connectorArn;

            /**
             * Sets the value of {@link ExternalIntegrationConfigurationProperty#getConnectorArn}
             * @param connectorArn The ARN of the connector that establishes the integration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorArn(java.lang.String connectorArn) {
                this.connectorArn = connectorArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExternalIntegrationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExternalIntegrationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExternalIntegrationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExternalIntegrationConfigurationProperty {
            private final java.lang.String connectorArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectorArn = software.amazon.jsii.Kernel.get(this, "connectorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectorArn = builder.connectorArn;
            }

            @Override
            public final java.lang.String getConnectorArn() {
                return this.connectorArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnectorArn() != null) {
                    data.set("connectorArn", om.valueToTree(this.getConnectorArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.ExternalIntegrationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExternalIntegrationConfigurationProperty.Jsii$Proxy that = (ExternalIntegrationConfigurationProperty.Jsii$Proxy) o;

                return this.connectorArn != null ? this.connectorArn.equals(that.connectorArn) : that.connectorArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectorArn != null ? this.connectorArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A map filter for filtering AWS Security Hub findings.
     * <p>
     * Each map filter provides the field to check for, the value to check for, and the comparison operator.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * MapFilterProperty mapFilterProperty = MapFilterProperty.builder()
     *         .comparison("comparison")
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-mapfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-mapfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.MapFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(MapFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MapFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The condition to apply to the key value when filtering Security Hub findings with a map filter.
         * <p>
         * To search for values that have the filter value, use one of the following comparison operators:
         * <p>
         * <ul>
         * <li>To search for values that include the filter value, use <code>CONTAINS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department CONTAINS Security</code> matches findings that include the value <code>Security</code> for the <code>Department</code> tag. In the same example, a finding with a value of <code>Security team</code> for the <code>Department</code> tag is a match.</li>
         * <li>To search for values that exactly match the filter value, use <code>EQUALS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department EQUALS Security</code> matches findings that have the value <code>Security</code> for the <code>Department</code> tag.</li>
         * </ul>
         * <p>
         * <code>CONTAINS</code> and <code>EQUALS</code> filters on the same field are joined by <code>OR</code> . A finding matches if it matches any one of those filters. For example, the filters <code>Department CONTAINS Security OR Department CONTAINS Finance</code> match a finding that includes either <code>Security</code> , <code>Finance</code> , or both values.
         * <p>
         * To search for values that don't have the filter value, use one of the following comparison operators:
         * <p>
         * <ul>
         * <li>To search for values that exclude the filter value, use <code>NOT_CONTAINS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_CONTAINS Finance</code> matches findings that exclude the value <code>Finance</code> for the <code>Department</code> tag.</li>
         * <li>To search for values other than the filter value, use <code>NOT_EQUALS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_EQUALS Finance</code> matches findings that don’t have the value <code>Finance</code> for the <code>Department</code> tag.</li>
         * </ul>
         * <p>
         * <code>NOT_CONTAINS</code> and <code>NOT_EQUALS</code> filters on the same field are joined by <code>AND</code> . A finding matches only if it matches all of those filters. For example, the filters <code>Department NOT_CONTAINS Security AND Department NOT_CONTAINS Finance</code> match a finding that excludes both the <code>Security</code> and <code>Finance</code> values.
         * <p>
         * <code>CONTAINS</code> filters can only be used with other <code>CONTAINS</code> filters. <code>NOT_CONTAINS</code> filters can only be used with other <code>NOT_CONTAINS</code> filters.
         * <p>
         * You can’t have both a <code>CONTAINS</code> filter and a <code>NOT_CONTAINS</code> filter on the same field. Similarly, you can’t have both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> filter on the same field. Combining filters in this way returns an error.
         * <p>
         * <code>CONTAINS</code> and <code>NOT_CONTAINS</code> operators can be used only with automation rules. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html">Automation rules</a> in the <em>AWS Security Hub User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-mapfilter.html#cfn-securityhub-automationrulev2-mapfilter-comparison">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-mapfilter.html#cfn-securityhub-automationrulev2-mapfilter-comparison</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComparison();

        /**
         * The key of the map filter.
         * <p>
         * For example, for <code>ResourceTags</code> , <code>Key</code> identifies the name of the tag. For <code>UserDefinedFields</code> , <code>Key</code> is the name of the field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-mapfilter.html#cfn-securityhub-automationrulev2-mapfilter-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-mapfilter.html#cfn-securityhub-automationrulev2-mapfilter-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value for the key in the map filter.
         * <p>
         * Filter values are case sensitive. For example, one of the values for a tag called <code>Department</code> might be <code>Security</code> . If you provide <code>security</code> as the filter value, then there's no match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-mapfilter.html#cfn-securityhub-automationrulev2-mapfilter-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-mapfilter.html#cfn-securityhub-automationrulev2-mapfilter-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link MapFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MapFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MapFilterProperty> {
            java.lang.String comparison;
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link MapFilterProperty#getComparison}
             * @param comparison The condition to apply to the key value when filtering Security Hub findings with a map filter. This parameter is required.
             *                   To search for values that have the filter value, use one of the following comparison operators:
             *                   <p>
             *                   <ul>
             *                   <li>To search for values that include the filter value, use <code>CONTAINS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department CONTAINS Security</code> matches findings that include the value <code>Security</code> for the <code>Department</code> tag. In the same example, a finding with a value of <code>Security team</code> for the <code>Department</code> tag is a match.</li>
             *                   <li>To search for values that exactly match the filter value, use <code>EQUALS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department EQUALS Security</code> matches findings that have the value <code>Security</code> for the <code>Department</code> tag.</li>
             *                   </ul>
             *                   <p>
             *                   <code>CONTAINS</code> and <code>EQUALS</code> filters on the same field are joined by <code>OR</code> . A finding matches if it matches any one of those filters. For example, the filters <code>Department CONTAINS Security OR Department CONTAINS Finance</code> match a finding that includes either <code>Security</code> , <code>Finance</code> , or both values.
             *                   <p>
             *                   To search for values that don't have the filter value, use one of the following comparison operators:
             *                   <p>
             *                   <ul>
             *                   <li>To search for values that exclude the filter value, use <code>NOT_CONTAINS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_CONTAINS Finance</code> matches findings that exclude the value <code>Finance</code> for the <code>Department</code> tag.</li>
             *                   <li>To search for values other than the filter value, use <code>NOT_EQUALS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_EQUALS Finance</code> matches findings that don’t have the value <code>Finance</code> for the <code>Department</code> tag.</li>
             *                   </ul>
             *                   <p>
             *                   <code>NOT_CONTAINS</code> and <code>NOT_EQUALS</code> filters on the same field are joined by <code>AND</code> . A finding matches only if it matches all of those filters. For example, the filters <code>Department NOT_CONTAINS Security AND Department NOT_CONTAINS Finance</code> match a finding that excludes both the <code>Security</code> and <code>Finance</code> values.
             *                   <p>
             *                   <code>CONTAINS</code> filters can only be used with other <code>CONTAINS</code> filters. <code>NOT_CONTAINS</code> filters can only be used with other <code>NOT_CONTAINS</code> filters.
             *                   <p>
             *                   You can’t have both a <code>CONTAINS</code> filter and a <code>NOT_CONTAINS</code> filter on the same field. Similarly, you can’t have both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> filter on the same field. Combining filters in this way returns an error.
             *                   <p>
             *                   <code>CONTAINS</code> and <code>NOT_CONTAINS</code> operators can be used only with automation rules. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html">Automation rules</a> in the <em>AWS Security Hub User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparison(java.lang.String comparison) {
                this.comparison = comparison;
                return this;
            }

            /**
             * Sets the value of {@link MapFilterProperty#getKey}
             * @param key The key of the map filter. This parameter is required.
             *            For example, for <code>ResourceTags</code> , <code>Key</code> identifies the name of the tag. For <code>UserDefinedFields</code> , <code>Key</code> is the name of the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link MapFilterProperty#getValue}
             * @param value The value for the key in the map filter. This parameter is required.
             *              Filter values are case sensitive. For example, one of the values for a tag called <code>Department</code> might be <code>Security</code> . If you provide <code>security</code> as the filter value, then there's no match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MapFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MapFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MapFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MapFilterProperty {
            private final java.lang.String comparison;
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparison = software.amazon.jsii.Kernel.get(this, "comparison", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparison = java.util.Objects.requireNonNull(builder.comparison, "comparison is required");
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getComparison() {
                return this.comparison;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparison", om.valueToTree(this.getComparison()));
                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.MapFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MapFilterProperty.Jsii$Proxy that = (MapFilterProperty.Jsii$Proxy) o;

                if (!comparison.equals(that.comparison)) return false;
                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.comparison.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * A number filter for querying findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * NumberFilterProperty numberFilterProperty = NumberFilterProperty.builder()
     *         .eq(123)
     *         .gte(123)
     *         .lte(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-numberfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-numberfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.NumberFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(NumberFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NumberFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The equal-to condition to be applied to a single field when querying for findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-numberfilter.html#cfn-securityhub-automationrulev2-numberfilter-eq">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-numberfilter.html#cfn-securityhub-automationrulev2-numberfilter-eq</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEq() {
            return null;
        }

        /**
         * The greater-than-equal condition to be applied to a single field when querying for findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-numberfilter.html#cfn-securityhub-automationrulev2-numberfilter-gte">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-numberfilter.html#cfn-securityhub-automationrulev2-numberfilter-gte</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGte() {
            return null;
        }

        /**
         * The less-than-equal condition to be applied to a single field when querying for findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-numberfilter.html#cfn-securityhub-automationrulev2-numberfilter-lte">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-numberfilter.html#cfn-securityhub-automationrulev2-numberfilter-lte</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLte() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NumberFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NumberFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NumberFilterProperty> {
            java.lang.Number eq;
            java.lang.Number gte;
            java.lang.Number lte;

            /**
             * Sets the value of {@link NumberFilterProperty#getEq}
             * @param eq The equal-to condition to be applied to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eq(java.lang.Number eq) {
                this.eq = eq;
                return this;
            }

            /**
             * Sets the value of {@link NumberFilterProperty#getGte}
             * @param gte The greater-than-equal condition to be applied to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gte(java.lang.Number gte) {
                this.gte = gte;
                return this;
            }

            /**
             * Sets the value of {@link NumberFilterProperty#getLte}
             * @param lte The less-than-equal condition to be applied to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lte(java.lang.Number lte) {
                this.lte = lte;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NumberFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NumberFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NumberFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NumberFilterProperty {
            private final java.lang.Number eq;
            private final java.lang.Number gte;
            private final java.lang.Number lte;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eq = software.amazon.jsii.Kernel.get(this, "eq", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.gte = software.amazon.jsii.Kernel.get(this, "gte", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.lte = software.amazon.jsii.Kernel.get(this, "lte", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eq = builder.eq;
                this.gte = builder.gte;
                this.lte = builder.lte;
            }

            @Override
            public final java.lang.Number getEq() {
                return this.eq;
            }

            @Override
            public final java.lang.Number getGte() {
                return this.gte;
            }

            @Override
            public final java.lang.Number getLte() {
                return this.lte;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEq() != null) {
                    data.set("eq", om.valueToTree(this.getEq()));
                }
                if (this.getGte() != null) {
                    data.set("gte", om.valueToTree(this.getGte()));
                }
                if (this.getLte() != null) {
                    data.set("lte", om.valueToTree(this.getLte()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.NumberFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NumberFilterProperty.Jsii$Proxy that = (NumberFilterProperty.Jsii$Proxy) o;

                if (this.eq != null ? !this.eq.equals(that.eq) : that.eq != null) return false;
                if (this.gte != null ? !this.gte.equals(that.gte) : that.gte != null) return false;
                return this.lte != null ? this.lte.equals(that.lte) : that.lte == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eq != null ? this.eq.hashCode() : 0;
                result = 31 * result + (this.gte != null ? this.gte.hashCode() : 0);
                result = 31 * result + (this.lte != null ? this.lte.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Enables filtering of security findings based on boolean field values in OCSF.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * OcsfBooleanFilterProperty ocsfBooleanFilterProperty = OcsfBooleanFilterProperty.builder()
     *         .fieldName("fieldName")
     *         .filter(BooleanFilterProperty.builder()
     *                 .value(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfbooleanfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfbooleanfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.OcsfBooleanFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(OcsfBooleanFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OcsfBooleanFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfbooleanfilter.html#cfn-securityhub-automationrulev2-ocsfbooleanfilter-fieldname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfbooleanfilter.html#cfn-securityhub-automationrulev2-ocsfbooleanfilter-fieldname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFieldName();

        /**
         * Enables filtering of security findings based on boolean field values in OCSF.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfbooleanfilter.html#cfn-securityhub-automationrulev2-ocsfbooleanfilter-filter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfbooleanfilter.html#cfn-securityhub-automationrulev2-ocsfbooleanfilter-filter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link OcsfBooleanFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OcsfBooleanFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OcsfBooleanFilterProperty> {
            java.lang.String fieldName;
            java.lang.Object filter;

            /**
             * Sets the value of {@link OcsfBooleanFilterProperty#getFieldName}
             * @param fieldName The name of the field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldName(java.lang.String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            /**
             * Sets the value of {@link OcsfBooleanFilterProperty#getFilter}
             * @param filter Enables filtering of security findings based on boolean field values in OCSF. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link OcsfBooleanFilterProperty#getFilter}
             * @param filter Enables filtering of security findings based on boolean field values in OCSF. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2.BooleanFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OcsfBooleanFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OcsfBooleanFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OcsfBooleanFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OcsfBooleanFilterProperty {
            private final java.lang.String fieldName;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldName = software.amazon.jsii.Kernel.get(this, "fieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldName = java.util.Objects.requireNonNull(builder.fieldName, "fieldName is required");
                this.filter = java.util.Objects.requireNonNull(builder.filter, "filter is required");
            }

            @Override
            public final java.lang.String getFieldName() {
                return this.fieldName;
            }

            @Override
            public final java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldName", om.valueToTree(this.getFieldName()));
                data.set("filter", om.valueToTree(this.getFilter()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.OcsfBooleanFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OcsfBooleanFilterProperty.Jsii$Proxy that = (OcsfBooleanFilterProperty.Jsii$Proxy) o;

                if (!fieldName.equals(that.fieldName)) return false;
                return this.filter.equals(that.filter);
            }

            @Override
            public final int hashCode() {
                int result = this.fieldName.hashCode();
                result = 31 * result + (this.filter.hashCode());
                return result;
            }
        }
    }
    /**
     * Enables filtering of security findings based on date and timestamp fields in OCSF.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * OcsfDateFilterProperty ocsfDateFilterProperty = OcsfDateFilterProperty.builder()
     *         .fieldName("fieldName")
     *         .filter(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfdatefilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfdatefilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.OcsfDateFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(OcsfDateFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OcsfDateFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfdatefilter.html#cfn-securityhub-automationrulev2-ocsfdatefilter-fieldname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfdatefilter.html#cfn-securityhub-automationrulev2-ocsfdatefilter-fieldname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFieldName();

        /**
         * Enables filtering of security findings based on date and timestamp fields in OCSF.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfdatefilter.html#cfn-securityhub-automationrulev2-ocsfdatefilter-filter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfdatefilter.html#cfn-securityhub-automationrulev2-ocsfdatefilter-filter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link OcsfDateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OcsfDateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OcsfDateFilterProperty> {
            java.lang.String fieldName;
            java.lang.Object filter;

            /**
             * Sets the value of {@link OcsfDateFilterProperty#getFieldName}
             * @param fieldName The name of the field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldName(java.lang.String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            /**
             * Sets the value of {@link OcsfDateFilterProperty#getFilter}
             * @param filter Enables filtering of security findings based on date and timestamp fields in OCSF. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link OcsfDateFilterProperty#getFilter}
             * @param filter Enables filtering of security findings based on date and timestamp fields in OCSF. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2.DateFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OcsfDateFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OcsfDateFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OcsfDateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OcsfDateFilterProperty {
            private final java.lang.String fieldName;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldName = software.amazon.jsii.Kernel.get(this, "fieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldName = java.util.Objects.requireNonNull(builder.fieldName, "fieldName is required");
                this.filter = java.util.Objects.requireNonNull(builder.filter, "filter is required");
            }

            @Override
            public final java.lang.String getFieldName() {
                return this.fieldName;
            }

            @Override
            public final java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldName", om.valueToTree(this.getFieldName()));
                data.set("filter", om.valueToTree(this.getFilter()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.OcsfDateFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OcsfDateFilterProperty.Jsii$Proxy that = (OcsfDateFilterProperty.Jsii$Proxy) o;

                if (!fieldName.equals(that.fieldName)) return false;
                return this.filter.equals(that.filter);
            }

            @Override
            public final int hashCode() {
                int result = this.fieldName.hashCode();
                result = 31 * result + (this.filter.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the filtering criteria for security findings using OCSF.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * OcsfFindingFiltersProperty ocsfFindingFiltersProperty = OcsfFindingFiltersProperty.builder()
     *         .compositeFilters(List.of(CompositeFilterProperty.builder()
     *                 .booleanFilters(List.of(OcsfBooleanFilterProperty.builder()
     *                         .fieldName("fieldName")
     *                         .filter(BooleanFilterProperty.builder()
     *                                 .value(false)
     *                                 .build())
     *                         .build()))
     *                 .dateFilters(List.of(OcsfDateFilterProperty.builder()
     *                         .fieldName("fieldName")
     *                         .filter(DateFilterProperty.builder()
     *                                 .dateRange(DateRangeProperty.builder()
     *                                         .unit("unit")
     *                                         .value(123)
     *                                         .build())
     *                                 .end("end")
     *                                 .start("start")
     *                                 .build())
     *                         .build()))
     *                 .mapFilters(List.of(OcsfMapFilterProperty.builder()
     *                         .fieldName("fieldName")
     *                         .filter(MapFilterProperty.builder()
     *                                 .comparison("comparison")
     *                                 .key("key")
     *                                 .value("value")
     *                                 .build())
     *                         .build()))
     *                 .numberFilters(List.of(OcsfNumberFilterProperty.builder()
     *                         .fieldName("fieldName")
     *                         .filter(NumberFilterProperty.builder()
     *                                 .eq(123)
     *                                 .gte(123)
     *                                 .lte(123)
     *                                 .build())
     *                         .build()))
     *                 .operator("operator")
     *                 .stringFilters(List.of(OcsfStringFilterProperty.builder()
     *                         .fieldName("fieldName")
     *                         .filter(StringFilterProperty.builder()
     *                                 .comparison("comparison")
     *                                 .value("value")
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         .compositeOperator("compositeOperator")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsffindingfilters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsffindingfilters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.OcsfFindingFiltersProperty")
    @software.amazon.jsii.Jsii.Proxy(OcsfFindingFiltersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OcsfFindingFiltersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables the creation of complex filtering conditions by combining filter criteria.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsffindingfilters.html#cfn-securityhub-automationrulev2-ocsffindingfilters-compositefilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsffindingfilters.html#cfn-securityhub-automationrulev2-ocsffindingfilters-compositefilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCompositeFilters() {
            return null;
        }

        /**
         * The logical operators used to combine the filtering on multiple <code>CompositeFilters</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsffindingfilters.html#cfn-securityhub-automationrulev2-ocsffindingfilters-compositeoperator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsffindingfilters.html#cfn-securityhub-automationrulev2-ocsffindingfilters-compositeoperator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompositeOperator() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OcsfFindingFiltersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OcsfFindingFiltersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OcsfFindingFiltersProperty> {
            java.lang.Object compositeFilters;
            java.lang.String compositeOperator;

            /**
             * Sets the value of {@link OcsfFindingFiltersProperty#getCompositeFilters}
             * @param compositeFilters Enables the creation of complex filtering conditions by combining filter criteria.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compositeFilters(software.amazon.awscdk.IResolvable compositeFilters) {
                this.compositeFilters = compositeFilters;
                return this;
            }

            /**
             * Sets the value of {@link OcsfFindingFiltersProperty#getCompositeFilters}
             * @param compositeFilters Enables the creation of complex filtering conditions by combining filter criteria.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compositeFilters(java.util.List<? extends java.lang.Object> compositeFilters) {
                this.compositeFilters = compositeFilters;
                return this;
            }

            /**
             * Sets the value of {@link OcsfFindingFiltersProperty#getCompositeOperator}
             * @param compositeOperator The logical operators used to combine the filtering on multiple <code>CompositeFilters</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compositeOperator(java.lang.String compositeOperator) {
                this.compositeOperator = compositeOperator;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OcsfFindingFiltersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OcsfFindingFiltersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OcsfFindingFiltersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OcsfFindingFiltersProperty {
            private final java.lang.Object compositeFilters;
            private final java.lang.String compositeOperator;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.compositeFilters = software.amazon.jsii.Kernel.get(this, "compositeFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.compositeOperator = software.amazon.jsii.Kernel.get(this, "compositeOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.compositeFilters = builder.compositeFilters;
                this.compositeOperator = builder.compositeOperator;
            }

            @Override
            public final java.lang.Object getCompositeFilters() {
                return this.compositeFilters;
            }

            @Override
            public final java.lang.String getCompositeOperator() {
                return this.compositeOperator;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCompositeFilters() != null) {
                    data.set("compositeFilters", om.valueToTree(this.getCompositeFilters()));
                }
                if (this.getCompositeOperator() != null) {
                    data.set("compositeOperator", om.valueToTree(this.getCompositeOperator()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.OcsfFindingFiltersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OcsfFindingFiltersProperty.Jsii$Proxy that = (OcsfFindingFiltersProperty.Jsii$Proxy) o;

                if (this.compositeFilters != null ? !this.compositeFilters.equals(that.compositeFilters) : that.compositeFilters != null) return false;
                return this.compositeOperator != null ? this.compositeOperator.equals(that.compositeOperator) : that.compositeOperator == null;
            }

            @Override
            public final int hashCode() {
                int result = this.compositeFilters != null ? this.compositeFilters.hashCode() : 0;
                result = 31 * result + (this.compositeOperator != null ? this.compositeOperator.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Enables filtering of security findings based on map field values in OCSF.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * OcsfMapFilterProperty ocsfMapFilterProperty = OcsfMapFilterProperty.builder()
     *         .fieldName("fieldName")
     *         .filter(MapFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .key("key")
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfmapfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfmapfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.OcsfMapFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(OcsfMapFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OcsfMapFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfmapfilter.html#cfn-securityhub-automationrulev2-ocsfmapfilter-fieldname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfmapfilter.html#cfn-securityhub-automationrulev2-ocsfmapfilter-fieldname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFieldName();

        /**
         * Enables filtering of security findings based on map field values in OCSF.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfmapfilter.html#cfn-securityhub-automationrulev2-ocsfmapfilter-filter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfmapfilter.html#cfn-securityhub-automationrulev2-ocsfmapfilter-filter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link OcsfMapFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OcsfMapFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OcsfMapFilterProperty> {
            java.lang.String fieldName;
            java.lang.Object filter;

            /**
             * Sets the value of {@link OcsfMapFilterProperty#getFieldName}
             * @param fieldName The name of the field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldName(java.lang.String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            /**
             * Sets the value of {@link OcsfMapFilterProperty#getFilter}
             * @param filter Enables filtering of security findings based on map field values in OCSF. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link OcsfMapFilterProperty#getFilter}
             * @param filter Enables filtering of security findings based on map field values in OCSF. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2.MapFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OcsfMapFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OcsfMapFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OcsfMapFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OcsfMapFilterProperty {
            private final java.lang.String fieldName;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldName = software.amazon.jsii.Kernel.get(this, "fieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldName = java.util.Objects.requireNonNull(builder.fieldName, "fieldName is required");
                this.filter = java.util.Objects.requireNonNull(builder.filter, "filter is required");
            }

            @Override
            public final java.lang.String getFieldName() {
                return this.fieldName;
            }

            @Override
            public final java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldName", om.valueToTree(this.getFieldName()));
                data.set("filter", om.valueToTree(this.getFilter()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.OcsfMapFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OcsfMapFilterProperty.Jsii$Proxy that = (OcsfMapFilterProperty.Jsii$Proxy) o;

                if (!fieldName.equals(that.fieldName)) return false;
                return this.filter.equals(that.filter);
            }

            @Override
            public final int hashCode() {
                int result = this.fieldName.hashCode();
                result = 31 * result + (this.filter.hashCode());
                return result;
            }
        }
    }
    /**
     * Enables filtering of security findings based on numerical field values in OCSF.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * OcsfNumberFilterProperty ocsfNumberFilterProperty = OcsfNumberFilterProperty.builder()
     *         .fieldName("fieldName")
     *         .filter(NumberFilterProperty.builder()
     *                 .eq(123)
     *                 .gte(123)
     *                 .lte(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfnumberfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfnumberfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.OcsfNumberFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(OcsfNumberFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OcsfNumberFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfnumberfilter.html#cfn-securityhub-automationrulev2-ocsfnumberfilter-fieldname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfnumberfilter.html#cfn-securityhub-automationrulev2-ocsfnumberfilter-fieldname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFieldName();

        /**
         * Enables filtering of security findings based on numerical field values in OCSF.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfnumberfilter.html#cfn-securityhub-automationrulev2-ocsfnumberfilter-filter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfnumberfilter.html#cfn-securityhub-automationrulev2-ocsfnumberfilter-filter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link OcsfNumberFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OcsfNumberFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OcsfNumberFilterProperty> {
            java.lang.String fieldName;
            java.lang.Object filter;

            /**
             * Sets the value of {@link OcsfNumberFilterProperty#getFieldName}
             * @param fieldName The name of the field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldName(java.lang.String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            /**
             * Sets the value of {@link OcsfNumberFilterProperty#getFilter}
             * @param filter Enables filtering of security findings based on numerical field values in OCSF. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link OcsfNumberFilterProperty#getFilter}
             * @param filter Enables filtering of security findings based on numerical field values in OCSF. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2.NumberFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OcsfNumberFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OcsfNumberFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OcsfNumberFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OcsfNumberFilterProperty {
            private final java.lang.String fieldName;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldName = software.amazon.jsii.Kernel.get(this, "fieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldName = java.util.Objects.requireNonNull(builder.fieldName, "fieldName is required");
                this.filter = java.util.Objects.requireNonNull(builder.filter, "filter is required");
            }

            @Override
            public final java.lang.String getFieldName() {
                return this.fieldName;
            }

            @Override
            public final java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldName", om.valueToTree(this.getFieldName()));
                data.set("filter", om.valueToTree(this.getFilter()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.OcsfNumberFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OcsfNumberFilterProperty.Jsii$Proxy that = (OcsfNumberFilterProperty.Jsii$Proxy) o;

                if (!fieldName.equals(that.fieldName)) return false;
                return this.filter.equals(that.filter);
            }

            @Override
            public final int hashCode() {
                int result = this.fieldName.hashCode();
                result = 31 * result + (this.filter.hashCode());
                return result;
            }
        }
    }
    /**
     * Enables filtering of security findings based on string field values in OCSF.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * OcsfStringFilterProperty ocsfStringFilterProperty = OcsfStringFilterProperty.builder()
     *         .fieldName("fieldName")
     *         .filter(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfstringfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfstringfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.OcsfStringFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(OcsfStringFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OcsfStringFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfstringfilter.html#cfn-securityhub-automationrulev2-ocsfstringfilter-fieldname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfstringfilter.html#cfn-securityhub-automationrulev2-ocsfstringfilter-fieldname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFieldName();

        /**
         * Enables filtering of security findings based on string field values in OCSF.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfstringfilter.html#cfn-securityhub-automationrulev2-ocsfstringfilter-filter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-ocsfstringfilter.html#cfn-securityhub-automationrulev2-ocsfstringfilter-filter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFilter();

        /**
         * @return a {@link Builder} of {@link OcsfStringFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OcsfStringFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OcsfStringFilterProperty> {
            java.lang.String fieldName;
            java.lang.Object filter;

            /**
             * Sets the value of {@link OcsfStringFilterProperty#getFieldName}
             * @param fieldName The name of the field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldName(java.lang.String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            /**
             * Sets the value of {@link OcsfStringFilterProperty#getFilter}
             * @param filter Enables filtering of security findings based on string field values in OCSF. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link OcsfStringFilterProperty#getFilter}
             * @param filter Enables filtering of security findings based on string field values in OCSF. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2.StringFilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OcsfStringFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OcsfStringFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OcsfStringFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OcsfStringFilterProperty {
            private final java.lang.String fieldName;
            private final java.lang.Object filter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldName = software.amazon.jsii.Kernel.get(this, "fieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldName = java.util.Objects.requireNonNull(builder.fieldName, "fieldName is required");
                this.filter = java.util.Objects.requireNonNull(builder.filter, "filter is required");
            }

            @Override
            public final java.lang.String getFieldName() {
                return this.fieldName;
            }

            @Override
            public final java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldName", om.valueToTree(this.getFieldName()));
                data.set("filter", om.valueToTree(this.getFilter()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.OcsfStringFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OcsfStringFilterProperty.Jsii$Proxy that = (OcsfStringFilterProperty.Jsii$Proxy) o;

                if (!fieldName.equals(that.fieldName)) return false;
                return this.filter.equals(that.filter);
            }

            @Override
            public final int hashCode() {
                int result = this.fieldName.hashCode();
                result = 31 * result + (this.filter.hashCode());
                return result;
            }
        }
    }
    /**
     * A string filter for filtering AWS Security Hub findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * StringFilterProperty stringFilterProperty = StringFilterProperty.builder()
     *         .comparison("comparison")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-stringfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-stringfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.StringFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(StringFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StringFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The condition to apply to a string value when filtering Security Hub findings.
         * <p>
         * To search for values that have the filter value, use one of the following comparison operators:
         * <p>
         * <ul>
         * <li>To search for values that include the filter value, use <code>CONTAINS</code> . For example, the filter <code>Title CONTAINS CloudFront</code> matches findings that have a <code>Title</code> that includes the string CloudFront.</li>
         * <li>To search for values that exactly match the filter value, use <code>EQUALS</code> . For example, the filter <code>AwsAccountId EQUALS 123456789012</code> only matches findings that have an account ID of <code>123456789012</code> .</li>
         * <li>To search for values that start with the filter value, use <code>PREFIX</code> . For example, the filter <code>ResourceRegion PREFIX us</code> matches findings that have a <code>ResourceRegion</code> that starts with <code>us</code> . A <code>ResourceRegion</code> that starts with a different value, such as <code>af</code> , <code>ap</code> , or <code>ca</code> , doesn't match.</li>
         * </ul>
         * <p>
         * <code>CONTAINS</code> , <code>EQUALS</code> , and <code>PREFIX</code> filters on the same field are joined by <code>OR</code> . A finding matches if it matches any one of those filters. For example, the filters <code>Title CONTAINS CloudFront OR Title CONTAINS CloudWatch</code> match a finding that includes either <code>CloudFront</code> , <code>CloudWatch</code> , or both strings in the title.
         * <p>
         * To search for values that don’t have the filter value, use one of the following comparison operators:
         * <p>
         * <ul>
         * <li>To search for values that exclude the filter value, use <code>NOT_CONTAINS</code> . For example, the filter <code>Title NOT_CONTAINS CloudFront</code> matches findings that have a <code>Title</code> that excludes the string CloudFront.</li>
         * <li>To search for values other than the filter value, use <code>NOT_EQUALS</code> . For example, the filter <code>AwsAccountId NOT_EQUALS 123456789012</code> only matches findings that have an account ID other than <code>123456789012</code> .</li>
         * <li>To search for values that don't start with the filter value, use <code>PREFIX_NOT_EQUALS</code> . For example, the filter <code>ResourceRegion PREFIX_NOT_EQUALS us</code> matches findings with a <code>ResourceRegion</code> that starts with a value other than <code>us</code> .</li>
         * </ul>
         * <p>
         * <code>NOT_CONTAINS</code> , <code>NOT_EQUALS</code> , and <code>PREFIX_NOT_EQUALS</code> filters on the same field are joined by <code>AND</code> . A finding matches only if it matches all of those filters. For example, the filters <code>Title NOT_CONTAINS CloudFront AND Title NOT_CONTAINS CloudWatch</code> match a finding that excludes both <code>CloudFront</code> and <code>CloudWatch</code> in the title.
         * <p>
         * You can’t have both a <code>CONTAINS</code> filter and a <code>NOT_CONTAINS</code> filter on the same field. Similarly, you can't provide both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filter on the same field. Combining filters in this way returns an error. <code>CONTAINS</code> filters can only be used with other <code>CONTAINS</code> filters. <code>NOT_CONTAINS</code> filters can only be used with other <code>NOT_CONTAINS</code> filters.
         * <p>
         * You can combine <code>PREFIX</code> filters with <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filters for the same field. Security Hub first processes the <code>PREFIX</code> filters, and then the <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filters.
         * <p>
         * For example, for the following filters, Security Hub first identifies findings that have resource types that start with either <code>AwsIam</code> or <code>AwsEc2</code> . It then excludes findings that have a resource type of <code>AwsIamPolicy</code> and findings that have a resource type of <code>AwsEc2NetworkInterface</code> .
         * <p>
         * <ul>
         * <li><code>ResourceType PREFIX AwsIam</code></li>
         * <li><code>ResourceType PREFIX AwsEc2</code></li>
         * <li><code>ResourceType NOT_EQUALS AwsIamPolicy</code></li>
         * <li><code>ResourceType NOT_EQUALS AwsEc2NetworkInterface</code></li>
         * </ul>
         * <p>
         * <code>CONTAINS</code> and <code>NOT_CONTAINS</code> operators can be used only with automation rules V1. <code>CONTAINS_WORD</code> operator is only supported in <code>GetFindingsV2</code> , <code>GetFindingStatisticsV2</code> , <code>GetResourcesV2</code> , and <code>GetResourceStatisticsV2</code> APIs. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html">Automation rules</a> in the <em>AWS Security Hub User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-stringfilter.html#cfn-securityhub-automationrulev2-stringfilter-comparison">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-stringfilter.html#cfn-securityhub-automationrulev2-stringfilter-comparison</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComparison();

        /**
         * The string filter value.
         * <p>
         * Filter values are case sensitive. For example, the product name for control-based findings is <code>Security Hub</code> . If you provide <code>security hub</code> as the filter value, there's no match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-stringfilter.html#cfn-securityhub-automationrulev2-stringfilter-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrulev2-stringfilter.html#cfn-securityhub-automationrulev2-stringfilter-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link StringFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StringFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StringFilterProperty> {
            java.lang.String comparison;
            java.lang.String value;

            /**
             * Sets the value of {@link StringFilterProperty#getComparison}
             * @param comparison The condition to apply to a string value when filtering Security Hub findings. This parameter is required.
             *                   To search for values that have the filter value, use one of the following comparison operators:
             *                   <p>
             *                   <ul>
             *                   <li>To search for values that include the filter value, use <code>CONTAINS</code> . For example, the filter <code>Title CONTAINS CloudFront</code> matches findings that have a <code>Title</code> that includes the string CloudFront.</li>
             *                   <li>To search for values that exactly match the filter value, use <code>EQUALS</code> . For example, the filter <code>AwsAccountId EQUALS 123456789012</code> only matches findings that have an account ID of <code>123456789012</code> .</li>
             *                   <li>To search for values that start with the filter value, use <code>PREFIX</code> . For example, the filter <code>ResourceRegion PREFIX us</code> matches findings that have a <code>ResourceRegion</code> that starts with <code>us</code> . A <code>ResourceRegion</code> that starts with a different value, such as <code>af</code> , <code>ap</code> , or <code>ca</code> , doesn't match.</li>
             *                   </ul>
             *                   <p>
             *                   <code>CONTAINS</code> , <code>EQUALS</code> , and <code>PREFIX</code> filters on the same field are joined by <code>OR</code> . A finding matches if it matches any one of those filters. For example, the filters <code>Title CONTAINS CloudFront OR Title CONTAINS CloudWatch</code> match a finding that includes either <code>CloudFront</code> , <code>CloudWatch</code> , or both strings in the title.
             *                   <p>
             *                   To search for values that don’t have the filter value, use one of the following comparison operators:
             *                   <p>
             *                   <ul>
             *                   <li>To search for values that exclude the filter value, use <code>NOT_CONTAINS</code> . For example, the filter <code>Title NOT_CONTAINS CloudFront</code> matches findings that have a <code>Title</code> that excludes the string CloudFront.</li>
             *                   <li>To search for values other than the filter value, use <code>NOT_EQUALS</code> . For example, the filter <code>AwsAccountId NOT_EQUALS 123456789012</code> only matches findings that have an account ID other than <code>123456789012</code> .</li>
             *                   <li>To search for values that don't start with the filter value, use <code>PREFIX_NOT_EQUALS</code> . For example, the filter <code>ResourceRegion PREFIX_NOT_EQUALS us</code> matches findings with a <code>ResourceRegion</code> that starts with a value other than <code>us</code> .</li>
             *                   </ul>
             *                   <p>
             *                   <code>NOT_CONTAINS</code> , <code>NOT_EQUALS</code> , and <code>PREFIX_NOT_EQUALS</code> filters on the same field are joined by <code>AND</code> . A finding matches only if it matches all of those filters. For example, the filters <code>Title NOT_CONTAINS CloudFront AND Title NOT_CONTAINS CloudWatch</code> match a finding that excludes both <code>CloudFront</code> and <code>CloudWatch</code> in the title.
             *                   <p>
             *                   You can’t have both a <code>CONTAINS</code> filter and a <code>NOT_CONTAINS</code> filter on the same field. Similarly, you can't provide both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filter on the same field. Combining filters in this way returns an error. <code>CONTAINS</code> filters can only be used with other <code>CONTAINS</code> filters. <code>NOT_CONTAINS</code> filters can only be used with other <code>NOT_CONTAINS</code> filters.
             *                   <p>
             *                   You can combine <code>PREFIX</code> filters with <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filters for the same field. Security Hub first processes the <code>PREFIX</code> filters, and then the <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filters.
             *                   <p>
             *                   For example, for the following filters, Security Hub first identifies findings that have resource types that start with either <code>AwsIam</code> or <code>AwsEc2</code> . It then excludes findings that have a resource type of <code>AwsIamPolicy</code> and findings that have a resource type of <code>AwsEc2NetworkInterface</code> .
             *                   <p>
             *                   <ul>
             *                   <li><code>ResourceType PREFIX AwsIam</code></li>
             *                   <li><code>ResourceType PREFIX AwsEc2</code></li>
             *                   <li><code>ResourceType NOT_EQUALS AwsIamPolicy</code></li>
             *                   <li><code>ResourceType NOT_EQUALS AwsEc2NetworkInterface</code></li>
             *                   </ul>
             *                   <p>
             *                   <code>CONTAINS</code> and <code>NOT_CONTAINS</code> operators can be used only with automation rules V1. <code>CONTAINS_WORD</code> operator is only supported in <code>GetFindingsV2</code> , <code>GetFindingStatisticsV2</code> , <code>GetResourcesV2</code> , and <code>GetResourceStatisticsV2</code> APIs. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html">Automation rules</a> in the <em>AWS Security Hub User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparison(java.lang.String comparison) {
                this.comparison = comparison;
                return this;
            }

            /**
             * Sets the value of {@link StringFilterProperty#getValue}
             * @param value The string filter value. This parameter is required.
             *              Filter values are case sensitive. For example, the product name for control-based findings is <code>Security Hub</code> . If you provide <code>security hub</code> as the filter value, there's no match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StringFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StringFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StringFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StringFilterProperty {
            private final java.lang.String comparison;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparison = software.amazon.jsii.Kernel.get(this, "comparison", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparison = java.util.Objects.requireNonNull(builder.comparison, "comparison is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getComparison() {
                return this.comparison;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparison", om.valueToTree(this.getComparison()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2.StringFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StringFilterProperty.Jsii$Proxy that = (StringFilterProperty.Jsii$Proxy) o;

                if (!comparison.equals(that.comparison)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.comparison.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2Props.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2Props.Builder();
        }

        /**
         * A list of actions to be performed when the rule criteria is met.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-actions</a>
         * @param actions A list of actions to be performed when the rule criteria is met. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final software.amazon.awscdk.IResolvable actions) {
            this.props.actions(actions);
            return this;
        }
        /**
         * A list of actions to be performed when the rule criteria is met.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-actions</a>
         * @param actions A list of actions to be performed when the rule criteria is met. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final java.util.List<? extends java.lang.Object> actions) {
            this.props.actions(actions);
            return this;
        }

        /**
         * The filtering type and configuration of the automation rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-criteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-criteria</a>
         * @param criteria The filtering type and configuration of the automation rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder criteria(final software.amazon.awscdk.IResolvable criteria) {
            this.props.criteria(criteria);
            return this;
        }
        /**
         * The filtering type and configuration of the automation rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-criteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-criteria</a>
         * @param criteria The filtering type and configuration of the automation rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder criteria(final software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2.CriteriaProperty criteria) {
            this.props.criteria(criteria);
            return this;
        }

        /**
         * A description of the V2 automation rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-description</a>
         * @param description A description of the V2 automation rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the V2 automation rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-rulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-rulename</a>
         * @param ruleName The name of the V2 automation rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(final java.lang.String ruleName) {
            this.props.ruleName(ruleName);
            return this;
        }

        /**
         * The value for the rule priority.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-ruleorder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-ruleorder</a>
         * @param ruleOrder The value for the rule priority. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleOrder(final java.lang.Number ruleOrder) {
            this.props.ruleOrder(ruleOrder);
            return this;
        }

        /**
         * The status of the V2 automation rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-rulestatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-rulestatus</a>
         * @param ruleStatus The status of the V2 automation rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleStatus(final java.lang.String ruleStatus) {
            this.props.ruleStatus(ruleStatus);
            return this;
        }

        /**
         * A list of key-value pairs associated with the V2 automation rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-tags</a>
         * @param tags A list of key-value pairs associated with the V2 automation rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2 build() {
            return new software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
