package software.amazon.awscdk.services.ses;

/**
 * Specifies a receipt rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * CfnReceiptRule cfnReceiptRule = CfnReceiptRule.Builder.create(this, "MyCfnReceiptRule")
 *         .rule(RuleProperty.builder()
 *                 .actions(List.of(ActionProperty.builder()
 *                         .addHeaderAction(AddHeaderActionProperty.builder()
 *                                 .headerName("headerName")
 *                                 .headerValue("headerValue")
 *                                 .build())
 *                         .bounceAction(BounceActionProperty.builder()
 *                                 .message("message")
 *                                 .sender("sender")
 *                                 .smtpReplyCode("smtpReplyCode")
 *                                 // the properties below are optional
 *                                 .statusCode("statusCode")
 *                                 .topicArn("topicArn")
 *                                 .build())
 *                         .connectAction(ConnectActionProperty.builder()
 *                                 .iamRoleArn("iamRoleArn")
 *                                 .instanceArn("instanceArn")
 *                                 .build())
 *                         .lambdaAction(LambdaActionProperty.builder()
 *                                 .functionArn("functionArn")
 *                                 // the properties below are optional
 *                                 .invocationType("invocationType")
 *                                 .topicArn("topicArn")
 *                                 .build())
 *                         .s3Action(S3ActionProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 // the properties below are optional
 *                                 .iamRoleArn("iamRoleArn")
 *                                 .kmsKeyArn("kmsKeyArn")
 *                                 .objectKeyPrefix("objectKeyPrefix")
 *                                 .topicArn("topicArn")
 *                                 .build())
 *                         .snsAction(SNSActionProperty.builder()
 *                                 .encoding("encoding")
 *                                 .topicArn("topicArn")
 *                                 .build())
 *                         .stopAction(StopActionProperty.builder()
 *                                 .scope("scope")
 *                                 // the properties below are optional
 *                                 .topicArn("topicArn")
 *                                 .build())
 *                         .workmailAction(WorkmailActionProperty.builder()
 *                                 .organizationArn("organizationArn")
 *                                 // the properties below are optional
 *                                 .topicArn("topicArn")
 *                                 .build())
 *                         .build()))
 *                 .enabled(false)
 *                 .name("name")
 *                 .recipients(List.of("recipients"))
 *                 .scanEnabled(false)
 *                 .tlsPolicy("tlsPolicy")
 *                 .build())
 *         .ruleSetName("ruleSetName")
 *         // the properties below are optional
 *         .after("after")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:15.829Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnReceiptRule")
public class CfnReceiptRule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnReceiptRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnReceiptRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ses.CfnReceiptRule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnReceiptRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.CfnReceiptRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan status, and TLS policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRule() {
        return software.amazon.jsii.Kernel.get(this, "rule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan status, and TLS policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rule", java.util.Objects.requireNonNull(value, "rule is required"));
    }

    /**
     * A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan status, and TLS policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.CfnReceiptRule.RuleProperty value) {
        software.amazon.jsii.Kernel.set(this, "rule", java.util.Objects.requireNonNull(value, "rule is required"));
    }

    /**
     * The name of the rule set where the receipt rule is added.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRuleSetName() {
        return software.amazon.jsii.Kernel.get(this, "ruleSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the rule set where the receipt rule is added.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleSetName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ruleSetName", java.util.Objects.requireNonNull(value, "ruleSetName is required"));
    }

    /**
     * The name of an existing rule after which the new rule is placed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAfter() {
        return software.amazon.jsii.Kernel.get(this, "after", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of an existing rule after which the new rule is placed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAfter(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "after", value);
    }
    /**
     * An action that Amazon SES can take when it receives an email on behalf of one or more email addresses or domains that you own.
     * <p>
     * An instance of this data type can represent only one action.
     * <p>
     * For information about setting up receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html">Amazon SES Developer Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * ActionProperty actionProperty = ActionProperty.builder()
     *         .addHeaderAction(AddHeaderActionProperty.builder()
     *                 .headerName("headerName")
     *                 .headerValue("headerValue")
     *                 .build())
     *         .bounceAction(BounceActionProperty.builder()
     *                 .message("message")
     *                 .sender("sender")
     *                 .smtpReplyCode("smtpReplyCode")
     *                 // the properties below are optional
     *                 .statusCode("statusCode")
     *                 .topicArn("topicArn")
     *                 .build())
     *         .connectAction(ConnectActionProperty.builder()
     *                 .iamRoleArn("iamRoleArn")
     *                 .instanceArn("instanceArn")
     *                 .build())
     *         .lambdaAction(LambdaActionProperty.builder()
     *                 .functionArn("functionArn")
     *                 // the properties below are optional
     *                 .invocationType("invocationType")
     *                 .topicArn("topicArn")
     *                 .build())
     *         .s3Action(S3ActionProperty.builder()
     *                 .bucketName("bucketName")
     *                 // the properties below are optional
     *                 .iamRoleArn("iamRoleArn")
     *                 .kmsKeyArn("kmsKeyArn")
     *                 .objectKeyPrefix("objectKeyPrefix")
     *                 .topicArn("topicArn")
     *                 .build())
     *         .snsAction(SNSActionProperty.builder()
     *                 .encoding("encoding")
     *                 .topicArn("topicArn")
     *                 .build())
     *         .stopAction(StopActionProperty.builder()
     *                 .scope("scope")
     *                 // the properties below are optional
     *                 .topicArn("topicArn")
     *                 .build())
     *         .workmailAction(WorkmailActionProperty.builder()
     *                 .organizationArn("organizationArn")
     *                 // the properties below are optional
     *                 .topicArn("topicArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnReceiptRule.ActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Adds a header to the received email.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html#cfn-ses-receiptrule-action-addheaderaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html#cfn-ses-receiptrule-action-addheaderaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAddHeaderAction() {
            return null;
        }

        /**
         * Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html#cfn-ses-receiptrule-action-bounceaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html#cfn-ses-receiptrule-action-bounceaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBounceAction() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html#cfn-ses-receiptrule-action-connectaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html#cfn-ses-receiptrule-action-connectaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectAction() {
            return null;
        }

        /**
         * Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html#cfn-ses-receiptrule-action-lambdaaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html#cfn-ses-receiptrule-action-lambdaaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaAction() {
            return null;
        }

        /**
         * Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes a notification to Amazon SNS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html#cfn-ses-receiptrule-action-s3action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html#cfn-ses-receiptrule-action-s3action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Action() {
            return null;
        }

        /**
         * Publishes the email content within a notification to Amazon SNS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html#cfn-ses-receiptrule-action-snsaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html#cfn-ses-receiptrule-action-snsaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnsAction() {
            return null;
        }

        /**
         * Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html#cfn-ses-receiptrule-action-stopaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html#cfn-ses-receiptrule-action-stopaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStopAction() {
            return null;
        }

        /**
         * Calls Amazon WorkMail and, optionally, publishes a notification to Amazon SNS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html#cfn-ses-receiptrule-action-workmailaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-action.html#cfn-ses-receiptrule-action-workmailaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWorkmailAction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionProperty> {
            java.lang.Object addHeaderAction;
            java.lang.Object bounceAction;
            java.lang.Object connectAction;
            java.lang.Object lambdaAction;
            java.lang.Object s3Action;
            java.lang.Object snsAction;
            java.lang.Object stopAction;
            java.lang.Object workmailAction;

            /**
             * Sets the value of {@link ActionProperty#getAddHeaderAction}
             * @param addHeaderAction Adds a header to the received email.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addHeaderAction(software.amazon.awscdk.IResolvable addHeaderAction) {
                this.addHeaderAction = addHeaderAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getAddHeaderAction}
             * @param addHeaderAction Adds a header to the received email.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addHeaderAction(software.amazon.awscdk.services.ses.CfnReceiptRule.AddHeaderActionProperty addHeaderAction) {
                this.addHeaderAction = addHeaderAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getBounceAction}
             * @param bounceAction Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bounceAction(software.amazon.awscdk.IResolvable bounceAction) {
                this.bounceAction = bounceAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getBounceAction}
             * @param bounceAction Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bounceAction(software.amazon.awscdk.services.ses.CfnReceiptRule.BounceActionProperty bounceAction) {
                this.bounceAction = bounceAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getConnectAction}
             * @param connectAction the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectAction(software.amazon.awscdk.IResolvable connectAction) {
                this.connectAction = connectAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getConnectAction}
             * @param connectAction the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectAction(software.amazon.awscdk.services.ses.CfnReceiptRule.ConnectActionProperty connectAction) {
                this.connectAction = connectAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getLambdaAction}
             * @param lambdaAction Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaAction(software.amazon.awscdk.IResolvable lambdaAction) {
                this.lambdaAction = lambdaAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getLambdaAction}
             * @param lambdaAction Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaAction(software.amazon.awscdk.services.ses.CfnReceiptRule.LambdaActionProperty lambdaAction) {
                this.lambdaAction = lambdaAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getS3Action}
             * @param s3Action Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes a notification to Amazon SNS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Action(software.amazon.awscdk.IResolvable s3Action) {
                this.s3Action = s3Action;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getS3Action}
             * @param s3Action Saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes a notification to Amazon SNS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Action(software.amazon.awscdk.services.ses.CfnReceiptRule.S3ActionProperty s3Action) {
                this.s3Action = s3Action;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getSnsAction}
             * @param snsAction Publishes the email content within a notification to Amazon SNS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsAction(software.amazon.awscdk.IResolvable snsAction) {
                this.snsAction = snsAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getSnsAction}
             * @param snsAction Publishes the email content within a notification to Amazon SNS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsAction(software.amazon.awscdk.services.ses.CfnReceiptRule.SNSActionProperty snsAction) {
                this.snsAction = snsAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getStopAction}
             * @param stopAction Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stopAction(software.amazon.awscdk.IResolvable stopAction) {
                this.stopAction = stopAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getStopAction}
             * @param stopAction Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stopAction(software.amazon.awscdk.services.ses.CfnReceiptRule.StopActionProperty stopAction) {
                this.stopAction = stopAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getWorkmailAction}
             * @param workmailAction Calls Amazon WorkMail and, optionally, publishes a notification to Amazon SNS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workmailAction(software.amazon.awscdk.IResolvable workmailAction) {
                this.workmailAction = workmailAction;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getWorkmailAction}
             * @param workmailAction Calls Amazon WorkMail and, optionally, publishes a notification to Amazon SNS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workmailAction(software.amazon.awscdk.services.ses.CfnReceiptRule.WorkmailActionProperty workmailAction) {
                this.workmailAction = workmailAction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionProperty {
            private final java.lang.Object addHeaderAction;
            private final java.lang.Object bounceAction;
            private final java.lang.Object connectAction;
            private final java.lang.Object lambdaAction;
            private final java.lang.Object s3Action;
            private final java.lang.Object snsAction;
            private final java.lang.Object stopAction;
            private final java.lang.Object workmailAction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.addHeaderAction = software.amazon.jsii.Kernel.get(this, "addHeaderAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bounceAction = software.amazon.jsii.Kernel.get(this, "bounceAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.connectAction = software.amazon.jsii.Kernel.get(this, "connectAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaAction = software.amazon.jsii.Kernel.get(this, "lambdaAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Action = software.amazon.jsii.Kernel.get(this, "s3Action", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snsAction = software.amazon.jsii.Kernel.get(this, "snsAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stopAction = software.amazon.jsii.Kernel.get(this, "stopAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.workmailAction = software.amazon.jsii.Kernel.get(this, "workmailAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.addHeaderAction = builder.addHeaderAction;
                this.bounceAction = builder.bounceAction;
                this.connectAction = builder.connectAction;
                this.lambdaAction = builder.lambdaAction;
                this.s3Action = builder.s3Action;
                this.snsAction = builder.snsAction;
                this.stopAction = builder.stopAction;
                this.workmailAction = builder.workmailAction;
            }

            @Override
            public final java.lang.Object getAddHeaderAction() {
                return this.addHeaderAction;
            }

            @Override
            public final java.lang.Object getBounceAction() {
                return this.bounceAction;
            }

            @Override
            public final java.lang.Object getConnectAction() {
                return this.connectAction;
            }

            @Override
            public final java.lang.Object getLambdaAction() {
                return this.lambdaAction;
            }

            @Override
            public final java.lang.Object getS3Action() {
                return this.s3Action;
            }

            @Override
            public final java.lang.Object getSnsAction() {
                return this.snsAction;
            }

            @Override
            public final java.lang.Object getStopAction() {
                return this.stopAction;
            }

            @Override
            public final java.lang.Object getWorkmailAction() {
                return this.workmailAction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddHeaderAction() != null) {
                    data.set("addHeaderAction", om.valueToTree(this.getAddHeaderAction()));
                }
                if (this.getBounceAction() != null) {
                    data.set("bounceAction", om.valueToTree(this.getBounceAction()));
                }
                if (this.getConnectAction() != null) {
                    data.set("connectAction", om.valueToTree(this.getConnectAction()));
                }
                if (this.getLambdaAction() != null) {
                    data.set("lambdaAction", om.valueToTree(this.getLambdaAction()));
                }
                if (this.getS3Action() != null) {
                    data.set("s3Action", om.valueToTree(this.getS3Action()));
                }
                if (this.getSnsAction() != null) {
                    data.set("snsAction", om.valueToTree(this.getSnsAction()));
                }
                if (this.getStopAction() != null) {
                    data.set("stopAction", om.valueToTree(this.getStopAction()));
                }
                if (this.getWorkmailAction() != null) {
                    data.set("workmailAction", om.valueToTree(this.getWorkmailAction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnReceiptRule.ActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionProperty.Jsii$Proxy that = (ActionProperty.Jsii$Proxy) o;

                if (this.addHeaderAction != null ? !this.addHeaderAction.equals(that.addHeaderAction) : that.addHeaderAction != null) return false;
                if (this.bounceAction != null ? !this.bounceAction.equals(that.bounceAction) : that.bounceAction != null) return false;
                if (this.connectAction != null ? !this.connectAction.equals(that.connectAction) : that.connectAction != null) return false;
                if (this.lambdaAction != null ? !this.lambdaAction.equals(that.lambdaAction) : that.lambdaAction != null) return false;
                if (this.s3Action != null ? !this.s3Action.equals(that.s3Action) : that.s3Action != null) return false;
                if (this.snsAction != null ? !this.snsAction.equals(that.snsAction) : that.snsAction != null) return false;
                if (this.stopAction != null ? !this.stopAction.equals(that.stopAction) : that.stopAction != null) return false;
                return this.workmailAction != null ? this.workmailAction.equals(that.workmailAction) : that.workmailAction == null;
            }

            @Override
            public final int hashCode() {
                int result = this.addHeaderAction != null ? this.addHeaderAction.hashCode() : 0;
                result = 31 * result + (this.bounceAction != null ? this.bounceAction.hashCode() : 0);
                result = 31 * result + (this.connectAction != null ? this.connectAction.hashCode() : 0);
                result = 31 * result + (this.lambdaAction != null ? this.lambdaAction.hashCode() : 0);
                result = 31 * result + (this.s3Action != null ? this.s3Action.hashCode() : 0);
                result = 31 * result + (this.snsAction != null ? this.snsAction.hashCode() : 0);
                result = 31 * result + (this.stopAction != null ? this.stopAction.hashCode() : 0);
                result = 31 * result + (this.workmailAction != null ? this.workmailAction.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * When included in a receipt rule, this action adds a header to the received email.
     * <p>
     * For information about adding a header using a receipt rule, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html">Amazon SES Developer Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * AddHeaderActionProperty addHeaderActionProperty = AddHeaderActionProperty.builder()
     *         .headerName("headerName")
     *         .headerValue("headerValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-addheaderaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-addheaderaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnReceiptRule.AddHeaderActionProperty")
    @software.amazon.jsii.Jsii.Proxy(AddHeaderActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AddHeaderActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the header to add to the incoming message.
         * <p>
         * The name must contain at least one character, and can contain up to 50 characters. It consists of alphanumeric ( <code>a–z, A–Z, 0–9</code> ) characters and dashes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-addheaderaction.html#cfn-ses-receiptrule-addheaderaction-headername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-addheaderaction.html#cfn-ses-receiptrule-addheaderaction-headername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderName();

        /**
         * The content to include in the header.
         * <p>
         * This value can contain up to 2048 characters. It can't contain newline ( <code>\n</code> ) or carriage return ( <code>\r</code> ) characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-addheaderaction.html#cfn-ses-receiptrule-addheaderaction-headervalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-addheaderaction.html#cfn-ses-receiptrule-addheaderaction-headervalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderValue();

        /**
         * @return a {@link Builder} of {@link AddHeaderActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AddHeaderActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AddHeaderActionProperty> {
            java.lang.String headerName;
            java.lang.String headerValue;

            /**
             * Sets the value of {@link AddHeaderActionProperty#getHeaderName}
             * @param headerName The name of the header to add to the incoming message. This parameter is required.
             *                   The name must contain at least one character, and can contain up to 50 characters. It consists of alphanumeric ( <code>a–z, A–Z, 0–9</code> ) characters and dashes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerName(java.lang.String headerName) {
                this.headerName = headerName;
                return this;
            }

            /**
             * Sets the value of {@link AddHeaderActionProperty#getHeaderValue}
             * @param headerValue The content to include in the header. This parameter is required.
             *                    This value can contain up to 2048 characters. It can't contain newline ( <code>\n</code> ) or carriage return ( <code>\r</code> ) characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerValue(java.lang.String headerValue) {
                this.headerValue = headerValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AddHeaderActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AddHeaderActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AddHeaderActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddHeaderActionProperty {
            private final java.lang.String headerName;
            private final java.lang.String headerValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.headerName = software.amazon.jsii.Kernel.get(this, "headerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headerValue = software.amazon.jsii.Kernel.get(this, "headerValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.headerName = java.util.Objects.requireNonNull(builder.headerName, "headerName is required");
                this.headerValue = java.util.Objects.requireNonNull(builder.headerValue, "headerValue is required");
            }

            @Override
            public final java.lang.String getHeaderName() {
                return this.headerName;
            }

            @Override
            public final java.lang.String getHeaderValue() {
                return this.headerValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("headerName", om.valueToTree(this.getHeaderName()));
                data.set("headerValue", om.valueToTree(this.getHeaderValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnReceiptRule.AddHeaderActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AddHeaderActionProperty.Jsii$Proxy that = (AddHeaderActionProperty.Jsii$Proxy) o;

                if (!headerName.equals(that.headerName)) return false;
                return this.headerValue.equals(that.headerValue);
            }

            @Override
            public final int hashCode() {
                int result = this.headerName.hashCode();
                result = 31 * result + (this.headerValue.hashCode());
                return result;
            }
        }
    }
    /**
     * When included in a receipt rule, this action rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).
     * <p>
     * For information about sending a bounce message in response to a received email, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-bounce.html">Amazon SES Developer Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * BounceActionProperty bounceActionProperty = BounceActionProperty.builder()
     *         .message("message")
     *         .sender("sender")
     *         .smtpReplyCode("smtpReplyCode")
     *         // the properties below are optional
     *         .statusCode("statusCode")
     *         .topicArn("topicArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnReceiptRule.BounceActionProperty")
    @software.amazon.jsii.Jsii.Proxy(BounceActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BounceActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Human-readable text to include in the bounce message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-message">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-message</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMessage();

        /**
         * The email address of the sender of the bounced email.
         * <p>
         * This is the address from which the bounce message is sent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-sender">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-sender</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSender();

        /**
         * The SMTP reply code, as defined by <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc5321">RFC 5321</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-smtpreplycode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-smtpreplycode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSmtpReplyCode();

        /**
         * The SMTP enhanced status code, as defined by <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc3463">RFC 3463</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-statuscode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-statuscode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatusCode() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken.
         * <p>
         * You can find the ARN of a topic by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html">ListTopics</a> operation in Amazon SNS.
         * <p>
         * For more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-topicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-topicarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTopicArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BounceActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BounceActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BounceActionProperty> {
            java.lang.String message;
            java.lang.String sender;
            java.lang.String smtpReplyCode;
            java.lang.String statusCode;
            java.lang.String topicArn;

            /**
             * Sets the value of {@link BounceActionProperty#getMessage}
             * @param message Human-readable text to include in the bounce message. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder message(java.lang.String message) {
                this.message = message;
                return this;
            }

            /**
             * Sets the value of {@link BounceActionProperty#getSender}
             * @param sender The email address of the sender of the bounced email. This parameter is required.
             *               This is the address from which the bounce message is sent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sender(java.lang.String sender) {
                this.sender = sender;
                return this;
            }

            /**
             * Sets the value of {@link BounceActionProperty#getSmtpReplyCode}
             * @param smtpReplyCode The SMTP reply code, as defined by <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc5321">RFC 5321</a> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smtpReplyCode(java.lang.String smtpReplyCode) {
                this.smtpReplyCode = smtpReplyCode;
                return this;
            }

            /**
             * Sets the value of {@link BounceActionProperty#getStatusCode}
             * @param statusCode The SMTP enhanced status code, as defined by <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc3463">RFC 3463</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of {@link BounceActionProperty#getTopicArn}
             * @param topicArn The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken.
             *                 You can find the ARN of a topic by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html">ListTopics</a> operation in Amazon SNS.
             *                 <p>
             *                 For more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicArn(java.lang.String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BounceActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BounceActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BounceActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BounceActionProperty {
            private final java.lang.String message;
            private final java.lang.String sender;
            private final java.lang.String smtpReplyCode;
            private final java.lang.String statusCode;
            private final java.lang.String topicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sender = software.amazon.jsii.Kernel.get(this, "sender", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.smtpReplyCode = software.amazon.jsii.Kernel.get(this, "smtpReplyCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.topicArn = software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.message = java.util.Objects.requireNonNull(builder.message, "message is required");
                this.sender = java.util.Objects.requireNonNull(builder.sender, "sender is required");
                this.smtpReplyCode = java.util.Objects.requireNonNull(builder.smtpReplyCode, "smtpReplyCode is required");
                this.statusCode = builder.statusCode;
                this.topicArn = builder.topicArn;
            }

            @Override
            public final java.lang.String getMessage() {
                return this.message;
            }

            @Override
            public final java.lang.String getSender() {
                return this.sender;
            }

            @Override
            public final java.lang.String getSmtpReplyCode() {
                return this.smtpReplyCode;
            }

            @Override
            public final java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public final java.lang.String getTopicArn() {
                return this.topicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("message", om.valueToTree(this.getMessage()));
                data.set("sender", om.valueToTree(this.getSender()));
                data.set("smtpReplyCode", om.valueToTree(this.getSmtpReplyCode()));
                if (this.getStatusCode() != null) {
                    data.set("statusCode", om.valueToTree(this.getStatusCode()));
                }
                if (this.getTopicArn() != null) {
                    data.set("topicArn", om.valueToTree(this.getTopicArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnReceiptRule.BounceActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BounceActionProperty.Jsii$Proxy that = (BounceActionProperty.Jsii$Proxy) o;

                if (!message.equals(that.message)) return false;
                if (!sender.equals(that.sender)) return false;
                if (!smtpReplyCode.equals(that.smtpReplyCode)) return false;
                if (this.statusCode != null ? !this.statusCode.equals(that.statusCode) : that.statusCode != null) return false;
                return this.topicArn != null ? this.topicArn.equals(that.topicArn) : that.topicArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.message.hashCode();
                result = 31 * result + (this.sender.hashCode());
                result = 31 * result + (this.smtpReplyCode.hashCode());
                result = 31 * result + (this.statusCode != null ? this.statusCode.hashCode() : 0);
                result = 31 * result + (this.topicArn != null ? this.topicArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * When included in a receipt rule, this action parses the received message and starts an email contact in Amazon Connect on your behalf.
     * <p>
     * <blockquote>
     * <p>
     * When you receive emails, the maximum email size (including headers) is 40 MB. Additionally, emails may only have up to 10 attachments. Emails larger than 40 MB or with more than 10 attachments will be bounced.
     * <p>
     * </blockquote>
     * <p>
     * We recommend that you configure this action via Amazon Connect.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * ConnectActionProperty connectActionProperty = ConnectActionProperty.builder()
     *         .iamRoleArn("iamRoleArn")
     *         .instanceArn("instanceArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-connectaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-connectaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnReceiptRule.ConnectActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the IAM role to be used by Amazon Simple Email Service while starting email contacts to the Amazon Connect instance.
         * <p>
         * This role should have permission to invoke <code>connect:StartEmailContact</code> for the given Amazon Connect instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-connectaction.html#cfn-ses-receiptrule-connectaction-iamrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-connectaction.html#cfn-ses-receiptrule-connectaction-iamrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIamRoleArn();

        /**
         * The Amazon Resource Name (ARN) for the Amazon Connect instance that Amazon SES integrates with for starting email contacts.
         * <p>
         * For more information about Amazon Connect instances, see the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-instances.html">Amazon Connect Administrator Guide</a>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-connectaction.html#cfn-ses-receiptrule-connectaction-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-connectaction.html#cfn-ses-receiptrule-connectaction-instancearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn();

        /**
         * @return a {@link Builder} of {@link ConnectActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectActionProperty> {
            java.lang.String iamRoleArn;
            java.lang.String instanceArn;

            /**
             * Sets the value of {@link ConnectActionProperty#getIamRoleArn}
             * @param iamRoleArn The Amazon Resource Name (ARN) of the IAM role to be used by Amazon Simple Email Service while starting email contacts to the Amazon Connect instance. This parameter is required.
             *                   This role should have permission to invoke <code>connect:StartEmailContact</code> for the given Amazon Connect instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamRoleArn(java.lang.String iamRoleArn) {
                this.iamRoleArn = iamRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link ConnectActionProperty#getInstanceArn}
             * @param instanceArn The Amazon Resource Name (ARN) for the Amazon Connect instance that Amazon SES integrates with for starting email contacts. This parameter is required.
             *                    For more information about Amazon Connect instances, see the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-instances.html">Amazon Connect Administrator Guide</a>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceArn(java.lang.String instanceArn) {
                this.instanceArn = instanceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectActionProperty {
            private final java.lang.String iamRoleArn;
            private final java.lang.String instanceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.iamRoleArn = software.amazon.jsii.Kernel.get(this, "iamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceArn = software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.iamRoleArn = java.util.Objects.requireNonNull(builder.iamRoleArn, "iamRoleArn is required");
                this.instanceArn = java.util.Objects.requireNonNull(builder.instanceArn, "instanceArn is required");
            }

            @Override
            public final java.lang.String getIamRoleArn() {
                return this.iamRoleArn;
            }

            @Override
            public final java.lang.String getInstanceArn() {
                return this.instanceArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("iamRoleArn", om.valueToTree(this.getIamRoleArn()));
                data.set("instanceArn", om.valueToTree(this.getInstanceArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnReceiptRule.ConnectActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectActionProperty.Jsii$Proxy that = (ConnectActionProperty.Jsii$Proxy) o;

                if (!iamRoleArn.equals(that.iamRoleArn)) return false;
                return this.instanceArn.equals(that.instanceArn);
            }

            @Override
            public final int hashCode() {
                int result = this.iamRoleArn.hashCode();
                result = 31 * result + (this.instanceArn.hashCode());
                return result;
            }
        }
    }
    /**
     * When included in a receipt rule, this action calls an AWS Lambda function and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).
     * <p>
     * To enable Amazon SES to call your AWS Lambda function or to publish to an Amazon SNS topic of another account, Amazon SES must have permission to access those resources. For information about giving permissions, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-permissions.html">Amazon SES Developer Guide</a> .
     * <p>
     * For information about using AWS Lambda actions in receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-lambda.html">Amazon SES Developer Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * LambdaActionProperty lambdaActionProperty = LambdaActionProperty.builder()
     *         .functionArn("functionArn")
     *         // the properties below are optional
     *         .invocationType("invocationType")
     *         .topicArn("topicArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-lambdaaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-lambdaaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnReceiptRule.LambdaActionProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the AWS Lambda function.
         * <p>
         * An example of an AWS Lambda function ARN is <code>arn:aws:lambda:us-west-2:account-id:function:MyFunction</code> . For more information about AWS Lambda, see the <a href="https://docs.aws.amazon.com/lambda/latest/dg/welcome.html">AWS Lambda Developer Guide</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-lambdaaction.html#cfn-ses-receiptrule-lambdaaction-functionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-lambdaaction.html#cfn-ses-receiptrule-lambdaaction-functionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn();

        /**
         * The invocation type of the AWS Lambda function.
         * <p>
         * An invocation type of <code>RequestResponse</code> means that the execution of the function immediately results in a response, and a value of <code>Event</code> means that the function is invoked asynchronously. The default value is <code>Event</code> . For information about AWS Lambda invocation types, see the <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a> .
         * <p>
         * <blockquote>
         * <p>
         * There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use <code>Event</code> invocation in most cases. Use <code>RequestResponse</code> only to make a mail flow decision, such as whether to stop the receipt rule or the receipt rule set.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-lambdaaction.html#cfn-ses-receiptrule-lambdaaction-invocationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-lambdaaction.html#cfn-ses-receiptrule-lambdaaction-invocationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInvocationType() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is executed.
         * <p>
         * You can find the ARN of a topic by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html">ListTopics</a> operation in Amazon SNS.
         * <p>
         * For more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-lambdaaction.html#cfn-ses-receiptrule-lambdaaction-topicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-lambdaaction.html#cfn-ses-receiptrule-lambdaaction-topicarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTopicArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaActionProperty> {
            java.lang.String functionArn;
            java.lang.String invocationType;
            java.lang.String topicArn;

            /**
             * Sets the value of {@link LambdaActionProperty#getFunctionArn}
             * @param functionArn The Amazon Resource Name (ARN) of the AWS Lambda function. This parameter is required.
             *                    An example of an AWS Lambda function ARN is <code>arn:aws:lambda:us-west-2:account-id:function:MyFunction</code> . For more information about AWS Lambda, see the <a href="https://docs.aws.amazon.com/lambda/latest/dg/welcome.html">AWS Lambda Developer Guide</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionArn(java.lang.String functionArn) {
                this.functionArn = functionArn;
                return this;
            }

            /**
             * Sets the value of {@link LambdaActionProperty#getInvocationType}
             * @param invocationType The invocation type of the AWS Lambda function.
             *                       An invocation type of <code>RequestResponse</code> means that the execution of the function immediately results in a response, and a value of <code>Event</code> means that the function is invoked asynchronously. The default value is <code>Event</code> . For information about AWS Lambda invocation types, see the <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a> .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use <code>Event</code> invocation in most cases. Use <code>RequestResponse</code> only to make a mail flow decision, such as whether to stop the receipt rule or the receipt rule set.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invocationType(java.lang.String invocationType) {
                this.invocationType = invocationType;
                return this;
            }

            /**
             * Sets the value of {@link LambdaActionProperty#getTopicArn}
             * @param topicArn The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is executed.
             *                 You can find the ARN of a topic by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html">ListTopics</a> operation in Amazon SNS.
             *                 <p>
             *                 For more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicArn(java.lang.String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaActionProperty {
            private final java.lang.String functionArn;
            private final java.lang.String invocationType;
            private final java.lang.String topicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.functionArn = software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.invocationType = software.amazon.jsii.Kernel.get(this, "invocationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.topicArn = software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.functionArn = java.util.Objects.requireNonNull(builder.functionArn, "functionArn is required");
                this.invocationType = builder.invocationType;
                this.topicArn = builder.topicArn;
            }

            @Override
            public final java.lang.String getFunctionArn() {
                return this.functionArn;
            }

            @Override
            public final java.lang.String getInvocationType() {
                return this.invocationType;
            }

            @Override
            public final java.lang.String getTopicArn() {
                return this.topicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("functionArn", om.valueToTree(this.getFunctionArn()));
                if (this.getInvocationType() != null) {
                    data.set("invocationType", om.valueToTree(this.getInvocationType()));
                }
                if (this.getTopicArn() != null) {
                    data.set("topicArn", om.valueToTree(this.getTopicArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnReceiptRule.LambdaActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaActionProperty.Jsii$Proxy that = (LambdaActionProperty.Jsii$Proxy) o;

                if (!functionArn.equals(that.functionArn)) return false;
                if (this.invocationType != null ? !this.invocationType.equals(that.invocationType) : that.invocationType != null) return false;
                return this.topicArn != null ? this.topicArn.equals(that.topicArn) : that.topicArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.functionArn.hashCode();
                result = 31 * result + (this.invocationType != null ? this.invocationType.hashCode() : 0);
                result = 31 * result + (this.topicArn != null ? this.topicArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Receipt rules enable you to specify which actions Amazon SES should take when it receives mail on behalf of one or more email addresses or domains that you own.
     * <p>
     * Each receipt rule defines a set of email addresses or domains that it applies to. If the email addresses or domains match at least one recipient address of the message, Amazon SES executes all of the receipt rule's actions on the message.
     * <p>
     * For information about setting up receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-receipt-rules-console-walkthrough.html">Amazon SES Developer Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * RuleProperty ruleProperty = RuleProperty.builder()
     *         .actions(List.of(ActionProperty.builder()
     *                 .addHeaderAction(AddHeaderActionProperty.builder()
     *                         .headerName("headerName")
     *                         .headerValue("headerValue")
     *                         .build())
     *                 .bounceAction(BounceActionProperty.builder()
     *                         .message("message")
     *                         .sender("sender")
     *                         .smtpReplyCode("smtpReplyCode")
     *                         // the properties below are optional
     *                         .statusCode("statusCode")
     *                         .topicArn("topicArn")
     *                         .build())
     *                 .connectAction(ConnectActionProperty.builder()
     *                         .iamRoleArn("iamRoleArn")
     *                         .instanceArn("instanceArn")
     *                         .build())
     *                 .lambdaAction(LambdaActionProperty.builder()
     *                         .functionArn("functionArn")
     *                         // the properties below are optional
     *                         .invocationType("invocationType")
     *                         .topicArn("topicArn")
     *                         .build())
     *                 .s3Action(S3ActionProperty.builder()
     *                         .bucketName("bucketName")
     *                         // the properties below are optional
     *                         .iamRoleArn("iamRoleArn")
     *                         .kmsKeyArn("kmsKeyArn")
     *                         .objectKeyPrefix("objectKeyPrefix")
     *                         .topicArn("topicArn")
     *                         .build())
     *                 .snsAction(SNSActionProperty.builder()
     *                         .encoding("encoding")
     *                         .topicArn("topicArn")
     *                         .build())
     *                 .stopAction(StopActionProperty.builder()
     *                         .scope("scope")
     *                         // the properties below are optional
     *                         .topicArn("topicArn")
     *                         .build())
     *                 .workmailAction(WorkmailActionProperty.builder()
     *                         .organizationArn("organizationArn")
     *                         // the properties below are optional
     *                         .topicArn("topicArn")
     *                         .build())
     *                 .build()))
     *         .enabled(false)
     *         .name("name")
     *         .recipients(List.of("recipients"))
     *         .scanEnabled(false)
     *         .tlsPolicy("tlsPolicy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-rule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-rule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnReceiptRule.RuleProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An ordered list of actions to perform on messages that match at least one of the recipient email addresses or domains specified in the receipt rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-rule.html#cfn-ses-receiptrule-rule-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-rule.html#cfn-ses-receiptrule-rule-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getActions() {
            return null;
        }

        /**
         * If <code>true</code> , the receipt rule is active.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-rule.html#cfn-ses-receiptrule-rule-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-rule.html#cfn-ses-receiptrule-rule-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The name of the receipt rule. The name must meet the following requirements:.
         * <p>
         * <ul>
         * <li>Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), dashes (-), or periods (.).</li>
         * <li>Start and end with a letter or number.</li>
         * <li>Contain 64 characters or fewer.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-rule.html#cfn-ses-receiptrule-rule-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-rule.html#cfn-ses-receiptrule-rule-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The recipient domains and email addresses that the receipt rule applies to.
         * <p>
         * If this field is not specified, this rule matches all recipients on all verified domains.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-rule.html#cfn-ses-receiptrule-rule-recipients">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-rule.html#cfn-ses-receiptrule-rule-recipients</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRecipients() {
            return null;
        }

        /**
         * If <code>true</code> , then messages that this receipt rule applies to are scanned for spam and viruses.
         * <p>
         * The default value is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-rule.html#cfn-ses-receiptrule-rule-scanenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-rule.html#cfn-ses-receiptrule-rule-scanenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScanEnabled() {
            return null;
        }

        /**
         * Specifies whether Amazon SES should require that incoming email is delivered over a connection encrypted with Transport Layer Security (TLS).
         * <p>
         * If this parameter is set to <code>Require</code> , Amazon SES bounces emails that are not received over TLS. The default is <code>Optional</code> .
         * <p>
         * Valid Values: <code>Require | Optional</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-rule.html#cfn-ses-receiptrule-rule-tlspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-rule.html#cfn-ses-receiptrule-rule-tlspolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTlsPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleProperty> {
            java.lang.Object actions;
            java.lang.Object enabled;
            java.lang.String name;
            java.util.List<java.lang.String> recipients;
            java.lang.Object scanEnabled;
            java.lang.String tlsPolicy;

            /**
             * Sets the value of {@link RuleProperty#getActions}
             * @param actions An ordered list of actions to perform on messages that match at least one of the recipient email addresses or domains specified in the receipt rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.IResolvable actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getActions}
             * @param actions An ordered list of actions to perform on messages that match at least one of the recipient email addresses or domains specified in the receipt rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<? extends java.lang.Object> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getEnabled}
             * @param enabled If <code>true</code> , the receipt rule is active.
             *                The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getEnabled}
             * @param enabled If <code>true</code> , the receipt rule is active.
             *                The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getName}
             * @param name The name of the receipt rule. The name must meet the following requirements:.
             *             <ul>
             *             <li>Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_), dashes (-), or periods (.).</li>
             *             <li>Start and end with a letter or number.</li>
             *             <li>Contain 64 characters or fewer.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getRecipients}
             * @param recipients The recipient domains and email addresses that the receipt rule applies to.
             *                   If this field is not specified, this rule matches all recipients on all verified domains.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recipients(java.util.List<java.lang.String> recipients) {
                this.recipients = recipients;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getScanEnabled}
             * @param scanEnabled If <code>true</code> , then messages that this receipt rule applies to are scanned for spam and viruses.
             *                    The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scanEnabled(java.lang.Boolean scanEnabled) {
                this.scanEnabled = scanEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getScanEnabled}
             * @param scanEnabled If <code>true</code> , then messages that this receipt rule applies to are scanned for spam and viruses.
             *                    The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scanEnabled(software.amazon.awscdk.IResolvable scanEnabled) {
                this.scanEnabled = scanEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RuleProperty#getTlsPolicy}
             * @param tlsPolicy Specifies whether Amazon SES should require that incoming email is delivered over a connection encrypted with Transport Layer Security (TLS).
             *                  If this parameter is set to <code>Require</code> , Amazon SES bounces emails that are not received over TLS. The default is <code>Optional</code> .
             *                  <p>
             *                  Valid Values: <code>Require | Optional</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tlsPolicy(java.lang.String tlsPolicy) {
                this.tlsPolicy = tlsPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleProperty {
            private final java.lang.Object actions;
            private final java.lang.Object enabled;
            private final java.lang.String name;
            private final java.util.List<java.lang.String> recipients;
            private final java.lang.Object scanEnabled;
            private final java.lang.String tlsPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recipients = software.amazon.jsii.Kernel.get(this, "recipients", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.scanEnabled = software.amazon.jsii.Kernel.get(this, "scanEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tlsPolicy = software.amazon.jsii.Kernel.get(this, "tlsPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = builder.actions;
                this.enabled = builder.enabled;
                this.name = builder.name;
                this.recipients = builder.recipients;
                this.scanEnabled = builder.scanEnabled;
                this.tlsPolicy = builder.tlsPolicy;
            }

            @Override
            public final java.lang.Object getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<java.lang.String> getRecipients() {
                return this.recipients;
            }

            @Override
            public final java.lang.Object getScanEnabled() {
                return this.scanEnabled;
            }

            @Override
            public final java.lang.String getTlsPolicy() {
                return this.tlsPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getActions() != null) {
                    data.set("actions", om.valueToTree(this.getActions()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getRecipients() != null) {
                    data.set("recipients", om.valueToTree(this.getRecipients()));
                }
                if (this.getScanEnabled() != null) {
                    data.set("scanEnabled", om.valueToTree(this.getScanEnabled()));
                }
                if (this.getTlsPolicy() != null) {
                    data.set("tlsPolicy", om.valueToTree(this.getTlsPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnReceiptRule.RuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleProperty.Jsii$Proxy that = (RuleProperty.Jsii$Proxy) o;

                if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.recipients != null ? !this.recipients.equals(that.recipients) : that.recipients != null) return false;
                if (this.scanEnabled != null ? !this.scanEnabled.equals(that.scanEnabled) : that.scanEnabled != null) return false;
                return this.tlsPolicy != null ? this.tlsPolicy.equals(that.tlsPolicy) : that.tlsPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actions != null ? this.actions.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.recipients != null ? this.recipients.hashCode() : 0);
                result = 31 * result + (this.scanEnabled != null ? this.scanEnabled.hashCode() : 0);
                result = 31 * result + (this.tlsPolicy != null ? this.tlsPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * When included in a receipt rule, this action saves the received message to an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).
     * <p>
     * To enable Amazon SES to write emails to your Amazon S3 bucket, use an AWS KMS key to encrypt your emails, or publish to an Amazon SNS topic of another account, Amazon SES must have permission to access those resources. For information about granting permissions, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-permissions.html">Amazon SES Developer Guide</a> .
     * <p>
     * <blockquote>
     * <p>
     * When you save your emails to an Amazon S3 bucket, the maximum email size (including headers) is 30 MB. Emails larger than that bounces.
     * <p>
     * </blockquote>
     * <p>
     * For information about specifying Amazon S3 actions in receipt rules, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-s3.html">Amazon SES Developer Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * S3ActionProperty s3ActionProperty = S3ActionProperty.builder()
     *         .bucketName("bucketName")
     *         // the properties below are optional
     *         .iamRoleArn("iamRoleArn")
     *         .kmsKeyArn("kmsKeyArn")
     *         .objectKeyPrefix("objectKeyPrefix")
     *         .topicArn("topicArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnReceiptRule.S3ActionProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon S3 bucket for incoming email.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The ARN of the IAM role to be used by Amazon Simple Email Service while writing to the Amazon S3 bucket, optionally encrypting your mail via the provided customer managed key, and publishing to the Amazon SNS topic.
         * <p>
         * This role should have access to the following APIs:
         * <p>
         * <ul>
         * <li><code>s3:PutObject</code> , <code>kms:Encrypt</code> and <code>kms:GenerateDataKey</code> for the given Amazon S3 bucket.</li>
         * <li><code>kms:GenerateDataKey</code> for the given AWS KMS customer managed key.</li>
         * <li><code>sns:Publish</code> for the given Amazon SNS topic.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If an IAM role ARN is provided, the role (and only the role) is used to access all the given resources (Amazon S3 bucket, AWS KMS customer managed key and Amazon SNS topic). Therefore, setting up individual resource access permissions is not required.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-iamrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-iamrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIamRoleArn() {
            return null;
        }

        /**
         * The customer managed key that Amazon SES should use to encrypt your emails before saving them to the Amazon S3 bucket.
         * <p>
         * You can use the AWS managed key or a customer managed key that you created in AWS KMS as follows:
         * <p>
         * <ul>
         * <li>To use the AWS managed key, provide an ARN in the form of <code>arn:aws:kms:REGION:ACCOUNT-ID-WITHOUT-HYPHENS:alias/aws/ses</code> . For example, if your AWS account ID is 123456789012 and you want to use the AWS managed key in the US West (Oregon) Region, the ARN of the AWS managed key would be <code>arn:aws:kms:us-west-2:123456789012:alias/aws/ses</code> . If you use the AWS managed key, you don't need to perform any extra steps to give Amazon SES permission to use the key.</li>
         * <li>To use a customer managed key that you created in AWS KMS, provide the ARN of the customer managed key and ensure that you add a statement to your key's policy to give Amazon SES permission to use it. For more information about giving permissions, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-permissions.html">Amazon SES Developer Guide</a> .</li>
         * </ul>
         * <p>
         * For more information about key policies, see the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">AWS KMS Developer Guide</a> . If you do not specify an AWS KMS key, Amazon SES does not encrypt your emails.
         * <p>
         * <blockquote>
         * <p>
         * Your mail is encrypted by Amazon SES using the Amazon S3 encryption client before the mail is submitted to Amazon S3 for storage. It is not encrypted using Amazon S3 server-side encryption. This means that you must use the Amazon S3 encryption client to decrypt the email after retrieving it from Amazon S3, as the service has no access to use your AWS KMS keys for decryption. This encryption client is currently available with the <a href="https://docs.aws.amazon.com/sdk-for-java/">AWS SDK for Java</a> and <a href="https://docs.aws.amazon.com/sdk-for-ruby/">AWS SDK for Ruby</a> only. For more information about client-side encryption using AWS KMS managed keys, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html">Amazon S3 Developer Guide</a> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-kmskeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * The key prefix of the Amazon S3 bucket.
         * <p>
         * The key prefix is similar to a directory name that enables you to store similar data under the same directory in a bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-objectkeyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-objectkeyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObjectKeyPrefix() {
            return null;
        }

        /**
         * The ARN of the Amazon SNS topic to notify when the message is saved to the Amazon S3 bucket.
         * <p>
         * You can find the ARN of a topic by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html">ListTopics</a> operation in Amazon SNS.
         * <p>
         * For more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-topicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-topicarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTopicArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ActionProperty> {
            java.lang.String bucketName;
            java.lang.String iamRoleArn;
            java.lang.String kmsKeyArn;
            java.lang.String objectKeyPrefix;
            java.lang.String topicArn;

            /**
             * Sets the value of {@link S3ActionProperty#getBucketName}
             * @param bucketName The name of the Amazon S3 bucket for incoming email. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3ActionProperty#getIamRoleArn}
             * @param iamRoleArn The ARN of the IAM role to be used by Amazon Simple Email Service while writing to the Amazon S3 bucket, optionally encrypting your mail via the provided customer managed key, and publishing to the Amazon SNS topic.
             *                   This role should have access to the following APIs:
             *                   <p>
             *                   <ul>
             *                   <li><code>s3:PutObject</code> , <code>kms:Encrypt</code> and <code>kms:GenerateDataKey</code> for the given Amazon S3 bucket.</li>
             *                   <li><code>kms:GenerateDataKey</code> for the given AWS KMS customer managed key.</li>
             *                   <li><code>sns:Publish</code> for the given Amazon SNS topic.</li>
             *                   </ul>
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   If an IAM role ARN is provided, the role (and only the role) is used to access all the given resources (Amazon S3 bucket, AWS KMS customer managed key and Amazon SNS topic). Therefore, setting up individual resource access permissions is not required.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamRoleArn(java.lang.String iamRoleArn) {
                this.iamRoleArn = iamRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link S3ActionProperty#getKmsKeyArn}
             * @param kmsKeyArn The customer managed key that Amazon SES should use to encrypt your emails before saving them to the Amazon S3 bucket.
             *                  You can use the AWS managed key or a customer managed key that you created in AWS KMS as follows:
             *                  <p>
             *                  <ul>
             *                  <li>To use the AWS managed key, provide an ARN in the form of <code>arn:aws:kms:REGION:ACCOUNT-ID-WITHOUT-HYPHENS:alias/aws/ses</code> . For example, if your AWS account ID is 123456789012 and you want to use the AWS managed key in the US West (Oregon) Region, the ARN of the AWS managed key would be <code>arn:aws:kms:us-west-2:123456789012:alias/aws/ses</code> . If you use the AWS managed key, you don't need to perform any extra steps to give Amazon SES permission to use the key.</li>
             *                  <li>To use a customer managed key that you created in AWS KMS, provide the ARN of the customer managed key and ensure that you add a statement to your key's policy to give Amazon SES permission to use it. For more information about giving permissions, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-permissions.html">Amazon SES Developer Guide</a> .</li>
             *                  </ul>
             *                  <p>
             *                  For more information about key policies, see the <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">AWS KMS Developer Guide</a> . If you do not specify an AWS KMS key, Amazon SES does not encrypt your emails.
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  Your mail is encrypted by Amazon SES using the Amazon S3 encryption client before the mail is submitted to Amazon S3 for storage. It is not encrypted using Amazon S3 server-side encryption. This means that you must use the Amazon S3 encryption client to decrypt the email after retrieving it from Amazon S3, as the service has no access to use your AWS KMS keys for decryption. This encryption client is currently available with the <a href="https://docs.aws.amazon.com/sdk-for-java/">AWS SDK for Java</a> and <a href="https://docs.aws.amazon.com/sdk-for-ruby/">AWS SDK for Ruby</a> only. For more information about client-side encryption using AWS KMS managed keys, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html">Amazon S3 Developer Guide</a> .
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link S3ActionProperty#getObjectKeyPrefix}
             * @param objectKeyPrefix The key prefix of the Amazon S3 bucket.
             *                        The key prefix is similar to a directory name that enables you to store similar data under the same directory in a bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectKeyPrefix(java.lang.String objectKeyPrefix) {
                this.objectKeyPrefix = objectKeyPrefix;
                return this;
            }

            /**
             * Sets the value of {@link S3ActionProperty#getTopicArn}
             * @param topicArn The ARN of the Amazon SNS topic to notify when the message is saved to the Amazon S3 bucket.
             *                 You can find the ARN of a topic by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html">ListTopics</a> operation in Amazon SNS.
             *                 <p>
             *                 For more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicArn(java.lang.String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ActionProperty {
            private final java.lang.String bucketName;
            private final java.lang.String iamRoleArn;
            private final java.lang.String kmsKeyArn;
            private final java.lang.String objectKeyPrefix;
            private final java.lang.String topicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iamRoleArn = software.amazon.jsii.Kernel.get(this, "iamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.objectKeyPrefix = software.amazon.jsii.Kernel.get(this, "objectKeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.topicArn = software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.iamRoleArn = builder.iamRoleArn;
                this.kmsKeyArn = builder.kmsKeyArn;
                this.objectKeyPrefix = builder.objectKeyPrefix;
                this.topicArn = builder.topicArn;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getIamRoleArn() {
                return this.iamRoleArn;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            public final java.lang.String getObjectKeyPrefix() {
                return this.objectKeyPrefix;
            }

            @Override
            public final java.lang.String getTopicArn() {
                return this.topicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                if (this.getIamRoleArn() != null) {
                    data.set("iamRoleArn", om.valueToTree(this.getIamRoleArn()));
                }
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }
                if (this.getObjectKeyPrefix() != null) {
                    data.set("objectKeyPrefix", om.valueToTree(this.getObjectKeyPrefix()));
                }
                if (this.getTopicArn() != null) {
                    data.set("topicArn", om.valueToTree(this.getTopicArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnReceiptRule.S3ActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ActionProperty.Jsii$Proxy that = (S3ActionProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (this.iamRoleArn != null ? !this.iamRoleArn.equals(that.iamRoleArn) : that.iamRoleArn != null) return false;
                if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
                if (this.objectKeyPrefix != null ? !this.objectKeyPrefix.equals(that.objectKeyPrefix) : that.objectKeyPrefix != null) return false;
                return this.topicArn != null ? this.topicArn.equals(that.topicArn) : that.topicArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.iamRoleArn != null ? this.iamRoleArn.hashCode() : 0);
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                result = 31 * result + (this.objectKeyPrefix != null ? this.objectKeyPrefix.hashCode() : 0);
                result = 31 * result + (this.topicArn != null ? this.topicArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The action to publish the email content to an Amazon SNS topic.
     * <p>
     * When executed, this action will send the email as a notification to the specified SNS topic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * SNSActionProperty sNSActionProperty = SNSActionProperty.builder()
     *         .encoding("encoding")
     *         .topicArn("topicArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-snsaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-snsaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnReceiptRule.SNSActionProperty")
    @software.amazon.jsii.Jsii.Proxy(SNSActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SNSActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The encoding to use for the email within the Amazon SNS notification.
         * <p>
         * The default value is <code>UTF-8</code> . Use <code>BASE64</code> if you need to preserve all special characters, especially when the original message uses a different encoding format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-snsaction.html#cfn-ses-receiptrule-snsaction-encoding">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-snsaction.html#cfn-ses-receiptrule-snsaction-encoding</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncoding() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS Topic to which notification for the email received will be published.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-snsaction.html#cfn-ses-receiptrule-snsaction-topicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-snsaction.html#cfn-ses-receiptrule-snsaction-topicarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTopicArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SNSActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SNSActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SNSActionProperty> {
            java.lang.String encoding;
            java.lang.String topicArn;

            /**
             * Sets the value of {@link SNSActionProperty#getEncoding}
             * @param encoding The encoding to use for the email within the Amazon SNS notification.
             *                 The default value is <code>UTF-8</code> . Use <code>BASE64</code> if you need to preserve all special characters, especially when the original message uses a different encoding format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encoding(java.lang.String encoding) {
                this.encoding = encoding;
                return this;
            }

            /**
             * Sets the value of {@link SNSActionProperty#getTopicArn}
             * @param topicArn The Amazon Resource Name (ARN) of the Amazon SNS Topic to which notification for the email received will be published.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicArn(java.lang.String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SNSActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SNSActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SNSActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SNSActionProperty {
            private final java.lang.String encoding;
            private final java.lang.String topicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encoding = software.amazon.jsii.Kernel.get(this, "encoding", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.topicArn = software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encoding = builder.encoding;
                this.topicArn = builder.topicArn;
            }

            @Override
            public final java.lang.String getEncoding() {
                return this.encoding;
            }

            @Override
            public final java.lang.String getTopicArn() {
                return this.topicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEncoding() != null) {
                    data.set("encoding", om.valueToTree(this.getEncoding()));
                }
                if (this.getTopicArn() != null) {
                    data.set("topicArn", om.valueToTree(this.getTopicArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnReceiptRule.SNSActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SNSActionProperty.Jsii$Proxy that = (SNSActionProperty.Jsii$Proxy) o;

                if (this.encoding != null ? !this.encoding.equals(that.encoding) : that.encoding != null) return false;
                return this.topicArn != null ? this.topicArn.equals(that.topicArn) : that.topicArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encoding != null ? this.encoding.hashCode() : 0;
                result = 31 * result + (this.topicArn != null ? this.topicArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * When included in a receipt rule, this action terminates the evaluation of the receipt rule set and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).
     * <p>
     * For information about setting a stop action in a receipt rule, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-stop.html">Amazon SES Developer Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * StopActionProperty stopActionProperty = StopActionProperty.builder()
     *         .scope("scope")
     *         // the properties below are optional
     *         .topicArn("topicArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-stopaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-stopaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnReceiptRule.StopActionProperty")
    @software.amazon.jsii.Jsii.Proxy(StopActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StopActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The scope of the StopAction.
         * <p>
         * The only acceptable value is <code>RuleSet</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-stopaction.html#cfn-ses-receiptrule-stopaction-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-stopaction.html#cfn-ses-receiptrule-stopaction-scope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScope();

        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the stop action is taken.
         * <p>
         * You can find the ARN of a topic by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html">ListTopics</a> Amazon SNS operation.
         * <p>
         * For more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-stopaction.html#cfn-ses-receiptrule-stopaction-topicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-stopaction.html#cfn-ses-receiptrule-stopaction-topicarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTopicArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StopActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StopActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StopActionProperty> {
            java.lang.String scope;
            java.lang.String topicArn;

            /**
             * Sets the value of {@link StopActionProperty#getScope}
             * @param scope The scope of the StopAction. This parameter is required.
             *              The only acceptable value is <code>RuleSet</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Sets the value of {@link StopActionProperty#getTopicArn}
             * @param topicArn The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the stop action is taken.
             *                 You can find the ARN of a topic by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html">ListTopics</a> Amazon SNS operation.
             *                 <p>
             *                 For more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicArn(java.lang.String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StopActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StopActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StopActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StopActionProperty {
            private final java.lang.String scope;
            private final java.lang.String topicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.topicArn = software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scope = java.util.Objects.requireNonNull(builder.scope, "scope is required");
                this.topicArn = builder.topicArn;
            }

            @Override
            public final java.lang.String getScope() {
                return this.scope;
            }

            @Override
            public final java.lang.String getTopicArn() {
                return this.topicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scope", om.valueToTree(this.getScope()));
                if (this.getTopicArn() != null) {
                    data.set("topicArn", om.valueToTree(this.getTopicArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnReceiptRule.StopActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StopActionProperty.Jsii$Proxy that = (StopActionProperty.Jsii$Proxy) o;

                if (!scope.equals(that.scope)) return false;
                return this.topicArn != null ? this.topicArn.equals(that.topicArn) : that.topicArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scope.hashCode();
                result = 31 * result + (this.topicArn != null ? this.topicArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * When included in a receipt rule, this action calls Amazon WorkMail and, optionally, publishes a notification to Amazon Simple Notification Service (Amazon SNS).
     * <p>
     * It usually isn't necessary to set this up manually, because Amazon WorkMail adds the rule automatically during its setup procedure.
     * <p>
     * For information using a receipt rule to call Amazon WorkMail, see the <a href="https://docs.aws.amazon.com/ses/latest/dg/receiving-email-action-workmail.html">Amazon SES Developer Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * WorkmailActionProperty workmailActionProperty = WorkmailActionProperty.builder()
     *         .organizationArn("organizationArn")
     *         // the properties below are optional
     *         .topicArn("topicArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-workmailaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-workmailaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnReceiptRule.WorkmailActionProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkmailActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkmailActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Amazon WorkMail organization. Amazon WorkMail ARNs use the following format:.
         * <p>
         * <code>arn:aws:workmail:&lt;region&gt;:&lt;awsAccountId&gt;:organization/&lt;workmailOrganizationId&gt;</code>
         * <p>
         * You can find the ID of your organization by using the <a href="https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListOrganizations.html">ListOrganizations</a> operation in Amazon WorkMail. Amazon WorkMail organization IDs begin with " <code>m-</code> ", followed by a string of alphanumeric characters.
         * <p>
         * For information about Amazon WorkMail organizations, see the <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html">Amazon WorkMail Administrator Guide</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-workmailaction.html#cfn-ses-receiptrule-workmailaction-organizationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-workmailaction.html#cfn-ses-receiptrule-workmailaction-organizationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOrganizationArn();

        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action is called.
         * <p>
         * You can find the ARN of a topic by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html">ListTopics</a> operation in Amazon SNS.
         * <p>
         * For more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-workmailaction.html#cfn-ses-receiptrule-workmailaction-topicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-workmailaction.html#cfn-ses-receiptrule-workmailaction-topicarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTopicArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkmailActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkmailActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkmailActionProperty> {
            java.lang.String organizationArn;
            java.lang.String topicArn;

            /**
             * Sets the value of {@link WorkmailActionProperty#getOrganizationArn}
             * @param organizationArn The Amazon Resource Name (ARN) of the Amazon WorkMail organization. Amazon WorkMail ARNs use the following format:. This parameter is required.
             *                        <code>arn:aws:workmail:&lt;region&gt;:&lt;awsAccountId&gt;:organization/&lt;workmailOrganizationId&gt;</code>
             *                        <p>
             *                        You can find the ID of your organization by using the <a href="https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListOrganizations.html">ListOrganizations</a> operation in Amazon WorkMail. Amazon WorkMail organization IDs begin with " <code>m-</code> ", followed by a string of alphanumeric characters.
             *                        <p>
             *                        For information about Amazon WorkMail organizations, see the <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html">Amazon WorkMail Administrator Guide</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationArn(java.lang.String organizationArn) {
                this.organizationArn = organizationArn;
                return this;
            }

            /**
             * Sets the value of {@link WorkmailActionProperty#getTopicArn}
             * @param topicArn The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action is called.
             *                 You can find the ARN of a topic by using the <a href="https://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html">ListTopics</a> operation in Amazon SNS.
             *                 <p>
             *                 For more information about Amazon SNS topics, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicArn(java.lang.String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkmailActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkmailActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkmailActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkmailActionProperty {
            private final java.lang.String organizationArn;
            private final java.lang.String topicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.organizationArn = software.amazon.jsii.Kernel.get(this, "organizationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.topicArn = software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.organizationArn = java.util.Objects.requireNonNull(builder.organizationArn, "organizationArn is required");
                this.topicArn = builder.topicArn;
            }

            @Override
            public final java.lang.String getOrganizationArn() {
                return this.organizationArn;
            }

            @Override
            public final java.lang.String getTopicArn() {
                return this.topicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("organizationArn", om.valueToTree(this.getOrganizationArn()));
                if (this.getTopicArn() != null) {
                    data.set("topicArn", om.valueToTree(this.getTopicArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnReceiptRule.WorkmailActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkmailActionProperty.Jsii$Proxy that = (WorkmailActionProperty.Jsii$Proxy) o;

                if (!organizationArn.equals(that.organizationArn)) return false;
                return this.topicArn != null ? this.topicArn.equals(that.topicArn) : that.topicArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.organizationArn.hashCode();
                result = 31 * result + (this.topicArn != null ? this.topicArn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.CfnReceiptRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.CfnReceiptRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ses.CfnReceiptRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ses.CfnReceiptRuleProps.Builder();
        }

        /**
         * A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan status, and TLS policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html#cfn-ses-receiptrule-rule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html#cfn-ses-receiptrule-rule</a>
         * @param rule A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan status, and TLS policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rule(final software.amazon.awscdk.IResolvable rule) {
            this.props.rule(rule);
            return this;
        }
        /**
         * A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan status, and TLS policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html#cfn-ses-receiptrule-rule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html#cfn-ses-receiptrule-rule</a>
         * @param rule A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan status, and TLS policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rule(final software.amazon.awscdk.services.ses.CfnReceiptRule.RuleProperty rule) {
            this.props.rule(rule);
            return this;
        }

        /**
         * The name of the rule set where the receipt rule is added.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html#cfn-ses-receiptrule-rulesetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html#cfn-ses-receiptrule-rulesetname</a>
         * @param ruleSetName The name of the rule set where the receipt rule is added. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleSetName(final java.lang.String ruleSetName) {
            this.props.ruleSetName(ruleSetName);
            return this;
        }

        /**
         * The name of an existing rule after which the new rule is placed.
         * <p>
         * If this parameter is null, the new rule is inserted at the beginning of the rule list.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html#cfn-ses-receiptrule-after">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-receiptrule.html#cfn-ses-receiptrule-after</a>
         * @param after The name of an existing rule after which the new rule is placed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder after(final java.lang.String after) {
            this.props.after(after);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ses.CfnReceiptRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.CfnReceiptRule build() {
            return new software.amazon.awscdk.services.ses.CfnReceiptRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
