package software.amazon.awscdk.services.ses;

/**
 * HTTPS policy option for the protocol of the open and click tracking links for your custom redirect domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ConfigurationSet.Builder.create(this, "ConfigurationSet")
 *         .customTrackingRedirectDomain("track.cdk.dev")
 *         .customTrackingHttpsPolicy(HttpsPolicy.REQUIRE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:15.865Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.HttpsPolicy")
public enum HttpsPolicy {
    /**
     * Open and Click tracking links will both be wrapped using HTTPS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUIRE,
    /**
     * Open tracking links will be wrapped using HTTPS.
     * <p>
     * Click tracking links will be wrapped using the original protocol of the link.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUIRE_OPEN_ONLY,
    /**
     * Open tracking links will be wrapped using HTTP.
     * <p>
     * Click tracking links will be wrapped using the original protocol of the link.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPTIONAL,
}
