package software.amazon.awscdk.services.ses;

/**
 * Construction properties for a ReceiptRuleSet.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.ses.*;
 * import software.amazon.awscdk.customresources.CustomResourceConfig;
 * App app = new App();
 * Stack stack = new Stack(app, "Stack");
 * CustomResourceConfig.of(app).addLogRetentionLifetime(RetentionDays.TEN_YEARS);
 * CustomResourceConfig.of(app).addRemovalPolicy(RemovalPolicy.DESTROY);
 * ReceiptRuleSet.Builder.create(app, "RuleSet")
 *         .dropSpam(true)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:15.874Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.ReceiptRuleSetProps")
@software.amazon.jsii.Jsii.Proxy(ReceiptRuleSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ReceiptRuleSetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether to add a first rule to stop processing messages that have at least one spam indicator.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDropSpam() {
        return null;
    }

    /**
     * The name for the receipt rule set.
     * <p>
     * Default: - A CloudFormation generated name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReceiptRuleSetName() {
        return null;
    }

    /**
     * The list of rules to add to this rule set.
     * <p>
     * Rules are added in the same
     * order as they appear in the list.
     * <p>
     * Default: - No rules are added to the rule set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ses.ReceiptRuleOptions> getRules() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ReceiptRuleSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ReceiptRuleSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ReceiptRuleSetProps> {
        java.lang.Boolean dropSpam;
        java.lang.String receiptRuleSetName;
        java.util.List<software.amazon.awscdk.services.ses.ReceiptRuleOptions> rules;

        /**
         * Sets the value of {@link ReceiptRuleSetProps#getDropSpam}
         * @param dropSpam Whether to add a first rule to stop processing messages that have at least one spam indicator.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dropSpam(java.lang.Boolean dropSpam) {
            this.dropSpam = dropSpam;
            return this;
        }

        /**
         * Sets the value of {@link ReceiptRuleSetProps#getReceiptRuleSetName}
         * @param receiptRuleSetName The name for the receipt rule set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder receiptRuleSetName(java.lang.String receiptRuleSetName) {
            this.receiptRuleSetName = receiptRuleSetName;
            return this;
        }

        /**
         * Sets the value of {@link ReceiptRuleSetProps#getRules}
         * @param rules The list of rules to add to this rule set.
         *              Rules are added in the same
         *              order as they appear in the list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder rules(java.util.List<? extends software.amazon.awscdk.services.ses.ReceiptRuleOptions> rules) {
            this.rules = (java.util.List<software.amazon.awscdk.services.ses.ReceiptRuleOptions>)rules;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ReceiptRuleSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ReceiptRuleSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ReceiptRuleSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReceiptRuleSetProps {
        private final java.lang.Boolean dropSpam;
        private final java.lang.String receiptRuleSetName;
        private final java.util.List<software.amazon.awscdk.services.ses.ReceiptRuleOptions> rules;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dropSpam = software.amazon.jsii.Kernel.get(this, "dropSpam", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.receiptRuleSetName = software.amazon.jsii.Kernel.get(this, "receiptRuleSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.ReceiptRuleOptions.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dropSpam = builder.dropSpam;
            this.receiptRuleSetName = builder.receiptRuleSetName;
            this.rules = (java.util.List<software.amazon.awscdk.services.ses.ReceiptRuleOptions>)builder.rules;
        }

        @Override
        public final java.lang.Boolean getDropSpam() {
            return this.dropSpam;
        }

        @Override
        public final java.lang.String getReceiptRuleSetName() {
            return this.receiptRuleSetName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ses.ReceiptRuleOptions> getRules() {
            return this.rules;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDropSpam() != null) {
                data.set("dropSpam", om.valueToTree(this.getDropSpam()));
            }
            if (this.getReceiptRuleSetName() != null) {
                data.set("receiptRuleSetName", om.valueToTree(this.getReceiptRuleSetName()));
            }
            if (this.getRules() != null) {
                data.set("rules", om.valueToTree(this.getRules()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.ReceiptRuleSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ReceiptRuleSetProps.Jsii$Proxy that = (ReceiptRuleSetProps.Jsii$Proxy) o;

            if (this.dropSpam != null ? !this.dropSpam.equals(that.dropSpam) : that.dropSpam != null) return false;
            if (this.receiptRuleSetName != null ? !this.receiptRuleSetName.equals(that.receiptRuleSetName) : that.receiptRuleSetName != null) return false;
            return this.rules != null ? this.rules.equals(that.rules) : that.rules == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dropSpam != null ? this.dropSpam.hashCode() : 0;
            result = 31 * result + (this.receiptRuleSetName != null ? this.receiptRuleSetName.hashCode() : 0);
            result = 31 * result + (this.rules != null ? this.rules.hashCode() : 0);
            return result;
        }
    }
}
