package software.amazon.awscdk.services.sns;

/**
 * Class for building the FilterPolicy by avoiding union types.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function fn;
 * Topic myTopic = new Topic(this, "MyTopic");
 * // Lambda should receive only message matching the following conditions on message body:
 * // color: 'red' or 'orange'
 * myTopic.addSubscription(LambdaSubscription.Builder.create(fn)
 *         .filterPolicyWithMessageBody(Map.of(
 *                 "background", FilterOrPolicy.policy(Map.of(
 *                         "color", FilterOrPolicy.filter(SubscriptionFilter.stringFilter(StringConditions.builder()
 *                                 .allowlist(List.of("red", "orange"))
 *                                 .build()))))))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:15.949Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.FilterOrPolicy")
public abstract class FilterOrPolicy extends software.amazon.jsii.JsiiObject {

    protected FilterOrPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FilterOrPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected FilterOrPolicy() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Filter of MessageBody.
     * <p>
     * @param filter This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.Filter filter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.SubscriptionFilter filter) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.sns.FilterOrPolicy.class, "filter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.Filter.class), new Object[] { java.util.Objects.requireNonNull(filter, "filter is required") });
    }

    /**
     * Policy of MessageBody.
     * <p>
     * @param policy This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.Policy policy(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.FilterOrPolicy> policy) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.sns.FilterOrPolicy.class, "policy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.Policy.class), new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
    }

    /**
     * Check if instance is <code>Filter</code> type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean isFilter() {
        return software.amazon.jsii.Kernel.call(this, "isFilter", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Check if instance is <code>Policy</code> type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean isPolicy() {
        return software.amazon.jsii.Kernel.call(this, "isPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Type switch for disambiguating between subclasses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.FilterOrPolicyType getType();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.sns.FilterOrPolicy {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Type switch for disambiguating between subclasses.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.FilterOrPolicyType getType() {
            return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.FilterOrPolicyType.class));
        }
    }
}
