package software.amazon.awscdk.services.sqs;

/**
 * Permission settings for the dead letter source queue.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IQueue sourceQueue;
 * // Only the sourceQueue can specify this queue as the dead-letter queue.
 * Queue queue1 = Queue.Builder.create(this, "Queue2")
 *         .redriveAllowPolicy(RedriveAllowPolicy.builder()
 *                 .sourceQueues(List.of(sourceQueue))
 *                 .build())
 *         .build();
 * // No source queues can specify this queue as the dead-letter queue.
 * Queue queue2 = Queue.Builder.create(this, "Queue")
 *         .redriveAllowPolicy(RedriveAllowPolicy.builder()
 *                 .redrivePermission(RedrivePermission.DENY_ALL)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:16.005Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sqs.RedriveAllowPolicy")
@software.amazon.jsii.Jsii.Proxy(RedriveAllowPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RedriveAllowPolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * Permission settings for source queues that can designate this queue as their dead-letter queue.
     * <p>
     * Default: - `RedrivePermission.BY_QUEUE` if `sourceQueues` is specified,`RedrivePermission.ALLOW_ALL` otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.RedrivePermission getRedrivePermission() {
        return null;
    }

    /**
     * Source queues that can designate this queue as their dead-letter queue.
     * <p>
     * When <code>redrivePermission</code> is set to <code>RedrivePermission.BY_QUEUE</code>, this parameter is required.
     * <p>
     * You can specify up to 10 source queues.
     * To allow more than 10 source queues to specify dead-letter queues, set the <code>redrivePermission</code> to
     * <code>RedrivePermission.ALLOW_ALL</code>.
     * <p>
     * When <code>redrivePermission</code> is either <code>RedrivePermission.ALLOW_ALL</code> or <code>RedrivePermission.DENY_ALL</code>,
     * this parameter cannot be set.
     * <p>
     * Default: - Required when `redrivePermission` is `RedrivePermission.BY_QUEUE`, cannot be defined otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.sqs.IQueue> getSourceQueues() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RedriveAllowPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RedriveAllowPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RedriveAllowPolicy> {
        software.amazon.awscdk.services.sqs.RedrivePermission redrivePermission;
        java.util.List<software.amazon.awscdk.services.sqs.IQueue> sourceQueues;

        /**
         * Sets the value of {@link RedriveAllowPolicy#getRedrivePermission}
         * @param redrivePermission Permission settings for source queues that can designate this queue as their dead-letter queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redrivePermission(software.amazon.awscdk.services.sqs.RedrivePermission redrivePermission) {
            this.redrivePermission = redrivePermission;
            return this;
        }

        /**
         * Sets the value of {@link RedriveAllowPolicy#getSourceQueues}
         * @param sourceQueues Source queues that can designate this queue as their dead-letter queue.
         *                     When <code>redrivePermission</code> is set to <code>RedrivePermission.BY_QUEUE</code>, this parameter is required.
         *                     <p>
         *                     You can specify up to 10 source queues.
         *                     To allow more than 10 source queues to specify dead-letter queues, set the <code>redrivePermission</code> to
         *                     <code>RedrivePermission.ALLOW_ALL</code>.
         *                     <p>
         *                     When <code>redrivePermission</code> is either <code>RedrivePermission.ALLOW_ALL</code> or <code>RedrivePermission.DENY_ALL</code>,
         *                     this parameter cannot be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder sourceQueues(java.util.List<? extends software.amazon.awscdk.services.sqs.IQueue> sourceQueues) {
            this.sourceQueues = (java.util.List<software.amazon.awscdk.services.sqs.IQueue>)sourceQueues;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RedriveAllowPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RedriveAllowPolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RedriveAllowPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedriveAllowPolicy {
        private final software.amazon.awscdk.services.sqs.RedrivePermission redrivePermission;
        private final java.util.List<software.amazon.awscdk.services.sqs.IQueue> sourceQueues;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.redrivePermission = software.amazon.jsii.Kernel.get(this, "redrivePermission", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.RedrivePermission.class));
            this.sourceQueues = software.amazon.jsii.Kernel.get(this, "sourceQueues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.redrivePermission = builder.redrivePermission;
            this.sourceQueues = (java.util.List<software.amazon.awscdk.services.sqs.IQueue>)builder.sourceQueues;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.RedrivePermission getRedrivePermission() {
            return this.redrivePermission;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.sqs.IQueue> getSourceQueues() {
            return this.sourceQueues;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getRedrivePermission() != null) {
                data.set("redrivePermission", om.valueToTree(this.getRedrivePermission()));
            }
            if (this.getSourceQueues() != null) {
                data.set("sourceQueues", om.valueToTree(this.getSourceQueues()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sqs.RedriveAllowPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RedriveAllowPolicy.Jsii$Proxy that = (RedriveAllowPolicy.Jsii$Proxy) o;

            if (this.redrivePermission != null ? !this.redrivePermission.equals(that.redrivePermission) : that.redrivePermission != null) return false;
            return this.sourceQueues != null ? this.sourceQueues.equals(that.sourceQueues) : that.sourceQueues == null;
        }

        @Override
        public final int hashCode() {
            int result = this.redrivePermission != null ? this.redrivePermission.hashCode() : 0;
            result = 31 * result + (this.sourceQueues != null ? this.sourceQueues.hashCode() : 0);
            return result;
        }
    }
}
