package software.amazon.awscdk.services.ssm;

/**
 * Properties for defining a <code>CfnAssociation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssm.*;
 * Object parameters;
 * CfnAssociationProps cfnAssociationProps = CfnAssociationProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .applyOnlyAtCronInterval(false)
 *         .associationName("associationName")
 *         .automationTargetParameterName("automationTargetParameterName")
 *         .calendarNames(List.of("calendarNames"))
 *         .complianceSeverity("complianceSeverity")
 *         .documentVersion("documentVersion")
 *         .instanceId("instanceId")
 *         .maxConcurrency("maxConcurrency")
 *         .maxErrors("maxErrors")
 *         .outputLocation(InstanceAssociationOutputLocationProperty.builder()
 *                 .s3Location(S3OutputLocationProperty.builder()
 *                         .outputS3BucketName("outputS3BucketName")
 *                         .outputS3KeyPrefix("outputS3KeyPrefix")
 *                         .outputS3Region("outputS3Region")
 *                         .build())
 *                 .build())
 *         .parameters(parameters)
 *         .scheduleExpression("scheduleExpression")
 *         .scheduleOffset(123)
 *         .syncCompliance("syncCompliance")
 *         .targets(List.of(TargetProperty.builder()
 *                 .key("key")
 *                 .values(List.of("values"))
 *                 .build()))
 *         .waitForSuccessTimeoutSeconds(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:16.025Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the SSM document that contains the configuration information for the instance.
     * <p>
     * You can specify <code>Command</code> or <code>Automation</code> documents. The documents can be AWS -predefined documents, documents you created, or a document that is shared with you from another account. For SSM documents that are shared with you from other AWS accounts , you must specify the complete SSM document ARN, in the following format:
     * <p>
     * <code>arn:partition:ssm:region:account-id:document/document-name</code>
     * <p>
     * For example: <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
     * <p>
     * For AWS -predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, <code>AWS -ApplyPatchBaseline</code> or <code>My-Document</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified.
     * <p>
     * Specify this option if you don't want an association to run immediately after you create it. This parameter is not supported for rate expressions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-applyonlyatcroninterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-applyonlyatcroninterval</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getApplyOnlyAtCronInterval() {
        return null;
    }

    /**
     * Specify a descriptive name for the association.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-associationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-associationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssociationName() {
        return null;
    }

    /**
     * Choose the parameter that will define how your automation will branch out.
     * <p>
     * This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a tool in AWS Systems Manager .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-automationtargetparametername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-automationtargetparametername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAutomationTargetParameterName() {
        return null;
    }

    /**
     * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated under.
     * <p>
     * The associations only run when that Change Calendar is open. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">AWS Systems Manager Change Calendar</a> in the <em>AWS Systems Manager User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-calendarnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-calendarnames</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCalendarNames() {
        return null;
    }

    /**
     * The severity level that is assigned to the association.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-complianceseverity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-complianceseverity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComplianceSeverity() {
        return null;
    }

    /**
     * The version of the SSM document to associate with the target.
     * <p>
     * <blockquote>
     * <p>
     * Note the following important information.
     * <p>
     * <ul>
     * <li>State Manager doesn't support running associations that use a new version of a document if that document is shared from another account. State Manager always runs the <code>default</code> version of a document if shared from another account, even though the Systems Manager console shows that a new version was processed. If you want to run an association using a new version of a document shared form another account, you must set the document version to <code>default</code> .</li>
     * <li><code>DocumentVersion</code> is not valid for documents owned by AWS , such as <code>AWS-RunPatchBaseline</code> or <code>AWS-UpdateSSMAgent</code> . If you specify <code>DocumentVersion</code> for an AWS document, the system returns the following error: "Error occurred during operation 'CreateAssociation'." (RequestToken: <token>, HandlerErrorCode: GeneralServiceException).</li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-documentversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-documentversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDocumentVersion() {
        return null;
    }

    /**
     * The ID of the instance that the SSM document is associated with.
     * <p>
     * You must specify the <code>InstanceId</code> or <code>Targets</code> property.
     * <p>
     * <blockquote>
     * <p>
     * <code>InstanceId</code> has been deprecated. To specify an instance ID for an association, use the <code>Targets</code> parameter. If you use the parameter <code>InstanceId</code> , you cannot use the parameters <code>AssociationName</code> , <code>DocumentVersion</code> , <code>MaxErrors</code> , <code>MaxConcurrency</code> , <code>OutputLocation</code> , or <code>ScheduleExpression</code> . To use these parameters, you must use the <code>Targets</code> parameter.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-instanceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-instanceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceId() {
        return null;
    }

    /**
     * The maximum number of targets allowed to run the association at the same time.
     * <p>
     * You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.
     * <p>
     * If a new managed node starts and attempts to run an association while Systems Manager is running <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for <code>MaxConcurrency</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-maxconcurrency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-maxconcurrency</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaxConcurrency() {
        return null;
    }

    /**
     * The number of errors that are allowed before the system stops sending requests to run the association on additional targets.
     * <p>
     * You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set <code>MaxError</code> to 10%, then the system stops sending the request when the sixth error is received.
     * <p>
     * Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at a time.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-maxerrors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-maxerrors</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaxErrors() {
        return null;
    }

    /**
     * An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-outputlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-outputlocation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOutputLocation() {
        return null;
    }

    /**
     * The parameters for the runtime configuration of the document.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * A cron expression that specifies a schedule when the association runs.
     * <p>
     * The schedule runs in Coordinated Universal Time (UTC).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-scheduleexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-scheduleexpression</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScheduleExpression() {
        return null;
    }

    /**
     * Number of days to wait after the scheduled day to run an association.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-scheduleoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-scheduleoffset</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getScheduleOffset() {
        return null;
    }

    /**
     * The mode for generating association compliance.
     * <p>
     * You can specify <code>AUTO</code> or <code>MANUAL</code> . In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code> . If the association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code> .
     * <p>
     * In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <code>PutComplianceItems</code> API action. In this case, compliance data is not managed by State Manager. It is managed by your direct call to the <code>PutComplianceItems</code> API action.
     * <p>
     * By default, all associations use <code>AUTO</code> mode.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-synccompliance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-synccompliance</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSyncCompliance() {
        return null;
    }

    /**
     * The targets for the association.
     * <p>
     * You must specify the <code>InstanceId</code> or <code>Targets</code> property. You can target all instances in an AWS account by specifying t he <code>InstanceIds</code> key with a value of <code>*</code> .
     * <p>
     * Supported formats include the following.
     * <p>
     * <ul>
     * <li><code>Key=InstanceIds,Values=&lt;instance-id-1&gt;,&lt;instance-id-2&gt;,&lt;instance-id-3&gt;</code></li>
     * <li><code>Key=tag-key,Values=&lt;my-tag-key-1&gt;,&lt;my-tag-key-2&gt;</code></li>
     * </ul>
     * <p>
     * To view a JSON and a YAML example that targets all instances, see "Create an association for all managed instances in an AWS account " on the Examples page.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-targets</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTargets() {
        return null;
    }

    /**
     * The number of seconds the service should wait for the association status to show "Success" before proceeding with the stack execution.
     * <p>
     * If the association status doesn't show "Success" after the specified number of seconds, then stack creation fails.
     * <p>
     * <blockquote>
     * <p>
     * When you specify a value for the <code>WaitForSuccessTimeoutSeconds</code> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">drift detection</a> for your AWS CloudFormation stack’s configuration might yield inaccurate results. If drift detection is important in your scenario, we recommend that you don’t include <code>WaitForSuccessTimeoutSeconds</code> in your template.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-waitforsuccesstimeoutseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-association.html#cfn-ssm-association-waitforsuccesstimeoutseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getWaitForSuccessTimeoutSeconds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAssociationProps> {
        java.lang.String name;
        java.lang.Object applyOnlyAtCronInterval;
        java.lang.String associationName;
        java.lang.String automationTargetParameterName;
        java.util.List<java.lang.String> calendarNames;
        java.lang.String complianceSeverity;
        java.lang.String documentVersion;
        java.lang.String instanceId;
        java.lang.String maxConcurrency;
        java.lang.String maxErrors;
        java.lang.Object outputLocation;
        java.lang.Object parameters;
        java.lang.String scheduleExpression;
        java.lang.Number scheduleOffset;
        java.lang.String syncCompliance;
        java.lang.Object targets;
        java.lang.Number waitForSuccessTimeoutSeconds;

        /**
         * Sets the value of {@link CfnAssociationProps#getName}
         * @param name The name of the SSM document that contains the configuration information for the instance. This parameter is required.
         *             You can specify <code>Command</code> or <code>Automation</code> documents. The documents can be AWS -predefined documents, documents you created, or a document that is shared with you from another account. For SSM documents that are shared with you from other AWS accounts , you must specify the complete SSM document ARN, in the following format:
         *             <p>
         *             <code>arn:partition:ssm:region:account-id:document/document-name</code>
         *             <p>
         *             For example: <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
         *             <p>
         *             For AWS -predefined documents and SSM documents you created in your account, you only need to specify the document name. For example, <code>AWS -ApplyPatchBaseline</code> or <code>My-Document</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getApplyOnlyAtCronInterval}
         * @param applyOnlyAtCronInterval By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified.
         *                                Specify this option if you don't want an association to run immediately after you create it. This parameter is not supported for rate expressions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyOnlyAtCronInterval(java.lang.Boolean applyOnlyAtCronInterval) {
            this.applyOnlyAtCronInterval = applyOnlyAtCronInterval;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getApplyOnlyAtCronInterval}
         * @param applyOnlyAtCronInterval By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified.
         *                                Specify this option if you don't want an association to run immediately after you create it. This parameter is not supported for rate expressions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applyOnlyAtCronInterval(software.amazon.awscdk.IResolvable applyOnlyAtCronInterval) {
            this.applyOnlyAtCronInterval = applyOnlyAtCronInterval;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getAssociationName}
         * @param associationName Specify a descriptive name for the association.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associationName(java.lang.String associationName) {
            this.associationName = associationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getAutomationTargetParameterName}
         * @param automationTargetParameterName Choose the parameter that will define how your automation will branch out.
         *                                      This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a tool in AWS Systems Manager .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automationTargetParameterName(java.lang.String automationTargetParameterName) {
            this.automationTargetParameterName = automationTargetParameterName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getCalendarNames}
         * @param calendarNames The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated under.
         *                      The associations only run when that Change Calendar is open. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">AWS Systems Manager Change Calendar</a> in the <em>AWS Systems Manager User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder calendarNames(java.util.List<java.lang.String> calendarNames) {
            this.calendarNames = calendarNames;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getComplianceSeverity}
         * @param complianceSeverity The severity level that is assigned to the association.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder complianceSeverity(java.lang.String complianceSeverity) {
            this.complianceSeverity = complianceSeverity;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getDocumentVersion}
         * @param documentVersion The version of the SSM document to associate with the target.
         *                        <blockquote>
         *                        <p>
         *                        Note the following important information.
         *                        <p>
         *                        <ul>
         *                        <li>State Manager doesn't support running associations that use a new version of a document if that document is shared from another account. State Manager always runs the <code>default</code> version of a document if shared from another account, even though the Systems Manager console shows that a new version was processed. If you want to run an association using a new version of a document shared form another account, you must set the document version to <code>default</code> .</li>
         *                        <li><code>DocumentVersion</code> is not valid for documents owned by AWS , such as <code>AWS-RunPatchBaseline</code> or <code>AWS-UpdateSSMAgent</code> . If you specify <code>DocumentVersion</code> for an AWS document, the system returns the following error: "Error occurred during operation 'CreateAssociation'." (RequestToken: <token>, HandlerErrorCode: GeneralServiceException).</li>
         *                        </ul>
         *                        <p>
         *                        </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentVersion(java.lang.String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getInstanceId}
         * @param instanceId The ID of the instance that the SSM document is associated with.
         *                   You must specify the <code>InstanceId</code> or <code>Targets</code> property.
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   <code>InstanceId</code> has been deprecated. To specify an instance ID for an association, use the <code>Targets</code> parameter. If you use the parameter <code>InstanceId</code> , you cannot use the parameters <code>AssociationName</code> , <code>DocumentVersion</code> , <code>MaxErrors</code> , <code>MaxConcurrency</code> , <code>OutputLocation</code> , or <code>ScheduleExpression</code> . To use these parameters, you must use the <code>Targets</code> parameter.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getMaxConcurrency}
         * @param maxConcurrency The maximum number of targets allowed to run the association at the same time.
         *                       You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.
         *                       <p>
         *                       If a new managed node starts and attempts to run an association while Systems Manager is running <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for <code>MaxConcurrency</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrency(java.lang.String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getMaxErrors}
         * @param maxErrors The number of errors that are allowed before the system stops sending requests to run the association on additional targets.
         *                  You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set <code>MaxError</code> to 10%, then the system stops sending the request when the sixth error is received.
         *                  <p>
         *                  Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at a time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxErrors(java.lang.String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getOutputLocation}
         * @param outputLocation An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputLocation(software.amazon.awscdk.IResolvable outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getOutputLocation}
         * @param outputLocation An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputLocation(software.amazon.awscdk.services.ssm.CfnAssociation.InstanceAssociationOutputLocationProperty outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getParameters}
         * @param parameters The parameters for the runtime configuration of the document.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.lang.Object parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getScheduleExpression}
         * @param scheduleExpression A cron expression that specifies a schedule when the association runs.
         *                           The schedule runs in Coordinated Universal Time (UTC).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpression(java.lang.String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getScheduleOffset}
         * @param scheduleOffset Number of days to wait after the scheduled day to run an association.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleOffset(java.lang.Number scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getSyncCompliance}
         * @param syncCompliance The mode for generating association compliance.
         *                       You can specify <code>AUTO</code> or <code>MANUAL</code> . In <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is <code>COMPLIANT</code> . If the association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code> .
         *                       <p>
         *                       In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the <code>PutComplianceItems</code> API action. In this case, compliance data is not managed by State Manager. It is managed by your direct call to the <code>PutComplianceItems</code> API action.
         *                       <p>
         *                       By default, all associations use <code>AUTO</code> mode.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncCompliance(java.lang.String syncCompliance) {
            this.syncCompliance = syncCompliance;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getTargets}
         * @param targets The targets for the association.
         *                You must specify the <code>InstanceId</code> or <code>Targets</code> property. You can target all instances in an AWS account by specifying t he <code>InstanceIds</code> key with a value of <code>*</code> .
         *                <p>
         *                Supported formats include the following.
         *                <p>
         *                <ul>
         *                <li><code>Key=InstanceIds,Values=&lt;instance-id-1&gt;,&lt;instance-id-2&gt;,&lt;instance-id-3&gt;</code></li>
         *                <li><code>Key=tag-key,Values=&lt;my-tag-key-1&gt;,&lt;my-tag-key-2&gt;</code></li>
         *                </ul>
         *                <p>
         *                To view a JSON and a YAML example that targets all instances, see "Create an association for all managed instances in an AWS account " on the Examples page.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(software.amazon.awscdk.IResolvable targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getTargets}
         * @param targets The targets for the association.
         *                You must specify the <code>InstanceId</code> or <code>Targets</code> property. You can target all instances in an AWS account by specifying t he <code>InstanceIds</code> key with a value of <code>*</code> .
         *                <p>
         *                Supported formats include the following.
         *                <p>
         *                <ul>
         *                <li><code>Key=InstanceIds,Values=&lt;instance-id-1&gt;,&lt;instance-id-2&gt;,&lt;instance-id-3&gt;</code></li>
         *                <li><code>Key=tag-key,Values=&lt;my-tag-key-1&gt;,&lt;my-tag-key-2&gt;</code></li>
         *                </ul>
         *                <p>
         *                To view a JSON and a YAML example that targets all instances, see "Create an association for all managed instances in an AWS account " on the Examples page.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(java.util.List<? extends java.lang.Object> targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssociationProps#getWaitForSuccessTimeoutSeconds}
         * @param waitForSuccessTimeoutSeconds The number of seconds the service should wait for the association status to show "Success" before proceeding with the stack execution.
         *                                     If the association status doesn't show "Success" after the specified number of seconds, then stack creation fails.
         *                                     <p>
         *                                     <blockquote>
         *                                     <p>
         *                                     When you specify a value for the <code>WaitForSuccessTimeoutSeconds</code> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">drift detection</a> for your AWS CloudFormation stack’s configuration might yield inaccurate results. If drift detection is important in your scenario, we recommend that you don’t include <code>WaitForSuccessTimeoutSeconds</code> in your template.
         *                                     <p>
         *                                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder waitForSuccessTimeoutSeconds(java.lang.Number waitForSuccessTimeoutSeconds) {
            this.waitForSuccessTimeoutSeconds = waitForSuccessTimeoutSeconds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAssociationProps {
        private final java.lang.String name;
        private final java.lang.Object applyOnlyAtCronInterval;
        private final java.lang.String associationName;
        private final java.lang.String automationTargetParameterName;
        private final java.util.List<java.lang.String> calendarNames;
        private final java.lang.String complianceSeverity;
        private final java.lang.String documentVersion;
        private final java.lang.String instanceId;
        private final java.lang.String maxConcurrency;
        private final java.lang.String maxErrors;
        private final java.lang.Object outputLocation;
        private final java.lang.Object parameters;
        private final java.lang.String scheduleExpression;
        private final java.lang.Number scheduleOffset;
        private final java.lang.String syncCompliance;
        private final java.lang.Object targets;
        private final java.lang.Number waitForSuccessTimeoutSeconds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applyOnlyAtCronInterval = software.amazon.jsii.Kernel.get(this, "applyOnlyAtCronInterval", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.associationName = software.amazon.jsii.Kernel.get(this, "associationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.automationTargetParameterName = software.amazon.jsii.Kernel.get(this, "automationTargetParameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.calendarNames = software.amazon.jsii.Kernel.get(this, "calendarNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.complianceSeverity = software.amazon.jsii.Kernel.get(this, "complianceSeverity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.documentVersion = software.amazon.jsii.Kernel.get(this, "documentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceId = software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxConcurrency = software.amazon.jsii.Kernel.get(this, "maxConcurrency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxErrors = software.amazon.jsii.Kernel.get(this, "maxErrors", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputLocation = software.amazon.jsii.Kernel.get(this, "outputLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheduleOffset = software.amazon.jsii.Kernel.get(this, "scheduleOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.syncCompliance = software.amazon.jsii.Kernel.get(this, "syncCompliance", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.waitForSuccessTimeoutSeconds = software.amazon.jsii.Kernel.get(this, "waitForSuccessTimeoutSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.applyOnlyAtCronInterval = builder.applyOnlyAtCronInterval;
            this.associationName = builder.associationName;
            this.automationTargetParameterName = builder.automationTargetParameterName;
            this.calendarNames = builder.calendarNames;
            this.complianceSeverity = builder.complianceSeverity;
            this.documentVersion = builder.documentVersion;
            this.instanceId = builder.instanceId;
            this.maxConcurrency = builder.maxConcurrency;
            this.maxErrors = builder.maxErrors;
            this.outputLocation = builder.outputLocation;
            this.parameters = builder.parameters;
            this.scheduleExpression = builder.scheduleExpression;
            this.scheduleOffset = builder.scheduleOffset;
            this.syncCompliance = builder.syncCompliance;
            this.targets = builder.targets;
            this.waitForSuccessTimeoutSeconds = builder.waitForSuccessTimeoutSeconds;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getApplyOnlyAtCronInterval() {
            return this.applyOnlyAtCronInterval;
        }

        @Override
        public final java.lang.String getAssociationName() {
            return this.associationName;
        }

        @Override
        public final java.lang.String getAutomationTargetParameterName() {
            return this.automationTargetParameterName;
        }

        @Override
        public final java.util.List<java.lang.String> getCalendarNames() {
            return this.calendarNames;
        }

        @Override
        public final java.lang.String getComplianceSeverity() {
            return this.complianceSeverity;
        }

        @Override
        public final java.lang.String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final java.lang.String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final java.lang.String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final java.lang.Object getOutputLocation() {
            return this.outputLocation;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.String getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final java.lang.Number getScheduleOffset() {
            return this.scheduleOffset;
        }

        @Override
        public final java.lang.String getSyncCompliance() {
            return this.syncCompliance;
        }

        @Override
        public final java.lang.Object getTargets() {
            return this.targets;
        }

        @Override
        public final java.lang.Number getWaitForSuccessTimeoutSeconds() {
            return this.waitForSuccessTimeoutSeconds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getApplyOnlyAtCronInterval() != null) {
                data.set("applyOnlyAtCronInterval", om.valueToTree(this.getApplyOnlyAtCronInterval()));
            }
            if (this.getAssociationName() != null) {
                data.set("associationName", om.valueToTree(this.getAssociationName()));
            }
            if (this.getAutomationTargetParameterName() != null) {
                data.set("automationTargetParameterName", om.valueToTree(this.getAutomationTargetParameterName()));
            }
            if (this.getCalendarNames() != null) {
                data.set("calendarNames", om.valueToTree(this.getCalendarNames()));
            }
            if (this.getComplianceSeverity() != null) {
                data.set("complianceSeverity", om.valueToTree(this.getComplianceSeverity()));
            }
            if (this.getDocumentVersion() != null) {
                data.set("documentVersion", om.valueToTree(this.getDocumentVersion()));
            }
            if (this.getInstanceId() != null) {
                data.set("instanceId", om.valueToTree(this.getInstanceId()));
            }
            if (this.getMaxConcurrency() != null) {
                data.set("maxConcurrency", om.valueToTree(this.getMaxConcurrency()));
            }
            if (this.getMaxErrors() != null) {
                data.set("maxErrors", om.valueToTree(this.getMaxErrors()));
            }
            if (this.getOutputLocation() != null) {
                data.set("outputLocation", om.valueToTree(this.getOutputLocation()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getScheduleExpression() != null) {
                data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
            }
            if (this.getScheduleOffset() != null) {
                data.set("scheduleOffset", om.valueToTree(this.getScheduleOffset()));
            }
            if (this.getSyncCompliance() != null) {
                data.set("syncCompliance", om.valueToTree(this.getSyncCompliance()));
            }
            if (this.getTargets() != null) {
                data.set("targets", om.valueToTree(this.getTargets()));
            }
            if (this.getWaitForSuccessTimeoutSeconds() != null) {
                data.set("waitForSuccessTimeoutSeconds", om.valueToTree(this.getWaitForSuccessTimeoutSeconds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAssociationProps.Jsii$Proxy that = (CfnAssociationProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.applyOnlyAtCronInterval != null ? !this.applyOnlyAtCronInterval.equals(that.applyOnlyAtCronInterval) : that.applyOnlyAtCronInterval != null) return false;
            if (this.associationName != null ? !this.associationName.equals(that.associationName) : that.associationName != null) return false;
            if (this.automationTargetParameterName != null ? !this.automationTargetParameterName.equals(that.automationTargetParameterName) : that.automationTargetParameterName != null) return false;
            if (this.calendarNames != null ? !this.calendarNames.equals(that.calendarNames) : that.calendarNames != null) return false;
            if (this.complianceSeverity != null ? !this.complianceSeverity.equals(that.complianceSeverity) : that.complianceSeverity != null) return false;
            if (this.documentVersion != null ? !this.documentVersion.equals(that.documentVersion) : that.documentVersion != null) return false;
            if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) return false;
            if (this.maxConcurrency != null ? !this.maxConcurrency.equals(that.maxConcurrency) : that.maxConcurrency != null) return false;
            if (this.maxErrors != null ? !this.maxErrors.equals(that.maxErrors) : that.maxErrors != null) return false;
            if (this.outputLocation != null ? !this.outputLocation.equals(that.outputLocation) : that.outputLocation != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.scheduleExpression != null ? !this.scheduleExpression.equals(that.scheduleExpression) : that.scheduleExpression != null) return false;
            if (this.scheduleOffset != null ? !this.scheduleOffset.equals(that.scheduleOffset) : that.scheduleOffset != null) return false;
            if (this.syncCompliance != null ? !this.syncCompliance.equals(that.syncCompliance) : that.syncCompliance != null) return false;
            if (this.targets != null ? !this.targets.equals(that.targets) : that.targets != null) return false;
            return this.waitForSuccessTimeoutSeconds != null ? this.waitForSuccessTimeoutSeconds.equals(that.waitForSuccessTimeoutSeconds) : that.waitForSuccessTimeoutSeconds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.applyOnlyAtCronInterval != null ? this.applyOnlyAtCronInterval.hashCode() : 0);
            result = 31 * result + (this.associationName != null ? this.associationName.hashCode() : 0);
            result = 31 * result + (this.automationTargetParameterName != null ? this.automationTargetParameterName.hashCode() : 0);
            result = 31 * result + (this.calendarNames != null ? this.calendarNames.hashCode() : 0);
            result = 31 * result + (this.complianceSeverity != null ? this.complianceSeverity.hashCode() : 0);
            result = 31 * result + (this.documentVersion != null ? this.documentVersion.hashCode() : 0);
            result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
            result = 31 * result + (this.maxConcurrency != null ? this.maxConcurrency.hashCode() : 0);
            result = 31 * result + (this.maxErrors != null ? this.maxErrors.hashCode() : 0);
            result = 31 * result + (this.outputLocation != null ? this.outputLocation.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.scheduleExpression != null ? this.scheduleExpression.hashCode() : 0);
            result = 31 * result + (this.scheduleOffset != null ? this.scheduleOffset.hashCode() : 0);
            result = 31 * result + (this.syncCompliance != null ? this.syncCompliance.hashCode() : 0);
            result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
            result = 31 * result + (this.waitForSuccessTimeoutSeconds != null ? this.waitForSuccessTimeoutSeconds.hashCode() : 0);
            return result;
        }
    }
}
