package software.amazon.awscdk.services.ssm;

/**
 * The <code>AWS::SSM::MaintenanceWindowTask</code> resource defines information about a task for an AWS Systems Manager maintenance window.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_RegisterTaskWithMaintenanceWindow.html">RegisterTaskWithMaintenanceWindow</a> in the <em>AWS Systems Manager API Reference</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssm.*;
 * Object parameters;
 * Object taskParameters;
 * CfnMaintenanceWindowTask cfnMaintenanceWindowTask = CfnMaintenanceWindowTask.Builder.create(this, "MyCfnMaintenanceWindowTask")
 *         .priority(123)
 *         .taskArn("taskArn")
 *         .taskType("taskType")
 *         .windowId("windowId")
 *         // the properties below are optional
 *         .cutoffBehavior("cutoffBehavior")
 *         .description("description")
 *         .loggingInfo(LoggingInfoProperty.builder()
 *                 .region("region")
 *                 .s3Bucket("s3Bucket")
 *                 // the properties below are optional
 *                 .s3Prefix("s3Prefix")
 *                 .build())
 *         .maxConcurrency("maxConcurrency")
 *         .maxErrors("maxErrors")
 *         .name("name")
 *         .serviceRoleArn("serviceRoleArn")
 *         .targets(List.of(TargetProperty.builder()
 *                 .key("key")
 *                 .values(List.of("values"))
 *                 .build()))
 *         .taskInvocationParameters(TaskInvocationParametersProperty.builder()
 *                 .maintenanceWindowAutomationParameters(MaintenanceWindowAutomationParametersProperty.builder()
 *                         .documentVersion("documentVersion")
 *                         .parameters(parameters)
 *                         .build())
 *                 .maintenanceWindowLambdaParameters(MaintenanceWindowLambdaParametersProperty.builder()
 *                         .clientContext("clientContext")
 *                         .payload("payload")
 *                         .qualifier("qualifier")
 *                         .build())
 *                 .maintenanceWindowRunCommandParameters(MaintenanceWindowRunCommandParametersProperty.builder()
 *                         .cloudWatchOutputConfig(CloudWatchOutputConfigProperty.builder()
 *                                 .cloudWatchLogGroupName("cloudWatchLogGroupName")
 *                                 .cloudWatchOutputEnabled(false)
 *                                 .build())
 *                         .comment("comment")
 *                         .documentHash("documentHash")
 *                         .documentHashType("documentHashType")
 *                         .documentVersion("documentVersion")
 *                         .notificationConfig(NotificationConfigProperty.builder()
 *                                 .notificationArn("notificationArn")
 *                                 // the properties below are optional
 *                                 .notificationEvents(List.of("notificationEvents"))
 *                                 .notificationType("notificationType")
 *                                 .build())
 *                         .outputS3BucketName("outputS3BucketName")
 *                         .outputS3KeyPrefix("outputS3KeyPrefix")
 *                         .parameters(parameters)
 *                         .serviceRoleArn("serviceRoleArn")
 *                         .timeoutSeconds(123)
 *                         .build())
 *                 .maintenanceWindowStepFunctionsParameters(MaintenanceWindowStepFunctionsParametersProperty.builder()
 *                         .input("input")
 *                         .name("name")
 *                         .build())
 *                 .build())
 *         .taskParameters(taskParameters)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:16.036Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask")
public class CfnMaintenanceWindowTask extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnMaintenanceWindowTask(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMaintenanceWindowTask(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMaintenanceWindowTask(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTaskProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The priority of the task in the maintenance window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getPriority() {
        return software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The priority of the task in the maintenance window.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPriority(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "priority", java.util.Objects.requireNonNull(value, "priority is required"));
    }

    /**
     * The resource that the task uses during execution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTaskArn() {
        return software.amazon.jsii.Kernel.get(this, "taskArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The resource that the task uses during execution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTaskArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "taskArn", java.util.Objects.requireNonNull(value, "taskArn is required"));
    }

    /**
     * The type of task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTaskType() {
        return software.amazon.jsii.Kernel.get(this, "taskType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTaskType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "taskType", java.util.Objects.requireNonNull(value, "taskType is required"));
    }

    /**
     * The ID of the maintenance window where the task is registered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getWindowId() {
        return software.amazon.jsii.Kernel.get(this, "windowId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the maintenance window where the task is registered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWindowId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "windowId", java.util.Objects.requireNonNull(value, "windowId is required"));
    }

    /**
     * The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCutoffBehavior() {
        return software.amazon.jsii.Kernel.get(this, "cutoffBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCutoffBehavior(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cutoffBehavior", value);
    }

    /**
     * A description of the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Information about an Amazon S3 bucket to write Run Command task-level logs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoggingInfo() {
        return software.amazon.jsii.Kernel.get(this, "loggingInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Information about an Amazon S3 bucket to write Run Command task-level logs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loggingInfo", value);
    }

    /**
     * Information about an Amazon S3 bucket to write Run Command task-level logs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.LoggingInfoProperty value) {
        software.amazon.jsii.Kernel.set(this, "loggingInfo", value);
    }

    /**
     * The maximum number of targets this task can be run for, in parallel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMaxConcurrency() {
        return software.amazon.jsii.Kernel.get(this, "maxConcurrency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The maximum number of targets this task can be run for, in parallel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxConcurrency(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "maxConcurrency", value);
    }

    /**
     * The maximum number of errors allowed before this task stops being scheduled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMaxErrors() {
        return software.amazon.jsii.Kernel.get(this, "maxErrors", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The maximum number of errors allowed before this task stops being scheduled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxErrors(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "maxErrors", value);
    }

    /**
     * The task name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The task name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM service role for AWS Systems Manager to assume when running a maintenance window task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServiceRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "serviceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM service role for AWS Systems Manager to assume when running a maintenance window task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceRoleArn", value);
    }

    /**
     * The targets, either instances or window target IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTargets() {
        return software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The targets, either instances or window target IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targets", value);
    }

    /**
     * The targets, either instances or window target IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.TargetProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.TargetProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "targets", value);
    }

    /**
     * The parameters to pass to the task when it runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTaskInvocationParameters() {
        return software.amazon.jsii.Kernel.get(this, "taskInvocationParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The parameters to pass to the task when it runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTaskInvocationParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "taskInvocationParameters", value);
    }

    /**
     * The parameters to pass to the task when it runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTaskInvocationParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.TaskInvocationParametersProperty value) {
        software.amazon.jsii.Kernel.set(this, "taskInvocationParameters", value);
    }

    /**
     * The parameters to pass to the task when it runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTaskParameters() {
        return software.amazon.jsii.Kernel.get(this, "taskParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The parameters to pass to the task when it runs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTaskParameters(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "taskParameters", value);
    }
    /**
     * Configuration options for sending command output to Amazon CloudWatch Logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * CloudWatchOutputConfigProperty cloudWatchOutputConfigProperty = CloudWatchOutputConfigProperty.builder()
     *         .cloudWatchLogGroupName("cloudWatchLogGroupName")
     *         .cloudWatchOutputEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-cloudwatchoutputconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-cloudwatchoutputconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.CloudWatchOutputConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchOutputConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchOutputConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the CloudWatch Logs log group where you want to send command output.
         * <p>
         * If you don't specify a group name, AWS Systems Manager automatically creates a log group for you. The log group uses the following naming format:
         * <p>
         * <code>aws/ssm/ *SystemsManagerDocumentName*</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-cloudwatchoutputconfig.html#cfn-ssm-maintenancewindowtask-cloudwatchoutputconfig-cloudwatchloggroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-cloudwatchoutputconfig.html#cfn-ssm-maintenancewindowtask-cloudwatchoutputconfig-cloudwatchloggroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogGroupName() {
            return null;
        }

        /**
         * Enables Systems Manager to send command output to CloudWatch Logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-cloudwatchoutputconfig.html#cfn-ssm-maintenancewindowtask-cloudwatchoutputconfig-cloudwatchoutputenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-cloudwatchoutputconfig.html#cfn-ssm-maintenancewindowtask-cloudwatchoutputconfig-cloudwatchoutputenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchOutputEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchOutputConfigProperty> {
            java.lang.String cloudWatchLogGroupName;
            java.lang.Object cloudWatchOutputEnabled;

            /**
             * Sets the value of {@link CloudWatchOutputConfigProperty#getCloudWatchLogGroupName}
             * @param cloudWatchLogGroupName The name of the CloudWatch Logs log group where you want to send command output.
             *                               If you don't specify a group name, AWS Systems Manager automatically creates a log group for you. The log group uses the following naming format:
             *                               <p>
             *                               <code>aws/ssm/ *SystemsManagerDocumentName*</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogGroupName(java.lang.String cloudWatchLogGroupName) {
                this.cloudWatchLogGroupName = cloudWatchLogGroupName;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchOutputConfigProperty#getCloudWatchOutputEnabled}
             * @param cloudWatchOutputEnabled Enables Systems Manager to send command output to CloudWatch Logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchOutputEnabled(java.lang.Boolean cloudWatchOutputEnabled) {
                this.cloudWatchOutputEnabled = cloudWatchOutputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchOutputConfigProperty#getCloudWatchOutputEnabled}
             * @param cloudWatchOutputEnabled Enables Systems Manager to send command output to CloudWatch Logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchOutputEnabled(software.amazon.awscdk.IResolvable cloudWatchOutputEnabled) {
                this.cloudWatchOutputEnabled = cloudWatchOutputEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchOutputConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchOutputConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchOutputConfigProperty {
            private final java.lang.String cloudWatchLogGroupName;
            private final java.lang.Object cloudWatchOutputEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogGroupName = software.amazon.jsii.Kernel.get(this, "cloudWatchLogGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cloudWatchOutputEnabled = software.amazon.jsii.Kernel.get(this, "cloudWatchOutputEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogGroupName = builder.cloudWatchLogGroupName;
                this.cloudWatchOutputEnabled = builder.cloudWatchOutputEnabled;
            }

            @Override
            public final java.lang.String getCloudWatchLogGroupName() {
                return this.cloudWatchLogGroupName;
            }

            @Override
            public final java.lang.Object getCloudWatchOutputEnabled() {
                return this.cloudWatchOutputEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLogGroupName() != null) {
                    data.set("cloudWatchLogGroupName", om.valueToTree(this.getCloudWatchLogGroupName()));
                }
                if (this.getCloudWatchOutputEnabled() != null) {
                    data.set("cloudWatchOutputEnabled", om.valueToTree(this.getCloudWatchOutputEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.CloudWatchOutputConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchOutputConfigProperty.Jsii$Proxy that = (CloudWatchOutputConfigProperty.Jsii$Proxy) o;

                if (this.cloudWatchLogGroupName != null ? !this.cloudWatchLogGroupName.equals(that.cloudWatchLogGroupName) : that.cloudWatchLogGroupName != null) return false;
                return this.cloudWatchOutputEnabled != null ? this.cloudWatchOutputEnabled.equals(that.cloudWatchOutputEnabled) : that.cloudWatchOutputEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogGroupName != null ? this.cloudWatchLogGroupName.hashCode() : 0;
                result = 31 * result + (this.cloudWatchOutputEnabled != null ? this.cloudWatchOutputEnabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>LoggingInfo</code> property type specifies information about the Amazon S3 bucket to write instance-level logs to.
     * <p>
     * <code>LoggingInfo</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html">AWS::SSM::MaintenanceWindowTask</a> resource.
     * <p>
     * <blockquote>
     * <p>
     * <code>LoggingInfo</code> has been deprecated. To specify an Amazon S3 bucket to contain logs, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html">AWS ::SSM::MaintenanceWindowTask MaintenanceWindowRunCommandParameters</a> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * LoggingInfoProperty loggingInfoProperty = LoggingInfoProperty.builder()
     *         .region("region")
     *         .s3Bucket("s3Bucket")
     *         // the properties below are optional
     *         .s3Prefix("s3Prefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-logginginfo.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-logginginfo.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.LoggingInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Region where the S3 bucket is located.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-logginginfo.html#cfn-ssm-maintenancewindowtask-logginginfo-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-logginginfo.html#cfn-ssm-maintenancewindowtask-logginginfo-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegion();

        /**
         * The name of an S3 bucket where execution logs are stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-logginginfo.html#cfn-ssm-maintenancewindowtask-logginginfo-s3bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-logginginfo.html#cfn-ssm-maintenancewindowtask-logginginfo-s3bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Bucket();

        /**
         * The Amazon S3 bucket subfolder.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-logginginfo.html#cfn-ssm-maintenancewindowtask-logginginfo-s3prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-logginginfo.html#cfn-ssm-maintenancewindowtask-logginginfo-s3prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3Prefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingInfoProperty> {
            java.lang.String region;
            java.lang.String s3Bucket;
            java.lang.String s3Prefix;

            /**
             * Sets the value of {@link LoggingInfoProperty#getRegion}
             * @param region The AWS Region where the S3 bucket is located. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link LoggingInfoProperty#getS3Bucket}
             * @param s3Bucket The name of an S3 bucket where execution logs are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(java.lang.String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of {@link LoggingInfoProperty#getS3Prefix}
             * @param s3Prefix The Amazon S3 bucket subfolder.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Prefix(java.lang.String s3Prefix) {
                this.s3Prefix = s3Prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingInfoProperty {
            private final java.lang.String region;
            private final java.lang.String s3Bucket;
            private final java.lang.String s3Prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Prefix = software.amazon.jsii.Kernel.get(this, "s3Prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
                this.s3Bucket = java.util.Objects.requireNonNull(builder.s3Bucket, "s3Bucket is required");
                this.s3Prefix = builder.s3Prefix;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.String getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            public final java.lang.String getS3Prefix() {
                return this.s3Prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("region", om.valueToTree(this.getRegion()));
                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                if (this.getS3Prefix() != null) {
                    data.set("s3Prefix", om.valueToTree(this.getS3Prefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.LoggingInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingInfoProperty.Jsii$Proxy that = (LoggingInfoProperty.Jsii$Proxy) o;

                if (!region.equals(that.region)) return false;
                if (!s3Bucket.equals(that.s3Bucket)) return false;
                return this.s3Prefix != null ? this.s3Prefix.equals(that.s3Prefix) : that.s3Prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.region.hashCode();
                result = 31 * result + (this.s3Bucket.hashCode());
                result = 31 * result + (this.s3Prefix != null ? this.s3Prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>MaintenanceWindowAutomationParameters</code> property type specifies the parameters for an <code>AUTOMATION</code> task type for a maintenance window task in AWS Systems Manager .
     * <p>
     * <code>MaintenanceWindowAutomationParameters</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html">TaskInvocationParameters</a> property type.
     * <p>
     * For information about available parameters in Automation runbooks, you can view the content of the runbook itself in the Systems Manager console. For information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-documents-reference-details.html#view-automation-json">View runbook content</a> in the <em>AWS Systems Manager User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * Object parameters;
     * MaintenanceWindowAutomationParametersProperty maintenanceWindowAutomationParametersProperty = MaintenanceWindowAutomationParametersProperty.builder()
     *         .documentVersion("documentVersion")
     *         .parameters(parameters)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowautomationparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowautomationparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.MaintenanceWindowAutomationParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(MaintenanceWindowAutomationParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaintenanceWindowAutomationParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The version of an Automation runbook to use during task execution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowautomationparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowautomationparameters-documentversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowautomationparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowautomationparameters-documentversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentVersion() {
            return null;
        }

        /**
         * The parameters for the <code>AUTOMATION</code> type task.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowautomationparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowautomationparameters-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowautomationparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowautomationparameters-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaintenanceWindowAutomationParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaintenanceWindowAutomationParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaintenanceWindowAutomationParametersProperty> {
            java.lang.String documentVersion;
            java.lang.Object parameters;

            /**
             * Sets the value of {@link MaintenanceWindowAutomationParametersProperty#getDocumentVersion}
             * @param documentVersion The version of an Automation runbook to use during task execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentVersion(java.lang.String documentVersion) {
                this.documentVersion = documentVersion;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowAutomationParametersProperty#getParameters}
             * @param parameters The parameters for the <code>AUTOMATION</code> type task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.lang.Object parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaintenanceWindowAutomationParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaintenanceWindowAutomationParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaintenanceWindowAutomationParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaintenanceWindowAutomationParametersProperty {
            private final java.lang.String documentVersion;
            private final java.lang.Object parameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.documentVersion = software.amazon.jsii.Kernel.get(this, "documentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.documentVersion = builder.documentVersion;
                this.parameters = builder.parameters;
            }

            @Override
            public final java.lang.String getDocumentVersion() {
                return this.documentVersion;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDocumentVersion() != null) {
                    data.set("documentVersion", om.valueToTree(this.getDocumentVersion()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.MaintenanceWindowAutomationParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaintenanceWindowAutomationParametersProperty.Jsii$Proxy that = (MaintenanceWindowAutomationParametersProperty.Jsii$Proxy) o;

                if (this.documentVersion != null ? !this.documentVersion.equals(that.documentVersion) : that.documentVersion != null) return false;
                return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.documentVersion != null ? this.documentVersion.hashCode() : 0;
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>MaintenanceWindowLambdaParameters</code> property type specifies the parameters for a <code>LAMBDA</code> task type for a maintenance window task in AWS Systems Manager .
     * <p>
     * <code>MaintenanceWindowLambdaParameters</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html">TaskInvocationParameters</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * MaintenanceWindowLambdaParametersProperty maintenanceWindowLambdaParametersProperty = MaintenanceWindowLambdaParametersProperty.builder()
     *         .clientContext("clientContext")
     *         .payload("payload")
     *         .qualifier("qualifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowlambdaparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowlambdaparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.MaintenanceWindowLambdaParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(MaintenanceWindowLambdaParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaintenanceWindowLambdaParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Client-specific information to pass to the AWS Lambda function that you're invoking.
         * <p>
         * You can then use the <code>context</code> variable to process the client information in your AWS Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowlambdaparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowlambdaparameters-clientcontext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowlambdaparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowlambdaparameters-clientcontext</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientContext() {
            return null;
        }

        /**
         * JSON to provide to your AWS Lambda function as input.
         * <p>
         * <blockquote>
         * <p>
         * Although <code>Type</code> is listed as "String" for this property, the payload content must be formatted as a Base64-encoded binary data object.
         * <p>
         * </blockquote>
         * <p>
         * <em>Length Constraint:</em> 4096
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowlambdaparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowlambdaparameters-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowlambdaparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowlambdaparameters-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPayload() {
            return null;
        }

        /**
         * An AWS Lambda function version or alias name.
         * <p>
         * If you specify a function version, the action uses the qualified function Amazon Resource Name (ARN) to invoke a specific Lambda function. If you specify an alias name, the action uses the alias ARN to invoke the Lambda function version that the alias points to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowlambdaparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowlambdaparameters-qualifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowlambdaparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowlambdaparameters-qualifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQualifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaintenanceWindowLambdaParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaintenanceWindowLambdaParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaintenanceWindowLambdaParametersProperty> {
            java.lang.String clientContext;
            java.lang.String payload;
            java.lang.String qualifier;

            /**
             * Sets the value of {@link MaintenanceWindowLambdaParametersProperty#getClientContext}
             * @param clientContext Client-specific information to pass to the AWS Lambda function that you're invoking.
             *                      You can then use the <code>context</code> variable to process the client information in your AWS Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientContext(java.lang.String clientContext) {
                this.clientContext = clientContext;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowLambdaParametersProperty#getPayload}
             * @param payload JSON to provide to your AWS Lambda function as input.
             *                <blockquote>
             *                <p>
             *                Although <code>Type</code> is listed as "String" for this property, the payload content must be formatted as a Base64-encoded binary data object.
             *                <p>
             *                </blockquote>
             *                <p>
             *                <em>Length Constraint:</em> 4096
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(java.lang.String payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowLambdaParametersProperty#getQualifier}
             * @param qualifier An AWS Lambda function version or alias name.
             *                  If you specify a function version, the action uses the qualified function Amazon Resource Name (ARN) to invoke a specific Lambda function. If you specify an alias name, the action uses the alias ARN to invoke the Lambda function version that the alias points to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder qualifier(java.lang.String qualifier) {
                this.qualifier = qualifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaintenanceWindowLambdaParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaintenanceWindowLambdaParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaintenanceWindowLambdaParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaintenanceWindowLambdaParametersProperty {
            private final java.lang.String clientContext;
            private final java.lang.String payload;
            private final java.lang.String qualifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientContext = software.amazon.jsii.Kernel.get(this, "clientContext", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.qualifier = software.amazon.jsii.Kernel.get(this, "qualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientContext = builder.clientContext;
                this.payload = builder.payload;
                this.qualifier = builder.qualifier;
            }

            @Override
            public final java.lang.String getClientContext() {
                return this.clientContext;
            }

            @Override
            public final java.lang.String getPayload() {
                return this.payload;
            }

            @Override
            public final java.lang.String getQualifier() {
                return this.qualifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClientContext() != null) {
                    data.set("clientContext", om.valueToTree(this.getClientContext()));
                }
                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }
                if (this.getQualifier() != null) {
                    data.set("qualifier", om.valueToTree(this.getQualifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.MaintenanceWindowLambdaParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaintenanceWindowLambdaParametersProperty.Jsii$Proxy that = (MaintenanceWindowLambdaParametersProperty.Jsii$Proxy) o;

                if (this.clientContext != null ? !this.clientContext.equals(that.clientContext) : that.clientContext != null) return false;
                if (this.payload != null ? !this.payload.equals(that.payload) : that.payload != null) return false;
                return this.qualifier != null ? this.qualifier.equals(that.qualifier) : that.qualifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientContext != null ? this.clientContext.hashCode() : 0;
                result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
                result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>MaintenanceWindowRunCommandParameters</code> property type specifies the parameters for a <code>RUN_COMMAND</code> task type for a maintenance window task in AWS Systems Manager .
     * <p>
     * This means that these parameters are the same as those for the <code>SendCommand</code> API call. For more information about <code>SendCommand</code> parameters, see <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_SendCommand.html">SendCommand</a> in the <em>AWS Systems Manager API Reference</em> .
     * <p>
     * For information about available parameters in SSM Command documents, you can view the content of the document itself in the Systems Manager console. For information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/viewing-ssm-document-content.html">Viewing SSM command document content</a> in the <em>AWS Systems Manager User Guide</em> .
     * <p>
     * <code>MaintenanceWindowRunCommandParameters</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html">TaskInvocationParameters</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * Object parameters;
     * MaintenanceWindowRunCommandParametersProperty maintenanceWindowRunCommandParametersProperty = MaintenanceWindowRunCommandParametersProperty.builder()
     *         .cloudWatchOutputConfig(CloudWatchOutputConfigProperty.builder()
     *                 .cloudWatchLogGroupName("cloudWatchLogGroupName")
     *                 .cloudWatchOutputEnabled(false)
     *                 .build())
     *         .comment("comment")
     *         .documentHash("documentHash")
     *         .documentHashType("documentHashType")
     *         .documentVersion("documentVersion")
     *         .notificationConfig(NotificationConfigProperty.builder()
     *                 .notificationArn("notificationArn")
     *                 // the properties below are optional
     *                 .notificationEvents(List.of("notificationEvents"))
     *                 .notificationType("notificationType")
     *                 .build())
     *         .outputS3BucketName("outputS3BucketName")
     *         .outputS3KeyPrefix("outputS3KeyPrefix")
     *         .parameters(parameters)
     *         .serviceRoleArn("serviceRoleArn")
     *         .timeoutSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(MaintenanceWindowRunCommandParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaintenanceWindowRunCommandParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration options for sending command output to Amazon CloudWatch Logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-cloudwatchoutputconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-cloudwatchoutputconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchOutputConfig() {
            return null;
        }

        /**
         * Information about the command or commands to run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-comment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-comment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
            return null;
        }

        /**
         * The SHA-256 or SHA-1 hash created by the system when the document was created.
         * <p>
         * SHA-1 hashes have been deprecated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-documenthash">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-documenthash</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentHash() {
            return null;
        }

        /**
         * The SHA-256 or SHA-1 hash type.
         * <p>
         * SHA-1 hashes are deprecated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-documenthashtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-documenthashtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentHashType() {
            return null;
        }

        /**
         * The AWS Systems Manager document (SSM document) version to use in the request.
         * <p>
         * You can specify <code>$DEFAULT</code> , <code>$LATEST</code> , or a specific version number. If you run commands by using the AWS CLI, then you must escape the first two options by using a backslash. If you specify a version number, then you don't need to use the backslash. For example:
         * <p>
         * <code>--document-version "\$DEFAULT"</code>
         * <p>
         * <code>--document-version "\$LATEST"</code>
         * <p>
         * <code>--document-version "3"</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-documentversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-documentversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentVersion() {
            return null;
        }

        /**
         * Configurations for sending notifications about command status changes on a per-managed node basis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-notificationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-notificationconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNotificationConfig() {
            return null;
        }

        /**
         * The name of the Amazon Simple Storage Service (Amazon S3) bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-outputs3bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-outputs3bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputS3BucketName() {
            return null;
        }

        /**
         * The S3 bucket subfolder.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-outputs3keyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-outputs3keyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputS3KeyPrefix() {
            return null;
        }

        /**
         * The parameters for the <code>RUN_COMMAND</code> task execution.
         * <p>
         * The supported parameters are the same as those for the <code>SendCommand</code> API call. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_SendCommand.html">SendCommand</a> in the <em>AWS Systems Manager API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM service role for AWS Systems Manager to assume when running a maintenance window task.
         * <p>
         * If you do not specify a service role ARN, Systems Manager uses a service-linked role in your account. If no appropriate service-linked role for Systems Manager exists in your account, it is created when you run <code>RegisterTaskWithMaintenanceWindow</code> .
         * <p>
         * However, for an improved security posture, we strongly recommend creating a custom policy and custom service role for running your maintenance window tasks. The policy can be crafted to provide only the permissions needed for your particular maintenance window tasks. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html">Setting up Maintenance Windows</a> in the in the <em>AWS Systems Manager User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-servicerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-servicerolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceRoleArn() {
            return null;
        }

        /**
         * If this time is reached and the command hasn't already started running, it doesn't run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-timeoutseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowruncommandparameters-timeoutseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaintenanceWindowRunCommandParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaintenanceWindowRunCommandParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaintenanceWindowRunCommandParametersProperty> {
            java.lang.Object cloudWatchOutputConfig;
            java.lang.String comment;
            java.lang.String documentHash;
            java.lang.String documentHashType;
            java.lang.String documentVersion;
            java.lang.Object notificationConfig;
            java.lang.String outputS3BucketName;
            java.lang.String outputS3KeyPrefix;
            java.lang.Object parameters;
            java.lang.String serviceRoleArn;
            java.lang.Number timeoutSeconds;

            /**
             * Sets the value of {@link MaintenanceWindowRunCommandParametersProperty#getCloudWatchOutputConfig}
             * @param cloudWatchOutputConfig Configuration options for sending command output to Amazon CloudWatch Logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchOutputConfig(software.amazon.awscdk.IResolvable cloudWatchOutputConfig) {
                this.cloudWatchOutputConfig = cloudWatchOutputConfig;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowRunCommandParametersProperty#getCloudWatchOutputConfig}
             * @param cloudWatchOutputConfig Configuration options for sending command output to Amazon CloudWatch Logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchOutputConfig(software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.CloudWatchOutputConfigProperty cloudWatchOutputConfig) {
                this.cloudWatchOutputConfig = cloudWatchOutputConfig;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowRunCommandParametersProperty#getComment}
             * @param comment Information about the command or commands to run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comment(java.lang.String comment) {
                this.comment = comment;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowRunCommandParametersProperty#getDocumentHash}
             * @param documentHash The SHA-256 or SHA-1 hash created by the system when the document was created.
             *                     SHA-1 hashes have been deprecated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentHash(java.lang.String documentHash) {
                this.documentHash = documentHash;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowRunCommandParametersProperty#getDocumentHashType}
             * @param documentHashType The SHA-256 or SHA-1 hash type.
             *                         SHA-1 hashes are deprecated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentHashType(java.lang.String documentHashType) {
                this.documentHashType = documentHashType;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowRunCommandParametersProperty#getDocumentVersion}
             * @param documentVersion The AWS Systems Manager document (SSM document) version to use in the request.
             *                        You can specify <code>$DEFAULT</code> , <code>$LATEST</code> , or a specific version number. If you run commands by using the AWS CLI, then you must escape the first two options by using a backslash. If you specify a version number, then you don't need to use the backslash. For example:
             *                        <p>
             *                        <code>--document-version "\$DEFAULT"</code>
             *                        <p>
             *                        <code>--document-version "\$LATEST"</code>
             *                        <p>
             *                        <code>--document-version "3"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentVersion(java.lang.String documentVersion) {
                this.documentVersion = documentVersion;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowRunCommandParametersProperty#getNotificationConfig}
             * @param notificationConfig Configurations for sending notifications about command status changes on a per-managed node basis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notificationConfig(software.amazon.awscdk.IResolvable notificationConfig) {
                this.notificationConfig = notificationConfig;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowRunCommandParametersProperty#getNotificationConfig}
             * @param notificationConfig Configurations for sending notifications about command status changes on a per-managed node basis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notificationConfig(software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.NotificationConfigProperty notificationConfig) {
                this.notificationConfig = notificationConfig;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowRunCommandParametersProperty#getOutputS3BucketName}
             * @param outputS3BucketName The name of the Amazon Simple Storage Service (Amazon S3) bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputS3BucketName(java.lang.String outputS3BucketName) {
                this.outputS3BucketName = outputS3BucketName;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowRunCommandParametersProperty#getOutputS3KeyPrefix}
             * @param outputS3KeyPrefix The S3 bucket subfolder.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputS3KeyPrefix(java.lang.String outputS3KeyPrefix) {
                this.outputS3KeyPrefix = outputS3KeyPrefix;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowRunCommandParametersProperty#getParameters}
             * @param parameters The parameters for the <code>RUN_COMMAND</code> task execution.
             *                   The supported parameters are the same as those for the <code>SendCommand</code> API call. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_SendCommand.html">SendCommand</a> in the <em>AWS Systems Manager API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.lang.Object parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowRunCommandParametersProperty#getServiceRoleArn}
             * @param serviceRoleArn The Amazon Resource Name (ARN) of the IAM service role for AWS Systems Manager to assume when running a maintenance window task.
             *                       If you do not specify a service role ARN, Systems Manager uses a service-linked role in your account. If no appropriate service-linked role for Systems Manager exists in your account, it is created when you run <code>RegisterTaskWithMaintenanceWindow</code> .
             *                       <p>
             *                       However, for an improved security posture, we strongly recommend creating a custom policy and custom service role for running your maintenance window tasks. The policy can be crafted to provide only the permissions needed for your particular maintenance window tasks. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html">Setting up Maintenance Windows</a> in the in the <em>AWS Systems Manager User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceRoleArn(java.lang.String serviceRoleArn) {
                this.serviceRoleArn = serviceRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowRunCommandParametersProperty#getTimeoutSeconds}
             * @param timeoutSeconds If this time is reached and the command hasn't already started running, it doesn't run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutSeconds(java.lang.Number timeoutSeconds) {
                this.timeoutSeconds = timeoutSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaintenanceWindowRunCommandParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaintenanceWindowRunCommandParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaintenanceWindowRunCommandParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaintenanceWindowRunCommandParametersProperty {
            private final java.lang.Object cloudWatchOutputConfig;
            private final java.lang.String comment;
            private final java.lang.String documentHash;
            private final java.lang.String documentHashType;
            private final java.lang.String documentVersion;
            private final java.lang.Object notificationConfig;
            private final java.lang.String outputS3BucketName;
            private final java.lang.String outputS3KeyPrefix;
            private final java.lang.Object parameters;
            private final java.lang.String serviceRoleArn;
            private final java.lang.Number timeoutSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchOutputConfig = software.amazon.jsii.Kernel.get(this, "cloudWatchOutputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentHash = software.amazon.jsii.Kernel.get(this, "documentHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentHashType = software.amazon.jsii.Kernel.get(this, "documentHashType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentVersion = software.amazon.jsii.Kernel.get(this, "documentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.notificationConfig = software.amazon.jsii.Kernel.get(this, "notificationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputS3BucketName = software.amazon.jsii.Kernel.get(this, "outputS3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputS3KeyPrefix = software.amazon.jsii.Kernel.get(this, "outputS3KeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceRoleArn = software.amazon.jsii.Kernel.get(this, "serviceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeoutSeconds = software.amazon.jsii.Kernel.get(this, "timeoutSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchOutputConfig = builder.cloudWatchOutputConfig;
                this.comment = builder.comment;
                this.documentHash = builder.documentHash;
                this.documentHashType = builder.documentHashType;
                this.documentVersion = builder.documentVersion;
                this.notificationConfig = builder.notificationConfig;
                this.outputS3BucketName = builder.outputS3BucketName;
                this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
                this.parameters = builder.parameters;
                this.serviceRoleArn = builder.serviceRoleArn;
                this.timeoutSeconds = builder.timeoutSeconds;
            }

            @Override
            public final java.lang.Object getCloudWatchOutputConfig() {
                return this.cloudWatchOutputConfig;
            }

            @Override
            public final java.lang.String getComment() {
                return this.comment;
            }

            @Override
            public final java.lang.String getDocumentHash() {
                return this.documentHash;
            }

            @Override
            public final java.lang.String getDocumentHashType() {
                return this.documentHashType;
            }

            @Override
            public final java.lang.String getDocumentVersion() {
                return this.documentVersion;
            }

            @Override
            public final java.lang.Object getNotificationConfig() {
                return this.notificationConfig;
            }

            @Override
            public final java.lang.String getOutputS3BucketName() {
                return this.outputS3BucketName;
            }

            @Override
            public final java.lang.String getOutputS3KeyPrefix() {
                return this.outputS3KeyPrefix;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.lang.String getServiceRoleArn() {
                return this.serviceRoleArn;
            }

            @Override
            public final java.lang.Number getTimeoutSeconds() {
                return this.timeoutSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchOutputConfig() != null) {
                    data.set("cloudWatchOutputConfig", om.valueToTree(this.getCloudWatchOutputConfig()));
                }
                if (this.getComment() != null) {
                    data.set("comment", om.valueToTree(this.getComment()));
                }
                if (this.getDocumentHash() != null) {
                    data.set("documentHash", om.valueToTree(this.getDocumentHash()));
                }
                if (this.getDocumentHashType() != null) {
                    data.set("documentHashType", om.valueToTree(this.getDocumentHashType()));
                }
                if (this.getDocumentVersion() != null) {
                    data.set("documentVersion", om.valueToTree(this.getDocumentVersion()));
                }
                if (this.getNotificationConfig() != null) {
                    data.set("notificationConfig", om.valueToTree(this.getNotificationConfig()));
                }
                if (this.getOutputS3BucketName() != null) {
                    data.set("outputS3BucketName", om.valueToTree(this.getOutputS3BucketName()));
                }
                if (this.getOutputS3KeyPrefix() != null) {
                    data.set("outputS3KeyPrefix", om.valueToTree(this.getOutputS3KeyPrefix()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }
                if (this.getServiceRoleArn() != null) {
                    data.set("serviceRoleArn", om.valueToTree(this.getServiceRoleArn()));
                }
                if (this.getTimeoutSeconds() != null) {
                    data.set("timeoutSeconds", om.valueToTree(this.getTimeoutSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaintenanceWindowRunCommandParametersProperty.Jsii$Proxy that = (MaintenanceWindowRunCommandParametersProperty.Jsii$Proxy) o;

                if (this.cloudWatchOutputConfig != null ? !this.cloudWatchOutputConfig.equals(that.cloudWatchOutputConfig) : that.cloudWatchOutputConfig != null) return false;
                if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
                if (this.documentHash != null ? !this.documentHash.equals(that.documentHash) : that.documentHash != null) return false;
                if (this.documentHashType != null ? !this.documentHashType.equals(that.documentHashType) : that.documentHashType != null) return false;
                if (this.documentVersion != null ? !this.documentVersion.equals(that.documentVersion) : that.documentVersion != null) return false;
                if (this.notificationConfig != null ? !this.notificationConfig.equals(that.notificationConfig) : that.notificationConfig != null) return false;
                if (this.outputS3BucketName != null ? !this.outputS3BucketName.equals(that.outputS3BucketName) : that.outputS3BucketName != null) return false;
                if (this.outputS3KeyPrefix != null ? !this.outputS3KeyPrefix.equals(that.outputS3KeyPrefix) : that.outputS3KeyPrefix != null) return false;
                if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
                if (this.serviceRoleArn != null ? !this.serviceRoleArn.equals(that.serviceRoleArn) : that.serviceRoleArn != null) return false;
                return this.timeoutSeconds != null ? this.timeoutSeconds.equals(that.timeoutSeconds) : that.timeoutSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchOutputConfig != null ? this.cloudWatchOutputConfig.hashCode() : 0;
                result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
                result = 31 * result + (this.documentHash != null ? this.documentHash.hashCode() : 0);
                result = 31 * result + (this.documentHashType != null ? this.documentHashType.hashCode() : 0);
                result = 31 * result + (this.documentVersion != null ? this.documentVersion.hashCode() : 0);
                result = 31 * result + (this.notificationConfig != null ? this.notificationConfig.hashCode() : 0);
                result = 31 * result + (this.outputS3BucketName != null ? this.outputS3BucketName.hashCode() : 0);
                result = 31 * result + (this.outputS3KeyPrefix != null ? this.outputS3KeyPrefix.hashCode() : 0);
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                result = 31 * result + (this.serviceRoleArn != null ? this.serviceRoleArn.hashCode() : 0);
                result = 31 * result + (this.timeoutSeconds != null ? this.timeoutSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>MaintenanceWindowStepFunctionsParameters</code> property type specifies the parameters for the execution of a <code>STEP_FUNCTIONS</code> task in a Systems Manager maintenance window.
     * <p>
     * <code>MaintenanceWindowStepFunctionsParameters</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html">TaskInvocationParameters</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * MaintenanceWindowStepFunctionsParametersProperty maintenanceWindowStepFunctionsParametersProperty = MaintenanceWindowStepFunctionsParametersProperty.builder()
     *         .input("input")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.MaintenanceWindowStepFunctionsParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(MaintenanceWindowStepFunctionsParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaintenanceWindowStepFunctionsParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The inputs for the <code>STEP_FUNCTIONS</code> task.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters-input">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters-input</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInput() {
            return null;
        }

        /**
         * The name of the <code>STEP_FUNCTIONS</code> task.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters.html#cfn-ssm-maintenancewindowtask-maintenancewindowstepfunctionsparameters-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaintenanceWindowStepFunctionsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaintenanceWindowStepFunctionsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaintenanceWindowStepFunctionsParametersProperty> {
            java.lang.String input;
            java.lang.String name;

            /**
             * Sets the value of {@link MaintenanceWindowStepFunctionsParametersProperty#getInput}
             * @param input The inputs for the <code>STEP_FUNCTIONS</code> task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(java.lang.String input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowStepFunctionsParametersProperty#getName}
             * @param name The name of the <code>STEP_FUNCTIONS</code> task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaintenanceWindowStepFunctionsParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaintenanceWindowStepFunctionsParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaintenanceWindowStepFunctionsParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaintenanceWindowStepFunctionsParametersProperty {
            private final java.lang.String input;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.input = builder.input;
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getInput() {
                return this.input;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInput() != null) {
                    data.set("input", om.valueToTree(this.getInput()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.MaintenanceWindowStepFunctionsParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaintenanceWindowStepFunctionsParametersProperty.Jsii$Proxy that = (MaintenanceWindowStepFunctionsParametersProperty.Jsii$Proxy) o;

                if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.input != null ? this.input.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>NotificationConfig</code> property type specifies configurations for sending notifications for a maintenance window task in AWS Systems Manager .
     * <p>
     * <code>NotificationConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html">MaintenanceWindowRunCommandParameters</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * NotificationConfigProperty notificationConfigProperty = NotificationConfigProperty.builder()
     *         .notificationArn("notificationArn")
     *         // the properties below are optional
     *         .notificationEvents(List.of("notificationEvents"))
     *         .notificationType("notificationType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-notificationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-notificationconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.NotificationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(NotificationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An Amazon Resource Name (ARN) for an Amazon Simple Notification Service (Amazon SNS) topic.
         * <p>
         * Run Command pushes notifications about command status changes to this topic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-notificationconfig.html#cfn-ssm-maintenancewindowtask-notificationconfig-notificationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-notificationconfig.html#cfn-ssm-maintenancewindowtask-notificationconfig-notificationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNotificationArn();

        /**
         * The different events that you can receive notifications for.
         * <p>
         * These events include the following: <code>All</code> (events), <code>InProgress</code> , <code>Success</code> , <code>TimedOut</code> , <code>Cancelled</code> , <code>Failed</code> . To learn more about these events, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html">Configuring Amazon SNS Notifications for AWS Systems Manager</a> in the <em>AWS Systems Manager User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-notificationconfig.html#cfn-ssm-maintenancewindowtask-notificationconfig-notificationevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-notificationconfig.html#cfn-ssm-maintenancewindowtask-notificationconfig-notificationevents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotificationEvents() {
            return null;
        }

        /**
         * The notification type.
         * <p>
         * <ul>
         * <li><code>Command</code> : Receive notification when the status of a command changes.</li>
         * <li><code>Invocation</code> : For commands sent to multiple instances, receive notification on a per-instance basis when the status of a command changes.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-notificationconfig.html#cfn-ssm-maintenancewindowtask-notificationconfig-notificationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-notificationconfig.html#cfn-ssm-maintenancewindowtask-notificationconfig-notificationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNotificationType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NotificationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotificationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotificationConfigProperty> {
            java.lang.String notificationArn;
            java.util.List<java.lang.String> notificationEvents;
            java.lang.String notificationType;

            /**
             * Sets the value of {@link NotificationConfigProperty#getNotificationArn}
             * @param notificationArn An Amazon Resource Name (ARN) for an Amazon Simple Notification Service (Amazon SNS) topic. This parameter is required.
             *                        Run Command pushes notifications about command status changes to this topic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notificationArn(java.lang.String notificationArn) {
                this.notificationArn = notificationArn;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigProperty#getNotificationEvents}
             * @param notificationEvents The different events that you can receive notifications for.
             *                           These events include the following: <code>All</code> (events), <code>InProgress</code> , <code>Success</code> , <code>TimedOut</code> , <code>Cancelled</code> , <code>Failed</code> . To learn more about these events, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html">Configuring Amazon SNS Notifications for AWS Systems Manager</a> in the <em>AWS Systems Manager User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notificationEvents(java.util.List<java.lang.String> notificationEvents) {
                this.notificationEvents = notificationEvents;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigProperty#getNotificationType}
             * @param notificationType The notification type.
             *                         <ul>
             *                         <li><code>Command</code> : Receive notification when the status of a command changes.</li>
             *                         <li><code>Invocation</code> : For commands sent to multiple instances, receive notification on a per-instance basis when the status of a command changes.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notificationType(java.lang.String notificationType) {
                this.notificationType = notificationType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotificationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotificationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationConfigProperty {
            private final java.lang.String notificationArn;
            private final java.util.List<java.lang.String> notificationEvents;
            private final java.lang.String notificationType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.notificationArn = software.amazon.jsii.Kernel.get(this, "notificationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.notificationEvents = software.amazon.jsii.Kernel.get(this, "notificationEvents", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.notificationType = software.amazon.jsii.Kernel.get(this, "notificationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.notificationArn = java.util.Objects.requireNonNull(builder.notificationArn, "notificationArn is required");
                this.notificationEvents = builder.notificationEvents;
                this.notificationType = builder.notificationType;
            }

            @Override
            public final java.lang.String getNotificationArn() {
                return this.notificationArn;
            }

            @Override
            public final java.util.List<java.lang.String> getNotificationEvents() {
                return this.notificationEvents;
            }

            @Override
            public final java.lang.String getNotificationType() {
                return this.notificationType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("notificationArn", om.valueToTree(this.getNotificationArn()));
                if (this.getNotificationEvents() != null) {
                    data.set("notificationEvents", om.valueToTree(this.getNotificationEvents()));
                }
                if (this.getNotificationType() != null) {
                    data.set("notificationType", om.valueToTree(this.getNotificationType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.NotificationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationConfigProperty.Jsii$Proxy that = (NotificationConfigProperty.Jsii$Proxy) o;

                if (!notificationArn.equals(that.notificationArn)) return false;
                if (this.notificationEvents != null ? !this.notificationEvents.equals(that.notificationEvents) : that.notificationEvents != null) return false;
                return this.notificationType != null ? this.notificationType.equals(that.notificationType) : that.notificationType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.notificationArn.hashCode();
                result = 31 * result + (this.notificationEvents != null ? this.notificationEvents.hashCode() : 0);
                result = 31 * result + (this.notificationType != null ? this.notificationType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>Target</code> property type specifies targets (either instances or window target IDs).
     * <p>
     * You specify instances by using <code>Key=InstanceIds,Values=&lt; *instanceid1* &gt;,&lt; *instanceid2* &gt;</code> . You specify window target IDs using <code>Key=WindowTargetIds,Values=&lt; *window-target-id-1* &gt;,&lt; *window-target-id-2* &gt;</code> for a maintenance window task in AWS Systems Manager .
     * <p>
     * <code>Target</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html">AWS::SSM::MaintenanceWindowTask</a> property type.
     * <p>
     * <blockquote>
     * <p>
     * To use <code>resource-groups:Name</code> as the key for a maintenance window target, specify the resource group as a <code>AWS::SSM::MaintenanceWindowTarget</code> type, and use the <code>Ref</code> function to specify the target for <code>AWS::SSM::MaintenanceWindowTask</code> . For an example, see <em>Create a Run Command task that targets instances using a resource group name</em> in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#aws-resource-ssm-maintenancewindowtask--examples">AWS::SSM::MaintenanceWindowTask Examples</a> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * TargetProperty targetProperty = TargetProperty.builder()
     *         .key("key")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-target.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-target.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.TargetProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * User-defined criteria for sending commands that target instances that meet the criteria.
         * <p>
         * <code>Key</code> can be <code>InstanceIds</code> or <code>WindowTargetIds</code> . For more information about how to target instances within a maintenance window task, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/register-tasks-options.html">About 'register-task-with-maintenance-window' Options and Values</a> in the <em>AWS Systems Manager User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-target.html#cfn-ssm-maintenancewindowtask-target-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-target.html#cfn-ssm-maintenancewindowtask-target-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * User-defined criteria that maps to <code>Key</code> .
         * <p>
         * For example, if you specify <code>InstanceIds</code> , you can specify <code>i-1234567890abcdef0,i-9876543210abcdef0</code> to run a command on two EC2 instances. For more information about how to target instances within a maintenance window task, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/register-tasks-options.html">About 'register-task-with-maintenance-window' Options and Values</a> in the <em>AWS Systems Manager User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-target.html#cfn-ssm-maintenancewindowtask-target-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-target.html#cfn-ssm-maintenancewindowtask-target-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetProperty> {
            java.lang.String key;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link TargetProperty#getKey}
             * @param key User-defined criteria for sending commands that target instances that meet the criteria. This parameter is required.
             *            <code>Key</code> can be <code>InstanceIds</code> or <code>WindowTargetIds</code> . For more information about how to target instances within a maintenance window task, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/register-tasks-options.html">About 'register-task-with-maintenance-window' Options and Values</a> in the <em>AWS Systems Manager User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TargetProperty#getValues}
             * @param values User-defined criteria that maps to <code>Key</code> . This parameter is required.
             *               For example, if you specify <code>InstanceIds</code> , you can specify <code>i-1234567890abcdef0,i-9876543210abcdef0</code> to run a command on two EC2 instances. For more information about how to target instances within a maintenance window task, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/register-tasks-options.html">About 'register-task-with-maintenance-window' Options and Values</a> in the <em>AWS Systems Manager User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetProperty {
            private final java.lang.String key;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.TargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetProperty.Jsii$Proxy that = (TargetProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * The <code>TaskInvocationParameters</code> property type specifies the task execution parameters for a maintenance window task in AWS Systems Manager .
     * <p>
     * <code>TaskInvocationParameters</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html">AWS::SSM::MaintenanceWindowTask</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssm.*;
     * Object parameters;
     * TaskInvocationParametersProperty taskInvocationParametersProperty = TaskInvocationParametersProperty.builder()
     *         .maintenanceWindowAutomationParameters(MaintenanceWindowAutomationParametersProperty.builder()
     *                 .documentVersion("documentVersion")
     *                 .parameters(parameters)
     *                 .build())
     *         .maintenanceWindowLambdaParameters(MaintenanceWindowLambdaParametersProperty.builder()
     *                 .clientContext("clientContext")
     *                 .payload("payload")
     *                 .qualifier("qualifier")
     *                 .build())
     *         .maintenanceWindowRunCommandParameters(MaintenanceWindowRunCommandParametersProperty.builder()
     *                 .cloudWatchOutputConfig(CloudWatchOutputConfigProperty.builder()
     *                         .cloudWatchLogGroupName("cloudWatchLogGroupName")
     *                         .cloudWatchOutputEnabled(false)
     *                         .build())
     *                 .comment("comment")
     *                 .documentHash("documentHash")
     *                 .documentHashType("documentHashType")
     *                 .documentVersion("documentVersion")
     *                 .notificationConfig(NotificationConfigProperty.builder()
     *                         .notificationArn("notificationArn")
     *                         // the properties below are optional
     *                         .notificationEvents(List.of("notificationEvents"))
     *                         .notificationType("notificationType")
     *                         .build())
     *                 .outputS3BucketName("outputS3BucketName")
     *                 .outputS3KeyPrefix("outputS3KeyPrefix")
     *                 .parameters(parameters)
     *                 .serviceRoleArn("serviceRoleArn")
     *                 .timeoutSeconds(123)
     *                 .build())
     *         .maintenanceWindowStepFunctionsParameters(MaintenanceWindowStepFunctionsParametersProperty.builder()
     *                 .input("input")
     *                 .name("name")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.TaskInvocationParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(TaskInvocationParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TaskInvocationParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parameters for an <code>AUTOMATION</code> task type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters-maintenancewindowautomationparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters-maintenancewindowautomationparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceWindowAutomationParameters() {
            return null;
        }

        /**
         * The parameters for a <code>LAMBDA</code> task type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters-maintenancewindowlambdaparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters-maintenancewindowlambdaparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceWindowLambdaParameters() {
            return null;
        }

        /**
         * The parameters for a <code>RUN_COMMAND</code> task type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters-maintenancewindowruncommandparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters-maintenancewindowruncommandparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceWindowRunCommandParameters() {
            return null;
        }

        /**
         * The parameters for a <code>STEP_FUNCTIONS</code> task type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters-maintenancewindowstepfunctionsparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-taskinvocationparameters.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters-maintenancewindowstepfunctionsparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceWindowStepFunctionsParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TaskInvocationParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TaskInvocationParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TaskInvocationParametersProperty> {
            java.lang.Object maintenanceWindowAutomationParameters;
            java.lang.Object maintenanceWindowLambdaParameters;
            java.lang.Object maintenanceWindowRunCommandParameters;
            java.lang.Object maintenanceWindowStepFunctionsParameters;

            /**
             * Sets the value of {@link TaskInvocationParametersProperty#getMaintenanceWindowAutomationParameters}
             * @param maintenanceWindowAutomationParameters The parameters for an <code>AUTOMATION</code> task type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceWindowAutomationParameters(software.amazon.awscdk.IResolvable maintenanceWindowAutomationParameters) {
                this.maintenanceWindowAutomationParameters = maintenanceWindowAutomationParameters;
                return this;
            }

            /**
             * Sets the value of {@link TaskInvocationParametersProperty#getMaintenanceWindowAutomationParameters}
             * @param maintenanceWindowAutomationParameters The parameters for an <code>AUTOMATION</code> task type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceWindowAutomationParameters(software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.MaintenanceWindowAutomationParametersProperty maintenanceWindowAutomationParameters) {
                this.maintenanceWindowAutomationParameters = maintenanceWindowAutomationParameters;
                return this;
            }

            /**
             * Sets the value of {@link TaskInvocationParametersProperty#getMaintenanceWindowLambdaParameters}
             * @param maintenanceWindowLambdaParameters The parameters for a <code>LAMBDA</code> task type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceWindowLambdaParameters(software.amazon.awscdk.IResolvable maintenanceWindowLambdaParameters) {
                this.maintenanceWindowLambdaParameters = maintenanceWindowLambdaParameters;
                return this;
            }

            /**
             * Sets the value of {@link TaskInvocationParametersProperty#getMaintenanceWindowLambdaParameters}
             * @param maintenanceWindowLambdaParameters The parameters for a <code>LAMBDA</code> task type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceWindowLambdaParameters(software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.MaintenanceWindowLambdaParametersProperty maintenanceWindowLambdaParameters) {
                this.maintenanceWindowLambdaParameters = maintenanceWindowLambdaParameters;
                return this;
            }

            /**
             * Sets the value of {@link TaskInvocationParametersProperty#getMaintenanceWindowRunCommandParameters}
             * @param maintenanceWindowRunCommandParameters The parameters for a <code>RUN_COMMAND</code> task type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceWindowRunCommandParameters(software.amazon.awscdk.IResolvable maintenanceWindowRunCommandParameters) {
                this.maintenanceWindowRunCommandParameters = maintenanceWindowRunCommandParameters;
                return this;
            }

            /**
             * Sets the value of {@link TaskInvocationParametersProperty#getMaintenanceWindowRunCommandParameters}
             * @param maintenanceWindowRunCommandParameters The parameters for a <code>RUN_COMMAND</code> task type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceWindowRunCommandParameters(software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.MaintenanceWindowRunCommandParametersProperty maintenanceWindowRunCommandParameters) {
                this.maintenanceWindowRunCommandParameters = maintenanceWindowRunCommandParameters;
                return this;
            }

            /**
             * Sets the value of {@link TaskInvocationParametersProperty#getMaintenanceWindowStepFunctionsParameters}
             * @param maintenanceWindowStepFunctionsParameters The parameters for a <code>STEP_FUNCTIONS</code> task type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceWindowStepFunctionsParameters(software.amazon.awscdk.IResolvable maintenanceWindowStepFunctionsParameters) {
                this.maintenanceWindowStepFunctionsParameters = maintenanceWindowStepFunctionsParameters;
                return this;
            }

            /**
             * Sets the value of {@link TaskInvocationParametersProperty#getMaintenanceWindowStepFunctionsParameters}
             * @param maintenanceWindowStepFunctionsParameters The parameters for a <code>STEP_FUNCTIONS</code> task type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maintenanceWindowStepFunctionsParameters(software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.MaintenanceWindowStepFunctionsParametersProperty maintenanceWindowStepFunctionsParameters) {
                this.maintenanceWindowStepFunctionsParameters = maintenanceWindowStepFunctionsParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TaskInvocationParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TaskInvocationParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TaskInvocationParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskInvocationParametersProperty {
            private final java.lang.Object maintenanceWindowAutomationParameters;
            private final java.lang.Object maintenanceWindowLambdaParameters;
            private final java.lang.Object maintenanceWindowRunCommandParameters;
            private final java.lang.Object maintenanceWindowStepFunctionsParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maintenanceWindowAutomationParameters = software.amazon.jsii.Kernel.get(this, "maintenanceWindowAutomationParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maintenanceWindowLambdaParameters = software.amazon.jsii.Kernel.get(this, "maintenanceWindowLambdaParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maintenanceWindowRunCommandParameters = software.amazon.jsii.Kernel.get(this, "maintenanceWindowRunCommandParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maintenanceWindowStepFunctionsParameters = software.amazon.jsii.Kernel.get(this, "maintenanceWindowStepFunctionsParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maintenanceWindowAutomationParameters = builder.maintenanceWindowAutomationParameters;
                this.maintenanceWindowLambdaParameters = builder.maintenanceWindowLambdaParameters;
                this.maintenanceWindowRunCommandParameters = builder.maintenanceWindowRunCommandParameters;
                this.maintenanceWindowStepFunctionsParameters = builder.maintenanceWindowStepFunctionsParameters;
            }

            @Override
            public final java.lang.Object getMaintenanceWindowAutomationParameters() {
                return this.maintenanceWindowAutomationParameters;
            }

            @Override
            public final java.lang.Object getMaintenanceWindowLambdaParameters() {
                return this.maintenanceWindowLambdaParameters;
            }

            @Override
            public final java.lang.Object getMaintenanceWindowRunCommandParameters() {
                return this.maintenanceWindowRunCommandParameters;
            }

            @Override
            public final java.lang.Object getMaintenanceWindowStepFunctionsParameters() {
                return this.maintenanceWindowStepFunctionsParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaintenanceWindowAutomationParameters() != null) {
                    data.set("maintenanceWindowAutomationParameters", om.valueToTree(this.getMaintenanceWindowAutomationParameters()));
                }
                if (this.getMaintenanceWindowLambdaParameters() != null) {
                    data.set("maintenanceWindowLambdaParameters", om.valueToTree(this.getMaintenanceWindowLambdaParameters()));
                }
                if (this.getMaintenanceWindowRunCommandParameters() != null) {
                    data.set("maintenanceWindowRunCommandParameters", om.valueToTree(this.getMaintenanceWindowRunCommandParameters()));
                }
                if (this.getMaintenanceWindowStepFunctionsParameters() != null) {
                    data.set("maintenanceWindowStepFunctionsParameters", om.valueToTree(this.getMaintenanceWindowStepFunctionsParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssm.CfnMaintenanceWindowTask.TaskInvocationParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TaskInvocationParametersProperty.Jsii$Proxy that = (TaskInvocationParametersProperty.Jsii$Proxy) o;

                if (this.maintenanceWindowAutomationParameters != null ? !this.maintenanceWindowAutomationParameters.equals(that.maintenanceWindowAutomationParameters) : that.maintenanceWindowAutomationParameters != null) return false;
                if (this.maintenanceWindowLambdaParameters != null ? !this.maintenanceWindowLambdaParameters.equals(that.maintenanceWindowLambdaParameters) : that.maintenanceWindowLambdaParameters != null) return false;
                if (this.maintenanceWindowRunCommandParameters != null ? !this.maintenanceWindowRunCommandParameters.equals(that.maintenanceWindowRunCommandParameters) : that.maintenanceWindowRunCommandParameters != null) return false;
                return this.maintenanceWindowStepFunctionsParameters != null ? this.maintenanceWindowStepFunctionsParameters.equals(that.maintenanceWindowStepFunctionsParameters) : that.maintenanceWindowStepFunctionsParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maintenanceWindowAutomationParameters != null ? this.maintenanceWindowAutomationParameters.hashCode() : 0;
                result = 31 * result + (this.maintenanceWindowLambdaParameters != null ? this.maintenanceWindowLambdaParameters.hashCode() : 0);
                result = 31 * result + (this.maintenanceWindowRunCommandParameters != null ? this.maintenanceWindowRunCommandParameters.hashCode() : 0);
                result = 31 * result + (this.maintenanceWindowStepFunctionsParameters != null ? this.maintenanceWindowStepFunctionsParameters.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTaskProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTaskProps.Builder();
        }

        /**
         * The priority of the task in the maintenance window.
         * <p>
         * The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-priority</a>
         * @param priority The priority of the task in the maintenance window. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(final java.lang.Number priority) {
            this.props.priority(priority);
            return this;
        }

        /**
         * The resource that the task uses during execution.
         * <p>
         * For <code>RUN_COMMAND</code> and <code>AUTOMATION</code> task types, <code>TaskArn</code> is the SSM document name or Amazon Resource Name (ARN).
         * <p>
         * For <code>LAMBDA</code> tasks, <code>TaskArn</code> is the function name or ARN.
         * <p>
         * For <code>STEP_FUNCTIONS</code> tasks, <code>TaskArn</code> is the state machine ARN.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskarn</a>
         * @param taskArn The resource that the task uses during execution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskArn(final java.lang.String taskArn) {
            this.props.taskArn(taskArn);
            return this;
        }

        /**
         * The type of task.
         * <p>
         * Valid values: <code>RUN_COMMAND</code> , <code>AUTOMATION</code> , <code>LAMBDA</code> , <code>STEP_FUNCTIONS</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-tasktype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-tasktype</a>
         * @param taskType The type of task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskType(final java.lang.String taskType) {
            this.props.taskType(taskType);
            return this;
        }

        /**
         * The ID of the maintenance window where the task is registered.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-windowid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-windowid</a>
         * @param windowId The ID of the maintenance window where the task is registered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder windowId(final java.lang.String windowId) {
            this.props.windowId(windowId);
            return this;
        }

        /**
         * The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-cutoffbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-cutoffbehavior</a>
         * @param cutoffBehavior The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cutoffBehavior(final java.lang.String cutoffBehavior) {
            this.props.cutoffBehavior(cutoffBehavior);
            return this;
        }

        /**
         * A description of the task.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-description</a>
         * @param description A description of the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Information about an Amazon S3 bucket to write Run Command task-level logs to.
         * <p>
         * <blockquote>
         * <p>
         * <code>LoggingInfo</code> has been deprecated. To specify an Amazon S3 bucket to contain logs for Run Command tasks, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html">AWS ::SSM::MaintenanceWindowTask MaintenanceWindowRunCommandParameters</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-logginginfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-logginginfo</a>
         * @param loggingInfo Information about an Amazon S3 bucket to write Run Command task-level logs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingInfo(final software.amazon.awscdk.IResolvable loggingInfo) {
            this.props.loggingInfo(loggingInfo);
            return this;
        }
        /**
         * Information about an Amazon S3 bucket to write Run Command task-level logs to.
         * <p>
         * <blockquote>
         * <p>
         * <code>LoggingInfo</code> has been deprecated. To specify an Amazon S3 bucket to contain logs for Run Command tasks, instead use the <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-maintenancewindowtask-maintenancewindowruncommandparameters.html">AWS ::SSM::MaintenanceWindowTask MaintenanceWindowRunCommandParameters</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-logginginfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-logginginfo</a>
         * @param loggingInfo Information about an Amazon S3 bucket to write Run Command task-level logs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingInfo(final software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.LoggingInfoProperty loggingInfo) {
            this.props.loggingInfo(loggingInfo);
            return this;
        }

        /**
         * The maximum number of targets this task can be run for, in parallel.
         * <p>
         * <blockquote>
         * <p>
         * Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">targetless task</a> You must provide a value in all other cases.
         * <p>
         * For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code> . This value doesn't affect the running of your task.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-maxconcurrency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-maxconcurrency</a>
         * @param maxConcurrency The maximum number of targets this task can be run for, in parallel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrency(final java.lang.String maxConcurrency) {
            this.props.maxConcurrency(maxConcurrency);
            return this;
        }

        /**
         * The maximum number of errors allowed before this task stops being scheduled.
         * <p>
         * <blockquote>
         * <p>
         * Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">targetless task</a> You must provide a value in all other cases.
         * <p>
         * For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of <code>1</code> . This value doesn't affect the running of your task.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-maxerrors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-maxerrors</a>
         * @param maxErrors The maximum number of errors allowed before this task stops being scheduled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxErrors(final java.lang.String maxErrors) {
            this.props.maxErrors(maxErrors);
            return this;
        }

        /**
         * The task name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-name</a>
         * @param name The task name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM service role for AWS Systems Manager to assume when running a maintenance window task.
         * <p>
         * If you do not specify a service role ARN, Systems Manager uses a service-linked role in your account. If no appropriate service-linked role for Systems Manager exists in your account, it is created when you run <code>RegisterTaskWithMaintenanceWindow</code> .
         * <p>
         * However, for an improved security posture, we strongly recommend creating a custom policy and custom service role for running your maintenance window tasks. The policy can be crafted to provide only the permissions needed for your particular maintenance window tasks. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html">Setting up Maintenance Windows</a> in the in the <em>AWS Systems Manager User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-servicerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-servicerolearn</a>
         * @param serviceRoleArn The Amazon Resource Name (ARN) of the IAM service role for AWS Systems Manager to assume when running a maintenance window task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRoleArn(final java.lang.String serviceRoleArn) {
            this.props.serviceRoleArn(serviceRoleArn);
            return this;
        }

        /**
         * The targets, either instances or window target IDs.
         * <p>
         * <ul>
         * <li>Specify instances using <code>Key=InstanceIds,Values= *instanceid1* , *instanceid2*</code> .</li>
         * <li>Specify window target IDs using <code>Key=WindowTargetIds,Values= *window-target-id-1* , *window-target-id-2*</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-targets</a>
         * @param targets The targets, either instances or window target IDs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final software.amazon.awscdk.IResolvable targets) {
            this.props.targets(targets);
            return this;
        }
        /**
         * The targets, either instances or window target IDs.
         * <p>
         * <ul>
         * <li>Specify instances using <code>Key=InstanceIds,Values= *instanceid1* , *instanceid2*</code> .</li>
         * <li>Specify window target IDs using <code>Key=WindowTargetIds,Values= *window-target-id-1* , *window-target-id-2*</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-targets</a>
         * @param targets The targets, either instances or window target IDs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final java.util.List<? extends java.lang.Object> targets) {
            this.props.targets(targets);
            return this;
        }

        /**
         * The parameters to pass to the task when it runs.
         * <p>
         * Populate only the fields that match the task type. All other fields should be empty.
         * <p>
         * <blockquote>
         * <p>
         * When you update a maintenance window task that has options specified in <code>TaskInvocationParameters</code> , you must provide again all the <code>TaskInvocationParameters</code> values that you want to retain. The values you do not specify again are removed. For example, suppose that when you registered a Run Command task, you specified <code>TaskInvocationParameters</code> values for <code>Comment</code> , <code>NotificationConfig</code> , and <code>OutputS3BucketName</code> . If you update the maintenance window task and specify only a different <code>OutputS3BucketName</code> value, the values for <code>Comment</code> and <code>NotificationConfig</code> are removed.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters</a>
         * @param taskInvocationParameters The parameters to pass to the task when it runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskInvocationParameters(final software.amazon.awscdk.IResolvable taskInvocationParameters) {
            this.props.taskInvocationParameters(taskInvocationParameters);
            return this;
        }
        /**
         * The parameters to pass to the task when it runs.
         * <p>
         * Populate only the fields that match the task type. All other fields should be empty.
         * <p>
         * <blockquote>
         * <p>
         * When you update a maintenance window task that has options specified in <code>TaskInvocationParameters</code> , you must provide again all the <code>TaskInvocationParameters</code> values that you want to retain. The values you do not specify again are removed. For example, suppose that when you registered a Run Command task, you specified <code>TaskInvocationParameters</code> values for <code>Comment</code> , <code>NotificationConfig</code> , and <code>OutputS3BucketName</code> . If you update the maintenance window task and specify only a different <code>OutputS3BucketName</code> value, the values for <code>Comment</code> and <code>NotificationConfig</code> are removed.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskinvocationparameters</a>
         * @param taskInvocationParameters The parameters to pass to the task when it runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskInvocationParameters(final software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.TaskInvocationParametersProperty taskInvocationParameters) {
            this.props.taskInvocationParameters(taskInvocationParameters);
            return this;
        }

        /**
         * The parameters to pass to the task when it runs.
         * <p>
         * <blockquote>
         * <p>
         * <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see <a href="https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_MaintenanceWindowTaskInvocationParameters.html">MaintenanceWindowTaskInvocationParameters</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-maintenancewindowtask.html#cfn-ssm-maintenancewindowtask-taskparameters</a>
         * @param taskParameters The parameters to pass to the task when it runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskParameters(final java.lang.Object taskParameters) {
            this.props.taskParameters(taskParameters);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask build() {
            return new software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
