package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for defining a custom state definition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.dynamodb.*;
 * // create a table
 * Table table = Table.Builder.create(this, "montable")
 *         .partitionKey(Attribute.builder()
 *                 .name("id")
 *                 .type(AttributeType.STRING)
 *                 .build())
 *         .build();
 * Pass finalStatus = new Pass(this, "final step");
 * // States language JSON to put an item into DynamoDB
 * // snippet generated from https://docs.aws.amazon.com/step-functions/latest/dg/tutorial-code-snippet.html#tutorial-code-snippet-1
 * Map&lt;String, Object&gt; stateJson = Map.of(
 *         "Type", "Task",
 *         "Resource", "arn:aws:states:::dynamodb:putItem",
 *         "Parameters", Map.of(
 *                 "TableName", table.getTableName(),
 *                 "Item", Map.of(
 *                         "id", Map.of(
 *                                 "S", "MyEntry"))),
 *         "ResultPath", null);
 * // custom state which represents a task to insert data into DynamoDB
 * CustomState custom = CustomState.Builder.create(this, "my custom task")
 *         .stateJson(stateJson)
 *         .build();
 * // catch errors with addCatch
 * Pass errorHandler = new Pass(this, "handle failure");
 * custom.addCatch(errorHandler);
 * // retry the task if something goes wrong
 * custom.addRetry(RetryProps.builder()
 *         .errors(List.of(Errors.ALL))
 *         .interval(Duration.seconds(10))
 *         .maxAttempts(5)
 *         .build());
 * Chain chain = Chain.start(custom).next(finalStatus);
 * StateMachine sm = StateMachine.Builder.create(this, "StateMachine")
 *         .definitionBody(DefinitionBody.fromChainable(chain))
 *         .timeout(Duration.seconds(30))
 *         .comment("a super cool state machine")
 *         .build();
 * // don't forget permissions. You need to assign them
 * table.grantWriteData(sm);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:16.216Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.CustomStateProps")
@software.amazon.jsii.Jsii.Proxy(CustomStateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomStateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Amazon States Language (JSON-based) definition of the state.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getStateJson();

    /**
     * @return a {@link Builder} of {@link CustomStateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomStateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomStateProps> {
        java.util.Map<java.lang.String, java.lang.Object> stateJson;

        /**
         * Sets the value of {@link CustomStateProps#getStateJson}
         * @param stateJson Amazon States Language (JSON-based) definition of the state. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder stateJson(java.util.Map<java.lang.String, ? extends java.lang.Object> stateJson) {
            this.stateJson = (java.util.Map<java.lang.String, java.lang.Object>)stateJson;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomStateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomStateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomStateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomStateProps {
        private final java.util.Map<java.lang.String, java.lang.Object> stateJson;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stateJson = software.amazon.jsii.Kernel.get(this, "stateJson", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stateJson = (java.util.Map<java.lang.String, java.lang.Object>)java.util.Objects.requireNonNull(builder.stateJson, "stateJson is required");
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getStateJson() {
            return this.stateJson;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stateJson", om.valueToTree(this.getStateJson()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.CustomStateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomStateProps.Jsii$Proxy that = (CustomStateProps.Jsii$Proxy) o;

            return this.stateJson.equals(that.stateJson);
        }

        @Override
        public final int hashCode() {
            int result = this.stateJson.hashCode();
            return result;
        }
    }
}
