package software.amazon.awscdk.services.stepfunctions;

/**
 * Option properties for JSONPath state.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * JsonPathCommonOptions jsonPathCommonOptions = JsonPathCommonOptions.builder()
 *         .inputPath("inputPath")
 *         .outputPath("outputPath")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:16.251Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.JsonPathCommonOptions")
@software.amazon.jsii.Jsii.Proxy(JsonPathCommonOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface JsonPathCommonOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * JSONPath expression to select part of the state to be the input to this state.
     * <p>
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * input to be the empty object {}.
     * <p>
     * Default: $
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInputPath() {
        return null;
    }

    /**
     * JSONPath expression to select part of the state to be the output to this state.
     * <p>
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * output to be the empty object {}.
     * <p>
     * Default: $
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutputPath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link JsonPathCommonOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JsonPathCommonOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<JsonPathCommonOptions> {
        java.lang.String inputPath;
        java.lang.String outputPath;

        /**
         * Sets the value of {@link JsonPathCommonOptions#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link JsonPathCommonOptions#getOutputPath}
         * @param outputPath JSONPath expression to select part of the state to be the output to this state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JsonPathCommonOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public JsonPathCommonOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JsonPathCommonOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonPathCommonOptions {
        private final java.lang.String inputPath;
        private final java.lang.String outputPath;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.inputPath = builder.inputPath;
            this.outputPath = builder.outputPath;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.JsonPathCommonOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JsonPathCommonOptions.Jsii$Proxy that = (JsonPathCommonOptions.Jsii$Proxy) o;

            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            return this.outputPath != null ? this.outputPath.equals(that.outputPath) : that.outputPath == null;
        }

        @Override
        public final int hashCode() {
            int result = this.inputPath != null ? this.inputPath.hashCode() : 0;
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            return result;
        }
    }
}
