package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The customization type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.bedrock.*;
 * import software.amazon.awscdk.services.kms.*;
 * IBucket outputBucket;
 * IBucket trainingBucket;
 * IBucket validationBucket;
 * IKey kmsKey;
 * IVpc vpc;
 * FoundationModel model = FoundationModel.fromFoundationModelId(this, "Model", FoundationModelIdentifier.AMAZON_TITAN_TEXT_G1_EXPRESS_V1);
 * BedrockCreateModelCustomizationJob task = BedrockCreateModelCustomizationJob.Builder.create(this, "CreateModelCustomizationJob")
 *         .baseModel(model)
 *         .clientRequestToken("MyToken")
 *         .customizationType(CustomizationType.FINE_TUNING)
 *         .customModelKmsKey(kmsKey)
 *         .customModelName("MyCustomModel") // required
 *         .customModelTags(List.of(CustomModelTag.builder().key("key1").value("value1").build()))
 *         .hyperParameters(Map.of(
 *                 "batchSize", "10"))
 *         .jobName("MyCustomizationJob") // required
 *         .jobTags(List.of(CustomModelTag.builder().key("key2").value("value2").build()))
 *         .outputData(OutputBucketConfiguration.builder()
 *                 .bucket(outputBucket) // required
 *                 .path("output-data/")
 *                 .build())
 *         .trainingData(TrainingBucketConfiguration.builder()
 *                 .bucket(trainingBucket)
 *                 .path("training-data/data.json")
 *                 .build()) // required
 *         // If you don't provide validation data, you have to specify `Evaluation percentage` hyperparameter.
 *         .validationData(List.of(ValidationBucketConfiguration.builder()
 *                 .bucket(validationBucket)
 *                 .path("validation-data/data.json")
 *                 .build()))
 *         .vpcConfig(Map.of(
 *                 "securityGroups", List.of(SecurityGroup.Builder.create(this, "SecurityGroup").vpc(vpc).build()),
 *                 "subnets", vpc.getPrivateSubnets()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:16.475Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.CustomizationType")
public enum CustomizationType {
    /**
     * Fine-tuning.
     * <p>
     * Provide labeled data in order to train a model to improve performance on specific tasks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FINE_TUNING,
    /**
     * Continued pre-training.
     * <p>
     * Provide unlabeled data to pre-train a foundation model by familiarizing it with certain types of inputs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CONTINUED_PRE_TRAINING,
    /**
     * Distillation.
     * <p>
     * With Model Distillation, you can generate synthetic responses from a large foundation model (teacher)
     * and use that data to train a smaller model (student) for your specific use-case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DISTILLATION,
}
