package software.amazon.awscdk.services.wisdom;

/**
 * Properties for defining a <code>CfnMessageTemplate</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wisdom.*;
 * CfnMessageTemplateProps cfnMessageTemplateProps = CfnMessageTemplateProps.builder()
 *         .channelSubtype("channelSubtype")
 *         .content(ContentProperty.builder()
 *                 .emailMessageTemplateContent(EmailMessageTemplateContentProperty.builder()
 *                         .body(EmailMessageTemplateContentBodyProperty.builder()
 *                                 .html(MessageTemplateBodyContentProviderProperty.builder()
 *                                         .content("content")
 *                                         .build())
 *                                 .plainText(MessageTemplateBodyContentProviderProperty.builder()
 *                                         .content("content")
 *                                         .build())
 *                                 .build())
 *                         .headers(List.of(EmailMessageTemplateHeaderProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .subject("subject")
 *                         .build())
 *                 .smsMessageTemplateContent(SmsMessageTemplateContentProperty.builder()
 *                         .body(SmsMessageTemplateContentBodyProperty.builder()
 *                                 .plainText(MessageTemplateBodyContentProviderProperty.builder()
 *                                         .content("content")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .knowledgeBaseArn("knowledgeBaseArn")
 *         .name("name")
 *         // the properties below are optional
 *         .defaultAttributes(MessageTemplateAttributesProperty.builder()
 *                 .agentAttributes(AgentAttributesProperty.builder()
 *                         .firstName("firstName")
 *                         .lastName("lastName")
 *                         .build())
 *                 .customAttributes(Map.of(
 *                         "customAttributesKey", "customAttributes"))
 *                 .customerProfileAttributes(CustomerProfileAttributesProperty.builder()
 *                         .accountNumber("accountNumber")
 *                         .additionalInformation("additionalInformation")
 *                         .address1("address1")
 *                         .address2("address2")
 *                         .address3("address3")
 *                         .address4("address4")
 *                         .billingAddress1("billingAddress1")
 *                         .billingAddress2("billingAddress2")
 *                         .billingAddress3("billingAddress3")
 *                         .billingAddress4("billingAddress4")
 *                         .billingCity("billingCity")
 *                         .billingCountry("billingCountry")
 *                         .billingCounty("billingCounty")
 *                         .billingPostalCode("billingPostalCode")
 *                         .billingProvince("billingProvince")
 *                         .billingState("billingState")
 *                         .birthDate("birthDate")
 *                         .businessEmailAddress("businessEmailAddress")
 *                         .businessName("businessName")
 *                         .businessPhoneNumber("businessPhoneNumber")
 *                         .city("city")
 *                         .country("country")
 *                         .county("county")
 *                         .custom(Map.of(
 *                                 "customKey", "custom"))
 *                         .emailAddress("emailAddress")
 *                         .firstName("firstName")
 *                         .gender("gender")
 *                         .homePhoneNumber("homePhoneNumber")
 *                         .lastName("lastName")
 *                         .mailingAddress1("mailingAddress1")
 *                         .mailingAddress2("mailingAddress2")
 *                         .mailingAddress3("mailingAddress3")
 *                         .mailingAddress4("mailingAddress4")
 *                         .mailingCity("mailingCity")
 *                         .mailingCountry("mailingCountry")
 *                         .mailingCounty("mailingCounty")
 *                         .mailingPostalCode("mailingPostalCode")
 *                         .mailingProvince("mailingProvince")
 *                         .mailingState("mailingState")
 *                         .middleName("middleName")
 *                         .mobilePhoneNumber("mobilePhoneNumber")
 *                         .partyType("partyType")
 *                         .phoneNumber("phoneNumber")
 *                         .postalCode("postalCode")
 *                         .profileArn("profileArn")
 *                         .profileId("profileId")
 *                         .province("province")
 *                         .shippingAddress1("shippingAddress1")
 *                         .shippingAddress2("shippingAddress2")
 *                         .shippingAddress3("shippingAddress3")
 *                         .shippingAddress4("shippingAddress4")
 *                         .shippingCity("shippingCity")
 *                         .shippingCountry("shippingCountry")
 *                         .shippingCounty("shippingCounty")
 *                         .shippingPostalCode("shippingPostalCode")
 *                         .shippingProvince("shippingProvince")
 *                         .shippingState("shippingState")
 *                         .state("state")
 *                         .build())
 *                 .systemAttributes(SystemAttributesProperty.builder()
 *                         .customerEndpoint(SystemEndpointAttributesProperty.builder()
 *                                 .address("address")
 *                                 .build())
 *                         .name("name")
 *                         .systemEndpoint(SystemEndpointAttributesProperty.builder()
 *                                 .address("address")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .groupingConfiguration(GroupingConfigurationProperty.builder()
 *                 .criteria("criteria")
 *                 .values(List.of("values"))
 *                 .build())
 *         .language("language")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:17.360Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnMessageTemplateProps")
@software.amazon.jsii.Jsii.Proxy(CfnMessageTemplateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMessageTemplateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The channel subtype this message template applies to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-channelsubtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-channelsubtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getChannelSubtype();

    /**
     * The content of the message template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-content">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-content</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getContent();

    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-knowledgebasearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-knowledgebasearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKnowledgeBaseArn();

    /**
     * The name of the message template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * An object that specifies the default values to use for variables in the message template.
     * <p>
     * This object contains different categories of key-value pairs. Each key defines a variable or placeholder in the message template. The corresponding value defines the default value for that variable.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-defaultattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-defaultattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultAttributes() {
        return null;
    }

    /**
     * The description of the message template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The configuration information of the external data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-groupingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-groupingconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGroupingConfiguration() {
        return null;
    }

    /**
     * The language code value for the language in which the quick response is written.
     * <p>
     * The supported language codes include <code>de_DE</code> , <code>en_US</code> , <code>es_ES</code> , <code>fr_FR</code> , <code>id_ID</code> , <code>it_IT</code> , <code>ja_JP</code> , <code>ko_KR</code> , <code>pt_BR</code> , <code>zh_CN</code> , <code>zh_TW</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-language">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-language</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLanguage() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMessageTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMessageTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMessageTemplateProps> {
        java.lang.String channelSubtype;
        java.lang.Object content;
        java.lang.String knowledgeBaseArn;
        java.lang.String name;
        java.lang.Object defaultAttributes;
        java.lang.String description;
        java.lang.Object groupingConfiguration;
        java.lang.String language;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnMessageTemplateProps#getChannelSubtype}
         * @param channelSubtype The channel subtype this message template applies to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelSubtype(java.lang.String channelSubtype) {
            this.channelSubtype = channelSubtype;
            return this;
        }

        /**
         * Sets the value of {@link CfnMessageTemplateProps#getContent}
         * @param content The content of the message template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(software.amazon.awscdk.IResolvable content) {
            this.content = content;
            return this;
        }

        /**
         * Sets the value of {@link CfnMessageTemplateProps#getContent}
         * @param content The content of the message template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(software.amazon.awscdk.services.wisdom.CfnMessageTemplate.ContentProperty content) {
            this.content = content;
            return this;
        }

        /**
         * Sets the value of {@link CfnMessageTemplateProps#getKnowledgeBaseArn}
         * @param knowledgeBaseArn The Amazon Resource Name (ARN) of the knowledge base. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseArn(java.lang.String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnMessageTemplateProps#getName}
         * @param name The name of the message template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnMessageTemplateProps#getDefaultAttributes}
         * @param defaultAttributes An object that specifies the default values to use for variables in the message template.
         *                          This object contains different categories of key-value pairs. Each key defines a variable or placeholder in the message template. The corresponding value defines the default value for that variable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAttributes(software.amazon.awscdk.IResolvable defaultAttributes) {
            this.defaultAttributes = defaultAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnMessageTemplateProps#getDefaultAttributes}
         * @param defaultAttributes An object that specifies the default values to use for variables in the message template.
         *                          This object contains different categories of key-value pairs. Each key defines a variable or placeholder in the message template. The corresponding value defines the default value for that variable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAttributes(software.amazon.awscdk.services.wisdom.CfnMessageTemplate.MessageTemplateAttributesProperty defaultAttributes) {
            this.defaultAttributes = defaultAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnMessageTemplateProps#getDescription}
         * @param description The description of the message template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnMessageTemplateProps#getGroupingConfiguration}
         * @param groupingConfiguration The configuration information of the external data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupingConfiguration(software.amazon.awscdk.IResolvable groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMessageTemplateProps#getGroupingConfiguration}
         * @param groupingConfiguration The configuration information of the external data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupingConfiguration(software.amazon.awscdk.services.wisdom.CfnMessageTemplate.GroupingConfigurationProperty groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMessageTemplateProps#getLanguage}
         * @param language The language code value for the language in which the quick response is written.
         *                 The supported language codes include <code>de_DE</code> , <code>en_US</code> , <code>es_ES</code> , <code>fr_FR</code> , <code>id_ID</code> , <code>it_IT</code> , <code>ja_JP</code> , <code>ko_KR</code> , <code>pt_BR</code> , <code>zh_CN</code> , <code>zh_TW</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder language(java.lang.String language) {
            this.language = language;
            return this;
        }

        /**
         * Sets the value of {@link CfnMessageTemplateProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMessageTemplateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMessageTemplateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMessageTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMessageTemplateProps {
        private final java.lang.String channelSubtype;
        private final java.lang.Object content;
        private final java.lang.String knowledgeBaseArn;
        private final java.lang.String name;
        private final java.lang.Object defaultAttributes;
        private final java.lang.String description;
        private final java.lang.Object groupingConfiguration;
        private final java.lang.String language;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.channelSubtype = software.amazon.jsii.Kernel.get(this, "channelSubtype", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.content = software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.knowledgeBaseArn = software.amazon.jsii.Kernel.get(this, "knowledgeBaseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultAttributes = software.amazon.jsii.Kernel.get(this, "defaultAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.groupingConfiguration = software.amazon.jsii.Kernel.get(this, "groupingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.language = software.amazon.jsii.Kernel.get(this, "language", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.channelSubtype = java.util.Objects.requireNonNull(builder.channelSubtype, "channelSubtype is required");
            this.content = java.util.Objects.requireNonNull(builder.content, "content is required");
            this.knowledgeBaseArn = java.util.Objects.requireNonNull(builder.knowledgeBaseArn, "knowledgeBaseArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.defaultAttributes = builder.defaultAttributes;
            this.description = builder.description;
            this.groupingConfiguration = builder.groupingConfiguration;
            this.language = builder.language;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getChannelSubtype() {
            return this.channelSubtype;
        }

        @Override
        public final java.lang.Object getContent() {
            return this.content;
        }

        @Override
        public final java.lang.String getKnowledgeBaseArn() {
            return this.knowledgeBaseArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getDefaultAttributes() {
            return this.defaultAttributes;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getGroupingConfiguration() {
            return this.groupingConfiguration;
        }

        @Override
        public final java.lang.String getLanguage() {
            return this.language;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("channelSubtype", om.valueToTree(this.getChannelSubtype()));
            data.set("content", om.valueToTree(this.getContent()));
            data.set("knowledgeBaseArn", om.valueToTree(this.getKnowledgeBaseArn()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getDefaultAttributes() != null) {
                data.set("defaultAttributes", om.valueToTree(this.getDefaultAttributes()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getGroupingConfiguration() != null) {
                data.set("groupingConfiguration", om.valueToTree(this.getGroupingConfiguration()));
            }
            if (this.getLanguage() != null) {
                data.set("language", om.valueToTree(this.getLanguage()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnMessageTemplateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMessageTemplateProps.Jsii$Proxy that = (CfnMessageTemplateProps.Jsii$Proxy) o;

            if (!channelSubtype.equals(that.channelSubtype)) return false;
            if (!content.equals(that.content)) return false;
            if (!knowledgeBaseArn.equals(that.knowledgeBaseArn)) return false;
            if (!name.equals(that.name)) return false;
            if (this.defaultAttributes != null ? !this.defaultAttributes.equals(that.defaultAttributes) : that.defaultAttributes != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.groupingConfiguration != null ? !this.groupingConfiguration.equals(that.groupingConfiguration) : that.groupingConfiguration != null) return false;
            if (this.language != null ? !this.language.equals(that.language) : that.language != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.channelSubtype.hashCode();
            result = 31 * result + (this.content.hashCode());
            result = 31 * result + (this.knowledgeBaseArn.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.defaultAttributes != null ? this.defaultAttributes.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.groupingConfiguration != null ? this.groupingConfiguration.hashCode() : 0);
            result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
