package software.amazon.awscdk.services.workspacesinstances;

/**
 * Properties for defining a <code>CfnVolumeAssociation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.workspacesinstances.*;
 * CfnVolumeAssociationProps cfnVolumeAssociationProps = CfnVolumeAssociationProps.builder()
 *         .device("device")
 *         .volumeId("volumeId")
 *         .workspaceInstanceId("workspaceInstanceId")
 *         // the properties below are optional
 *         .disassociateMode("disassociateMode")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesinstances-volumeassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesinstances-volumeassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-04T12:43:17.371Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspacesinstances.CfnVolumeAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnVolumeAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVolumeAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The device name for the volume attachment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesinstances-volumeassociation.html#cfn-workspacesinstances-volumeassociation-device">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesinstances-volumeassociation.html#cfn-workspacesinstances-volumeassociation-device</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDevice();

    /**
     * ID of the volume to attach to the workspace instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesinstances-volumeassociation.html#cfn-workspacesinstances-volumeassociation-volumeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesinstances-volumeassociation.html#cfn-workspacesinstances-volumeassociation-volumeid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVolumeId();

    /**
     * ID of the workspace instance to associate with the volume.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesinstances-volumeassociation.html#cfn-workspacesinstances-volumeassociation-workspaceinstanceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesinstances-volumeassociation.html#cfn-workspacesinstances-volumeassociation-workspaceinstanceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWorkspaceInstanceId();

    /**
     * Mode to use when disassociating the volume.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesinstances-volumeassociation.html#cfn-workspacesinstances-volumeassociation-disassociatemode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesinstances-volumeassociation.html#cfn-workspacesinstances-volumeassociation-disassociatemode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisassociateMode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVolumeAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVolumeAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVolumeAssociationProps> {
        java.lang.String device;
        java.lang.String volumeId;
        java.lang.String workspaceInstanceId;
        java.lang.String disassociateMode;

        /**
         * Sets the value of {@link CfnVolumeAssociationProps#getDevice}
         * @param device The device name for the volume attachment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder device(java.lang.String device) {
            this.device = device;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeAssociationProps#getVolumeId}
         * @param volumeId ID of the volume to attach to the workspace instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeId(java.lang.String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeAssociationProps#getWorkspaceInstanceId}
         * @param workspaceInstanceId ID of the workspace instance to associate with the volume. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workspaceInstanceId(java.lang.String workspaceInstanceId) {
            this.workspaceInstanceId = workspaceInstanceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeAssociationProps#getDisassociateMode}
         * @param disassociateMode Mode to use when disassociating the volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disassociateMode(java.lang.String disassociateMode) {
            this.disassociateMode = disassociateMode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVolumeAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVolumeAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVolumeAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVolumeAssociationProps {
        private final java.lang.String device;
        private final java.lang.String volumeId;
        private final java.lang.String workspaceInstanceId;
        private final java.lang.String disassociateMode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.device = software.amazon.jsii.Kernel.get(this, "device", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumeId = software.amazon.jsii.Kernel.get(this, "volumeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.workspaceInstanceId = software.amazon.jsii.Kernel.get(this, "workspaceInstanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disassociateMode = software.amazon.jsii.Kernel.get(this, "disassociateMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.device = java.util.Objects.requireNonNull(builder.device, "device is required");
            this.volumeId = java.util.Objects.requireNonNull(builder.volumeId, "volumeId is required");
            this.workspaceInstanceId = java.util.Objects.requireNonNull(builder.workspaceInstanceId, "workspaceInstanceId is required");
            this.disassociateMode = builder.disassociateMode;
        }

        @Override
        public final java.lang.String getDevice() {
            return this.device;
        }

        @Override
        public final java.lang.String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final java.lang.String getWorkspaceInstanceId() {
            return this.workspaceInstanceId;
        }

        @Override
        public final java.lang.String getDisassociateMode() {
            return this.disassociateMode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("device", om.valueToTree(this.getDevice()));
            data.set("volumeId", om.valueToTree(this.getVolumeId()));
            data.set("workspaceInstanceId", om.valueToTree(this.getWorkspaceInstanceId()));
            if (this.getDisassociateMode() != null) {
                data.set("disassociateMode", om.valueToTree(this.getDisassociateMode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_workspacesinstances.CfnVolumeAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVolumeAssociationProps.Jsii$Proxy that = (CfnVolumeAssociationProps.Jsii$Proxy) o;

            if (!device.equals(that.device)) return false;
            if (!volumeId.equals(that.volumeId)) return false;
            if (!workspaceInstanceId.equals(that.workspaceInstanceId)) return false;
            return this.disassociateMode != null ? this.disassociateMode.equals(that.disassociateMode) : that.disassociateMode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.device.hashCode();
            result = 31 * result + (this.volumeId.hashCode());
            result = 31 * result + (this.workspaceInstanceId.hashCode());
            result = 31 * result + (this.disassociateMode != null ? this.disassociateMode.hashCode() : 0);
            return result;
        }
    }
}
