package software.amazon.awscdk.cloud_assembly_schema;

/**
 * Query input for lookup up CloudFormation resources using CC API.
 * <p>
 * The example below is required to successfully compile CDK (otherwise,
 * the CDK build will generate a synthetic example for the below, but it
 * doesn't have enough type information about the literal string union
 * to generate a validly compiling example).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.cloudassembly.schema.CcApiContextQuery;
 * CcApiContextQuery x = CcApiContextQuery.builder()
 *         .typeName("AWS::Some::Type")
 *         .expectedMatchCount("exactly-one")
 *         .propertiesToReturn(List.of("SomeProp"))
 *         .account("11111111111")
 *         .region("us-east-1")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:46.351Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.CcApiContextQuery")
@software.amazon.jsii.Jsii.Proxy(CcApiContextQuery.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CcApiContextQuery extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.cloud_assembly_schema.ContextLookupRoleOptions {

    /**
     * This is a set of properties returned from CC API that we want to return from ContextQuery.
     * <p>
     * If any properties listed here are absent from the target resource, an error will be thrown.
     * <p>
     * The returned object will always include the key <code>Identifier</code> with the CC-API returned
     * field <code>Identifier</code>.
     * <p>
     * <h2>Notes on property completeness</h2>
     * <p>
     * CloudControl API's <code>ListResources</code> may return fewer properties than
     * <code>GetResource</code> would, depending on the resource implementation.
     * <p>
     * The returned properties here are <em>currently</em> selected from the response
     * object that CloudControl API returns to the CDK CLI.
     * <p>
     * However, if we find there is need to do so, we may decide to change this
     * behavior in the future: we might change it to perform an additional
     * <code>GetResource</code> call for resources matched by <code>propertyMatch</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getPropertiesToReturn();

    /**
     * The CloudFormation resource type.
     * <p>
     * See https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/supported-resources.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTypeName();

    /**
     * The value to return if the resource was not found and <code>ignoreErrorOnMissingContext</code> is true.
     * <p>
     * If supplied, <code>dummyValue</code> should be an array of objects.
     * <p>
     * <code>dummyValue</code> does not have to have elements, and it may have objects with
     * different properties than the properties in <code>propertiesToReturn</code>, but it
     * will be easiest for downstream code if the <code>dummyValue</code> conforms to
     * the expected response shape.
     * <p>
     * Default: - No dummy value available
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDummyValue() {
        return null;
    }

    /**
     * Identifier of the resource to look up using <code>GetResource</code>.
     * <p>
     * Specifying exactIdentifier will return exactly one result, or throw an error
     * unless <code>ignoreErrorOnMissingContext</code> is set.
     * <p>
     * Default: - Either exactIdentifier or propertyMatch should be specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExactIdentifier() {
        return null;
    }

    /**
     * Expected count of results if <code>propertyMatch</code> is specified.
     * <p>
     * If the expected result count does not match the actual count,
     * by default an error is produced and the result is not committed to cached
     * context, and the user can correct the situation and try again without
     * having to manually clear out the context key using <code>cdk context --remove</code>
     * <p>
     * If the value of * <code>ignoreErrorOnMissingContext</code> is <code>true</code>, the value of
     * <code>expectedMatchCount</code> is <code>at-least-one | exactly-one</code> and the number
     * of found resources is 0, <code>dummyValue</code> is returned and committed to context
     * instead.
     * <p>
     * Default: 'any'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExpectedMatchCount() {
        return null;
    }

    /**
     * Ignore an error and return the <code>dummyValue</code> instead if the resource was not found.
     * <p>
     * <ul>
     * <li>In case of an <code>exactIdentifier</code> lookup, return the <code>dummyValue</code> if the resource with
     * that identifier was not found.</li>
     * <li>In case of a <code>propertyMatch</code> lookup, return the <code>dummyValue</code> if <code>expectedMatchCount</code>
     * is <code>at-least-one | exactly-one</code> and the number of resources found was 0.</li>
     * </ul>
     * <p>
     * if <code>ignoreErrorOnMissingContext</code> is set, <code>dummyValue</code> should be set and be an array.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreErrorOnMissingContext() {
        return null;
    }

    /**
     * Returns any resources matching these properties, using <code>ListResources</code>.
     * <p>
     * By default, specifying propertyMatch will successfully return 0 or more
     * results. To throw an error if the number of results is unexpected (and
     * prevent the query results from being committed to context), specify
     * <code>expectedMatchCount</code>.
     * <p>
     * <h2>Notes on property completeness</h2>
     * <p>
     * CloudControl API's <code>ListResources</code> may return fewer properties than
     * <code>GetResource</code> would, depending on the resource implementation.
     * <p>
     * The resources that <code>propertyMatch</code> matches against will <em>only ever</em> be the
     * properties returned by the <code>ListResources</code> call.
     * <p>
     * Default: - Either exactIdentifier or propertyMatch should be specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getPropertyMatch() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CcApiContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CcApiContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CcApiContextQuery> {
        java.util.List<java.lang.String> propertiesToReturn;
        java.lang.String typeName;
        java.lang.Object dummyValue;
        java.lang.String exactIdentifier;
        java.lang.String expectedMatchCount;
        java.lang.Boolean ignoreErrorOnMissingContext;
        java.util.Map<java.lang.String, java.lang.Object> propertyMatch;
        java.lang.String account;
        java.lang.String region;
        java.util.Map<java.lang.String, java.lang.Object> assumeRoleAdditionalOptions;
        java.lang.String lookupRoleArn;
        java.lang.String lookupRoleExternalId;

        /**
         * Sets the value of {@link CcApiContextQuery#getPropertiesToReturn}
         * @param propertiesToReturn This is a set of properties returned from CC API that we want to return from ContextQuery. This parameter is required.
         *                           If any properties listed here are absent from the target resource, an error will be thrown.
         *                           <p>
         *                           The returned object will always include the key <code>Identifier</code> with the CC-API returned
         *                           field <code>Identifier</code>.
         *                           <p>
         *                           <h2>Notes on property completeness</h2>
         *                           <p>
         *                           CloudControl API's <code>ListResources</code> may return fewer properties than
         *                           <code>GetResource</code> would, depending on the resource implementation.
         *                           <p>
         *                           The returned properties here are <em>currently</em> selected from the response
         *                           object that CloudControl API returns to the CDK CLI.
         *                           <p>
         *                           However, if we find there is need to do so, we may decide to change this
         *                           behavior in the future: we might change it to perform an additional
         *                           <code>GetResource</code> call for resources matched by <code>propertyMatch</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propertiesToReturn(java.util.List<java.lang.String> propertiesToReturn) {
            this.propertiesToReturn = propertiesToReturn;
            return this;
        }

        /**
         * Sets the value of {@link CcApiContextQuery#getTypeName}
         * @param typeName The CloudFormation resource type. This parameter is required.
         *                 See https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/supported-resources.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeName(java.lang.String typeName) {
            this.typeName = typeName;
            return this;
        }

        /**
         * Sets the value of {@link CcApiContextQuery#getDummyValue}
         * @param dummyValue The value to return if the resource was not found and <code>ignoreErrorOnMissingContext</code> is true.
         *                   If supplied, <code>dummyValue</code> should be an array of objects.
         *                   <p>
         *                   <code>dummyValue</code> does not have to have elements, and it may have objects with
         *                   different properties than the properties in <code>propertiesToReturn</code>, but it
         *                   will be easiest for downstream code if the <code>dummyValue</code> conforms to
         *                   the expected response shape.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dummyValue(java.lang.Object dummyValue) {
            this.dummyValue = dummyValue;
            return this;
        }

        /**
         * Sets the value of {@link CcApiContextQuery#getExactIdentifier}
         * @param exactIdentifier Identifier of the resource to look up using <code>GetResource</code>.
         *                        Specifying exactIdentifier will return exactly one result, or throw an error
         *                        unless <code>ignoreErrorOnMissingContext</code> is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exactIdentifier(java.lang.String exactIdentifier) {
            this.exactIdentifier = exactIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CcApiContextQuery#getExpectedMatchCount}
         * @param expectedMatchCount Expected count of results if <code>propertyMatch</code> is specified.
         *                           If the expected result count does not match the actual count,
         *                           by default an error is produced and the result is not committed to cached
         *                           context, and the user can correct the situation and try again without
         *                           having to manually clear out the context key using <code>cdk context --remove</code>
         *                           <p>
         *                           If the value of * <code>ignoreErrorOnMissingContext</code> is <code>true</code>, the value of
         *                           <code>expectedMatchCount</code> is <code>at-least-one | exactly-one</code> and the number
         *                           of found resources is 0, <code>dummyValue</code> is returned and committed to context
         *                           instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expectedMatchCount(java.lang.String expectedMatchCount) {
            this.expectedMatchCount = expectedMatchCount;
            return this;
        }

        /**
         * Sets the value of {@link CcApiContextQuery#getIgnoreErrorOnMissingContext}
         * @param ignoreErrorOnMissingContext Ignore an error and return the <code>dummyValue</code> instead if the resource was not found.
         *                                    <ul>
         *                                    <li>In case of an <code>exactIdentifier</code> lookup, return the <code>dummyValue</code> if the resource with
         *                                    that identifier was not found.</li>
         *                                    <li>In case of a <code>propertyMatch</code> lookup, return the <code>dummyValue</code> if <code>expectedMatchCount</code>
         *                                    is <code>at-least-one | exactly-one</code> and the number of resources found was 0.</li>
         *                                    </ul>
         *                                    <p>
         *                                    if <code>ignoreErrorOnMissingContext</code> is set, <code>dummyValue</code> should be set and be an array.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreErrorOnMissingContext(java.lang.Boolean ignoreErrorOnMissingContext) {
            this.ignoreErrorOnMissingContext = ignoreErrorOnMissingContext;
            return this;
        }

        /**
         * Sets the value of {@link CcApiContextQuery#getPropertyMatch}
         * @param propertyMatch Returns any resources matching these properties, using <code>ListResources</code>.
         *                      By default, specifying propertyMatch will successfully return 0 or more
         *                      results. To throw an error if the number of results is unexpected (and
         *                      prevent the query results from being committed to context), specify
         *                      <code>expectedMatchCount</code>.
         *                      <p>
         *                      <h2>Notes on property completeness</h2>
         *                      <p>
         *                      CloudControl API's <code>ListResources</code> may return fewer properties than
         *                      <code>GetResource</code> would, depending on the resource implementation.
         *                      <p>
         *                      The resources that <code>propertyMatch</code> matches against will <em>only ever</em> be the
         *                      properties returned by the <code>ListResources</code> call.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder propertyMatch(java.util.Map<java.lang.String, ? extends java.lang.Object> propertyMatch) {
            this.propertyMatch = (java.util.Map<java.lang.String, java.lang.Object>)propertyMatch;
            return this;
        }

        /**
         * Sets the value of {@link CcApiContextQuery#getAccount}
         * @param account Query account. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link CcApiContextQuery#getRegion}
         * @param region Query region. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link CcApiContextQuery#getAssumeRoleAdditionalOptions}
         * @param assumeRoleAdditionalOptions Additional options to pass to STS when assuming the lookup role.
         *                                    <ul>
         *                                    <li><code>RoleArn</code> should not be used. Use the dedicated <code>lookupRoleArn</code> property instead.</li>
         *                                    <li><code>ExternalId</code> should not be used. Use the dedicated <code>lookupRoleExternalId</code> instead.</li>
         *                                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assumeRoleAdditionalOptions(java.util.Map<java.lang.String, ? extends java.lang.Object> assumeRoleAdditionalOptions) {
            this.assumeRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)assumeRoleAdditionalOptions;
            return this;
        }

        /**
         * Sets the value of {@link CcApiContextQuery#getLookupRoleArn}
         * @param lookupRoleArn The ARN of the role that should be used to look up the missing values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRoleArn(java.lang.String lookupRoleArn) {
            this.lookupRoleArn = lookupRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CcApiContextQuery#getLookupRoleExternalId}
         * @param lookupRoleExternalId The ExternalId that needs to be supplied while assuming this role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRoleExternalId(java.lang.String lookupRoleExternalId) {
            this.lookupRoleExternalId = lookupRoleExternalId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CcApiContextQuery}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CcApiContextQuery build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CcApiContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CcApiContextQuery {
        private final java.util.List<java.lang.String> propertiesToReturn;
        private final java.lang.String typeName;
        private final java.lang.Object dummyValue;
        private final java.lang.String exactIdentifier;
        private final java.lang.String expectedMatchCount;
        private final java.lang.Boolean ignoreErrorOnMissingContext;
        private final java.util.Map<java.lang.String, java.lang.Object> propertyMatch;
        private final java.lang.String account;
        private final java.lang.String region;
        private final java.util.Map<java.lang.String, java.lang.Object> assumeRoleAdditionalOptions;
        private final java.lang.String lookupRoleArn;
        private final java.lang.String lookupRoleExternalId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.propertiesToReturn = software.amazon.jsii.Kernel.get(this, "propertiesToReturn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.typeName = software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dummyValue = software.amazon.jsii.Kernel.get(this, "dummyValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.exactIdentifier = software.amazon.jsii.Kernel.get(this, "exactIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.expectedMatchCount = software.amazon.jsii.Kernel.get(this, "expectedMatchCount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ignoreErrorOnMissingContext = software.amazon.jsii.Kernel.get(this, "ignoreErrorOnMissingContext", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.propertyMatch = software.amazon.jsii.Kernel.get(this, "propertyMatch", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assumeRoleAdditionalOptions = software.amazon.jsii.Kernel.get(this, "assumeRoleAdditionalOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.lookupRoleArn = software.amazon.jsii.Kernel.get(this, "lookupRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lookupRoleExternalId = software.amazon.jsii.Kernel.get(this, "lookupRoleExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.propertiesToReturn = java.util.Objects.requireNonNull(builder.propertiesToReturn, "propertiesToReturn is required");
            this.typeName = java.util.Objects.requireNonNull(builder.typeName, "typeName is required");
            this.dummyValue = builder.dummyValue;
            this.exactIdentifier = builder.exactIdentifier;
            this.expectedMatchCount = builder.expectedMatchCount;
            this.ignoreErrorOnMissingContext = builder.ignoreErrorOnMissingContext;
            this.propertyMatch = (java.util.Map<java.lang.String, java.lang.Object>)builder.propertyMatch;
            this.account = java.util.Objects.requireNonNull(builder.account, "account is required");
            this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
            this.assumeRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)builder.assumeRoleAdditionalOptions;
            this.lookupRoleArn = builder.lookupRoleArn;
            this.lookupRoleExternalId = builder.lookupRoleExternalId;
        }

        @Override
        public final java.util.List<java.lang.String> getPropertiesToReturn() {
            return this.propertiesToReturn;
        }

        @Override
        public final java.lang.String getTypeName() {
            return this.typeName;
        }

        @Override
        public final java.lang.Object getDummyValue() {
            return this.dummyValue;
        }

        @Override
        public final java.lang.String getExactIdentifier() {
            return this.exactIdentifier;
        }

        @Override
        public final java.lang.String getExpectedMatchCount() {
            return this.expectedMatchCount;
        }

        @Override
        public final java.lang.Boolean getIgnoreErrorOnMissingContext() {
            return this.ignoreErrorOnMissingContext;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getPropertyMatch() {
            return this.propertyMatch;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssumeRoleAdditionalOptions() {
            return this.assumeRoleAdditionalOptions;
        }

        @Override
        public final java.lang.String getLookupRoleArn() {
            return this.lookupRoleArn;
        }

        @Override
        public final java.lang.String getLookupRoleExternalId() {
            return this.lookupRoleExternalId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("propertiesToReturn", om.valueToTree(this.getPropertiesToReturn()));
            data.set("typeName", om.valueToTree(this.getTypeName()));
            if (this.getDummyValue() != null) {
                data.set("dummyValue", om.valueToTree(this.getDummyValue()));
            }
            if (this.getExactIdentifier() != null) {
                data.set("exactIdentifier", om.valueToTree(this.getExactIdentifier()));
            }
            if (this.getExpectedMatchCount() != null) {
                data.set("expectedMatchCount", om.valueToTree(this.getExpectedMatchCount()));
            }
            if (this.getIgnoreErrorOnMissingContext() != null) {
                data.set("ignoreErrorOnMissingContext", om.valueToTree(this.getIgnoreErrorOnMissingContext()));
            }
            if (this.getPropertyMatch() != null) {
                data.set("propertyMatch", om.valueToTree(this.getPropertyMatch()));
            }
            data.set("account", om.valueToTree(this.getAccount()));
            data.set("region", om.valueToTree(this.getRegion()));
            if (this.getAssumeRoleAdditionalOptions() != null) {
                data.set("assumeRoleAdditionalOptions", om.valueToTree(this.getAssumeRoleAdditionalOptions()));
            }
            if (this.getLookupRoleArn() != null) {
                data.set("lookupRoleArn", om.valueToTree(this.getLookupRoleArn()));
            }
            if (this.getLookupRoleExternalId() != null) {
                data.set("lookupRoleExternalId", om.valueToTree(this.getLookupRoleExternalId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.CcApiContextQuery"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CcApiContextQuery.Jsii$Proxy that = (CcApiContextQuery.Jsii$Proxy) o;

            if (!propertiesToReturn.equals(that.propertiesToReturn)) return false;
            if (!typeName.equals(that.typeName)) return false;
            if (this.dummyValue != null ? !this.dummyValue.equals(that.dummyValue) : that.dummyValue != null) return false;
            if (this.exactIdentifier != null ? !this.exactIdentifier.equals(that.exactIdentifier) : that.exactIdentifier != null) return false;
            if (this.expectedMatchCount != null ? !this.expectedMatchCount.equals(that.expectedMatchCount) : that.expectedMatchCount != null) return false;
            if (this.ignoreErrorOnMissingContext != null ? !this.ignoreErrorOnMissingContext.equals(that.ignoreErrorOnMissingContext) : that.ignoreErrorOnMissingContext != null) return false;
            if (this.propertyMatch != null ? !this.propertyMatch.equals(that.propertyMatch) : that.propertyMatch != null) return false;
            if (!account.equals(that.account)) return false;
            if (!region.equals(that.region)) return false;
            if (this.assumeRoleAdditionalOptions != null ? !this.assumeRoleAdditionalOptions.equals(that.assumeRoleAdditionalOptions) : that.assumeRoleAdditionalOptions != null) return false;
            if (this.lookupRoleArn != null ? !this.lookupRoleArn.equals(that.lookupRoleArn) : that.lookupRoleArn != null) return false;
            return this.lookupRoleExternalId != null ? this.lookupRoleExternalId.equals(that.lookupRoleExternalId) : that.lookupRoleExternalId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.propertiesToReturn.hashCode();
            result = 31 * result + (this.typeName.hashCode());
            result = 31 * result + (this.dummyValue != null ? this.dummyValue.hashCode() : 0);
            result = 31 * result + (this.exactIdentifier != null ? this.exactIdentifier.hashCode() : 0);
            result = 31 * result + (this.expectedMatchCount != null ? this.expectedMatchCount.hashCode() : 0);
            result = 31 * result + (this.ignoreErrorOnMissingContext != null ? this.ignoreErrorOnMissingContext.hashCode() : 0);
            result = 31 * result + (this.propertyMatch != null ? this.propertyMatch.hashCode() : 0);
            result = 31 * result + (this.account.hashCode());
            result = 31 * result + (this.region.hashCode());
            result = 31 * result + (this.assumeRoleAdditionalOptions != null ? this.assumeRoleAdditionalOptions.hashCode() : 0);
            result = 31 * result + (this.lookupRoleArn != null ? this.lookupRoleArn.hashCode() : 0);
            result = 31 * result + (this.lookupRoleExternalId != null ? this.lookupRoleExternalId.hashCode() : 0);
            return result;
        }
    }
}
