package software.amazon.awscdk.pipelines;

/**
 * Construction properties for a <code>ManualApprovalStep</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodePipeline pipeline;
 * MyApplicationStage preprod = new MyApplicationStage(this, "PreProd");
 * MyApplicationStage prod = new MyApplicationStage(this, "Prod");
 * Topic topic = new Topic(this, "ChangeApprovalTopic");
 * pipeline.addStage(preprod, AddStageOpts.builder()
 *         .post(List.of(
 *             ShellStep.Builder.create("Validate Endpoint")
 *                     .commands(List.of("curl -Ssf https://my.webservice.com/"))
 *                     .build()))
 *         .build());
 * pipeline.addStage(prod, AddStageOpts.builder()
 *         .pre(List.of(ManualApprovalStep.Builder.create("PromoteToProd")
 *                 //All options below are optional
 *                 .comment("Please validate changes")
 *                 .reviewUrl("https://my.webservice.com/")
 *                 .notificationTopic(topic)
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:46.512Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.ManualApprovalStepProps")
@software.amazon.jsii.Jsii.Proxy(ManualApprovalStepProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ManualApprovalStepProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The comment to display with this manual approval.
     * <p>
     * Default: - No comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * Optional SNS topic to send notifications to when an approval is pending.
     * <p>
     * Default: - No notifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ITopic getNotificationTopic() {
        return null;
    }

    /**
     * The URL for review associated with this manual approval.
     * <p>
     * Default: - No URL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReviewUrl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ManualApprovalStepProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ManualApprovalStepProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ManualApprovalStepProps> {
        java.lang.String comment;
        software.amazon.awscdk.services.sns.ITopic notificationTopic;
        java.lang.String reviewUrl;

        /**
         * Sets the value of {@link ManualApprovalStepProps#getComment}
         * @param comment The comment to display with this manual approval.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link ManualApprovalStepProps#getNotificationTopic}
         * @param notificationTopic Optional SNS topic to send notifications to when an approval is pending.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTopic(software.amazon.awscdk.services.sns.ITopic notificationTopic) {
            this.notificationTopic = notificationTopic;
            return this;
        }

        /**
         * Sets the value of {@link ManualApprovalStepProps#getReviewUrl}
         * @param reviewUrl The URL for review associated with this manual approval.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reviewUrl(java.lang.String reviewUrl) {
            this.reviewUrl = reviewUrl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ManualApprovalStepProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ManualApprovalStepProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ManualApprovalStepProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManualApprovalStepProps {
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.sns.ITopic notificationTopic;
        private final java.lang.String reviewUrl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.notificationTopic = software.amazon.jsii.Kernel.get(this, "notificationTopic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
            this.reviewUrl = software.amazon.jsii.Kernel.get(this, "reviewUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.comment = builder.comment;
            this.notificationTopic = builder.notificationTopic;
            this.reviewUrl = builder.reviewUrl;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.sns.ITopic getNotificationTopic() {
            return this.notificationTopic;
        }

        @Override
        public final java.lang.String getReviewUrl() {
            return this.reviewUrl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getNotificationTopic() != null) {
                data.set("notificationTopic", om.valueToTree(this.getNotificationTopic()));
            }
            if (this.getReviewUrl() != null) {
                data.set("reviewUrl", om.valueToTree(this.getReviewUrl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.ManualApprovalStepProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ManualApprovalStepProps.Jsii$Proxy that = (ManualApprovalStepProps.Jsii$Proxy) o;

            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.notificationTopic != null ? !this.notificationTopic.equals(that.notificationTopic) : that.notificationTopic != null) return false;
            return this.reviewUrl != null ? this.reviewUrl.equals(that.reviewUrl) : that.reviewUrl == null;
        }

        @Override
        public final int hashCode() {
            int result = this.comment != null ? this.comment.hashCode() : 0;
            result = 31 * result + (this.notificationTopic != null ? this.notificationTopic.hashCode() : 0);
            result = 31 * result + (this.reviewUrl != null ? this.reviewUrl.hashCode() : 0);
            return result;
        }
    }
}
