package software.amazon.awscdk.services.amplify;

/**
 * Properties for defining a <code>CfnBranch</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.amplify.*;
 * CfnBranchProps cfnBranchProps = CfnBranchProps.builder()
 *         .appId("appId")
 *         .branchName("branchName")
 *         // the properties below are optional
 *         .backend(BackendProperty.builder()
 *                 .stackArn("stackArn")
 *                 .build())
 *         .basicAuthConfig(BasicAuthConfigProperty.builder()
 *                 .password("password")
 *                 .username("username")
 *                 // the properties below are optional
 *                 .enableBasicAuth(false)
 *                 .build())
 *         .buildSpec("buildSpec")
 *         .computeRoleArn("computeRoleArn")
 *         .description("description")
 *         .enableAutoBuild(false)
 *         .enablePerformanceMode(false)
 *         .enablePullRequestPreview(false)
 *         .enableSkewProtection(false)
 *         .environmentVariables(List.of(EnvironmentVariableProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .framework("framework")
 *         .pullRequestEnvironmentName("pullRequestEnvironmentName")
 *         .stage("stage")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:29.936Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplify.CfnBranchProps")
@software.amazon.jsii.Jsii.Proxy(CfnBranchProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnBranchProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique ID for an Amplify app.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-appid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-appid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAppId();

    /**
     * The name for the branch.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-branchname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-branchname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBranchName();

    /**
     * The backend for a <code>Branch</code> of an Amplify app. Use for a backend created from an AWS CloudFormation stack.
     * <p>
     * This field is available to Amplify Gen 2 apps only. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-backend">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-backend</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBackend() {
        return null;
    }

    /**
     * The basic authorization credentials for a branch of an Amplify app.
     * <p>
     * You must base64-encode the authorization credentials and provide them in the format <code>user:password</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-basicauthconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-basicauthconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBasicAuthConfig() {
        return null;
    }

    /**
     * The build specification (build spec) for the branch.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-buildspec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-buildspec</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBuildSpec() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role to assign to a branch of an SSR app.
     * <p>
     * The SSR Compute role allows the Amplify Hosting compute service to securely access specific AWS resources based on the role's permissions. For more information about the SSR Compute role, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html">Adding an SSR Compute role</a> in the <em>Amplify User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-computerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-computerolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComputeRoleArn() {
        return null;
    }

    /**
     * The description for the branch that is part of an Amplify app.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Enables auto building for the branch.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enableautobuild">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enableautobuild</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableAutoBuild() {
        return null;
    }

    /**
     * Enables performance mode for the branch.
     * <p>
     * Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enableperformancemode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enableperformancemode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnablePerformanceMode() {
        return null;
    }

    /**
     * Specifies whether Amplify Hosting creates a preview for each pull request that is made for this branch.
     * <p>
     * If this property is enabled, Amplify deploys your app to a unique preview URL after each pull request is opened. Development and QA teams can use this preview to test the pull request before it's merged into a production or integration branch.
     * <p>
     * To provide backend support for your preview, Amplify automatically provisions a temporary backend environment that it deletes when the pull request is closed. If you want to specify a dedicated backend environment for your previews, use the <code>PullRequestEnvironmentName</code> property.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/pr-previews.html">Web Previews</a> in the <em>AWS Amplify Hosting User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enablepullrequestpreview">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enablepullrequestpreview</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnablePullRequestPreview() {
        return null;
    }

    /**
     * Specifies whether the skew protection feature is enabled for the branch.
     * <p>
     * Deployment skew protection is available to Amplify applications to eliminate version skew issues between client and servers in web applications. When you apply skew protection to a branch, you can ensure that your clients always interact with the correct version of server-side assets, regardless of when a deployment occurs. For more information about skew protection, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/skew-protection.html">Skew protection for Amplify deployments</a> in the <em>Amplify User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enableskewprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enableskewprotection</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableSkewProtection() {
        return null;
    }

    /**
     * The environment variables for the branch.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-environmentvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-environmentvariables</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentVariables() {
        return null;
    }

    /**
     * The framework for the branch.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-framework">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-framework</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFramework() {
        return null;
    }

    /**
     * If pull request previews are enabled for this branch, you can use this property to specify a dedicated backend environment for your previews.
     * <p>
     * For example, you could specify an environment named <code>prod</code> , <code>test</code> , or <code>dev</code> that you initialized with the Amplify CLI and mapped to this branch.
     * <p>
     * To enable pull request previews, set the <code>EnablePullRequestPreview</code> property to <code>true</code> .
     * <p>
     * If you don't specify an environment, Amplify Hosting provides backend support for each preview by automatically provisioning a temporary backend environment. Amplify Hosting deletes this environment when the pull request is closed.
     * <p>
     * For more information about creating backend environments, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/multi-environments.html">Feature Branch Deployments and Team Workflows</a> in the <em>AWS Amplify Hosting User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-pullrequestenvironmentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-pullrequestenvironmentname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPullRequestEnvironmentName() {
        return null;
    }

    /**
     * Describes the current stage for the branch.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-stage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-stage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStage() {
        return null;
    }

    /**
     * The tag for the branch.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnBranchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBranchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnBranchProps> {
        java.lang.String appId;
        java.lang.String branchName;
        java.lang.Object backend;
        java.lang.Object basicAuthConfig;
        java.lang.String buildSpec;
        java.lang.String computeRoleArn;
        java.lang.String description;
        java.lang.Object enableAutoBuild;
        java.lang.Object enablePerformanceMode;
        java.lang.Object enablePullRequestPreview;
        java.lang.Object enableSkewProtection;
        java.lang.Object environmentVariables;
        java.lang.String framework;
        java.lang.String pullRequestEnvironmentName;
        java.lang.String stage;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnBranchProps#getAppId}
         * @param appId The unique ID for an Amplify app. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appId(java.lang.String appId) {
            this.appId = appId;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getBranchName}
         * @param branchName The name for the branch. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branchName(java.lang.String branchName) {
            this.branchName = branchName;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getBackend}
         * @param backend The backend for a <code>Branch</code> of an Amplify app. Use for a backend created from an AWS CloudFormation stack.
         *                This field is available to Amplify Gen 2 apps only. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backend(software.amazon.awscdk.IResolvable backend) {
            this.backend = backend;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getBackend}
         * @param backend The backend for a <code>Branch</code> of an Amplify app. Use for a backend created from an AWS CloudFormation stack.
         *                This field is available to Amplify Gen 2 apps only. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backend(software.amazon.awscdk.services.amplify.CfnBranch.BackendProperty backend) {
            this.backend = backend;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getBasicAuthConfig}
         * @param basicAuthConfig The basic authorization credentials for a branch of an Amplify app.
         *                        You must base64-encode the authorization credentials and provide them in the format <code>user:password</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder basicAuthConfig(software.amazon.awscdk.IResolvable basicAuthConfig) {
            this.basicAuthConfig = basicAuthConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getBasicAuthConfig}
         * @param basicAuthConfig The basic authorization credentials for a branch of an Amplify app.
         *                        You must base64-encode the authorization credentials and provide them in the format <code>user:password</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder basicAuthConfig(software.amazon.awscdk.services.amplify.CfnBranch.BasicAuthConfigProperty basicAuthConfig) {
            this.basicAuthConfig = basicAuthConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getBuildSpec}
         * @param buildSpec The build specification (build spec) for the branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildSpec(java.lang.String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getComputeRoleArn}
         * @param computeRoleArn The Amazon Resource Name (ARN) of the IAM role to assign to a branch of an SSR app.
         *                       The SSR Compute role allows the Amplify Hosting compute service to securely access specific AWS resources based on the role's permissions. For more information about the SSR Compute role, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html">Adding an SSR Compute role</a> in the <em>Amplify User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeRoleArn(java.lang.String computeRoleArn) {
            this.computeRoleArn = computeRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getDescription}
         * @param description The description for the branch that is part of an Amplify app.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getEnableAutoBuild}
         * @param enableAutoBuild Enables auto building for the branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAutoBuild(java.lang.Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getEnableAutoBuild}
         * @param enableAutoBuild Enables auto building for the branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAutoBuild(software.amazon.awscdk.IResolvable enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getEnablePerformanceMode}
         * @param enablePerformanceMode Enables performance mode for the branch.
         *                              Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceMode(java.lang.Boolean enablePerformanceMode) {
            this.enablePerformanceMode = enablePerformanceMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getEnablePerformanceMode}
         * @param enablePerformanceMode Enables performance mode for the branch.
         *                              Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePerformanceMode(software.amazon.awscdk.IResolvable enablePerformanceMode) {
            this.enablePerformanceMode = enablePerformanceMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getEnablePullRequestPreview}
         * @param enablePullRequestPreview Specifies whether Amplify Hosting creates a preview for each pull request that is made for this branch.
         *                                 If this property is enabled, Amplify deploys your app to a unique preview URL after each pull request is opened. Development and QA teams can use this preview to test the pull request before it's merged into a production or integration branch.
         *                                 <p>
         *                                 To provide backend support for your preview, Amplify automatically provisions a temporary backend environment that it deletes when the pull request is closed. If you want to specify a dedicated backend environment for your previews, use the <code>PullRequestEnvironmentName</code> property.
         *                                 <p>
         *                                 For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/pr-previews.html">Web Previews</a> in the <em>AWS Amplify Hosting User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePullRequestPreview(java.lang.Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getEnablePullRequestPreview}
         * @param enablePullRequestPreview Specifies whether Amplify Hosting creates a preview for each pull request that is made for this branch.
         *                                 If this property is enabled, Amplify deploys your app to a unique preview URL after each pull request is opened. Development and QA teams can use this preview to test the pull request before it's merged into a production or integration branch.
         *                                 <p>
         *                                 To provide backend support for your preview, Amplify automatically provisions a temporary backend environment that it deletes when the pull request is closed. If you want to specify a dedicated backend environment for your previews, use the <code>PullRequestEnvironmentName</code> property.
         *                                 <p>
         *                                 For more information, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/pr-previews.html">Web Previews</a> in the <em>AWS Amplify Hosting User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enablePullRequestPreview(software.amazon.awscdk.IResolvable enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getEnableSkewProtection}
         * @param enableSkewProtection Specifies whether the skew protection feature is enabled for the branch.
         *                             Deployment skew protection is available to Amplify applications to eliminate version skew issues between client and servers in web applications. When you apply skew protection to a branch, you can ensure that your clients always interact with the correct version of server-side assets, regardless of when a deployment occurs. For more information about skew protection, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/skew-protection.html">Skew protection for Amplify deployments</a> in the <em>Amplify User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableSkewProtection(java.lang.Boolean enableSkewProtection) {
            this.enableSkewProtection = enableSkewProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getEnableSkewProtection}
         * @param enableSkewProtection Specifies whether the skew protection feature is enabled for the branch.
         *                             Deployment skew protection is available to Amplify applications to eliminate version skew issues between client and servers in web applications. When you apply skew protection to a branch, you can ensure that your clients always interact with the correct version of server-side assets, regardless of when a deployment occurs. For more information about skew protection, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/skew-protection.html">Skew protection for Amplify deployments</a> in the <em>Amplify User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableSkewProtection(software.amazon.awscdk.IResolvable enableSkewProtection) {
            this.enableSkewProtection = enableSkewProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getEnvironmentVariables}
         * @param environmentVariables The environment variables for the branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(software.amazon.awscdk.IResolvable environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getEnvironmentVariables}
         * @param environmentVariables The environment variables for the branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(java.util.List<? extends java.lang.Object> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getFramework}
         * @param framework The framework for the branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder framework(java.lang.String framework) {
            this.framework = framework;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getPullRequestEnvironmentName}
         * @param pullRequestEnvironmentName If pull request previews are enabled for this branch, you can use this property to specify a dedicated backend environment for your previews.
         *                                   For example, you could specify an environment named <code>prod</code> , <code>test</code> , or <code>dev</code> that you initialized with the Amplify CLI and mapped to this branch.
         *                                   <p>
         *                                   To enable pull request previews, set the <code>EnablePullRequestPreview</code> property to <code>true</code> .
         *                                   <p>
         *                                   If you don't specify an environment, Amplify Hosting provides backend support for each preview by automatically provisioning a temporary backend environment. Amplify Hosting deletes this environment when the pull request is closed.
         *                                   <p>
         *                                   For more information about creating backend environments, see <a href="https://docs.aws.amazon.com/amplify/latest/userguide/multi-environments.html">Feature Branch Deployments and Team Workflows</a> in the <em>AWS Amplify Hosting User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pullRequestEnvironmentName(java.lang.String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getStage}
         * @param stage Describes the current stage for the branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stage(java.lang.String stage) {
            this.stage = stage;
            return this;
        }

        /**
         * Sets the value of {@link CfnBranchProps#getTags}
         * @param tags The tag for the branch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBranchProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnBranchProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnBranchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBranchProps {
        private final java.lang.String appId;
        private final java.lang.String branchName;
        private final java.lang.Object backend;
        private final java.lang.Object basicAuthConfig;
        private final java.lang.String buildSpec;
        private final java.lang.String computeRoleArn;
        private final java.lang.String description;
        private final java.lang.Object enableAutoBuild;
        private final java.lang.Object enablePerformanceMode;
        private final java.lang.Object enablePullRequestPreview;
        private final java.lang.Object enableSkewProtection;
        private final java.lang.Object environmentVariables;
        private final java.lang.String framework;
        private final java.lang.String pullRequestEnvironmentName;
        private final java.lang.String stage;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appId = software.amazon.jsii.Kernel.get(this, "appId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.branchName = software.amazon.jsii.Kernel.get(this, "branchName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.backend = software.amazon.jsii.Kernel.get(this, "backend", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.basicAuthConfig = software.amazon.jsii.Kernel.get(this, "basicAuthConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.buildSpec = software.amazon.jsii.Kernel.get(this, "buildSpec", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.computeRoleArn = software.amazon.jsii.Kernel.get(this, "computeRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableAutoBuild = software.amazon.jsii.Kernel.get(this, "enableAutoBuild", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enablePerformanceMode = software.amazon.jsii.Kernel.get(this, "enablePerformanceMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enablePullRequestPreview = software.amazon.jsii.Kernel.get(this, "enablePullRequestPreview", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableSkewProtection = software.amazon.jsii.Kernel.get(this, "enableSkewProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.framework = software.amazon.jsii.Kernel.get(this, "framework", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pullRequestEnvironmentName = software.amazon.jsii.Kernel.get(this, "pullRequestEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stage = software.amazon.jsii.Kernel.get(this, "stage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appId = java.util.Objects.requireNonNull(builder.appId, "appId is required");
            this.branchName = java.util.Objects.requireNonNull(builder.branchName, "branchName is required");
            this.backend = builder.backend;
            this.basicAuthConfig = builder.basicAuthConfig;
            this.buildSpec = builder.buildSpec;
            this.computeRoleArn = builder.computeRoleArn;
            this.description = builder.description;
            this.enableAutoBuild = builder.enableAutoBuild;
            this.enablePerformanceMode = builder.enablePerformanceMode;
            this.enablePullRequestPreview = builder.enablePullRequestPreview;
            this.enableSkewProtection = builder.enableSkewProtection;
            this.environmentVariables = builder.environmentVariables;
            this.framework = builder.framework;
            this.pullRequestEnvironmentName = builder.pullRequestEnvironmentName;
            this.stage = builder.stage;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAppId() {
            return this.appId;
        }

        @Override
        public final java.lang.String getBranchName() {
            return this.branchName;
        }

        @Override
        public final java.lang.Object getBackend() {
            return this.backend;
        }

        @Override
        public final java.lang.Object getBasicAuthConfig() {
            return this.basicAuthConfig;
        }

        @Override
        public final java.lang.String getBuildSpec() {
            return this.buildSpec;
        }

        @Override
        public final java.lang.String getComputeRoleArn() {
            return this.computeRoleArn;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getEnableAutoBuild() {
            return this.enableAutoBuild;
        }

        @Override
        public final java.lang.Object getEnablePerformanceMode() {
            return this.enablePerformanceMode;
        }

        @Override
        public final java.lang.Object getEnablePullRequestPreview() {
            return this.enablePullRequestPreview;
        }

        @Override
        public final java.lang.Object getEnableSkewProtection() {
            return this.enableSkewProtection;
        }

        @Override
        public final java.lang.Object getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final java.lang.String getFramework() {
            return this.framework;
        }

        @Override
        public final java.lang.String getPullRequestEnvironmentName() {
            return this.pullRequestEnvironmentName;
        }

        @Override
        public final java.lang.String getStage() {
            return this.stage;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("appId", om.valueToTree(this.getAppId()));
            data.set("branchName", om.valueToTree(this.getBranchName()));
            if (this.getBackend() != null) {
                data.set("backend", om.valueToTree(this.getBackend()));
            }
            if (this.getBasicAuthConfig() != null) {
                data.set("basicAuthConfig", om.valueToTree(this.getBasicAuthConfig()));
            }
            if (this.getBuildSpec() != null) {
                data.set("buildSpec", om.valueToTree(this.getBuildSpec()));
            }
            if (this.getComputeRoleArn() != null) {
                data.set("computeRoleArn", om.valueToTree(this.getComputeRoleArn()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnableAutoBuild() != null) {
                data.set("enableAutoBuild", om.valueToTree(this.getEnableAutoBuild()));
            }
            if (this.getEnablePerformanceMode() != null) {
                data.set("enablePerformanceMode", om.valueToTree(this.getEnablePerformanceMode()));
            }
            if (this.getEnablePullRequestPreview() != null) {
                data.set("enablePullRequestPreview", om.valueToTree(this.getEnablePullRequestPreview()));
            }
            if (this.getEnableSkewProtection() != null) {
                data.set("enableSkewProtection", om.valueToTree(this.getEnableSkewProtection()));
            }
            if (this.getEnvironmentVariables() != null) {
                data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
            }
            if (this.getFramework() != null) {
                data.set("framework", om.valueToTree(this.getFramework()));
            }
            if (this.getPullRequestEnvironmentName() != null) {
                data.set("pullRequestEnvironmentName", om.valueToTree(this.getPullRequestEnvironmentName()));
            }
            if (this.getStage() != null) {
                data.set("stage", om.valueToTree(this.getStage()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplify.CfnBranchProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBranchProps.Jsii$Proxy that = (CfnBranchProps.Jsii$Proxy) o;

            if (!appId.equals(that.appId)) return false;
            if (!branchName.equals(that.branchName)) return false;
            if (this.backend != null ? !this.backend.equals(that.backend) : that.backend != null) return false;
            if (this.basicAuthConfig != null ? !this.basicAuthConfig.equals(that.basicAuthConfig) : that.basicAuthConfig != null) return false;
            if (this.buildSpec != null ? !this.buildSpec.equals(that.buildSpec) : that.buildSpec != null) return false;
            if (this.computeRoleArn != null ? !this.computeRoleArn.equals(that.computeRoleArn) : that.computeRoleArn != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enableAutoBuild != null ? !this.enableAutoBuild.equals(that.enableAutoBuild) : that.enableAutoBuild != null) return false;
            if (this.enablePerformanceMode != null ? !this.enablePerformanceMode.equals(that.enablePerformanceMode) : that.enablePerformanceMode != null) return false;
            if (this.enablePullRequestPreview != null ? !this.enablePullRequestPreview.equals(that.enablePullRequestPreview) : that.enablePullRequestPreview != null) return false;
            if (this.enableSkewProtection != null ? !this.enableSkewProtection.equals(that.enableSkewProtection) : that.enableSkewProtection != null) return false;
            if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
            if (this.framework != null ? !this.framework.equals(that.framework) : that.framework != null) return false;
            if (this.pullRequestEnvironmentName != null ? !this.pullRequestEnvironmentName.equals(that.pullRequestEnvironmentName) : that.pullRequestEnvironmentName != null) return false;
            if (this.stage != null ? !this.stage.equals(that.stage) : that.stage != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.appId.hashCode();
            result = 31 * result + (this.branchName.hashCode());
            result = 31 * result + (this.backend != null ? this.backend.hashCode() : 0);
            result = 31 * result + (this.basicAuthConfig != null ? this.basicAuthConfig.hashCode() : 0);
            result = 31 * result + (this.buildSpec != null ? this.buildSpec.hashCode() : 0);
            result = 31 * result + (this.computeRoleArn != null ? this.computeRoleArn.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enableAutoBuild != null ? this.enableAutoBuild.hashCode() : 0);
            result = 31 * result + (this.enablePerformanceMode != null ? this.enablePerformanceMode.hashCode() : 0);
            result = 31 * result + (this.enablePullRequestPreview != null ? this.enablePullRequestPreview.hashCode() : 0);
            result = 31 * result + (this.enableSkewProtection != null ? this.enableSkewProtection.hashCode() : 0);
            result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
            result = 31 * result + (this.framework != null ? this.framework.hashCode() : 0);
            result = 31 * result + (this.pullRequestEnvironmentName != null ? this.pullRequestEnvironmentName.hashCode() : 0);
            result = 31 * result + (this.stage != null ? this.stage.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
