package software.amazon.awscdk.services.apigateway;

/**
 * Supported IP Address Types.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * RestApi api = RestApi.Builder.create(this, "api")
 *         .endpointConfiguration(EndpointConfiguration.builder()
 *                 .types(List.of(EndpointType.REGIONAL))
 *                 .ipAddressType(IpAddressType.DUAL_STACK)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:30.170Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.IpAddressType")
public enum IpAddressType {
    /**
     * IPv4 address type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV4,
    /**
     * IPv4 and IPv6 address type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DUAL_STACK,
}
