package software.amazon.awscdk.services.apigatewayv2;

/**
 * Properties to initialize an instance of <code>HttpAuthorizer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * HttpApi httpApi;
 * HttpAuthorizerProps httpAuthorizerProps = HttpAuthorizerProps.builder()
 *         .httpApi(httpApi)
 *         .identitySource(List.of("identitySource"))
 *         .type(HttpAuthorizerType.IAM)
 *         // the properties below are optional
 *         .authorizerName("authorizerName")
 *         .authorizerUri("authorizerUri")
 *         .enableSimpleResponses(false)
 *         .jwtAudience(List.of("jwtAudience"))
 *         .jwtIssuer("jwtIssuer")
 *         .payloadFormatVersion(AuthorizerPayloadVersion.VERSION_1_0)
 *         .resultsCacheTtl(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:30.337Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.HttpAuthorizerProps")
@software.amazon.jsii.Jsii.Proxy(HttpAuthorizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpAuthorizerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * HTTP Api to attach the authorizer to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IHttpApi getHttpApi();

    /**
     * The identity source for which authorization is requested.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getIdentitySource();

    /**
     * The type of authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpAuthorizerType getType();

    /**
     * Name of the authorizer.
     * <p>
     * Default: - id of the HttpAuthorizer construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerName() {
        return null;
    }

    /**
     * The authorizer's Uniform Resource Identifier (URI).
     * <p>
     * For REQUEST authorizers, this must be a well-formed Lambda function URI.
     * <p>
     * Default: - required for Request authorizer types
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerUri() {
        return null;
    }

    /**
     * Specifies whether a Lambda authorizer returns a response in a simple format.
     * <p>
     * If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy.
     * <p>
     * Default: - The lambda authorizer must return an IAM policy as its response
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableSimpleResponses() {
        return null;
    }

    /**
     * A list of the intended recipients of the JWT.
     * <p>
     * A valid JWT must provide an aud that matches at least one entry in this list.
     * <p>
     * Default: - required for JWT authorizer typess.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getJwtAudience() {
        return null;
    }

    /**
     * The base domain of the identity provider that issues JWT.
     * <p>
     * Default: - required for JWT authorizer types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJwtIssuer() {
        return null;
    }

    /**
     * Specifies the format of the payload sent to an HTTP API Lambda authorizer.
     * <p>
     * Default: AuthorizerPayloadVersion.VERSION_2_0 if the authorizer type is HttpAuthorizerType.LAMBDA
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.AuthorizerPayloadVersion getPayloadFormatVersion() {
        return null;
    }

    /**
     * How long APIGateway should cache the results.
     * <p>
     * Max 1 hour.
     * <p>
     * Default: - API Gateway will not cache authorizer responses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getResultsCacheTtl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpAuthorizerProps> {
        software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi;
        java.util.List<java.lang.String> identitySource;
        software.amazon.awscdk.services.apigatewayv2.HttpAuthorizerType type;
        java.lang.String authorizerName;
        java.lang.String authorizerUri;
        java.lang.Boolean enableSimpleResponses;
        java.util.List<java.lang.String> jwtAudience;
        java.lang.String jwtIssuer;
        software.amazon.awscdk.services.apigatewayv2.AuthorizerPayloadVersion payloadFormatVersion;
        software.amazon.awscdk.Duration resultsCacheTtl;

        /**
         * Sets the value of {@link HttpAuthorizerProps#getHttpApi}
         * @param httpApi HTTP Api to attach the authorizer to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpApi(software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi) {
            this.httpApi = httpApi;
            return this;
        }

        /**
         * Sets the value of {@link HttpAuthorizerProps#getIdentitySource}
         * @param identitySource The identity source for which authorization is requested. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySource(java.util.List<java.lang.String> identitySource) {
            this.identitySource = identitySource;
            return this;
        }

        /**
         * Sets the value of {@link HttpAuthorizerProps#getType}
         * @param type The type of authorizer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.apigatewayv2.HttpAuthorizerType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link HttpAuthorizerProps#getAuthorizerName}
         * @param authorizerName Name of the authorizer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerName(java.lang.String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        /**
         * Sets the value of {@link HttpAuthorizerProps#getAuthorizerUri}
         * @param authorizerUri The authorizer's Uniform Resource Identifier (URI).
         *                      For REQUEST authorizers, this must be a well-formed Lambda function URI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerUri(java.lang.String authorizerUri) {
            this.authorizerUri = authorizerUri;
            return this;
        }

        /**
         * Sets the value of {@link HttpAuthorizerProps#getEnableSimpleResponses}
         * @param enableSimpleResponses Specifies whether a Lambda authorizer returns a response in a simple format.
         *                              If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableSimpleResponses(java.lang.Boolean enableSimpleResponses) {
            this.enableSimpleResponses = enableSimpleResponses;
            return this;
        }

        /**
         * Sets the value of {@link HttpAuthorizerProps#getJwtAudience}
         * @param jwtAudience A list of the intended recipients of the JWT.
         *                    A valid JWT must provide an aud that matches at least one entry in this list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jwtAudience(java.util.List<java.lang.String> jwtAudience) {
            this.jwtAudience = jwtAudience;
            return this;
        }

        /**
         * Sets the value of {@link HttpAuthorizerProps#getJwtIssuer}
         * @param jwtIssuer The base domain of the identity provider that issues JWT.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jwtIssuer(java.lang.String jwtIssuer) {
            this.jwtIssuer = jwtIssuer;
            return this;
        }

        /**
         * Sets the value of {@link HttpAuthorizerProps#getPayloadFormatVersion}
         * @param payloadFormatVersion Specifies the format of the payload sent to an HTTP API Lambda authorizer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder payloadFormatVersion(software.amazon.awscdk.services.apigatewayv2.AuthorizerPayloadVersion payloadFormatVersion) {
            this.payloadFormatVersion = payloadFormatVersion;
            return this;
        }

        /**
         * Sets the value of {@link HttpAuthorizerProps#getResultsCacheTtl}
         * @param resultsCacheTtl How long APIGateway should cache the results.
         *                        Max 1 hour.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultsCacheTtl(software.amazon.awscdk.Duration resultsCacheTtl) {
            this.resultsCacheTtl = resultsCacheTtl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpAuthorizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpAuthorizerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpAuthorizerProps {
        private final software.amazon.awscdk.services.apigatewayv2.IHttpApi httpApi;
        private final java.util.List<java.lang.String> identitySource;
        private final software.amazon.awscdk.services.apigatewayv2.HttpAuthorizerType type;
        private final java.lang.String authorizerName;
        private final java.lang.String authorizerUri;
        private final java.lang.Boolean enableSimpleResponses;
        private final java.util.List<java.lang.String> jwtAudience;
        private final java.lang.String jwtIssuer;
        private final software.amazon.awscdk.services.apigatewayv2.AuthorizerPayloadVersion payloadFormatVersion;
        private final software.amazon.awscdk.Duration resultsCacheTtl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpApi = software.amazon.jsii.Kernel.get(this, "httpApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IHttpApi.class));
            this.identitySource = software.amazon.jsii.Kernel.get(this, "identitySource", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpAuthorizerType.class));
            this.authorizerName = software.amazon.jsii.Kernel.get(this, "authorizerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizerUri = software.amazon.jsii.Kernel.get(this, "authorizerUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableSimpleResponses = software.amazon.jsii.Kernel.get(this, "enableSimpleResponses", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.jwtAudience = software.amazon.jsii.Kernel.get(this, "jwtAudience", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.jwtIssuer = software.amazon.jsii.Kernel.get(this, "jwtIssuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.payloadFormatVersion = software.amazon.jsii.Kernel.get(this, "payloadFormatVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.AuthorizerPayloadVersion.class));
            this.resultsCacheTtl = software.amazon.jsii.Kernel.get(this, "resultsCacheTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpApi = java.util.Objects.requireNonNull(builder.httpApi, "httpApi is required");
            this.identitySource = java.util.Objects.requireNonNull(builder.identitySource, "identitySource is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.authorizerName = builder.authorizerName;
            this.authorizerUri = builder.authorizerUri;
            this.enableSimpleResponses = builder.enableSimpleResponses;
            this.jwtAudience = builder.jwtAudience;
            this.jwtIssuer = builder.jwtIssuer;
            this.payloadFormatVersion = builder.payloadFormatVersion;
            this.resultsCacheTtl = builder.resultsCacheTtl;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IHttpApi getHttpApi() {
            return this.httpApi;
        }

        @Override
        public final java.util.List<java.lang.String> getIdentitySource() {
            return this.identitySource;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpAuthorizerType getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getAuthorizerName() {
            return this.authorizerName;
        }

        @Override
        public final java.lang.String getAuthorizerUri() {
            return this.authorizerUri;
        }

        @Override
        public final java.lang.Boolean getEnableSimpleResponses() {
            return this.enableSimpleResponses;
        }

        @Override
        public final java.util.List<java.lang.String> getJwtAudience() {
            return this.jwtAudience;
        }

        @Override
        public final java.lang.String getJwtIssuer() {
            return this.jwtIssuer;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.AuthorizerPayloadVersion getPayloadFormatVersion() {
            return this.payloadFormatVersion;
        }

        @Override
        public final software.amazon.awscdk.Duration getResultsCacheTtl() {
            return this.resultsCacheTtl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("httpApi", om.valueToTree(this.getHttpApi()));
            data.set("identitySource", om.valueToTree(this.getIdentitySource()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getAuthorizerName() != null) {
                data.set("authorizerName", om.valueToTree(this.getAuthorizerName()));
            }
            if (this.getAuthorizerUri() != null) {
                data.set("authorizerUri", om.valueToTree(this.getAuthorizerUri()));
            }
            if (this.getEnableSimpleResponses() != null) {
                data.set("enableSimpleResponses", om.valueToTree(this.getEnableSimpleResponses()));
            }
            if (this.getJwtAudience() != null) {
                data.set("jwtAudience", om.valueToTree(this.getJwtAudience()));
            }
            if (this.getJwtIssuer() != null) {
                data.set("jwtIssuer", om.valueToTree(this.getJwtIssuer()));
            }
            if (this.getPayloadFormatVersion() != null) {
                data.set("payloadFormatVersion", om.valueToTree(this.getPayloadFormatVersion()));
            }
            if (this.getResultsCacheTtl() != null) {
                data.set("resultsCacheTtl", om.valueToTree(this.getResultsCacheTtl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.HttpAuthorizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpAuthorizerProps.Jsii$Proxy that = (HttpAuthorizerProps.Jsii$Proxy) o;

            if (!httpApi.equals(that.httpApi)) return false;
            if (!identitySource.equals(that.identitySource)) return false;
            if (!type.equals(that.type)) return false;
            if (this.authorizerName != null ? !this.authorizerName.equals(that.authorizerName) : that.authorizerName != null) return false;
            if (this.authorizerUri != null ? !this.authorizerUri.equals(that.authorizerUri) : that.authorizerUri != null) return false;
            if (this.enableSimpleResponses != null ? !this.enableSimpleResponses.equals(that.enableSimpleResponses) : that.enableSimpleResponses != null) return false;
            if (this.jwtAudience != null ? !this.jwtAudience.equals(that.jwtAudience) : that.jwtAudience != null) return false;
            if (this.jwtIssuer != null ? !this.jwtIssuer.equals(that.jwtIssuer) : that.jwtIssuer != null) return false;
            if (this.payloadFormatVersion != null ? !this.payloadFormatVersion.equals(that.payloadFormatVersion) : that.payloadFormatVersion != null) return false;
            return this.resultsCacheTtl != null ? this.resultsCacheTtl.equals(that.resultsCacheTtl) : that.resultsCacheTtl == null;
        }

        @Override
        public final int hashCode() {
            int result = this.httpApi.hashCode();
            result = 31 * result + (this.identitySource.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.authorizerName != null ? this.authorizerName.hashCode() : 0);
            result = 31 * result + (this.authorizerUri != null ? this.authorizerUri.hashCode() : 0);
            result = 31 * result + (this.enableSimpleResponses != null ? this.enableSimpleResponses.hashCode() : 0);
            result = 31 * result + (this.jwtAudience != null ? this.jwtAudience.hashCode() : 0);
            result = 31 * result + (this.jwtIssuer != null ? this.jwtIssuer.hashCode() : 0);
            result = 31 * result + (this.payloadFormatVersion != null ? this.payloadFormatVersion.hashCode() : 0);
            result = 31 * result + (this.resultsCacheTtl != null ? this.resultsCacheTtl.hashCode() : 0);
            return result;
        }
    }
}
