package software.amazon.awscdk.services.appmesh;

/**
 * VirtualGateway represents a newly defined App Mesh Virtual Gateway.
 * <p>
 * A virtual gateway allows resources that are outside of your mesh to communicate to resources that
 * are inside of your mesh.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // A Virtual Node with a gRPC listener with a connection pool set
 * Mesh mesh;
 * VirtualNode node = VirtualNode.Builder.create(this, "node")
 *         .mesh(mesh)
 *         // DNS service discovery can optionally specify the DNS response type as either LOAD_BALANCER or ENDPOINTS.
 *         // LOAD_BALANCER means that the DNS resolver returns a loadbalanced set of endpoints,
 *         // whereas ENDPOINTS means that the DNS resolver is returning all the endpoints.
 *         // By default, the response type is assumed to be LOAD_BALANCER
 *         .serviceDiscovery(ServiceDiscovery.dns("node", DnsResponseType.ENDPOINTS))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .port(80)
 *                 .connectionPool(HttpConnectionPool.builder()
 *                         .maxConnections(100)
 *                         .maxPendingRequests(10)
 *                         .build())
 *                 .build())))
 *         .build();
 * // A Virtual Gateway with a gRPC listener with a connection pool set
 * VirtualGateway gateway = VirtualGateway.Builder.create(this, "gateway")
 *         .mesh(mesh)
 *         .listeners(List.of(VirtualGatewayListener.grpc(GrpcGatewayListenerOptions.builder()
 *                 .port(8080)
 *                 .connectionPool(GrpcConnectionPool.builder()
 *                         .maxRequests(10)
 *                         .build())
 *                 .build())))
 *         .virtualGatewayName("gateway")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html">https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:30.936Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualGateway")
public class VirtualGateway extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.appmesh.IVirtualGateway {

    protected VirtualGateway(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VirtualGateway(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appmesh.VirtualGateway.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public VirtualGateway(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualGatewayProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing VirtualGateway given an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param virtualGatewayArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualGateway fromVirtualGatewayArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String virtualGatewayArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualGateway.class, "fromVirtualGatewayArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualGateway.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(virtualGatewayArn, "virtualGatewayArn is required") });
    }

    /**
     * Import an existing VirtualGateway given its attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualGateway fromVirtualGatewayAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualGatewayAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualGateway.class, "fromVirtualGatewayAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualGateway.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Utility method to add a new GatewayRoute to the VirtualGateway.
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GatewayRoute addGatewayRoute(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.GatewayRouteBaseProps props) {
        return software.amazon.jsii.Kernel.call(this, "addGatewayRoute", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GatewayRoute.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Grants the given entity <code>appmesh:StreamAggregatedResources</code>.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantStreamAggregatedResources(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantStreamAggregatedResources", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appmesh.VirtualGatewayListenerConfig> getListeners() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "listeners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualGatewayListenerConfig.class))));
    }

    /**
     * The Mesh that the VirtualGateway belongs to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IMesh getMesh() {
        return software.amazon.jsii.Kernel.get(this, "mesh", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IMesh.class));
    }

    /**
     * The Amazon Resource Name (ARN) for the VirtualGateway.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVirtualGatewayArn() {
        return software.amazon.jsii.Kernel.get(this, "virtualGatewayArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the VirtualGateway.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVirtualGatewayName() {
        return software.amazon.jsii.Kernel.get(this, "virtualGatewayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appmesh.VirtualGateway}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appmesh.VirtualGateway> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appmesh.VirtualGatewayProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appmesh.VirtualGatewayProps.Builder();
        }

        /**
         * Access Logging Configuration for the VirtualGateway.
         * <p>
         * Default: - no access logging
         * <p>
         * @return {@code this}
         * @param accessLog Access Logging Configuration for the VirtualGateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLog(final software.amazon.awscdk.services.appmesh.AccessLog accessLog) {
            this.props.accessLog(accessLog);
            return this;
        }

        /**
         * Default Configuration Virtual Node uses to communicate with Virtual Service.
         * <p>
         * Default: - No Config
         * <p>
         * @return {@code this}
         * @param backendDefaults Default Configuration Virtual Node uses to communicate with Virtual Service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backendDefaults(final software.amazon.awscdk.services.appmesh.BackendDefaults backendDefaults) {
            this.props.backendDefaults(backendDefaults);
            return this;
        }

        /**
         * Listeners for the VirtualGateway.
         * <p>
         * Only one is supported.
         * <p>
         * Default: - Single HTTP listener on port 8080
         * <p>
         * @return {@code this}
         * @param listeners Listeners for the VirtualGateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listeners(final java.util.List<? extends software.amazon.awscdk.services.appmesh.VirtualGatewayListener> listeners) {
            this.props.listeners(listeners);
            return this;
        }

        /**
         * Name of the VirtualGateway.
         * <p>
         * Default: - A name is automatically determined
         * <p>
         * @return {@code this}
         * @param virtualGatewayName Name of the VirtualGateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualGatewayName(final java.lang.String virtualGatewayName) {
            this.props.virtualGatewayName(virtualGatewayName);
            return this;
        }

        /**
         * The Mesh which the VirtualGateway belongs to.
         * <p>
         * @return {@code this}
         * @param mesh The Mesh which the VirtualGateway belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mesh(final software.amazon.awscdk.services.appmesh.IMesh mesh) {
            this.props.mesh(mesh);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appmesh.VirtualGateway}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appmesh.VirtualGateway build() {
            return new software.amazon.awscdk.services.appmesh.VirtualGateway(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
