package software.amazon.awscdk.services.appmesh;

/**
 * Represents the properties needed to define the provider for a VirtualService.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh;
 * VirtualNode node = VirtualNode.Builder.create(this, "node")
 *         .mesh(mesh)
 *         .serviceDiscovery(ServiceDiscovery.dns("node"))
 *         .build();
 * VirtualService virtualService = VirtualService.Builder.create(this, "service-1")
 *         .virtualServiceProvider(VirtualServiceProvider.virtualNode(node))
 *         .virtualServiceName("service1.domain.local")
 *         .build();
 * node.addBackend(Backend.virtualService(virtualService));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:30.959Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualServiceProvider")
public abstract class VirtualServiceProvider extends software.amazon.jsii.JsiiObject {

    protected VirtualServiceProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VirtualServiceProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected VirtualServiceProvider() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Returns an Empty Provider for a VirtualService.
     * <p>
     * This provides no routing capabilities
     * and should only be used as a placeholder
     * <p>
     * @param mesh This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualServiceProvider none(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IMesh mesh) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualServiceProvider.class, "none", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualServiceProvider.class), new Object[] { java.util.Objects.requireNonNull(mesh, "mesh is required") });
    }

    /**
     * Returns a VirtualNode based Provider for a VirtualService.
     * <p>
     * @param virtualNode This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualServiceProvider virtualNode(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualNode virtualNode) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualServiceProvider.class, "virtualNode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualServiceProvider.class), new Object[] { java.util.Objects.requireNonNull(virtualNode, "virtualNode is required") });
    }

    /**
     * Returns a VirtualRouter based Provider for a VirtualService.
     * <p>
     * @param virtualRouter This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualServiceProvider virtualRouter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualRouter virtualRouter) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualServiceProvider.class, "virtualRouter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualServiceProvider.class), new Object[] { java.util.Objects.requireNonNull(virtualRouter, "virtualRouter is required") });
    }

    /**
     * Enforces mutual exclusivity for VirtualService provider types.
     * <p>
     * @param _construct This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualServiceProviderConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _construct);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.VirtualServiceProvider {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Enforces mutual exclusivity for VirtualService provider types.
         * <p>
         * @param _construct This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualServiceProviderConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _construct) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualServiceProviderConfig.class), new Object[] { java.util.Objects.requireNonNull(_construct, "_construct is required") });
        }
    }
}
