package software.amazon.awscdk.services.appsync;

/**
 * Properties for an AppSync RDS datasource Aurora Serverless V1.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.rds.*;
 * import software.amazon.awscdk.services.secretsmanager.*;
 * IApi api;
 * Role role;
 * Secret secret;
 * ServerlessCluster serverlessCluster;
 * AppSyncRdsDataSourceProps appSyncRdsDataSourceProps = AppSyncRdsDataSourceProps.builder()
 *         .api(api)
 *         .secretStore(secret)
 *         .serverlessCluster(serverlessCluster)
 *         // the properties below are optional
 *         .databaseName("databaseName")
 *         .description("description")
 *         .name("name")
 *         .serviceRole(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:31.063Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AppSyncRdsDataSourceProps")
@software.amazon.jsii.Jsii.Proxy(AppSyncRdsDataSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AppSyncRdsDataSourceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.appsync.AppSyncBackedDataSourceProps {

    /**
     * The secret containing the credentials for the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret getSecretStore();

    /**
     * The serverless cluster to call to interact with this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IServerlessCluster getServerlessCluster();

    /**
     * The name of the database to use within the cluster.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AppSyncRdsDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AppSyncRdsDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AppSyncRdsDataSourceProps> {
        software.amazon.awscdk.services.secretsmanager.ISecret secretStore;
        software.amazon.awscdk.services.rds.IServerlessCluster serverlessCluster;
        java.lang.String databaseName;
        software.amazon.awscdk.services.iam.IRole serviceRole;
        software.amazon.awscdk.services.appsync.IApi api;
        java.lang.String description;
        java.lang.String name;

        /**
         * Sets the value of {@link AppSyncRdsDataSourceProps#getSecretStore}
         * @param secretStore The secret containing the credentials for the database. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretStore(software.amazon.awscdk.services.secretsmanager.ISecret secretStore) {
            this.secretStore = secretStore;
            return this;
        }

        /**
         * Sets the value of {@link AppSyncRdsDataSourceProps#getServerlessCluster}
         * @param serverlessCluster The serverless cluster to call to interact with this data source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverlessCluster(software.amazon.awscdk.services.rds.IServerlessCluster serverlessCluster) {
            this.serverlessCluster = serverlessCluster;
            return this;
        }

        /**
         * Sets the value of {@link AppSyncRdsDataSourceProps#getDatabaseName}
         * @param databaseName The name of the database to use within the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Sets the value of {@link AppSyncRdsDataSourceProps#getServiceRole}
         * @param serviceRole The IAM service role to be assumed by AppSync to interact with the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        /**
         * Sets the value of {@link AppSyncRdsDataSourceProps#getApi}
         * @param api The API to attach this data source to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(software.amazon.awscdk.services.appsync.IApi api) {
            this.api = api;
            return this;
        }

        /**
         * Sets the value of {@link AppSyncRdsDataSourceProps#getDescription}
         * @param description The description of the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link AppSyncRdsDataSourceProps#getName}
         * @param name The name of the data source.
         *             The only allowed pattern is: {[_A-Za-z][_0-9A-Za-z]*}.
         *             Any invalid characters will be automatically removed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AppSyncRdsDataSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AppSyncRdsDataSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AppSyncRdsDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppSyncRdsDataSourceProps {
        private final software.amazon.awscdk.services.secretsmanager.ISecret secretStore;
        private final software.amazon.awscdk.services.rds.IServerlessCluster serverlessCluster;
        private final java.lang.String databaseName;
        private final software.amazon.awscdk.services.iam.IRole serviceRole;
        private final software.amazon.awscdk.services.appsync.IApi api;
        private final java.lang.String description;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.secretStore = software.amazon.jsii.Kernel.get(this, "secretStore", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
            this.serverlessCluster = software.amazon.jsii.Kernel.get(this, "serverlessCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IServerlessCluster.class));
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceRole = software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.api = software.amazon.jsii.Kernel.get(this, "api", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IApi.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.secretStore = java.util.Objects.requireNonNull(builder.secretStore, "secretStore is required");
            this.serverlessCluster = java.util.Objects.requireNonNull(builder.serverlessCluster, "serverlessCluster is required");
            this.databaseName = builder.databaseName;
            this.serviceRole = builder.serviceRole;
            this.api = java.util.Objects.requireNonNull(builder.api, "api is required");
            this.description = builder.description;
            this.name = builder.name;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.ISecret getSecretStore() {
            return this.secretStore;
        }

        @Override
        public final software.amazon.awscdk.services.rds.IServerlessCluster getServerlessCluster() {
            return this.serverlessCluster;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.IApi getApi() {
            return this.api;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("secretStore", om.valueToTree(this.getSecretStore()));
            data.set("serverlessCluster", om.valueToTree(this.getServerlessCluster()));
            if (this.getDatabaseName() != null) {
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
            }
            if (this.getServiceRole() != null) {
                data.set("serviceRole", om.valueToTree(this.getServiceRole()));
            }
            data.set("api", om.valueToTree(this.getApi()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.AppSyncRdsDataSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AppSyncRdsDataSourceProps.Jsii$Proxy that = (AppSyncRdsDataSourceProps.Jsii$Proxy) o;

            if (!secretStore.equals(that.secretStore)) return false;
            if (!serverlessCluster.equals(that.serverlessCluster)) return false;
            if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
            if (this.serviceRole != null ? !this.serviceRole.equals(that.serviceRole) : that.serviceRole != null) return false;
            if (!api.equals(that.api)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public final int hashCode() {
            int result = this.secretStore.hashCode();
            result = 31 * result + (this.serverlessCluster.hashCode());
            result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
            result = 31 * result + (this.serviceRole != null ? this.serviceRole.hashCode() : 0);
            result = 31 * result + (this.api.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
