package software.amazon.awscdk.services.appsync;

/**
 * The <code>AWS::AppSync::Api</code> resource creates an AWS AppSync API that you can use for an AWS AppSync API with your preferred configuration, such as an Event API that provides real-time message publishing and message subscriptions over WebSockets.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnApi cfnApi = CfnApi.Builder.create(this, "MyCfnApi")
 *         .name("name")
 *         // the properties below are optional
 *         .eventConfig(EventConfigProperty.builder()
 *                 .authProviders(List.of(AuthProviderProperty.builder()
 *                         .authType("authType")
 *                         // the properties below are optional
 *                         .cognitoConfig(CognitoConfigProperty.builder()
 *                                 .awsRegion("awsRegion")
 *                                 .userPoolId("userPoolId")
 *                                 // the properties below are optional
 *                                 .appIdClientRegex("appIdClientRegex")
 *                                 .build())
 *                         .lambdaAuthorizerConfig(LambdaAuthorizerConfigProperty.builder()
 *                                 .authorizerUri("authorizerUri")
 *                                 // the properties below are optional
 *                                 .authorizerResultTtlInSeconds(123)
 *                                 .identityValidationExpression("identityValidationExpression")
 *                                 .build())
 *                         .openIdConnectConfig(OpenIDConnectConfigProperty.builder()
 *                                 .issuer("issuer")
 *                                 // the properties below are optional
 *                                 .authTtl(123)
 *                                 .clientId("clientId")
 *                                 .iatTtl(123)
 *                                 .build())
 *                         .build()))
 *                 .connectionAuthModes(List.of(AuthModeProperty.builder()
 *                         .authType("authType")
 *                         .build()))
 *                 .defaultPublishAuthModes(List.of(AuthModeProperty.builder()
 *                         .authType("authType")
 *                         .build()))
 *                 .defaultSubscribeAuthModes(List.of(AuthModeProperty.builder()
 *                         .authType("authType")
 *                         .build()))
 *                 // the properties below are optional
 *                 .logConfig(EventLogConfigProperty.builder()
 *                         .cloudWatchLogsRoleArn("cloudWatchLogsRoleArn")
 *                         .logLevel("logLevel")
 *                         .build())
 *                 .build())
 *         .ownerContact("ownerContact")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:31.085Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnApi")
public class CfnApi extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appsync.CfnApi.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.CfnApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the AWS AppSync Api.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrApiArn() {
        return software.amazon.jsii.Kernel.get(this, "attrApiArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the AWS AppSync Api generated by the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrApiId() {
        return software.amazon.jsii.Kernel.get(this, "attrApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A map of DNS names for the AppSync API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrDns() {
        return software.amazon.jsii.Kernel.get(this, "attrDns", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The domain name of the Api's HTTP endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDnsHttp() {
        return software.amazon.jsii.Kernel.get(this, "attrDnsHttp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain name of the Api's real-time endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDnsRealtime() {
        return software.amazon.jsii.Kernel.get(this, "attrDnsRealtime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the <code>Api</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the <code>Api</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for an Event API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEventConfig() {
        return software.amazon.jsii.Kernel.get(this, "eventConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for an Event API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "eventConfig", value);
    }

    /**
     * Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for an Event API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnApi.EventConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "eventConfig", value);
    }

    /**
     * The owner contact information for an API resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOwnerContact() {
        return software.amazon.jsii.Kernel.get(this, "ownerContact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The owner contact information for an API resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOwnerContact(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ownerContact", value);
    }

    /**
     * A set of tags (key-value pairs) for this API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A set of tags (key-value pairs) for this API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Describes an authorization configuration.
     * <p>
     * Use <code>AuthMode</code> to specify the publishing and subscription authorization configuration for an Event API.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * AuthModeProperty authModeProperty = AuthModeProperty.builder()
     *         .authType("authType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-authmode.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-authmode.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnApi.AuthModeProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthModeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthModeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authorization type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-authmode.html#cfn-appsync-api-authmode-authtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-authmode.html#cfn-appsync-api-authmode-authtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthModeProperty> {
            java.lang.String authType;

            /**
             * Sets the value of {@link AuthModeProperty#getAuthType}
             * @param authType The authorization type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authType(java.lang.String authType) {
                this.authType = authType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthModeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthModeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthModeProperty {
            private final java.lang.String authType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authType = builder.authType;
            }

            @Override
            public final java.lang.String getAuthType() {
                return this.authType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthType() != null) {
                    data.set("authType", om.valueToTree(this.getAuthType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnApi.AuthModeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthModeProperty.Jsii$Proxy that = (AuthModeProperty.Jsii$Proxy) o;

                return this.authType != null ? this.authType.equals(that.authType) : that.authType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authType != null ? this.authType.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes an authorization provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * AuthProviderProperty authProviderProperty = AuthProviderProperty.builder()
     *         .authType("authType")
     *         // the properties below are optional
     *         .cognitoConfig(CognitoConfigProperty.builder()
     *                 .awsRegion("awsRegion")
     *                 .userPoolId("userPoolId")
     *                 // the properties below are optional
     *                 .appIdClientRegex("appIdClientRegex")
     *                 .build())
     *         .lambdaAuthorizerConfig(LambdaAuthorizerConfigProperty.builder()
     *                 .authorizerUri("authorizerUri")
     *                 // the properties below are optional
     *                 .authorizerResultTtlInSeconds(123)
     *                 .identityValidationExpression("identityValidationExpression")
     *                 .build())
     *         .openIdConnectConfig(OpenIDConnectConfigProperty.builder()
     *                 .issuer("issuer")
     *                 // the properties below are optional
     *                 .authTtl(123)
     *                 .clientId("clientId")
     *                 .iatTtl(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-authprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-authprovider.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnApi.AuthProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authorization type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-authprovider.html#cfn-appsync-api-authprovider-authtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-authprovider.html#cfn-appsync-api-authprovider-authtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthType();

        /**
         * Describes an Amazon Cognito user pool configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-authprovider.html#cfn-appsync-api-authprovider-cognitoconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-authprovider.html#cfn-appsync-api-authprovider-cognitoconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCognitoConfig() {
            return null;
        }

        /**
         * A <code>LambdaAuthorizerConfig</code> specifies how to authorize AWS AppSync API access when using the <code>AWS_LAMBDA</code> authorizer mode.
         * <p>
         * Be aware that an AWS AppSync API can have only one AWS Lambda authorizer configured at a time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-authprovider.html#cfn-appsync-api-authprovider-lambdaauthorizerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-authprovider.html#cfn-appsync-api-authprovider-lambdaauthorizerconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaAuthorizerConfig() {
            return null;
        }

        /**
         * Describes an OpenID Connect (OIDC) configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-authprovider.html#cfn-appsync-api-authprovider-openidconnectconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-authprovider.html#cfn-appsync-api-authprovider-openidconnectconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOpenIdConnectConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthProviderProperty> {
            java.lang.String authType;
            java.lang.Object cognitoConfig;
            java.lang.Object lambdaAuthorizerConfig;
            java.lang.Object openIdConnectConfig;

            /**
             * Sets the value of {@link AuthProviderProperty#getAuthType}
             * @param authType The authorization type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authType(java.lang.String authType) {
                this.authType = authType;
                return this;
            }

            /**
             * Sets the value of {@link AuthProviderProperty#getCognitoConfig}
             * @param cognitoConfig Describes an Amazon Cognito user pool configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cognitoConfig(software.amazon.awscdk.IResolvable cognitoConfig) {
                this.cognitoConfig = cognitoConfig;
                return this;
            }

            /**
             * Sets the value of {@link AuthProviderProperty#getCognitoConfig}
             * @param cognitoConfig Describes an Amazon Cognito user pool configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cognitoConfig(software.amazon.awscdk.services.appsync.CfnApi.CognitoConfigProperty cognitoConfig) {
                this.cognitoConfig = cognitoConfig;
                return this;
            }

            /**
             * Sets the value of {@link AuthProviderProperty#getLambdaAuthorizerConfig}
             * @param lambdaAuthorizerConfig A <code>LambdaAuthorizerConfig</code> specifies how to authorize AWS AppSync API access when using the <code>AWS_LAMBDA</code> authorizer mode.
             *                               Be aware that an AWS AppSync API can have only one AWS Lambda authorizer configured at a time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaAuthorizerConfig(software.amazon.awscdk.IResolvable lambdaAuthorizerConfig) {
                this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
                return this;
            }

            /**
             * Sets the value of {@link AuthProviderProperty#getLambdaAuthorizerConfig}
             * @param lambdaAuthorizerConfig A <code>LambdaAuthorizerConfig</code> specifies how to authorize AWS AppSync API access when using the <code>AWS_LAMBDA</code> authorizer mode.
             *                               Be aware that an AWS AppSync API can have only one AWS Lambda authorizer configured at a time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaAuthorizerConfig(software.amazon.awscdk.services.appsync.CfnApi.LambdaAuthorizerConfigProperty lambdaAuthorizerConfig) {
                this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
                return this;
            }

            /**
             * Sets the value of {@link AuthProviderProperty#getOpenIdConnectConfig}
             * @param openIdConnectConfig Describes an OpenID Connect (OIDC) configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openIdConnectConfig(software.amazon.awscdk.IResolvable openIdConnectConfig) {
                this.openIdConnectConfig = openIdConnectConfig;
                return this;
            }

            /**
             * Sets the value of {@link AuthProviderProperty#getOpenIdConnectConfig}
             * @param openIdConnectConfig Describes an OpenID Connect (OIDC) configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openIdConnectConfig(software.amazon.awscdk.services.appsync.CfnApi.OpenIDConnectConfigProperty openIdConnectConfig) {
                this.openIdConnectConfig = openIdConnectConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthProviderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthProviderProperty {
            private final java.lang.String authType;
            private final java.lang.Object cognitoConfig;
            private final java.lang.Object lambdaAuthorizerConfig;
            private final java.lang.Object openIdConnectConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cognitoConfig = software.amazon.jsii.Kernel.get(this, "cognitoConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaAuthorizerConfig = software.amazon.jsii.Kernel.get(this, "lambdaAuthorizerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.openIdConnectConfig = software.amazon.jsii.Kernel.get(this, "openIdConnectConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authType = java.util.Objects.requireNonNull(builder.authType, "authType is required");
                this.cognitoConfig = builder.cognitoConfig;
                this.lambdaAuthorizerConfig = builder.lambdaAuthorizerConfig;
                this.openIdConnectConfig = builder.openIdConnectConfig;
            }

            @Override
            public final java.lang.String getAuthType() {
                return this.authType;
            }

            @Override
            public final java.lang.Object getCognitoConfig() {
                return this.cognitoConfig;
            }

            @Override
            public final java.lang.Object getLambdaAuthorizerConfig() {
                return this.lambdaAuthorizerConfig;
            }

            @Override
            public final java.lang.Object getOpenIdConnectConfig() {
                return this.openIdConnectConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authType", om.valueToTree(this.getAuthType()));
                if (this.getCognitoConfig() != null) {
                    data.set("cognitoConfig", om.valueToTree(this.getCognitoConfig()));
                }
                if (this.getLambdaAuthorizerConfig() != null) {
                    data.set("lambdaAuthorizerConfig", om.valueToTree(this.getLambdaAuthorizerConfig()));
                }
                if (this.getOpenIdConnectConfig() != null) {
                    data.set("openIdConnectConfig", om.valueToTree(this.getOpenIdConnectConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnApi.AuthProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthProviderProperty.Jsii$Proxy that = (AuthProviderProperty.Jsii$Proxy) o;

                if (!authType.equals(that.authType)) return false;
                if (this.cognitoConfig != null ? !this.cognitoConfig.equals(that.cognitoConfig) : that.cognitoConfig != null) return false;
                if (this.lambdaAuthorizerConfig != null ? !this.lambdaAuthorizerConfig.equals(that.lambdaAuthorizerConfig) : that.lambdaAuthorizerConfig != null) return false;
                return this.openIdConnectConfig != null ? this.openIdConnectConfig.equals(that.openIdConnectConfig) : that.openIdConnectConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authType.hashCode();
                result = 31 * result + (this.cognitoConfig != null ? this.cognitoConfig.hashCode() : 0);
                result = 31 * result + (this.lambdaAuthorizerConfig != null ? this.lambdaAuthorizerConfig.hashCode() : 0);
                result = 31 * result + (this.openIdConnectConfig != null ? this.openIdConnectConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an Amazon Cognito configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * CognitoConfigProperty cognitoConfigProperty = CognitoConfigProperty.builder()
     *         .awsRegion("awsRegion")
     *         .userPoolId("userPoolId")
     *         // the properties below are optional
     *         .appIdClientRegex("appIdClientRegex")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-cognitoconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-cognitoconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnApi.CognitoConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CognitoConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CognitoConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Region in which the user pool was created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-cognitoconfig.html#cfn-appsync-api-cognitoconfig-awsregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-cognitoconfig.html#cfn-appsync-api-cognitoconfig-awsregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAwsRegion();

        /**
         * The user pool ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-cognitoconfig.html#cfn-appsync-api-cognitoconfig-userpoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-cognitoconfig.html#cfn-appsync-api-cognitoconfig-userpoolid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId();

        /**
         * A regular expression for validating the incoming Amazon Cognito user pool app client ID.
         * <p>
         * If this value isn't set, no filtering is applied.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-cognitoconfig.html#cfn-appsync-api-cognitoconfig-appidclientregex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-cognitoconfig.html#cfn-appsync-api-cognitoconfig-appidclientregex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAppIdClientRegex() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CognitoConfigProperty> {
            java.lang.String awsRegion;
            java.lang.String userPoolId;
            java.lang.String appIdClientRegex;

            /**
             * Sets the value of {@link CognitoConfigProperty#getAwsRegion}
             * @param awsRegion The AWS Region in which the user pool was created. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsRegion(java.lang.String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            /**
             * Sets the value of {@link CognitoConfigProperty#getUserPoolId}
             * @param userPoolId The user pool ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolId(java.lang.String userPoolId) {
                this.userPoolId = userPoolId;
                return this;
            }

            /**
             * Sets the value of {@link CognitoConfigProperty#getAppIdClientRegex}
             * @param appIdClientRegex A regular expression for validating the incoming Amazon Cognito user pool app client ID.
             *                         If this value isn't set, no filtering is applied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appIdClientRegex(java.lang.String appIdClientRegex) {
                this.appIdClientRegex = appIdClientRegex;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CognitoConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoConfigProperty {
            private final java.lang.String awsRegion;
            private final java.lang.String userPoolId;
            private final java.lang.String appIdClientRegex;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsRegion = software.amazon.jsii.Kernel.get(this, "awsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.appIdClientRegex = software.amazon.jsii.Kernel.get(this, "appIdClientRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsRegion = java.util.Objects.requireNonNull(builder.awsRegion, "awsRegion is required");
                this.userPoolId = java.util.Objects.requireNonNull(builder.userPoolId, "userPoolId is required");
                this.appIdClientRegex = builder.appIdClientRegex;
            }

            @Override
            public final java.lang.String getAwsRegion() {
                return this.awsRegion;
            }

            @Override
            public final java.lang.String getUserPoolId() {
                return this.userPoolId;
            }

            @Override
            public final java.lang.String getAppIdClientRegex() {
                return this.appIdClientRegex;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("awsRegion", om.valueToTree(this.getAwsRegion()));
                data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
                if (this.getAppIdClientRegex() != null) {
                    data.set("appIdClientRegex", om.valueToTree(this.getAppIdClientRegex()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnApi.CognitoConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoConfigProperty.Jsii$Proxy that = (CognitoConfigProperty.Jsii$Proxy) o;

                if (!awsRegion.equals(that.awsRegion)) return false;
                if (!userPoolId.equals(that.userPoolId)) return false;
                return this.appIdClientRegex != null ? this.appIdClientRegex.equals(that.appIdClientRegex) : that.appIdClientRegex == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsRegion.hashCode();
                result = 31 * result + (this.userPoolId.hashCode());
                result = 31 * result + (this.appIdClientRegex != null ? this.appIdClientRegex.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A map of DNS names for the Api.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * DnsMapProperty dnsMapProperty = DnsMapProperty.builder()
     *         .http("http")
     *         .realtime("realtime")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-dnsmap.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-dnsmap.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnApi.DnsMapProperty")
    @software.amazon.jsii.Jsii.Proxy(DnsMapProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DnsMapProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The domain name of the Api's HTTP endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-dnsmap.html#cfn-appsync-api-dnsmap-http">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-dnsmap.html#cfn-appsync-api-dnsmap-http</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttp() {
            return null;
        }

        /**
         * The domain name of the Api's real-time endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-dnsmap.html#cfn-appsync-api-dnsmap-realtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-dnsmap.html#cfn-appsync-api-dnsmap-realtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRealtime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DnsMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DnsMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DnsMapProperty> {
            java.lang.String http;
            java.lang.String realtime;

            /**
             * Sets the value of {@link DnsMapProperty#getHttp}
             * @param http The domain name of the Api's HTTP endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http(java.lang.String http) {
                this.http = http;
                return this;
            }

            /**
             * Sets the value of {@link DnsMapProperty#getRealtime}
             * @param realtime The domain name of the Api's real-time endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder realtime(java.lang.String realtime) {
                this.realtime = realtime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DnsMapProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DnsMapProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DnsMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DnsMapProperty {
            private final java.lang.String http;
            private final java.lang.String realtime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.http = software.amazon.jsii.Kernel.get(this, "http", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.realtime = software.amazon.jsii.Kernel.get(this, "realtime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.http = builder.http;
                this.realtime = builder.realtime;
            }

            @Override
            public final java.lang.String getHttp() {
                return this.http;
            }

            @Override
            public final java.lang.String getRealtime() {
                return this.realtime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHttp() != null) {
                    data.set("http", om.valueToTree(this.getHttp()));
                }
                if (this.getRealtime() != null) {
                    data.set("realtime", om.valueToTree(this.getRealtime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnApi.DnsMapProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DnsMapProperty.Jsii$Proxy that = (DnsMapProperty.Jsii$Proxy) o;

                if (this.http != null ? !this.http.equals(that.http) : that.http != null) return false;
                return this.realtime != null ? this.realtime.equals(that.realtime) : that.realtime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.http != null ? this.http.hashCode() : 0;
                result = 31 * result + (this.realtime != null ? this.realtime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for an Event API.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * EventConfigProperty eventConfigProperty = EventConfigProperty.builder()
     *         .authProviders(List.of(AuthProviderProperty.builder()
     *                 .authType("authType")
     *                 // the properties below are optional
     *                 .cognitoConfig(CognitoConfigProperty.builder()
     *                         .awsRegion("awsRegion")
     *                         .userPoolId("userPoolId")
     *                         // the properties below are optional
     *                         .appIdClientRegex("appIdClientRegex")
     *                         .build())
     *                 .lambdaAuthorizerConfig(LambdaAuthorizerConfigProperty.builder()
     *                         .authorizerUri("authorizerUri")
     *                         // the properties below are optional
     *                         .authorizerResultTtlInSeconds(123)
     *                         .identityValidationExpression("identityValidationExpression")
     *                         .build())
     *                 .openIdConnectConfig(OpenIDConnectConfigProperty.builder()
     *                         .issuer("issuer")
     *                         // the properties below are optional
     *                         .authTtl(123)
     *                         .clientId("clientId")
     *                         .iatTtl(123)
     *                         .build())
     *                 .build()))
     *         .connectionAuthModes(List.of(AuthModeProperty.builder()
     *                 .authType("authType")
     *                 .build()))
     *         .defaultPublishAuthModes(List.of(AuthModeProperty.builder()
     *                 .authType("authType")
     *                 .build()))
     *         .defaultSubscribeAuthModes(List.of(AuthModeProperty.builder()
     *                 .authType("authType")
     *                 .build()))
     *         // the properties below are optional
     *         .logConfig(EventLogConfigProperty.builder()
     *                 .cloudWatchLogsRoleArn("cloudWatchLogsRoleArn")
     *                 .logLevel("logLevel")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnApi.EventConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EventConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of authorization providers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventconfig.html#cfn-appsync-api-eventconfig-authproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventconfig.html#cfn-appsync-api-eventconfig-authproviders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAuthProviders();

        /**
         * A list of valid authorization modes for the Event API connections.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventconfig.html#cfn-appsync-api-eventconfig-connectionauthmodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventconfig.html#cfn-appsync-api-eventconfig-connectionauthmodes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getConnectionAuthModes();

        /**
         * A list of valid authorization modes for the Event API publishing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventconfig.html#cfn-appsync-api-eventconfig-defaultpublishauthmodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventconfig.html#cfn-appsync-api-eventconfig-defaultpublishauthmodes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDefaultPublishAuthModes();

        /**
         * A list of valid authorization modes for the Event API subscriptions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventconfig.html#cfn-appsync-api-eventconfig-defaultsubscribeauthmodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventconfig.html#cfn-appsync-api-eventconfig-defaultsubscribeauthmodes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDefaultSubscribeAuthModes();

        /**
         * The CloudWatch Logs configuration for the Event API.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventconfig.html#cfn-appsync-api-eventconfig-logconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventconfig.html#cfn-appsync-api-eventconfig-logconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventConfigProperty> {
            java.lang.Object authProviders;
            java.lang.Object connectionAuthModes;
            java.lang.Object defaultPublishAuthModes;
            java.lang.Object defaultSubscribeAuthModes;
            java.lang.Object logConfig;

            /**
             * Sets the value of {@link EventConfigProperty#getAuthProviders}
             * @param authProviders A list of authorization providers. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authProviders(software.amazon.awscdk.IResolvable authProviders) {
                this.authProviders = authProviders;
                return this;
            }

            /**
             * Sets the value of {@link EventConfigProperty#getAuthProviders}
             * @param authProviders A list of authorization providers. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authProviders(java.util.List<? extends java.lang.Object> authProviders) {
                this.authProviders = authProviders;
                return this;
            }

            /**
             * Sets the value of {@link EventConfigProperty#getConnectionAuthModes}
             * @param connectionAuthModes A list of valid authorization modes for the Event API connections. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionAuthModes(software.amazon.awscdk.IResolvable connectionAuthModes) {
                this.connectionAuthModes = connectionAuthModes;
                return this;
            }

            /**
             * Sets the value of {@link EventConfigProperty#getConnectionAuthModes}
             * @param connectionAuthModes A list of valid authorization modes for the Event API connections. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionAuthModes(java.util.List<? extends java.lang.Object> connectionAuthModes) {
                this.connectionAuthModes = connectionAuthModes;
                return this;
            }

            /**
             * Sets the value of {@link EventConfigProperty#getDefaultPublishAuthModes}
             * @param defaultPublishAuthModes A list of valid authorization modes for the Event API publishing. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultPublishAuthModes(software.amazon.awscdk.IResolvable defaultPublishAuthModes) {
                this.defaultPublishAuthModes = defaultPublishAuthModes;
                return this;
            }

            /**
             * Sets the value of {@link EventConfigProperty#getDefaultPublishAuthModes}
             * @param defaultPublishAuthModes A list of valid authorization modes for the Event API publishing. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultPublishAuthModes(java.util.List<? extends java.lang.Object> defaultPublishAuthModes) {
                this.defaultPublishAuthModes = defaultPublishAuthModes;
                return this;
            }

            /**
             * Sets the value of {@link EventConfigProperty#getDefaultSubscribeAuthModes}
             * @param defaultSubscribeAuthModes A list of valid authorization modes for the Event API subscriptions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultSubscribeAuthModes(software.amazon.awscdk.IResolvable defaultSubscribeAuthModes) {
                this.defaultSubscribeAuthModes = defaultSubscribeAuthModes;
                return this;
            }

            /**
             * Sets the value of {@link EventConfigProperty#getDefaultSubscribeAuthModes}
             * @param defaultSubscribeAuthModes A list of valid authorization modes for the Event API subscriptions. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultSubscribeAuthModes(java.util.List<? extends java.lang.Object> defaultSubscribeAuthModes) {
                this.defaultSubscribeAuthModes = defaultSubscribeAuthModes;
                return this;
            }

            /**
             * Sets the value of {@link EventConfigProperty#getLogConfig}
             * @param logConfig The CloudWatch Logs configuration for the Event API.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logConfig(software.amazon.awscdk.IResolvable logConfig) {
                this.logConfig = logConfig;
                return this;
            }

            /**
             * Sets the value of {@link EventConfigProperty#getLogConfig}
             * @param logConfig The CloudWatch Logs configuration for the Event API.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logConfig(software.amazon.awscdk.services.appsync.CfnApi.EventLogConfigProperty logConfig) {
                this.logConfig = logConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventConfigProperty {
            private final java.lang.Object authProviders;
            private final java.lang.Object connectionAuthModes;
            private final java.lang.Object defaultPublishAuthModes;
            private final java.lang.Object defaultSubscribeAuthModes;
            private final java.lang.Object logConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authProviders = software.amazon.jsii.Kernel.get(this, "authProviders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.connectionAuthModes = software.amazon.jsii.Kernel.get(this, "connectionAuthModes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultPublishAuthModes = software.amazon.jsii.Kernel.get(this, "defaultPublishAuthModes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultSubscribeAuthModes = software.amazon.jsii.Kernel.get(this, "defaultSubscribeAuthModes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logConfig = software.amazon.jsii.Kernel.get(this, "logConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authProviders = java.util.Objects.requireNonNull(builder.authProviders, "authProviders is required");
                this.connectionAuthModes = java.util.Objects.requireNonNull(builder.connectionAuthModes, "connectionAuthModes is required");
                this.defaultPublishAuthModes = java.util.Objects.requireNonNull(builder.defaultPublishAuthModes, "defaultPublishAuthModes is required");
                this.defaultSubscribeAuthModes = java.util.Objects.requireNonNull(builder.defaultSubscribeAuthModes, "defaultSubscribeAuthModes is required");
                this.logConfig = builder.logConfig;
            }

            @Override
            public final java.lang.Object getAuthProviders() {
                return this.authProviders;
            }

            @Override
            public final java.lang.Object getConnectionAuthModes() {
                return this.connectionAuthModes;
            }

            @Override
            public final java.lang.Object getDefaultPublishAuthModes() {
                return this.defaultPublishAuthModes;
            }

            @Override
            public final java.lang.Object getDefaultSubscribeAuthModes() {
                return this.defaultSubscribeAuthModes;
            }

            @Override
            public final java.lang.Object getLogConfig() {
                return this.logConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authProviders", om.valueToTree(this.getAuthProviders()));
                data.set("connectionAuthModes", om.valueToTree(this.getConnectionAuthModes()));
                data.set("defaultPublishAuthModes", om.valueToTree(this.getDefaultPublishAuthModes()));
                data.set("defaultSubscribeAuthModes", om.valueToTree(this.getDefaultSubscribeAuthModes()));
                if (this.getLogConfig() != null) {
                    data.set("logConfig", om.valueToTree(this.getLogConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnApi.EventConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventConfigProperty.Jsii$Proxy that = (EventConfigProperty.Jsii$Proxy) o;

                if (!authProviders.equals(that.authProviders)) return false;
                if (!connectionAuthModes.equals(that.connectionAuthModes)) return false;
                if (!defaultPublishAuthModes.equals(that.defaultPublishAuthModes)) return false;
                if (!defaultSubscribeAuthModes.equals(that.defaultSubscribeAuthModes)) return false;
                return this.logConfig != null ? this.logConfig.equals(that.logConfig) : that.logConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authProviders.hashCode();
                result = 31 * result + (this.connectionAuthModes.hashCode());
                result = 31 * result + (this.defaultPublishAuthModes.hashCode());
                result = 31 * result + (this.defaultSubscribeAuthModes.hashCode());
                result = 31 * result + (this.logConfig != null ? this.logConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the CloudWatch Logs configuration for the Event API.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * EventLogConfigProperty eventLogConfigProperty = EventLogConfigProperty.builder()
     *         .cloudWatchLogsRoleArn("cloudWatchLogsRoleArn")
     *         .logLevel("logLevel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventlogconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventlogconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnApi.EventLogConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EventLogConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventLogConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IAM service role that AWS AppSync assumes to publish CloudWatch Logs in your account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventlogconfig.html#cfn-appsync-api-eventlogconfig-cloudwatchlogsrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventlogconfig.html#cfn-appsync-api-eventlogconfig-cloudwatchlogsrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCloudWatchLogsRoleArn();

        /**
         * The type of information to log for the Event API.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventlogconfig.html#cfn-appsync-api-eventlogconfig-loglevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-eventlogconfig.html#cfn-appsync-api-eventlogconfig-loglevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogLevel();

        /**
         * @return a {@link Builder} of {@link EventLogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventLogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventLogConfigProperty> {
            java.lang.String cloudWatchLogsRoleArn;
            java.lang.String logLevel;

            /**
             * Sets the value of {@link EventLogConfigProperty#getCloudWatchLogsRoleArn}
             * @param cloudWatchLogsRoleArn The IAM service role that AWS AppSync assumes to publish CloudWatch Logs in your account. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsRoleArn(java.lang.String cloudWatchLogsRoleArn) {
                this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link EventLogConfigProperty#getLogLevel}
             * @param logLevel The type of information to log for the Event API. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logLevel(java.lang.String logLevel) {
                this.logLevel = logLevel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventLogConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventLogConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventLogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventLogConfigProperty {
            private final java.lang.String cloudWatchLogsRoleArn;
            private final java.lang.String logLevel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogsRoleArn = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logLevel = software.amazon.jsii.Kernel.get(this, "logLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogsRoleArn = java.util.Objects.requireNonNull(builder.cloudWatchLogsRoleArn, "cloudWatchLogsRoleArn is required");
                this.logLevel = java.util.Objects.requireNonNull(builder.logLevel, "logLevel is required");
            }

            @Override
            public final java.lang.String getCloudWatchLogsRoleArn() {
                return this.cloudWatchLogsRoleArn;
            }

            @Override
            public final java.lang.String getLogLevel() {
                return this.logLevel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cloudWatchLogsRoleArn", om.valueToTree(this.getCloudWatchLogsRoleArn()));
                data.set("logLevel", om.valueToTree(this.getLogLevel()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnApi.EventLogConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventLogConfigProperty.Jsii$Proxy that = (EventLogConfigProperty.Jsii$Proxy) o;

                if (!cloudWatchLogsRoleArn.equals(that.cloudWatchLogsRoleArn)) return false;
                return this.logLevel.equals(that.logLevel);
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogsRoleArn.hashCode();
                result = 31 * result + (this.logLevel.hashCode());
                return result;
            }
        }
    }
    /**
     * A <code>LambdaAuthorizerConfig</code> specifies how to authorize AWS AppSync API access when using the <code>AWS_LAMBDA</code> authorizer mode.
     * <p>
     * Be aware that an AWS AppSync API can have only one AWS Lambda authorizer configured at a time.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * LambdaAuthorizerConfigProperty lambdaAuthorizerConfigProperty = LambdaAuthorizerConfigProperty.builder()
     *         .authorizerUri("authorizerUri")
     *         // the properties below are optional
     *         .authorizerResultTtlInSeconds(123)
     *         .identityValidationExpression("identityValidationExpression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-lambdaauthorizerconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-lambdaauthorizerconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnApi.LambdaAuthorizerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaAuthorizerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaAuthorizerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Lambda function to be called for authorization.
         * <p>
         * This can be a standard Lambda ARN, a version ARN ( <code>.../v3</code> ), or an alias ARN.
         * <p>
         * <em>Note</em> : This Lambda function must have the following resource-based policy assigned to it. When configuring Lambda authorizers in the console, this is done for you. To use the AWS Command Line Interface ( AWS CLI ), run the following:
         * <p>
         * <code>aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-lambdaauthorizerconfig.html#cfn-appsync-api-lambdaauthorizerconfig-authorizeruri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-lambdaauthorizerconfig.html#cfn-appsync-api-lambdaauthorizerconfig-authorizeruri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthorizerUri();

        /**
         * The number of seconds a response should be cached for.
         * <p>
         * The default is 0 seconds, which disables caching. If you don't specify a value for <code>authorizerResultTtlInSeconds</code> , the default value is used. The maximum value is one hour (3600 seconds). The Lambda function can override this by returning a <code>ttlOverride</code> key in its response.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-lambdaauthorizerconfig.html#cfn-appsync-api-lambdaauthorizerconfig-authorizerresultttlinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-lambdaauthorizerconfig.html#cfn-appsync-api-lambdaauthorizerconfig-authorizerresultttlinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAuthorizerResultTtlInSeconds() {
            return null;
        }

        /**
         * A regular expression for validation of tokens before the Lambda function is called.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-lambdaauthorizerconfig.html#cfn-appsync-api-lambdaauthorizerconfig-identityvalidationexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-lambdaauthorizerconfig.html#cfn-appsync-api-lambdaauthorizerconfig-identityvalidationexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdentityValidationExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaAuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaAuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaAuthorizerConfigProperty> {
            java.lang.String authorizerUri;
            java.lang.Number authorizerResultTtlInSeconds;
            java.lang.String identityValidationExpression;

            /**
             * Sets the value of {@link LambdaAuthorizerConfigProperty#getAuthorizerUri}
             * @param authorizerUri The Amazon Resource Name (ARN) of the Lambda function to be called for authorization. This parameter is required.
             *                      This can be a standard Lambda ARN, a version ARN ( <code>.../v3</code> ), or an alias ARN.
             *                      <p>
             *                      <em>Note</em> : This Lambda function must have the following resource-based policy assigned to it. When configuring Lambda authorizers in the console, this is done for you. To use the AWS Command Line Interface ( AWS CLI ), run the following:
             *                      <p>
             *                      <code>aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizerUri(java.lang.String authorizerUri) {
                this.authorizerUri = authorizerUri;
                return this;
            }

            /**
             * Sets the value of {@link LambdaAuthorizerConfigProperty#getAuthorizerResultTtlInSeconds}
             * @param authorizerResultTtlInSeconds The number of seconds a response should be cached for.
             *                                     The default is 0 seconds, which disables caching. If you don't specify a value for <code>authorizerResultTtlInSeconds</code> , the default value is used. The maximum value is one hour (3600 seconds). The Lambda function can override this by returning a <code>ttlOverride</code> key in its response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizerResultTtlInSeconds(java.lang.Number authorizerResultTtlInSeconds) {
                this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link LambdaAuthorizerConfigProperty#getIdentityValidationExpression}
             * @param identityValidationExpression A regular expression for validation of tokens before the Lambda function is called.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityValidationExpression(java.lang.String identityValidationExpression) {
                this.identityValidationExpression = identityValidationExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaAuthorizerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaAuthorizerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaAuthorizerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaAuthorizerConfigProperty {
            private final java.lang.String authorizerUri;
            private final java.lang.Number authorizerResultTtlInSeconds;
            private final java.lang.String identityValidationExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizerUri = software.amazon.jsii.Kernel.get(this, "authorizerUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authorizerResultTtlInSeconds = software.amazon.jsii.Kernel.get(this, "authorizerResultTtlInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.identityValidationExpression = software.amazon.jsii.Kernel.get(this, "identityValidationExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizerUri = java.util.Objects.requireNonNull(builder.authorizerUri, "authorizerUri is required");
                this.authorizerResultTtlInSeconds = builder.authorizerResultTtlInSeconds;
                this.identityValidationExpression = builder.identityValidationExpression;
            }

            @Override
            public final java.lang.String getAuthorizerUri() {
                return this.authorizerUri;
            }

            @Override
            public final java.lang.Number getAuthorizerResultTtlInSeconds() {
                return this.authorizerResultTtlInSeconds;
            }

            @Override
            public final java.lang.String getIdentityValidationExpression() {
                return this.identityValidationExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authorizerUri", om.valueToTree(this.getAuthorizerUri()));
                if (this.getAuthorizerResultTtlInSeconds() != null) {
                    data.set("authorizerResultTtlInSeconds", om.valueToTree(this.getAuthorizerResultTtlInSeconds()));
                }
                if (this.getIdentityValidationExpression() != null) {
                    data.set("identityValidationExpression", om.valueToTree(this.getIdentityValidationExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnApi.LambdaAuthorizerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaAuthorizerConfigProperty.Jsii$Proxy that = (LambdaAuthorizerConfigProperty.Jsii$Proxy) o;

                if (!authorizerUri.equals(that.authorizerUri)) return false;
                if (this.authorizerResultTtlInSeconds != null ? !this.authorizerResultTtlInSeconds.equals(that.authorizerResultTtlInSeconds) : that.authorizerResultTtlInSeconds != null) return false;
                return this.identityValidationExpression != null ? this.identityValidationExpression.equals(that.identityValidationExpression) : that.identityValidationExpression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authorizerUri.hashCode();
                result = 31 * result + (this.authorizerResultTtlInSeconds != null ? this.authorizerResultTtlInSeconds.hashCode() : 0);
                result = 31 * result + (this.identityValidationExpression != null ? this.identityValidationExpression.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an OpenID Connect (OIDC) configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * OpenIDConnectConfigProperty openIDConnectConfigProperty = OpenIDConnectConfigProperty.builder()
     *         .issuer("issuer")
     *         // the properties below are optional
     *         .authTtl(123)
     *         .clientId("clientId")
     *         .iatTtl(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-openidconnectconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-openidconnectconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnApi.OpenIDConnectConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenIDConnectConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenIDConnectConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The issuer for the OIDC configuration.
         * <p>
         * The issuer returned by discovery must exactly match the value of <code>iss</code> in the ID token.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-openidconnectconfig.html#cfn-appsync-api-openidconnectconfig-issuer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-openidconnectconfig.html#cfn-appsync-api-openidconnectconfig-issuer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIssuer();

        /**
         * The number of milliseconds that a token is valid after being authenticated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-openidconnectconfig.html#cfn-appsync-api-openidconnectconfig-authttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-openidconnectconfig.html#cfn-appsync-api-openidconnectconfig-authttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAuthTtl() {
            return null;
        }

        /**
         * The client identifier of the relying party at the OpenID identity provider.
         * <p>
         * This identifier is typically obtained when the relying party is registered with the OpenID identity provider. You can specify a regular expression so that AWS AppSync can validate against multiple client identifiers at a time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-openidconnectconfig.html#cfn-appsync-api-openidconnectconfig-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-openidconnectconfig.html#cfn-appsync-api-openidconnectconfig-clientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientId() {
            return null;
        }

        /**
         * The number of milliseconds that a token is valid after it's issued to a user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-openidconnectconfig.html#cfn-appsync-api-openidconnectconfig-iatttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-api-openidconnectconfig.html#cfn-appsync-api-openidconnectconfig-iatttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIatTtl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OpenIDConnectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenIDConnectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenIDConnectConfigProperty> {
            java.lang.String issuer;
            java.lang.Number authTtl;
            java.lang.String clientId;
            java.lang.Number iatTtl;

            /**
             * Sets the value of {@link OpenIDConnectConfigProperty#getIssuer}
             * @param issuer The issuer for the OIDC configuration. This parameter is required.
             *               The issuer returned by discovery must exactly match the value of <code>iss</code> in the ID token.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder issuer(java.lang.String issuer) {
                this.issuer = issuer;
                return this;
            }

            /**
             * Sets the value of {@link OpenIDConnectConfigProperty#getAuthTtl}
             * @param authTtl The number of milliseconds that a token is valid after being authenticated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authTtl(java.lang.Number authTtl) {
                this.authTtl = authTtl;
                return this;
            }

            /**
             * Sets the value of {@link OpenIDConnectConfigProperty#getClientId}
             * @param clientId The client identifier of the relying party at the OpenID identity provider.
             *                 This identifier is typically obtained when the relying party is registered with the OpenID identity provider. You can specify a regular expression so that AWS AppSync can validate against multiple client identifiers at a time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link OpenIDConnectConfigProperty#getIatTtl}
             * @param iatTtl The number of milliseconds that a token is valid after it's issued to a user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iatTtl(java.lang.Number iatTtl) {
                this.iatTtl = iatTtl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenIDConnectConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenIDConnectConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenIDConnectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenIDConnectConfigProperty {
            private final java.lang.String issuer;
            private final java.lang.Number authTtl;
            private final java.lang.String clientId;
            private final java.lang.Number iatTtl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.issuer = software.amazon.jsii.Kernel.get(this, "issuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authTtl = software.amazon.jsii.Kernel.get(this, "authTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iatTtl = software.amazon.jsii.Kernel.get(this, "iatTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.issuer = java.util.Objects.requireNonNull(builder.issuer, "issuer is required");
                this.authTtl = builder.authTtl;
                this.clientId = builder.clientId;
                this.iatTtl = builder.iatTtl;
            }

            @Override
            public final java.lang.String getIssuer() {
                return this.issuer;
            }

            @Override
            public final java.lang.Number getAuthTtl() {
                return this.authTtl;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.Number getIatTtl() {
                return this.iatTtl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("issuer", om.valueToTree(this.getIssuer()));
                if (this.getAuthTtl() != null) {
                    data.set("authTtl", om.valueToTree(this.getAuthTtl()));
                }
                if (this.getClientId() != null) {
                    data.set("clientId", om.valueToTree(this.getClientId()));
                }
                if (this.getIatTtl() != null) {
                    data.set("iatTtl", om.valueToTree(this.getIatTtl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnApi.OpenIDConnectConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenIDConnectConfigProperty.Jsii$Proxy that = (OpenIDConnectConfigProperty.Jsii$Proxy) o;

                if (!issuer.equals(that.issuer)) return false;
                if (this.authTtl != null ? !this.authTtl.equals(that.authTtl) : that.authTtl != null) return false;
                if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) return false;
                return this.iatTtl != null ? this.iatTtl.equals(that.iatTtl) : that.iatTtl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.issuer.hashCode();
                result = 31 * result + (this.authTtl != null ? this.authTtl.hashCode() : 0);
                result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
                result = 31 * result + (this.iatTtl != null ? this.iatTtl.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.CfnApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.CfnApi> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.CfnApiProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.CfnApiProps.Builder();
        }

        /**
         * The name of the <code>Api</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-name</a>
         * @param name The name of the <code>Api</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for an Event API.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-eventconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-eventconfig</a>
         * @param eventConfig Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for an Event API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventConfig(final software.amazon.awscdk.IResolvable eventConfig) {
            this.props.eventConfig(eventConfig);
            return this;
        }
        /**
         * Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for an Event API.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-eventconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-eventconfig</a>
         * @param eventConfig Describes the authorization configuration for connections, message publishing, message subscriptions, and logging for an Event API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventConfig(final software.amazon.awscdk.services.appsync.CfnApi.EventConfigProperty eventConfig) {
            this.props.eventConfig(eventConfig);
            return this;
        }

        /**
         * The owner contact information for an API resource.
         * <p>
         * This field accepts any string input with a length of 0 - 256 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-ownercontact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-ownercontact</a>
         * @param ownerContact The owner contact information for an API resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ownerContact(final java.lang.String ownerContact) {
            this.props.ownerContact(ownerContact);
            return this;
        }

        /**
         * A set of tags (key-value pairs) for this API.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-api.html#cfn-appsync-api-tags</a>
         * @param tags A set of tags (key-value pairs) for this API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appsync.CfnApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.CfnApi build() {
            return new software.amazon.awscdk.services.appsync.CfnApi(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
