package software.amazon.awscdk.services.appsync;

/**
 * Properties for defining a <code>CfnDataSource</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnDataSourceProps cfnDataSourceProps = CfnDataSourceProps.builder()
 *         .apiId("apiId")
 *         .name("name")
 *         .type("type")
 *         // the properties below are optional
 *         .description("description")
 *         .dynamoDbConfig(DynamoDBConfigProperty.builder()
 *                 .awsRegion("awsRegion")
 *                 .tableName("tableName")
 *                 // the properties below are optional
 *                 .deltaSyncConfig(DeltaSyncConfigProperty.builder()
 *                         .baseTableTtl("baseTableTtl")
 *                         .deltaSyncTableName("deltaSyncTableName")
 *                         .deltaSyncTableTtl("deltaSyncTableTtl")
 *                         .build())
 *                 .useCallerCredentials(false)
 *                 .versioned(false)
 *                 .build())
 *         .elasticsearchConfig(ElasticsearchConfigProperty.builder()
 *                 .awsRegion("awsRegion")
 *                 .endpoint("endpoint")
 *                 .build())
 *         .eventBridgeConfig(EventBridgeConfigProperty.builder()
 *                 .eventBusArn("eventBusArn")
 *                 .build())
 *         .httpConfig(HttpConfigProperty.builder()
 *                 .endpoint("endpoint")
 *                 // the properties below are optional
 *                 .authorizationConfig(AuthorizationConfigProperty.builder()
 *                         .authorizationType("authorizationType")
 *                         // the properties below are optional
 *                         .awsIamConfig(AwsIamConfigProperty.builder()
 *                                 .signingRegion("signingRegion")
 *                                 .signingServiceName("signingServiceName")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .lambdaConfig(LambdaConfigProperty.builder()
 *                 .lambdaFunctionArn("lambdaFunctionArn")
 *                 .build())
 *         .metricsConfig("metricsConfig")
 *         .openSearchServiceConfig(OpenSearchServiceConfigProperty.builder()
 *                 .awsRegion("awsRegion")
 *                 .endpoint("endpoint")
 *                 .build())
 *         .relationalDatabaseConfig(RelationalDatabaseConfigProperty.builder()
 *                 .relationalDatabaseSourceType("relationalDatabaseSourceType")
 *                 // the properties below are optional
 *                 .rdsHttpEndpointConfig(RdsHttpEndpointConfigProperty.builder()
 *                         .awsRegion("awsRegion")
 *                         .awsSecretStoreArn("awsSecretStoreArn")
 *                         .dbClusterIdentifier("dbClusterIdentifier")
 *                         // the properties below are optional
 *                         .databaseName("databaseName")
 *                         .schema("schema")
 *                         .build())
 *                 .build())
 *         .serviceRoleArn("serviceRoleArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:31.120Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnDataSourceProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataSourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Unique AWS AppSync GraphQL API identifier where this data source will be created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-apiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-apiid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiId();

    /**
     * Friendly name for you to identify your AppSync data source after creation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The type of the data source.
     * <p>
     * <ul>
     * <li><em>AWS_LAMBDA</em> : The data source is an AWS Lambda function.</li>
     * <li><em>AMAZON_DYNAMODB</em> : The data source is an Amazon DynamoDB table.</li>
     * <li><em>AMAZON_ELASTICSEARCH</em> : The data source is an Amazon OpenSearch Service domain.</li>
     * <li><em>AMAZON_EVENTBRIDGE</em> : The data source is an Amazon EventBridge event bus.</li>
     * <li><em>AMAZON_OPENSEARCH_SERVICE</em> : The data source is an Amazon OpenSearch Service domain.</li>
     * <li><em>AMAZON_BEDROCK_RUNTIME</em> : The data source is the Amazon Bedrock runtime.</li>
     * <li><em>NONE</em> : There is no data source. This type is used when you wish to invoke a GraphQL operation without connecting to a data source, such as performing data transformation with resolvers or triggering a subscription to be invoked from a mutation.</li>
     * <li><em>HTTP</em> : The data source is an HTTP endpoint.</li>
     * <li><em>RELATIONAL_DATABASE</em> : The data source is a relational database.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The description of the data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * AWS Region and TableName for an Amazon DynamoDB table in your account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-dynamodbconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-dynamodbconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbConfig() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-elasticsearchconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-elasticsearchconfig</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchConfig() {
        return null;
    }

    /**
     * An EventBridge configuration that contains a valid ARN of an event bus.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-eventbridgeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-eventbridgeconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEventBridgeConfig() {
        return null;
    }

    /**
     * Endpoints for an HTTP data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-httpconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-httpconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHttpConfig() {
        return null;
    }

    /**
     * An ARN of a Lambda function in valid ARN format.
     * <p>
     * This can be the ARN of a Lambda function that exists in the current account or in another account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-lambdaconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-lambdaconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaConfig() {
        return null;
    }

    /**
     * Enables or disables enhanced data source metrics for specified data sources.
     * <p>
     * Note that <code>MetricsConfig</code> won't be used unless the <code>dataSourceLevelMetricsBehavior</code> value is set to <code>PER_DATA_SOURCE_METRICS</code> . If the <code>dataSourceLevelMetricsBehavior</code> is set to <code>FULL_REQUEST_DATA_SOURCE_METRICS</code> instead, <code>MetricsConfig</code> will be ignored. However, you can still set its value.
     * <p>
     * <code>MetricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-metricsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-metricsconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMetricsConfig() {
        return null;
    }

    /**
     * AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-opensearchserviceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-opensearchserviceconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOpenSearchServiceConfig() {
        return null;
    }

    /**
     * Relational Database configuration of the relational database data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-relationaldatabaseconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-relationaldatabaseconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRelationalDatabaseConfig() {
        return null;
    }

    /**
     * The AWS Identity and Access Management service role ARN for the data source.
     * <p>
     * The system assumes this role when accessing the data source.
     * <p>
     * Required if <code>Type</code> is specified as <code>AWS_LAMBDA</code> , <code>AMAZON_DYNAMODB</code> , <code>AMAZON_ELASTICSEARCH</code> , <code>AMAZON_EVENTBRIDGE</code> , <code>AMAZON_OPENSEARCH_SERVICE</code> , <code>RELATIONAL_DATABASE</code> , or <code>AMAZON_BEDROCK_RUNTIME</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-servicerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-datasource.html#cfn-appsync-datasource-servicerolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceRoleArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataSourceProps> {
        java.lang.String apiId;
        java.lang.String name;
        java.lang.String type;
        java.lang.String description;
        java.lang.Object dynamoDbConfig;
        java.lang.Object elasticsearchConfig;
        java.lang.Object eventBridgeConfig;
        java.lang.Object httpConfig;
        java.lang.Object lambdaConfig;
        java.lang.String metricsConfig;
        java.lang.Object openSearchServiceConfig;
        java.lang.Object relationalDatabaseConfig;
        java.lang.String serviceRoleArn;

        /**
         * Sets the value of {@link CfnDataSourceProps#getApiId}
         * @param apiId Unique AWS AppSync GraphQL API identifier where this data source will be created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getName}
         * @param name Friendly name for you to identify your AppSync data source after creation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getType}
         * @param type The type of the data source. This parameter is required.
         *             <ul>
         *             <li><em>AWS_LAMBDA</em> : The data source is an AWS Lambda function.</li>
         *             <li><em>AMAZON_DYNAMODB</em> : The data source is an Amazon DynamoDB table.</li>
         *             <li><em>AMAZON_ELASTICSEARCH</em> : The data source is an Amazon OpenSearch Service domain.</li>
         *             <li><em>AMAZON_EVENTBRIDGE</em> : The data source is an Amazon EventBridge event bus.</li>
         *             <li><em>AMAZON_OPENSEARCH_SERVICE</em> : The data source is an Amazon OpenSearch Service domain.</li>
         *             <li><em>AMAZON_BEDROCK_RUNTIME</em> : The data source is the Amazon Bedrock runtime.</li>
         *             <li><em>NONE</em> : There is no data source. This type is used when you wish to invoke a GraphQL operation without connecting to a data source, such as performing data transformation with resolvers or triggering a subscription to be invoked from a mutation.</li>
         *             <li><em>HTTP</em> : The data source is an HTTP endpoint.</li>
         *             <li><em>RELATIONAL_DATABASE</em> : The data source is a relational database.</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDescription}
         * @param description The description of the data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDynamoDbConfig}
         * @param dynamoDbConfig AWS Region and TableName for an Amazon DynamoDB table in your account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dynamoDbConfig(software.amazon.awscdk.IResolvable dynamoDbConfig) {
            this.dynamoDbConfig = dynamoDbConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getDynamoDbConfig}
         * @param dynamoDbConfig AWS Region and TableName for an Amazon DynamoDB table in your account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dynamoDbConfig(software.amazon.awscdk.services.appsync.CfnDataSource.DynamoDBConfigProperty dynamoDbConfig) {
            this.dynamoDbConfig = dynamoDbConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getElasticsearchConfig}
         * @param elasticsearchConfig the value to be set.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder elasticsearchConfig(software.amazon.awscdk.IResolvable elasticsearchConfig) {
            this.elasticsearchConfig = elasticsearchConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getElasticsearchConfig}
         * @param elasticsearchConfig the value to be set.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder elasticsearchConfig(software.amazon.awscdk.services.appsync.CfnDataSource.ElasticsearchConfigProperty elasticsearchConfig) {
            this.elasticsearchConfig = elasticsearchConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getEventBridgeConfig}
         * @param eventBridgeConfig An EventBridge configuration that contains a valid ARN of an event bus.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBridgeConfig(software.amazon.awscdk.IResolvable eventBridgeConfig) {
            this.eventBridgeConfig = eventBridgeConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getEventBridgeConfig}
         * @param eventBridgeConfig An EventBridge configuration that contains a valid ARN of an event bus.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBridgeConfig(software.amazon.awscdk.services.appsync.CfnDataSource.EventBridgeConfigProperty eventBridgeConfig) {
            this.eventBridgeConfig = eventBridgeConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getHttpConfig}
         * @param httpConfig Endpoints for an HTTP data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpConfig(software.amazon.awscdk.IResolvable httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getHttpConfig}
         * @param httpConfig Endpoints for an HTTP data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpConfig(software.amazon.awscdk.services.appsync.CfnDataSource.HttpConfigProperty httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getLambdaConfig}
         * @param lambdaConfig An ARN of a Lambda function in valid ARN format.
         *                     This can be the ARN of a Lambda function that exists in the current account or in another account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaConfig(software.amazon.awscdk.IResolvable lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getLambdaConfig}
         * @param lambdaConfig An ARN of a Lambda function in valid ARN format.
         *                     This can be the ARN of a Lambda function that exists in the current account or in another account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaConfig(software.amazon.awscdk.services.appsync.CfnDataSource.LambdaConfigProperty lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getMetricsConfig}
         * @param metricsConfig Enables or disables enhanced data source metrics for specified data sources.
         *                      Note that <code>MetricsConfig</code> won't be used unless the <code>dataSourceLevelMetricsBehavior</code> value is set to <code>PER_DATA_SOURCE_METRICS</code> . If the <code>dataSourceLevelMetricsBehavior</code> is set to <code>FULL_REQUEST_DATA_SOURCE_METRICS</code> instead, <code>MetricsConfig</code> will be ignored. However, you can still set its value.
         *                      <p>
         *                      <code>MetricsConfig</code> can be <code>ENABLED</code> or <code>DISABLED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsConfig(java.lang.String metricsConfig) {
            this.metricsConfig = metricsConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getOpenSearchServiceConfig}
         * @param openSearchServiceConfig AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openSearchServiceConfig(software.amazon.awscdk.IResolvable openSearchServiceConfig) {
            this.openSearchServiceConfig = openSearchServiceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getOpenSearchServiceConfig}
         * @param openSearchServiceConfig AWS Region and Endpoints for an Amazon OpenSearch Service domain in your account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openSearchServiceConfig(software.amazon.awscdk.services.appsync.CfnDataSource.OpenSearchServiceConfigProperty openSearchServiceConfig) {
            this.openSearchServiceConfig = openSearchServiceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getRelationalDatabaseConfig}
         * @param relationalDatabaseConfig Relational Database configuration of the relational database data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseConfig(software.amazon.awscdk.IResolvable relationalDatabaseConfig) {
            this.relationalDatabaseConfig = relationalDatabaseConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getRelationalDatabaseConfig}
         * @param relationalDatabaseConfig Relational Database configuration of the relational database data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseConfig(software.amazon.awscdk.services.appsync.CfnDataSource.RelationalDatabaseConfigProperty relationalDatabaseConfig) {
            this.relationalDatabaseConfig = relationalDatabaseConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataSourceProps#getServiceRoleArn}
         * @param serviceRoleArn The AWS Identity and Access Management service role ARN for the data source.
         *                       The system assumes this role when accessing the data source.
         *                       <p>
         *                       Required if <code>Type</code> is specified as <code>AWS_LAMBDA</code> , <code>AMAZON_DYNAMODB</code> , <code>AMAZON_ELASTICSEARCH</code> , <code>AMAZON_EVENTBRIDGE</code> , <code>AMAZON_OPENSEARCH_SERVICE</code> , <code>RELATIONAL_DATABASE</code> , or <code>AMAZON_BEDROCK_RUNTIME</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRoleArn(java.lang.String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataSourceProps {
        private final java.lang.String apiId;
        private final java.lang.String name;
        private final java.lang.String type;
        private final java.lang.String description;
        private final java.lang.Object dynamoDbConfig;
        private final java.lang.Object elasticsearchConfig;
        private final java.lang.Object eventBridgeConfig;
        private final java.lang.Object httpConfig;
        private final java.lang.Object lambdaConfig;
        private final java.lang.String metricsConfig;
        private final java.lang.Object openSearchServiceConfig;
        private final java.lang.Object relationalDatabaseConfig;
        private final java.lang.String serviceRoleArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dynamoDbConfig = software.amazon.jsii.Kernel.get(this, "dynamoDbConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.elasticsearchConfig = software.amazon.jsii.Kernel.get(this, "elasticsearchConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.eventBridgeConfig = software.amazon.jsii.Kernel.get(this, "eventBridgeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.httpConfig = software.amazon.jsii.Kernel.get(this, "httpConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.lambdaConfig = software.amazon.jsii.Kernel.get(this, "lambdaConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.metricsConfig = software.amazon.jsii.Kernel.get(this, "metricsConfig", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.openSearchServiceConfig = software.amazon.jsii.Kernel.get(this, "openSearchServiceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.relationalDatabaseConfig = software.amazon.jsii.Kernel.get(this, "relationalDatabaseConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serviceRoleArn = software.amazon.jsii.Kernel.get(this, "serviceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiId = java.util.Objects.requireNonNull(builder.apiId, "apiId is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.description = builder.description;
            this.dynamoDbConfig = builder.dynamoDbConfig;
            this.elasticsearchConfig = builder.elasticsearchConfig;
            this.eventBridgeConfig = builder.eventBridgeConfig;
            this.httpConfig = builder.httpConfig;
            this.lambdaConfig = builder.lambdaConfig;
            this.metricsConfig = builder.metricsConfig;
            this.openSearchServiceConfig = builder.openSearchServiceConfig;
            this.relationalDatabaseConfig = builder.relationalDatabaseConfig;
            this.serviceRoleArn = builder.serviceRoleArn;
        }

        @Override
        public final java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getDynamoDbConfig() {
            return this.dynamoDbConfig;
        }

        @Override
        public final java.lang.Object getElasticsearchConfig() {
            return this.elasticsearchConfig;
        }

        @Override
        public final java.lang.Object getEventBridgeConfig() {
            return this.eventBridgeConfig;
        }

        @Override
        public final java.lang.Object getHttpConfig() {
            return this.httpConfig;
        }

        @Override
        public final java.lang.Object getLambdaConfig() {
            return this.lambdaConfig;
        }

        @Override
        public final java.lang.String getMetricsConfig() {
            return this.metricsConfig;
        }

        @Override
        public final java.lang.Object getOpenSearchServiceConfig() {
            return this.openSearchServiceConfig;
        }

        @Override
        public final java.lang.Object getRelationalDatabaseConfig() {
            return this.relationalDatabaseConfig;
        }

        @Override
        public final java.lang.String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiId", om.valueToTree(this.getApiId()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDynamoDbConfig() != null) {
                data.set("dynamoDbConfig", om.valueToTree(this.getDynamoDbConfig()));
            }
            if (this.getElasticsearchConfig() != null) {
                data.set("elasticsearchConfig", om.valueToTree(this.getElasticsearchConfig()));
            }
            if (this.getEventBridgeConfig() != null) {
                data.set("eventBridgeConfig", om.valueToTree(this.getEventBridgeConfig()));
            }
            if (this.getHttpConfig() != null) {
                data.set("httpConfig", om.valueToTree(this.getHttpConfig()));
            }
            if (this.getLambdaConfig() != null) {
                data.set("lambdaConfig", om.valueToTree(this.getLambdaConfig()));
            }
            if (this.getMetricsConfig() != null) {
                data.set("metricsConfig", om.valueToTree(this.getMetricsConfig()));
            }
            if (this.getOpenSearchServiceConfig() != null) {
                data.set("openSearchServiceConfig", om.valueToTree(this.getOpenSearchServiceConfig()));
            }
            if (this.getRelationalDatabaseConfig() != null) {
                data.set("relationalDatabaseConfig", om.valueToTree(this.getRelationalDatabaseConfig()));
            }
            if (this.getServiceRoleArn() != null) {
                data.set("serviceRoleArn", om.valueToTree(this.getServiceRoleArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnDataSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataSourceProps.Jsii$Proxy that = (CfnDataSourceProps.Jsii$Proxy) o;

            if (!apiId.equals(that.apiId)) return false;
            if (!name.equals(that.name)) return false;
            if (!type.equals(that.type)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.dynamoDbConfig != null ? !this.dynamoDbConfig.equals(that.dynamoDbConfig) : that.dynamoDbConfig != null) return false;
            if (this.elasticsearchConfig != null ? !this.elasticsearchConfig.equals(that.elasticsearchConfig) : that.elasticsearchConfig != null) return false;
            if (this.eventBridgeConfig != null ? !this.eventBridgeConfig.equals(that.eventBridgeConfig) : that.eventBridgeConfig != null) return false;
            if (this.httpConfig != null ? !this.httpConfig.equals(that.httpConfig) : that.httpConfig != null) return false;
            if (this.lambdaConfig != null ? !this.lambdaConfig.equals(that.lambdaConfig) : that.lambdaConfig != null) return false;
            if (this.metricsConfig != null ? !this.metricsConfig.equals(that.metricsConfig) : that.metricsConfig != null) return false;
            if (this.openSearchServiceConfig != null ? !this.openSearchServiceConfig.equals(that.openSearchServiceConfig) : that.openSearchServiceConfig != null) return false;
            if (this.relationalDatabaseConfig != null ? !this.relationalDatabaseConfig.equals(that.relationalDatabaseConfig) : that.relationalDatabaseConfig != null) return false;
            return this.serviceRoleArn != null ? this.serviceRoleArn.equals(that.serviceRoleArn) : that.serviceRoleArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiId.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.dynamoDbConfig != null ? this.dynamoDbConfig.hashCode() : 0);
            result = 31 * result + (this.elasticsearchConfig != null ? this.elasticsearchConfig.hashCode() : 0);
            result = 31 * result + (this.eventBridgeConfig != null ? this.eventBridgeConfig.hashCode() : 0);
            result = 31 * result + (this.httpConfig != null ? this.httpConfig.hashCode() : 0);
            result = 31 * result + (this.lambdaConfig != null ? this.lambdaConfig.hashCode() : 0);
            result = 31 * result + (this.metricsConfig != null ? this.metricsConfig.hashCode() : 0);
            result = 31 * result + (this.openSearchServiceConfig != null ? this.openSearchServiceConfig.hashCode() : 0);
            result = 31 * result + (this.relationalDatabaseConfig != null ? this.relationalDatabaseConfig.hashCode() : 0);
            result = 31 * result + (this.serviceRoleArn != null ? this.serviceRoleArn.hashCode() : 0);
            return result;
        }
    }
}
