package software.amazon.awscdk.services.b2bi;

/**
 * Properties for defining a <code>CfnTransformer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.b2bi.*;
 * CfnTransformerProps cfnTransformerProps = CfnTransformerProps.builder()
 *         .name("name")
 *         .status("status")
 *         // the properties below are optional
 *         .ediType(EdiTypeProperty.builder()
 *                 .x12Details(X12DetailsProperty.builder()
 *                         .transactionSet("transactionSet")
 *                         .version("version")
 *                         .build())
 *                 .build())
 *         .fileFormat("fileFormat")
 *         .inputConversion(InputConversionProperty.builder()
 *                 .fromFormat("fromFormat")
 *                 // the properties below are optional
 *                 .advancedOptions(AdvancedOptionsProperty.builder()
 *                         .x12(X12AdvancedOptionsProperty.builder()
 *                                 .splitOptions(X12SplitOptionsProperty.builder()
 *                                         .splitBy("splitBy")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .formatOptions(FormatOptionsProperty.builder()
 *                         .x12(X12DetailsProperty.builder()
 *                                 .transactionSet("transactionSet")
 *                                 .version("version")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .mapping(MappingProperty.builder()
 *                 .templateLanguage("templateLanguage")
 *                 // the properties below are optional
 *                 .template("template")
 *                 .build())
 *         .mappingTemplate("mappingTemplate")
 *         .outputConversion(OutputConversionProperty.builder()
 *                 .toFormat("toFormat")
 *                 // the properties below are optional
 *                 .formatOptions(FormatOptionsProperty.builder()
 *                         .x12(X12DetailsProperty.builder()
 *                                 .transactionSet("transactionSet")
 *                                 .version("version")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .sampleDocument("sampleDocument")
 *         .sampleDocuments(SampleDocumentsProperty.builder()
 *                 .bucketName("bucketName")
 *                 .keys(List.of(SampleDocumentKeysProperty.builder()
 *                         .input("input")
 *                         .output("output")
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:31.520Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformerProps")
@software.amazon.jsii.Jsii.Proxy(CfnTransformerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTransformerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Returns the descriptive name for the transformer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Returns the state of the newly created transformer.
     * <p>
     * The transformer can be either <code>active</code> or <code>inactive</code> . For the transformer to be used in a capability, its status must <code>active</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-status</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStatus();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-editype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-editype</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Object getEdiType() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-fileformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-fileformat</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getFileFormat() {
        return null;
    }

    /**
     * Returns a structure that contains the format options for the transformation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-inputconversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-inputconversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInputConversion() {
        return null;
    }

    /**
     * Returns the structure that contains the mapping template and its language (either XSLT or JSONATA).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-mapping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-mapping</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMapping() {
        return null;
    }

    /**
     * (deprecated) This shape is deprecated: This is a legacy trait.
     * <p>
     * Please use input-conversion or output-conversion.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-mappingtemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-mappingtemplate</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getMappingTemplate() {
        return null;
    }

    /**
     * Returns the <code>OutputConversion</code> object, which contains the format options for the outbound transformation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-outputconversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-outputconversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOutputConversion() {
        return null;
    }

    /**
     * (deprecated) This shape is deprecated: This is a legacy trait.
     * <p>
     * Please use input-conversion or output-conversion.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-sampledocument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-sampledocument</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getSampleDocument() {
        return null;
    }

    /**
     * Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-sampledocuments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-sampledocuments</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSampleDocuments() {
        return null;
    }

    /**
     * A key-value pair for a specific transformer.
     * <p>
     * Tags are metadata that you can use to search for and group capabilities for various purposes.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTransformerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTransformerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTransformerProps> {
        java.lang.String name;
        java.lang.String status;
        java.lang.Object ediType;
        java.lang.String fileFormat;
        java.lang.Object inputConversion;
        java.lang.Object mapping;
        java.lang.String mappingTemplate;
        java.lang.Object outputConversion;
        java.lang.String sampleDocument;
        java.lang.Object sampleDocuments;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnTransformerProps#getName}
         * @param name Returns the descriptive name for the transformer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getStatus}
         * @param status Returns the state of the newly created transformer. This parameter is required.
         *               The transformer can be either <code>active</code> or <code>inactive</code> . For the transformer to be used in a capability, its status must <code>active</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getEdiType}
         * @param ediType the value to be set.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder ediType(software.amazon.awscdk.IResolvable ediType) {
            this.ediType = ediType;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getEdiType}
         * @param ediType the value to be set.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder ediType(software.amazon.awscdk.services.b2bi.CfnTransformer.EdiTypeProperty ediType) {
            this.ediType = ediType;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getFileFormat}
         * @param fileFormat the value to be set.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder fileFormat(java.lang.String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getInputConversion}
         * @param inputConversion Returns a structure that contains the format options for the transformation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputConversion(software.amazon.awscdk.IResolvable inputConversion) {
            this.inputConversion = inputConversion;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getInputConversion}
         * @param inputConversion Returns a structure that contains the format options for the transformation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputConversion(software.amazon.awscdk.services.b2bi.CfnTransformer.InputConversionProperty inputConversion) {
            this.inputConversion = inputConversion;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getMapping}
         * @param mapping Returns the structure that contains the mapping template and its language (either XSLT or JSONATA).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapping(software.amazon.awscdk.IResolvable mapping) {
            this.mapping = mapping;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getMapping}
         * @param mapping Returns the structure that contains the mapping template and its language (either XSLT or JSONATA).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapping(software.amazon.awscdk.services.b2bi.CfnTransformer.MappingProperty mapping) {
            this.mapping = mapping;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getMappingTemplate}
         * @param mappingTemplate This shape is deprecated: This is a legacy trait.
         *                        Please use input-conversion or output-conversion.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder mappingTemplate(java.lang.String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getOutputConversion}
         * @param outputConversion Returns the <code>OutputConversion</code> object, which contains the format options for the outbound transformation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputConversion(software.amazon.awscdk.IResolvable outputConversion) {
            this.outputConversion = outputConversion;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getOutputConversion}
         * @param outputConversion Returns the <code>OutputConversion</code> object, which contains the format options for the outbound transformation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputConversion(software.amazon.awscdk.services.b2bi.CfnTransformer.OutputConversionProperty outputConversion) {
            this.outputConversion = outputConversion;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getSampleDocument}
         * @param sampleDocument This shape is deprecated: This is a legacy trait.
         *                       Please use input-conversion or output-conversion.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder sampleDocument(java.lang.String sampleDocument) {
            this.sampleDocument = sampleDocument;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getSampleDocuments}
         * @param sampleDocuments Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sampleDocuments(software.amazon.awscdk.IResolvable sampleDocuments) {
            this.sampleDocuments = sampleDocuments;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getSampleDocuments}
         * @param sampleDocuments Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sampleDocuments(software.amazon.awscdk.services.b2bi.CfnTransformer.SampleDocumentsProperty sampleDocuments) {
            this.sampleDocuments = sampleDocuments;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransformerProps#getTags}
         * @param tags A key-value pair for a specific transformer.
         *             Tags are metadata that you can use to search for and group capabilities for various purposes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTransformerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTransformerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTransformerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTransformerProps {
        private final java.lang.String name;
        private final java.lang.String status;
        private final java.lang.Object ediType;
        private final java.lang.String fileFormat;
        private final java.lang.Object inputConversion;
        private final java.lang.Object mapping;
        private final java.lang.String mappingTemplate;
        private final java.lang.Object outputConversion;
        private final java.lang.String sampleDocument;
        private final java.lang.Object sampleDocuments;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ediType = software.amazon.jsii.Kernel.get(this, "ediType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.fileFormat = software.amazon.jsii.Kernel.get(this, "fileFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inputConversion = software.amazon.jsii.Kernel.get(this, "inputConversion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mapping = software.amazon.jsii.Kernel.get(this, "mapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mappingTemplate = software.amazon.jsii.Kernel.get(this, "mappingTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputConversion = software.amazon.jsii.Kernel.get(this, "outputConversion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sampleDocument = software.amazon.jsii.Kernel.get(this, "sampleDocument", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sampleDocuments = software.amazon.jsii.Kernel.get(this, "sampleDocuments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
            this.ediType = builder.ediType;
            this.fileFormat = builder.fileFormat;
            this.inputConversion = builder.inputConversion;
            this.mapping = builder.mapping;
            this.mappingTemplate = builder.mappingTemplate;
            this.outputConversion = builder.outputConversion;
            this.sampleDocument = builder.sampleDocument;
            this.sampleDocuments = builder.sampleDocuments;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        public final java.lang.Object getEdiType() {
            return this.ediType;
        }

        @Override
        public final java.lang.String getFileFormat() {
            return this.fileFormat;
        }

        @Override
        public final java.lang.Object getInputConversion() {
            return this.inputConversion;
        }

        @Override
        public final java.lang.Object getMapping() {
            return this.mapping;
        }

        @Override
        public final java.lang.String getMappingTemplate() {
            return this.mappingTemplate;
        }

        @Override
        public final java.lang.Object getOutputConversion() {
            return this.outputConversion;
        }

        @Override
        public final java.lang.String getSampleDocument() {
            return this.sampleDocument;
        }

        @Override
        public final java.lang.Object getSampleDocuments() {
            return this.sampleDocuments;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("status", om.valueToTree(this.getStatus()));
            if (this.getEdiType() != null) {
                data.set("ediType", om.valueToTree(this.getEdiType()));
            }
            if (this.getFileFormat() != null) {
                data.set("fileFormat", om.valueToTree(this.getFileFormat()));
            }
            if (this.getInputConversion() != null) {
                data.set("inputConversion", om.valueToTree(this.getInputConversion()));
            }
            if (this.getMapping() != null) {
                data.set("mapping", om.valueToTree(this.getMapping()));
            }
            if (this.getMappingTemplate() != null) {
                data.set("mappingTemplate", om.valueToTree(this.getMappingTemplate()));
            }
            if (this.getOutputConversion() != null) {
                data.set("outputConversion", om.valueToTree(this.getOutputConversion()));
            }
            if (this.getSampleDocument() != null) {
                data.set("sampleDocument", om.valueToTree(this.getSampleDocument()));
            }
            if (this.getSampleDocuments() != null) {
                data.set("sampleDocuments", om.valueToTree(this.getSampleDocuments()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTransformerProps.Jsii$Proxy that = (CfnTransformerProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!status.equals(that.status)) return false;
            if (this.ediType != null ? !this.ediType.equals(that.ediType) : that.ediType != null) return false;
            if (this.fileFormat != null ? !this.fileFormat.equals(that.fileFormat) : that.fileFormat != null) return false;
            if (this.inputConversion != null ? !this.inputConversion.equals(that.inputConversion) : that.inputConversion != null) return false;
            if (this.mapping != null ? !this.mapping.equals(that.mapping) : that.mapping != null) return false;
            if (this.mappingTemplate != null ? !this.mappingTemplate.equals(that.mappingTemplate) : that.mappingTemplate != null) return false;
            if (this.outputConversion != null ? !this.outputConversion.equals(that.outputConversion) : that.outputConversion != null) return false;
            if (this.sampleDocument != null ? !this.sampleDocument.equals(that.sampleDocument) : that.sampleDocument != null) return false;
            if (this.sampleDocuments != null ? !this.sampleDocuments.equals(that.sampleDocuments) : that.sampleDocuments != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.status.hashCode());
            result = 31 * result + (this.ediType != null ? this.ediType.hashCode() : 0);
            result = 31 * result + (this.fileFormat != null ? this.fileFormat.hashCode() : 0);
            result = 31 * result + (this.inputConversion != null ? this.inputConversion.hashCode() : 0);
            result = 31 * result + (this.mapping != null ? this.mapping.hashCode() : 0);
            result = 31 * result + (this.mappingTemplate != null ? this.mappingTemplate.hashCode() : 0);
            result = 31 * result + (this.outputConversion != null ? this.outputConversion.hashCode() : 0);
            result = 31 * result + (this.sampleDocument != null ? this.sampleDocument.hashCode() : 0);
            result = 31 * result + (this.sampleDocuments != null ? this.sampleDocuments.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
