package software.amazon.awscdk.services.batch;

/**
 * A Volume that can be mounted to a container supported by EKS.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EksJobDefinition jobDefn = EksJobDefinition.Builder.create(this, "eksf2")
 *         .container(EksContainerDefinition.Builder.create(this, "container")
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .volumes(List.of(EksVolume.emptyDir(EmptyDirVolumeOptions.builder()
 *                         .name("myEmptyDirVolume")
 *                         .mountPath("/mount/path")
 *                         .medium(EmptyDirMediumType.MEMORY)
 *                         .readonly(true)
 *                         .sizeLimit(Size.mebibytes(2048))
 *                         .build())))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:31.727Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EksVolume")
public abstract class EksVolume extends software.amazon.jsii.JsiiObject {

    protected EksVolume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EksVolume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected EksVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EksVolumeOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Creates a Kubernetes EmptyDir volume.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes/#emptydir">https://kubernetes.io/docs/concepts/storage/volumes/#emptydir</a>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EmptyDirVolume emptyDir(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EmptyDirVolumeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.EksVolume.class, "emptyDir", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EmptyDirVolume.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Creates a Kubernetes HostPath volume.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">https://kubernetes.io/docs/concepts/storage/volumes/#hostpath</a>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.HostPathVolume hostPath(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.HostPathVolumeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.EksVolume.class, "hostPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.HostPathVolume.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Creates a Kubernetes Secret volume.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes/#secret">https://kubernetes.io/docs/concepts/storage/volumes/#secret</a>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.SecretPathVolume secret(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.SecretPathVolumeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.EksVolume.class, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.SecretPathVolume.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * The name of this volume.
     * <p>
     * The name must be a valid DNS subdomain name.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The path on the container where the container is mounted.
     * <p>
     * Default: - the container is not mounted
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getContainerPath() {
        return software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If specified, the container has readonly access to the volume.
     * <p>
     * Otherwise, the container has read/write access.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getReadonly() {
        return software.amazon.jsii.Kernel.get(this, "readonly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.batch.EksVolume {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
