package software.amazon.awscdk.services.bedrock;

/**
 * Creates a guardrail to detect and filter harmful content in your generative AI application.
 * <p>
 * Amazon Bedrock Guardrails provides the following safeguards (also known as policies) to detect and filter harmful content:
 * <p>
 * <ul>
 * <li><em>Content filters</em> - Detect and filter harmful text or image content in input prompts or model responses. Filtering is done based on detection of certain predefined harmful content categories: Hate, Insults, Sexual, Violence, Misconduct and Prompt Attack. You also can adjust the filter strength for each of these categories.</li>
 * <li><em>Denied topics</em> - Define a set of topics that are undesirable in the context of your application. The filter will help block them if detected in user queries or model responses.</li>
 * <li><em>Word filters</em> - Configure filters to help block undesirable words, phrases, and profanity (exact match). Such words can include offensive terms, competitor names, etc.</li>
 * <li><em>Sensitive information filters</em> - Configure filters to help block or mask sensitive information, such as personally identifiable information (PII), or custom regex in user inputs and model responses. Blocking or masking is done based on probabilistic detection of sensitive information in standard formats in entities such as SSN number, Date of Birth, address, etc. This also allows configuring regular expression based detection of patterns for identifiers.</li>
 * <li><em>Contextual grounding check</em> - Help detect and filter hallucinations in model responses based on grounding in a source and relevance to the user query.</li>
 * </ul>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-how.html">How Amazon Bedrock Guardrails works</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * CfnGuardrail cfnGuardrail = CfnGuardrail.Builder.create(this, "MyCfnGuardrail")
 *         .blockedInputMessaging("blockedInputMessaging")
 *         .blockedOutputsMessaging("blockedOutputsMessaging")
 *         .name("name")
 *         // the properties below are optional
 *         .contentPolicyConfig(ContentPolicyConfigProperty.builder()
 *                 .filtersConfig(List.of(ContentFilterConfigProperty.builder()
 *                         .inputStrength("inputStrength")
 *                         .outputStrength("outputStrength")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .inputAction("inputAction")
 *                         .inputEnabled(false)
 *                         .inputModalities(List.of("inputModalities"))
 *                         .outputAction("outputAction")
 *                         .outputEnabled(false)
 *                         .outputModalities(List.of("outputModalities"))
 *                         .build()))
 *                 // the properties below are optional
 *                 .contentFiltersTierConfig(ContentFiltersTierConfigProperty.builder()
 *                         .tierName("tierName")
 *                         .build())
 *                 .build())
 *         .contextualGroundingPolicyConfig(ContextualGroundingPolicyConfigProperty.builder()
 *                 .filtersConfig(List.of(ContextualGroundingFilterConfigProperty.builder()
 *                         .threshold(123)
 *                         .type("type")
 *                         // the properties below are optional
 *                         .action("action")
 *                         .enabled(false)
 *                         .build()))
 *                 .build())
 *         .crossRegionConfig(GuardrailCrossRegionConfigProperty.builder()
 *                 .guardrailProfileArn("guardrailProfileArn")
 *                 .build())
 *         .description("description")
 *         .kmsKeyArn("kmsKeyArn")
 *         .sensitiveInformationPolicyConfig(SensitiveInformationPolicyConfigProperty.builder()
 *                 .piiEntitiesConfig(List.of(PiiEntityConfigProperty.builder()
 *                         .action("action")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .inputAction("inputAction")
 *                         .inputEnabled(false)
 *                         .outputAction("outputAction")
 *                         .outputEnabled(false)
 *                         .build()))
 *                 .regexesConfig(List.of(RegexConfigProperty.builder()
 *                         .action("action")
 *                         .name("name")
 *                         .pattern("pattern")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .inputAction("inputAction")
 *                         .inputEnabled(false)
 *                         .outputAction("outputAction")
 *                         .outputEnabled(false)
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .topicPolicyConfig(TopicPolicyConfigProperty.builder()
 *                 .topicsConfig(List.of(TopicConfigProperty.builder()
 *                         .definition("definition")
 *                         .name("name")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .examples(List.of("examples"))
 *                         .inputAction("inputAction")
 *                         .inputEnabled(false)
 *                         .outputAction("outputAction")
 *                         .outputEnabled(false)
 *                         .build()))
 *                 // the properties below are optional
 *                 .topicsTierConfig(TopicsTierConfigProperty.builder()
 *                         .tierName("tierName")
 *                         .build())
 *                 .build())
 *         .wordPolicyConfig(WordPolicyConfigProperty.builder()
 *                 .managedWordListsConfig(List.of(ManagedWordsConfigProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .inputAction("inputAction")
 *                         .inputEnabled(false)
 *                         .outputAction("outputAction")
 *                         .outputEnabled(false)
 *                         .build()))
 *                 .wordsConfig(List.of(WordConfigProperty.builder()
 *                         .text("text")
 *                         // the properties below are optional
 *                         .inputAction("inputAction")
 *                         .inputEnabled(false)
 *                         .outputAction("outputAction")
 *                         .outputEnabled(false)
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:31.972Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrail")
public class CfnGuardrail extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnGuardrail(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGuardrail(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.CfnGuardrail.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGuardrail(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.CfnGuardrailProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The date and time at which the guardrail was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Appears if the <code>status</code> of the guardrail is <code>FAILED</code> .
     * <p>
     * A list of recommendations to carry out before retrying the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrFailureRecommendations() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrFailureRecommendations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The ARN of the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGuardrailArn() {
        return software.amazon.jsii.Kernel.get(this, "attrGuardrailArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGuardrailId() {
        return software.amazon.jsii.Kernel.get(this, "attrGuardrailId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Appears if the <code>status</code> is <code>FAILED</code> .
     * <p>
     * A list of reasons for why the guardrail failed to be created, updated, versioned, or deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrStatusReasons() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrStatusReasons", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The date and time at which the guardrail was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the guardrail that was created.
     * <p>
     * This value will always be <code>DRAFT</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The message to return when the guardrail blocks a prompt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBlockedInputMessaging() {
        return software.amazon.jsii.Kernel.get(this, "blockedInputMessaging", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The message to return when the guardrail blocks a prompt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBlockedInputMessaging(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "blockedInputMessaging", java.util.Objects.requireNonNull(value, "blockedInputMessaging is required"));
    }

    /**
     * The message to return when the guardrail blocks a model response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBlockedOutputsMessaging() {
        return software.amazon.jsii.Kernel.get(this, "blockedOutputsMessaging", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The message to return when the guardrail blocks a model response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBlockedOutputsMessaging(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "blockedOutputsMessaging", java.util.Objects.requireNonNull(value, "blockedOutputsMessaging is required"));
    }

    /**
     * The name of the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The content filter policies to configure for the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContentPolicyConfig() {
        return software.amazon.jsii.Kernel.get(this, "contentPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The content filter policies to configure for the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContentPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "contentPolicyConfig", value);
    }

    /**
     * The content filter policies to configure for the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContentPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnGuardrail.ContentPolicyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "contentPolicyConfig", value);
    }

    /**
     * Contextual grounding policy config for a guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContextualGroundingPolicyConfig() {
        return software.amazon.jsii.Kernel.get(this, "contextualGroundingPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contextual grounding policy config for a guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContextualGroundingPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "contextualGroundingPolicyConfig", value);
    }

    /**
     * Contextual grounding policy config for a guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContextualGroundingPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnGuardrail.ContextualGroundingPolicyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "contextualGroundingPolicyConfig", value);
    }

    /**
     * The system-defined guardrail profile that you’re using with your guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCrossRegionConfig() {
        return software.amazon.jsii.Kernel.get(this, "crossRegionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The system-defined guardrail profile that you’re using with your guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCrossRegionConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "crossRegionConfig", value);
    }

    /**
     * The system-defined guardrail profile that you’re using with your guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCrossRegionConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnGuardrail.GuardrailCrossRegionConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "crossRegionConfig", value);
    }

    /**
     * A description of the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The ARN of the AWS KMS key that you use to encrypt the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the AWS KMS key that you use to encrypt the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyArn", value);
    }

    /**
     * The sensitive information policy to configure for the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSensitiveInformationPolicyConfig() {
        return software.amazon.jsii.Kernel.get(this, "sensitiveInformationPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The sensitive information policy to configure for the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSensitiveInformationPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sensitiveInformationPolicyConfig", value);
    }

    /**
     * The sensitive information policy to configure for the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSensitiveInformationPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnGuardrail.SensitiveInformationPolicyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "sensitiveInformationPolicyConfig", value);
    }

    /**
     * The tags that you want to attach to the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags that you want to attach to the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * The topic policies to configure for the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTopicPolicyConfig() {
        return software.amazon.jsii.Kernel.get(this, "topicPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The topic policies to configure for the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTopicPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "topicPolicyConfig", value);
    }

    /**
     * The topic policies to configure for the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTopicPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnGuardrail.TopicPolicyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "topicPolicyConfig", value);
    }

    /**
     * The word policy you configure for the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWordPolicyConfig() {
        return software.amazon.jsii.Kernel.get(this, "wordPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The word policy you configure for the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWordPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "wordPolicyConfig", value);
    }

    /**
     * The word policy you configure for the guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWordPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnGuardrail.WordPolicyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "wordPolicyConfig", value);
    }
    /**
     * Contains filter strengths for harmful content.
     * <p>
     * Guardrails support the following content filters to detect and filter harmful user inputs and FM-generated outputs.
     * <p>
     * <ul>
     * <li><em>Hate</em> – Describes language or a statement that discriminates, criticizes, insults, denounces, or dehumanizes a person or group on the basis of an identity (such as race, ethnicity, gender, religion, sexual orientation, ability, and national origin).</li>
     * <li><em>Insults</em> – Describes language or a statement that includes demeaning, humiliating, mocking, insulting, or belittling language. This type of language is also labeled as bullying.</li>
     * <li><em>Sexual</em> – Describes language or a statement that indicates sexual interest, activity, or arousal using direct or indirect references to body parts, physical traits, or sex.</li>
     * <li><em>Violence</em> – Describes language or a statement that includes glorification of or threats to inflict physical pain, hurt, or injury toward a person, group or thing.</li>
     * </ul>
     * <p>
     * Content filtering depends on the confidence classification of user inputs and FM responses across each of the four harmful categories. All input and output statements are classified into one of four confidence levels (NONE, LOW, MEDIUM, HIGH) for each harmful category. For example, if a statement is classified as <em>Hate</em> with HIGH confidence, the likelihood of the statement representing hateful content is high. A single statement can be classified across multiple categories with varying confidence levels. For example, a single statement can be classified as <em>Hate</em> with HIGH confidence, <em>Insults</em> with LOW confidence, <em>Sexual</em> with NONE confidence, and <em>Violence</em> with MEDIUM confidence.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-filters.html">Guardrails content filters</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ContentFilterConfigProperty contentFilterConfigProperty = ContentFilterConfigProperty.builder()
     *         .inputStrength("inputStrength")
     *         .outputStrength("outputStrength")
     *         .type("type")
     *         // the properties below are optional
     *         .inputAction("inputAction")
     *         .inputEnabled(false)
     *         .inputModalities(List.of("inputModalities"))
     *         .outputAction("outputAction")
     *         .outputEnabled(false)
     *         .outputModalities(List.of("outputModalities"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrail.ContentFilterConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ContentFilterConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContentFilterConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The strength of the content filter to apply to prompts.
         * <p>
         * As you increase the filter strength, the likelihood of filtering harmful content increases and the probability of seeing harmful content in your application reduces.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-inputstrength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-inputstrength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInputStrength();

        /**
         * The strength of the content filter to apply to model responses.
         * <p>
         * As you increase the filter strength, the likelihood of filtering harmful content increases and the probability of seeing harmful content in your application reduces.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-outputstrength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-outputstrength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOutputStrength();

        /**
         * The harmful category that the content filter is applied to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-inputaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-inputaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputAction() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-inputenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-inputenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputEnabled() {
            return null;
        }

        /**
         * List of modalities.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-inputmodalities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-inputmodalities</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInputModalities() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-outputaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-outputaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputAction() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-outputenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-outputenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputEnabled() {
            return null;
        }

        /**
         * List of modalities.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-outputmodalities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterconfig.html#cfn-bedrock-guardrail-contentfilterconfig-outputmodalities</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOutputModalities() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContentFilterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContentFilterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContentFilterConfigProperty> {
            java.lang.String inputStrength;
            java.lang.String outputStrength;
            java.lang.String type;
            java.lang.String inputAction;
            java.lang.Object inputEnabled;
            java.util.List<java.lang.String> inputModalities;
            java.lang.String outputAction;
            java.lang.Object outputEnabled;
            java.util.List<java.lang.String> outputModalities;

            /**
             * Sets the value of {@link ContentFilterConfigProperty#getInputStrength}
             * @param inputStrength The strength of the content filter to apply to prompts. This parameter is required.
             *                      As you increase the filter strength, the likelihood of filtering harmful content increases and the probability of seeing harmful content in your application reduces.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputStrength(java.lang.String inputStrength) {
                this.inputStrength = inputStrength;
                return this;
            }

            /**
             * Sets the value of {@link ContentFilterConfigProperty#getOutputStrength}
             * @param outputStrength The strength of the content filter to apply to model responses. This parameter is required.
             *                       As you increase the filter strength, the likelihood of filtering harmful content increases and the probability of seeing harmful content in your application reduces.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputStrength(java.lang.String outputStrength) {
                this.outputStrength = outputStrength;
                return this;
            }

            /**
             * Sets the value of {@link ContentFilterConfigProperty#getType}
             * @param type The harmful category that the content filter is applied to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ContentFilterConfigProperty#getInputAction}
             * @param inputAction the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputAction(java.lang.String inputAction) {
                this.inputAction = inputAction;
                return this;
            }

            /**
             * Sets the value of {@link ContentFilterConfigProperty#getInputEnabled}
             * @param inputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputEnabled(java.lang.Boolean inputEnabled) {
                this.inputEnabled = inputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ContentFilterConfigProperty#getInputEnabled}
             * @param inputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputEnabled(software.amazon.awscdk.IResolvable inputEnabled) {
                this.inputEnabled = inputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ContentFilterConfigProperty#getInputModalities}
             * @param inputModalities List of modalities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputModalities(java.util.List<java.lang.String> inputModalities) {
                this.inputModalities = inputModalities;
                return this;
            }

            /**
             * Sets the value of {@link ContentFilterConfigProperty#getOutputAction}
             * @param outputAction the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputAction(java.lang.String outputAction) {
                this.outputAction = outputAction;
                return this;
            }

            /**
             * Sets the value of {@link ContentFilterConfigProperty#getOutputEnabled}
             * @param outputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputEnabled(java.lang.Boolean outputEnabled) {
                this.outputEnabled = outputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ContentFilterConfigProperty#getOutputEnabled}
             * @param outputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputEnabled(software.amazon.awscdk.IResolvable outputEnabled) {
                this.outputEnabled = outputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ContentFilterConfigProperty#getOutputModalities}
             * @param outputModalities List of modalities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputModalities(java.util.List<java.lang.String> outputModalities) {
                this.outputModalities = outputModalities;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContentFilterConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContentFilterConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContentFilterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContentFilterConfigProperty {
            private final java.lang.String inputStrength;
            private final java.lang.String outputStrength;
            private final java.lang.String type;
            private final java.lang.String inputAction;
            private final java.lang.Object inputEnabled;
            private final java.util.List<java.lang.String> inputModalities;
            private final java.lang.String outputAction;
            private final java.lang.Object outputEnabled;
            private final java.util.List<java.lang.String> outputModalities;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputStrength = software.amazon.jsii.Kernel.get(this, "inputStrength", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputStrength = software.amazon.jsii.Kernel.get(this, "outputStrength", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputAction = software.amazon.jsii.Kernel.get(this, "inputAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputEnabled = software.amazon.jsii.Kernel.get(this, "inputEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputModalities = software.amazon.jsii.Kernel.get(this, "inputModalities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.outputAction = software.amazon.jsii.Kernel.get(this, "outputAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputEnabled = software.amazon.jsii.Kernel.get(this, "outputEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputModalities = software.amazon.jsii.Kernel.get(this, "outputModalities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputStrength = java.util.Objects.requireNonNull(builder.inputStrength, "inputStrength is required");
                this.outputStrength = java.util.Objects.requireNonNull(builder.outputStrength, "outputStrength is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.inputAction = builder.inputAction;
                this.inputEnabled = builder.inputEnabled;
                this.inputModalities = builder.inputModalities;
                this.outputAction = builder.outputAction;
                this.outputEnabled = builder.outputEnabled;
                this.outputModalities = builder.outputModalities;
            }

            @Override
            public final java.lang.String getInputStrength() {
                return this.inputStrength;
            }

            @Override
            public final java.lang.String getOutputStrength() {
                return this.outputStrength;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getInputAction() {
                return this.inputAction;
            }

            @Override
            public final java.lang.Object getInputEnabled() {
                return this.inputEnabled;
            }

            @Override
            public final java.util.List<java.lang.String> getInputModalities() {
                return this.inputModalities;
            }

            @Override
            public final java.lang.String getOutputAction() {
                return this.outputAction;
            }

            @Override
            public final java.lang.Object getOutputEnabled() {
                return this.outputEnabled;
            }

            @Override
            public final java.util.List<java.lang.String> getOutputModalities() {
                return this.outputModalities;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputStrength", om.valueToTree(this.getInputStrength()));
                data.set("outputStrength", om.valueToTree(this.getOutputStrength()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getInputAction() != null) {
                    data.set("inputAction", om.valueToTree(this.getInputAction()));
                }
                if (this.getInputEnabled() != null) {
                    data.set("inputEnabled", om.valueToTree(this.getInputEnabled()));
                }
                if (this.getInputModalities() != null) {
                    data.set("inputModalities", om.valueToTree(this.getInputModalities()));
                }
                if (this.getOutputAction() != null) {
                    data.set("outputAction", om.valueToTree(this.getOutputAction()));
                }
                if (this.getOutputEnabled() != null) {
                    data.set("outputEnabled", om.valueToTree(this.getOutputEnabled()));
                }
                if (this.getOutputModalities() != null) {
                    data.set("outputModalities", om.valueToTree(this.getOutputModalities()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnGuardrail.ContentFilterConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContentFilterConfigProperty.Jsii$Proxy that = (ContentFilterConfigProperty.Jsii$Proxy) o;

                if (!inputStrength.equals(that.inputStrength)) return false;
                if (!outputStrength.equals(that.outputStrength)) return false;
                if (!type.equals(that.type)) return false;
                if (this.inputAction != null ? !this.inputAction.equals(that.inputAction) : that.inputAction != null) return false;
                if (this.inputEnabled != null ? !this.inputEnabled.equals(that.inputEnabled) : that.inputEnabled != null) return false;
                if (this.inputModalities != null ? !this.inputModalities.equals(that.inputModalities) : that.inputModalities != null) return false;
                if (this.outputAction != null ? !this.outputAction.equals(that.outputAction) : that.outputAction != null) return false;
                if (this.outputEnabled != null ? !this.outputEnabled.equals(that.outputEnabled) : that.outputEnabled != null) return false;
                return this.outputModalities != null ? this.outputModalities.equals(that.outputModalities) : that.outputModalities == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputStrength.hashCode();
                result = 31 * result + (this.outputStrength.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.inputAction != null ? this.inputAction.hashCode() : 0);
                result = 31 * result + (this.inputEnabled != null ? this.inputEnabled.hashCode() : 0);
                result = 31 * result + (this.inputModalities != null ? this.inputModalities.hashCode() : 0);
                result = 31 * result + (this.outputAction != null ? this.outputAction.hashCode() : 0);
                result = 31 * result + (this.outputEnabled != null ? this.outputEnabled.hashCode() : 0);
                result = 31 * result + (this.outputModalities != null ? this.outputModalities.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Guardrail tier config for content policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ContentFiltersTierConfigProperty contentFiltersTierConfigProperty = ContentFiltersTierConfigProperty.builder()
     *         .tierName("tierName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterstierconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterstierconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrail.ContentFiltersTierConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ContentFiltersTierConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContentFiltersTierConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Tier name for tier configuration in content filters policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterstierconfig.html#cfn-bedrock-guardrail-contentfilterstierconfig-tiername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentfilterstierconfig.html#cfn-bedrock-guardrail-contentfilterstierconfig-tiername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTierName();

        /**
         * @return a {@link Builder} of {@link ContentFiltersTierConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContentFiltersTierConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContentFiltersTierConfigProperty> {
            java.lang.String tierName;

            /**
             * Sets the value of {@link ContentFiltersTierConfigProperty#getTierName}
             * @param tierName Tier name for tier configuration in content filters policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tierName(java.lang.String tierName) {
                this.tierName = tierName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContentFiltersTierConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContentFiltersTierConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContentFiltersTierConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContentFiltersTierConfigProperty {
            private final java.lang.String tierName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tierName = software.amazon.jsii.Kernel.get(this, "tierName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tierName = java.util.Objects.requireNonNull(builder.tierName, "tierName is required");
            }

            @Override
            public final java.lang.String getTierName() {
                return this.tierName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("tierName", om.valueToTree(this.getTierName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnGuardrail.ContentFiltersTierConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContentFiltersTierConfigProperty.Jsii$Proxy that = (ContentFiltersTierConfigProperty.Jsii$Proxy) o;

                return this.tierName.equals(that.tierName);
            }

            @Override
            public final int hashCode() {
                int result = this.tierName.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains details about how to handle harmful content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ContentPolicyConfigProperty contentPolicyConfigProperty = ContentPolicyConfigProperty.builder()
     *         .filtersConfig(List.of(ContentFilterConfigProperty.builder()
     *                 .inputStrength("inputStrength")
     *                 .outputStrength("outputStrength")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .inputAction("inputAction")
     *                 .inputEnabled(false)
     *                 .inputModalities(List.of("inputModalities"))
     *                 .outputAction("outputAction")
     *                 .outputEnabled(false)
     *                 .outputModalities(List.of("outputModalities"))
     *                 .build()))
     *         // the properties below are optional
     *         .contentFiltersTierConfig(ContentFiltersTierConfigProperty.builder()
     *                 .tierName("tierName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentpolicyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentpolicyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrail.ContentPolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ContentPolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContentPolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains the type of the content filter and how strongly it should apply to prompts and model responses.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentpolicyconfig.html#cfn-bedrock-guardrail-contentpolicyconfig-filtersconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentpolicyconfig.html#cfn-bedrock-guardrail-contentpolicyconfig-filtersconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFiltersConfig();

        /**
         * Guardrail tier config for content policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentpolicyconfig.html#cfn-bedrock-guardrail-contentpolicyconfig-contentfilterstierconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contentpolicyconfig.html#cfn-bedrock-guardrail-contentpolicyconfig-contentfilterstierconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContentFiltersTierConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContentPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContentPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContentPolicyConfigProperty> {
            java.lang.Object filtersConfig;
            java.lang.Object contentFiltersTierConfig;

            /**
             * Sets the value of {@link ContentPolicyConfigProperty#getFiltersConfig}
             * @param filtersConfig Contains the type of the content filter and how strongly it should apply to prompts and model responses. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filtersConfig(software.amazon.awscdk.IResolvable filtersConfig) {
                this.filtersConfig = filtersConfig;
                return this;
            }

            /**
             * Sets the value of {@link ContentPolicyConfigProperty#getFiltersConfig}
             * @param filtersConfig Contains the type of the content filter and how strongly it should apply to prompts and model responses. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filtersConfig(java.util.List<? extends java.lang.Object> filtersConfig) {
                this.filtersConfig = filtersConfig;
                return this;
            }

            /**
             * Sets the value of {@link ContentPolicyConfigProperty#getContentFiltersTierConfig}
             * @param contentFiltersTierConfig Guardrail tier config for content policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentFiltersTierConfig(software.amazon.awscdk.IResolvable contentFiltersTierConfig) {
                this.contentFiltersTierConfig = contentFiltersTierConfig;
                return this;
            }

            /**
             * Sets the value of {@link ContentPolicyConfigProperty#getContentFiltersTierConfig}
             * @param contentFiltersTierConfig Guardrail tier config for content policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentFiltersTierConfig(software.amazon.awscdk.services.bedrock.CfnGuardrail.ContentFiltersTierConfigProperty contentFiltersTierConfig) {
                this.contentFiltersTierConfig = contentFiltersTierConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContentPolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContentPolicyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContentPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContentPolicyConfigProperty {
            private final java.lang.Object filtersConfig;
            private final java.lang.Object contentFiltersTierConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filtersConfig = software.amazon.jsii.Kernel.get(this, "filtersConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.contentFiltersTierConfig = software.amazon.jsii.Kernel.get(this, "contentFiltersTierConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filtersConfig = java.util.Objects.requireNonNull(builder.filtersConfig, "filtersConfig is required");
                this.contentFiltersTierConfig = builder.contentFiltersTierConfig;
            }

            @Override
            public final java.lang.Object getFiltersConfig() {
                return this.filtersConfig;
            }

            @Override
            public final java.lang.Object getContentFiltersTierConfig() {
                return this.contentFiltersTierConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("filtersConfig", om.valueToTree(this.getFiltersConfig()));
                if (this.getContentFiltersTierConfig() != null) {
                    data.set("contentFiltersTierConfig", om.valueToTree(this.getContentFiltersTierConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnGuardrail.ContentPolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContentPolicyConfigProperty.Jsii$Proxy that = (ContentPolicyConfigProperty.Jsii$Proxy) o;

                if (!filtersConfig.equals(that.filtersConfig)) return false;
                return this.contentFiltersTierConfig != null ? this.contentFiltersTierConfig.equals(that.contentFiltersTierConfig) : that.contentFiltersTierConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.filtersConfig.hashCode();
                result = 31 * result + (this.contentFiltersTierConfig != null ? this.contentFiltersTierConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The filter configuration details for the guardrails contextual grounding filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ContextualGroundingFilterConfigProperty contextualGroundingFilterConfigProperty = ContextualGroundingFilterConfigProperty.builder()
     *         .threshold(123)
     *         .type("type")
     *         // the properties below are optional
     *         .action("action")
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contextualgroundingfilterconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contextualgroundingfilterconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrail.ContextualGroundingFilterConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ContextualGroundingFilterConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContextualGroundingFilterConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The threshold details for the guardrails contextual grounding filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contextualgroundingfilterconfig.html#cfn-bedrock-guardrail-contextualgroundingfilterconfig-threshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contextualgroundingfilterconfig.html#cfn-bedrock-guardrail-contextualgroundingfilterconfig-threshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getThreshold();

        /**
         * The filter details for the guardrails contextual grounding filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contextualgroundingfilterconfig.html#cfn-bedrock-guardrail-contextualgroundingfilterconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contextualgroundingfilterconfig.html#cfn-bedrock-guardrail-contextualgroundingfilterconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contextualgroundingfilterconfig.html#cfn-bedrock-guardrail-contextualgroundingfilterconfig-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contextualgroundingfilterconfig.html#cfn-bedrock-guardrail-contextualgroundingfilterconfig-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contextualgroundingfilterconfig.html#cfn-bedrock-guardrail-contextualgroundingfilterconfig-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contextualgroundingfilterconfig.html#cfn-bedrock-guardrail-contextualgroundingfilterconfig-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContextualGroundingFilterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContextualGroundingFilterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContextualGroundingFilterConfigProperty> {
            java.lang.Number threshold;
            java.lang.String type;
            java.lang.String action;
            java.lang.Object enabled;

            /**
             * Sets the value of {@link ContextualGroundingFilterConfigProperty#getThreshold}
             * @param threshold The threshold details for the guardrails contextual grounding filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threshold(java.lang.Number threshold) {
                this.threshold = threshold;
                return this;
            }

            /**
             * Sets the value of {@link ContextualGroundingFilterConfigProperty#getType}
             * @param type The filter details for the guardrails contextual grounding filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ContextualGroundingFilterConfigProperty#getAction}
             * @param action the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link ContextualGroundingFilterConfigProperty#getEnabled}
             * @param enabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ContextualGroundingFilterConfigProperty#getEnabled}
             * @param enabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContextualGroundingFilterConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContextualGroundingFilterConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContextualGroundingFilterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContextualGroundingFilterConfigProperty {
            private final java.lang.Number threshold;
            private final java.lang.String type;
            private final java.lang.String action;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.threshold = software.amazon.jsii.Kernel.get(this, "threshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.threshold = java.util.Objects.requireNonNull(builder.threshold, "threshold is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.action = builder.action;
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Number getThreshold() {
                return this.threshold;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("threshold", om.valueToTree(this.getThreshold()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getAction() != null) {
                    data.set("action", om.valueToTree(this.getAction()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnGuardrail.ContextualGroundingFilterConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContextualGroundingFilterConfigProperty.Jsii$Proxy that = (ContextualGroundingFilterConfigProperty.Jsii$Proxy) o;

                if (!threshold.equals(that.threshold)) return false;
                if (!type.equals(that.type)) return false;
                if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.threshold.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The policy configuration details for the guardrails contextual grounding policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ContextualGroundingPolicyConfigProperty contextualGroundingPolicyConfigProperty = ContextualGroundingPolicyConfigProperty.builder()
     *         .filtersConfig(List.of(ContextualGroundingFilterConfigProperty.builder()
     *                 .threshold(123)
     *                 .type("type")
     *                 // the properties below are optional
     *                 .action("action")
     *                 .enabled(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contextualgroundingpolicyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contextualgroundingpolicyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrail.ContextualGroundingPolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ContextualGroundingPolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContextualGroundingPolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of contextual grounding filter configs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contextualgroundingpolicyconfig.html#cfn-bedrock-guardrail-contextualgroundingpolicyconfig-filtersconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-contextualgroundingpolicyconfig.html#cfn-bedrock-guardrail-contextualgroundingpolicyconfig-filtersconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFiltersConfig();

        /**
         * @return a {@link Builder} of {@link ContextualGroundingPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContextualGroundingPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContextualGroundingPolicyConfigProperty> {
            java.lang.Object filtersConfig;

            /**
             * Sets the value of {@link ContextualGroundingPolicyConfigProperty#getFiltersConfig}
             * @param filtersConfig List of contextual grounding filter configs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filtersConfig(software.amazon.awscdk.IResolvable filtersConfig) {
                this.filtersConfig = filtersConfig;
                return this;
            }

            /**
             * Sets the value of {@link ContextualGroundingPolicyConfigProperty#getFiltersConfig}
             * @param filtersConfig List of contextual grounding filter configs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filtersConfig(java.util.List<? extends java.lang.Object> filtersConfig) {
                this.filtersConfig = filtersConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContextualGroundingPolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContextualGroundingPolicyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContextualGroundingPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContextualGroundingPolicyConfigProperty {
            private final java.lang.Object filtersConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filtersConfig = software.amazon.jsii.Kernel.get(this, "filtersConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filtersConfig = java.util.Objects.requireNonNull(builder.filtersConfig, "filtersConfig is required");
            }

            @Override
            public final java.lang.Object getFiltersConfig() {
                return this.filtersConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("filtersConfig", om.valueToTree(this.getFiltersConfig()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnGuardrail.ContextualGroundingPolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContextualGroundingPolicyConfigProperty.Jsii$Proxy that = (ContextualGroundingPolicyConfigProperty.Jsii$Proxy) o;

                return this.filtersConfig.equals(that.filtersConfig);
            }

            @Override
            public final int hashCode() {
                int result = this.filtersConfig.hashCode();
                return result;
            }
        }
    }
    /**
     * The system-defined guardrail profile that you're using with your guardrail.
     * <p>
     * Guardrail profiles define the destination AWS Regions where guardrail inference requests can be automatically routed. Using guardrail profiles helps maintain guardrail performance and reliability when demand increases.
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html">Amazon Bedrock User Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * GuardrailCrossRegionConfigProperty guardrailCrossRegionConfigProperty = GuardrailCrossRegionConfigProperty.builder()
     *         .guardrailProfileArn("guardrailProfileArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-guardrailcrossregionconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-guardrailcrossregionconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrail.GuardrailCrossRegionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(GuardrailCrossRegionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GuardrailCrossRegionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the guardrail profile.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-guardrailcrossregionconfig.html#cfn-bedrock-guardrail-guardrailcrossregionconfig-guardrailprofilearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-guardrailcrossregionconfig.html#cfn-bedrock-guardrail-guardrailcrossregionconfig-guardrailprofilearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGuardrailProfileArn();

        /**
         * @return a {@link Builder} of {@link GuardrailCrossRegionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GuardrailCrossRegionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GuardrailCrossRegionConfigProperty> {
            java.lang.String guardrailProfileArn;

            /**
             * Sets the value of {@link GuardrailCrossRegionConfigProperty#getGuardrailProfileArn}
             * @param guardrailProfileArn The Amazon Resource Name (ARN) of the guardrail profile. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardrailProfileArn(java.lang.String guardrailProfileArn) {
                this.guardrailProfileArn = guardrailProfileArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GuardrailCrossRegionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GuardrailCrossRegionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GuardrailCrossRegionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GuardrailCrossRegionConfigProperty {
            private final java.lang.String guardrailProfileArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.guardrailProfileArn = software.amazon.jsii.Kernel.get(this, "guardrailProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.guardrailProfileArn = java.util.Objects.requireNonNull(builder.guardrailProfileArn, "guardrailProfileArn is required");
            }

            @Override
            public final java.lang.String getGuardrailProfileArn() {
                return this.guardrailProfileArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("guardrailProfileArn", om.valueToTree(this.getGuardrailProfileArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnGuardrail.GuardrailCrossRegionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GuardrailCrossRegionConfigProperty.Jsii$Proxy that = (GuardrailCrossRegionConfigProperty.Jsii$Proxy) o;

                return this.guardrailProfileArn.equals(that.guardrailProfileArn);
            }

            @Override
            public final int hashCode() {
                int result = this.guardrailProfileArn.hashCode();
                return result;
            }
        }
    }
    /**
     * The managed word list to configure for the guardrail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ManagedWordsConfigProperty managedWordsConfigProperty = ManagedWordsConfigProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .inputAction("inputAction")
     *         .inputEnabled(false)
     *         .outputAction("outputAction")
     *         .outputEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-managedwordsconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-managedwordsconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrail.ManagedWordsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedWordsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedWordsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The managed word type to configure for the guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-managedwordsconfig.html#cfn-bedrock-guardrail-managedwordsconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-managedwordsconfig.html#cfn-bedrock-guardrail-managedwordsconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-managedwordsconfig.html#cfn-bedrock-guardrail-managedwordsconfig-inputaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-managedwordsconfig.html#cfn-bedrock-guardrail-managedwordsconfig-inputaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputAction() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-managedwordsconfig.html#cfn-bedrock-guardrail-managedwordsconfig-inputenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-managedwordsconfig.html#cfn-bedrock-guardrail-managedwordsconfig-inputenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputEnabled() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-managedwordsconfig.html#cfn-bedrock-guardrail-managedwordsconfig-outputaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-managedwordsconfig.html#cfn-bedrock-guardrail-managedwordsconfig-outputaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputAction() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-managedwordsconfig.html#cfn-bedrock-guardrail-managedwordsconfig-outputenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-managedwordsconfig.html#cfn-bedrock-guardrail-managedwordsconfig-outputenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedWordsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedWordsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedWordsConfigProperty> {
            java.lang.String type;
            java.lang.String inputAction;
            java.lang.Object inputEnabled;
            java.lang.String outputAction;
            java.lang.Object outputEnabled;

            /**
             * Sets the value of {@link ManagedWordsConfigProperty#getType}
             * @param type The managed word type to configure for the guardrail. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ManagedWordsConfigProperty#getInputAction}
             * @param inputAction the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputAction(java.lang.String inputAction) {
                this.inputAction = inputAction;
                return this;
            }

            /**
             * Sets the value of {@link ManagedWordsConfigProperty#getInputEnabled}
             * @param inputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputEnabled(java.lang.Boolean inputEnabled) {
                this.inputEnabled = inputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ManagedWordsConfigProperty#getInputEnabled}
             * @param inputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputEnabled(software.amazon.awscdk.IResolvable inputEnabled) {
                this.inputEnabled = inputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ManagedWordsConfigProperty#getOutputAction}
             * @param outputAction the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputAction(java.lang.String outputAction) {
                this.outputAction = outputAction;
                return this;
            }

            /**
             * Sets the value of {@link ManagedWordsConfigProperty#getOutputEnabled}
             * @param outputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputEnabled(java.lang.Boolean outputEnabled) {
                this.outputEnabled = outputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ManagedWordsConfigProperty#getOutputEnabled}
             * @param outputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputEnabled(software.amazon.awscdk.IResolvable outputEnabled) {
                this.outputEnabled = outputEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedWordsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedWordsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedWordsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedWordsConfigProperty {
            private final java.lang.String type;
            private final java.lang.String inputAction;
            private final java.lang.Object inputEnabled;
            private final java.lang.String outputAction;
            private final java.lang.Object outputEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputAction = software.amazon.jsii.Kernel.get(this, "inputAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputEnabled = software.amazon.jsii.Kernel.get(this, "inputEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputAction = software.amazon.jsii.Kernel.get(this, "outputAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputEnabled = software.amazon.jsii.Kernel.get(this, "outputEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.inputAction = builder.inputAction;
                this.inputEnabled = builder.inputEnabled;
                this.outputAction = builder.outputAction;
                this.outputEnabled = builder.outputEnabled;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getInputAction() {
                return this.inputAction;
            }

            @Override
            public final java.lang.Object getInputEnabled() {
                return this.inputEnabled;
            }

            @Override
            public final java.lang.String getOutputAction() {
                return this.outputAction;
            }

            @Override
            public final java.lang.Object getOutputEnabled() {
                return this.outputEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getInputAction() != null) {
                    data.set("inputAction", om.valueToTree(this.getInputAction()));
                }
                if (this.getInputEnabled() != null) {
                    data.set("inputEnabled", om.valueToTree(this.getInputEnabled()));
                }
                if (this.getOutputAction() != null) {
                    data.set("outputAction", om.valueToTree(this.getOutputAction()));
                }
                if (this.getOutputEnabled() != null) {
                    data.set("outputEnabled", om.valueToTree(this.getOutputEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnGuardrail.ManagedWordsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedWordsConfigProperty.Jsii$Proxy that = (ManagedWordsConfigProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.inputAction != null ? !this.inputAction.equals(that.inputAction) : that.inputAction != null) return false;
                if (this.inputEnabled != null ? !this.inputEnabled.equals(that.inputEnabled) : that.inputEnabled != null) return false;
                if (this.outputAction != null ? !this.outputAction.equals(that.outputAction) : that.outputAction != null) return false;
                return this.outputEnabled != null ? this.outputEnabled.equals(that.outputEnabled) : that.outputEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.inputAction != null ? this.inputAction.hashCode() : 0);
                result = 31 * result + (this.inputEnabled != null ? this.inputEnabled.hashCode() : 0);
                result = 31 * result + (this.outputAction != null ? this.outputAction.hashCode() : 0);
                result = 31 * result + (this.outputEnabled != null ? this.outputEnabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The PII entity to configure for the guardrail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PiiEntityConfigProperty piiEntityConfigProperty = PiiEntityConfigProperty.builder()
     *         .action("action")
     *         .type("type")
     *         // the properties below are optional
     *         .inputAction("inputAction")
     *         .inputEnabled(false)
     *         .outputAction("outputAction")
     *         .outputEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-piientityconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-piientityconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrail.PiiEntityConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(PiiEntityConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PiiEntityConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configure guardrail action when the PII entity is detected.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-piientityconfig.html#cfn-bedrock-guardrail-piientityconfig-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-piientityconfig.html#cfn-bedrock-guardrail-piientityconfig-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * Configure guardrail type when the PII entity is detected.
         * <p>
         * The following PIIs are used to block or mask sensitive information:
         * <p>
         * <ul>
         * <li><em>General</em></li>
         * <li><em>ADDRESS</em></li>
         * </ul>
         * <p>
         * A physical address, such as "100 Main Street, Anytown, USA" or "Suite #12, Building 123". An address can include information such as the street, building, location, city, state, country, county, zip code, precinct, and neighborhood.
         * <p>
         * <ul>
         * <li><em>AGE</em></li>
         * </ul>
         * <p>
         * An individual's age, including the quantity and unit of time. For example, in the phrase "I am 40 years old," Guardrails recognizes "40 years" as an age.
         * <p>
         * <ul>
         * <li><em>NAME</em></li>
         * </ul>
         * <p>
         * An individual's name. This entity type does not include titles, such as Dr., Mr., Mrs., or Miss. guardrails doesn't apply this entity type to names that are part of organizations or addresses. For example, guardrails recognizes the "John Doe Organization" as an organization, and it recognizes "Jane Doe Street" as an address.
         * <p>
         * <ul>
         * <li><em>EMAIL</em></li>
         * </ul>
         * <p>
         * An email address, such as <em>marymajor&#64;email.com</em> .
         * <p>
         * <ul>
         * <li><em>PHONE</em></li>
         * </ul>
         * <p>
         * A phone number. This entity type also includes fax and pager numbers.
         * <p>
         * <ul>
         * <li><em>USERNAME</em></li>
         * </ul>
         * <p>
         * A user name that identifies an account, such as a login name, screen name, nick name, or handle.
         * <p>
         * <ul>
         * <li><em>PASSWORD</em></li>
         * </ul>
         * <p>
         * An alphanumeric string that is used as a password, such as "* <em>very20special#pass</em>* ".
         * <p>
         * <ul>
         * <li><em>DRIVER_ID</em></li>
         * </ul>
         * <p>
         * The number assigned to a driver's license, which is an official document permitting an individual to operate one or more motorized vehicles on a public road. A driver's license number consists of alphanumeric characters.
         * <p>
         * <ul>
         * <li><em>LICENSE_PLATE</em></li>
         * </ul>
         * <p>
         * A license plate for a vehicle is issued by the state or country where the vehicle is registered. The format for passenger vehicles is typically five to eight digits, consisting of upper-case letters and numbers. The format varies depending on the location of the issuing state or country.
         * <p>
         * <ul>
         * <li><em>VEHICLE_IDENTIFICATION_NUMBER</em></li>
         * </ul>
         * <p>
         * A Vehicle Identification Number (VIN) uniquely identifies a vehicle. VIN content and format are defined in the <em>ISO 3779</em> specification. Each country has specific codes and formats for VINs.
         * <p>
         * <ul>
         * <li><em>Finance</em></li>
         * <li><em>CREDIT_DEBIT_CARD_CVV</em></li>
         * </ul>
         * <p>
         * A three-digit card verification code (CVV) that is present on VISA, MasterCard, and Discover credit and debit cards. For American Express credit or debit cards, the CVV is a four-digit numeric code.
         * <p>
         * <ul>
         * <li><em>CREDIT_DEBIT_CARD_EXPIRY</em></li>
         * </ul>
         * <p>
         * The expiration date for a credit or debit card. This number is usually four digits long and is often formatted as <em>month/year</em> or <em>MM/YY</em> . Guardrails recognizes expiration dates such as <em>01/21</em> , <em>01/2021</em> , and <em>Jan 2021</em> .
         * <p>
         * <ul>
         * <li><em>CREDIT_DEBIT_CARD_NUMBER</em></li>
         * </ul>
         * <p>
         * The number for a credit or debit card. These numbers can vary from 13 to 16 digits in length. However, Amazon Comprehend also recognizes credit or debit card numbers when only the last four digits are present.
         * <p>
         * <ul>
         * <li><em>PIN</em></li>
         * </ul>
         * <p>
         * A four-digit personal identification number (PIN) with which you can access your bank account.
         * <p>
         * <ul>
         * <li><em>INTERNATIONAL_BANK_ACCOUNT_NUMBER</em></li>
         * </ul>
         * <p>
         * An International Bank Account Number has specific formats in each country. For more information, see <a href="https://docs.aws.amazon.com/https://www.iban.com/structure">www.iban.com/structure</a> .
         * <p>
         * <ul>
         * <li><em>SWIFT_CODE</em></li>
         * </ul>
         * <p>
         * A SWIFT code is a standard format of Bank Identifier Code (BIC) used to specify a particular bank or branch. Banks use these codes for money transfers such as international wire transfers.
         * <p>
         * SWIFT codes consist of eight or 11 characters. The 11-digit codes refer to specific branches, while eight-digit codes (or 11-digit codes ending in 'XXX') refer to the head or primary office.
         * <p>
         * <ul>
         * <li><em>IT</em></li>
         * <li><em>IP_ADDRESS</em></li>
         * </ul>
         * <p>
         * An IPv4 address, such as <em>198.51.100.0</em> .
         * <p>
         * <ul>
         * <li><em>MAC_ADDRESS</em></li>
         * </ul>
         * <p>
         * A <em>media access control</em> (MAC) address is a unique identifier assigned to a network interface controller (NIC).
         * <p>
         * <ul>
         * <li><em>URL</em></li>
         * </ul>
         * <p>
         * A web address, such as <em>www.example.com</em> .
         * <p>
         * <ul>
         * <li><em>AWS_ACCESS_KEY</em></li>
         * </ul>
         * <p>
         * A unique identifier that's associated with a secret access key; you use the access key ID and secret access key to sign programmatic AWS requests cryptographically.
         * <p>
         * <ul>
         * <li><em>AWS_SECRET_KEY</em></li>
         * </ul>
         * <p>
         * A unique identifier that's associated with an access key. You use the access key ID and secret access key to sign programmatic AWS requests cryptographically.
         * <p>
         * <ul>
         * <li><em>USA specific</em></li>
         * <li><em>US_BANK_ACCOUNT_NUMBER</em></li>
         * </ul>
         * <p>
         * A US bank account number, which is typically 10 to 12 digits long.
         * <p>
         * <ul>
         * <li><em>US_BANK_ROUTING_NUMBER</em></li>
         * </ul>
         * <p>
         * A US bank account routing number. These are typically nine digits long,
         * <p>
         * <ul>
         * <li><em>US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER</em></li>
         * </ul>
         * <p>
         * A US Individual Taxpayer Identification Number (ITIN) is a nine-digit number that starts with a "9" and contain a "7" or "8" as the fourth digit. An ITIN can be formatted with a space or a dash after the third and forth digits.
         * <p>
         * <ul>
         * <li><em>US_PASSPORT_NUMBER</em></li>
         * </ul>
         * <p>
         * A US passport number. Passport numbers range from six to nine alphanumeric characters.
         * <p>
         * <ul>
         * <li><em>US_SOCIAL_SECURITY_NUMBER</em></li>
         * </ul>
         * <p>
         * A US Social Security Number (SSN) is a nine-digit number that is issued to US citizens, permanent residents, and temporary working residents.
         * <p>
         * <ul>
         * <li><em>Canada specific</em></li>
         * <li><em>CA_HEALTH_NUMBER</em></li>
         * </ul>
         * <p>
         * A Canadian Health Service Number is a 10-digit unique identifier, required for individuals to access healthcare benefits.
         * <p>
         * <ul>
         * <li><em>CA_SOCIAL_INSURANCE_NUMBER</em></li>
         * </ul>
         * <p>
         * A Canadian Social Insurance Number (SIN) is a nine-digit unique identifier, required for individuals to access government programs and benefits.
         * <p>
         * The SIN is formatted as three groups of three digits, such as <em>123-456-789</em> . A SIN can be validated through a simple check-digit process called the <a href="https://docs.aws.amazon.com/https://www.wikipedia.org/wiki/Luhn_algorithm">Luhn algorithm</a> .
         * <p>
         * <ul>
         * <li><em>UK Specific</em></li>
         * <li><em>UK_NATIONAL_HEALTH_SERVICE_NUMBER</em></li>
         * </ul>
         * <p>
         * A UK National Health Service Number is a 10-17 digit number, such as <em>485 777 3456</em> . The current system formats the 10-digit number with spaces after the third and sixth digits. The final digit is an error-detecting checksum.
         * <p>
         * <ul>
         * <li><em>UK_NATIONAL_INSURANCE_NUMBER</em></li>
         * </ul>
         * <p>
         * A UK National Insurance Number (NINO) provides individuals with access to National Insurance (social security) benefits. It is also used for some purposes in the UK tax system.
         * <p>
         * The number is nine digits long and starts with two letters, followed by six numbers and one letter. A NINO can be formatted with a space or a dash after the two letters and after the second, forth, and sixth digits.
         * <p>
         * <ul>
         * <li><em>UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER</em></li>
         * </ul>
         * <p>
         * A UK Unique Taxpayer Reference (UTR) is a 10-digit number that identifies a taxpayer or a business.
         * <p>
         * <ul>
         * <li><em>Custom</em></li>
         * <li><em>Regex filter</em> - You can use a regular expressions to define patterns for a guardrail to recognize and act upon such as serial number, booking ID etc..</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-piientityconfig.html#cfn-bedrock-guardrail-piientityconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-piientityconfig.html#cfn-bedrock-guardrail-piientityconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Options for sensitive information action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-piientityconfig.html#cfn-bedrock-guardrail-piientityconfig-inputaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-piientityconfig.html#cfn-bedrock-guardrail-piientityconfig-inputaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputAction() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-piientityconfig.html#cfn-bedrock-guardrail-piientityconfig-inputenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-piientityconfig.html#cfn-bedrock-guardrail-piientityconfig-inputenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputEnabled() {
            return null;
        }

        /**
         * Options for sensitive information action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-piientityconfig.html#cfn-bedrock-guardrail-piientityconfig-outputaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-piientityconfig.html#cfn-bedrock-guardrail-piientityconfig-outputaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputAction() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-piientityconfig.html#cfn-bedrock-guardrail-piientityconfig-outputenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-piientityconfig.html#cfn-bedrock-guardrail-piientityconfig-outputenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PiiEntityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PiiEntityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PiiEntityConfigProperty> {
            java.lang.String action;
            java.lang.String type;
            java.lang.String inputAction;
            java.lang.Object inputEnabled;
            java.lang.String outputAction;
            java.lang.Object outputEnabled;

            /**
             * Sets the value of {@link PiiEntityConfigProperty#getAction}
             * @param action Configure guardrail action when the PII entity is detected. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link PiiEntityConfigProperty#getType}
             * @param type Configure guardrail type when the PII entity is detected. This parameter is required.
             *             The following PIIs are used to block or mask sensitive information:
             *             <p>
             *             <ul>
             *             <li><em>General</em></li>
             *             <li><em>ADDRESS</em></li>
             *             </ul>
             *             <p>
             *             A physical address, such as "100 Main Street, Anytown, USA" or "Suite #12, Building 123". An address can include information such as the street, building, location, city, state, country, county, zip code, precinct, and neighborhood.
             *             <p>
             *             <ul>
             *             <li><em>AGE</em></li>
             *             </ul>
             *             <p>
             *             An individual's age, including the quantity and unit of time. For example, in the phrase "I am 40 years old," Guardrails recognizes "40 years" as an age.
             *             <p>
             *             <ul>
             *             <li><em>NAME</em></li>
             *             </ul>
             *             <p>
             *             An individual's name. This entity type does not include titles, such as Dr., Mr., Mrs., or Miss. guardrails doesn't apply this entity type to names that are part of organizations or addresses. For example, guardrails recognizes the "John Doe Organization" as an organization, and it recognizes "Jane Doe Street" as an address.
             *             <p>
             *             <ul>
             *             <li><em>EMAIL</em></li>
             *             </ul>
             *             <p>
             *             An email address, such as <em>marymajor&#64;email.com</em> .
             *             <p>
             *             <ul>
             *             <li><em>PHONE</em></li>
             *             </ul>
             *             <p>
             *             A phone number. This entity type also includes fax and pager numbers.
             *             <p>
             *             <ul>
             *             <li><em>USERNAME</em></li>
             *             </ul>
             *             <p>
             *             A user name that identifies an account, such as a login name, screen name, nick name, or handle.
             *             <p>
             *             <ul>
             *             <li><em>PASSWORD</em></li>
             *             </ul>
             *             <p>
             *             An alphanumeric string that is used as a password, such as "* <em>very20special#pass</em>* ".
             *             <p>
             *             <ul>
             *             <li><em>DRIVER_ID</em></li>
             *             </ul>
             *             <p>
             *             The number assigned to a driver's license, which is an official document permitting an individual to operate one or more motorized vehicles on a public road. A driver's license number consists of alphanumeric characters.
             *             <p>
             *             <ul>
             *             <li><em>LICENSE_PLATE</em></li>
             *             </ul>
             *             <p>
             *             A license plate for a vehicle is issued by the state or country where the vehicle is registered. The format for passenger vehicles is typically five to eight digits, consisting of upper-case letters and numbers. The format varies depending on the location of the issuing state or country.
             *             <p>
             *             <ul>
             *             <li><em>VEHICLE_IDENTIFICATION_NUMBER</em></li>
             *             </ul>
             *             <p>
             *             A Vehicle Identification Number (VIN) uniquely identifies a vehicle. VIN content and format are defined in the <em>ISO 3779</em> specification. Each country has specific codes and formats for VINs.
             *             <p>
             *             <ul>
             *             <li><em>Finance</em></li>
             *             <li><em>CREDIT_DEBIT_CARD_CVV</em></li>
             *             </ul>
             *             <p>
             *             A three-digit card verification code (CVV) that is present on VISA, MasterCard, and Discover credit and debit cards. For American Express credit or debit cards, the CVV is a four-digit numeric code.
             *             <p>
             *             <ul>
             *             <li><em>CREDIT_DEBIT_CARD_EXPIRY</em></li>
             *             </ul>
             *             <p>
             *             The expiration date for a credit or debit card. This number is usually four digits long and is often formatted as <em>month/year</em> or <em>MM/YY</em> . Guardrails recognizes expiration dates such as <em>01/21</em> , <em>01/2021</em> , and <em>Jan 2021</em> .
             *             <p>
             *             <ul>
             *             <li><em>CREDIT_DEBIT_CARD_NUMBER</em></li>
             *             </ul>
             *             <p>
             *             The number for a credit or debit card. These numbers can vary from 13 to 16 digits in length. However, Amazon Comprehend also recognizes credit or debit card numbers when only the last four digits are present.
             *             <p>
             *             <ul>
             *             <li><em>PIN</em></li>
             *             </ul>
             *             <p>
             *             A four-digit personal identification number (PIN) with which you can access your bank account.
             *             <p>
             *             <ul>
             *             <li><em>INTERNATIONAL_BANK_ACCOUNT_NUMBER</em></li>
             *             </ul>
             *             <p>
             *             An International Bank Account Number has specific formats in each country. For more information, see <a href="https://docs.aws.amazon.com/https://www.iban.com/structure">www.iban.com/structure</a> .
             *             <p>
             *             <ul>
             *             <li><em>SWIFT_CODE</em></li>
             *             </ul>
             *             <p>
             *             A SWIFT code is a standard format of Bank Identifier Code (BIC) used to specify a particular bank or branch. Banks use these codes for money transfers such as international wire transfers.
             *             <p>
             *             SWIFT codes consist of eight or 11 characters. The 11-digit codes refer to specific branches, while eight-digit codes (or 11-digit codes ending in 'XXX') refer to the head or primary office.
             *             <p>
             *             <ul>
             *             <li><em>IT</em></li>
             *             <li><em>IP_ADDRESS</em></li>
             *             </ul>
             *             <p>
             *             An IPv4 address, such as <em>198.51.100.0</em> .
             *             <p>
             *             <ul>
             *             <li><em>MAC_ADDRESS</em></li>
             *             </ul>
             *             <p>
             *             A <em>media access control</em> (MAC) address is a unique identifier assigned to a network interface controller (NIC).
             *             <p>
             *             <ul>
             *             <li><em>URL</em></li>
             *             </ul>
             *             <p>
             *             A web address, such as <em>www.example.com</em> .
             *             <p>
             *             <ul>
             *             <li><em>AWS_ACCESS_KEY</em></li>
             *             </ul>
             *             <p>
             *             A unique identifier that's associated with a secret access key; you use the access key ID and secret access key to sign programmatic AWS requests cryptographically.
             *             <p>
             *             <ul>
             *             <li><em>AWS_SECRET_KEY</em></li>
             *             </ul>
             *             <p>
             *             A unique identifier that's associated with an access key. You use the access key ID and secret access key to sign programmatic AWS requests cryptographically.
             *             <p>
             *             <ul>
             *             <li><em>USA specific</em></li>
             *             <li><em>US_BANK_ACCOUNT_NUMBER</em></li>
             *             </ul>
             *             <p>
             *             A US bank account number, which is typically 10 to 12 digits long.
             *             <p>
             *             <ul>
             *             <li><em>US_BANK_ROUTING_NUMBER</em></li>
             *             </ul>
             *             <p>
             *             A US bank account routing number. These are typically nine digits long,
             *             <p>
             *             <ul>
             *             <li><em>US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER</em></li>
             *             </ul>
             *             <p>
             *             A US Individual Taxpayer Identification Number (ITIN) is a nine-digit number that starts with a "9" and contain a "7" or "8" as the fourth digit. An ITIN can be formatted with a space or a dash after the third and forth digits.
             *             <p>
             *             <ul>
             *             <li><em>US_PASSPORT_NUMBER</em></li>
             *             </ul>
             *             <p>
             *             A US passport number. Passport numbers range from six to nine alphanumeric characters.
             *             <p>
             *             <ul>
             *             <li><em>US_SOCIAL_SECURITY_NUMBER</em></li>
             *             </ul>
             *             <p>
             *             A US Social Security Number (SSN) is a nine-digit number that is issued to US citizens, permanent residents, and temporary working residents.
             *             <p>
             *             <ul>
             *             <li><em>Canada specific</em></li>
             *             <li><em>CA_HEALTH_NUMBER</em></li>
             *             </ul>
             *             <p>
             *             A Canadian Health Service Number is a 10-digit unique identifier, required for individuals to access healthcare benefits.
             *             <p>
             *             <ul>
             *             <li><em>CA_SOCIAL_INSURANCE_NUMBER</em></li>
             *             </ul>
             *             <p>
             *             A Canadian Social Insurance Number (SIN) is a nine-digit unique identifier, required for individuals to access government programs and benefits.
             *             <p>
             *             The SIN is formatted as three groups of three digits, such as <em>123-456-789</em> . A SIN can be validated through a simple check-digit process called the <a href="https://docs.aws.amazon.com/https://www.wikipedia.org/wiki/Luhn_algorithm">Luhn algorithm</a> .
             *             <p>
             *             <ul>
             *             <li><em>UK Specific</em></li>
             *             <li><em>UK_NATIONAL_HEALTH_SERVICE_NUMBER</em></li>
             *             </ul>
             *             <p>
             *             A UK National Health Service Number is a 10-17 digit number, such as <em>485 777 3456</em> . The current system formats the 10-digit number with spaces after the third and sixth digits. The final digit is an error-detecting checksum.
             *             <p>
             *             <ul>
             *             <li><em>UK_NATIONAL_INSURANCE_NUMBER</em></li>
             *             </ul>
             *             <p>
             *             A UK National Insurance Number (NINO) provides individuals with access to National Insurance (social security) benefits. It is also used for some purposes in the UK tax system.
             *             <p>
             *             The number is nine digits long and starts with two letters, followed by six numbers and one letter. A NINO can be formatted with a space or a dash after the two letters and after the second, forth, and sixth digits.
             *             <p>
             *             <ul>
             *             <li><em>UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER</em></li>
             *             </ul>
             *             <p>
             *             A UK Unique Taxpayer Reference (UTR) is a 10-digit number that identifies a taxpayer or a business.
             *             <p>
             *             <ul>
             *             <li><em>Custom</em></li>
             *             <li><em>Regex filter</em> - You can use a regular expressions to define patterns for a guardrail to recognize and act upon such as serial number, booking ID etc..</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link PiiEntityConfigProperty#getInputAction}
             * @param inputAction Options for sensitive information action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputAction(java.lang.String inputAction) {
                this.inputAction = inputAction;
                return this;
            }

            /**
             * Sets the value of {@link PiiEntityConfigProperty#getInputEnabled}
             * @param inputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputEnabled(java.lang.Boolean inputEnabled) {
                this.inputEnabled = inputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link PiiEntityConfigProperty#getInputEnabled}
             * @param inputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputEnabled(software.amazon.awscdk.IResolvable inputEnabled) {
                this.inputEnabled = inputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link PiiEntityConfigProperty#getOutputAction}
             * @param outputAction Options for sensitive information action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputAction(java.lang.String outputAction) {
                this.outputAction = outputAction;
                return this;
            }

            /**
             * Sets the value of {@link PiiEntityConfigProperty#getOutputEnabled}
             * @param outputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputEnabled(java.lang.Boolean outputEnabled) {
                this.outputEnabled = outputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link PiiEntityConfigProperty#getOutputEnabled}
             * @param outputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputEnabled(software.amazon.awscdk.IResolvable outputEnabled) {
                this.outputEnabled = outputEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PiiEntityConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PiiEntityConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PiiEntityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PiiEntityConfigProperty {
            private final java.lang.String action;
            private final java.lang.String type;
            private final java.lang.String inputAction;
            private final java.lang.Object inputEnabled;
            private final java.lang.String outputAction;
            private final java.lang.Object outputEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputAction = software.amazon.jsii.Kernel.get(this, "inputAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputEnabled = software.amazon.jsii.Kernel.get(this, "inputEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputAction = software.amazon.jsii.Kernel.get(this, "outputAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputEnabled = software.amazon.jsii.Kernel.get(this, "outputEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.inputAction = builder.inputAction;
                this.inputEnabled = builder.inputEnabled;
                this.outputAction = builder.outputAction;
                this.outputEnabled = builder.outputEnabled;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getInputAction() {
                return this.inputAction;
            }

            @Override
            public final java.lang.Object getInputEnabled() {
                return this.inputEnabled;
            }

            @Override
            public final java.lang.String getOutputAction() {
                return this.outputAction;
            }

            @Override
            public final java.lang.Object getOutputEnabled() {
                return this.outputEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getInputAction() != null) {
                    data.set("inputAction", om.valueToTree(this.getInputAction()));
                }
                if (this.getInputEnabled() != null) {
                    data.set("inputEnabled", om.valueToTree(this.getInputEnabled()));
                }
                if (this.getOutputAction() != null) {
                    data.set("outputAction", om.valueToTree(this.getOutputAction()));
                }
                if (this.getOutputEnabled() != null) {
                    data.set("outputEnabled", om.valueToTree(this.getOutputEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnGuardrail.PiiEntityConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PiiEntityConfigProperty.Jsii$Proxy that = (PiiEntityConfigProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!type.equals(that.type)) return false;
                if (this.inputAction != null ? !this.inputAction.equals(that.inputAction) : that.inputAction != null) return false;
                if (this.inputEnabled != null ? !this.inputEnabled.equals(that.inputEnabled) : that.inputEnabled != null) return false;
                if (this.outputAction != null ? !this.outputAction.equals(that.outputAction) : that.outputAction != null) return false;
                return this.outputEnabled != null ? this.outputEnabled.equals(that.outputEnabled) : that.outputEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.inputAction != null ? this.inputAction.hashCode() : 0);
                result = 31 * result + (this.inputEnabled != null ? this.inputEnabled.hashCode() : 0);
                result = 31 * result + (this.outputAction != null ? this.outputAction.hashCode() : 0);
                result = 31 * result + (this.outputEnabled != null ? this.outputEnabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The regular expression to configure for the guardrail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RegexConfigProperty regexConfigProperty = RegexConfigProperty.builder()
     *         .action("action")
     *         .name("name")
     *         .pattern("pattern")
     *         // the properties below are optional
     *         .description("description")
     *         .inputAction("inputAction")
     *         .inputEnabled(false)
     *         .outputAction("outputAction")
     *         .outputEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrail.RegexConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RegexConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RegexConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The guardrail action to configure when matching regular expression is detected.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html#cfn-bedrock-guardrail-regexconfig-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html#cfn-bedrock-guardrail-regexconfig-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * The name of the regular expression to configure for the guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html#cfn-bedrock-guardrail-regexconfig-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html#cfn-bedrock-guardrail-regexconfig-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The regular expression pattern to configure for the guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html#cfn-bedrock-guardrail-regexconfig-pattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html#cfn-bedrock-guardrail-regexconfig-pattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPattern();

        /**
         * The description of the regular expression to configure for the guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html#cfn-bedrock-guardrail-regexconfig-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html#cfn-bedrock-guardrail-regexconfig-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Options for sensitive information action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html#cfn-bedrock-guardrail-regexconfig-inputaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html#cfn-bedrock-guardrail-regexconfig-inputaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputAction() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html#cfn-bedrock-guardrail-regexconfig-inputenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html#cfn-bedrock-guardrail-regexconfig-inputenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputEnabled() {
            return null;
        }

        /**
         * Options for sensitive information action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html#cfn-bedrock-guardrail-regexconfig-outputaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html#cfn-bedrock-guardrail-regexconfig-outputaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputAction() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html#cfn-bedrock-guardrail-regexconfig-outputenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-regexconfig.html#cfn-bedrock-guardrail-regexconfig-outputenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RegexConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RegexConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RegexConfigProperty> {
            java.lang.String action;
            java.lang.String name;
            java.lang.String pattern;
            java.lang.String description;
            java.lang.String inputAction;
            java.lang.Object inputEnabled;
            java.lang.String outputAction;
            java.lang.Object outputEnabled;

            /**
             * Sets the value of {@link RegexConfigProperty#getAction}
             * @param action The guardrail action to configure when matching regular expression is detected. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link RegexConfigProperty#getName}
             * @param name The name of the regular expression to configure for the guardrail. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RegexConfigProperty#getPattern}
             * @param pattern The regular expression pattern to configure for the guardrail. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pattern(java.lang.String pattern) {
                this.pattern = pattern;
                return this;
            }

            /**
             * Sets the value of {@link RegexConfigProperty#getDescription}
             * @param description The description of the regular expression to configure for the guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link RegexConfigProperty#getInputAction}
             * @param inputAction Options for sensitive information action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputAction(java.lang.String inputAction) {
                this.inputAction = inputAction;
                return this;
            }

            /**
             * Sets the value of {@link RegexConfigProperty#getInputEnabled}
             * @param inputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputEnabled(java.lang.Boolean inputEnabled) {
                this.inputEnabled = inputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RegexConfigProperty#getInputEnabled}
             * @param inputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputEnabled(software.amazon.awscdk.IResolvable inputEnabled) {
                this.inputEnabled = inputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RegexConfigProperty#getOutputAction}
             * @param outputAction Options for sensitive information action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputAction(java.lang.String outputAction) {
                this.outputAction = outputAction;
                return this;
            }

            /**
             * Sets the value of {@link RegexConfigProperty#getOutputEnabled}
             * @param outputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputEnabled(java.lang.Boolean outputEnabled) {
                this.outputEnabled = outputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link RegexConfigProperty#getOutputEnabled}
             * @param outputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputEnabled(software.amazon.awscdk.IResolvable outputEnabled) {
                this.outputEnabled = outputEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RegexConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RegexConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RegexConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RegexConfigProperty {
            private final java.lang.String action;
            private final java.lang.String name;
            private final java.lang.String pattern;
            private final java.lang.String description;
            private final java.lang.String inputAction;
            private final java.lang.Object inputEnabled;
            private final java.lang.String outputAction;
            private final java.lang.Object outputEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pattern = software.amazon.jsii.Kernel.get(this, "pattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputAction = software.amazon.jsii.Kernel.get(this, "inputAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputEnabled = software.amazon.jsii.Kernel.get(this, "inputEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputAction = software.amazon.jsii.Kernel.get(this, "outputAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputEnabled = software.amazon.jsii.Kernel.get(this, "outputEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.pattern = java.util.Objects.requireNonNull(builder.pattern, "pattern is required");
                this.description = builder.description;
                this.inputAction = builder.inputAction;
                this.inputEnabled = builder.inputEnabled;
                this.outputAction = builder.outputAction;
                this.outputEnabled = builder.outputEnabled;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getPattern() {
                return this.pattern;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getInputAction() {
                return this.inputAction;
            }

            @Override
            public final java.lang.Object getInputEnabled() {
                return this.inputEnabled;
            }

            @Override
            public final java.lang.String getOutputAction() {
                return this.outputAction;
            }

            @Override
            public final java.lang.Object getOutputEnabled() {
                return this.outputEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("pattern", om.valueToTree(this.getPattern()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getInputAction() != null) {
                    data.set("inputAction", om.valueToTree(this.getInputAction()));
                }
                if (this.getInputEnabled() != null) {
                    data.set("inputEnabled", om.valueToTree(this.getInputEnabled()));
                }
                if (this.getOutputAction() != null) {
                    data.set("outputAction", om.valueToTree(this.getOutputAction()));
                }
                if (this.getOutputEnabled() != null) {
                    data.set("outputEnabled", om.valueToTree(this.getOutputEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnGuardrail.RegexConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RegexConfigProperty.Jsii$Proxy that = (RegexConfigProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!name.equals(that.name)) return false;
                if (!pattern.equals(that.pattern)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.inputAction != null ? !this.inputAction.equals(that.inputAction) : that.inputAction != null) return false;
                if (this.inputEnabled != null ? !this.inputEnabled.equals(that.inputEnabled) : that.inputEnabled != null) return false;
                if (this.outputAction != null ? !this.outputAction.equals(that.outputAction) : that.outputAction != null) return false;
                return this.outputEnabled != null ? this.outputEnabled.equals(that.outputEnabled) : that.outputEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.pattern.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.inputAction != null ? this.inputAction.hashCode() : 0);
                result = 31 * result + (this.inputEnabled != null ? this.inputEnabled.hashCode() : 0);
                result = 31 * result + (this.outputAction != null ? this.outputAction.hashCode() : 0);
                result = 31 * result + (this.outputEnabled != null ? this.outputEnabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains details about PII entities and regular expressions to configure for the guardrail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * SensitiveInformationPolicyConfigProperty sensitiveInformationPolicyConfigProperty = SensitiveInformationPolicyConfigProperty.builder()
     *         .piiEntitiesConfig(List.of(PiiEntityConfigProperty.builder()
     *                 .action("action")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .inputAction("inputAction")
     *                 .inputEnabled(false)
     *                 .outputAction("outputAction")
     *                 .outputEnabled(false)
     *                 .build()))
     *         .regexesConfig(List.of(RegexConfigProperty.builder()
     *                 .action("action")
     *                 .name("name")
     *                 .pattern("pattern")
     *                 // the properties below are optional
     *                 .description("description")
     *                 .inputAction("inputAction")
     *                 .inputEnabled(false)
     *                 .outputAction("outputAction")
     *                 .outputEnabled(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-sensitiveinformationpolicyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-sensitiveinformationpolicyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrail.SensitiveInformationPolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SensitiveInformationPolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SensitiveInformationPolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of PII entities to configure to the guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-sensitiveinformationpolicyconfig.html#cfn-bedrock-guardrail-sensitiveinformationpolicyconfig-piientitiesconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-sensitiveinformationpolicyconfig.html#cfn-bedrock-guardrail-sensitiveinformationpolicyconfig-piientitiesconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPiiEntitiesConfig() {
            return null;
        }

        /**
         * A list of regular expressions to configure to the guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-sensitiveinformationpolicyconfig.html#cfn-bedrock-guardrail-sensitiveinformationpolicyconfig-regexesconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-sensitiveinformationpolicyconfig.html#cfn-bedrock-guardrail-sensitiveinformationpolicyconfig-regexesconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRegexesConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SensitiveInformationPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SensitiveInformationPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SensitiveInformationPolicyConfigProperty> {
            java.lang.Object piiEntitiesConfig;
            java.lang.Object regexesConfig;

            /**
             * Sets the value of {@link SensitiveInformationPolicyConfigProperty#getPiiEntitiesConfig}
             * @param piiEntitiesConfig A list of PII entities to configure to the guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder piiEntitiesConfig(software.amazon.awscdk.IResolvable piiEntitiesConfig) {
                this.piiEntitiesConfig = piiEntitiesConfig;
                return this;
            }

            /**
             * Sets the value of {@link SensitiveInformationPolicyConfigProperty#getPiiEntitiesConfig}
             * @param piiEntitiesConfig A list of PII entities to configure to the guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder piiEntitiesConfig(java.util.List<? extends java.lang.Object> piiEntitiesConfig) {
                this.piiEntitiesConfig = piiEntitiesConfig;
                return this;
            }

            /**
             * Sets the value of {@link SensitiveInformationPolicyConfigProperty#getRegexesConfig}
             * @param regexesConfig A list of regular expressions to configure to the guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regexesConfig(software.amazon.awscdk.IResolvable regexesConfig) {
                this.regexesConfig = regexesConfig;
                return this;
            }

            /**
             * Sets the value of {@link SensitiveInformationPolicyConfigProperty#getRegexesConfig}
             * @param regexesConfig A list of regular expressions to configure to the guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regexesConfig(java.util.List<? extends java.lang.Object> regexesConfig) {
                this.regexesConfig = regexesConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SensitiveInformationPolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SensitiveInformationPolicyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SensitiveInformationPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SensitiveInformationPolicyConfigProperty {
            private final java.lang.Object piiEntitiesConfig;
            private final java.lang.Object regexesConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.piiEntitiesConfig = software.amazon.jsii.Kernel.get(this, "piiEntitiesConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.regexesConfig = software.amazon.jsii.Kernel.get(this, "regexesConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.piiEntitiesConfig = builder.piiEntitiesConfig;
                this.regexesConfig = builder.regexesConfig;
            }

            @Override
            public final java.lang.Object getPiiEntitiesConfig() {
                return this.piiEntitiesConfig;
            }

            @Override
            public final java.lang.Object getRegexesConfig() {
                return this.regexesConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPiiEntitiesConfig() != null) {
                    data.set("piiEntitiesConfig", om.valueToTree(this.getPiiEntitiesConfig()));
                }
                if (this.getRegexesConfig() != null) {
                    data.set("regexesConfig", om.valueToTree(this.getRegexesConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnGuardrail.SensitiveInformationPolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SensitiveInformationPolicyConfigProperty.Jsii$Proxy that = (SensitiveInformationPolicyConfigProperty.Jsii$Proxy) o;

                if (this.piiEntitiesConfig != null ? !this.piiEntitiesConfig.equals(that.piiEntitiesConfig) : that.piiEntitiesConfig != null) return false;
                return this.regexesConfig != null ? this.regexesConfig.equals(that.regexesConfig) : that.regexesConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.piiEntitiesConfig != null ? this.piiEntitiesConfig.hashCode() : 0;
                result = 31 * result + (this.regexesConfig != null ? this.regexesConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details about topics for the guardrail to identify and deny.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * TopicConfigProperty topicConfigProperty = TopicConfigProperty.builder()
     *         .definition("definition")
     *         .name("name")
     *         .type("type")
     *         // the properties below are optional
     *         .examples(List.of("examples"))
     *         .inputAction("inputAction")
     *         .inputEnabled(false)
     *         .outputAction("outputAction")
     *         .outputEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrail.TopicConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A definition of the topic to deny.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html#cfn-bedrock-guardrail-topicconfig-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html#cfn-bedrock-guardrail-topicconfig-definition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDefinition();

        /**
         * The name of the topic to deny.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html#cfn-bedrock-guardrail-topicconfig-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html#cfn-bedrock-guardrail-topicconfig-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Specifies to deny the topic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html#cfn-bedrock-guardrail-topicconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html#cfn-bedrock-guardrail-topicconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * A list of prompts, each of which is an example of a prompt that can be categorized as belonging to the topic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html#cfn-bedrock-guardrail-topicconfig-examples">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html#cfn-bedrock-guardrail-topicconfig-examples</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExamples() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html#cfn-bedrock-guardrail-topicconfig-inputaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html#cfn-bedrock-guardrail-topicconfig-inputaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputAction() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html#cfn-bedrock-guardrail-topicconfig-inputenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html#cfn-bedrock-guardrail-topicconfig-inputenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputEnabled() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html#cfn-bedrock-guardrail-topicconfig-outputaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html#cfn-bedrock-guardrail-topicconfig-outputaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputAction() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html#cfn-bedrock-guardrail-topicconfig-outputenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicconfig.html#cfn-bedrock-guardrail-topicconfig-outputenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicConfigProperty> {
            java.lang.String definition;
            java.lang.String name;
            java.lang.String type;
            java.util.List<java.lang.String> examples;
            java.lang.String inputAction;
            java.lang.Object inputEnabled;
            java.lang.String outputAction;
            java.lang.Object outputEnabled;

            /**
             * Sets the value of {@link TopicConfigProperty#getDefinition}
             * @param definition A definition of the topic to deny. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder definition(java.lang.String definition) {
                this.definition = definition;
                return this;
            }

            /**
             * Sets the value of {@link TopicConfigProperty#getName}
             * @param name The name of the topic to deny. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link TopicConfigProperty#getType}
             * @param type Specifies to deny the topic. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link TopicConfigProperty#getExamples}
             * @param examples A list of prompts, each of which is an example of a prompt that can be categorized as belonging to the topic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder examples(java.util.List<java.lang.String> examples) {
                this.examples = examples;
                return this;
            }

            /**
             * Sets the value of {@link TopicConfigProperty#getInputAction}
             * @param inputAction the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputAction(java.lang.String inputAction) {
                this.inputAction = inputAction;
                return this;
            }

            /**
             * Sets the value of {@link TopicConfigProperty#getInputEnabled}
             * @param inputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputEnabled(java.lang.Boolean inputEnabled) {
                this.inputEnabled = inputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link TopicConfigProperty#getInputEnabled}
             * @param inputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputEnabled(software.amazon.awscdk.IResolvable inputEnabled) {
                this.inputEnabled = inputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link TopicConfigProperty#getOutputAction}
             * @param outputAction the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputAction(java.lang.String outputAction) {
                this.outputAction = outputAction;
                return this;
            }

            /**
             * Sets the value of {@link TopicConfigProperty#getOutputEnabled}
             * @param outputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputEnabled(java.lang.Boolean outputEnabled) {
                this.outputEnabled = outputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link TopicConfigProperty#getOutputEnabled}
             * @param outputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputEnabled(software.amazon.awscdk.IResolvable outputEnabled) {
                this.outputEnabled = outputEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicConfigProperty {
            private final java.lang.String definition;
            private final java.lang.String name;
            private final java.lang.String type;
            private final java.util.List<java.lang.String> examples;
            private final java.lang.String inputAction;
            private final java.lang.Object inputEnabled;
            private final java.lang.String outputAction;
            private final java.lang.Object outputEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.examples = software.amazon.jsii.Kernel.get(this, "examples", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.inputAction = software.amazon.jsii.Kernel.get(this, "inputAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputEnabled = software.amazon.jsii.Kernel.get(this, "inputEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputAction = software.amazon.jsii.Kernel.get(this, "outputAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputEnabled = software.amazon.jsii.Kernel.get(this, "outputEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.definition = java.util.Objects.requireNonNull(builder.definition, "definition is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.examples = builder.examples;
                this.inputAction = builder.inputAction;
                this.inputEnabled = builder.inputEnabled;
                this.outputAction = builder.outputAction;
                this.outputEnabled = builder.outputEnabled;
            }

            @Override
            public final java.lang.String getDefinition() {
                return this.definition;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.util.List<java.lang.String> getExamples() {
                return this.examples;
            }

            @Override
            public final java.lang.String getInputAction() {
                return this.inputAction;
            }

            @Override
            public final java.lang.Object getInputEnabled() {
                return this.inputEnabled;
            }

            @Override
            public final java.lang.String getOutputAction() {
                return this.outputAction;
            }

            @Override
            public final java.lang.Object getOutputEnabled() {
                return this.outputEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("definition", om.valueToTree(this.getDefinition()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getExamples() != null) {
                    data.set("examples", om.valueToTree(this.getExamples()));
                }
                if (this.getInputAction() != null) {
                    data.set("inputAction", om.valueToTree(this.getInputAction()));
                }
                if (this.getInputEnabled() != null) {
                    data.set("inputEnabled", om.valueToTree(this.getInputEnabled()));
                }
                if (this.getOutputAction() != null) {
                    data.set("outputAction", om.valueToTree(this.getOutputAction()));
                }
                if (this.getOutputEnabled() != null) {
                    data.set("outputEnabled", om.valueToTree(this.getOutputEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnGuardrail.TopicConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicConfigProperty.Jsii$Proxy that = (TopicConfigProperty.Jsii$Proxy) o;

                if (!definition.equals(that.definition)) return false;
                if (!name.equals(that.name)) return false;
                if (!type.equals(that.type)) return false;
                if (this.examples != null ? !this.examples.equals(that.examples) : that.examples != null) return false;
                if (this.inputAction != null ? !this.inputAction.equals(that.inputAction) : that.inputAction != null) return false;
                if (this.inputEnabled != null ? !this.inputEnabled.equals(that.inputEnabled) : that.inputEnabled != null) return false;
                if (this.outputAction != null ? !this.outputAction.equals(that.outputAction) : that.outputAction != null) return false;
                return this.outputEnabled != null ? this.outputEnabled.equals(that.outputEnabled) : that.outputEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.definition.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.examples != null ? this.examples.hashCode() : 0);
                result = 31 * result + (this.inputAction != null ? this.inputAction.hashCode() : 0);
                result = 31 * result + (this.inputEnabled != null ? this.inputEnabled.hashCode() : 0);
                result = 31 * result + (this.outputAction != null ? this.outputAction.hashCode() : 0);
                result = 31 * result + (this.outputEnabled != null ? this.outputEnabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains details about topics that the guardrail should identify and deny.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * TopicPolicyConfigProperty topicPolicyConfigProperty = TopicPolicyConfigProperty.builder()
     *         .topicsConfig(List.of(TopicConfigProperty.builder()
     *                 .definition("definition")
     *                 .name("name")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .examples(List.of("examples"))
     *                 .inputAction("inputAction")
     *                 .inputEnabled(false)
     *                 .outputAction("outputAction")
     *                 .outputEnabled(false)
     *                 .build()))
     *         // the properties below are optional
     *         .topicsTierConfig(TopicsTierConfigProperty.builder()
     *                 .tierName("tierName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicpolicyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicpolicyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrail.TopicPolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicPolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicPolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of policies related to topics that the guardrail should deny.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicpolicyconfig.html#cfn-bedrock-guardrail-topicpolicyconfig-topicsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicpolicyconfig.html#cfn-bedrock-guardrail-topicpolicyconfig-topicsconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTopicsConfig();

        /**
         * Guardrail tier config for topic policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicpolicyconfig.html#cfn-bedrock-guardrail-topicpolicyconfig-topicstierconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicpolicyconfig.html#cfn-bedrock-guardrail-topicpolicyconfig-topicstierconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTopicsTierConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicPolicyConfigProperty> {
            java.lang.Object topicsConfig;
            java.lang.Object topicsTierConfig;

            /**
             * Sets the value of {@link TopicPolicyConfigProperty#getTopicsConfig}
             * @param topicsConfig A list of policies related to topics that the guardrail should deny. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicsConfig(software.amazon.awscdk.IResolvable topicsConfig) {
                this.topicsConfig = topicsConfig;
                return this;
            }

            /**
             * Sets the value of {@link TopicPolicyConfigProperty#getTopicsConfig}
             * @param topicsConfig A list of policies related to topics that the guardrail should deny. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicsConfig(java.util.List<? extends java.lang.Object> topicsConfig) {
                this.topicsConfig = topicsConfig;
                return this;
            }

            /**
             * Sets the value of {@link TopicPolicyConfigProperty#getTopicsTierConfig}
             * @param topicsTierConfig Guardrail tier config for topic policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicsTierConfig(software.amazon.awscdk.IResolvable topicsTierConfig) {
                this.topicsTierConfig = topicsTierConfig;
                return this;
            }

            /**
             * Sets the value of {@link TopicPolicyConfigProperty#getTopicsTierConfig}
             * @param topicsTierConfig Guardrail tier config for topic policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicsTierConfig(software.amazon.awscdk.services.bedrock.CfnGuardrail.TopicsTierConfigProperty topicsTierConfig) {
                this.topicsTierConfig = topicsTierConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicPolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicPolicyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicPolicyConfigProperty {
            private final java.lang.Object topicsConfig;
            private final java.lang.Object topicsTierConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.topicsConfig = software.amazon.jsii.Kernel.get(this, "topicsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.topicsTierConfig = software.amazon.jsii.Kernel.get(this, "topicsTierConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topicsConfig = java.util.Objects.requireNonNull(builder.topicsConfig, "topicsConfig is required");
                this.topicsTierConfig = builder.topicsTierConfig;
            }

            @Override
            public final java.lang.Object getTopicsConfig() {
                return this.topicsConfig;
            }

            @Override
            public final java.lang.Object getTopicsTierConfig() {
                return this.topicsTierConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("topicsConfig", om.valueToTree(this.getTopicsConfig()));
                if (this.getTopicsTierConfig() != null) {
                    data.set("topicsTierConfig", om.valueToTree(this.getTopicsTierConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnGuardrail.TopicPolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicPolicyConfigProperty.Jsii$Proxy that = (TopicPolicyConfigProperty.Jsii$Proxy) o;

                if (!topicsConfig.equals(that.topicsConfig)) return false;
                return this.topicsTierConfig != null ? this.topicsTierConfig.equals(that.topicsTierConfig) : that.topicsTierConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.topicsConfig.hashCode();
                result = 31 * result + (this.topicsTierConfig != null ? this.topicsTierConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Guardrail tier config for topic policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * TopicsTierConfigProperty topicsTierConfigProperty = TopicsTierConfigProperty.builder()
     *         .tierName("tierName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicstierconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicstierconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrail.TopicsTierConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicsTierConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicsTierConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Tier name for tier configuration in topic policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicstierconfig.html#cfn-bedrock-guardrail-topicstierconfig-tiername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-topicstierconfig.html#cfn-bedrock-guardrail-topicstierconfig-tiername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTierName();

        /**
         * @return a {@link Builder} of {@link TopicsTierConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicsTierConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicsTierConfigProperty> {
            java.lang.String tierName;

            /**
             * Sets the value of {@link TopicsTierConfigProperty#getTierName}
             * @param tierName Tier name for tier configuration in topic policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tierName(java.lang.String tierName) {
                this.tierName = tierName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicsTierConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicsTierConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicsTierConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicsTierConfigProperty {
            private final java.lang.String tierName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tierName = software.amazon.jsii.Kernel.get(this, "tierName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tierName = java.util.Objects.requireNonNull(builder.tierName, "tierName is required");
            }

            @Override
            public final java.lang.String getTierName() {
                return this.tierName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("tierName", om.valueToTree(this.getTierName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnGuardrail.TopicsTierConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicsTierConfigProperty.Jsii$Proxy that = (TopicsTierConfigProperty.Jsii$Proxy) o;

                return this.tierName.equals(that.tierName);
            }

            @Override
            public final int hashCode() {
                int result = this.tierName.hashCode();
                return result;
            }
        }
    }
    /**
     * A word to configure for the guardrail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * WordConfigProperty wordConfigProperty = WordConfigProperty.builder()
     *         .text("text")
     *         // the properties below are optional
     *         .inputAction("inputAction")
     *         .inputEnabled(false)
     *         .outputAction("outputAction")
     *         .outputEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrail.WordConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(WordConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WordConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Text of the word configured for the guardrail to block.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordconfig.html#cfn-bedrock-guardrail-wordconfig-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordconfig.html#cfn-bedrock-guardrail-wordconfig-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getText();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordconfig.html#cfn-bedrock-guardrail-wordconfig-inputaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordconfig.html#cfn-bedrock-guardrail-wordconfig-inputaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputAction() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordconfig.html#cfn-bedrock-guardrail-wordconfig-inputenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordconfig.html#cfn-bedrock-guardrail-wordconfig-inputenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputEnabled() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordconfig.html#cfn-bedrock-guardrail-wordconfig-outputaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordconfig.html#cfn-bedrock-guardrail-wordconfig-outputaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputAction() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordconfig.html#cfn-bedrock-guardrail-wordconfig-outputenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordconfig.html#cfn-bedrock-guardrail-wordconfig-outputenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WordConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WordConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WordConfigProperty> {
            java.lang.String text;
            java.lang.String inputAction;
            java.lang.Object inputEnabled;
            java.lang.String outputAction;
            java.lang.Object outputEnabled;

            /**
             * Sets the value of {@link WordConfigProperty#getText}
             * @param text Text of the word configured for the guardrail to block. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link WordConfigProperty#getInputAction}
             * @param inputAction the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputAction(java.lang.String inputAction) {
                this.inputAction = inputAction;
                return this;
            }

            /**
             * Sets the value of {@link WordConfigProperty#getInputEnabled}
             * @param inputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputEnabled(java.lang.Boolean inputEnabled) {
                this.inputEnabled = inputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WordConfigProperty#getInputEnabled}
             * @param inputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputEnabled(software.amazon.awscdk.IResolvable inputEnabled) {
                this.inputEnabled = inputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WordConfigProperty#getOutputAction}
             * @param outputAction the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputAction(java.lang.String outputAction) {
                this.outputAction = outputAction;
                return this;
            }

            /**
             * Sets the value of {@link WordConfigProperty#getOutputEnabled}
             * @param outputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputEnabled(java.lang.Boolean outputEnabled) {
                this.outputEnabled = outputEnabled;
                return this;
            }

            /**
             * Sets the value of {@link WordConfigProperty#getOutputEnabled}
             * @param outputEnabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputEnabled(software.amazon.awscdk.IResolvable outputEnabled) {
                this.outputEnabled = outputEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WordConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WordConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WordConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WordConfigProperty {
            private final java.lang.String text;
            private final java.lang.String inputAction;
            private final java.lang.Object inputEnabled;
            private final java.lang.String outputAction;
            private final java.lang.Object outputEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputAction = software.amazon.jsii.Kernel.get(this, "inputAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputEnabled = software.amazon.jsii.Kernel.get(this, "inputEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputAction = software.amazon.jsii.Kernel.get(this, "outputAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputEnabled = software.amazon.jsii.Kernel.get(this, "outputEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.text = java.util.Objects.requireNonNull(builder.text, "text is required");
                this.inputAction = builder.inputAction;
                this.inputEnabled = builder.inputEnabled;
                this.outputAction = builder.outputAction;
                this.outputEnabled = builder.outputEnabled;
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            public final java.lang.String getInputAction() {
                return this.inputAction;
            }

            @Override
            public final java.lang.Object getInputEnabled() {
                return this.inputEnabled;
            }

            @Override
            public final java.lang.String getOutputAction() {
                return this.outputAction;
            }

            @Override
            public final java.lang.Object getOutputEnabled() {
                return this.outputEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("text", om.valueToTree(this.getText()));
                if (this.getInputAction() != null) {
                    data.set("inputAction", om.valueToTree(this.getInputAction()));
                }
                if (this.getInputEnabled() != null) {
                    data.set("inputEnabled", om.valueToTree(this.getInputEnabled()));
                }
                if (this.getOutputAction() != null) {
                    data.set("outputAction", om.valueToTree(this.getOutputAction()));
                }
                if (this.getOutputEnabled() != null) {
                    data.set("outputEnabled", om.valueToTree(this.getOutputEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnGuardrail.WordConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WordConfigProperty.Jsii$Proxy that = (WordConfigProperty.Jsii$Proxy) o;

                if (!text.equals(that.text)) return false;
                if (this.inputAction != null ? !this.inputAction.equals(that.inputAction) : that.inputAction != null) return false;
                if (this.inputEnabled != null ? !this.inputEnabled.equals(that.inputEnabled) : that.inputEnabled != null) return false;
                if (this.outputAction != null ? !this.outputAction.equals(that.outputAction) : that.outputAction != null) return false;
                return this.outputEnabled != null ? this.outputEnabled.equals(that.outputEnabled) : that.outputEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.text.hashCode();
                result = 31 * result + (this.inputAction != null ? this.inputAction.hashCode() : 0);
                result = 31 * result + (this.inputEnabled != null ? this.inputEnabled.hashCode() : 0);
                result = 31 * result + (this.outputAction != null ? this.outputAction.hashCode() : 0);
                result = 31 * result + (this.outputEnabled != null ? this.outputEnabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains details about the word policy to configured for the guardrail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * WordPolicyConfigProperty wordPolicyConfigProperty = WordPolicyConfigProperty.builder()
     *         .managedWordListsConfig(List.of(ManagedWordsConfigProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .inputAction("inputAction")
     *                 .inputEnabled(false)
     *                 .outputAction("outputAction")
     *                 .outputEnabled(false)
     *                 .build()))
     *         .wordsConfig(List.of(WordConfigProperty.builder()
     *                 .text("text")
     *                 // the properties below are optional
     *                 .inputAction("inputAction")
     *                 .inputEnabled(false)
     *                 .outputAction("outputAction")
     *                 .outputEnabled(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordpolicyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordpolicyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnGuardrail.WordPolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(WordPolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WordPolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of managed words to configure for the guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordpolicyconfig.html#cfn-bedrock-guardrail-wordpolicyconfig-managedwordlistsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordpolicyconfig.html#cfn-bedrock-guardrail-wordpolicyconfig-managedwordlistsconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManagedWordListsConfig() {
            return null;
        }

        /**
         * A list of words to configure for the guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordpolicyconfig.html#cfn-bedrock-guardrail-wordpolicyconfig-wordsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-guardrail-wordpolicyconfig.html#cfn-bedrock-guardrail-wordpolicyconfig-wordsconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWordsConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WordPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WordPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WordPolicyConfigProperty> {
            java.lang.Object managedWordListsConfig;
            java.lang.Object wordsConfig;

            /**
             * Sets the value of {@link WordPolicyConfigProperty#getManagedWordListsConfig}
             * @param managedWordListsConfig A list of managed words to configure for the guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedWordListsConfig(software.amazon.awscdk.IResolvable managedWordListsConfig) {
                this.managedWordListsConfig = managedWordListsConfig;
                return this;
            }

            /**
             * Sets the value of {@link WordPolicyConfigProperty#getManagedWordListsConfig}
             * @param managedWordListsConfig A list of managed words to configure for the guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedWordListsConfig(java.util.List<? extends java.lang.Object> managedWordListsConfig) {
                this.managedWordListsConfig = managedWordListsConfig;
                return this;
            }

            /**
             * Sets the value of {@link WordPolicyConfigProperty#getWordsConfig}
             * @param wordsConfig A list of words to configure for the guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wordsConfig(software.amazon.awscdk.IResolvable wordsConfig) {
                this.wordsConfig = wordsConfig;
                return this;
            }

            /**
             * Sets the value of {@link WordPolicyConfigProperty#getWordsConfig}
             * @param wordsConfig A list of words to configure for the guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wordsConfig(java.util.List<? extends java.lang.Object> wordsConfig) {
                this.wordsConfig = wordsConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WordPolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WordPolicyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WordPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WordPolicyConfigProperty {
            private final java.lang.Object managedWordListsConfig;
            private final java.lang.Object wordsConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.managedWordListsConfig = software.amazon.jsii.Kernel.get(this, "managedWordListsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.wordsConfig = software.amazon.jsii.Kernel.get(this, "wordsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.managedWordListsConfig = builder.managedWordListsConfig;
                this.wordsConfig = builder.wordsConfig;
            }

            @Override
            public final java.lang.Object getManagedWordListsConfig() {
                return this.managedWordListsConfig;
            }

            @Override
            public final java.lang.Object getWordsConfig() {
                return this.wordsConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getManagedWordListsConfig() != null) {
                    data.set("managedWordListsConfig", om.valueToTree(this.getManagedWordListsConfig()));
                }
                if (this.getWordsConfig() != null) {
                    data.set("wordsConfig", om.valueToTree(this.getWordsConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnGuardrail.WordPolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WordPolicyConfigProperty.Jsii$Proxy that = (WordPolicyConfigProperty.Jsii$Proxy) o;

                if (this.managedWordListsConfig != null ? !this.managedWordListsConfig.equals(that.managedWordListsConfig) : that.managedWordListsConfig != null) return false;
                return this.wordsConfig != null ? this.wordsConfig.equals(that.wordsConfig) : that.wordsConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.managedWordListsConfig != null ? this.managedWordListsConfig.hashCode() : 0;
                result = 31 * result + (this.wordsConfig != null ? this.wordsConfig.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.bedrock.CfnGuardrail}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.bedrock.CfnGuardrail> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.bedrock.CfnGuardrailProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.bedrock.CfnGuardrailProps.Builder();
        }

        /**
         * The message to return when the guardrail blocks a prompt.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-blockedinputmessaging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-blockedinputmessaging</a>
         * @param blockedInputMessaging The message to return when the guardrail blocks a prompt. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockedInputMessaging(final java.lang.String blockedInputMessaging) {
            this.props.blockedInputMessaging(blockedInputMessaging);
            return this;
        }

        /**
         * The message to return when the guardrail blocks a model response.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-blockedoutputsmessaging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-blockedoutputsmessaging</a>
         * @param blockedOutputsMessaging The message to return when the guardrail blocks a model response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockedOutputsMessaging(final java.lang.String blockedOutputsMessaging) {
            this.props.blockedOutputsMessaging(blockedOutputsMessaging);
            return this;
        }

        /**
         * The name of the guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-name</a>
         * @param name The name of the guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The content filter policies to configure for the guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-contentpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-contentpolicyconfig</a>
         * @param contentPolicyConfig The content filter policies to configure for the guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentPolicyConfig(final software.amazon.awscdk.IResolvable contentPolicyConfig) {
            this.props.contentPolicyConfig(contentPolicyConfig);
            return this;
        }
        /**
         * The content filter policies to configure for the guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-contentpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-contentpolicyconfig</a>
         * @param contentPolicyConfig The content filter policies to configure for the guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentPolicyConfig(final software.amazon.awscdk.services.bedrock.CfnGuardrail.ContentPolicyConfigProperty contentPolicyConfig) {
            this.props.contentPolicyConfig(contentPolicyConfig);
            return this;
        }

        /**
         * Contextual grounding policy config for a guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-contextualgroundingpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-contextualgroundingpolicyconfig</a>
         * @param contextualGroundingPolicyConfig Contextual grounding policy config for a guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contextualGroundingPolicyConfig(final software.amazon.awscdk.IResolvable contextualGroundingPolicyConfig) {
            this.props.contextualGroundingPolicyConfig(contextualGroundingPolicyConfig);
            return this;
        }
        /**
         * Contextual grounding policy config for a guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-contextualgroundingpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-contextualgroundingpolicyconfig</a>
         * @param contextualGroundingPolicyConfig Contextual grounding policy config for a guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contextualGroundingPolicyConfig(final software.amazon.awscdk.services.bedrock.CfnGuardrail.ContextualGroundingPolicyConfigProperty contextualGroundingPolicyConfig) {
            this.props.contextualGroundingPolicyConfig(contextualGroundingPolicyConfig);
            return this;
        }

        /**
         * The system-defined guardrail profile that you’re using with your guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-crossregionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-crossregionconfig</a>
         * @param crossRegionConfig The system-defined guardrail profile that you’re using with your guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossRegionConfig(final software.amazon.awscdk.IResolvable crossRegionConfig) {
            this.props.crossRegionConfig(crossRegionConfig);
            return this;
        }
        /**
         * The system-defined guardrail profile that you’re using with your guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-crossregionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-crossregionconfig</a>
         * @param crossRegionConfig The system-defined guardrail profile that you’re using with your guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossRegionConfig(final software.amazon.awscdk.services.bedrock.CfnGuardrail.GuardrailCrossRegionConfigProperty crossRegionConfig) {
            this.props.crossRegionConfig(crossRegionConfig);
            return this;
        }

        /**
         * A description of the guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-description</a>
         * @param description A description of the guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The ARN of the AWS KMS key that you use to encrypt the guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-kmskeyarn</a>
         * @param kmsKeyArn The ARN of the AWS KMS key that you use to encrypt the guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyArn(final java.lang.String kmsKeyArn) {
            this.props.kmsKeyArn(kmsKeyArn);
            return this;
        }

        /**
         * The sensitive information policy to configure for the guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-sensitiveinformationpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-sensitiveinformationpolicyconfig</a>
         * @param sensitiveInformationPolicyConfig The sensitive information policy to configure for the guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sensitiveInformationPolicyConfig(final software.amazon.awscdk.IResolvable sensitiveInformationPolicyConfig) {
            this.props.sensitiveInformationPolicyConfig(sensitiveInformationPolicyConfig);
            return this;
        }
        /**
         * The sensitive information policy to configure for the guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-sensitiveinformationpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-sensitiveinformationpolicyconfig</a>
         * @param sensitiveInformationPolicyConfig The sensitive information policy to configure for the guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sensitiveInformationPolicyConfig(final software.amazon.awscdk.services.bedrock.CfnGuardrail.SensitiveInformationPolicyConfigProperty sensitiveInformationPolicyConfig) {
            this.props.sensitiveInformationPolicyConfig(sensitiveInformationPolicyConfig);
            return this;
        }

        /**
         * The tags that you want to attach to the guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-tags</a>
         * @param tags The tags that you want to attach to the guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The topic policies to configure for the guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-topicpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-topicpolicyconfig</a>
         * @param topicPolicyConfig The topic policies to configure for the guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicPolicyConfig(final software.amazon.awscdk.IResolvable topicPolicyConfig) {
            this.props.topicPolicyConfig(topicPolicyConfig);
            return this;
        }
        /**
         * The topic policies to configure for the guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-topicpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-topicpolicyconfig</a>
         * @param topicPolicyConfig The topic policies to configure for the guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicPolicyConfig(final software.amazon.awscdk.services.bedrock.CfnGuardrail.TopicPolicyConfigProperty topicPolicyConfig) {
            this.props.topicPolicyConfig(topicPolicyConfig);
            return this;
        }

        /**
         * The word policy you configure for the guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-wordpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-wordpolicyconfig</a>
         * @param wordPolicyConfig The word policy you configure for the guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wordPolicyConfig(final software.amazon.awscdk.IResolvable wordPolicyConfig) {
            this.props.wordPolicyConfig(wordPolicyConfig);
            return this;
        }
        /**
         * The word policy you configure for the guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-wordpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-guardrail.html#cfn-bedrock-guardrail-wordpolicyconfig</a>
         * @param wordPolicyConfig The word policy you configure for the guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wordPolicyConfig(final software.amazon.awscdk.services.bedrock.CfnGuardrail.WordPolicyConfigProperty wordPolicyConfig) {
            this.props.wordPolicyConfig(wordPolicyConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.bedrock.CfnGuardrail}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.bedrock.CfnGuardrail build() {
            return new software.amazon.awscdk.services.bedrock.CfnGuardrail(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
