package software.amazon.awscdk.services.chatbot;

/**
 * Properties for a new Slack channel configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.chatbot.*;
 * Project project;
 * SlackChannelConfiguration target = SlackChannelConfiguration.Builder.create(this, "MySlackChannel")
 *         .slackChannelConfigurationName("YOUR_CHANNEL_NAME")
 *         .slackWorkspaceId("YOUR_SLACK_WORKSPACE_ID")
 *         .slackChannelId("YOUR_SLACK_CHANNEL_ID")
 *         .build();
 * INotificationRule rule = project.notifyOnBuildSucceeded("NotifyOnBuildSucceeded", target);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:32.190Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_chatbot.SlackChannelConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(SlackChannelConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SlackChannelConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of Slack channel configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSlackChannelConfigurationName();

    /**
     * The ID of the Slack channel.
     * <p>
     * To get the ID, open Slack, right click on the channel name in the left pane, then choose Copy Link.
     * The channel ID is the 9-character string at the end of the URL. For example, ABCBBLZZZ.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSlackChannelId();

    /**
     * The ID of the Slack workspace authorized with AWS Chatbot.
     * <p>
     * To get the workspace ID, you must perform the initial authorization flow with Slack in the AWS Chatbot console.
     * Then you can copy and paste the workspace ID from the console.
     * For more details, see steps 1-4 in Setting Up AWS Chatbot with Slack in the AWS Chatbot User Guide.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/setting-up.html#Setup_intro">https://docs.aws.amazon.com/chatbot/latest/adminguide/setting-up.html#Setup_intro</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSlackWorkspaceId();

    /**
     * A list of IAM managed policies that are applied as channel guardrails.
     * <p>
     * Default: - The AWS managed 'AdministratorAccess' policy is applied as a default if this is not set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> getGuardrailPolicies() {
        return null;
    }

    /**
     * Specifies the logging level for this configuration.
     * <p>
     * This property affects the log entries pushed to Amazon CloudWatch Logs.
     * <p>
     * Default: LoggingLevel.NONE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.chatbot.LoggingLevel getLoggingLevel() {
        return null;
    }

    /**
     * The number of days log events are kept in CloudWatch Logs.
     * <p>
     * When updating
     * this property, unsetting it doesn't remove the log retention policy. To
     * remove the retention policy, set the value to <code>INFINITE</code>.
     * <p>
     * Default: logs.RetentionDays.INFINITE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
        return null;
    }

    /**
     * When log retention is specified, a custom resource attempts to create the CloudWatch log group.
     * <p>
     * These options control the retry policy when interacting with CloudWatch APIs.
     * <p>
     * Default: - Default AWS SDK retry options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.LogRetentionRetryOptions getLogRetentionRetryOptions() {
        return null;
    }

    /**
     * The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
     * <p>
     * Default: - A new role is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getLogRetentionRole() {
        return null;
    }

    /**
     * The SNS topics that deliver notifications to AWS Chatbot.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.sns.ITopic> getNotificationTopics() {
        return null;
    }

    /**
     * The permission role of Slack channel configuration.
     * <p>
     * Default: - A role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Enables use of a user role requirement in your chat configuration.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUserRoleRequired() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SlackChannelConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SlackChannelConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SlackChannelConfigurationProps> {
        java.lang.String slackChannelConfigurationName;
        java.lang.String slackChannelId;
        java.lang.String slackWorkspaceId;
        java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> guardrailPolicies;
        software.amazon.awscdk.services.chatbot.LoggingLevel loggingLevel;
        software.amazon.awscdk.services.logs.RetentionDays logRetention;
        software.amazon.awscdk.services.logs.LogRetentionRetryOptions logRetentionRetryOptions;
        software.amazon.awscdk.services.iam.IRole logRetentionRole;
        java.util.List<software.amazon.awscdk.services.sns.ITopic> notificationTopics;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.Boolean userRoleRequired;

        /**
         * Sets the value of {@link SlackChannelConfigurationProps#getSlackChannelConfigurationName}
         * @param slackChannelConfigurationName The name of Slack channel configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slackChannelConfigurationName(java.lang.String slackChannelConfigurationName) {
            this.slackChannelConfigurationName = slackChannelConfigurationName;
            return this;
        }

        /**
         * Sets the value of {@link SlackChannelConfigurationProps#getSlackChannelId}
         * @param slackChannelId The ID of the Slack channel. This parameter is required.
         *                       To get the ID, open Slack, right click on the channel name in the left pane, then choose Copy Link.
         *                       The channel ID is the 9-character string at the end of the URL. For example, ABCBBLZZZ.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slackChannelId(java.lang.String slackChannelId) {
            this.slackChannelId = slackChannelId;
            return this;
        }

        /**
         * Sets the value of {@link SlackChannelConfigurationProps#getSlackWorkspaceId}
         * @param slackWorkspaceId The ID of the Slack workspace authorized with AWS Chatbot. This parameter is required.
         *                         To get the workspace ID, you must perform the initial authorization flow with Slack in the AWS Chatbot console.
         *                         Then you can copy and paste the workspace ID from the console.
         *                         For more details, see steps 1-4 in Setting Up AWS Chatbot with Slack in the AWS Chatbot User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slackWorkspaceId(java.lang.String slackWorkspaceId) {
            this.slackWorkspaceId = slackWorkspaceId;
            return this;
        }

        /**
         * Sets the value of {@link SlackChannelConfigurationProps#getGuardrailPolicies}
         * @param guardrailPolicies A list of IAM managed policies that are applied as channel guardrails.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder guardrailPolicies(java.util.List<? extends software.amazon.awscdk.services.iam.IManagedPolicy> guardrailPolicies) {
            this.guardrailPolicies = (java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy>)guardrailPolicies;
            return this;
        }

        /**
         * Sets the value of {@link SlackChannelConfigurationProps#getLoggingLevel}
         * @param loggingLevel Specifies the logging level for this configuration.
         *                     This property affects the log entries pushed to Amazon CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingLevel(software.amazon.awscdk.services.chatbot.LoggingLevel loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        /**
         * Sets the value of {@link SlackChannelConfigurationProps#getLogRetention}
         * @param logRetention The number of days log events are kept in CloudWatch Logs.
         *                     When updating
         *                     this property, unsetting it doesn't remove the log retention policy. To
         *                     remove the retention policy, set the value to <code>INFINITE</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        /**
         * Sets the value of {@link SlackChannelConfigurationProps#getLogRetentionRetryOptions}
         * @param logRetentionRetryOptions When log retention is specified, a custom resource attempts to create the CloudWatch log group.
         *                                 These options control the retry policy when interacting with CloudWatch APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRetryOptions(software.amazon.awscdk.services.logs.LogRetentionRetryOptions logRetentionRetryOptions) {
            this.logRetentionRetryOptions = logRetentionRetryOptions;
            return this;
        }

        /**
         * Sets the value of {@link SlackChannelConfigurationProps#getLogRetentionRole}
         * @param logRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRole(software.amazon.awscdk.services.iam.IRole logRetentionRole) {
            this.logRetentionRole = logRetentionRole;
            return this;
        }

        /**
         * Sets the value of {@link SlackChannelConfigurationProps#getNotificationTopics}
         * @param notificationTopics The SNS topics that deliver notifications to AWS Chatbot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder notificationTopics(java.util.List<? extends software.amazon.awscdk.services.sns.ITopic> notificationTopics) {
            this.notificationTopics = (java.util.List<software.amazon.awscdk.services.sns.ITopic>)notificationTopics;
            return this;
        }

        /**
         * Sets the value of {@link SlackChannelConfigurationProps#getRole}
         * @param role The permission role of Slack channel configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link SlackChannelConfigurationProps#getUserRoleRequired}
         * @param userRoleRequired Enables use of a user role requirement in your chat configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userRoleRequired(java.lang.Boolean userRoleRequired) {
            this.userRoleRequired = userRoleRequired;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SlackChannelConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SlackChannelConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SlackChannelConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlackChannelConfigurationProps {
        private final java.lang.String slackChannelConfigurationName;
        private final java.lang.String slackChannelId;
        private final java.lang.String slackWorkspaceId;
        private final java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> guardrailPolicies;
        private final software.amazon.awscdk.services.chatbot.LoggingLevel loggingLevel;
        private final software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private final software.amazon.awscdk.services.logs.LogRetentionRetryOptions logRetentionRetryOptions;
        private final software.amazon.awscdk.services.iam.IRole logRetentionRole;
        private final java.util.List<software.amazon.awscdk.services.sns.ITopic> notificationTopics;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.Boolean userRoleRequired;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.slackChannelConfigurationName = software.amazon.jsii.Kernel.get(this, "slackChannelConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.slackChannelId = software.amazon.jsii.Kernel.get(this, "slackChannelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.slackWorkspaceId = software.amazon.jsii.Kernel.get(this, "slackWorkspaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.guardrailPolicies = software.amazon.jsii.Kernel.get(this, "guardrailPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IManagedPolicy.class)));
            this.loggingLevel = software.amazon.jsii.Kernel.get(this, "loggingLevel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.chatbot.LoggingLevel.class));
            this.logRetention = software.amazon.jsii.Kernel.get(this, "logRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
            this.logRetentionRetryOptions = software.amazon.jsii.Kernel.get(this, "logRetentionRetryOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.LogRetentionRetryOptions.class));
            this.logRetentionRole = software.amazon.jsii.Kernel.get(this, "logRetentionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.notificationTopics = software.amazon.jsii.Kernel.get(this, "notificationTopics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class)));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.userRoleRequired = software.amazon.jsii.Kernel.get(this, "userRoleRequired", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.slackChannelConfigurationName = java.util.Objects.requireNonNull(builder.slackChannelConfigurationName, "slackChannelConfigurationName is required");
            this.slackChannelId = java.util.Objects.requireNonNull(builder.slackChannelId, "slackChannelId is required");
            this.slackWorkspaceId = java.util.Objects.requireNonNull(builder.slackWorkspaceId, "slackWorkspaceId is required");
            this.guardrailPolicies = (java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy>)builder.guardrailPolicies;
            this.loggingLevel = builder.loggingLevel;
            this.logRetention = builder.logRetention;
            this.logRetentionRetryOptions = builder.logRetentionRetryOptions;
            this.logRetentionRole = builder.logRetentionRole;
            this.notificationTopics = (java.util.List<software.amazon.awscdk.services.sns.ITopic>)builder.notificationTopics;
            this.role = builder.role;
            this.userRoleRequired = builder.userRoleRequired;
        }

        @Override
        public final java.lang.String getSlackChannelConfigurationName() {
            return this.slackChannelConfigurationName;
        }

        @Override
        public final java.lang.String getSlackChannelId() {
            return this.slackChannelId;
        }

        @Override
        public final java.lang.String getSlackWorkspaceId() {
            return this.slackWorkspaceId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IManagedPolicy> getGuardrailPolicies() {
            return this.guardrailPolicies;
        }

        @Override
        public final software.amazon.awscdk.services.chatbot.LoggingLevel getLoggingLevel() {
            return this.loggingLevel;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
            return this.logRetention;
        }

        @Override
        public final software.amazon.awscdk.services.logs.LogRetentionRetryOptions getLogRetentionRetryOptions() {
            return this.logRetentionRetryOptions;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getLogRetentionRole() {
            return this.logRetentionRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.sns.ITopic> getNotificationTopics() {
            return this.notificationTopics;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.Boolean getUserRoleRequired() {
            return this.userRoleRequired;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("slackChannelConfigurationName", om.valueToTree(this.getSlackChannelConfigurationName()));
            data.set("slackChannelId", om.valueToTree(this.getSlackChannelId()));
            data.set("slackWorkspaceId", om.valueToTree(this.getSlackWorkspaceId()));
            if (this.getGuardrailPolicies() != null) {
                data.set("guardrailPolicies", om.valueToTree(this.getGuardrailPolicies()));
            }
            if (this.getLoggingLevel() != null) {
                data.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
            }
            if (this.getLogRetention() != null) {
                data.set("logRetention", om.valueToTree(this.getLogRetention()));
            }
            if (this.getLogRetentionRetryOptions() != null) {
                data.set("logRetentionRetryOptions", om.valueToTree(this.getLogRetentionRetryOptions()));
            }
            if (this.getLogRetentionRole() != null) {
                data.set("logRetentionRole", om.valueToTree(this.getLogRetentionRole()));
            }
            if (this.getNotificationTopics() != null) {
                data.set("notificationTopics", om.valueToTree(this.getNotificationTopics()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getUserRoleRequired() != null) {
                data.set("userRoleRequired", om.valueToTree(this.getUserRoleRequired()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_chatbot.SlackChannelConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SlackChannelConfigurationProps.Jsii$Proxy that = (SlackChannelConfigurationProps.Jsii$Proxy) o;

            if (!slackChannelConfigurationName.equals(that.slackChannelConfigurationName)) return false;
            if (!slackChannelId.equals(that.slackChannelId)) return false;
            if (!slackWorkspaceId.equals(that.slackWorkspaceId)) return false;
            if (this.guardrailPolicies != null ? !this.guardrailPolicies.equals(that.guardrailPolicies) : that.guardrailPolicies != null) return false;
            if (this.loggingLevel != null ? !this.loggingLevel.equals(that.loggingLevel) : that.loggingLevel != null) return false;
            if (this.logRetention != null ? !this.logRetention.equals(that.logRetention) : that.logRetention != null) return false;
            if (this.logRetentionRetryOptions != null ? !this.logRetentionRetryOptions.equals(that.logRetentionRetryOptions) : that.logRetentionRetryOptions != null) return false;
            if (this.logRetentionRole != null ? !this.logRetentionRole.equals(that.logRetentionRole) : that.logRetentionRole != null) return false;
            if (this.notificationTopics != null ? !this.notificationTopics.equals(that.notificationTopics) : that.notificationTopics != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            return this.userRoleRequired != null ? this.userRoleRequired.equals(that.userRoleRequired) : that.userRoleRequired == null;
        }

        @Override
        public final int hashCode() {
            int result = this.slackChannelConfigurationName.hashCode();
            result = 31 * result + (this.slackChannelId.hashCode());
            result = 31 * result + (this.slackWorkspaceId.hashCode());
            result = 31 * result + (this.guardrailPolicies != null ? this.guardrailPolicies.hashCode() : 0);
            result = 31 * result + (this.loggingLevel != null ? this.loggingLevel.hashCode() : 0);
            result = 31 * result + (this.logRetention != null ? this.logRetention.hashCode() : 0);
            result = 31 * result + (this.logRetentionRetryOptions != null ? this.logRetentionRetryOptions.hashCode() : 0);
            result = 31 * result + (this.logRetentionRole != null ? this.logRetentionRole.hashCode() : 0);
            result = 31 * result + (this.notificationTopics != null ? this.notificationTopics.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.userRoleRequired != null ? this.userRoleRequired.hashCode() : 0);
            return result;
        }
    }
}
