package software.amazon.awscdk.services.cleanrooms;

/**
 * Properties for defining a <code>CfnPrivacyBudgetTemplate</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cleanrooms.*;
 * CfnPrivacyBudgetTemplateProps cfnPrivacyBudgetTemplateProps = CfnPrivacyBudgetTemplateProps.builder()
 *         .autoRefresh("autoRefresh")
 *         .membershipIdentifier("membershipIdentifier")
 *         .parameters(ParametersProperty.builder()
 *                 .epsilon(123)
 *                 .usersNoisePerQuery(123)
 *                 .build())
 *         .privacyBudgetType("privacyBudgetType")
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-privacybudgettemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-privacybudgettemplate.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:32.246Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnPrivacyBudgetTemplateProps")
@software.amazon.jsii.Jsii.Proxy(CfnPrivacyBudgetTemplateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPrivacyBudgetTemplateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * How often the privacy budget refreshes.
     * <p>
     * <blockquote>
     * <p>
     * If you plan to regularly bring new data into the collaboration, use <code>CALENDAR_MONTH</code> to automatically get a new privacy budget for the collaboration every calendar month. Choosing this option allows arbitrary amounts of information to be revealed about rows of the data when repeatedly queried across refreshes. Avoid choosing this if the same rows will be repeatedly queried between privacy budget refreshes.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-privacybudgettemplate.html#cfn-cleanrooms-privacybudgettemplate-autorefresh">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-privacybudgettemplate.html#cfn-cleanrooms-privacybudgettemplate-autorefresh</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAutoRefresh();

    /**
     * The identifier for a membership resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-privacybudgettemplate.html#cfn-cleanrooms-privacybudgettemplate-membershipidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-privacybudgettemplate.html#cfn-cleanrooms-privacybudgettemplate-membershipidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMembershipIdentifier();

    /**
     * Specifies the epsilon and noise parameters for the privacy budget template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-privacybudgettemplate.html#cfn-cleanrooms-privacybudgettemplate-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-privacybudgettemplate.html#cfn-cleanrooms-privacybudgettemplate-parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getParameters();

    /**
     * Specifies the type of the privacy budget template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-privacybudgettemplate.html#cfn-cleanrooms-privacybudgettemplate-privacybudgettype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-privacybudgettemplate.html#cfn-cleanrooms-privacybudgettemplate-privacybudgettype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrivacyBudgetType();

    /**
     * An optional label that you can assign to a resource when you create it.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-privacybudgettemplate.html#cfn-cleanrooms-privacybudgettemplate-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-privacybudgettemplate.html#cfn-cleanrooms-privacybudgettemplate-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPrivacyBudgetTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPrivacyBudgetTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPrivacyBudgetTemplateProps> {
        java.lang.String autoRefresh;
        java.lang.String membershipIdentifier;
        java.lang.Object parameters;
        java.lang.String privacyBudgetType;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnPrivacyBudgetTemplateProps#getAutoRefresh}
         * @param autoRefresh How often the privacy budget refreshes. This parameter is required.
         *                    <blockquote>
         *                    <p>
         *                    If you plan to regularly bring new data into the collaboration, use <code>CALENDAR_MONTH</code> to automatically get a new privacy budget for the collaboration every calendar month. Choosing this option allows arbitrary amounts of information to be revealed about rows of the data when repeatedly queried across refreshes. Avoid choosing this if the same rows will be repeatedly queried between privacy budget refreshes.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoRefresh(java.lang.String autoRefresh) {
            this.autoRefresh = autoRefresh;
            return this;
        }

        /**
         * Sets the value of {@link CfnPrivacyBudgetTemplateProps#getMembershipIdentifier}
         * @param membershipIdentifier The identifier for a membership resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder membershipIdentifier(java.lang.String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnPrivacyBudgetTemplateProps#getParameters}
         * @param parameters Specifies the epsilon and noise parameters for the privacy budget template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnPrivacyBudgetTemplateProps#getParameters}
         * @param parameters Specifies the epsilon and noise parameters for the privacy budget template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(software.amazon.awscdk.services.cleanrooms.CfnPrivacyBudgetTemplate.ParametersProperty parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnPrivacyBudgetTemplateProps#getPrivacyBudgetType}
         * @param privacyBudgetType Specifies the type of the privacy budget template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privacyBudgetType(java.lang.String privacyBudgetType) {
            this.privacyBudgetType = privacyBudgetType;
            return this;
        }

        /**
         * Sets the value of {@link CfnPrivacyBudgetTemplateProps#getTags}
         * @param tags An optional label that you can assign to a resource when you create it.
         *             Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPrivacyBudgetTemplateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPrivacyBudgetTemplateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPrivacyBudgetTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPrivacyBudgetTemplateProps {
        private final java.lang.String autoRefresh;
        private final java.lang.String membershipIdentifier;
        private final java.lang.Object parameters;
        private final java.lang.String privacyBudgetType;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoRefresh = software.amazon.jsii.Kernel.get(this, "autoRefresh", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.membershipIdentifier = software.amazon.jsii.Kernel.get(this, "membershipIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.privacyBudgetType = software.amazon.jsii.Kernel.get(this, "privacyBudgetType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoRefresh = java.util.Objects.requireNonNull(builder.autoRefresh, "autoRefresh is required");
            this.membershipIdentifier = java.util.Objects.requireNonNull(builder.membershipIdentifier, "membershipIdentifier is required");
            this.parameters = java.util.Objects.requireNonNull(builder.parameters, "parameters is required");
            this.privacyBudgetType = java.util.Objects.requireNonNull(builder.privacyBudgetType, "privacyBudgetType is required");
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAutoRefresh() {
            return this.autoRefresh;
        }

        @Override
        public final java.lang.String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.String getPrivacyBudgetType() {
            return this.privacyBudgetType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autoRefresh", om.valueToTree(this.getAutoRefresh()));
            data.set("membershipIdentifier", om.valueToTree(this.getMembershipIdentifier()));
            data.set("parameters", om.valueToTree(this.getParameters()));
            data.set("privacyBudgetType", om.valueToTree(this.getPrivacyBudgetType()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnPrivacyBudgetTemplateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPrivacyBudgetTemplateProps.Jsii$Proxy that = (CfnPrivacyBudgetTemplateProps.Jsii$Proxy) o;

            if (!autoRefresh.equals(that.autoRefresh)) return false;
            if (!membershipIdentifier.equals(that.membershipIdentifier)) return false;
            if (!parameters.equals(that.parameters)) return false;
            if (!privacyBudgetType.equals(that.privacyBudgetType)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoRefresh.hashCode();
            result = 31 * result + (this.membershipIdentifier.hashCode());
            result = 31 * result + (this.parameters.hashCode());
            result = 31 * result + (this.privacyBudgetType.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
