package software.amazon.awscdk.services.cloudfront;

/**
 * The distribution tenant.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create the simple Origin
 * Bucket myBucket = new Bucket(this, "myBucket");
 * IOrigin s3Origin = S3BucketOrigin.withOriginAccessControl(myBucket, S3BucketOriginWithOACProps.builder()
 *         .originAccessLevels(List.of(AccessLevel.READ, AccessLevel.LIST))
 *         .build());
 * // Create the Distribution construct
 * Distribution myMultiTenantDistribution = Distribution.Builder.create(this, "cf-hosted-distribution")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(s3Origin)
 *                 .build())
 *         .defaultRootObject("index.html")
 *         .build();
 * // Access the underlying L1 CfnDistribution to configure SaaS Manager properties which are not yet available in the L2 Distribution construct
 * CfnDistribution cfnDistribution = (CfnDistribution)myMultiTenantDistribution.getNode().getDefaultChild();
 * DefaultCacheBehaviorProperty defaultCacheBehavior = DefaultCacheBehaviorProperty.builder()
 *         .targetOriginId(myBucket.getBucketArn())
 *         .viewerProtocolPolicy("allow-all")
 *         .compress(false)
 *         .allowedMethods(List.of("GET", "HEAD"))
 *         .cachePolicyId(CachePolicy.CACHING_OPTIMIZED.getCachePolicyId())
 *         .build();
 * // Create the updated distributionConfig
 * DistributionConfigProperty distributionConfig = DistributionConfigProperty.builder()
 *         .defaultCacheBehavior(defaultCacheBehavior)
 *         .enabled(true)
 *         // the properties below are optional
 *         .connectionMode("tenant-only")
 *         .origins(List.of(OriginProperty.builder()
 *                 .id(myBucket.getBucketArn())
 *                 .domainName(myBucket.getBucketDomainName())
 *                 .s3OriginConfig(S3OriginConfigProperty.builder().build())
 *                 .originPath("/{{tenantName}}")
 *                 .build()))
 *         .tenantConfig(TenantConfigProperty.builder()
 *                 .parameterDefinitions(List.of(ParameterDefinitionProperty.builder()
 *                         .definition(DefinitionProperty.builder()
 *                                 .stringSchema(StringSchemaProperty.builder()
 *                                         .required(false)
 *                                         // the properties below are optional
 *                                         .comment("tenantName")
 *                                         .defaultValue("root")
 *                                         .build())
 *                                 .build())
 *                         .name("tenantName")
 *                         .build()))
 *                 .build())
 *         .build();
 * // Override the distribution configuration to enable multi-tenancy.
 * cfnDistribution.getDistributionConfig() = distributionConfig;
 * // Create a connection group so we have access to the RoutingEndpoint associated with the tenant we are about to create
 * CfnConnectionGroup connectionGroup = CfnConnectionGroup.Builder.create(this, "self-hosted-connection-group")
 *         .enabled(true)
 *         .ipv6Enabled(true)
 *         .name("self-hosted-connection-group")
 *         .build();
 * // Export the RoutingEndpoint, skip this step if you'd prefer to fetch it from the CloudFront console or via Cloudfront.ListConnectionGroups API
 * // Export the RoutingEndpoint, skip this step if you'd prefer to fetch it from the CloudFront console or via Cloudfront.ListConnectionGroups API
 * CfnOutput.Builder.create(this, "RoutingEndpoint")
 *         .value(connectionGroup.getAttrRoutingEndpoint())
 *         .description("CloudFront Routing Endpoint to be added to my hosted zone CNAME records")
 *         .build();
 * // Create a distribution tenant with a self-hosted domain.
 * CfnDistributionTenant selfHostedTenant = CfnDistributionTenant.Builder.create(this, "self-hosted-tenant")
 *         .distributionId(myMultiTenantDistribution.getDistributionId())
 *         .connectionGroupId(connectionGroup.getAttrId())
 *         .name("self-hosted-tenant")
 *         .domains(List.of("self-hosted-tenant.my.domain.com"))
 *         .enabled(true)
 *         .managedCertificateRequest(ManagedCertificateRequestProperty.builder()
 *                 .primaryDomainName("self-hosted-tenant.my.domain.com")
 *                 .validationTokenHost("self-hosted")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:32.427Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistributionTenant")
public class CfnDistributionTenant extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnDistributionTenant(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDistributionTenant(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.CfnDistributionTenant.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDistributionTenant(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnDistributionTenantProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the distribution tenant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time when the distribution tenant was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrDomainResults() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainResults", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The current version of the distribution tenant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrETag() {
        return software.amazon.jsii.Kernel.get(this, "attrETag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the distribution tenant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time when the distribution tenant was updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModifiedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the distribution tenant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ID of the multi-tenant distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDistributionId() {
        return software.amazon.jsii.Kernel.get(this, "distributionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the multi-tenant distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDistributionId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "distributionId", java.util.Objects.requireNonNull(value, "distributionId is required"));
    }

    /**
     * The domains associated with the distribution tenant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getDomains() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "domains", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The domains associated with the distribution tenant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomains(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "domains", java.util.Objects.requireNonNull(value, "domains is required"));
    }

    /**
     * The name of the distribution tenant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the distribution tenant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The ID of the connection group for the distribution tenant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConnectionGroupId() {
        return software.amazon.jsii.Kernel.get(this, "connectionGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the connection group for the distribution tenant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionGroupId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectionGroupId", value);
    }

    /**
     * Customizations for the distribution tenant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomizations() {
        return software.amazon.jsii.Kernel.get(this, "customizations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Customizations for the distribution tenant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomizations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customizations", value);
    }

    /**
     * Customizations for the distribution tenant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomizations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CfnDistributionTenant.CustomizationsProperty value) {
        software.amazon.jsii.Kernel.set(this, "customizations", value);
    }

    /**
     * Indicates whether the distribution tenant is in an enabled state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether the distribution tenant is in an enabled state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enabled", value);
    }

    /**
     * Indicates whether the distribution tenant is in an enabled state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enabled", value);
    }

    /**
     * An object that represents the request for the Amazon CloudFront managed ACM certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getManagedCertificateRequest() {
        return software.amazon.jsii.Kernel.get(this, "managedCertificateRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that represents the request for the Amazon CloudFront managed ACM certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManagedCertificateRequest(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "managedCertificateRequest", value);
    }

    /**
     * An object that represents the request for the Amazon CloudFront managed ACM certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManagedCertificateRequest(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CfnDistributionTenant.ManagedCertificateRequestProperty value) {
        software.amazon.jsii.Kernel.set(this, "managedCertificateRequest", value);
    }

    /**
     * A list of parameter values to add to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of parameter values to add to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * A list of parameter values to add to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cloudfront.CfnDistributionTenant.ParameterProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cloudfront.CfnDistributionTenant.ParameterProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "parameters", value);
    }

    /**
     * A complex type that contains zero or more <code>Tag</code> elements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A complex type that contains zero or more <code>Tag</code> elements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The AWS Certificate Manager (ACM) certificate associated with your distribution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * CertificateProperty certificateProperty = CertificateProperty.builder()
     *         .arn("arn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-certificate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-certificate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistributionTenant.CertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(CertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the ACM certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-certificate.html#cfn-cloudfront-distributiontenant-certificate-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-certificate.html#cfn-cloudfront-distributiontenant-certificate-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CertificateProperty> {
            java.lang.String arn;

            /**
             * Sets the value of {@link CertificateProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the ACM certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CertificateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CertificateProperty {
            private final java.lang.String arn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistributionTenant.CertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CertificateProperty.Jsii$Proxy that = (CertificateProperty.Jsii$Proxy) o;

                return this.arn != null ? this.arn.equals(that.arn) : that.arn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Customizations for the distribution tenant.
     * <p>
     * For each distribution tenant, you can specify the geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and AWS WAF web ACL. These are specific values that you can override or disable from the multi-tenant distribution that was used to create the distribution tenant.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * CustomizationsProperty customizationsProperty = CustomizationsProperty.builder()
     *         .certificate(CertificateProperty.builder()
     *                 .arn("arn")
     *                 .build())
     *         .geoRestrictions(GeoRestrictionCustomizationProperty.builder()
     *                 .locations(List.of("locations"))
     *                 .restrictionType("restrictionType")
     *                 .build())
     *         .webAcl(WebAclCustomizationProperty.builder()
     *                 .action("action")
     *                 .arn("arn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-customizations.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-customizations.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistributionTenant.CustomizationsProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomizationsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomizationsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Certificate Manager (ACM) certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-customizations.html#cfn-cloudfront-distributiontenant-customizations-certificate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-customizations.html#cfn-cloudfront-distributiontenant-customizations-certificate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCertificate() {
            return null;
        }

        /**
         * The geographic restrictions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-customizations.html#cfn-cloudfront-distributiontenant-customizations-georestrictions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-customizations.html#cfn-cloudfront-distributiontenant-customizations-georestrictions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGeoRestrictions() {
            return null;
        }

        /**
         * The AWS WAF web ACL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-customizations.html#cfn-cloudfront-distributiontenant-customizations-webacl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-customizations.html#cfn-cloudfront-distributiontenant-customizations-webacl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWebAcl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomizationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomizationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomizationsProperty> {
            java.lang.Object certificate;
            java.lang.Object geoRestrictions;
            java.lang.Object webAcl;

            /**
             * Sets the value of {@link CustomizationsProperty#getCertificate}
             * @param certificate The AWS Certificate Manager (ACM) certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificate(software.amazon.awscdk.IResolvable certificate) {
                this.certificate = certificate;
                return this;
            }

            /**
             * Sets the value of {@link CustomizationsProperty#getCertificate}
             * @param certificate The AWS Certificate Manager (ACM) certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificate(software.amazon.awscdk.services.cloudfront.CfnDistributionTenant.CertificateProperty certificate) {
                this.certificate = certificate;
                return this;
            }

            /**
             * Sets the value of {@link CustomizationsProperty#getGeoRestrictions}
             * @param geoRestrictions The geographic restrictions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoRestrictions(software.amazon.awscdk.IResolvable geoRestrictions) {
                this.geoRestrictions = geoRestrictions;
                return this;
            }

            /**
             * Sets the value of {@link CustomizationsProperty#getGeoRestrictions}
             * @param geoRestrictions The geographic restrictions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoRestrictions(software.amazon.awscdk.services.cloudfront.CfnDistributionTenant.GeoRestrictionCustomizationProperty geoRestrictions) {
                this.geoRestrictions = geoRestrictions;
                return this;
            }

            /**
             * Sets the value of {@link CustomizationsProperty#getWebAcl}
             * @param webAcl The AWS WAF web ACL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webAcl(software.amazon.awscdk.IResolvable webAcl) {
                this.webAcl = webAcl;
                return this;
            }

            /**
             * Sets the value of {@link CustomizationsProperty#getWebAcl}
             * @param webAcl The AWS WAF web ACL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webAcl(software.amazon.awscdk.services.cloudfront.CfnDistributionTenant.WebAclCustomizationProperty webAcl) {
                this.webAcl = webAcl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomizationsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomizationsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomizationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomizationsProperty {
            private final java.lang.Object certificate;
            private final java.lang.Object geoRestrictions;
            private final java.lang.Object webAcl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.geoRestrictions = software.amazon.jsii.Kernel.get(this, "geoRestrictions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.webAcl = software.amazon.jsii.Kernel.get(this, "webAcl", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificate = builder.certificate;
                this.geoRestrictions = builder.geoRestrictions;
                this.webAcl = builder.webAcl;
            }

            @Override
            public final java.lang.Object getCertificate() {
                return this.certificate;
            }

            @Override
            public final java.lang.Object getGeoRestrictions() {
                return this.geoRestrictions;
            }

            @Override
            public final java.lang.Object getWebAcl() {
                return this.webAcl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCertificate() != null) {
                    data.set("certificate", om.valueToTree(this.getCertificate()));
                }
                if (this.getGeoRestrictions() != null) {
                    data.set("geoRestrictions", om.valueToTree(this.getGeoRestrictions()));
                }
                if (this.getWebAcl() != null) {
                    data.set("webAcl", om.valueToTree(this.getWebAcl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistributionTenant.CustomizationsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomizationsProperty.Jsii$Proxy that = (CustomizationsProperty.Jsii$Proxy) o;

                if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) return false;
                if (this.geoRestrictions != null ? !this.geoRestrictions.equals(that.geoRestrictions) : that.geoRestrictions != null) return false;
                return this.webAcl != null ? this.webAcl.equals(that.webAcl) : that.webAcl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificate != null ? this.certificate.hashCode() : 0;
                result = 31 * result + (this.geoRestrictions != null ? this.geoRestrictions.hashCode() : 0);
                result = 31 * result + (this.webAcl != null ? this.webAcl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The details about the domain result.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * DomainResultProperty domainResultProperty = DomainResultProperty.builder()
     *         .domain("domain")
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-domainresult.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-domainresult.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistributionTenant.DomainResultProperty")
    @software.amazon.jsii.Jsii.Proxy(DomainResultProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DomainResultProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The specified domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-domainresult.html#cfn-cloudfront-distributiontenant-domainresult-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-domainresult.html#cfn-cloudfront-distributiontenant-domainresult-domain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
            return null;
        }

        /**
         * Whether the domain is active or inactive.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-domainresult.html#cfn-cloudfront-distributiontenant-domainresult-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-domainresult.html#cfn-cloudfront-distributiontenant-domainresult-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DomainResultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DomainResultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DomainResultProperty> {
            java.lang.String domain;
            java.lang.String status;

            /**
             * Sets the value of {@link DomainResultProperty#getDomain}
             * @param domain The specified domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domain(java.lang.String domain) {
                this.domain = domain;
                return this;
            }

            /**
             * Sets the value of {@link DomainResultProperty#getStatus}
             * @param status Whether the domain is active or inactive.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DomainResultProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DomainResultProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DomainResultProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainResultProperty {
            private final java.lang.String domain;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domain = builder.domain;
                this.status = builder.status;
            }

            @Override
            public final java.lang.String getDomain() {
                return this.domain;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDomain() != null) {
                    data.set("domain", om.valueToTree(this.getDomain()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistributionTenant.DomainResultProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DomainResultProperty.Jsii$Proxy that = (DomainResultProperty.Jsii$Proxy) o;

                if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.domain != null ? this.domain.hashCode() : 0;
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The customizations that you specified for the distribution tenant for geographic restrictions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * GeoRestrictionCustomizationProperty geoRestrictionCustomizationProperty = GeoRestrictionCustomizationProperty.builder()
     *         .locations(List.of("locations"))
     *         .restrictionType("restrictionType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-georestrictioncustomization.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-georestrictioncustomization.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistributionTenant.GeoRestrictionCustomizationProperty")
    @software.amazon.jsii.Jsii.Proxy(GeoRestrictionCustomizationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeoRestrictionCustomizationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The locations for geographic restrictions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-georestrictioncustomization.html#cfn-cloudfront-distributiontenant-georestrictioncustomization-locations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-georestrictioncustomization.html#cfn-cloudfront-distributiontenant-georestrictioncustomization-locations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLocations() {
            return null;
        }

        /**
         * The method that you want to use to restrict distribution of your content by country:.
         * <p>
         * <ul>
         * <li><code>none</code> : No geographic restriction is enabled, meaning access to content is not restricted by client geo location.</li>
         * <li><code>blacklist</code> : The <code>Location</code> elements specify the countries in which you don't want CloudFront to distribute your content.</li>
         * <li><code>whitelist</code> : The <code>Location</code> elements specify the countries in which you want CloudFront to distribute your content.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-georestrictioncustomization.html#cfn-cloudfront-distributiontenant-georestrictioncustomization-restrictiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-georestrictioncustomization.html#cfn-cloudfront-distributiontenant-georestrictioncustomization-restrictiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRestrictionType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeoRestrictionCustomizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeoRestrictionCustomizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeoRestrictionCustomizationProperty> {
            java.util.List<java.lang.String> locations;
            java.lang.String restrictionType;

            /**
             * Sets the value of {@link GeoRestrictionCustomizationProperty#getLocations}
             * @param locations The locations for geographic restrictions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder locations(java.util.List<java.lang.String> locations) {
                this.locations = locations;
                return this;
            }

            /**
             * Sets the value of {@link GeoRestrictionCustomizationProperty#getRestrictionType}
             * @param restrictionType The method that you want to use to restrict distribution of your content by country:.
             *                        <ul>
             *                        <li><code>none</code> : No geographic restriction is enabled, meaning access to content is not restricted by client geo location.</li>
             *                        <li><code>blacklist</code> : The <code>Location</code> elements specify the countries in which you don't want CloudFront to distribute your content.</li>
             *                        <li><code>whitelist</code> : The <code>Location</code> elements specify the countries in which you want CloudFront to distribute your content.</li>
             *                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictionType(java.lang.String restrictionType) {
                this.restrictionType = restrictionType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeoRestrictionCustomizationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeoRestrictionCustomizationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GeoRestrictionCustomizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeoRestrictionCustomizationProperty {
            private final java.util.List<java.lang.String> locations;
            private final java.lang.String restrictionType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.locations = software.amazon.jsii.Kernel.get(this, "locations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.restrictionType = software.amazon.jsii.Kernel.get(this, "restrictionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.locations = builder.locations;
                this.restrictionType = builder.restrictionType;
            }

            @Override
            public final java.util.List<java.lang.String> getLocations() {
                return this.locations;
            }

            @Override
            public final java.lang.String getRestrictionType() {
                return this.restrictionType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLocations() != null) {
                    data.set("locations", om.valueToTree(this.getLocations()));
                }
                if (this.getRestrictionType() != null) {
                    data.set("restrictionType", om.valueToTree(this.getRestrictionType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistributionTenant.GeoRestrictionCustomizationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeoRestrictionCustomizationProperty.Jsii$Proxy that = (GeoRestrictionCustomizationProperty.Jsii$Proxy) o;

                if (this.locations != null ? !this.locations.equals(that.locations) : that.locations != null) return false;
                return this.restrictionType != null ? this.restrictionType.equals(that.restrictionType) : that.restrictionType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.locations != null ? this.locations.hashCode() : 0;
                result = 31 * result + (this.restrictionType != null ? this.restrictionType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the request for the Amazon CloudFront managed ACM certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * ManagedCertificateRequestProperty managedCertificateRequestProperty = ManagedCertificateRequestProperty.builder()
     *         .certificateTransparencyLoggingPreference("certificateTransparencyLoggingPreference")
     *         .primaryDomainName("primaryDomainName")
     *         .validationTokenHost("validationTokenHost")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-managedcertificaterequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-managedcertificaterequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistributionTenant.ManagedCertificateRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedCertificateRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedCertificateRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * You can opt out of certificate transparency logging by specifying the <code>disabled</code> option.
         * <p>
         * Opt in by specifying <code>enabled</code> . For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency">Certificate Transparency Logging</a> in the <em>AWS Certificate Manager User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-managedcertificaterequest.html#cfn-cloudfront-distributiontenant-managedcertificaterequest-certificatetransparencyloggingpreference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-managedcertificaterequest.html#cfn-cloudfront-distributiontenant-managedcertificaterequest-certificatetransparencyloggingpreference</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateTransparencyLoggingPreference() {
            return null;
        }

        /**
         * The primary domain name associated with the CloudFront managed ACM certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-managedcertificaterequest.html#cfn-cloudfront-distributiontenant-managedcertificaterequest-primarydomainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-managedcertificaterequest.html#cfn-cloudfront-distributiontenant-managedcertificaterequest-primarydomainname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrimaryDomainName() {
            return null;
        }

        /**
         * Specify how the HTTP validation token will be served when requesting the CloudFront managed ACM certificate.
         * <p>
         * <ul>
         * <li>For <code>cloudfront</code> , CloudFront will automatically serve the validation token. Choose this mode if you can point the domain's DNS to CloudFront immediately.</li>
         * <li>For <code>self-hosted</code> , you serve the validation token from your existing infrastructure. Choose this mode when you need to maintain current traffic flow while your certificate is being issued. You can place the validation token at the well-known path on your existing web server, wait for ACM to validate and issue the certificate, and then update your DNS to point to CloudFront.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-managedcertificaterequest.html#cfn-cloudfront-distributiontenant-managedcertificaterequest-validationtokenhost">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-managedcertificaterequest.html#cfn-cloudfront-distributiontenant-managedcertificaterequest-validationtokenhost</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValidationTokenHost() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedCertificateRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedCertificateRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedCertificateRequestProperty> {
            java.lang.String certificateTransparencyLoggingPreference;
            java.lang.String primaryDomainName;
            java.lang.String validationTokenHost;

            /**
             * Sets the value of {@link ManagedCertificateRequestProperty#getCertificateTransparencyLoggingPreference}
             * @param certificateTransparencyLoggingPreference You can opt out of certificate transparency logging by specifying the <code>disabled</code> option.
             *                                                 Opt in by specifying <code>enabled</code> . For more information, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency">Certificate Transparency Logging</a> in the <em>AWS Certificate Manager User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateTransparencyLoggingPreference(java.lang.String certificateTransparencyLoggingPreference) {
                this.certificateTransparencyLoggingPreference = certificateTransparencyLoggingPreference;
                return this;
            }

            /**
             * Sets the value of {@link ManagedCertificateRequestProperty#getPrimaryDomainName}
             * @param primaryDomainName The primary domain name associated with the CloudFront managed ACM certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryDomainName(java.lang.String primaryDomainName) {
                this.primaryDomainName = primaryDomainName;
                return this;
            }

            /**
             * Sets the value of {@link ManagedCertificateRequestProperty#getValidationTokenHost}
             * @param validationTokenHost Specify how the HTTP validation token will be served when requesting the CloudFront managed ACM certificate.
             *                            <ul>
             *                            <li>For <code>cloudfront</code> , CloudFront will automatically serve the validation token. Choose this mode if you can point the domain's DNS to CloudFront immediately.</li>
             *                            <li>For <code>self-hosted</code> , you serve the validation token from your existing infrastructure. Choose this mode when you need to maintain current traffic flow while your certificate is being issued. You can place the validation token at the well-known path on your existing web server, wait for ACM to validate and issue the certificate, and then update your DNS to point to CloudFront.</li>
             *                            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validationTokenHost(java.lang.String validationTokenHost) {
                this.validationTokenHost = validationTokenHost;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedCertificateRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedCertificateRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedCertificateRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedCertificateRequestProperty {
            private final java.lang.String certificateTransparencyLoggingPreference;
            private final java.lang.String primaryDomainName;
            private final java.lang.String validationTokenHost;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateTransparencyLoggingPreference = software.amazon.jsii.Kernel.get(this, "certificateTransparencyLoggingPreference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.primaryDomainName = software.amazon.jsii.Kernel.get(this, "primaryDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.validationTokenHost = software.amazon.jsii.Kernel.get(this, "validationTokenHost", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateTransparencyLoggingPreference = builder.certificateTransparencyLoggingPreference;
                this.primaryDomainName = builder.primaryDomainName;
                this.validationTokenHost = builder.validationTokenHost;
            }

            @Override
            public final java.lang.String getCertificateTransparencyLoggingPreference() {
                return this.certificateTransparencyLoggingPreference;
            }

            @Override
            public final java.lang.String getPrimaryDomainName() {
                return this.primaryDomainName;
            }

            @Override
            public final java.lang.String getValidationTokenHost() {
                return this.validationTokenHost;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCertificateTransparencyLoggingPreference() != null) {
                    data.set("certificateTransparencyLoggingPreference", om.valueToTree(this.getCertificateTransparencyLoggingPreference()));
                }
                if (this.getPrimaryDomainName() != null) {
                    data.set("primaryDomainName", om.valueToTree(this.getPrimaryDomainName()));
                }
                if (this.getValidationTokenHost() != null) {
                    data.set("validationTokenHost", om.valueToTree(this.getValidationTokenHost()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistributionTenant.ManagedCertificateRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedCertificateRequestProperty.Jsii$Proxy that = (ManagedCertificateRequestProperty.Jsii$Proxy) o;

                if (this.certificateTransparencyLoggingPreference != null ? !this.certificateTransparencyLoggingPreference.equals(that.certificateTransparencyLoggingPreference) : that.certificateTransparencyLoggingPreference != null) return false;
                if (this.primaryDomainName != null ? !this.primaryDomainName.equals(that.primaryDomainName) : that.primaryDomainName != null) return false;
                return this.validationTokenHost != null ? this.validationTokenHost.equals(that.validationTokenHost) : that.validationTokenHost == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificateTransparencyLoggingPreference != null ? this.certificateTransparencyLoggingPreference.hashCode() : 0;
                result = 31 * result + (this.primaryDomainName != null ? this.primaryDomainName.hashCode() : 0);
                result = 31 * result + (this.validationTokenHost != null ? this.validationTokenHost.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A list of parameter values to add to the resource.
     * <p>
     * A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * ParameterProperty parameterProperty = ParameterProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-parameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-parameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistributionTenant.ParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(ParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parameter name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-parameter.html#cfn-cloudfront-distributiontenant-parameter-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-parameter.html#cfn-cloudfront-distributiontenant-parameter-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The parameter value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-parameter.html#cfn-cloudfront-distributiontenant-parameter-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-parameter.html#cfn-cloudfront-distributiontenant-parameter-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParameterProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link ParameterProperty#getName}
             * @param name The parameter name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ParameterProperty#getValue}
             * @param value The parameter value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParameterProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistributionTenant.ParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParameterProperty.Jsii$Proxy that = (ParameterProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The AWS WAF web ACL customization specified for the distribution tenant.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * WebAclCustomizationProperty webAclCustomizationProperty = WebAclCustomizationProperty.builder()
     *         .action("action")
     *         .arn("arn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-webaclcustomization.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-webaclcustomization.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistributionTenant.WebAclCustomizationProperty")
    @software.amazon.jsii.Jsii.Proxy(WebAclCustomizationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebAclCustomizationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action for the AWS WAF web ACL customization.
         * <p>
         * You can specify <code>override</code> to specify a separate AWS WAF web ACL for the distribution tenant. If you specify <code>disable</code> , the distribution tenant won't have AWS WAF web ACL protections and won't inherit from the multi-tenant distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-webaclcustomization.html#cfn-cloudfront-distributiontenant-webaclcustomization-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-webaclcustomization.html#cfn-cloudfront-distributiontenant-webaclcustomization-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the AWS WAF web ACL.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-webaclcustomization.html#cfn-cloudfront-distributiontenant-webaclcustomization-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distributiontenant-webaclcustomization.html#cfn-cloudfront-distributiontenant-webaclcustomization-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WebAclCustomizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebAclCustomizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebAclCustomizationProperty> {
            java.lang.String action;
            java.lang.String arn;

            /**
             * Sets the value of {@link WebAclCustomizationProperty#getAction}
             * @param action The action for the AWS WAF web ACL customization.
             *               You can specify <code>override</code> to specify a separate AWS WAF web ACL for the distribution tenant. If you specify <code>disable</code> , the distribution tenant won't have AWS WAF web ACL protections and won't inherit from the multi-tenant distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link WebAclCustomizationProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the AWS WAF web ACL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebAclCustomizationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebAclCustomizationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebAclCustomizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebAclCustomizationProperty {
            private final java.lang.String action;
            private final java.lang.String arn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = builder.action;
                this.arn = builder.arn;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAction() != null) {
                    data.set("action", om.valueToTree(this.getAction()));
                }
                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistributionTenant.WebAclCustomizationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebAclCustomizationProperty.Jsii$Proxy that = (WebAclCustomizationProperty.Jsii$Proxy) o;

                if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
                return this.arn != null ? this.arn.equals(that.arn) : that.arn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action != null ? this.action.hashCode() : 0;
                result = 31 * result + (this.arn != null ? this.arn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.CfnDistributionTenant}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.CfnDistributionTenant> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.CfnDistributionTenantProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.CfnDistributionTenantProps.Builder();
        }

        /**
         * The ID of the multi-tenant distribution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-distributionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-distributionid</a>
         * @param distributionId The ID of the multi-tenant distribution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionId(final java.lang.String distributionId) {
            this.props.distributionId(distributionId);
            return this;
        }

        /**
         * The domains associated with the distribution tenant.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-domains">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-domains</a>
         * @param domains The domains associated with the distribution tenant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domains(final java.util.List<java.lang.String> domains) {
            this.props.domains(domains);
            return this;
        }

        /**
         * The name of the distribution tenant.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-name</a>
         * @param name The name of the distribution tenant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The ID of the connection group for the distribution tenant.
         * <p>
         * If you don't specify a connection group, CloudFront uses the default connection group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-connectiongroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-connectiongroupid</a>
         * @param connectionGroupId The ID of the connection group for the distribution tenant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionGroupId(final java.lang.String connectionGroupId) {
            this.props.connectionGroupId(connectionGroupId);
            return this;
        }

        /**
         * Customizations for the distribution tenant.
         * <p>
         * For each distribution tenant, you can specify the geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and AWS WAF web ACL. These are specific values that you can override or disable from the multi-tenant distribution that was used to create the distribution tenant.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-customizations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-customizations</a>
         * @param customizations Customizations for the distribution tenant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customizations(final software.amazon.awscdk.IResolvable customizations) {
            this.props.customizations(customizations);
            return this;
        }
        /**
         * Customizations for the distribution tenant.
         * <p>
         * For each distribution tenant, you can specify the geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and AWS WAF web ACL. These are specific values that you can override or disable from the multi-tenant distribution that was used to create the distribution tenant.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-customizations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-customizations</a>
         * @param customizations Customizations for the distribution tenant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customizations(final software.amazon.awscdk.services.cloudfront.CfnDistributionTenant.CustomizationsProperty customizations) {
            this.props.customizations(customizations);
            return this;
        }

        /**
         * Indicates whether the distribution tenant is in an enabled state.
         * <p>
         * If disabled, the distribution tenant won't serve traffic.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-enabled</a>
         * @param enabled Indicates whether the distribution tenant is in an enabled state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }
        /**
         * Indicates whether the distribution tenant is in an enabled state.
         * <p>
         * If disabled, the distribution tenant won't serve traffic.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-enabled</a>
         * @param enabled Indicates whether the distribution tenant is in an enabled state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final software.amazon.awscdk.IResolvable enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * An object that represents the request for the Amazon CloudFront managed ACM certificate.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-managedcertificaterequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-managedcertificaterequest</a>
         * @param managedCertificateRequest An object that represents the request for the Amazon CloudFront managed ACM certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedCertificateRequest(final software.amazon.awscdk.IResolvable managedCertificateRequest) {
            this.props.managedCertificateRequest(managedCertificateRequest);
            return this;
        }
        /**
         * An object that represents the request for the Amazon CloudFront managed ACM certificate.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-managedcertificaterequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-managedcertificaterequest</a>
         * @param managedCertificateRequest An object that represents the request for the Amazon CloudFront managed ACM certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedCertificateRequest(final software.amazon.awscdk.services.cloudfront.CfnDistributionTenant.ManagedCertificateRequestProperty managedCertificateRequest) {
            this.props.managedCertificateRequest(managedCertificateRequest);
            return this;
        }

        /**
         * A list of parameter values to add to the resource.
         * <p>
         * A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-parameters</a>
         * @param parameters A list of parameter values to add to the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final software.amazon.awscdk.IResolvable parameters) {
            this.props.parameters(parameters);
            return this;
        }
        /**
         * A list of parameter values to add to the resource.
         * <p>
         * A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-parameters</a>
         * @param parameters A list of parameter values to add to the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.List<? extends java.lang.Object> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * A complex type that contains zero or more <code>Tag</code> elements.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-tags</a>
         * @param tags A complex type that contains zero or more <code>Tag</code> elements. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.CfnDistributionTenant}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.CfnDistributionTenant build() {
            return new software.amazon.awscdk.services.cloudfront.CfnDistributionTenant(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
