package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for defining a <code>CfnDistributionTenant</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create the simple Origin
 * Bucket myBucket = new Bucket(this, "myBucket");
 * IOrigin s3Origin = S3BucketOrigin.withOriginAccessControl(myBucket, S3BucketOriginWithOACProps.builder()
 *         .originAccessLevels(List.of(AccessLevel.READ, AccessLevel.LIST))
 *         .build());
 * // Create the Distribution construct
 * Distribution myMultiTenantDistribution = Distribution.Builder.create(this, "cf-hosted-distribution")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(s3Origin)
 *                 .build())
 *         .defaultRootObject("index.html")
 *         .build();
 * // Access the underlying L1 CfnDistribution to configure SaaS Manager properties which are not yet available in the L2 Distribution construct
 * CfnDistribution cfnDistribution = (CfnDistribution)myMultiTenantDistribution.getNode().getDefaultChild();
 * DefaultCacheBehaviorProperty defaultCacheBehavior = DefaultCacheBehaviorProperty.builder()
 *         .targetOriginId(myBucket.getBucketArn())
 *         .viewerProtocolPolicy("allow-all")
 *         .compress(false)
 *         .allowedMethods(List.of("GET", "HEAD"))
 *         .cachePolicyId(CachePolicy.CACHING_OPTIMIZED.getCachePolicyId())
 *         .build();
 * // Create the updated distributionConfig
 * DistributionConfigProperty distributionConfig = DistributionConfigProperty.builder()
 *         .defaultCacheBehavior(defaultCacheBehavior)
 *         .enabled(true)
 *         // the properties below are optional
 *         .connectionMode("tenant-only")
 *         .origins(List.of(OriginProperty.builder()
 *                 .id(myBucket.getBucketArn())
 *                 .domainName(myBucket.getBucketDomainName())
 *                 .s3OriginConfig(S3OriginConfigProperty.builder().build())
 *                 .originPath("/{{tenantName}}")
 *                 .build()))
 *         .tenantConfig(TenantConfigProperty.builder()
 *                 .parameterDefinitions(List.of(ParameterDefinitionProperty.builder()
 *                         .definition(DefinitionProperty.builder()
 *                                 .stringSchema(StringSchemaProperty.builder()
 *                                         .required(false)
 *                                         // the properties below are optional
 *                                         .comment("tenantName")
 *                                         .defaultValue("root")
 *                                         .build())
 *                                 .build())
 *                         .name("tenantName")
 *                         .build()))
 *                 .build())
 *         .build();
 * // Override the distribution configuration to enable multi-tenancy.
 * cfnDistribution.getDistributionConfig() = distributionConfig;
 * // Create a connection group so we have access to the RoutingEndpoint associated with the tenant we are about to create
 * CfnConnectionGroup connectionGroup = CfnConnectionGroup.Builder.create(this, "self-hosted-connection-group")
 *         .enabled(true)
 *         .ipv6Enabled(true)
 *         .name("self-hosted-connection-group")
 *         .build();
 * // Export the RoutingEndpoint, skip this step if you'd prefer to fetch it from the CloudFront console or via Cloudfront.ListConnectionGroups API
 * // Export the RoutingEndpoint, skip this step if you'd prefer to fetch it from the CloudFront console or via Cloudfront.ListConnectionGroups API
 * CfnOutput.Builder.create(this, "RoutingEndpoint")
 *         .value(connectionGroup.getAttrRoutingEndpoint())
 *         .description("CloudFront Routing Endpoint to be added to my hosted zone CNAME records")
 *         .build();
 * // Create a distribution tenant with a self-hosted domain.
 * CfnDistributionTenant selfHostedTenant = CfnDistributionTenant.Builder.create(this, "self-hosted-tenant")
 *         .distributionId(myMultiTenantDistribution.getDistributionId())
 *         .connectionGroupId(connectionGroup.getAttrId())
 *         .name("self-hosted-tenant")
 *         .domains(List.of("self-hosted-tenant.my.domain.com"))
 *         .enabled(true)
 *         .managedCertificateRequest(ManagedCertificateRequestProperty.builder()
 *                 .primaryDomainName("self-hosted-tenant.my.domain.com")
 *                 .validationTokenHost("self-hosted")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:32.431Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistributionTenantProps")
@software.amazon.jsii.Jsii.Proxy(CfnDistributionTenantProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDistributionTenantProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the multi-tenant distribution.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-distributionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-distributionid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDistributionId();

    /**
     * The domains associated with the distribution tenant.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-domains">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-domains</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getDomains();

    /**
     * The name of the distribution tenant.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The ID of the connection group for the distribution tenant.
     * <p>
     * If you don't specify a connection group, CloudFront uses the default connection group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-connectiongroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-connectiongroupid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectionGroupId() {
        return null;
    }

    /**
     * Customizations for the distribution tenant.
     * <p>
     * For each distribution tenant, you can specify the geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and AWS WAF web ACL. These are specific values that you can override or disable from the multi-tenant distribution that was used to create the distribution tenant.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-customizations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-customizations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomizations() {
        return null;
    }

    /**
     * Indicates whether the distribution tenant is in an enabled state.
     * <p>
     * If disabled, the distribution tenant won't serve traffic.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-enabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return null;
    }

    /**
     * An object that represents the request for the Amazon CloudFront managed ACM certificate.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-managedcertificaterequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-managedcertificaterequest</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getManagedCertificateRequest() {
        return null;
    }

    /**
     * A list of parameter values to add to the resource.
     * <p>
     * A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * A complex type that contains zero or more <code>Tag</code> elements.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distributiontenant.html#cfn-cloudfront-distributiontenant-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDistributionTenantProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDistributionTenantProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDistributionTenantProps> {
        java.lang.String distributionId;
        java.util.List<java.lang.String> domains;
        java.lang.String name;
        java.lang.String connectionGroupId;
        java.lang.Object customizations;
        java.lang.Object enabled;
        java.lang.Object managedCertificateRequest;
        java.lang.Object parameters;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDistributionTenantProps#getDistributionId}
         * @param distributionId The ID of the multi-tenant distribution. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionId(java.lang.String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionTenantProps#getDomains}
         * @param domains The domains associated with the distribution tenant. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domains(java.util.List<java.lang.String> domains) {
            this.domains = domains;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionTenantProps#getName}
         * @param name The name of the distribution tenant. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionTenantProps#getConnectionGroupId}
         * @param connectionGroupId The ID of the connection group for the distribution tenant.
         *                          If you don't specify a connection group, CloudFront uses the default connection group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionGroupId(java.lang.String connectionGroupId) {
            this.connectionGroupId = connectionGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionTenantProps#getCustomizations}
         * @param customizations Customizations for the distribution tenant.
         *                       For each distribution tenant, you can specify the geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and AWS WAF web ACL. These are specific values that you can override or disable from the multi-tenant distribution that was used to create the distribution tenant.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customizations(software.amazon.awscdk.IResolvable customizations) {
            this.customizations = customizations;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionTenantProps#getCustomizations}
         * @param customizations Customizations for the distribution tenant.
         *                       For each distribution tenant, you can specify the geographic restrictions, and the Amazon Resource Names (ARNs) for the ACM certificate and AWS WAF web ACL. These are specific values that you can override or disable from the multi-tenant distribution that was used to create the distribution tenant.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customizations(software.amazon.awscdk.services.cloudfront.CfnDistributionTenant.CustomizationsProperty customizations) {
            this.customizations = customizations;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionTenantProps#getEnabled}
         * @param enabled Indicates whether the distribution tenant is in an enabled state.
         *                If disabled, the distribution tenant won't serve traffic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionTenantProps#getEnabled}
         * @param enabled Indicates whether the distribution tenant is in an enabled state.
         *                If disabled, the distribution tenant won't serve traffic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionTenantProps#getManagedCertificateRequest}
         * @param managedCertificateRequest An object that represents the request for the Amazon CloudFront managed ACM certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedCertificateRequest(software.amazon.awscdk.IResolvable managedCertificateRequest) {
            this.managedCertificateRequest = managedCertificateRequest;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionTenantProps#getManagedCertificateRequest}
         * @param managedCertificateRequest An object that represents the request for the Amazon CloudFront managed ACM certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedCertificateRequest(software.amazon.awscdk.services.cloudfront.CfnDistributionTenant.ManagedCertificateRequestProperty managedCertificateRequest) {
            this.managedCertificateRequest = managedCertificateRequest;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionTenantProps#getParameters}
         * @param parameters A list of parameter values to add to the resource.
         *                   A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionTenantProps#getParameters}
         * @param parameters A list of parameter values to add to the resource.
         *                   A parameter is specified as a key-value pair. A valid parameter value must exist for any parameter that is marked as required in the multi-tenant distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.List<? extends java.lang.Object> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionTenantProps#getTags}
         * @param tags A complex type that contains zero or more <code>Tag</code> elements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDistributionTenantProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDistributionTenantProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDistributionTenantProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDistributionTenantProps {
        private final java.lang.String distributionId;
        private final java.util.List<java.lang.String> domains;
        private final java.lang.String name;
        private final java.lang.String connectionGroupId;
        private final java.lang.Object customizations;
        private final java.lang.Object enabled;
        private final java.lang.Object managedCertificateRequest;
        private final java.lang.Object parameters;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.distributionId = software.amazon.jsii.Kernel.get(this, "distributionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domains = software.amazon.jsii.Kernel.get(this, "domains", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionGroupId = software.amazon.jsii.Kernel.get(this, "connectionGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customizations = software.amazon.jsii.Kernel.get(this, "customizations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.managedCertificateRequest = software.amazon.jsii.Kernel.get(this, "managedCertificateRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.distributionId = java.util.Objects.requireNonNull(builder.distributionId, "distributionId is required");
            this.domains = java.util.Objects.requireNonNull(builder.domains, "domains is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.connectionGroupId = builder.connectionGroupId;
            this.customizations = builder.customizations;
            this.enabled = builder.enabled;
            this.managedCertificateRequest = builder.managedCertificateRequest;
            this.parameters = builder.parameters;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDistributionId() {
            return this.distributionId;
        }

        @Override
        public final java.util.List<java.lang.String> getDomains() {
            return this.domains;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getConnectionGroupId() {
            return this.connectionGroupId;
        }

        @Override
        public final java.lang.Object getCustomizations() {
            return this.customizations;
        }

        @Override
        public final java.lang.Object getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.Object getManagedCertificateRequest() {
            return this.managedCertificateRequest;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("distributionId", om.valueToTree(this.getDistributionId()));
            data.set("domains", om.valueToTree(this.getDomains()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getConnectionGroupId() != null) {
                data.set("connectionGroupId", om.valueToTree(this.getConnectionGroupId()));
            }
            if (this.getCustomizations() != null) {
                data.set("customizations", om.valueToTree(this.getCustomizations()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getManagedCertificateRequest() != null) {
                data.set("managedCertificateRequest", om.valueToTree(this.getManagedCertificateRequest()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistributionTenantProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDistributionTenantProps.Jsii$Proxy that = (CfnDistributionTenantProps.Jsii$Proxy) o;

            if (!distributionId.equals(that.distributionId)) return false;
            if (!domains.equals(that.domains)) return false;
            if (!name.equals(that.name)) return false;
            if (this.connectionGroupId != null ? !this.connectionGroupId.equals(that.connectionGroupId) : that.connectionGroupId != null) return false;
            if (this.customizations != null ? !this.customizations.equals(that.customizations) : that.customizations != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.managedCertificateRequest != null ? !this.managedCertificateRequest.equals(that.managedCertificateRequest) : that.managedCertificateRequest != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.distributionId.hashCode();
            result = 31 * result + (this.domains.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.connectionGroupId != null ? this.connectionGroupId.hashCode() : 0);
            result = 31 * result + (this.customizations != null ? this.customizations.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.managedCertificateRequest != null ? this.managedCertificateRequest.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
